# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/html_parts.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: shared html parts

=end
module SiSU_Parts_HTML
  require_relative 'generic_parts'                       # generic_parts.rb
  include SiSU_Parts_Generic
  def the_line_break
    '<br>'
  end
  def the_table_close
    '</td></tr>
</table>'
  end
  def the_table_cellpad_box
    '"20"'
  end
  def the_color
    def white
      '#ffffff'
    end
    def black
      '#000000'
    end
    def grey_pale
      '#eeeeee'
    end
    def grey_medium
      '#cccccc'
    end
    def grey
      '#999999'
    end
    def blue_ink
      '#003399'
    end
    def blue_tinge
      '#e3ecef'
    end
    def yellow_light
      '#fff3b6'
    end
    def table1
      'ffffcc'
    end
    def table2
      'c0d0f0'
    end
    def band1
      %{"#{white}"}
    end
    def band2
      %{"#{white}"}
    end
    self
  end
  def the_url_decoration
    #def tex_open                     #'{\UseTextSymbol{OML}{<}}'
    #  Dx[:url_o]
    #end
    #def tex_close                    #'{\UseTextSymbol{OML}{>}}'
    #  Dx[:url_c]
    #end
    def xml_open                     #'&lt;'
      Dx[:url_o]
    end
    def xml_close                    #'&gt;'
      Dx[:url_c]
    end
    def txt_open
      '<'
    end
    def txt_close
      '>'
    end
    self
  end
  def the_width
    def table1
      '"100%"'
    end
    def table2
      '"99%"'
    end
    def table_txt
      '"94%"'
    end
    def table_txt_r
      '"96%"'
    end
    self
  end
  def the_png
    def _url_path_image_base #used for html image display
      "#{Xx[:html_relative2]}_sisu/image"
    end
    def ico
      %{  <link rel="shortcut icon" href="../_sisu/image/#{the_icon.i_ico}" />}
    end
    def png_home
      %{<img border="0" src="#{_url_path_image_base}/#{the_icon.home_button}" alt="#{the_text.home} --&gt;" />}
    end
    def png_home_button
      rel=@dir.path_rel_links.html_scroll_2
      %{<img border="0" src="#{rel}/#{the_icon.home_button}" alt="#{the_text.home} --&gt;" />}
    end
    self
  end
  def the_font
    def set_fonts
      'verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman'
     #'verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
    end
    def set_face
      %{face="#{set_fonts}"}
    end
    def set_color
      'color="#000000"'
    end
    def set_size_endnote
      'size="3"'
    end
    def set_small
      'size="3"'
    end
    def set_tiny
      'size="2"'
    end
    def paragraph_font_tiny
      %{<font #{set_tiny} #{set_face}>}
    end
    def paragraph_font_small
      %{<font #{set_small} #{set_face}>}
    end
    self
  end
  def the_nav
    def txt_homepage
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;home&nbsp;
  </font> }
    end
    def txt_toc_link
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;&nbsp;toc&nbsp;
  </font> }
    end
    def txt_doc_link
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;scroll&nbsp;
  </font> }
    end
    def txt_manifest
      #{png_manifest}&nbsp;document&nbsp;manifest
      %{  <font face="#{the_font.set_fonts}" size="2">
    [&nbsp;document&nbsp;manifest&nbsp;]
  </font> }
    end
    def txt_concordance
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;&nbsp;A-Z&nbsp;
  </font> }
    end
    self
  end
  def the_banner
    def home_button_only
      %{<a href="#{url.site}/">
  #{the_png.png_home_button}
  </a>}
    end
    def banner_band
      %{<table summary="home button" width="100%" border="0" cellpadding="3" align="center">
<tr><td align="left" valign="middle">
  <a href="#{url.site}/" target="_top">
    #{the_png.png_home}
  </a>
</td>
<td width="90%">
#{the_table_close}}
    end
    def instrument_cover_band_scr
      '<table summary="scroll instrument cover band" width="100%" border="0" cellpadding="8" align="center">
<tr><td align="center">'
    end
    def instrument_cover_band_seg
      '<table summary="segment instrument cover band, title, author, location" width="100%" border="0" cellpadding="8" align="center">
<tr><td align="center">'
    end
    self
  end
  def the_margin
    def txt_0
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_0} align="right">
</td><td valign="top" align="justify">}
    end
    def txt_1
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_1} align="right"></td><td valign="top" align="justify">}
    end
    def txt_2
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_3
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_3} align="right">
</td>
<td valign="top" align="justify">}
    end
    def css
      '<table summary="normal text css" width="100%" border="0" cellpadding="2" align="center">
<tr><td valign="top" align="justify"> '
    end
    def num
      '</p> </td><td width="4%" align="right" valign="top">'
    end
    def numless
      '</td><td width="4%" align="right" valign="top">'
    end
    def num_css
      '</td>
<td width="2%" align="right" valign="top">  '
    end
    self
  end
end
module SiSU_Proj_HTML
  require_relative 'se'                                 # se.rb
  include SiSU_Env
  #require_relative 'css'                                # css.rb
  #  include SiSU_Style
  class Bits
    include SiSU_Parts_HTML
    def initialize
      @v=SiSU_Env::InfoVersion.instance.get_version
      #@dir=SiSU_Env::InfoEnv.new
      #@date=SiSU_Env::InfoDate.new #{@date.year}
    end
    def txt_generator
      %{  <meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
    <link rel="generator" href="http://www.sisudoc.org/" />}
    end
    def widget_sisu_text
<<WOK
  <p class="tiny"><font color="#666666" size="2">
    Output generated by
    <a href="#{the_url.sisu}">
      #{@v[:project]}
    </a>
    #{@v[:version]} #{@v[:date]} (#{@v[:date_stamp]})
  </font></p>
WOK
    end
    def credits_sisu_manifest
      widget_sisu_text
    end
    def widget_sisu
<<WOK
<!-- widget sisu -->
<tr><td valign="top" width="100%">
<!-- SiSU Rights -->
#{widget_sisu_text}
</td></tr>
WOK
    end
    def credits_sisu
      %{<div class="substance">
<table summary="SiSU summary" cellpadding="4" border="0">
<tr><td>
  #{widget_sisu}
</table></div>}
      ''
    end
    def widget_promo # Array used to build promo from list.yml and promo.yml
    #  ['sisu_icon','sisu','sisu_search_libre','open_society','fsf','ruby']
    end
  end
  class Home
    def initialize
      @v=SiSU_Env::InfoVersion.instance.get_version
      @dir=SiSU_Env::InfoEnv.new
      @date=SiSU_Env::InfoDate.new #{@date.year}
    end
    def redirect
      <<WOK
<html><head>
<title>SiSU</title>
<meta http-equiv="refresh" content="0, url=http://www.sisudoc.org/sisu/SiSU/">
</head>
<body>
SiSU informtion provided at <a href="http://www.sisudoc.org/sisu/SiSU/">www.sisudoc.org/sisu/SiSU</a><p />
If your browser supports redirection, you will be escorted there shortly.
</body>
</html>
WOK
    end
    def homepage
      <<WOK
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>SiSU information Structuring Universe - Structured information, Serialized Units - software for electronic texts, documents, books, digital libraries in plaintext, HTML, EPUB, XHTML, XML, ODF (OpenDocument), LaTeX, PDF, SQL (PostgreSQL and SQLite), and for search</title>
<meta name="dc.title" content="SiSU - SiSU information Structuring Universe, Structured information Serialised Units, #{@date.year_static}" />
<meta name="dc.creator" content="Ralph Amissah" />
<meta name="dc.subject" content= "document structuring, ebook, publishing, PDF, LaTeX, XML, ODF, EPUB, SQL, postgresql, sqlite, electronic book, electronic publishing, electronic document, electronic citation, data structure, citation systems, granular search, digital library" />
<meta name="dc.publisher" content= "SiSU http://www.sisudoc.org/" />
<meta name="dc.language" content="en" />
<meta name="dc.rights" content="Copyright Ralph Amissah" />
<meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
<link rel="generator" href="http://www.sisudoc.org/" />
<link rel="stylesheet" href="./#{@dir.path.style}/harvest.css" type="text/css" />
<link rel="shortcut icon" href="./_sisu/image/rb7.ico" />
</head>

<body lang="en" xml:lang="en">
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>

<h1>SiSU</h1>
<p>
[<a href="http://sisudoc.org/sisu_manual/en/html/sisu/toc.html">Manual</a>]
</p>
<p>
[<a href="http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary">Source</a>]
[<a href="http://lists.sisudoc.org/listinfo/sisu">List Info (sisu@lists.sisudoc.org)</a>]
</p>

<h1>SiSU Markup Samples</h1>
<p>
[<a href="http://git.sisudoc.org/gitweb/?p=doc/sisu-markup-samples.git;a=summary">Source</a>]
[<a href="http://sisudoc.org/sisu_markup_samples.html">Output</a>]
</p>

<hr />

<h2 class="top_band_tiny">
  Structured information, Serialized Units
  &nbsp;&nbsp;
  <a href="http://www.sisudoc.org" target="_top">
    &lt;www.sisudoc.org&gt;
  </a>
  &nbsp;&nbsp;or&nbsp;&nbsp;
  <a href="http://www.jus.uio.no/sisu/" target="_top">
    &lt;www.jus.uio.no/sisu/&gt;
  </a>
software for electronic texts, document collections, books, digital libraries &amp; search, with "atomic search" &amp; text locating system (shared object citation numbering: "<i>ocn</i>").
Outputs include: plaintext, HTML, EPUB, ODT (OpenDocumentText), (XHTML, XML,) LaTeX, PDF, SQL (PostgreSQL and SQLite).
</h2>
<p class="small">
<a href="mailto:sisu@lists.sisudoc.org">
&lt;sisu@lists.sisudoc.org&gt;
</a>
<a href="http://lists.sisudoc.org/listinfo/sisu">
&lt;http://lists.sisudoc.org/listinfo/sisu&gt;
</a>
</p>
<p class="small">
<a href="mailto:ralph@amissah.com">
&lt;ralph@amissah.com&gt;
</a>
<a href="mailto:ralph.amissah@gmail.com">
&lt;ralph.amissah@gmail.com&gt;
</a>
</p>
<p class="tiny">
#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!), #{@date.year_static}.
</p>
<p class="tiny">
w3 since October 3 1993.
</p>
</body>
</html>
WOK
    end
    def home_toc
      ' '
    end
  end
end
__END__
