# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: summary of generated outputs and metadata

=end
module SiSU_QRcode
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'prog_text_translation'              # prog_text_translation.rb
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'html'                               # html.rb
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'i18n'                               # i18n.rb
  include SiSU_Viz
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      l=SiSU_Env::StandardiseLanguage.new(@opt.lng).language
      @doc_language=l[:n]
    end
    def read
      begin
        @env=SiSU_Env::InfoEnv.new(@opt.fns)
        @md=SiSU_Param::Parameters.new(@opt).get
        SiSU_Env::InfoSkin.new(@md).select
        xbrowser=@env.program.web_browser
        browser=@env.program.console_web_browser
        unless @opt.cmd =~/q/
          url_html="file://#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}"
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'QR code',"#{xbrowser} #{url_html}").green_hi_blue
          : SiSU_Screen::Ansi.new(@opt.cmd,'QR code',"[#{@opt.f_pth[:lng_is]}] #{@opt.fns}").green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,"#{browser} #{url_html}").grey_tab if @opt.cmd =~/v/i
        end
        data=SiSU_HTML::Source::HTML_Environment.new(@particulars).tuned_file_instructions
        OutputInfo.new(@md).check_output(data)
      rescue
        SiSU_Errors::InfoError.new($!,$@,@opt.cmd,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    private
    class OutputInfo <Source
      def initialize(md)
        @manifest={ txt: [], txt_title: [] }
        @md,@fns=md,md.fns
        @env=SiSU_Env::InfoEnv.new(@md.fns)
        @fnb=@md.fnb
        @base_url="#{@env.url.root}/#{@fnb}"
        @f=SiSU_Env::FileOp.new(@md)
        @base_path=@f.output_path.manifest.dir
        @@dg ||=SiSU_Env::InfoEnv.new.digest.type
        @dg=@@dg
        l=SiSU_Env::StandardiseLanguage.new(@md.opt.lng).language
        @language=l[:n]
        @translate=SiSU_Translate::Source.new(@md,@language)
        @brace_url=SiSU_Viz::Skin.new.url_decoration
        @f.make_path(@f.output_path.qrcode.dir)
      end
      def output_metadata
        fn=@f.base_filename.manifest_txt
        mn=''
        if @md.opt =~/M/
          pt=@f.output_path.manifest.dir
          fn=@f.base_filename.manifest_txt
          manifest=@f.write_file.manifest_txt
        end
        @manifest[:txt].each do |x|
          manifest << x if @md.opt =~/M/
          mn += x
        end
        manifest.close if @md.opt =~/M/
        #system(%{
        #  cat  #{pt}/#{fn} | qrencode -s 3 -o qrcm.autonomy_markup0.png
        #})
        cmd=SiSU_Env::SystemCall.new(mn,@f.place_file.qrcode_md.dir,@md.opt.cmd)
        cmd.qrencode
        #system(%{
        #  echo "#{mn}" | qrencode -s 3 -o #{@dest}/qrc_md.#{fn}.png
        #})
      end
      def output_metadata_short
        fn=@f.base_filename.manifest_txt
        mn=''
        @manifest[:txt_title].each do |x|
          mn += x
        end
        cmd=SiSU_Env::SystemCall.new(mn,@f.place_file.qrcode_title.dir,@md.opt.cmd)
        cmd.qrencode
        #system(%{
        #  echo "#{mn}" | qrencode -s 3 -o #{@dest}/qrc_title.#{fn}.png
        #})
      end
      def summarize(id,file,pth='',rel='',url='',img='● ')
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] <<<<WOK
#{id} #{kb}
  #{@brace_url.txt_open}#{url}/#{file}#{@brace_url.txt_close}
WOK
      end
      def summarize_html_seg(id,file,pth='',rel='',url='',img='● ')
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] <<<<WOK
#{id} #{kb}
  #{@brace_url.txt_open}#{url}/#{file}#{@brace_url.txt_close}
WOK
      end
      def summarize_sources(id,file,pth,rel,url)
        sys=SiSU_Env::SystemCall.new
        dgst =if @dg =~/^sha(?:2|256)$/; sys.sha256("#{pth}/#{file}")
        else                             sys.md5("#{pth}/#{file}")
        end
        SiSU_Screen::Ansi.new(@md.opt.cmd,"#{dgst[1]} #{file}").warn if @md.opt.cmd =~/[vVM]/
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] <<<<WOK
#{id} #{dgst[1]} #{kb}
  #{@brace_url.txt_open}#{url}/#{file}#{@brace_url.txt_close}
WOK
      end
      def published_manifests?
        @f=SiSU_Env::FileOp.new(@md) #.base_filename
        @m=[]
        url=@f.output_path.base.url
        manifests={}
        mp,mn,mt=nil,nil,nil
        ln=SiSU_i18n::Languages.new.language.list
        Px[:lng_lst].each do |lc|
          if @env.output_dir_structure.by_language_code?
            mp="#{@f.output_path.base.dir}/#{lc}/manifest"
            mn="#{@md.fnb}.html"
            mt="#{mp}/#{mn}"
            mu="#{url}/#{lc}/manifest/#{mn}"
          elsif @env.output_dir_structure.by_filetype?
            mp="#{@f.output_path.base.dir}/manifest"
            mn="#{@md.fnb}.#{lc}.html"
            mt="#{mp}/#{mn}"
            mu="#{url}/manifest/#{mn}"
          else
            mp="#{@f.output_path.base.dir}/#{@md.fnb}"
            mn="sisu_manifest.#{lc}.html"
            mt="#{mp}/#{mn}"
            mu="#{url}/#{mn}"
          end
          if FileTest.directory?(mp) \
          &&  FileTest.file?(mt)
            lng=ln[lc][:t]
            manifests[lc]={ ln: lng, fn: mn }
            @m << { mu: mu, l: lng }
          end
        end
        #url=@f.output_path.base.url
        #@en_manifest=if @env.output_dir_structure.by_language_code?
        #  "#{url}/en/manifest/#{@md.fnb}.html"
        #elsif @env.output_dir_structure.by_filetype?
        #  "#{url}/manifest/#{@md.fnb}.#{lc}.html"
        #else
        #  "#{url}/sisu_manifest.#{lc}.html"
        #end
        manifests
        @m=@m.uniq
        @m
      end
      def languages(id,file)
        flv=published_manifests?
        flv.each do |l|
          lang=SiSU_Translate::Source.new(@md,@language,l[:n]).language_list
          @manifest[:txt] << "#{l[:mu]} #{l[:l]}\n"
        end
      end
      def published_languages(id,file)
        flv=published_manifests?
        flv.each do |l|
          @manifest[:txt] << "#{l[:l]}  #{@brace_url.txt_open}#{l[:mu]}#{@brace_url.txt_close}\n"
        end
      end
      def metadata(id,info)
        info=info.to_s.gsub(/#{Mx[:br_line]}/,"\n")
        @manifest[:txt] << %{#{id}: #{info}\n}
      end
      def md_title_info(id,info)
        info=info.to_s.gsub(/#{Mx[:br_line]}/,"\n")
        @manifest[:txt_title] << %{#{info}\n}
      end
      def links(url,lnk,target)
        static=if url =~/^\.\//; url.gsub(/^\.(\.)?/,@base_url)
        elsif url =~/^\.\.\//;   url.gsub(/^\.(\.)?/,@env.url.root)
        else                     url
        end
        @manifest[:txt] << %{#{url} #{lnk} #{@brace_url.txt_open}#{static}#{@brace_url.txt_close}\n}
      end
      def output_tests
        if FileTest.file?(@f.place_file.html_segtoc.dir)==true
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          id,file='HTML, table of contents (for segmented text)',@f.base_filename.html_segtoc
          summarize_html_seg(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.html_scroll.dir)==true
          pth=@f.output_path.html_scroll.dir
          rel=@f.output_path.html_scroll.rel_sm
          url=@f.output_path.html_scroll.url
          id,file='HTML, full length document',@f.base_filename.html_scroll
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.html_book_index.dir)==true
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          id,file='HTML, (book type) index',@f.base_filename.html_book_index
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.html_concordance.dir)==true
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          id,file='HTML, concordance file',@f.base_filename.html_concordance
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.epub.dir)==true
          id,file='EPUB (Electronic Publication, e-book standard)',@f.base_filename.epub
          pth=@f.output_path.epub.dir
          rel=@f.output_path.epub.rel_sm
          url=@f.output_path.epub.url
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_letter}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, U.S. letter size, portrait/vertical","#{@f.base_filename.pdf_p_letter}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_letter}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, U.S. letter size, landscape/horizontal","#{@f.base_filename.pdf_l_letter}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_a4}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, A4 size, portrait/vertical","#{@f.base_filename.pdf_p_a4}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_a4}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, A4 size, landscape/horizontal","#{@f.base_filename.pdf_l_a4}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_a5}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, A5 (book) size, portrait/vertical","#{@f.base_filename.pdf_p_a5}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_a5}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, A5 (book) size, landscape/horizontal","#{@f.base_filename.pdf_l_a5}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_b5}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, B5 (book) size, portrait/vertical","#{@f.base_filename.pdf_p_b5}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_b5}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, B5 (book) size, landscape/horizontal","#{@f.base_filename.pdf_l_b5}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_legal}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, U.S. legal size, portrait/vertical","#{@f.base_filename.pdf_p_legal}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_legal}")==true
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          id,file="PDF, U.S. legal size, landscape/horizontal","#{@f.base_filename.pdf_l_legal}"
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.odt.dir)==true
          pth=@f.output_path.odt.dir
          rel=@f.output_path.odt.rel_sm
          url=@f.output_path.odf.url
          id,file='ODF:ODT (Open Document Format)',@f.base_filename.odt
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xhtml.dir)==true
          pth=@f.output_path.xhtml.dir
          rel=@f.output_path.xhtml.rel_sm
          url=@f.output_path.xhtml.url
          id,file='ODF:ODT (Open Document Format)',@f.base_filename.odt
          id,file='XHTML',@f.base_filename.xhtml
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_sax.dir)==true
          pth=@f.output_path.xml_sax.dir
          rel=@f.output_path.xml_sax.rel_sm
          url=@f.output_path.xml_sax.url
          id,file='XML SAX',@f.base_filename.xml_sax
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_dom.dir)==true
          pth=@f.output_path.xml_dom.dir
          rel=@f.output_path.xml_dom.rel_sm
          url=@f.output_path.xml_dom.url
          id,file='XML DOM',@f.base_filename.xml_dom
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.txt.dir)==true
        if    @md.opt.cmd =~/a/; id='Plaintext (Unix (UTF-8) with footnotes)'
        elsif @md.opt.cmd =~/e/; id='Plaintext (Unix (UTF-8) with endnotes)'
        elsif @md.opt.cmd =~/A/; id='Plaintext (dos (UTF-8) with footnotes)'
        elsif @md.opt.cmd =~/E/; id='Plaintext (dos (UTF-8) with endnotes)'
        else                id='Plaintext (UTF-8)'
        end
          pth=@f.output_path.txt.dir
          rel=@f.output_path.txt.rel_sm
          url=@f.output_path.txt.url
          file=@f.base_filename.txt
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@base_path}/#{@md.fns}.tex")==true
          id,file='LaTeX (portrait)',"#{@md.fns}.tex"
          pth,rel,url='','',''
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?("#{@base_path}/#{@md.fns}.tex")==true
          id,file='LaTeX (landscape)',"#{@md.fns}.landscape.tex"
          pth,rel,url='','',''
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.manpage.dir)==true
          pth=@f.output_path.manpage.dir
          rel=@f.output_path.manpage.rel_sm
          url=@f.output_path.manpage.url
          id,file='Manpage',@f.base_filename.manpage
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.texinfo.dir)==true
          pth=@f.output_path.texinfo.dir
          rel=@f.output_path.texinfo.rel_sm
          url=@f.output_path.texinfo.url
          id,file='Texinfo',@f.base_filename.texinfo
          summarize(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.hash_digest.dir)==true
          pth=@f.output_path.hash_digest.dir
          rel=@f.output_path.hash_digest.rel_sm
          url=@f.output_path.hash_digest.url
          id,file="Digest/DCC - Document Content Certificate (#{@dg})",@f.base_filename.hash_digest
          summarize(id,file,pth,rel,url)
        end
      end
      def published_versions
        id,file='Markup (SiSU source)',@md.fns
        #languages(id,file)
        published_languages(id,file)
      end
      def language_versions
        if FileTest.file?(@f.place_file.manifest.dir)==true
          id,file='Markup (SiSU source)',@md.fns
          published_languages(id,file)
        end
      end
      def source_tests
        if @md.fns =~/\.ssm\.sst$/                                                  #% decide whether to extract and include requested/required documents
          req=@md.fns
          if FileTest.file?(@f.place_file.src.dir)==true
            pth=@f.output_path.src.dir
            rel=@f.output_path.src.rel
            url=@f.output_path.src.url
            id,file='Markup Composite File (SiSU source)',@f.base_filename.src
            summarize_sources(id,file,pth,rel,url)
          end
        else
          if FileTest.file?(@f.place_file.src.dir)==true
            pth=@f.output_path.src.dir
            rel=@f.output_path.src.rel
            url=@f.output_path.src.url
            id,file='Markup (SiSU source)',@f.base_filename.src
            summarize_sources(id,file,pth,rel,url)
          end
        end
        if FileTest.file?(@f.place_file.sisupod.dir)==true
          pth=@f.output_path.sisupod.dir
          rel=@f.output_path.sisupod.rel
          url=@f.output_path.sisupod.url
          id,file='SiSU doc (zip)',@f.base_filename.sisupod
          summarize_sources(id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.pot.dir)==true
          pth=@f.output_path.pot.dir
          rel=@f.output_path.pot.rel_sm
          url=@f.output_path.pot.url
          id,file='SiSU pot',@f.base_filename.pot
          summarize_sources(id,file,pth,rel,url)
        end
      end
      def metadata_tests
        if defined? @md.title.full \
        and @md.title.full=~/\S+/
          id,info=@translate.full_title,@md.title.full
          #id,info=@translate.full_title,%{"#{@md.title.full}"}
          metadata(id,info)
          md_title_info(id,info)
        end
        if defined? @md.creator.author \
        and @md.creator.author=~/\S+/
          id,info=@translate.author,@md.creator.author
          metadata(id,info)
          md_title_info(id,info)
        end
        if defined? @md.creator.editor \
        and @md.creator.editor=~/\S+/
          id,info=@translate.editor,@md.creator.editor
          metadata(id,info)
        end
        if defined? @md.creator.contributor \
        and @md.creator.contributor=~/\S+/
          id,info=@translate.contributor,@md.creator.contributor
          metadata(id,info)
        end
        if defined? @md.creator.translator \
        and @md.creator.translator=~/\S+/
          id,info=@translate.translator,%{(#{@md.creator.translator})}
          metadata(id,info)
          md_title_info(id,info)
        end
        if defined? @md.creator.illustrator \
        and @md.creator.illustrator=~/\S+/
          id,info=@translate.illustrator,@md.creator.illustrator
          metadata(id,info)
        end
        if defined? @md.publisher \
        and @md.publisher=~/\S+/ #dc
          id,info=@translate.publisher,@md.publisher
          metadata(id,info)
        end
        if defined? @md.creator.prepared_by \
        and @md.creator.prepared_by=~/\S+/
          id,info=@translate.prepared_by,@md.creator.prepared_by
          metadata(id,info)
        end
        if defined? @md.creator.digitized_by \
        and @md.creator.digitized_by=~/\S+/
          id,info=@translate.digitized_by,@md.creator.digitized_by
          metadata(id,info)
        end
        if defined? @md.classify.subject \
        and @md.classify.subject=~/\S+/
          id,info=@translate.subject,@md.classify.subject
          metadata(id,info)
        end
        if defined? @md.notes.description \
        and @md.notes.description=~/\S+/
          id,info=@translate.description,@md.notes.description
          metadata(id,info)
        end
        if defined? @md.notes.abstract \
        and @md.notes.abstract=~/\S+/
          id,info=@translate.abstract,@md.notes.abstract
          metadata(id,info)
        end
        if defined? @md.type \
        and @md.type=~/\S+/ #dc
          id,info=@translate.type,@md.type
          metadata(id,info)
        end
        if defined? @md.rights.all \
        and @md.rights.all=~/\S+/ #dc
          id,info=@translate.rights,@md.rights.all
          metadata(id,info)
        end
        if defined? @md.date.published
          if defined? @md.date.published \
          and @md.date.published=~/\S+/ #dc
            id,info=@translate.date,@md.date.published
            metadata(id,info)
            md_title_info(id,info)
          end
          if defined? @md.date.created \
          and @md.date.created=~/\S+/ #dc
            id,info=@translate.date_created,@md.date.created
            metadata(id,info)
          end
          if defined? @md.date.issued \
          and @md.date.issued=~/\S+/ #dc
            id,info=@translate.date_issued,@md.date.issued
            metadata(id,info)
          end
          if defined? @md.date.available \
          and @md.date.available=~/\S+/ #dc
            id,info=@translate.date_available,@md.date.available
            metadata(id,info)
          end
          if defined? @md.date.modified \
          and @md.date.modified=~/\S+/ #dc
            id,info=@translate.date_modified,@md.date.modified
            metadata(id,info)
          end
          if defined? @md.date.valid \
          and @md.date.valid=~/\S+/ #dc
            id,info=@translate.date_valid,@md.date.valid
            metadata(id,info)
          end
        end
        if defined? @md.title.language \
        and @md.title.language=~/\S+/
          id,info=@translate.language,@md.title.language
          metadata(id,info)
        end
        if defined? @md.original.language \
        and @md.original.language=~/\S+/
          id,info=@translate.language_original,@md.original.language
          metadata(id,info)
        end
        if defined? @md.classify.format \
        and @md.classify.format=~/\S+/
          id,info=@transate.format,@md.classify.format
          metadata(id,info)
        end
        if defined? @md.classify.identifier \
        and @md.classify.identifier=~/\S+/
          id,info=@translate.identifier,@md.classify.identifier
          metadata(id,info)
        end
        if defined? @md.original.source \
        and @md.original.source=~/\S+/
          id,info=@translate.source,@md.original.source
          metadata(id,info)
        end
        if defined? @md.classify.relation \
        and @md.classify.relation=~/\S+/
          id,info=@translate.relation,@md.classify.relation
          metadata(id,info)
        end
        if defined? @md.classify.coverage \
        and @md.classify.coverage=~/\S+/
          id,info=@translate.coverage,@md.classify.coverage
          metadata(id,info)
        end
        if defined? @md.classify.keywords \
        and @md.classify.keywords=~/\S+/
          id,info=@translate.keywords,@md.classify.keywords
          metadata(id,info)
        end
        if defined? @md.notes.comment \
        and @md.notes.comment=~/\S+/
          id,info=@translate.comments,@md.notes.comment
          metadata(id,info)
        end
        if defined? @md.classify.loc \
        and @md.classify.loc=~/\S+/
          id,info=@translate.cls_loc,@md.classify.loc
          metadata(id,info)
        end
        if defined? @md.classify.dewey \
        and @md.classify.dewey=~/\S+/
          id,info=@translate.cls_dewey,@md.classify.dewey
          metadata(id,info)
        end
        if defined? @md.classify.oclc \
        and @md.classify.oclc=~/\S+/
          id,info=@translate.cls_oclc,@md.classify.oclc
          @manifest[:txt] << %{#{id}:\n}
          @manifest[:txt] << %{#{info}\n}
        end
        if defined? @md.classify.pg \
        and @md.classify.pg=~/\S+/
          id,info=@translate.cls_gutenberg,@md.classify.pg
          metadata(id,info)
        end
        if defined? @md.classify.isbn \
        and @md.classify.isbn=~/\S+/
          id,info=@translate.cls_isbn,@md.classify.isbn
          metadata(id,info)
        end
        if defined? @md.notes.prefix_a \
        and @md.notes.prefix_a=~/\S+/
          id,info=@translate.prefix_a,@md.notes.prefix_a
          metadata(id,info)
        end
        if defined? @md.notes.prefix_b \
        and @md.notes.prefix_b=~/\S+/
          id,info=@translate.prefix_b,@md.notes.prefix_b
          metadata(id,info)
        end
        if defined? @md.topic_register_array \
        and @md.topic_register_array.length > 0
          @manifest[:txt] << %{#{@translate.topic_register}:\n}
@sp='  '
          @md.topic_register_array.each do |t|
            t.each_with_index do |st,i|
              if st.class==Array
                st.each do |v|
                  @manifest[:txt] << %{#{@sp*i}#{v}\n}
                end
              else @manifest[:txt] << %{#{@sp*i}#{st}\n}
              end
            end
          end
        end
        if @md.fns
          id,info=@translate.sourcefile,@md.fns
          metadata(id,info)
        end
        if @md.en[:mismatch] > 0
          id,info='WARNING document error in endnote markup, number mismatch',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
          metadata(id,info)
        end
        if @md.wc_words
          id,info=@translate.word_count,@md.wc_words
          metadata(id,info)
        end
        if @md.dgst
          id,info="#{@translate.sourcefile_digest} (#{@dg})",@md.dgst[1]
          metadata(id,info)
        end
        if @md.sc_number
          id,info=@translate.sc_number,@md.sc_number
          metadata(id,info)
        end
        if @md.sc_date
          id,info=@translate.sc_date,"#{@md.sc_date} at #{@md.sc_time}"
          metadata(id,info)
        end
      end
      def check_output(data)
        begin
          id,file='',''
          vz=SiSU_Env::GetInit.instance.skin
          @f=SiSU_Env::FileOp.new(@md) #.base_filename
          url=@f.output_path.base.url
          @en_manifest=if @env.output_dir_structure.by_language_code?
            "#{url}/en/manifest/#{@md.fnb}.html"
          elsif @env.output_dir_structure.by_filetype?
            "#{url}/manifest/#{@md.fnb}.#{@md.opt.lng}.html"
          else
            "#{url}/sisu_manifest.#{@md.opt.lng}.html"
          end
          @manifest[:txt] <<<<WOK
#{@translate.manifest_description_metadata}
  #{@brace_url.txt_open}#{@en_manifest}#{@brace_url.txt_close}
WOK
          metadata_tests
          @manifest[:txt_title] <<<<WOK
  #{@brace_url.txt_open}#{@en_manifest}#{@brace_url.txt_close}
WOK
          source_tests
          @manifest[:txt] <<<<WOK
#{@translate.language_version_list}
WOK
          language_versions
          output_metadata
          output_metadata_short
        rescue
          SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
            __LINE__.to_s + ':' + __FILE__
          end
        ensure
        end
      end
    end
  end
end
__END__
