/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* Detection tables for Adibou / Addy Junior series. */

#ifndef GOB_DETECTION_TABLES_ADIBOU_H
#define GOB_DETECTION_TABLES_ADIBOU_H

// -- French: Adibou --

{
	{
		"adibou1",
		"ADIBOU 1 Environnement 4-7 ans",
		AD_ENTRY1s("intro.stk", "6db110188fcb7c5208d9721b5282682a", 4805104),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kGameTypeAdibou1,
	kFeaturesAdLib,
	0, 0, 0
},
{
	{
		"adibou1",
		"ADIBOU 1 Environnement 4-7 ans",
		AD_ENTRY1s("intro.stk", "904a93f46687617bb34e672020fc17a4", 248724),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kGameTypeAdibou1,
	kFeaturesAdLib | kFeaturesEGA,
	0, "base.tot", 0
},
{
	{
		"adibou1",
		"ADIBOU 1 Environnement 4-7 ans",
		AD_ENTRY1s("intro.stk", "228edf921ebcd9f1c6d566856f264ea4", 2647968),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kGameTypeAdibou1,
	kFeaturesAdLib,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2",
		AD_ENTRY1s("intro.stk", "94ae7004348dc8bf99c23a9a6ef81827", 956162),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"Le Jardin Magique d'Adibou",
		AD_ENTRY1s("intro.stk", "a8ff86f3cc40dfe5898e0a741217ef27", 956328),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU Version Decouverte",
		AD_ENTRY1s("intro.stk", "558c14327b79ed39214b49d567a75e33", 8737856),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.10 Environnement",
		AD_ENTRY1s("intro.stk", "f2b797819aeedee557e904b0b5ccd82e", 8736454),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.11 Environnement",
		AD_ENTRY1s("intro.stk", "7b1f1f6f6477f54401e95d913f75e333", 8736904),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.12 Environnement",
		AD_ENTRY1s("intro.stk", "1e49c39a4a3ce6032a84b712539c2d63", 8738134),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.13s Environnement",
		AD_ENTRY1s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOO 2.14 Environnement",
		AD_ENTRY1s("intro.stk", "ff63637e3cb7f0a457edf79457b1c6b3", 9333874),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},

// -- German: Addy Junior --

{
	{
		"adibou2",
		"ADIBOU 2",
		AD_ENTRY1s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958),
		DE_DEU,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2",
		"ADI Jr. (Packard Bell OEM)",
		AD_ENTRY1s("intro.stk", "80588ad3b5510bb44d3f40d6b07b81e7", 956328),
		DE_DEU,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},


// -- Italian: Adibù --
{
	{
		"adibou2",
		"ADIBÙ 2",
		AD_ENTRY1s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958),
		IT_ITA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},

// -- Spanish: Adibù --
{
	{
		"adibou2",
		"ADIBÙ 2",
		AD_ENTRY1s("intro.stk", "0b996fcd8929245fecddc4d9169843d0", 956682),
		ES_ESP,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},

// -- English: Adiboo --
{
	{
		"adibou2",
		"ADIBOO 2",
		AD_ENTRY1s("intro.stk", "718a51862406136c28639489a9ba950a", 956350),
		EN_ANY,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},

// -- Demos --

{
	{
		"adibou2",
		"ADIBOU 2 Demo",
		AD_ENTRY1s("intro.stk", "0f197c6b8f1cef3fb4aa37438a52e031", 954276),
		FR_FRA,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO0()
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	// Titlescreen says "ADIBOO: Limited version!", Sierra setup says "Adiboo 2 Demo"
	{
		"adibou2",
		"ADIBOO 2 Demo",
		AD_ENTRY1s("intro.stk", "ea6c2d25f33135db763c1175979d904a", 528108),
		EN_GRB,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kGameTypeAdibou2,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demogb.scn", "9291455a908ac0e6aaaca686e532609b", 105,
				   "demogb.vmd", "bc9c1db97db7bec8f566332444fa0090", 14320840),
		EN_GRB,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeAdibou2,
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 9
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demoall.scn", "c8fd308c037b829800006332b2c32674", 106,
				   "demoall.vmd", "4672b2deacc6fca97484840424b1921b", 14263433),
		DE_DEU,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeAdibou2,
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 10
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demofra.scn", "d1b2b1618af384ea1120def8b986c02b", 106,
				   "demofra.vmd", "b494cdec1aac7e54c3f2480512d2880e", 14297100),
		FR_FRA,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeAdibou2,
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 11
},

#endif // GOB_DETECTION_TABLES_ADIBOU_H
