/*******************************************************************************
 * shroudBNC - an object-oriented framework for IRC                            *
 * Copyright (C) 2005-2007 Gunnar Beutner                                      *
 *                                                                             *
 * This program is free software; you can redistribute it and/or               *
 * modify it under the terms of the GNU General Public License                 *
 * as published by the Free Software Foundation; either version 2              *
 * of the License, or (at your option) any later version.                      *
 *                                                                             *
 * This program is distributed in the hope that it will be useful,             *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU General Public License for more details.                                *
 *                                                                             *
 * You should have received a copy of the GNU General Public License           *
 * along with this program; if not, write to the Free Software                 *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *******************************************************************************/

/**
 * CPersistable
 *
 * Base class for persistable objects.
 */
class SBNCAPI CPersistable {
private:
	safe_box_t m_Box;

protected:
	void SetBox(safe_box_t Box) {
		m_Box = Box;
	}

public:
	CPersistable(void) {
		m_Box = NULL;
	}

	~CPersistable(void) {
		if (m_Box != NULL) {
			safe_box_t Parent = safe_get_parent(m_Box);
			const char *Name = safe_get_name(m_Box);

			safe_remove(Parent, Name);

			m_Box = NULL;
		}
	}

	safe_box_t GetBox(void) {
		return m_Box;
	}
};
