.TH sane-fujitsu 5 "10 Oct 2001"
.IX sane-fujitsu
.IX sane-fcpa
.IX sane-m3096g
.IX sane-sp15c

.SH NAME
sane-m3096g, sane-sp15c - SANE backends for Fujitsu flatbed scanners

.SH DESCRIPTION
The
.B sane-m3096g
and
.B sane-sp15c
libraries implement SANE (Scanner Access Now Easy) backends which
provide access to Fujitsu flatbed scanners.
At present, the following
scanners are known to work with these backends:
.PP
.RS
Vendor:  Model:           Rev:
.br
-------- ---------------- -----
.br
FUJITSU  M3096Gm          02  
.br
FCPA     ScanPartner 15C  1.01
.RE
.P
The M3096G driver supports
lineart (1-bit), halftone (1-bit),
and grayscale (8-bit) scanning.

The ScanPartner 15C driver supports
lineart (1-bit), halftone (1-bit),
grayscale (4-bit and 8-bit),
and color (3 x 8-bit) scanning.

Other scanners in these families may work.
The ScanPartner 15C seems to be a repackaging
of the ScanPartner 600C.
Perusal of the M3096GX/M3093GX/M3093DG manual
suggests the M3096G driver offers access to a
subset of the new scanners.
People are encouraged to try these driver with the other scanners
and to contact the author with test results.

.SH CONFIGURATION
A modest effort has been made to expose the standard options to the API.
This allows frontends such as xscanimage to set scanning region,
resolution, bit-depth (and color), and enable the automatic document feeder.

.SH "SEE ALSO"
sane(7), sane\-scsi(5)
.br
Fujitsu ScanPartner 15C OEM Manual, Doc. No. 250-0081-0
.br
Fujitsu M3096G OEM Manual, part number 50FH5028E-05
.br
Fujitsu M3096GX/M3093GX/M3093DG OEM Manual, part number C150-E015...03

.SH AUTHOR
Randolph Bentson
<bentson@holmsjoen.com>,
and Oliver Schirrmeister <oschirr@abm.de>,
with credit to the unnamed author of the coolscan driver

.SH LIMITATIONS
Testing limited to a Linux 2.2.5 kernel
.br
Can't quite get the scan page/minute performance in ADF modes.
This may be due to limited system buffer size.

.SH BUGS
I'm sure there are plenty, and not too well hidden,
but I haven't seen them yet.
.br
Both scanners claim to have separate control
of resolution in X and Y directions.
I confess I haven't tested this yet.
I have found that xsane doesn't even display this capability.
.br
Threshold settings on the SP15C don't seem to
affect the results of lineart mode scans.
.br
It might be possible to merge these two drivers without much effort
since the SP15C driver was derived from the M3096G driver.
They were split so as to keep the second driver development from breaking
the working first driver.
Watch this space for changes.
