/* rygel-http-get.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *         Parthiban Balasubramanian <P.Balasubramanian-contractor@cablelabs.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
enum  {
	RYGEL_HTTP_GET_0_PROPERTY,
	RYGEL_HTTP_GET_NUM_PROPERTIES
};
static GParamSpec* rygel_http_get_properties[RYGEL_HTTP_GET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER (rygel_http_thumbnail_handler_get_type ())
#define RYGEL_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))

typedef struct _RygelHTTPThumbnailHandler RygelHTTPThumbnailHandler;
typedef struct _RygelHTTPThumbnailHandlerClass RygelHTTPThumbnailHandlerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_HTTP_SUBTITLE_HANDLER (rygel_http_subtitle_handler_get_type ())
#define RYGEL_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler))
#define RYGEL_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))

typedef struct _RygelHTTPSubtitleHandler RygelHTTPSubtitleHandler;
typedef struct _RygelHTTPSubtitleHandlerClass RygelHTTPSubtitleHandlerClass;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelHTTPGet* self;
	gboolean _tmp0_;
	SoupMessage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	SoupMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	gchar* cf_header;
	gchar* _tmp11_;
	gchar* cf_val;
	SoupMessage* _tmp12_;
	SoupMessageHeaders* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	RygelHTTPItemURI* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	RygelHTTPMediaResourceHandler* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelHTTPItemURI* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GCancellable* _tmp33_;
	GCancellable* _tmp34_;
	RygelHTTPMediaResourceHandler* _tmp35_;
	RygelHTTPMediaResourceHandler* _tmp36_;
	RygelHTTPItemURI* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	RygelHTTPThumbnailHandler* _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelHTTPItemURI* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GCancellable* _tmp45_;
	GCancellable* _tmp46_;
	RygelHTTPThumbnailHandler* _tmp47_;
	RygelHTTPThumbnailHandler* _tmp48_;
	RygelHTTPItemURI* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	RygelHTTPSubtitleHandler* _tmp52_;
	RygelMediaObject* _tmp53_;
	RygelHTTPItemURI* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GCancellable* _tmp57_;
	GCancellable* _tmp58_;
	RygelHTTPSubtitleHandler* _tmp59_;
	RygelHTTPSubtitleHandler* _tmp60_;
	RygelHTTPItemURI* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GError* _tmp64_;
	GError* _tmp65_;
	SoupMessageHeaders* headers;
	SoupMessage* _tmp66_;
	SoupMessageHeaders* _tmp67_;
	SoupMessageHeaders* _tmp68_;
	gchar* transfer_mode;
	SoupMessageHeaders* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	RygelHTTPGetHandler* _tmp73_;
	gchar* _tmp74_;
	RygelHTTPGetHandler* _tmp75_;
	const gchar* _tmp76_;
	gchar* msg;
	gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	RygelHTTPItemURI* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	GError* _tmp83_;
	GError* _tmp84_;
	GError * _inner_error_;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelHTTPGet* self;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	RygelClientHacks* _tmp10_;
	RygelClientHacks* _tmp11_;
	RygelMediaObject* _tmp12_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelHTTPGet* self;
	gboolean supports_time_seek;
	SoupMessage* _tmp0_;
	RygelHTTPGetHandler* _tmp1_;
	gboolean requested_time_seek;
	SoupMessage* _tmp2_;
	gboolean supports_byte_seek;
	SoupMessage* _tmp3_;
	RygelHTTPGetHandler* _tmp4_;
	gboolean requested_byte_seek;
	SoupMessage* _tmp5_;
	gboolean supports_cleartext_seek;
	SoupMessage* _tmp6_;
	RygelHTTPGetHandler* _tmp7_;
	gboolean requested_cleartext_seek;
	SoupMessage* _tmp8_;
	SoupMessageHeaders* response_headers;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gchar* msg;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelHTTPItemURI* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	gboolean _tmp21_;
	gchar* _vala1_msg;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	RygelHTTPItemURI* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gchar* _vala2_msg;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	RygelHTTPItemURI* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GError* _tmp36_;
	GError* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gchar* _vala3_msg;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	RygelHTTPItemURI* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GError* _tmp45_;
	GError* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	RygelPlaySpeedRequest* _tmp51_;
	RygelPlaySpeedRequest* _tmp52_;
	RygelPlaySpeedRequest* _tmp53_;
	RygelPlaySpeedRequest* _tmp54_;
	RygelPlaySpeed* _tmp55_;
	RygelPlaySpeed* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	RygelPlaySpeedRequest* _tmp59_;
	RygelPlaySpeed* _tmp60_;
	RygelPlaySpeed* _tmp61_;
	GError* _error_;
	SoupServer* _tmp62_;
	SoupMessage* _tmp63_;
	GError* _tmp64_;
	GError* _tmp65_;
	const gchar* _tmp66_;
	GError* _tmp67_;
	GError* _tmp68_;
	const gchar* _tmp69_;
	GError* _tmp70_;
	GError* _tmp71_;
	GError* _tmp72_;
	const gchar* _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp76_;
	RygelDTCPCleartextRequest* cleartext_seek;
	SoupMessage* _tmp77_;
	RygelHTTPGetHandler* _tmp78_;
	RygelDTCPCleartextRequest* _tmp79_;
	RygelDTCPCleartextRequest* _tmp80_;
	gint64 _tmp81_;
	gint64 _tmp82_;
	RygelDTCPCleartextRequest* _tmp83_;
	gint64 _tmp84_;
	gint64 _tmp85_;
	RygelDTCPCleartextRequest* _tmp86_;
	RygelHTTPSeekRequest* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	gboolean _tmp90_;
	RygelHTTPByteSeekRequest* byte_seek;
	SoupMessage* _tmp91_;
	RygelHTTPGetHandler* _tmp92_;
	RygelHTTPByteSeekRequest* _tmp93_;
	RygelHTTPByteSeekRequest* _tmp94_;
	gint64 _tmp95_;
	gint64 _tmp96_;
	RygelHTTPByteSeekRequest* _tmp97_;
	gint64 _tmp98_;
	gint64 _tmp99_;
	RygelHTTPByteSeekRequest* _tmp100_;
	RygelHTTPSeekRequest* _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	gboolean _tmp104_;
	RygelPlaySpeed* _tmp105_;
	RygelPlaySpeedRequest* _tmp106_;
	RygelPlaySpeedRequest* _tmp107_;
	RygelPlaySpeed* _tmp108_;
	RygelPlaySpeed* _tmp109_;
	RygelPlaySpeed* speed;
	RygelPlaySpeed* _tmp110_;
	RygelHTTPTimeSeekRequest* time_seek;
	SoupMessage* _tmp111_;
	RygelHTTPGetHandler* _tmp112_;
	RygelPlaySpeed* _tmp113_;
	RygelHTTPTimeSeekRequest* _tmp114_;
	RygelHTTPTimeSeekRequest* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	RygelHTTPTimeSeekRequest* _tmp118_;
	RygelHTTPSeekRequest* _tmp119_;
	GError* _vala1__error_;
	GError* _tmp120_;
	const gchar* _tmp121_;
	SoupServer* _tmp122_;
	SoupMessage* _tmp123_;
	GError* _tmp124_;
	gint _tmp125_;
	GError* _tmp126_;
	const gchar* _tmp127_;
	RygelHTTPGetHandler* _tmp128_;
	SoupMessage* _tmp129_;
	SoupMessageHeaders* _tmp130_;
	RygelHTTPServer* _tmp131_;
	const gchar* _tmp132_;
	const gchar* _tmp133_;
	RygelHTTPResponse* response;
	RygelHTTPGetHandler* _tmp134_;
	RygelHTTPResponse* _tmp135_;
	GeeList* responses;
	RygelHTTPResponse* _tmp136_;
	GeeList* _tmp137_;
	GeeList* _tmp138_;
	GeeList* _response_elem_list;
	GeeList* _tmp139_;
	GeeList* _tmp140_;
	gint _response_elem_size;
	GeeList* _tmp141_;
	gint _tmp142_;
	gint _tmp143_;
	gint _response_elem_index;
	gint _tmp144_;
	gint _tmp145_;
	gint _tmp146_;
	RygelHTTPResponseElement* response_elem;
	GeeList* _tmp147_;
	gint _tmp148_;
	gpointer _tmp149_;
	RygelHTTPResponseElement* _tmp150_;
	GError* _vala2__error_;
	GError* _tmp151_;
	const gchar* _tmp152_;
	SoupServer* _tmp153_;
	SoupMessage* _tmp154_;
	GError* _tmp155_;
	gint _tmp156_;
	GError* _tmp157_;
	const gchar* _tmp158_;
	gint64 response_size;
	SoupMessageHeaders* _tmp159_;
	gint64 _tmp160_;
	SoupMessageHeaders* _tmp161_;
	gint64 _tmp162_;
	gint64 _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	gchar* _tmp167_;
	RygelHTTPGetHandler* _tmp168_;
	gint64 _tmp169_;
	SoupMessageHeaders* _tmp170_;
	gint64 _tmp171_;
	gint64 _tmp172_;
	gchar* _tmp173_;
	gchar* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	SoupEncoding response_body_encoding;
	gboolean _tmp177_;
	RygelPlaySpeedRequest* _tmp178_;
	SoupMessage* _tmp179_;
	gint64 _tmp180_;
	SoupMessage* _tmp181_;
	SoupMessageHeaders* _tmp182_;
	SoupEncoding _tmp183_;
	gboolean supports_playspeed;
	gboolean _tmp184_;
	gboolean _tmp185_;
	gboolean _tmp186_;
	SoupMessage* _tmp187_;
	GString* vary_header;
	SoupMessageHeaders* _tmp188_;
	const gchar* _tmp189_;
	GString* _tmp190_;
	gboolean _tmp191_;
	GString* _tmp192_;
	gssize _tmp193_;
	GString* _tmp194_;
	GString* _tmp195_;
	gboolean _tmp196_;
	GString* _tmp197_;
	gssize _tmp198_;
	GString* _tmp199_;
	GString* _tmp200_;
	SoupMessage* _tmp201_;
	SoupMessageHeaders* _tmp202_;
	GString* _tmp203_;
	const gchar* _tmp204_;
	gint response_code;
	SoupMessage* _tmp205_;
	SoupMessageHeaders* _tmp206_;
	const gchar* _tmp207_;
	SoupMessage* _tmp208_;
	gint _tmp209_;
	SoupMessage* _tmp210_;
	SoupMessage* _tmp211_;
	SoupMessage* _tmp212_;
	SoupMessageHeaders* _tmp213_;
	SoupMessage* _tmp214_;
	SoupMessageHeaders* _tmp215_;
	SoupMessage* _tmp216_;
	gchar* _tmp217_;
	gchar* _tmp218_;
	gchar* _tmp219_;
	gboolean _tmp220_;
	SoupServer* _tmp221_;
	SoupMessage* _tmp222_;
	RygelHTTPResponse* _tmp223_;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server,
                                  SoupServer* server,
                                  SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type,
                                        RygelHTTPServer* http_server,
                                        SoupServer* server,
                                        SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type,
                                                RygelHTTPServer* http_server,
                                                SoupServer* server,
                                                SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle_async_ready_wrapper (GObject *source_object,
                                                     GAsyncResult *res,
                                                     void *user_data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_new (RygelMediaObject* media_object,
                                                                      const gchar* media_resource_name,
                                                                      GCancellable* cancellable,
                                                                      GError** error);
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_construct (GType object_type,
                                                                            RygelMediaObject* media_object,
                                                                            const gchar* media_resource_name,
                                                                            GCancellable* cancellable,
                                                                            GError** error);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
GType rygel_http_thumbnail_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item,
                                                             gint thumbnail_index,
                                                             GCancellable* cancellable,
                                                             GError** error);
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type,
                                                                   RygelMediaFileItem* media_item,
                                                                   gint thumbnail_index,
                                                                   GCancellable* cancellable,
                                                                   GError** error);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
GType rygel_http_subtitle_handler_get_type (void) G_GNUC_CONST;
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item,
                                                           gint subtitle_index,
                                                           GCancellable* cancellable,
                                                           GError** error);
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type,
                                                                 RygelMediaFileItem* media_item,
                                                                 gint subtitle_index,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self,
                                                        const gchar* mode);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void rygel_http_get_handle_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_);
void rygel_http_request_find_item (RygelHTTPRequest* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_client_hacks_apply (RygelClientHacks* self,
                               RygelMediaObject* object);
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static void rygel_http_get_handle_item_request_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_);
gboolean rygel_http_time_seek_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
gboolean rygel_http_time_seek_request_requested (SoupMessage* message);
gboolean rygel_http_byte_seek_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
gboolean rygel_http_byte_seek_request_requested (SoupMessage* msg);
gboolean rygel_dtcp_cleartext_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
gboolean rygel_dtcp_cleartext_request_requested (SoupMessage* message);
gboolean rygel_play_speed_request_requested (RygelHTTPGet* request);
GQuark rygel_play_speed_error_quark (void);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request,
                                                                  GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type,
                                                                        RygelHTTPGet* request,
                                                                        GError** error);
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void rygel_value_set_play_speed (GValue* value,
                                 gpointer v_object);
void rygel_value_take_play_speed (GValue* value,
                                  gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
gchar* rygel_play_speed_to_string (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
void rygel_http_request_end (RygelHTTPRequest* self,
                             guint status,
                             const gchar* reason);
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (SoupMessage* message,
                                                             RygelHTTPGetHandler* handler,
                                                             GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type,
                                                                   SoupMessage* message,
                                                                   RygelHTTPGetHandler* handler,
                                                                   GError** error);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (SoupMessage* msg,
                                                            RygelHTTPGetHandler* handler,
                                                            GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type,
                                                                  SoupMessage* msg,
                                                                  RygelHTTPGetHandler* handler,
                                                                  GError** error);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (SoupMessage* message,
                                                            RygelHTTPGetHandler* handler,
                                                            RygelPlaySpeed* speed,
                                                            GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type,
                                                                  SoupMessage* message,
                                                                  RygelHTTPGetHandler* handler,
                                                                  RygelPlaySpeed* speed,
                                                                  GError** error);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self,
                                                  RygelHTTPGet* request,
                                                  GError** error);
const gchar* rygel_http_server_get_server_name (RygelHTTPServer* self);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self,
                                                       RygelHTTPGet* request,
                                                       GError** error);
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GeeList* rygel_http_response_preroll (RygelHTTPResponse* self,
                                      GError** error);
void rygel_http_response_element_add_response_headers (RygelHTTPResponseElement* self,
                                                       RygelHTTPRequest* request);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request);
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
static void __lambda18_ (RygelHTTPGet* self,
                  const gchar* name,
                  const gchar* value);
static void ___lambda18__soup_message_headers_foreach_func (const gchar* name,
                                                     const gchar* value,
                                                     gpointer self);
static void rygel_http_get_handle_item_request_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void rygel_http_get_finalize (GObject * obj);


RygelHTTPGet*
rygel_http_get_construct (GType object_type,
                          RygelHTTPServer* http_server,
                          SoupServer* server,
                          SoupMessage* msg)
{
	RygelHTTPGet * self = NULL;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, http_server, server, msg);
	return self;
}


RygelHTTPGet*
rygel_http_get_new (RygelHTTPServer* http_server,
                    SoupServer* server,
                    SoupMessage* msg)
{
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
}


static void
rygel_http_get_real_handle_data_free (gpointer _data)
{
	RygelHttpGetHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleData, _data_);
}


static void
rygel_http_get_real_handle_async_ready_wrapper (GObject *source_object,
                                                GAsyncResult *res,
                                                void *user_data)
{
	RygelHttpGetHandleData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
rygel_http_get_real_handle (RygelHTTPRequest* base,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	RygelHTTPGet* _tmp0_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_http_get_real_handle_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_handle_co (_data_);
}


static void
rygel_http_get_real_handle_finish (RygelHTTPRequest* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	RygelHttpGetHandleData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static SoupMessageHeaders*
_vala_SoupMessageHeaders_copy (SoupMessageHeaders* self)
{
	return g_boxed_copy (soup_message_headers_get_type (), self);
}


static gpointer
__vala_SoupMessageHeaders_copy0 (gpointer self)
{
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}


static void
_vala_SoupMessageHeaders_free (SoupMessageHeaders* self)
{
	g_boxed_free (soup_message_headers_get_type (), self);
}


static void
rygel_http_get_handle_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	RygelHttpGetHandleData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_http_get_real_handle_co (_data_);
}


static gboolean
rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_object_get (_data_->_tmp1_, "method", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strcmp0 (_data_->_tmp4_, "HEAD") == 0;
	_g_free0 (_data_->_tmp4_);
	if (_data_->_tmp5_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
		g_object_get (_data_->_tmp6_, "method", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp9_, "GET") == 0;
		_g_free0 (_data_->_tmp9_);
	}
	if (!_data_->_tmp0_) {
		_data_->_tmp10_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ ("Invalid Request (only GET and HEAD supported)"));
		_data_->_inner_error_ = _data_->_tmp10_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp11_ = g_strdup ("getcontentFeatures.dlna.org");
		_data_->cf_header = _data_->_tmp11_;
		_data_->_tmp12_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp13_ = _data_->_tmp12_->request_headers;
		_data_->_tmp14_ = _data_->cf_header;
		_data_->_tmp15_ = soup_message_headers_get_one (_data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
		_data_->cf_val = _data_->_tmp16_;
		_data_->_tmp18_ = _data_->cf_val;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp19_ = _data_->cf_val;
			_data_->_tmp17_ = g_strcmp0 (_data_->_tmp19_, "1") != 0;
		} else {
			_data_->_tmp17_ = FALSE;
		}
		if (_data_->_tmp17_) {
			_data_->_tmp20_ = _data_->cf_header;
			_data_->_tmp21_ = g_strconcat (_data_->_tmp20_, " must be 1", NULL);
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ (_data_->_tmp22_));
			_data_->_tmp24_ = _data_->_tmp23_;
			_g_free0 (_data_->_tmp22_);
			_data_->_inner_error_ = _data_->_tmp24_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->cf_val);
			_g_free0 (_data_->cf_header);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->cf_val);
		_g_free0 (_data_->cf_header);
	}
	_data_->_tmp25_ = ((RygelHTTPRequest*) _data_->self)->uri;
	_data_->_tmp26_ = rygel_http_item_uri_get_resource_name (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	if (_data_->_tmp27_ != NULL) {
		_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp30_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp31_ = rygel_http_item_uri_get_resource_name (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = rygel_http_media_resource_handler_new (_data_->_tmp29_, _data_->_tmp32_, _data_->_tmp34_, &_data_->_inner_error_);
		_data_->_tmp28_ = _data_->_tmp35_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp36_ = _data_->_tmp28_;
		_data_->_tmp28_ = NULL;
		_g_object_unref0 (_data_->self->handler);
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp36_;
		_g_object_unref0 (_data_->_tmp28_);
	} else {
		_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp38_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp37_);
		_data_->_tmp39_ = _data_->_tmp38_;
		if (_data_->_tmp39_ >= 0) {
			_data_->_tmp41_ = ((RygelHTTPRequest*) _data_->self)->object;
			_data_->_tmp42_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp43_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp42_);
			_data_->_tmp44_ = _data_->_tmp43_;
			_data_->_tmp45_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp47_ = rygel_http_thumbnail_handler_new (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp41_) : NULL, _data_->_tmp44_, _data_->_tmp46_, &_data_->_inner_error_);
			_data_->_tmp40_ = _data_->_tmp47_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp48_ = _data_->_tmp40_;
			_data_->_tmp40_ = NULL;
			_g_object_unref0 (_data_->self->handler);
			_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp48_;
			_g_object_unref0 (_data_->_tmp40_);
		} else {
			_data_->_tmp49_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp50_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp49_);
			_data_->_tmp51_ = _data_->_tmp50_;
			if (_data_->_tmp51_ >= 0) {
				_data_->_tmp53_ = ((RygelHTTPRequest*) _data_->self)->object;
				_data_->_tmp54_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp55_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp54_);
				_data_->_tmp56_ = _data_->_tmp55_;
				_data_->_tmp57_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp58_ = _data_->_tmp57_;
				_data_->_tmp59_ = rygel_http_subtitle_handler_new (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp53_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp53_) : NULL, _data_->_tmp56_, _data_->_tmp58_, &_data_->_inner_error_);
				_data_->_tmp52_ = _data_->_tmp59_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp60_ = _data_->_tmp52_;
				_data_->_tmp52_ = NULL;
				_g_object_unref0 (_data_->self->handler);
				_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp60_;
				_g_object_unref0 (_data_->_tmp52_);
			} else {
				_data_->_tmp61_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp62_ = rygel_http_item_uri_to_string (_data_->_tmp61_);
				_data_->_tmp63_ = _data_->_tmp62_;
				_data_->_tmp64_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No handler found for '%s'", _data_->_tmp63_);
				_data_->_tmp65_ = _data_->_tmp64_;
				_g_free0 (_data_->_tmp63_);
				_data_->_inner_error_ = _data_->_tmp65_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	{
		_data_->_tmp66_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp67_ = _data_->_tmp66_->request_headers;
		_data_->_tmp68_ = __vala_SoupMessageHeaders_copy0 (_data_->_tmp67_);
		_data_->headers = _data_->_tmp68_;
		_data_->_tmp69_ = _data_->headers;
		_data_->_tmp70_ = soup_message_headers_get_one (_data_->_tmp69_, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
		_data_->_tmp71_ = g_strdup (_data_->_tmp70_);
		_data_->transfer_mode = _data_->_tmp71_;
		_data_->_tmp72_ = _data_->transfer_mode;
		if (_data_->_tmp72_ == NULL) {
			_data_->_tmp73_ = _data_->self->handler;
			_data_->_tmp74_ = rygel_http_get_handler_get_default_transfer_mode (_data_->_tmp73_);
			_g_free0 (_data_->transfer_mode);
			_data_->transfer_mode = _data_->_tmp74_;
		}
		_data_->_tmp75_ = _data_->self->handler;
		_data_->_tmp76_ = _data_->transfer_mode;
		if (!rygel_http_get_handler_supports_transfer_mode (_data_->_tmp75_, _data_->_tmp76_)) {
			_data_->_tmp77_ = g_strdup ("%s transfer mode not supported for '%s'");
			_data_->msg = _data_->_tmp77_;
			_data_->_tmp78_ = _data_->msg;
			_data_->_tmp79_ = _data_->transfer_mode;
			_data_->_tmp80_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp81_ = rygel_http_item_uri_to_string (_data_->_tmp80_);
			_data_->_tmp82_ = _data_->_tmp81_;
			_data_->_tmp83_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp78_, _data_->_tmp79_, _data_->_tmp82_);
			_data_->_tmp84_ = _data_->_tmp83_;
			_g_free0 (_data_->_tmp82_);
			_data_->_inner_error_ = _data_->_tmp84_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->msg);
			_g_free0 (_data_->transfer_mode);
			__vala_SoupMessageHeaders_free0 (_data_->headers);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->transfer_mode);
		__vala_SoupMessageHeaders_free0 (_data_->headers);
	}
	_data_->_state_ = 1;
	rygel_http_get_handle_item_request (_data_->self, rygel_http_get_handle_ready, _data_);
	return FALSE;
	_state_1:
	rygel_http_get_handle_item_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_http_get_real_find_item_data_free (gpointer _data)
{
	RygelHttpGetFindItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetFindItemData, _data_);
}


static void
rygel_http_get_real_find_item_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data)
{
	RygelHttpGetFindItemData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_http_get_real_find_item (RygelHTTPRequest* base,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	RygelHTTPGet* _tmp0_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_http_get_real_find_item_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_find_item_co (_data_);
}


static void
rygel_http_get_real_find_item_finish (RygelHTTPRequest* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	RygelHttpGetFindItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void
rygel_http_get_find_item_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	RygelHttpGetFindItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_http_get_real_find_item_co (_data_);
}


static gboolean
rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), rygel_http_get_find_item_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		_data_->_tmp3_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp4_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp3_) : NULL);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp1_ = _data_->_tmp5_;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (G_UNLIKELY (_data_->_tmp1_)) {
		_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp7_ = rygel_media_object_get_id (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", _data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp9_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = ((RygelHTTPRequest*) _data_->self)->hack;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->hack;
		_data_->_tmp12_ = ((RygelHTTPRequest*) _data_->self)->object;
		rygel_client_hacks_apply (_data_->_tmp11_, _data_->_tmp12_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_http_get_handle_item_request_data_free (gpointer _data)
{
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleItemRequestData, _data_);
}


static void
rygel_http_get_handle_item_request_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	RygelHttpGetHandleItemRequestData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_http_get_handle_item_request (RygelHTTPGet* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelHttpGetHandleItemRequestData* _data_;
	RygelHTTPGet* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_http_get_handle_item_request_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_handle_item_request_co (_data_);
}


static void
rygel_http_get_handle_item_request_finish (RygelHTTPGet* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}


static gpointer
_rygel_play_speed_ref0 (gpointer self)
{
	return self ? rygel_play_speed_ref (self) : NULL;
}


static void
__lambda18_ (RygelHTTPGet* self,
             const gchar* name,
             const gchar* value)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-http-get.vala:353:     %s : %s", name, value);
}


static void
___lambda18__soup_message_headers_foreach_func (const gchar* name,
                                                const gchar* value,
                                                gpointer self)
{
	__lambda18_ ((RygelHTTPGet*) self, name, value);
}


static void
rygel_http_get_handle_item_request_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_http_get_handle_item_request_co (_data_);
}


static gboolean
rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp1_ = _data_->self->handler;
	_data_->supports_time_seek = rygel_http_time_seek_request_supported (_data_->_tmp0_, _data_->_tmp1_);
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->requested_time_seek = rygel_http_time_seek_request_requested (_data_->_tmp2_);
	_data_->_tmp3_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp4_ = _data_->self->handler;
	_data_->supports_byte_seek = rygel_http_byte_seek_request_supported (_data_->_tmp3_, _data_->_tmp4_);
	_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->requested_byte_seek = rygel_http_byte_seek_request_requested (_data_->_tmp5_);
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp7_ = _data_->self->handler;
	_data_->supports_cleartext_seek = rygel_dtcp_cleartext_request_supported (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->requested_cleartext_seek = rygel_dtcp_cleartext_request_requested (_data_->_tmp8_);
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp10_ = _data_->_tmp9_->response_headers;
	_data_->_tmp11_ = __vala_SoupMessageHeaders_copy0 (_data_->_tmp10_);
	_data_->response_headers = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->requested_cleartext_seek;
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = _data_->supports_cleartext_seek;
		if (!_data_->_tmp13_) {
			_data_->_tmp14_ = g_strdup ("Cleartext seek not supported for %s");
			_data_->msg = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->msg;
			_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp17_ = rygel_http_item_uri_to_string (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp15_, _data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			_g_free0 (_data_->_tmp18_);
			_data_->_inner_error_ = _data_->_tmp20_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->msg);
			__vala_SoupMessageHeaders_free0 (_data_->response_headers);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp21_ = _data_->requested_byte_seek;
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = g_strdup ("Both Cleartext and Range seek requested for %s");
			_data_->_vala1_msg = _data_->_tmp22_;
			_data_->_tmp23_ = _data_->_vala1_msg;
			_data_->_tmp24_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp25_ = rygel_http_item_uri_to_string (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp23_, _data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			_g_free0 (_data_->_tmp26_);
			_data_->_inner_error_ = _data_->_tmp28_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->_vala1_msg);
			__vala_SoupMessageHeaders_free0 (_data_->response_headers);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp29_ = _data_->requested_byte_seek;
		if (_data_->_tmp29_) {
			_data_->_tmp30_ = _data_->supports_byte_seek;
			if (!_data_->_tmp30_) {
				_data_->_tmp31_ = g_strdup ("Byte seek not supported for %s");
				_data_->_vala2_msg = _data_->_tmp31_;
				_data_->_tmp32_ = _data_->_vala2_msg;
				_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp34_ = rygel_http_item_uri_to_string (_data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				_data_->_tmp36_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp32_, _data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				_g_free0 (_data_->_tmp35_);
				_data_->_inner_error_ = _data_->_tmp37_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_free0 (_data_->_vala2_msg);
				__vala_SoupMessageHeaders_free0 (_data_->response_headers);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			_data_->_tmp38_ = _data_->requested_time_seek;
			if (_data_->_tmp38_) {
				_data_->_tmp39_ = _data_->supports_time_seek;
				if (!_data_->_tmp39_) {
					_data_->_tmp40_ = g_strdup ("Time seek not supported for %s");
					_data_->_vala3_msg = _data_->_tmp40_;
					_data_->_tmp41_ = _data_->_vala3_msg;
					_data_->_tmp42_ = ((RygelHTTPRequest*) _data_->self)->uri;
					_data_->_tmp43_ = rygel_http_item_uri_to_string (_data_->_tmp42_);
					_data_->_tmp44_ = _data_->_tmp43_;
					_data_->_tmp45_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp41_, _data_->_tmp44_);
					_data_->_tmp46_ = _data_->_tmp45_;
					_g_free0 (_data_->_tmp44_);
					_data_->_inner_error_ = _data_->_tmp46_;
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
					_g_free0 (_data_->_vala3_msg);
					__vala_SoupMessageHeaders_free0 (_data_->response_headers);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	{
		_data_->_tmp49_ = _data_->requested_byte_seek;
		if (_data_->_tmp49_) {
			_data_->_tmp48_ = TRUE;
		} else {
			_data_->_tmp50_ = _data_->requested_cleartext_seek;
			_data_->_tmp48_ = _data_->_tmp50_;
		}
		if (!_data_->_tmp48_) {
			_data_->_tmp47_ = rygel_play_speed_request_requested (_data_->self);
		} else {
			_data_->_tmp47_ = FALSE;
		}
		if (_data_->_tmp47_) {
			_data_->_tmp52_ = rygel_play_speed_request_new_from_request (_data_->self, &_data_->_inner_error_);
			_data_->_tmp51_ = _data_->_tmp52_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
					goto __catch39_rygel_play_speed_error;
				}
				__vala_SoupMessageHeaders_free0 (_data_->response_headers);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp53_ = _data_->_tmp51_;
			_data_->_tmp51_ = NULL;
			_g_object_unref0 (_data_->self->speed_request);
			_data_->self->speed_request = _data_->_tmp53_;
			_data_->_tmp54_ = _data_->self->speed_request;
			_data_->_tmp55_ = rygel_play_speed_request_get_speed (_data_->_tmp54_);
			_data_->_tmp56_ = _data_->_tmp55_;
			_data_->_tmp57_ = rygel_play_speed_to_string (_data_->_tmp56_);
			_data_->_tmp58_ = _data_->_tmp57_;
			g_debug ("rygel-http-get.vala:171: Processing playspeed %s", _data_->_tmp58_);
			_g_free0 (_data_->_tmp58_);
			_data_->_tmp59_ = _data_->self->speed_request;
			_data_->_tmp60_ = rygel_play_speed_request_get_speed (_data_->_tmp59_);
			_data_->_tmp61_ = _data_->_tmp60_;
			if (rygel_play_speed_is_normal_rate (_data_->_tmp61_)) {
				_g_object_unref0 (_data_->self->speed_request);
				_data_->self->speed_request = NULL;
			}
			_g_object_unref0 (_data_->_tmp51_);
		} else {
			_g_object_unref0 (_data_->self->speed_request);
			_data_->self->speed_request = NULL;
		}
	}
	goto __finally39;
	__catch39_rygel_play_speed_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp62_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp63_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp62_, _data_->_tmp63_);
		_data_->_tmp64_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp64_, RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT)) {
			_data_->_tmp65_ = _data_->_error_;
			_data_->_tmp66_ = _data_->_tmp65_->message;
			rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_BAD_REQUEST, _data_->_tmp66_);
		} else {
			_data_->_tmp67_ = _data_->_error_;
			if (g_error_matches (_data_->_tmp67_, RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT)) {
				_data_->_tmp68_ = _data_->_error_;
				_data_->_tmp69_ = _data_->_tmp68_->message;
				rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NOT_ACCEPTABLE, _data_->_tmp69_);
			} else {
				_data_->_tmp70_ = _data_->_error_;
				_data_->_tmp71_ = _g_error_copy0 (_data_->_tmp70_);
				_data_->_inner_error_ = _data_->_tmp71_;
				_g_error_free0 (_data_->_error_);
				goto __finally39;
			}
		}
		_data_->_tmp72_ = _data_->_error_;
		_data_->_tmp73_ = _data_->_tmp72_->message;
		g_warning ("rygel-http-get.vala:191: Error processing PlaySpeed: %s", _data_->_tmp73_);
		_g_error_free0 (_data_->_error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally39:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp75_ = _data_->supports_cleartext_seek;
		if (_data_->_tmp75_) {
			_data_->_tmp76_ = _data_->requested_cleartext_seek;
			_data_->_tmp74_ = _data_->_tmp76_;
		} else {
			_data_->_tmp74_ = FALSE;
		}
		if (_data_->_tmp74_) {
			_data_->_tmp77_ = ((RygelHTTPRequest*) _data_->self)->msg;
			_data_->_tmp78_ = _data_->self->handler;
			_data_->_tmp79_ = rygel_dtcp_cleartext_request_new (_data_->_tmp77_, _data_->_tmp78_, &_data_->_inner_error_);
			_data_->cleartext_seek = _data_->_tmp79_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					goto __catch40_rygel_http_seek_request_error;
				}
				goto __finally40;
			}
			_data_->_tmp80_ = _data_->cleartext_seek;
			_data_->_tmp81_ = rygel_dtcp_cleartext_request_get_start_byte (_data_->_tmp80_);
			_data_->_tmp82_ = _data_->_tmp81_;
			_data_->_tmp83_ = _data_->cleartext_seek;
			_data_->_tmp84_ = rygel_dtcp_cleartext_request_get_end_byte (_data_->_tmp83_);
			_data_->_tmp85_ = _data_->_tmp84_;
			g_debug ("rygel-http-get.vala:200: Processing DTCP cleartext byte range request " \
"(bytes %lld to %lld)", _data_->_tmp82_, _data_->_tmp85_);
			_data_->_tmp86_ = _data_->cleartext_seek;
			_data_->_tmp87_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp86_);
			_g_object_unref0 (_data_->self->seek);
			_data_->self->seek = _data_->_tmp87_;
			_g_object_unref0 (_data_->cleartext_seek);
		} else {
			_data_->_tmp89_ = _data_->supports_byte_seek;
			if (_data_->_tmp89_) {
				_data_->_tmp90_ = _data_->requested_byte_seek;
				_data_->_tmp88_ = _data_->_tmp90_;
			} else {
				_data_->_tmp88_ = FALSE;
			}
			if (_data_->_tmp88_) {
				_data_->_tmp91_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp92_ = _data_->self->handler;
				_data_->_tmp93_ = rygel_http_byte_seek_request_new (_data_->_tmp91_, _data_->_tmp92_, &_data_->_inner_error_);
				_data_->byte_seek = _data_->_tmp93_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						goto __catch40_rygel_http_seek_request_error;
					}
					goto __finally40;
				}
				_data_->_tmp94_ = _data_->byte_seek;
				_data_->_tmp95_ = rygel_http_byte_seek_request_get_start_byte (_data_->_tmp94_);
				_data_->_tmp96_ = _data_->_tmp95_;
				_data_->_tmp97_ = _data_->byte_seek;
				_data_->_tmp98_ = rygel_http_byte_seek_request_get_end_byte (_data_->_tmp97_);
				_data_->_tmp99_ = _data_->_tmp98_;
				g_debug ("rygel-http-get.vala:205: Processing byte range request (bytes %lld to " \
"%lld)", _data_->_tmp96_, _data_->_tmp99_);
				_data_->_tmp100_ = _data_->byte_seek;
				_data_->_tmp101_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp100_);
				_g_object_unref0 (_data_->self->seek);
				_data_->self->seek = _data_->_tmp101_;
				_g_object_unref0 (_data_->byte_seek);
			} else {
				_data_->_tmp103_ = _data_->supports_time_seek;
				if (_data_->_tmp103_) {
					_data_->_tmp104_ = _data_->requested_time_seek;
					_data_->_tmp102_ = _data_->_tmp104_;
				} else {
					_data_->_tmp102_ = FALSE;
				}
				if (_data_->_tmp102_) {
					_data_->_tmp106_ = _data_->self->speed_request;
					if (_data_->_tmp106_ == NULL) {
						_data_->_tmp105_ = NULL;
					} else {
						_data_->_tmp107_ = _data_->self->speed_request;
						_data_->_tmp108_ = rygel_play_speed_request_get_speed (_data_->_tmp107_);
						_data_->_tmp109_ = _data_->_tmp108_;
						_data_->_tmp105_ = _data_->_tmp109_;
					}
					_data_->_tmp110_ = _rygel_play_speed_ref0 (_data_->_tmp105_);
					_data_->speed = _data_->_tmp110_;
					_data_->_tmp111_ = ((RygelHTTPRequest*) _data_->self)->msg;
					_data_->_tmp112_ = _data_->self->handler;
					_data_->_tmp113_ = _data_->speed;
					_data_->_tmp114_ = rygel_http_time_seek_request_new (_data_->_tmp111_, _data_->_tmp112_, _data_->_tmp113_, &_data_->_inner_error_);
					_data_->time_seek = _data_->_tmp114_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_rygel_play_speed_unref0 (_data_->speed);
						if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
							goto __catch40_rygel_http_seek_request_error;
						}
						_rygel_play_speed_unref0 (_data_->speed);
						__vala_SoupMessageHeaders_free0 (_data_->response_headers);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp115_ = _data_->time_seek;
					_data_->_tmp116_ = rygel_http_time_seek_request_to_string (_data_->_tmp115_);
					_data_->_tmp117_ = _data_->_tmp116_;
					g_debug ("rygel-http-get.vala:214: Processing time seek %s", _data_->_tmp117_);
					_g_free0 (_data_->_tmp117_);
					_data_->_tmp118_ = _data_->time_seek;
					_data_->_tmp119_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp118_);
					_g_object_unref0 (_data_->self->seek);
					_data_->self->seek = _data_->_tmp119_;
					_g_object_unref0 (_data_->time_seek);
					_rygel_play_speed_unref0 (_data_->speed);
				} else {
					_g_object_unref0 (_data_->self->seek);
					_data_->self->seek = NULL;
				}
			}
		}
	}
	goto __finally40;
	__catch40_rygel_http_seek_request_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp120_ = _data_->_vala1__error_;
		_data_->_tmp121_ = _data_->_tmp120_->message;
		g_warning ("rygel-http-get.vala:220: Caught HTTPSeekRequestError: %s", _data_->_tmp121_);
		_data_->_tmp122_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp123_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp122_, _data_->_tmp123_);
		_data_->_tmp124_ = _data_->_vala1__error_;
		_data_->_tmp125_ = _data_->_tmp124_->code;
		_data_->_tmp126_ = _data_->_vala1__error_;
		_data_->_tmp127_ = _data_->_tmp126_->message;
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) _data_->_tmp125_, _data_->_tmp127_);
		_g_error_free0 (_data_->_vala1__error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally40:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp128_ = _data_->self->handler;
	rygel_http_get_handler_add_response_headers (_data_->_tmp128_, _data_->self, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp129_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp130_ = _data_->_tmp129_->response_headers;
	_data_->_tmp131_ = ((RygelHTTPRequest*) _data_->self)->http_server;
	_data_->_tmp132_ = rygel_http_server_get_server_name (_data_->_tmp131_);
	_data_->_tmp133_ = _data_->_tmp132_;
	soup_message_headers_append (_data_->_tmp130_, "Server", _data_->_tmp133_);
	_data_->_tmp134_ = _data_->self->handler;
	_data_->_tmp135_ = rygel_http_get_handler_render_body (_data_->_tmp134_, _data_->self, &_data_->_inner_error_);
	_data_->response = _data_->_tmp135_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp136_ = _data_->response;
		_data_->_tmp137_ = rygel_http_response_preroll (_data_->_tmp136_, &_data_->_inner_error_);
		_data_->responses = _data_->_tmp137_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				goto __catch41_rygel_http_seek_request_error;
			}
			goto __finally41;
		}
		_data_->_tmp138_ = _data_->responses;
		if (_data_->_tmp138_ != NULL) {
			{
				_data_->_tmp139_ = _data_->responses;
				_data_->_tmp140_ = _g_object_ref0 (_data_->_tmp139_);
				_data_->_response_elem_list = _data_->_tmp140_;
				_data_->_tmp141_ = _data_->_response_elem_list;
				_data_->_tmp142_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp141_);
				_data_->_tmp143_ = _data_->_tmp142_;
				_data_->_response_elem_size = _data_->_tmp143_;
				_data_->_response_elem_index = -1;
				while (TRUE) {
					_data_->_tmp144_ = _data_->_response_elem_index;
					_data_->_response_elem_index = _data_->_tmp144_ + 1;
					_data_->_tmp145_ = _data_->_response_elem_index;
					_data_->_tmp146_ = _data_->_response_elem_size;
					if (!(_data_->_tmp145_ < _data_->_tmp146_)) {
						break;
					}
					_data_->_tmp147_ = _data_->_response_elem_list;
					_data_->_tmp148_ = _data_->_response_elem_index;
					_data_->_tmp149_ = gee_list_get (_data_->_tmp147_, _data_->_tmp148_);
					_data_->response_elem = (RygelHTTPResponseElement*) _data_->_tmp149_;
					_data_->_tmp150_ = _data_->response_elem;
					rygel_http_response_element_add_response_headers (_data_->_tmp150_, (RygelHTTPRequest*) _data_->self);
					_g_object_unref0 (_data_->response_elem);
				}
				_g_object_unref0 (_data_->_response_elem_list);
			}
		}
		_g_object_unref0 (_data_->responses);
	}
	goto __finally41;
	__catch41_rygel_http_seek_request_error:
	{
		_data_->_vala2__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp151_ = _data_->_vala2__error_;
		_data_->_tmp152_ = _data_->_tmp151_->message;
		g_warning ("rygel-http-get.vala:246: Caught HTTPSeekRequestError on preroll: %s", _data_->_tmp152_);
		_data_->_tmp153_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp154_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp153_, _data_->_tmp154_);
		_data_->_tmp155_ = _data_->_vala2__error_;
		_data_->_tmp156_ = _data_->_tmp155_->code;
		_data_->_tmp157_ = _data_->_vala2__error_;
		_data_->_tmp158_ = _data_->_tmp157_->message;
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) _data_->_tmp156_, _data_->_tmp158_);
		_g_error_free0 (_data_->_vala2__error_);
		_g_object_unref0 (_data_->response);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally41:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->response);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp159_ = _data_->response_headers;
		_data_->response_size = soup_message_headers_get_content_length (_data_->_tmp159_);
		_data_->_tmp160_ = _data_->response_size;
		if (_data_->_tmp160_ > ((gint64) 0)) {
			_data_->_tmp161_ = _data_->response_headers;
			_data_->_tmp162_ = _data_->response_size;
			soup_message_headers_set_content_length (_data_->_tmp161_, _data_->_tmp162_);
			_data_->_tmp163_ = _data_->response_size;
			_data_->_tmp164_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp163_);
			_data_->_tmp165_ = _data_->_tmp164_;
			_data_->_tmp166_ = g_strconcat ("Response size set via response element: size ", _data_->_tmp165_, NULL);
			_data_->_tmp167_ = _data_->_tmp166_;
			g_debug ("rygel-http-get.vala:264: %s", _data_->_tmp167_);
			_g_free0 (_data_->_tmp167_);
			_g_free0 (_data_->_tmp165_);
		} else {
			_data_->_tmp168_ = _data_->self->handler;
			_data_->response_size = rygel_http_get_handler_get_resource_size (_data_->_tmp168_);
			_data_->_tmp169_ = _data_->response_size;
			if (_data_->_tmp169_ > ((gint64) 0)) {
				_data_->_tmp170_ = _data_->response_headers;
				_data_->_tmp171_ = _data_->response_size;
				soup_message_headers_set_content_length (_data_->_tmp170_, _data_->_tmp171_);
				_data_->_tmp172_ = _data_->response_size;
				_data_->_tmp173_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp172_);
				_data_->_tmp174_ = _data_->_tmp173_;
				_data_->_tmp175_ = g_strconcat ("Response size set via response element: size ", _data_->_tmp174_, NULL);
				_data_->_tmp176_ = _data_->_tmp175_;
				g_debug ("rygel-http-get.vala:271: %s", _data_->_tmp176_);
				_g_free0 (_data_->_tmp176_);
				_g_free0 (_data_->_tmp174_);
			} else {
				g_debug ("rygel-http-get.vala:274: Response size unknown");
			}
		}
	}
	{
		_data_->_tmp178_ = _data_->self->speed_request;
		if (_data_->_tmp178_ != NULL) {
			_data_->_tmp179_ = ((RygelHTTPRequest*) _data_->self)->msg;
			_data_->_tmp177_ = soup_message_get_http_version (_data_->_tmp179_) != SOUP_HTTP_1_0;
		} else {
			_data_->_tmp177_ = FALSE;
		}
		if (_data_->_tmp177_) {
			_data_->response_body_encoding = SOUP_ENCODING_CHUNKED;
			g_debug ("rygel-http-get.vala:289: Response encoding set to CHUNKED");
		} else {
			_data_->_tmp180_ = _data_->response_size;
			if (_data_->_tmp180_ > ((gint64) 0)) {
				_data_->response_body_encoding = SOUP_ENCODING_CONTENT_LENGTH;
				g_debug ("rygel-http-get.vala:293: Response encoding set to CONTENT-LENGTH");
			} else {
				_data_->_tmp181_ = ((RygelHTTPRequest*) _data_->self)->msg;
				if (soup_message_get_http_version (_data_->_tmp181_) == SOUP_HTTP_1_0) {
					_data_->response_body_encoding = SOUP_ENCODING_EOF;
					g_debug ("rygel-http-get.vala:298: Response encoding set to EOF");
				} else {
					_data_->response_body_encoding = SOUP_ENCODING_CHUNKED;
					g_debug ("rygel-http-get.vala:301: Response encoding set to CHUNKED");
				}
			}
		}
		_data_->_tmp182_ = _data_->response_headers;
		_data_->_tmp183_ = _data_->response_body_encoding;
		soup_message_headers_set_encoding (_data_->_tmp182_, _data_->_tmp183_);
	}
	{
		_data_->supports_playspeed = rygel_play_speed_request_supported (_data_->self);
		_data_->_tmp185_ = _data_->supports_time_seek;
		if (_data_->_tmp185_) {
			_data_->_tmp184_ = TRUE;
		} else {
			_data_->_tmp186_ = _data_->supports_playspeed;
			_data_->_tmp184_ = _data_->_tmp186_;
		}
		if (_data_->_tmp184_) {
			_data_->_tmp187_ = ((RygelHTTPRequest*) _data_->self)->msg;
			if (soup_message_get_http_version (_data_->_tmp187_) != SOUP_HTTP_1_0) {
				_data_->_tmp188_ = _data_->response_headers;
				_data_->_tmp189_ = soup_message_headers_get_list (_data_->_tmp188_, "Vary");
				_data_->_tmp190_ = g_string_new (_data_->_tmp189_);
				_data_->vary_header = _data_->_tmp190_;
				_data_->_tmp191_ = _data_->supports_time_seek;
				if (_data_->_tmp191_) {
					_data_->_tmp192_ = _data_->vary_header;
					_data_->_tmp193_ = _data_->_tmp192_->len;
					if (_data_->_tmp193_ > ((gssize) 0)) {
						_data_->_tmp194_ = _data_->vary_header;
						g_string_append (_data_->_tmp194_, ",");
					}
					_data_->_tmp195_ = _data_->vary_header;
					g_string_append (_data_->_tmp195_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
				}
				_data_->_tmp196_ = _data_->supports_playspeed;
				if (_data_->_tmp196_) {
					_data_->_tmp197_ = _data_->vary_header;
					_data_->_tmp198_ = _data_->_tmp197_->len;
					if (_data_->_tmp198_ > ((gssize) 0)) {
						_data_->_tmp199_ = _data_->vary_header;
						g_string_append (_data_->_tmp199_, ",");
					}
					_data_->_tmp200_ = _data_->vary_header;
					g_string_append (_data_->_tmp200_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
				}
				_data_->_tmp201_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp202_ = _data_->_tmp201_->response_headers;
				_data_->_tmp203_ = _data_->vary_header;
				_data_->_tmp204_ = _data_->_tmp203_->str;
				soup_message_headers_replace (_data_->_tmp202_, "Vary", _data_->_tmp204_);
				_g_string_free0 (_data_->vary_header);
			}
		}
	}
	{
		_data_->_tmp205_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp206_ = _data_->_tmp205_->response_headers;
		_data_->_tmp207_ = soup_message_headers_get_one (_data_->_tmp206_, "Content-Range");
		if (_data_->_tmp207_ != NULL) {
			_data_->response_code = (gint) SOUP_STATUS_PARTIAL_CONTENT;
		} else {
			_data_->response_code = (gint) SOUP_STATUS_OK;
		}
		_data_->_tmp208_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp209_ = _data_->response_code;
		soup_message_set_status (_data_->_tmp208_, (guint) _data_->_tmp209_);
	}
	_data_->_tmp210_ = ((RygelHTTPRequest*) _data_->self)->msg;
	if (soup_message_get_http_version (_data_->_tmp210_) == SOUP_HTTP_1_0) {
		_data_->_tmp211_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_message_set_http_version (_data_->_tmp211_, SOUP_HTTP_1_1);
		_data_->_tmp212_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp213_ = _data_->_tmp212_->response_headers;
		soup_message_headers_append (_data_->_tmp213_, "Connection", "close");
	}
	g_debug ("rygel-http-get.vala:351: Following HTTP headers appended to response:");
	_data_->_tmp214_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp215_ = _data_->_tmp214_->response_headers;
	soup_message_headers_foreach (_data_->_tmp215_, ___lambda18__soup_message_headers_foreach_func, _data_->self);
	_data_->_tmp216_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_object_get (_data_->_tmp216_, "method", &_data_->_tmp217_, NULL);
	_data_->_tmp218_ = _data_->_tmp217_;
	_data_->_tmp219_ = _data_->_tmp218_;
	_data_->_tmp220_ = g_strcmp0 (_data_->_tmp219_, "HEAD") == 0;
	_g_free0 (_data_->_tmp219_);
	if (_data_->_tmp220_) {
		_data_->_tmp221_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp222_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp221_, _data_->_tmp222_);
		_g_object_unref0 (_data_->response);
		__vala_SoupMessageHeaders_free0 (_data_->response_headers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp223_ = _data_->response;
	_data_->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp223_, rygel_http_get_handle_item_request_ready, _data_);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp223_, _data_->_res_);
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NONE, NULL);
	_g_object_unref0 (_data_->response);
	__vala_SoupMessageHeaders_free0 (_data_->response_headers);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_http_get_class_init (RygelHTTPGetClass * klass)
{
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	((RygelHTTPRequestClass *) klass)->handle = (void (*) (RygelHTTPRequest *, GAsyncReadyCallback, gpointer)) rygel_http_get_real_handle;
	((RygelHTTPRequestClass *) klass)->handle_finish = (void (*) (RygelHTTPRequest *, GAsyncResult*, GError**)) rygel_http_get_real_handle_finish;
	((RygelHTTPRequestClass *) klass)->find_item = (void (*) (RygelHTTPRequest *, GAsyncReadyCallback, gpointer)) rygel_http_get_real_find_item;
	((RygelHTTPRequestClass *) klass)->find_item_finish = (void (*) (RygelHTTPRequest *, GAsyncResult*, GError**)) rygel_http_get_real_find_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void
rygel_http_get_instance_init (RygelHTTPGet * self)
{
}


static void
rygel_http_get_finalize (GObject * obj)
{
	RygelHTTPGet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
	_g_object_unref0 (self->seek);
	_g_object_unref0 (self->speed_request);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType
rygel_http_get_get_type (void)
{
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



