﻿
# game/tutorial_quickstart.rpy:28
translate russian tutorial_create_27048c11:

    # e "When you're ready to use Ren'Py to create your visual novel, the first step is to create a new project."
    e "Когда вы будете готовы начать создание вашей визуальной новеллы, первым вашим шагом станет создание нового проекта."

# game/tutorial_quickstart.rpy:30
translate russian tutorial_create_bae6289c:

    # e "You can create a new project by clicking 'Create New Project' on the front screen of the launcher."
    e "Вы можете создать новый проект, кликнув на 'Добавить новый проект' на главном экране лаунчера."

# game/tutorial_quickstart.rpy:32
translate russian tutorial_create_45915fcb:

    # e "If this is your first time using Ren'Py, it'll ask you for the place you want to keep your projects. The best place is always somewhere that's frequently backed up."
    e "Если вы в первый раз запускаете Ren'Py, то вас спросят, где вы будете держать ваши проекты. Лучше всего держать проекты на облачных дисках, где они постоянно будут сохраняться."

# game/tutorial_quickstart.rpy:36
translate russian tutorial_create_55e30cb5:

    # e "After that, Ren'Py will ask for a name for your project. You'll have to stick to English letters and numbers, as zip files can't handle anything more than that."
    e "После этого Ren'Py спросит вас об имени вашего проекта. Вам придётся ограничиться английскими буквами и цифрами, так как zip-архивы не способны понять русский язык."

# game/tutorial_quickstart.rpy:40
translate russian tutorial_create_dea3e5c2:

    # e "The next thing Ren'Py will ask for is the resolution the visual novel will run at. This controls how large or small you'll have to make your game's artwork."
    e "Далее Ren'Py спросит разрешение вашей визуальной новеллы. Разрешение говорит о том, на какой размер фонов, спрайтов, CG и других изображений вы должны ориентироваться."

# game/tutorial_quickstart.rpy:44
translate russian tutorial_create_3289ea75:

    # e "Finally, Ren'Py will ask you to select a color scheme. You can change this after the game has been created, so just pick a color that's pleasing."
    e "И наконец, Ren'Py попросит вас выбрать цветовую схему. Вы сможете изменить её после создания игры, так что выберите любую понравившуюся композицию."

# game/tutorial_quickstart.rpy:48
translate russian tutorial_create_6b9e3b96:

    # e "Once that's done, Ren'Py will work for a bit and return you to the main menu with the new project selected. Now, when you click Launch, Ren'Py will start your new game."
    e "Как только с этим будет покончено, Ren'Py сгенерирует проект и вернёт вас в главное меню, новый проект будет автоматически выбран. Теперь, кликнув на 'Запустить проект', Ren'Py запустит вашу новую игру."

# game/tutorial_quickstart.rpy:50
translate russian tutorial_create_bdf94f9b:

    # e "To get back here, you can choose 'Tutorial' to switch to this tutorial game."
    e "Чтобы снова посмотреть обучение, можете выбрать 'Обучение' и таким образом вы переключитесь на проект обучения."

# game/tutorial_quickstart.rpy:52
translate russian tutorial_create_22f516df:

    # e "You'll also need to edit the games script to make changes. To do that, click 'script.rpy' on the front page of the launcher."
    e "Также, чтобы сделать свою игру, вам понадобится отредактировать её скрипт. Чтобы сделать это, кликните на 'script.rpy' в окне проекта."

# game/tutorial_quickstart.rpy:54
translate russian tutorial_create_18cd1d9d:

    # e "If it's your first time doing so, Ren'Py will ask you to select a text editor. Editra might be a safe choice, but read the descriptions to be sure."
    e "Если это ваш первый раз, Ren'Py попросит вас выбрать текстовый редактор. Editra — вполне безопасный выбор, но перед выбором внимательно прочитайте описания или же используйте собственный редактор."

# game/tutorial_quickstart.rpy:56
translate russian tutorial_create_bfbd6220:

    # e "After the text editor is downloaded, the script will open up and you can start to change what characters are saying."
    e "После того как текстовый редактор загрузится, скрипт откроется, и вы сможете начать изменять то, что говорят персонажи."

# game/tutorial_quickstart.rpy:69
translate russian tutorial_dialogue_112ff505:

    # e "Probably the most common thing a creator does with Ren'Py is to write dialogue for the player to read."
    e "Наверное, самая распространённая для разработчиков вещь в Ren'Py — написание диалогов."

# game/tutorial_quickstart.rpy:71
translate russian tutorial_dialogue_be2be31a:

    # e "But before I can show you how to write dialogue, let me show you how we present script examples."
    e "Но прежде чем я покажу вам, как писать диалог, давайте я сначала покажу, как мы показываем примеры скрипта."

# game/tutorial_quickstart.rpy:74
translate russian tutorial_dialogue_7b6be28e:

    # "Eileen" "Examples will show up in a window like the one above. You'll need to click outside of the example window in order to advance the tutorial."
    "Эйлин" "Примеры показываются так же, как и в окне выше. Для того чтобы продолжить обучение, вам нужно кликнуть за границы этого окна."

# game/tutorial_quickstart.rpy:76
translate russian tutorial_dialogue_5269d005:

    # "Eileen" "When an example is bigger than the screen, you can scroll around in it using the mouse wheel or by simply dragging the mouse."
    "Эйлин" "Когда пример оказывается больше экрана, вы можете прокручивать его при помощи колеса мыши или просто перетаскивая мышкой."

# game/tutorial_quickstart.rpy:78
translate russian tutorial_dialogue_241c0c74:

    # "Eileen" "Script might seem scary at first, but if you look you'll see it's easy to match it up to what I'm saying."
    "Эйлин" "С непривычки скрипт может показаться пугающим, но если вы присмотритесь, то увидете, как просто обозначено то, что я говорю."

# game/tutorial_quickstart.rpy:82
translate russian tutorial_dialogue_f0d66410:

    # e "Let's see the simplest possible Ren'Py game."
    e "Давайте поиграем в самую простейшую игру на Ren'Py."

# game/tutorial_quickstart.rpy:89
translate russian tutorial_dialogue_3e6b0068:

    # "Wow, It's really really dark in here."
    "Ого, здесь очень темно."

# game/tutorial_quickstart.rpy:91
translate russian tutorial_dialogue_5072a404:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Люси" "Берегитесь, а то вас съест Грю."

# game/tutorial_quickstart.rpy:99
translate russian tutorial_dialogue_d39d1b2b:

    # e "I'll show you the script of that example."
    e "Я покажу вам код этого примера."

# game/tutorial_quickstart.rpy:101
translate russian tutorial_dialogue_f51ecf1f:

    # e "This script demonstrates two kinds of Ren'Py statements, labels and say statements."
    e "Этот код демонстрирует два вида операторов Ren'Py: метки и операторы речи."

# game/tutorial_quickstart.rpy:103
translate russian tutorial_dialogue_bc7ec147:

    # e "The first line is a label statement. The label statement is used to give a name to a place in the program."
    e "Первая строка — метка. Она используются для именования определённых мест в программе."

# game/tutorial_quickstart.rpy:105
translate russian tutorial_dialogue_b20db833:

    # e "In this case, we're naming a place \"start\". The start label is special, as it marks the place a game begins running."
    e "В данном случае мы назвали место \"start\". Метка start — особенная, она отмечает место, где начинается игра."

# game/tutorial_quickstart.rpy:107
translate russian tutorial_dialogue_b0afbe96:

    # e "The next line is a simple say statement. It consists of a string beginning with a double-quote, and ending at the next double-quote."
    e "Следующая строка — простой оператор речи. Он состоит из текста, заключённого в двойные кавычки."

# game/tutorial_quickstart.rpy:109
translate russian tutorial_dialogue_628c9e4c:

    # e "Special characters in strings can be escaped with a backslash. To include \" in a string, we have to write \\\"."
    e "Особые знаки можно экранировать с помощью обратного слеша. Чтобы включить \" в строку, мы пишем \\\"."

# game/tutorial_quickstart.rpy:116
translate russian tutorial_dialogue_3e6b0068_1:

    # "Wow, It's really really dark in here."
    "Ого, здесь очень темно."

# game/tutorial_quickstart.rpy:125
translate russian tutorial_dialogue_d7f0b5b7:

    # e "When Ren'Py sees a single string on a line by itself, it uses the narrator to say that string. So a single string can be used to express a character's thoughts."
    e "Когда Ren'Py видит на строке кода чистую строку текста, он показывает её как слова рассказчика. Её можно также использовать для мыслей персонажа."

# game/tutorial_quickstart.rpy:131
translate russian tutorial_dialogue_5072a404_1:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Люси" "Берегитесь, а то вас съест Грю."

# game/tutorial_quickstart.rpy:139
translate russian tutorial_dialogue_9dd2d543:

    # e "When we have two strings separated by a space, the first is used as the character's name, and the second is what the character is saying."
    e "Когда два выражения в кавычках разделяет пробел, первое из них служит именем персонажа, а второе — его словами."

# game/tutorial_quickstart.rpy:141
translate russian tutorial_dialogue_64ffe685:

    # e "This two-argument form of the say statement is used for dialogue, where a character is speaking out loud."
    e "Эта форма оператора речи используется для диалога, то есть для речи персонажа."

# game/tutorial_quickstart.rpy:143
translate russian tutorial_dialogue_97a33275:

    # e "If you'd like, you can run this game yourself by erasing everything in your project's script.rpy file, and replacing it with the code in the box above."
    e "Если хотите, можете сами запустить эту игру, заменив всё в своём файле script.rpy на код, находящийся в окне сверху."

# game/tutorial_quickstart.rpy:145
translate russian tutorial_dialogue_c5e70d7e:

    # e "Be sure to preserve the spacing before lines. That's known as indentation, and it's used to help Ren'Py group lines of script into blocks."
    e "Убедитесь, что сохраняете пробелы перед строками. Такой отступ называется индентацией и помогает Ren'Py группировать отдельные строки кода в блоки."

# game/tutorial_quickstart.rpy:149
translate russian tutorial_dialogue_90719f73:

    # e "Using a string for a character's name is inconvenient, for two reasons."
    e "Однако использование такого выражения для показа имени персонажа неудобно по целым двум причинам."

# game/tutorial_quickstart.rpy:151
translate russian tutorial_dialogue_910f286a:

    # e "The first is that's it's a bit verbose. While typing \"Lucy\" isn't so bad, imagine if you had to type \"Eileen Richardson\" thousands of times."
    e "Первая состоит в том, что это долго печатать. Нет, конечно, напечатать \"Люси\" не так сложно, но представьте, что вам нужно набрать \"Эйлин Ричардсон\" несколько тысяч раз."

# game/tutorial_quickstart.rpy:153
translate russian tutorial_dialogue_9c9d59c2:

    # e "The second is that it doesn't leave any place to put styling, which can change the look of a character."
    e "Вторая причина — такой подход не позволяет вам использовать стили, изменяющие уникальность персонажа."

# game/tutorial_quickstart.rpy:155
translate russian tutorial_dialogue_2a2d1e51:

    # e "To solve these problems, Ren'Py lets you define Characters."
    e "Для решения этих проблем Ren'Py позволяет объявлять объекты-персонажи."

# game/tutorial_quickstart.rpy:159
translate russian tutorial_dialogue_16e8c5fd:

    # e "Here's an example Character definition. It begins with the word \"define\". That tells Ren'Py that we are defining something."
    e "Вот пример такого объекта-персонажа. Он начинается со слова \"define\", которое показывает Ren'Py, что мы хотим что-то определить."

# game/tutorial_quickstart.rpy:161
translate russian tutorial_dialogue_34fe5aa0:

    # e "Define is followed by a short name for the character, like \"l\". We'll be able to use that short name when writing dialogue."
    e "После этого слова следует короткое имя персонажа, например, \"l\". Позднее мы сможем использовать это короткое имя при написании диалога."

# game/tutorial_quickstart.rpy:163
translate russian tutorial_dialogue_67f90201:

    # e "This is followed by an equals sign, and the thing that we're defining. In this case, it's a Character."
    e "Затем идёт знак равенства и то, что мы определяем. В нашем случае это персонаж (Character)."

# game/tutorial_quickstart.rpy:165
translate russian tutorial_dialogue_4e454a89:

    # e "On the first line, the character's name is given to be \"Lucy\", and her name will be drawn a reddish color."
    e "На первой строке мы говорим, что имя персонажа — \"Люси\", и то, что имя должно быть розового цвета."

# game/tutorial_quickstart.rpy:167
translate russian tutorial_dialogue_db11f026:

    # e "These short names are case-sensitive. Capital L is a different name from lower-case l, so you'll need to be careful about that."
    e "Эти короткие имена регистрозависимы. Буква L и буква l отличны друг от друга, так что вам нужно вести себя с ними осторожно."

# game/tutorial_quickstart.rpy:171
translate russian tutorial_dialogue_1d161320:

    # e "Now that we have a character defined, we can use it to say dialogue."
    e "Теперь, когда у нас есть определение персонажа, мы можем использовать его для диалога."

# game/tutorial_quickstart.rpy:178
translate russian tutorial_dialogue_3710169c:

    # l "Why are you trying to put words into my mouth? And who are you calling \"it\"?"
    l "Почему ты засовываешь мне в рот слова? И кого ты называешь \"он\"?"

# game/tutorial_quickstart.rpy:180
translate russian tutorial_dialogue_6d463776:

    # l "What's more, what are you going to do about the Grue problem? Are you just going to leave me here?"
    l "И вообще, что нам делать с Грю? Ты просто меня здесь бросишь?"

# game/tutorial_quickstart.rpy:188
translate russian tutorial_dialogue_023bcd31:

    # e "Here's the full game, including the two new lines of dialogue, both of which use the Character we defined to say dialogue."
    e "Вот полная игра, включающая две новые строки диалога, использующие наш объект-персонаж."

# game/tutorial_quickstart.rpy:190
translate russian tutorial_dialogue_48bb9547:

    # e "The one-argument form of the say statement is unchanged, but in the two-argument form, instead of the first string we can use a short name."
    e "Форма оператора речи в случае с одним аргументом осталась неизменной, но в случае с двумя аргументами, вместо первой строки текста мы использовали короткое имя персонажа."

# game/tutorial_quickstart.rpy:192
translate russian tutorial_dialogue_56a9936f:

    # e "When this say statement is run, Ren'Py will look up the short name, which is really a Python variable. It will then use the associated Character to show the dialogue."
    e "При запуске оператора речи, Ren'Py пойдёт искать короткое имя, являющееся переменной Python. И потом будет использован ассоциированный с ним объект Character, показывающийся в диалоге."

# game/tutorial_quickstart.rpy:194
translate russian tutorial_dialogue_d5984a21:

    # e "The Character object controls who is speaking, the color of their name, and many other properties of the dialogue."
    e "Объект Character управляет именем персонажа, его цветом, и другими свойствами диалога."

# game/tutorial_quickstart.rpy:198
translate russian tutorial_dialogue_a5bcac8b:

    # e "Since the bulk of a visual novel is dialogue, we've tried to make it as easy to write as possible."
    e "Так как огромная часть работы над визуальной новеллой составляет написание диалога, мы постарались упростить это настолько, насколько возможно."

# game/tutorial_quickstart.rpy:200
translate russian tutorial_dialogue_6b9a42d0:

    # e "Hopefully, by allowing the use of short names for characters, we've succeeded."
    e "Надеемся, что позволив вам использовать короткие имена персонажей, мы облегчили вам жизнь."

# game/tutorial_quickstart.rpy:206
translate russian tutorial_images_e09ac970:

    # e "A visual novel isn't much without images. So let's add some images to our little game."
    e "Визуальная новелла не очень интересна без изображений, поэтому давайте добавим в нашу маленькую игру парочку."

# game/tutorial_quickstart.rpy:208
translate russian tutorial_images_40140793:

    # e "Before we can show images, we must first choose image names, then place the image files into the images directory."
    e "Перед отображением изображений, сначала нам нужно выбрать для них имена, а затем их следует разместить в папке images."

# game/tutorial_quickstart.rpy:210
translate russian tutorial_images_d73388f8:

    # e "An image name is something like 'bg cave' or 'lucy happy', with one or more parts separated by spaces."
    e "Изображение можно проименовать 'bg cave' или 'lucy happy', где одна или более частей будут разделены пробелами."

# game/tutorial_quickstart.rpy:212
translate russian tutorial_images_2d5596d4:

    # e "Each part should start with a lower-case letter, and then contain lower-case letters, numbers, and underscores."
    e "Каждая часть имени должна начинаться с прописной буквы, и содержать только подобные буквы, цифры и подчёркивания."

# game/tutorial_quickstart.rpy:214
translate russian tutorial_images_e02c0c82:

    # e "The first part of an image is called the tag. For 'bg cave' the tag is 'bg', while for 'lucy happy' the tag is 'lucy'."
    e "Первая часть имени изображения называется тег. Для 'bg cave' тегом является 'bg', а для 'lucy happy' тег — 'lucy'."

# game/tutorial_quickstart.rpy:216
translate russian tutorial_images_d5eafcf2:

    # e "You can open the images directory by clicking the appropriate button in the Ren'Py launcher."
    e "Вы можете открыть папку images, кликнув на соответствующую ей кнопку в окне проекта."

# game/tutorial_quickstart.rpy:218
translate russian tutorial_images_e4b12fb6:

    # e "The files in the images directory should have the same name as the image, followed by an extension like .jpg, .png, or .webp."
    e "Файлы в папке images должны иметь то же имя, что и изображение в коде, а также должны иметь поддерживаемые разрешения, например, .jpg, .png или .webp."

# game/tutorial_quickstart.rpy:220
translate russian tutorial_images_a3bd89b2:

    # e "Our example uses 'bg cave.jpg', 'lucy happy.png', and 'lucy mad.png'."
    e "Наш пример использует 'bg cave.jpg', 'lucy happy.png' и 'lucy mad.png'."

# game/tutorial_quickstart.rpy:224
translate russian tutorial_images_76b954de:

    # e "Let's see what those look like in the game."
    e "Давайте посмотрим, как они выглядят в игре."

# game/tutorial_quickstart.rpy:230
translate russian tutorial_images_f04e72ea:

    # l "Now that the lights are on, we don't have to worry about Grues anymore."
    l "Ну хоть свет включили. Теперь не нужно беспокоиться о Грю."

# game/tutorial_quickstart.rpy:234
translate russian tutorial_images_d77ffa1c:

    # l "But what's the deal with me being in a cave? Eileen gets to be out in the sun, and I'm stuck here!"
    l "Но что за дела, почему я в пещере? Эйлин греется на солнышке, а я застряла здесь!"

# game/tutorial_quickstart.rpy:242
translate russian tutorial_images_6c0c938b:

    # e "Here's the script for that scene. Notice how it includes two new statements, the scene and show statement."
    e "Вот код этой сцены. Заметьте, что он включает в себя два новых оператора — scene и show."

# game/tutorial_quickstart.rpy:244
translate russian tutorial_images_1a4660b9:

    # e "The scene statement clears the screen, and then adds a background image."
    e "Оператор scene очищает экран и добавляет изображение на фон."

# game/tutorial_quickstart.rpy:246
translate russian tutorial_images_672c8cb8:

    # e "The show statement adds a background image on top of all the other images on the screen."
    e "Оператор show добавляет изображение поверх других."

# game/tutorial_quickstart.rpy:248
translate russian tutorial_images_2fc7baee:

    # e "If there was already an image with the same tag, the new image is used to replace the old one."
    e "Если у нового изображения такой же тег, как у того, что уже показано, произойдёт замена старого изображения."

# game/tutorial_quickstart.rpy:250
translate russian tutorial_images_802825f2:

    # e "Changes to the list of shown images take place instantly, so in the example, the user won't see the background by itself."
    e "Изменения отображаемых изображений происходят моментально, так что в этом примере пользователь не видит фон сам по себе."

# game/tutorial_quickstart.rpy:252
translate russian tutorial_images_b246dfdd:

    # e "The second show statement has an at clause, which gives a location on the screen. Common locations are left, right, and center, but you can define many more."
    e "Второй оператор, show, содержит функцию at, позволяющую задать местоположение на экране. Чаще всего используются left, right и center, но вы можете определить и много других."

# game/tutorial_quickstart.rpy:257
translate russian tutorial_images_82fceeb8:

    # e "In this example, we show an image named logo base, and we show it at a creator-defined position, rightish."
    e "В этом примере, мы показываем изображение с именем logo base, и мы показываем его на определённой разработчиком позиции — rightish."

# game/tutorial_quickstart.rpy:259
translate russian tutorial_images_9defda43:

    # e "We also specify that it should be shown behind another image, in this case eileen. That's me."
    e "Мы также указываем что его следует показывать за другим изображением, eileen. То есть, за мной."

# game/tutorial_quickstart.rpy:264
translate russian tutorial_images_73d331f7:

    # e "Finally, there's the hide statement, which hides the image with the given tag."
    e "Наконец, оператор hide скрывает изображение с указанным тегом."

# game/tutorial_quickstart.rpy:266
translate russian tutorial_images_f34f62d5:

    # e "Since the show statement replaces an image, and the scene statement clears the scene, it's pretty rare to hide an image."
    e "Так как оператор show заменяет изображение, а оператор scene очищает экран, скрывать изображения приходится редко."

# game/tutorial_quickstart.rpy:268
translate russian tutorial_images_e06fa53a:

    # e "The main use is for when a character or prop leaves before the scene is over."
    e "Чаще всего его используют при уходе персонажа или отдельного объекта до начала новой сцены."

# game/tutorial_quickstart.rpy:282
translate russian tutorial_simple_positions_b492e793:

    # e "When the standard positions that come with Ren'Py aren't enough for you, you can create your own. Here, I'll show you the easy way to do it."
    e "Когда стандартных позиций Ren'Py становится недостаточно, вы можете создать собственные. Сейчас я покажу вам, как просто их делать."

# game/tutorial_quickstart.rpy:291
translate russian tutorial_simple_positions_04e3bc44:

    # e "The first way to do it is to show an image followed by a colon. Then indented on the next couple of lines are the xalign and yalign transform properties."
    e "Сначала мы показываем изображение и ставим после него двоеточие. Затем, на следующих строках, учитывая индентацию, мы прописываем трансформационные параметры xalign и yalign."

# game/tutorial_quickstart.rpy:293
translate russian tutorial_simple_positions_3ecad5f8:

    # e "Each of the transform properties is a name followed by a value. For xalign and yalign, the values are numbers."
    e "Каждая трансформация — это определённое имя со значением. Для параметров xalign и yalign, значения — это цифры."

# game/tutorial_quickstart.rpy:295
translate russian tutorial_simple_positions_61c1b124:

    # e "The xalign transform property is the important one, as it controls where the image is placed horizontally on the screen."
    e "Параметр xalign очень важен, так как он контролирует позицию изображения по горизонтали."

# game/tutorial_quickstart.rpy:305
translate russian tutorial_simple_positions_67ebea97:

    # e "An xalign of 0.0 is the left side."
    e "Если мы поставим xalign на 0.0, то это будет левая сторона экрана."

# game/tutorial_quickstart.rpy:315
translate russian tutorial_simple_positions_bd4f56d8:

    # e "0.5 is the center."
    e "0.5 — центр."

# game/tutorial_quickstart.rpy:324
translate russian tutorial_simple_positions_fb2c48f2:

    # e "And 1.0 is the right. The decimal place is important and has to be there. Just 1 by itself won't work the same."
    e "И 1.0 — правая сторона. Десятичная дробь очень важна и обязана здесь быть. Если мы напишем просто 1 или 1,0, то результат будет не тот же, или же код вообще перестанет работать."

# game/tutorial_quickstart.rpy:333
translate russian tutorial_simple_positions_8eebc9a7:

    # e "Of course, you can pick any position in between."
    e "Само собой, вы можете выбрать любую позицию на экране."

# game/tutorial_quickstart.rpy:335
translate russian tutorial_simple_positions_4cd917f6:

    # e "The yalign property is the same way, with 0.0 being the top of the screen and 1.0 being the bottom. Since most sprites stick to the bottom, it's almost always 1.0."
    e "Параметр yalign действует похожим образом, 0.0 — верх экрана, а 1.0 — его низ. Так как большинство спрайтов располагается внизу, в большинстве случаев мы оставляем их на 1.0."

# game/tutorial_quickstart.rpy:341
translate russian tutorial_simple_positions_fbd1a3eb:

    # e "While being able to write positions like this is useful, having to repeatedly do so isn't. So Ren'Py lets you define a transform once, and reuse it."
    e "И в то время как умение писать позиции полезно, необходимость постоянно их повторять — совсем не полезна. Поэтому Ren'Py позволяет вам один раз определить трансформацию, а затем использовать её при необходимости."

# game/tutorial_quickstart.rpy:345
translate russian tutorial_simple_positions_2377e3b3:

    # e "Usually transforms are defined at the top of a file, right after the characters. But it doesn't matter to Ren'Py where you define them."
    e "Обычно трансформации определяются выше основного скрипта, сразу после определения персонажей, но в Ren'Py не имеет значения, где вы будете их определять."

# game/tutorial_quickstart.rpy:347
translate russian tutorial_simple_positions_3ce7e367:

    # e "The transform is given a name, slightleft, and then the xalign and yalign properties."
    e "Нашей трансформации даётся имя slightleft, а затем параметры xalign и yalign."

# game/tutorial_quickstart.rpy:355
translate russian tutorial_simple_positions_82d640d9:

    # e "Once a transform has been defined, you can use it in the at clause of the show statement."
    e "Как только трансформация будет объявлена, вы можете использовать её с функцией at при операторе show."

# game/tutorial_quickstart.rpy:360
translate russian tutorial_simple_positions_16b66785:

    # e "Transforms are sticky. If you replace an image without using a transform, Ren'Py will keep the same transforms it had been using."
    e "Трансформации очень липкие. Если вы замените изображение без новой трансформации, Ren'Py применит на неё прошлую трансформацию."

# game/tutorial_quickstart.rpy:364
translate russian tutorial_simple_positions_5d5e0cfd:

    # e "Of course, there's a lot more to transforms than this. If you want to learn more, you can read the sections on Position Properties, Transforms and Animation, and Transform Properties."
    e "Разумеется, существует намного больше трансформаций. Если вы хотите узнать о них побольше, можете почитать о них в секциях 'Позиционные параметры', 'Анимация и Трансформация' и 'Параметры трансформаций'."

# game/tutorial_quickstart.rpy:366
translate russian tutorial_simple_positions_e65da9bf:

    # e "But for many visual novels, xalign and yalign are the only properties that matter."
    e "Но для многих визуальных новелл будет достаточно пары xalign и yalign."

# game/tutorial_quickstart.rpy:381
translate russian tutorial_transitions_9b8c714c:

    # e "It can be somewhat jarring for the game to jump from place to place."
    e "Если игра прыгает туда-сюда, у игроков может закружиться голова."

# game/tutorial_quickstart.rpy:388
translate russian tutorial_transitions_3e290ea8:

    # e "To help take some of edge off a change in scene, Ren'Py supports the use of transitions. Let's try that scene change again, but this time we'll use transitions."
    e "Для того, чтобы сделать изменения сцен приятными для глаз, Ren'Py поддерживает использование переходов. Давайте попробуем повторить то же изменение сцены, но в этот раз с переходом."

# game/tutorial_quickstart.rpy:402
translate russian tutorial_transitions_9c0a86c4:

    # e "That's much smoother. Here's some example code showing how we include transitions in our game."
    e "Так-то лучше. Вот пример кода, показывающий использование переходов в игре."

# game/tutorial_quickstart.rpy:404
translate russian tutorial_transitions_3e490d40:

    # e "It uses the with statement. The with statement causes the scene to transition from the last things shown to the things currently being shown."
    e "Они используют оператор with. Оператор with вызывает переход сцены из того, что было показано раньше, к тому, что должно быть показано сейчас."

# game/tutorial_quickstart.rpy:406
translate russian tutorial_transitions_a43847df:

    # e "It takes a transition as an argument. In this case, we're using the Dissolve transition. This transition takes as an argument the amount of time the dissolve should take."
    e "Он принимает имя перехода как аргумент. В нашем случае используется переход Dissolve. Этот переход принимает в себя аргумент — время, которое он будет длиться."

# game/tutorial_quickstart.rpy:408
translate russian tutorial_transitions_6fcee414:

    # e "In this case, each transition takes half a second."
    e "В нашем случае, его длительность — полсекунды."

# game/tutorial_quickstart.rpy:412
translate russian tutorial_transitions_033042cc:

    # e "We can define a short name for a transition, using the define statement. Here, we're defining slowdissolve to be a dissolve that takes a whole second."
    e "Мы можем определить для перехода короткое имя, используя оператор define. Здесь мы определили showdissolve — переход Dissolve, занимающий секунду."

# game/tutorial_quickstart.rpy:427
translate russian tutorial_transitions_0ba82f00:

    # e "Once a transition has been given a short name, we can use it in our game."
    e "После объявления такого имени мы можем использовать его в игре."

# game/tutorial_quickstart.rpy:431
translate russian tutorial_transitions_51ff9600:

    # e "Ren'Py defines some transitions for you, like dissolve, fade, and move. For more complex or customized transitions, you'll have to define your own."
    e "Ren'Py определяет за вас несколько популярных переходов: растворение (dissolve), затухание (fade) и передвижение (move). Для более сложных переходов, вам придётся определять собственные переходы."

# game/tutorial_quickstart.rpy:433
translate russian tutorial_transitions_1528f73f:

    # e "If you're interested, check out the Transitions Gallery section of this tutorial."
    e "Если вас это интересует, посмотрите на галерею переходов. Для неё отведена отдельная секция обучения."

# game/tutorial_quickstart.rpy:439
translate russian tutorial_music_8b92efb7:

    # e "Another important part of a visual novel or simulation game is the soundtrack."
    e "Другой важной частью визуальной новеллы является звук."

# game/tutorial_quickstart.rpy:441
translate russian tutorial_music_53910317:

    # e "Ren'Py breaks sound up into channels. The channel a sound is played on determines if the sound loops, and if it is saved and restored with the game."
    e "Ren'Py разделяет звук на каналы. Канал определяет, нужно ли играть звук циклично, и необходимо ли его сохранять и восстанавливать вместе с игрой."

# game/tutorial_quickstart.rpy:443
translate russian tutorial_music_a1e37712:

    # e "When a sound is played on the music channel, it is looped, and it is saved when the game is saved."
    e "Когда звук играет на канале music, он будет воспроизводиться циклично и сохраняться вместе с игрой."

# game/tutorial_quickstart.rpy:445
translate russian tutorial_music_d9086d22:

    # e "When the channel named sound is used, the sound is played once and then stopped. It isn't saved."
    e "Звуки на канале sound играют единовременно и не сохраняются."

# game/tutorial_quickstart.rpy:447
translate russian tutorial_music_3555b640:

    # e "The sounds themselves are stored in audio files. Ren'Py supports the Opus, Ogg Vorbis, and mp3 formats."
    e "Сами звуки хранятся в аудио-файлах. Ren'Py поддерживает такие форматы как Opus, Ogg Vorbis и mp3."

# game/tutorial_quickstart.rpy:449
translate russian tutorial_music_a776b6ad:

    # e "Let's check out some of the commands that can effect the music channel."
    e "Давайте посмотрим на команды, влияющие на канал музыки."

# game/tutorial_quickstart.rpy:454
translate russian tutorial_music_8b606a55:

    # e "The play music command replaces the currently playing music, and replaces it with the named filename."
    e "Команда play music заменяет текущую музыку на другой музыкальный файл."

# game/tutorial_quickstart.rpy:456
translate russian tutorial_music_18650fe7:

    # e "If you specify the currently-playing song, it will restart it."
    e "Если вы укажете тот же файл, что играет сейчас, воспроизведение будет перезапущено."

# game/tutorial_quickstart.rpy:458
translate russian tutorial_music_413d91fc:

    # e "If the optional fadeout clause is given, it will fade out the currently playing music before starting the new music."
    e "Если дано условие fadeout, перед воспроизведением новой музыки, текущая будет затухать."

# game/tutorial_quickstart.rpy:463
translate russian tutorial_music_a282a0e3:

    # e "The queue statement also adds music to the named channel, but it waits until the currently-playing song is finished before playing the new music."
    e "Операция queue добавляет музыку в очередь указанного канала и воспроизводит её по завершению текущей."

# game/tutorial_quickstart.rpy:468
translate russian tutorial_music_01ca6bad:

    # e "The third statement is the stop statement. It stops the music playing on a channel. It too takes the fadeout clause."
    e "Третий оператор — stop. Он останавливает музыку на канале и также поддерживает условие fadeout."

# game/tutorial_quickstart.rpy:473
translate russian tutorial_music_384937da:

    # e "Unlike the music channel, playing a sound on the sound channel causes it to play only once."
    e "В отличие от канала музыки, использование канала звука позволяет воспроизвести звуковой файл один раз."

# game/tutorial_quickstart.rpy:480
translate russian tutorial_music_1d3e9fd2:

    # e "You can queue up multiple sounds on the sound channel, but the sounds will only play one at a time."
    e "Вы можете ставить несколько звуковых эффектов в очередь, но они будут проигрываться лишь единожды."

# game/tutorial_quickstart.rpy:486
translate russian tutorial_music_aa01c19d:

    # e "Ren'Py has separate mixers for sound, music, and voices, so the player can adjust them as they like."
    e "Ren'Py содержит отдельные миксеры для звука, музыки и голоса, так что игрок может настроить их громкость, как захочет."

# game/tutorial_quickstart.rpy:492
translate russian tutorial_menus_0426904b:

    # e "Many visual novels require the player to make choices from in-game menus. These choices can add some challenge to the game, or adjust it to the player's preferences."
    e "Многие визуальные новеллы требуют от пользователя принимать решения во внутриигровых меню. Эти решения могут добавить в игру сложность или же подстроить её под предпочтения игрока."

# game/tutorial_quickstart.rpy:494
translate russian tutorial_menus_431eeff0:

    # e "Do you like to play visual novels with choices in them?"
    e "Вам нравится играть в визуальные новеллы с возможностью выбора?"

# game/tutorial_quickstart.rpy:509
translate russian choice1_yes_f6d95df8:

    # e "While creating a multi-path visual novel can be a bit more work, it can yield a unique experience."
    e "Хотя создание разветвлённого сюжета требует большой логической работы, он позволяет создать для игрока уникальный игровой опыт."

# game/tutorial_quickstart.rpy:517
translate russian choice1_no_72958b50:

    # e "Games without menus are called kinetic novels, and there are dozens of them available to play."
    e "Игры без возможности выбора называются кинетическими новеллами и их тоже очень много."

# game/tutorial_quickstart.rpy:528
translate russian choice1_done_acba9504:

    # e "Here, you can see the code for that menu. If you scroll down, you can see the code we run after the menu."
    e "Вот код для этого меню. Если вы пролистаете его вниз, то увидите также код, выполняемый после меню."

# game/tutorial_quickstart.rpy:530
translate russian choice1_done_f9fa6889:

    # e "Menus are introduced by the menu statement. The menu statement takes an indented block, in which there can be one line of dialogue and multiple choices."
    e "Меню начинаются с оператора menu, после которого следует индентированный блок. В этом блоке может быть одна строка диалога на каждый выбор."

# game/tutorial_quickstart.rpy:532
translate russian choice1_done_ebb2db38:

    # e "Each choice must end with a colon, as each choice has its own block of Ren'Py code, that is run when that choice is selected."
    e "После каждого выбора должно идти двоеточие и соответствующий ему индентированный блок кода. Итого, в нашем случае это 12 пробелов или 3 индентации."

# game/tutorial_quickstart.rpy:534
translate russian choice1_done_59cac95d:

    # e "Here, each block jumps to a label. While you could put small amounts of Ren'Py code inside a menu label, it's probably good practice to usually jump to a bigger block of code."
    e "В нашем случае каждый блок совершает переход к метке. Внутри меню следует использовать лишь небольшое количество кода, а при наличии большого количества текста — переходить к другим меткам."

# game/tutorial_quickstart.rpy:536
translate russian choice1_done_2851a313:

    # e "Scrolling down past the menu, you can see the labels that the menu jumps to. There are three labels here, named choice1_yes, choice1_no, and choice1_done."
    e "Ниже меню вы можете увидеть метки, к которым меню осуществляет переход. Их три — choice1_yes, choice1_no и choice1_done."

# game/tutorial_quickstart.rpy:538
translate russian choice1_done_ff761b03:

    # e "When the first menu choice is picked, we jump to the choice1_yes, which runs two lines of script before jumping to choice1_done."
    e "Когда мы выбираем первый вариант в меню, мы переходим к choice1_yes, который выполняет две строки кода и переходит к choice1_done."

# game/tutorial_quickstart.rpy:540
translate russian choice1_done_664fe702:

    # e "Similarly, picking the second choice jumps us to choice1_no, which also runs two lines of script."
    e "При выборе второго варианта, мы переходим к choice1_no, который также выполняет две строки кода."

# game/tutorial_quickstart.rpy:542
translate russian choice1_done_31d12b1e:

    # e "The lines beginning with the dollar sign are lines of python code, which are used to set a flag based on the user's choice."
    e "Строки, начинающиеся со знака доллара — код Python. Мы используем его для создания постоянных данных (переменных или флагов), хранящих выбор пользователя."

# game/tutorial_quickstart.rpy:544
translate russian choice1_done_88398d3e:

    # e "The flag is named menu_flag, and it's set to True or False based on the user's choice. The if statement can be used to test a flag, so the game can remember the user's choices."
    e "Наша переменная названа menu_flag, и мы даём ей значение True или False, в зависимости от выбора пользователя. Оператор if можно использовать для тестирования значения переменной."
    e "Так вы можете позволить своей игре запоминать выборы игроков."

# game/tutorial_quickstart.rpy:549
translate russian choice1_done_2828dbfc:

    # e "For example, I remember that you plan to use menus in your game."
    e "Например, я помню, что вы планируете использовать меню в игре."

# game/tutorial_quickstart.rpy:553
translate russian choice1_done_503786e4:

    # e "For example, I remember that you're planning to make a kinetic novel, without menus."
    e "Например, я помню, что вы планируете создать кинетическую новеллу без меню."

# game/tutorial_quickstart.rpy:555
translate russian choice1_done_819e234a:

    # e "Here's an example that shows how we can test a flag, and do different things if it is true or not."
    e "Вот пример, показывающий тестирование постоянных данных и выполнение разных последовательностей в зависимости от его значения."

# game/tutorial_quickstart.rpy:559
translate russian choice1_done_461e6a59:

    # e "Finally, this shows how you can show dialogue and menus at the same time. Understand?" nointeract
    e "И последнее, вы можете показывать и диалог и меню в одно и то же время. Понятно?" nointeract

# game/tutorial_quickstart.rpy:564
translate russian choice1_done_a32e30fd:

    # e "Great."
    e "Отлично."

# game/tutorial_quickstart.rpy:568
translate russian choice1_done_fbd1dbc1:

    # e "If you look at the example, before the first choice, there's an indented say statement."
    e "Если вы посмотрите на пример, то перед первым выбором будет индентированный оператор речи."

# game/tutorial_quickstart.rpy:574
translate russian menu3_done_47fa2268:

    # e "Although we won't demonstrate it here, Ren'Py supports making decisions based on a combinations of points, flags, and other factors."
    e "Хотя мы не будем здесь это демонстрировать, Ren'Py поддерживает сложные процессы принятия решений, основанные на сочетаниях очков, флагов и других факторов."

# game/tutorial_quickstart.rpy:576
translate russian menu3_done_826a600b:

    # e "One of Ren'Py's big advantages is the flexibility using a scripting language like Python provides us. It lets us easily scale from kinetic novels to complex simulation games."
    e "Одно из больших преимуществ Ren'Py — использование гибкого языка Python. Он позволяет вам быстро вырасти из обычной кинетической новеллы до сложной игры-симулятора."

# game/tutorial_quickstart.rpy:585
translate russian tutorial_input_066611c5:

    # e "Some games might prompt the player for input."
    e "Некоторые игры могут потребовать ввода данных от игрока."

# game/tutorial_quickstart.rpy:599
translate russian tutorial_input_dc3b4560:

    # e "That's done with Python, and especially the renpy.input function. The first line of this example prompts the player for some texts, and sticks it in the name variable."
    e "Это делается с помощью Python, а если точнее, то с помощью функции renpy.input. Первая строка этого примера требует от игрока какой-либо текст и вкладывает его в переменную."

# game/tutorial_quickstart.rpy:601
translate russian tutorial_input_c88b3f4e:

    # e "Often times, you'll want to clean the name up before you use it. The last line does that, by calling the strip method to remove whitespace, and replacing the name with a default if it's missing."
    e "Часто бывает, что вы захотите почистить имя перед использованием. Последняя строка делает именно это, вызывая алгоритм strip, убирающий проблемы, а если имя не задано, то последняя строка также задаёт стандартное имя."

# game/tutorial_quickstart.rpy:605
translate russian tutorial_input_1236e9da:

    # e "To interpolate a variable, write it in square brackets. Isn't that right, [name]?"
    e "Чтобы вставить (интерполировать) переменную, напишите её в квадратных скобках. Не так ли, [name]?"

# game/tutorial_quickstart.rpy:609
translate russian tutorial_input_c1f7a808:

    # e "Variable names can also be shown in character names. To do that, just include the variable in square brackets in the character's name. Got it?"
    e "Переменные также могут быть именами персонажей. Для этого просто включите переменную в квадратных скобках в имя персонажа. Понятно?"

# game/tutorial_quickstart.rpy:612
translate russian tutorial_input_f7757a8e:

    # g "I think I do."
    g "Наверное."

# game/tutorial_quickstart.rpy:619
translate russian tutorial_input_0548d3e2:

    # e "Variable interpolation also works with other variables. Here, the answer is [answer] and the flag is [flag]."
    e "Интерполяция также работает и с другими переменными. Здесь answer равен [answer], а flag — [flag]."

translate russian strings:

    # tutorial_quickstart.rpy:2
    old "Lucy"
    new "Люси"

    # tutorial_quickstart.rpy:497
    old "Yes, I do."
    new "Да."

    # tutorial_quickstart.rpy:497
    old "No, I don't."
    new "Нет."

    # tutorial_quickstart.rpy:589
    old "What's your name?"
    new "Как вас зовут?"

    # tutorial_quickstart.rpy:591
    old "Guy Shy"
    new "Товарищ"

