% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http_interaction.R
\docType{data}
\name{HTTPInteraction}
\alias{HTTPInteraction}
\title{HTTPInteraction class}
\arguments{
\item{request}{A \code{Request} class object}

\item{response}{A \code{VcrResponse} class object}

\item{recorded_at}{Time http interaction recorded at}
}
\description{
HTTPInteraction class
}
\details{
\strong{Methods}
\describe{
\item{\code{to_hash()}}{
Create a hash from the HTTPInteraction object
}
\item{\code{from_hash(hash)}}{
Create a HTTPInteraction object from a hash
}
}
}
\examples{
\dontrun{
# make the request
library(vcr)
url <- "https://eu.httpbin.org/post"
body <- list(foo = "bar")
cli <- crul::HttpClient$new(url = url)
res <- cli$post(body = body)

# build a Request object
(request <- Request$new("POST", uri = url,
  body = body, headers = res$response_headers))
# build a VcrResponse object
(response <- VcrResponse$new(
   res$status_http(),
   res$response_headers,
   res$parse("UTF-8"),
   res$response_headers$status))

# make HTTPInteraction object
(x <- HTTPInteraction$new(request = request, response = response))
x$recorded_at
x$to_hash()

# make an HTTPInteraction from a hash with the object already made
x$from_hash(x$to_hash())

# Make an HTTPInteraction from a hash alone
my_hash <- x$to_hash()
HTTPInteraction$new()$from_hash(my_hash)
}
}
\keyword{datasets}
