% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf.R
\name{rdf}
\alias{rdf}
\title{Initialize an \code{rdf} Object}
\usage{
rdf(storage = c("memory", "BDB", "sqlite", "postgres", "mysql",
  "virtuoso"), host = NULL, port = NULL, user = NULL,
  password = NULL, database = NULL, charset = NULL, dir = NULL,
  dsn = "Local Virtuoso", name = "rdflib", new_db = FALSE,
  fallback = TRUE)
}
\arguments{
\item{storage}{Storage backend to use; see details}

\item{host}{host address for mysql, postgres, or virtuoso storage}

\item{port}{port for mysql (mysql storage defaults to mysql standard port, 3306)
or postgres (postgres storage defaults to postgres standard port, 4321)}

\item{user}{user name for postgres, mysql, or virtuoso}

\item{password}{password for postgres, mysql, or virtuoso}

\item{database}{name of the database to be created/used}

\item{charset}{charset for virtuoso database, if desired}

\item{dir}{directory of where to write sqlite or berkeley database.}

\item{dsn}{Virtuoso dsn, either "Local Virtuoso" or "Remote Virtuoso"}

\item{name}{name for the storage object created. Default is usually fine.}

\item{new_db}{logical, default FALSE. Create new database or connect to existing?}

\item{fallback}{logical, default TRUE. If requested storage system cannot initialize,
should \code{rdf()} fall back on memory (default) or throw an error (fallback=FALSE)?}
}
\value{
an rdf object
}
\description{
Initialize an \code{rdf} Object
}
\details{
an rdf Object is a list of class 'rdf', consisting of
three pointers to external C objects managed by the redland library.
These are the \code{world} object: basically a top-level pointer for
all RDF models, and a \code{model} object: a collection of RDF statements,
and a \code{storage} object, indicating how these statements are stored.

\code{rdflib} defaults to an in-memory hash-based storage structure.
which should be best for most use cases. For very large triplestores,
disk-based storage will be necessary. Enabling external storage devices
will require additional libraries and custom compiling. See the storage
vignette for details.
}
\examples{
x <- rdf()

}
