% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/SingleCellExperiment.R
\docType{class}
\name{SingleCellExperiment-class}
\alias{SingleCellExperiment-class}
\alias{SingleCellExperiment}
\alias{coerce,SummarizedExperiment,SingleCellExperiment-method}
\alias{coerce,RangedSummarizedExperiment,SingleCellExperiment-method}
\title{The SingleCellExperiment class}
\usage{
SingleCellExperiment(
  ...,
  reducedDims = list(),
  altExps = list(),
  rowPairs = list(),
  colPairs = list()
)
}
\arguments{
\item{...}{Arguments passed to the \code{\link{SummarizedExperiment}} constructor to fill the slots of the base class.}

\item{reducedDims}{A list of any number of matrix-like objects containing dimensionality reduction results,
each of which should have the same number of rows as the output SingleCellExperiment object.}

\item{altExps}{A list of any number of \linkS4class{SummarizedExperiment} objects containing alternative Experiments,
each of which should have the same number of columns as the output SingleCellExperiment object.}

\item{rowPairs}{A list of any number of \linkS4class{SelfHits} objects describing relationships between pairs of rows.
Each entry should have number of nodes equal to the number of rows of the output SingleCellExperiment object.
Alternatively, entries may be square sparse matrices of order equal to the number of rows of the output object.}

\item{colPairs}{A list of any number of \linkS4class{SelfHits} objects describing relationships between pairs of columns.
Each entry should have number of nodes equal to the number of columns of the output SingleCellExperiment object.
Alternatively, entries may be square sparse matrices of order equal to the number of columns of the output object.}
}
\value{
A SingleCellExperiment object.
}
\description{
The SingleCellExperiment class is designed to represent single-cell sequencing data.
It inherits from the \linkS4class{RangedSummarizedExperiment} class and is used in the same manner.
In addition, the class supports storage of dimensionality reduction results (e.g., PCA, t-SNE) via \code{\link{reducedDims}},
and storage of alternative feature types (e.g., spike-ins) via \code{\link{altExps}}.
}
\details{
In this class, rows should represent genomic features (e.g., genes) while columns represent samples generated from single cells.
As with any \linkS4class{SummarizedExperiment} derivative,
different quantifications (e.g., counts, CPMs, log-expression) can be stored simultaneously in the \code{\link{assays}} slot,
and row and column metadata can be attached using \code{\link{rowData}} and \code{\link{colData}}, respectively.

The extra arguments in the constructor (e.g., \code{\link{reducedDims}} \code{\link{altExps}})
represent the main extensions implemented in the SingleCellExperiment class.
This enables a consistent, formalized representation of data structures 
that are commonly encountered during single-cell data analysis.
Readers are referred to the specific documentation pages for more details.

A SingleCellExperiment can also be created by coercing from a \linkS4class{SummarizedExperiment}
or \linkS4class{RangedSummarizedExperiment} instance.
}
\examples{
ncells <- 100
u <- matrix(rpois(20000, 5), ncol=ncells)
v <- log2(u + 1)

pca <- matrix(runif(ncells*5), ncells)
tsne <- matrix(rnorm(ncells*2), ncells)

sce <- SingleCellExperiment(assays=list(counts=u, logcounts=v),
    reducedDims=SimpleList(PCA=pca, tSNE=tsne))
sce

## coercion from SummarizedExperiment
se <- SummarizedExperiment(assays=list(counts=u, logcounts=v))
as(se, "SingleCellExperiment")

}
\seealso{
\code{\link{reducedDims}}, for representation of dimensionality reduction results.

\code{\link{altExps}}, for representation of data for alternative feature sets.

\code{\link{colPairs}} and \code{\link{rowPairs}}, to hold pairing information for rows and columns.

\code{\link{sizeFactors}}, to store size factors for normalization.

\code{\link{colLabels}}, to store cell-level labels.

\code{\link{rowSubset}}, to store a subset of rows.

\code{?"\link{SCE-combine}"}, to combine or subset a SingleCellExperiment object.

\code{?"\link{SCE-internals}"}, for developer use.
}
\author{
Aaron Lun and Davide Risso
}
