% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateLogRatio.R
\name{calculateLogRatio}
\alias{calculateLogRatio}
\title{Calculate coverage log-ratio of tumor vs. normal}
\usage{
calculateLogRatio(normal, tumor)
}
\arguments{
\item{normal}{Normal coverage read in by the \code{\link{readCoverageFile}}
function.}

\item{tumor}{Tumor coverage read in by the \code{\link{readCoverageFile}}
function.}
}
\value{
\code{numeric(length(tumor))}, tumor vs. normal copy number log-ratios
for all targets.
}
\description{
This function is automatically called by \code{\link{runAbsoluteCN}} when
normal and tumor coverage are provided (and not a segmentation file or
target-level log-ratios). This function is therefore normally not called by
the user.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal.txt", 
    package="PureCN")
tumor.coverage.file <- system.file("extdata", "example_tumor.txt", 
    package="PureCN")
normal <- readCoverageFile(normal.coverage.file)
tumor <- readCoverageFile(tumor.coverage.file)
log.ratio <- calculateLogRatio(normal, tumor)

}
\author{
Markus Riester
}
