/***************************************************************************
                          rpainter.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rpainter.cpp 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <stdlib.h>

#include "rpainter.h"
#include "rmath.h"


#define getSign(x) ((x) > 0 ? 1: ((x) == 0 ? 0: (-1)))


// Constructor:
//
RPainter::RPainter()
:QPainter()
{

}



// Constructor:
//
RPainter::RPainter(const QPaintDevice* _pDev)
:QPainter(_pDev)
{
  
}



// Destructor:
//
RPainter::~RPainter()
{

}



// Draw a more exact arc:
//
void
RPainter::drawExactArc(double _cx, double _cy, 
                       double _cr,
                       double _a1, double _a2,
                       int   _x1, int   _y1,
                       int   _x2, int   _y2,
                       bool _reversed)
{
  if(_cr<=0.5) {
    drawPoint((int)_cx, (int)_cy);
  }
  else {
    int   cix;            // Next point on circle
    int   ciy;            //
    double aStep;          // Angle Step (rad)
    //double aStep2;         // Angle Step (rad)
    double a;              // Current Angle (rad)

    if(2.0/_cr<=1.0)
      aStep=asin(2.0/_cr);
    else
      aStep=1.0;

    //aStep2=aStep*0.50;
      
    if(aStep<0.05) aStep = 0.05;

    if(!_reversed) {
    
      // Arc Counterclockwise:
      //
      if(_a1>_a2-0.01) _a2+=360.0;
      moveTo(_x1, _y1);
      for(a=(_a1/ARAD)+aStep; a<=(_a2/ARAD); a+=aStep) {
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        lineTo(cix, ciy);

        /*
        a+=aStep2;
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        moveTo(cix, ciy);
        */
      }
      lineTo(_x2, _y2);
    }
    else {
      // Arc Clockwise:
      if(_a1<_a2+0.01) _a2-=360.0;
      moveTo(_x1, _y1);
      for(a=(_a1/ARAD)-aStep; a>=(_a2/ARAD); a-=aStep) {
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        lineTo(cix, ciy);

        /*
        a-=aStep2;
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        moveTo(cix, ciy);
        */
      }
      lineTo(_x2, _y2);
    }
  }
}



void
RPainter::drawStyleLine(int _x1, int _y1,
                        int _x2, int _y2,
                        int _width,
                        PenStyle _style)
{
  unsigned long int pattern1;
  unsigned long int pattern2;

#ifndef DEF_WINDOWS
  switch(_style) {
    default:
    case SolidLine:      pattern1 = 0xFFFFFFFF; pattern2 = 0xFFFFFFFF; break;
    case DashLine:       pattern1 = 0xFFFFFFFF; pattern2 = 0x00000000; break;
    case DotLine:        pattern1 = 0x30003000; pattern2 = 0x30003000; break;
    case DashDotLine:    pattern1 = 0x003003FF; pattern2 = 0xFFFFFFFF; break;
    case DashDotDotLine: pattern1 = 0x030303FF; pattern2 = 0xFFFFFFFF; break;
  }
#else
  switch(_style) {
    default:
    case SolidLine:      pattern1 = 0xFFFFFFFF; pattern2 = 0xFFFFFFFF; break;
    case DashLine:       pattern1 = 0xFF00FF00; pattern2 = 0xFF00FF00; break;
    case DotLine:        pattern1 = 0x30303030; pattern2 = 0x30303030; break;
    case DashDotLine:    pattern1 = 0xFF03C0FF; pattern2 = 0xFF03C0FF; break;
    case DashDotDotLine: pattern1 = 0x030303FF; pattern2 = 0x030303FF; break;
  }
#endif


  int ldx, ldy, dxabs, dyabs, i, j, px, py, sdx, sdy, x, y;
  unsigned long int mask1=0x80000000;
  unsigned long int mask2=0x00000000;

  ldx = _x2-_x1;
  ldy = _y2-_y1;
  sdx = getSign(ldx);
  sdy = getSign(ldy);
  dxabs = abs(ldx);
  dyabs = abs(ldy);

  x = 0;
  y = 0;
  px = _x1;
  py = _y1;

  if( dxabs >= dyabs ) {
    for( i=0; i<dxabs; i++ ) {
      mask1 = ((mask1 || mask2) ? mask1 : 0x80000000);
      y += dyabs;
      if( y>=dxabs ) {
        y -= dxabs;
        py += sdy;
      }
      px += sdx;
      if( pattern1 & mask1 || pattern2 & mask2 ) {
        for( j=-_width/2; j<=_width/2; j++ ) {
          drawPoint( px, py+j );
        }
	
	//drawPoint( px, py );
      }
      if(mask1==1) {
        mask1>>=1;
        mask2=0x80000000;
      }
      else {
        mask1>>=1;
        mask2>>=1;
      }
    }
    
    // Width:
    //
    /*if( _width!=0 ) {
      double ratioLengthWidth = sqrt(dxabs*dxabs+dyabs*dyabs) / (_width / 2.0);
      double xd = dyabs / ratioLengthWidth;
      double yd = dxabs / ratioLengthWidth;
      
      xd /= (_width/2.0);
      yd /= (_width/2.0);
      
      for( j=1; j<=_width/2; ++j ) {
        drawStyleLine( _x1+xd*j, _y1-yd*j, _x2+xd*j, _y2-yd*j, 0, _style );
        drawStyleLine( _x1-xd*j, _y1+yd*j, _x2-xd*j, _y2+yd*j, 0, _style );
      }
    }*/
  }
  else {
    for( i=0; i<dyabs; i++ ) {
      mask1 = ((mask1 || mask2) ? mask1 : 0x80000000);
      x += dxabs;
      if( x>=dyabs ) {
        x -= dyabs;
        px += sdx;
      }
      py += sdy;
      if( pattern1 & mask1 || pattern2 & mask2 ) {
        for( j=-_width/2; j<=_width/2; j++ ) {
          drawPoint( px+j, py );
        }
      }
      if(mask1==1) {
        mask1>>=1;
        mask2=0x80000000;
      }
      else {
        mask1>>=1;
        mask2>>=1;
      }
    }

  }
}


// EOF









