/***************************************************************************
                          rmultilinedit.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rmultilinedit.cpp 1998/09/19 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qmultilinedit.h>
#include <qfiledialog.h>

#include "rmultilinedit.h"
  
#include "rappwin.h"
#include "rfilebase.h"
#include "rfile.h"
#include "rconfig.h"


// Constructor:
//
RMultiLineEdit::RMultiLineEdit(QWidget* _parent,
                               const char* _name)
:QMultiLineEdit(_parent, _name)
{
  setFont( RCONFIG->getFont(0) );
}


// Destructor:
//
RMultiLineEdit::~RMultiLineEdit()
{
}


/*! Add some behaviour for special characters.
*/
void
RMultiLineEdit::keyPressEvent( QKeyEvent *e )
{
  if ( e->state() & ControlButton && e->state() & ShiftButton ) {
    switch ( e->key() ) {
      case Key_O:
        insert("");
        break;
      case Key_D:
        insert("");
        break;
      case Key_U:
        insert("");
        break;
      case Key_Plus:
        insert("");
        break;
      case Key_Colon:
        insert("");
        break;
      default:
        QMultiLineEdit::keyPressEvent( e );
        break;
    }
  }
  else {
    QMultiLineEdit::keyPressEvent( e );
  }
}
			

// Load a file into this edit field (ask user for a file name):
//
void
RMultiLineEdit::loadFile()
{
  QString fn;       // File name
  
  fn = QFileDialog::getOpenFileName(0, 0, this);
  if(!fn.isEmpty()) {
    loadFile(fn);
  }
}
    
  
    
// Load a file into this edit field (file name given):
//
bool
RMultiLineEdit::loadFile(const QString& _name)
{
  bool ret=false;
  RFileBase file(_name);
  if(file.readFileInBuffer()) {
    if(file.getBuf()) {
      setText(QString::fromLocal8Bit(file.getBuf()));
      ret=true;
    }
  }
  return ret;
}



// Save the text in a file (ask user for a file name):
//
void
RMultiLineEdit::saveFile()
{
  QString fn;        // File name
  
  fn = QFileDialog::getSaveFileName(0, 0, this);
  
  if(!fn.isEmpty()) {
    bool usersChoice;

    // No Extension set / append default extension:
    //
    if(fn.find('.')==-1) {
      fn+=".txt";
    }

    QFileInfo fi(fn);
             
    if(fi.exists()) {
      usersChoice=fileOverwriteWarning(fn, 
                                       tr("The file"),
                                       RAppWin::getRAppWin());
    }
    else {
      usersChoice=true;
    }
                      
    if(!fi.exists() || usersChoice) {
      RFileBase file(fn);
      file.copyBufFrom((const char*)text().local8Bit());
      file.saveBufferToFile();
      file.delBuffer();
    }
  }
}

    

// Resize:
//
void
RMultiLineEdit::resizeEvent(QResizeEvent *_ev)
{
  QTableView::resizeEvent( _ev );
}


// EOF






