/***************************************************************************
                          rfileparser.h  -  description
                             -------------------
    begin                : Sun Sep 12 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RFILEPARSER_H
#define RFILEPARSER_H

#include <qstring.h>

#include "rprgdef.h"

class RFileParser
{
public:
  RFileParser();
  ~RFileParser();

  static QString getContents(QString fileName, bool comments=true, bool sections=true, bool whitespace=true, bool htmlComments=true);
  static QString getSection(QString s, QString sectionName);
  static QString getHtmlComment(QString s);
  static QString getNextStringBetween(QString s, int& startIndex, QChar starter, QChar stopper);
  static QString getNextStringUntil(QString s, int& startIndex, QChar stopper);
  static QString removeComments(QString s);
  static QString removeHtmlComments(QString s);
  static QString removeSections(QString s);
  static QString plainTextToHtml(QString s, int autoBreak);
  static QString charToHtml(QChar c);

};

#endif
