/***************************************************************************
                          rdlgcircle.cpp  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rdlgcircle.h"
#include "relement.h"
#include "rmath.h"
#include <qvalidator.h>

RDlgCircle::RDlgCircle(QWidget *_parent, const char *_name, RElement *_circle)
					 : QDialog(_parent,_name,true){
	initDialog();
	setCaption(tr("Circle"));
	
  val= new QDoubleValidator(-1.0e300, 1.0e300, 8, this);
	
  QLineEdit_cx->setValidator(val);
  QLineEdit_cy->setValidator(val);
  QLineEdit_cr->setValidator(val);

	QPushButton_Ok->setText(tr("Ok"));
  connect(QPushButton_Ok, SIGNAL(clicked()), SLOT(accept()));

	QPushButton_Cancel->setText(tr("Cancel"));
  connect(QPushButton_Cancel, SIGNAL(clicked()), SLOT(reject()));

  QString tempStr;

  tempStr.setNum(_circle->getCx());
  QLineEdit_cx->setText(tempStr);
  tempStr.setNum(_circle->getCy());
  QLineEdit_cy->setText(tempStr);
  tempStr.setNum(_circle->getCr());
  QLineEdit_cr->setText(tempStr);

  QLabel_Center->setText(tr("Center:"));
  QLabel_Radius->setText(tr("Radius:"));
  tempStr.setNum(_circle->getLength());
  QLabel_Length->setText(tr("Length:")+" "+tempStr);
}

RDlgCircle::~RDlgCircle(){
}

// Gives the Values that are written in the Editfields
double
RDlgCircle::getCx(bool *isOk){
	//QString tmpStr=QLineEdit_cx->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cx->text(), 0.0, isOk );
}

double
RDlgCircle::getCy(bool *isOk){
	//QString tmpStr=QLineEdit_cy->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cy->text(), 0.0, isOk );
}

double
RDlgCircle::getCr(bool *isOk){
	//QString tmpStr=QLineEdit_cr->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cr->text(), 0.0, isOk );
}

