/***************************************************************************
                          raboutdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Apr 28 1999                                           
    copyright            : (C) 1999 by Andreas Mustun                         
    email                : mustun@ribbonsoft.com                                     
 ***************************************************************************/


#include <qkeycode.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpushbutton.h>

#include "raboutdialog.h"
#include "rprgdef.h"

#ifdef DEF_QCAD
#include "xpm/qcad.xpm"
#endif
#ifdef DEF_CAM_EXPERT
#include "xpm/camexp.xpm"
#endif
#include "xpm/ribbonsoft.xpm"


/*! \class RAboutDialog
    \brief The "Help" -> "About" Dialog

    \author Andrew Mustun
*/


/*! Constructor
    \param _parent The Parent Widget
    \param _name Name
*/
RAboutDialog::RAboutDialog(QWidget* _parent,
                           const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  setFixedSize(350, 194);

  setCaption(DEF_APPNAME);

  // Stuff the elements into a box layout:
  //
  QGridLayout * gl = new QGridLayout(this, 4, 2, 5);
    gl->setColStretch(0, 2);
    gl->setColStretch(1, 5);

    gl->setRowStretch(0, 1);
    gl->setRowStretch(1, 20);
    gl->setRowStretch(2, 20);
    gl->setRowStretch(3, 6);

  // Program:
  //
  fProg = new QFrame(this, "fprog");
  fProg->setFrameStyle(QFrame::Box|QFrame::Sunken);
  gl->addMultiCellWidget(fProg, 1, 1, 0, 1);

  QGridLayout* glp = new QGridLayout(fProg, 1, 2, 5);
    glp->setColStretch(0, 1);
    glp->setColStretch(1, 3);

    lIconProg = new QLabel(fProg, "liconprog");
    lIconProg->setPixmap(QPixmap(DEF_APP_ICON));
    lIconProg->setAlignment(AlignHCenter|AlignTop);
    glp->addWidget(lIconProg, 0, 0);

    QString mes;
    mes = QString("%1\nVersion: %2\nReleased: %3\nAll rights reserved.")
                 .arg(DEF_APPNAME)
		 .arg(DEF_VERSION)
		 .arg(DEF_RELEASE);
    lInfoProg = new QLabel(mes, fProg, "linfoprog");
    lInfoProg->setAlignment(AlignTop);
    glp->addWidget(lInfoProg, 0, 1);

  // Firm:
  //
  fFirm = new QFrame(this, "ffirm");
  fFirm->setFrameStyle(QFrame::Box|QFrame::Sunken);
  gl->addMultiCellWidget(fFirm, 2, 2, 0, 1);

  QGridLayout* glf = new QGridLayout(fFirm, 1, 2, 5);
    glf->setColStretch(0, 1);
    glf->setColStretch(1, 3);

    lIconFirm = new QLabel(fFirm, "liconfirm");
    lIconFirm->setPixmap(QPixmap(DEF_ORG_ICON));
    lIconFirm->setAlignment(AlignHCenter|AlignTop);
    glf->addWidget(lIconFirm, 0, 0);

    mes = QString("Copyright by %1\n%2\nSupport: %3\nInternet: %4")
                 .arg(DEF_FIRM)
		 .arg(DEF_PROGRAMMER)
                 .arg(DEF_SUPPORTEMAIL)
                 .arg(DEF_INTERNET);
    lInfoFirm = new QLabel(mes, fFirm, "linfofirm");
    lInfoFirm->setAlignment(AlignTop);
    glf->addWidget(lInfoFirm, 0, 1);

  bOk = new QPushButton("OK", this);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));
  bOk->setAccel(Key_Return);
  gl->addMultiCellWidget(bOk, 3, 3, 0, 1);

}



/*! Destructor
*/
RAboutDialog::~RAboutDialog()
{

}


// EOF-




