/***************************************************************************
                          measurearea.h  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Guenter Szolderits
    email                : g.szolderits@gmx.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MEASUREAREA_H
#define MEASUREAREA_H

#include <qqueue.h>

/**
  *@author Guenter Szolderits
  */

class MeasureAreaPoint
{
public:
	MeasureAreaPoint(double _x, double _y) { x=_x; y=_y; }
	double getX() { return x; };
	double getY() { return y; };
private:
	double x;
	double y;
};

/**
  *@author Guenter Szolderits
  */

class MeasureArea
{
public: 
	MeasureArea();
	~MeasureArea();

	void addPoint(double _x, double _y);
	void calculate();
	double getArea() { return area; }
	double getCircumference() { return circumference; }
	void reset();
	int count() { return thePoints.count(); }

private:
	double calcSubArea(MeasureAreaPoint *_pt1, MeasureAreaPoint *_pt2);
	double calcDistance(MeasureAreaPoint *_pt1, MeasureAreaPoint *_pt2);

	QQueue<MeasureAreaPoint> thePoints;
	double baseY;
	double area;
	double circumference;
};

#endif
