/****************************************************************************
** main.cpp 19980824 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft, Andreas Mustun.  All rights reserved.
**
*****************************************************************************/

#include <stdlib.h>

#include <qapplication.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qplatinumstyle.h>
#include <qtimer.h>
#include <qwindowsstyle.h>

#include "rappwin.h"
#include "rconfig.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlog.h"

#if defined(DEF_CAM_EXPERT) || defined(DEF_WINDOWS)
#include "rvalidate.h"
#endif


#include "rmath.h"

int 
main(int argc, char** argv) {

  int ret;

  QApplication app(argc, argv);

  // Read INI/QM-File:
  //
  QFileInfo prgInfo(argv[0]);
  QDir prgDir(prgInfo.dirPath(true));
  RCONFIG->setPrgDir(prgDir);        // CWD is program directory
  RCONFIG->createLanguageList();     // Compile the list of available languages (for Options dialog)
  RCONFIG->createConfigFile(false);  // Create config file ~/.qcad/qcad.conf if there's none
  RCONFIG->readConfigFile();         // Read config file
  RCONFIG->readQmFile();             // Read language file
  
  app.setFont( RCONFIG->getFont(0) );  // Set default font for application

#if defined(DEF_CAM_EXPERT) || defined(DEF_WINDOWS)
  RValidate v1;                       // Validate reg.txt (CAM Expert)
  if(!v1.validate()) exit(1);
#endif

  RAppWin* appWin = RAppWin::getRAppWin();

  // Set Application style:
  //
  QApplication::setStyle( new QWindowsStyle() );
  //QApplication::setStyle( new QPlatinumStyle() );
  app.setMainWidget(appWin);

  // Show application window:
  //
  appWin->init();
  appWin->show();
  appWin->zoomToPage();
  
  // Show Intro:
  //
#ifndef DEF_LESS_DIALOGS
  if( argc==1 ) {
    appWin->showIntro();
    QTimer::singleShot(1500, appWin, SLOT(closeIntro()));
  }
#endif

  // Read Fonts:
  //
  RFonts::getRFonts();

  // Load file if given:
  //
  bool doExit=false;       // Immediately exit after handling command line params
  bool autoZoom=false;     // Autozoom
  bool printToFile=false;  // Print to file after loading
  QString printFile;       // Path of ps file
  
  if(argc>1) {
    for(int i=1; i<argc; ++i) {
    
      // Autozoom:
      //
      if( !strcmp( argv[i], "--autozoom" ) ) {
        autoZoom=true;
      }
      else if( !strcmp( argv[i], "--printtofile" ) && i+1<argc ) {
        printToFile=true;
        printFile = argv[i+1];
      }
      else if( !strcmp( argv[i], "--exit" ) ) {
        doExit=true;
      }
      else {
        appWin->fileOpen(QString(argv[i]));
      }
    }
  }
  
  if(autoZoom) appWin->zoomAuto();

  if(printToFile) {
    appWin->getPrinter()->setOutputToFile( true );
    appWin->getPrinter()->setOutputFileName( printFile );
    appWin->filePrint( false );
  }
  
  if(doExit) exit(0);

  appWin->setFocus();
  appWin->resizeChildren();
  
  // Execute application:
  //
  ret=app.exec();

  RCONFIG->createConfigFile(true);

  return ret;

}


// EOF


















