##########################################################################
#
# TestPackage.py: test the Package module
#
#  Python-CDD is a library to make easier to build applications to
#  Custom Debian Distributions.
#  See http://projetos.ossystems.com.br/python-cdd for more information.
#
# ====================================================================
# Copyright (c) 2002-2005 O.S. Systems.	 All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution.
#
#########################################################################
# Authors: Otavio Salvador <otavio@ossystems.com.br>
#		   Marco Presi <zufus@debian.org>

import unittest

import apt_pkg

from TestBase	 import TestBase
from cdd.Package import *

import logging
import sys

class PackageTests(TestBase):
	def __read_file(self, class_ref, filename):
		parse_in = open(filename, 'r')
		parse = apt_pkg.ParseTagFile(parse_in)

		pkg_list = []
		while parse.Step() == 1:
			pkg = class_ref(parse.Section)
			pkg_list.append(pkg)
		parse_in.close()

		return pkg_list

	def test_1package_init(self):
		"""Package: initialization"""
		pkg_list = self.__read_file(Package, self.aux_file('Packages'))
		self.failUnless(pkg_list[0].has_key('Package'),
						"Failed to read the fields to Package object.")

		srclist = self.__read_file(SourcePackage, self.aux_file('Sources'))
		self.failUnless(srclist[0].has_key('Package'),
						"Failed to read the fields to SourcePackage object.")

	def test_2cast_fields(self):
		"""Package: fielding casting"""
		pkg_list = self.__read_file(Package, self.aux_file('Packages'))

		for field in ('Suggests', 'Recommends', 'Depends', 'Pre-Depends'):
			if pkg_list[0].has_key(field):
				self.failUnlessEqual(type(pkg_list[0][field]), list,
									 "Missing casting for the '%s' field."
									 % field)
				self.failUnlessEqual(type(pkg_list[0][field][0]), list,
									 "Wrong casting for the '%s' field."
									 % field)

		if pkg_list[0].has_key('Provides'):
			self.failUnlessEqual(type(pkg_list[0]['Provides']), list)

		srclist = self.__read_file(SourcePackage, self.aux_file('Sources'))

		for field in ('Build-Depends', 'Build-Depends-Indep'):
			if srclist[0].has_key(field):
				self.failUnlessEqual(type(srclist[0][field]), list,
									 "Missing casting for the '%s' field."
									 % field)
				self.failUnlessEqual(type(srclist[0][field][0]), list,
									 "Wrong casting for the '%s' field."
									 % field)

		if srclist[0].has_key('Binary'):
			self.failUnlessEqual(type(srclist[0]['Binary']), list)

		if srclist[0].has_key('Files'):
			self.failUnlessEqual(type(srclist[0]['Files']), list,
								 "Missing Source Files List.")
			files = []
			files = srclist[0]['Files']
			for i in range (0, len(files)):
				self.failUnlessEqual(type(files[i]), dict,
									 "Wrong casting for 'files' field.")

				for field in ('name', 'md5sum', 'size'):
					if field == 'name':
						self.failIfEqual(files[i][field][-1:], '\n'
										 "Didn't remove the newline char.")

					self.failIfEqual(files[i].has_key(field), False,
								"Didn't returned the field '%s'." % field)

	def test_3dump(self):
		"""Package: dump package index"""
		for classref, filename in ((Package, self.aux_file('Packages')),
								   (SourcePackage, self.aux_file('Sources'))):
			pkg_list = self.__read_file(classref, filename)
			pkg_str = ""
			for pkg in pkg_list:
				pkg_str += pkg.dump()

			packages_file = open(filename, 'r')
			self.failUnlessEqual(
				pkg_str, packages_file.read(),
				"Dump generated is invalid: %s %s !=\n%s" % (classref, filename, pkg_str)
			)


def suite():
	suite = unittest.TestSuite()

	suite.addTest(unittest.makeSuite(PackageTests, 'test'))

	return suite


if __name__ == '__main__':
	log = logging.getLogger()
	log_handler = logging.FileHandler(sys.argv[0][:-3] + '.log')
	log.setLevel(logging.DEBUG)
	log.addHandler(log_handler)
	unittest.main(defaultTest='suite')
