# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.0.0 --output=unicodedb_6_0_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '6.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x05 AND '
'\r AND YEN SIGN'
'\x12 BRIGHTNESS SYMBOL'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\x06 CHART'
'\x0b DECORATION'
'\x07 ENGINE'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x0e IN SILHOUETTE'
'\x06 LARGE'
'\t LEERAEWA'
'\x0b LOCOMOTIVE'
'\x08 LUGGAGE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x05 MARK'
'\x05 MFON'
'\x06 MOON '
'\x07 MUOMAE'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\x04 ORE'
'\x0f OVER MOUNTAINS'
'\x02 P'
'\x04 POT'
'\x08 SATCHEL'
'\x06 SEVEN'
'\t SPARKLER'
'\x05 STOP'
'\x05 TABS'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x16 WITH DECORATIVE COVER'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\r WITH INK PEN'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH VERTICAL BAR'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x06-SHIRT'
'\x07-THIRTY'
'\x012'
'\x03272'
'\x013'
'\x014'
'\x03408'
'\x015'
'\x03533'
'\x035B6'
'\x016'
'\x017'
'\x0270'
'\x018'
'\x019'
'\x03981'
'\x01A'
'\x02A '
'\x06A MFON'
'\x05A YUE'
'\x03A7A'
'\x02AA'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nABATA TREE'
'\x05ABIC '
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x05ACUTE'
'\x02AE'
'\rAE WITH GRAVE'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x04AGON'
'\x05AHMI '
'\x04AIN '
'\x02AK'
'\x03AK '
'\x06AKEUAE'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x04ALF '
'\x05ALGAR'
'\x04ALL '
'\x03ALO'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\x1dAMOND SHAPE WITH A DOT INSIDE'
'\x02AN'
'\x03ANA'
'\x04ANAE'
'\x03AND'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x07ANGKUOQ'
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x02AP'
'\x04APAQ'
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x04ARAE'
'\x08ARCASITE'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDSMAN'
'\nARFUL FACE'
'\tARM CLOCK'
'\rARRED TRIDENT'
'\x05ARROW'
'\tART WITH '
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x12ASTED SWEET POTATO'
'\x02AT'
'\nAT ON BONE'
'\x0fATAKANA LETTER '
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\x14ATIN CAPITAL LETTER '
'\nAUTOMOBILE'
'\x08AVED ICE'
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x08AY-NIGHT'
'\x01B'
'\x02B '
'\x02BA'
'\x03BAG'
'\x04BALL'
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x05BELOW'
'\x08BER POLE'
'\x07BERGINE'
'\x06BETAN '
'\x07BETWEEN'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x08BICYCLES'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\nBILE PHONE'
'\x06BISCUS'
'\x0eBLE CURLY LOOP'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\nBLOND HAIR'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x0cBRATION MODE'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x02BY'
'\x01C'
'\x02C '
'\x02CA'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x0bCANDRABINDU'
'\x07CAP TEN'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x02CE'
'\x03CE '
'\x08CE CREAM'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x02CH'
'\nCH BALLOON'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHICK'
'\x03CHO'
'\nCHWA WITH '
'\x0cCIDUOUS TREE'
'\x06CIRCLE'
'\x1dCIRCLED LATIN CAPITAL LETTER '
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x05COVER'
'\x07CRACKER'
'\x10CREAMING IN FEAR'
'\x12CREATIONAL VEHICLE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\x03CRO'
'\nCROSS MARK'
'\x06CTOPUS'
'\x04CTOR'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x07D INDEX'
'\x1cD WITH LEFTWARDS ARROW ABOVE'
'\x02DA'
'\x03DAA'
'\x05DAIC '
'\x05DBOAT'
'\x05DDING'
'\nDECORATION'
'\x03DEN'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDESCENDER'
'\x08DESTRIAN'
'\x04DGER'
'\x02DH'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x0fDIAN RUPEE SIGN'
'\x14DIFIER LETTER EXTRA-'
'\x03DIO'
'\x04DISC'
'\x08DIT CARD'
'\x05DLING'
'\x02DO'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x08DOT REPH'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x0fDOUBLE TRIANGLE'
'\x1cDOWN POINTING BACKHAND INDEX'
'\tDOWN SIGN'
'\x1dDOWN-POINTING DOUBLE TRIANGLE'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x04DRAM'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\tDY BEETLE'
'\x01E'
'\x02E '
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x0bE WITH VEIL'
'\x03E80'
'\x03EAD'
'\x07EAD ORE'
'\x03EAM'
'\x04EANS'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x08ED BRICK'
'\x08ED FLAGS'
'\x07ED RICE'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEM'
'\x04EEN '
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x05EIGHT'
'\tEIGHT OF '
'\x06EIGHTH'
'\x05EKEET'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\nENTRY SIGN'
'\x04ENTY'
'\x05EOPLE'
'\x02EQ'
'\x02ER'
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x0fERING MEGAPHONE'
'\x15ERTICAL TRAFFIC LIGHT'
'\x02ES'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\x04EVEN'
'\x08EVEN OF '
'\x0cEVERING FACE'
'\x02EW'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0bEXED BICEPS'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x15FACE WITH CLOSED EYES'
'\x16FACE WITH SMILING EYES'
'\tFACING UP'
'\x07FATIGUE'
'\x02FE'
'\x04FEUQ'
'\x0eFFICE BUILDING'
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x0cFLAG ON POST'
'\x06FLOWER'
'\x0cFOLDED HANDS'
'\x03FOM'
'\x15FORMATION DESK PERSON'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\nFOUR DOTS '
'\x04FREE'
'\x08FROWNING'
'\x02FT'
'\x0cFT ICE CREAM'
'\x03FTY'
'\x03FUE'
'\x01G'
'\x06G FACE'
'\x15G WITH OBLIQUE STROKE'
'\x02GA'
'\x12GALI LETTER KHINYA'
'\x04GAME'
'\x07GATIVE '
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GE'
'\x0bGE AT NIGHT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x03GER'
'\x06GERINE'
'\x0bGGAGE CLAIM'
'\x03GGY'
'\x02GH'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x08GHT RAIL'
'\x04GHT-'
'\x13GIBBOUS MOON SYMBOL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x07GLASSES'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x05GRAVE'
'\nGUA PI MAO'
'\x04GUIN'
'\x05GULUS'
'\x01H'
'\x02HA'
'\x04HALF'
'\x05HALQA'
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x03HAQ'
'\x03HAT'
'\x02HE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x10HEAVY CHECK MARK'
'\x0bHEELED SHOE'
'\x05HEUAE'
'\x06HEUAEP'
'\x02HI'
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x12HILOSOPHERS SULFUR'
'\x07HIUCHUS'
'\x05HMER '
'\x12HOOKED SCHWA WITH '
'\x04HOOL'
'\x04HOST'
'\x05HOTEL'
'\x04HREE'
'\nHREE DOTS '
'\x08HREE OF '
'\x05HROOM'
'\x04HUET'
'\x07HUNDRED'
'\x02HY'
'\x01I'
'\x0eI AND SKI BOOT'
'\x07I NTEUM'
'\x05ICAL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x02ID'
'\x03IDA'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IGHT'
'\nIGHT RULER'
'\x0fIGHT WITH STARS'
'\x05IGIT '
'\x15IGN INVERTED MCHU CAN'
'\tIGN TOMPI'
'\x02II'
'\x03IKA'
'\x02IL'
'\tIL POLISH'
'\x04ILET'
'\x05ILVER'
'\nIMALUNGUN '
'\x05IMGBA'
'\x02IN'
'\tINARBORAS'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x04INDI'
'\x03INE'
'\x04ING '
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\tING HEART'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\nING SYMBOL'
'\x07INNABAR'
'\x07INNING '
'\x04INU '
'\x11INVERTED MCHU CAN'
'\x03ION'
'\x02IP'
'\x02IQ'
'\x02IR'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCUT'
'\x03IRL'
'\x04IRON'
'\x04IRTY'
'\x02IS'
'\x03ISA'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x08ITA MFON'
'\x04ITAR'
'\x04ITE '
'\x03IVE'
'\x07IVE OF '
'\x0cIVISION SIGN'
'\x02IX'
'\x06IX OF '
'\rIYA FRACTION '
'\x04IYAQ'
'\x15IZONTAL TRAFFIC LIGHT'
'\x01J'
'\x02JA'
'\x08JACK OF '
'\x03JAM'
'\x0bJIHVAMULIYA'
'\x15JK UNIFIED IDEOGRAPH-'
'\x05JUDUL'
'\x01K'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x1cK WITH LEFTWARDS ARROW ABOVE'
'\x15K WITH OBLIQUE STROKE'
'\x03KAD'
'\x04KALI'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\tKATAKANA '
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\nKINDI MVOP'
'\tKING FACE'
'\x04KINI'
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x03KUE'
'\x05KWAEN'
'\tKYO TOWER'
'\x01L'
'\x1eL WITH RETROFLEX HOOK AND BELT'
'\x02LA'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x14LASHING SWEAT SYMBOL'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x03LAW'
'\x0fLAYALAM LETTER '
'\x0cLAYING CARD '
'\x0bLCE TSA CAN'
'\tLD TAMIL '
'\x05LDER '
'\x0eLDREN CROSSING'
'\x02LE'
'\tLE FOLDER'
'\x13LEADING MCHAN RTAGS'
'\x0fLED IDEOGRAPH A'
'\x05LEERI'
'\x1cLEFT POINTING BACKHAND INDEX'
'\x1dLEFT-POINTING DOUBLE TRIANGLE'
'\x06LENDAR'
'\x06LETTER'
'\x07LETTER '
'\x13LETTER KASHMIRI YEH'
'\x1dLETTER SMALL CAPITAL TURNED M'
'\x07LETTERS'
'\x05LEVEN'
'\x07LF FACE'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x05LICE '
'\x08LICOPTER'
'\x0bLIEVED FACE'
'\nLIGHT BULB'
'\x05LING '
'\x03LIP'
'\x0cLIVERY TRUCK'
'\x07LKY WAY'
'\x02LL'
'\tLLEN LEAF'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x05LLOON'
'\x07LM TREE'
'\x02LO'
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x0fLOOK OF TRIUMPH'
'\x04LOW '
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\x0cLOWERED FLAG'
'\x05LPHIN'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x07LY LOOP'
'\x01M'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x02MA'
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\x0cMALL LETTER '
'\x03MAN'
'\x04MARK'
'\x05MARK '
'\x04MARY'
'\x07MASSAGE'
'\x04MATO'
'\x02MB'
'\x03MBA'
'#MBINING DOUBLE INVERTED BREVE BELOW'
'\x08MCHU CAN'
'\x08ME BADGE'
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x05MELON'
'\x11MEN HOLDING HANDS'
'\x03MER'
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x04MIL '
'\x0bMILING EYES'
'\x04MILY'
'\nMINUS SIGN'
'\x02MO'
'\rMOBILE PHONES'
'\x03MON'
'\x04MONO'
'\x02MP'
'\x05MSHAE'
'\x04MUCH'
'\x11MUM LETTER PHASE-'
'\x08MY HOUSE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x07N WITH '
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x08NA METEK'
'\x0cNAMUSED FACE'
'\x04NBOW'
'\x08NDA FACE'
'\nNDA PA NJI'
'\tNDAILING '
'\x05NDBAG'
'\x03NDY'
'\x02NE'
'\x05NEGAR'
'\x04NEMA'
'\x03NEY'
'\x02NG'
'\x04NGUE'
'\x02NI'
'\tNIGHT OF '
'\x04NINE'
'\x08NINE OF '
'\x05NING '
'\x04NJAM'
'\tNK SYMBOL'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x04NOSE'
'\x04NOTE'
'\nNOTE WITH '
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\tNTESSENCE'
'\x0bNTIMONY ORE'
'\x07NUMBER '
'\x07NUMBERS'
'\x03NYI'
'\x05NZEUM'
'\x01O'
'\x02O '
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x07OCALIC '
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x08OCUS OF '
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x07OGICAL '
'\x04OGRE'
'\x03OIL'
'\x02OK'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x06OLCANO'
'\x03OLD'
'\x04OLIN'
'\nOLLAR SIGN'
'\x02OM'
'\x08OM NTEUM'
'\x04OMBU'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON TEUAEQ'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x04ONTH'
'\x07ONTIEEN'
'\x03OOL'
'\x02OP'
'\nOP NKAARAE'
'\x05OPARD'
'\nOPEN MOUTH'
'\x0cOPEN O WITH '
'\x06OPPER '
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x03ORE'
'\x15ORGIAN LETTER U-BRJGU'
'\x04ORNS'
'\nORTHERN TA'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\nOTING STAR'
'\x08OTPRINTS'
'\x04OTUS'
'\x0bOUBLE DANDA'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x07OUR OF '
'\x0bOUSEL HORSE'
'\tOUT MOUTH'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\tOWBOARDER'
'\nOWEL SIGN '
'\x0bOWING HEART'
'\x01P'
'\x02P '
'\x07P PIEET'
'\nP STREAMER'
'\x0bP-POINTING '
'\x02PA'
'\rPA NJI PIPAEM'
'\x08PAKPAK E'
'\x03PAN'
'\x07PANESE '
'\x05PARAQ'
'\x0ePARTMENT STORE'
'\x06PBOARD'
'\x0bPEDESTRIANS'
'\x18PEN MOUTH AND COLD SWEAT'
'\x0fPENSION RAILWAY'
'\x07PERCLIP'
'\x03PES'
'\x04PEUX'
'\x05PHANT'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x06PICKET'
'\x05PIRIT'
'\tPLE HEART'
'\x08PLE LEAF'
'\x04PLET'
'\x04PLUG'
'\tPLUS SIGN'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\nPOLICE CAR'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x06PSTICK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x03PUQ'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x01Q'
'\x03QUA'
'\x07QUARED '
'\x07QUARTER'
'\x08QUARTERS'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x01R'
'\x06R FACE'
'\x15R WITH OBLIQUE STROKE'
'\x0eR-OFF CALENDAR'
'\x02RA'
'\x06RACING'
'\x03RAE'
'\x0eRAGANA LETTER '
'\x07RAILWAY'
'\x0bRAISED FLAG'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x13RATUM SUPER STRATUM'
'\x02RB'
'\x02RC'
'\x08RCHAIC E'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\x03REE'
'\x05REGIA'
'\x06REMEDY'
'\x0cREVERSED TSE'
'\x04RFER'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x02RI'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\x05RIEEN'
'\x04RIFY'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x0fRIGHT-POINTING '
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x03RII'
'\x07RILLIC '
'\x07RINCESS'
'\x04RING'
'\x04RISE'
'\x0cRISTMAS TREE'
'\x0cRK AND KNIFE'
'\nRKING FACE'
'\x03RKL'
'\x02RO'
'\x04ROLL'
'\x03ROM'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x02RR'
'\x03RRA'
'\nRRIS WHEEL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RTCAKE'
'\x04RTLE'
'\x03RTY'
'\nRTY POPPER'
'\x02RU'
'\x05RULER'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x15S WITH OBLIQUE STROKE'
'\x02SA'
'\x08SALT OF '
'\x06SANDAL'
'\x0bSAPPOINTED '
'\nSCENT MOON'
'\x05SCOPE'
'\x05SCORE'
'\x02SE'
'\x03SE '
'\x04SED '
'\x0eSEPARATOR MARK'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\tSH SYMBOL'
'\x03SHA'
'\x04SHAE'
'\x04SHES'
'\x13SHHA WITH DESCENDER'
'\x05SHPIN'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x04SIGN'
'\x05SIGN '
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\tSIVE FACE'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x11SKETBALL AND HOOP'
'\rSMALL LETTER '
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMILING EYES'
'\x0eSMOKING SYMBOL'
'\x08SOFTNESS'
'\x05SOLVE'
'\x03SOS'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x06SPITAL'
'\rSQUARE BUTTON'
'\x08SQUARED '
'\x02SS'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\tSTAL BALL'
'\tSTER FACE'
'\x05STNUT'
'\x04STOL'
'\x06STROOM'
'\nSTRUCTION '
'\x15STUCK-OUT TONGUE AND '
'\x08SWIMMING'
'\tSYLLABLE '
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x06TAGRAM'
'\x04TAXI'
'\x0cTCHING CHICK'
'\x0cTEARS OF JOY'
'\x06TEBOOK'
'\rTED HAND SIGN'
'\x03TEE'
'\x03TEL'
'\x0fTELLITE ANTENNA'
'\x03TER'
'\x04TERY'
'\x06TEUWEN'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\nTHDAY CAKE'
'\x0eTHER CHRISTMAS'
'\x08THIOPIC '
'\x0cTHLETIC SHOE'
'\x08THOUSAND'
'\x06THREE '
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x02TI'
'\nTICAL DISC'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x04TILL'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x06TO BOX'
'\x03TOM'
'\x05TORCH'
'\x04TORT'
'\x04TORY'
'\x14TRAILING MCHAN RTAGS'
'\x03TRE'
'\nTREFACTION'
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x05TRIOL'
'\x03TRO'
'\x03TTH'
'\x04TTTA'
'\x03TUB'
'\x06TURBAN'
'\x08TURNED H'
'\x0eTURNED V WITH '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUBJOINED SIGN '
'\x08UBLE DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x16UBSCRIPT SMALL LETTER '
'\x06UCIBLE'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x08UKEUTNDA'
'\x03ULL'
'\tULL MOON '
'\x02UM'
'\x08UMBRELLA'
'\x05UMBS '
'\x05UMPET'
'\x02UN'
'\x07UN MEUT'
'\x0bUND PUSHPIN'
'\x14UNDRED POINTS SYMBOL'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x1aUP POINTING BACKHAND INDEX'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\x0fUPLE WITH HEART'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x0eUR LEAF CLOVER'
'\x05URINE'
'\nURIPIGMENT'
'\x08UROPEAN '
'\x07US TENT'
'\nUSHED FACE'
'\x07USHENNA'
'\x02UT'
'\x0bUT AND BOLT'
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\tVANAGARI '
'\x07VAPOURS'
'\x02VD'
'\x02VE'
'\x03VE '
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\x0eVENIENCE STORE'
'\rVERGREEN TREE'
'\x10VERTED PENTAGRAM'
'\x0bVERTICALLY '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\nVIE CAMERA'
'\x0eVING HAND SIGN'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x08VOCALIC '
'\x11VOCALIZATION MARK'
'\x0eVOLVING HEARTS'
'\x03VOP'
'\x11VOWEL LENGTH MARK'
'\x0bVOWEL SIGN '
'\x02VS'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\x08W PRINTS'
'\x02WA'
'\x04WAEN'
'\x04WAET'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x03WER'
'\x11WER PLAYING CARDS'
'\x05WFISH'
'\x0bWHITE JOKER'
'\x06WIMMER'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN-POINTING '
'\x02WO'
'\x08WO DOTS '
'\x06WO OF '
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x04WORK'
'\x06WORKER'
'\tWRY SMILE'
'\x05WUAET'
'\x01X'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x15XTRATERRESTRIAL ALIEN'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x02YA'
'\x03YAI'
'\x02YE'
'\x03YEE'
'\x0cYELLOW HEART'
'\x08YEN SIGN'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x10YIR MKPARAQ MEUN'
'\x0cYMBOL BINDU '
'\x02YO'
'\x06YRINGE'
'\x01Z'
'\x0eZAKAYA LANTERN'
'\x04ZERO'
'\x02ZY'
'\x04ZZY '
)
_charnodes =[66667,
 -63999,
 -1,
 131989,
 723,
 -1,
 197428,
 72317,
 -1,
 262370,
 134265,
 -1,
 327744,
 203416,
 -1,
 393247,
 266291,
 -1,
 458767,
 333172,
 -1,
 524298,
 403503,
 -1,
 -65527,
 466669,
 92598,
 -1,
 530732,
 92619,
 720909,
 462416,
 -1,
 -65524,
 666882,
 92543,
 -1,
 721751,
 92553,
 983039,
 656083,
 92531,
 -1,
 853044,
 92601,
 1048600,
 397363,
 -1,
 1114132,
 993327,
 -1,
 -65518,
 1057093,
 92550,
 -65517,
 1122029,
 92624,
 -1,
 1180559,
 92563,
 1441791,
 1051767,
 -1,
 1441815,
 1321019,
 92607,
 -1,
 1386002,
 92535,
 -1,
 1379564,
 92557,
 1638426,
 993339,
 92640,
 -1,
 1582610,
 92657,
 1769501,
 1580059,
 -1,
 -65508,
 1712317,
 92544,
 -1,
 1777389,
 92541,
 -65506,
 1707686,
 92579,
 -1,
 1901267,
 92658,
 2097193,
 330370,
 -1,
 2162725,
 2032339,
 -1,
 2228260,
 2097877,
 -1,
 -65501,
 2172172,
 92562,
 -1,
 2235023,
 92637,
 -1,
 2170605,
 92518,
 2490408,
 2101942,
 -1,
 -65497,
 2433213,
 92558,
 -1,
 2491641,
 92592,
 -1,
 2435339,
 92528,
 2752559,
 2037050,
 -1,
 2818094,
 2690167,
 -1,
 2883629,
 2755703,
 92628,
 -1,
 2818153,
 92648,
 -1,
 2828906,
 92547,
 -1,
 2753377,
 92554,
 3145780,
 2696207,
 -1,
 3211315,
 3090479,
 -1,
 -65486,
 3153292,
 92527,
 -1,
 3214455,
 92545,
 -1,
 3150632,
 92540,
 3473463,
 3091914,
 -1,
 -65482,
 3418590,
 92609,
 -1,
 3474681,
 92583,
 3670074,
 3419550,
 -1,
 -65479,
 3606814,
 92589,
 -1,
 3671643,
 92608,
 3866685,
 3614226,
 -1,
 -65476,
 3811571,
 92604,
 -1,
 3867865,
 92622,
 4063295,
 3801811,
 92662,
 -1,
 4000887,
 92613,
 -1,
 4003378,
 92584,
 4259928,
 270061,
 -1,
 4325447,
 4204591,
 92576,
 4390981,
 4260563,
 -1,
 -65468,
 4333757,
 92618,
 -1,
 4394103,
 92529,
 -65466,
 4331820,
 92561,
 -1,
 4525175,
 92649,
 4718669,
 4260563,
 -1,
 4784202,
 4653779,
 92524,
 -1,
 4725036,
 92536,
 4980735,
 4718917,
 -1,
 -65460,
 4856082,
 92634,
 -1,
 4918699,
 92625,
 5111889,
 4657846,
 92663,
 5242879,
 5049463,
 -1,
 -65456,
 5121554,
 92621,
 -1,
 5180849,
 92593,
 5374038,
 5049463,
 -1,
 5439573,
 5318703,
 -1,
 -65452,
 5385474,
 92647,
 -1,
 5449234,
 92605,
 -1,
 5377333,
 92548,
 5767167,
 5315611,
 92568,
 -1,
 5643500,
 92610,
 5832811,
 4200748,
 -1,
 5898334,
 5767891,
 92667,
 5963868,
 5835895,
 92600,
 -1,
 5904684,
 92542,
 -65443,
 5906621,
 92668,
 -1,
 6037229,
 92555,
 6226016,
 5837494,
 92654,
 -1,
 6163689,
 92611,
 6357091,
 6164597,
 -1,
 -65438,
 6294846,
 92581,
 -1,
 6357715,
 92551,
 6553702,
 6293028,
 -1,
 -65435,
 6498547,
 92520,
 -1,
 6556791,
 92582,
 -65433,
 6499075,
 92617,
 -65432,
 6694971,
 92614,
 -65431,
 6757612,
 92671,
 -65430,
 6819703,
 92591,
 -1,
 6884670,
 92666,
 7078014,
 5776914,
 -1,
 7143538,
 7013075,
 -1,
 7209071,
 7078611,
 92635,
 -1,
 7151805,
 92577,
 -65424,
 7151805,
 92636,
 -65423,
 7280940,
 92530,
 -1,
 7343429,
 92559,
 7536758,
 7088175,
 -1,
 7602293,
 7477548,
 92586,
 -1,
 7537478,
 92569,
 -1,
 7537478,
 92566,
 7798906,
 7478299,
 -1,
 7864441,
 7740443,
 92537,
 -1,
 7805592,
 92519,
 -1,
 7807165,
 92630,
 8126463,
 7736439,
 -1,
 8126589,
 8005679,
 92669,
 -1,
 8061829,
 92572,
 -1,
 8067736,
 92672,
 8323216,
 7023956,
 -1,
 8388740,
 8267823,
 -1,
 -65407,
 8331453,
 92644,
 -65406,
 8395416,
 92645,
 -65405,
 8457649,
 92594,
 -1,
 8520558,
 92641,
 8716425,
 8326736,
 -1,
 8781959,
 8651590,
 92567,
 -1,
 8726034,
 92623,
 -65400,
 8727810,
 92639,
 -1,
 8853804,
 92606,
 9044108,
 8658378,
 -1,
 -65397,
 8988116,
 92642,
 -1,
 9046491,
 92643,
 9240719,
 8983222,
 -1,
 -65394,
 9184786,
 92590,
 -1,
 9243881,
 92564,
 -1,
 9176281,
 92588,
 9502876,
 8266599,
 -1,
 9568406,
 9441680,
 -1,
 9633940,
 9509915,
 92659,
 -1,
 9576637,
 92660,
 -65387,
 9573492,
 92638,
 -1,
 9703026,
 92580,
 9896089,
 9505911,
 -1,
 -65384,
 9840146,
 92560,
 -1,
 9899127,
 92534,
 -65382,
 9840708,
 92571,
 -65381,
 10034385,
 92525,
 -1,
 10093289,
 92549,
 10289321,
 9442903,
 -1,
 10354851,
 10230811,
 -1,
 10420385,
 10296347,
 -1,
 -65376,
 10364434,
 92556,
 -1,
 10427032,
 92523,
 -65374,
 10363069,
 92664,
 -1,
 10557740,
 92539,
 10748071,
 10289875,
 -1,
 -65371,
 10690749,
 92633,
 -65370,
 10755821,
 92521,
 -1,
 10814500,
 92575,
 -65368,
 10692655,
 92653,
 -1,
 10948191,
 92595,
 11141302,
 10229108,
 -1,
 11206830,
 11085871,
 -1,
 -65364,
 11150866,
 92620,
 -65363,
 11214220,
 92538,
 -1,
 11275830,
 92587,
 11468979,
 11144311,
 -1,
 11534514,
 11413551,
 -1,
 -65359,
 11480322,
 92646,
 -1,
 11535174,
 92570,
 -1,
 11478546,
 92599,
 -65356,
 11411348,
 92532,
 -65355,
 11738139,
 92665,
 -1,
 11801270,
 92670,
 11993282,
 11079453,
 -1,
 12058814,
 11937839,
 -1,
 12124348,
 11993088,
 -1,
 -65350,
 12067312,
 92661,
 -65349,
 12128950,
 92616,
 -1,
 12191638,
 92626,
 12451839,
 12061815,
 92596,
 -1,
 12330514,
 92612,
 12517568,
 11993811,
 92603,
 -1,
 12460221,
 92673,
 -65343,
 12459217,
 92627,
 -1,
 12586217,
 92651,
 12779727,
 11931699,
 -1,
 12845260,
 12718480,
 -1,
 12910794,
 12782711,
 -1,
 12976329,
 12855343,
 -1,
 -65337,
 12922114,
 92552,
 -65336,
 12982936,
 92565,
 -1,
 13042502,
 92615,
 -1,
 12920338,
 92602,
 -65333,
 12852433,
 92674,
 -1,
 13239024,
 92578,
 13500415,
 12781092,
 -1,
 -65330,
 13380202,
 92597,
 -1,
 13444626,
 92585,
 13631701,
 12722445,
 -1,
 13697235,
 13566675,
 -1,
 -65326,
 13639869,
 92526,
 -1,
 13700215,
 92656,
 -65324,
 13636524,
 92546,
 -1,
 13831886,
 92655,
 14024922,
 13577104,
 -1,
 14090457,
 13969455,
 -1,
 -65320,
 14031899,
 92533,
 -1,
 14093431,
 92650,
 -1,
 14028494,
 92574,
 14352607,
 13970029,
 -1,
 14418142,
 14290039,
 -1,
 -65315,
 14362683,
 92573,
 -1,
 14421111,
 92652,
 -1,
 14359761,
 92522,
 -65312,
 14294043,
 92631,
 -65311,
 14619318,
 92632,
 -1,
 14680787,
 92629,
 14877065,
 199300,
 -1,
 14942487,
 14817944,
 -1,
 15007989,
 14880819,
 -1,
 15073517,
 14947700,
 -1,
 15139049,
 15011408,
 -1,
 -65304,
 15082023,
 92432,
 -1,
 15139717,
 92457,
 -65302,
 15084924,
 92435,
 -65301,
 15280395,
 92412,
 -65300,
 15340328,
 92476,
 -1,
 15402201,
 92414,
 15663103,
 15011891,
 -1,
 15663346,
 15532755,
 -1,
 15728881,
 15598628,
 92465,
 -1,
 15663942,
 92409,
 -1,
 15671021,
 92483,
 -65293,
 15608754,
 92467,
 -65292,
 15870289,
 92485,
 -1,
 15929038,
 92475,
 16122109,
 14947642,
 -1,
 16187640,
 16061110,
 92403,
 -1,
 16125161,
 92405,
 16318715,
 16125520,
 -1,
 -65286,
 16262674,
 92407,
 -1,
 16319319,
 92430,
 -65284,
 16263384,
 92487,
 -1,
 16450777,
 92418,
 16646405,
 16065383,
 -1,
 16711937,
 16585512,
 -1,
 -65280,
 16655890,
 92459,
 -1,
 16719597,
 92447,
 16908548,
 16650640,
 -1,
 -65277,
 16853554,
 92486,
 -1,
 16911593,
 92408,
 -1,
 16853235,
 92480,
 17170698,
 16592212,
 -1,
 -65273,
 17115321,
 92463,
 -65272,
 17175222,
 92493,
 -65271,
 17239606,
 92450,
 -1,
 17302564,
 92410,
 17498384,
 17107586,
 -1,
 17563918,
 17435767,
 -1,
 -65267,
 17508970,
 92425,
 -1,
 17566839,
 92437,
 -65265,
 17505516,
 92440,
 -1,
 17695780,
 92471,
 17891605,
 17442322,
 -1,
 17957140,
 17828983,
 -1,
 -65261,
 17901811,
 92472,
 -1,
 17960055,
 92505,
 -1,
 17902183,
 92514,
 -65258,
 17836079,
 92503,
 -1,
 18158262,
 92507,
 18350386,
 14883116,
 92497,
 18415903,
 18288413,
 -1,
 18481435,
 18357275,
 92445,
 -1,
 18422424,
 92404,
 18612510,
 18419280,
 -1,
 -65251,
 18556434,
 92424,
 -1,
 18613062,
 92458,
 -1,
 18551592,
 92466,
 18874659,
 18354293,
 -1,
 -65247,
 18816133,
 92438,
 -65246,
 18879272,
 92444,
 -1,
 18943621,
 92442,
 19136808,
 18812023,
 -1,
 19202343,
 19081263,
 -1,
 -65242,
 19146258,
 92427,
 -1,
 19208856,
 92478,
 -1,
 19139820,
 92496,
 19464492,
 19072513,
 -1,
 19530027,
 19399401,
 92448,
 -1,
 19464534,
 92515,
 -1,
 19474766,
 92401,
 19726639,
 19399379,
 -1,
 -65234,
 19666753,
 92426,
 -1,
 19729779,
 92482,
 -65232,
 19671906,
 92510,
 -65231,
 19867695,
 92499,
 -1,
 19930474,
 92441,
 20119877,
 18293607,
 -1,
 20185404,
 20058512,
 -1,
 20250937,
 20122743,
 -1,
 20316472,
 20195375,
 -1,
 -65225,
 20262146,
 92501,
 -1,
 20316998,
 92417,
 -1,
 20253815,
 92413,
 -65222,
 20195375,
 92504,
 -65221,
 20520391,
 92508,
 -1,
 20583298,
 92500,
 20775232,
 20129839,
 -1,
 -65218,
 20719663,
 92498,
 -65217,
 20778103,
 92419,
 -1,
 20841286,
 92473,
 21037379,
 20710099,
 -1,
 -65214,
 20979901,
 92516,
 -1,
 21044973,
 92423,
 -65212,
 20979246,
 92452,
 -1,
 21171826,
 92428,
 21365075,
 20059508,
 -1,
 21430605,
 21302391,
 -1,
 21496140,
 21375023,
 -1,
 -65207,
 21438189,
 92460,
 -65206,
 21503548,
 92431,
 -65205,
 21567788,
 92454,
 -1,
 21627803,
 92415,
 -1,
 21440018,
 92420,
 21889361,
 21375023,
 92489,
 -65201,
 21831869,
 92479,
 -65200,
 21896401,
 92422,
 -1,
 21961368,
 92474,
 -65198,
 21835132,
 92502,
 -1,
 22096823,
 92449,
 22282591,
 21308946,
 -1,
 22348122,
 22219895,
 -1,
 22413657,
 22292527,
 -1,
 -65193,
 22357522,
 92416,
 -65192,
 22420120,
 92481,
 -1,
 22479726,
 92451,
 -1,
 22351084,
 92456,
 22741340,
 22292527,
 92433,
 -1,
 22683182,
 92477,
 -65187,
 22683079,
 92492,
 -65186,
 22811318,
 92513,
 -1,
 22872902,
 92491,
 23069033,
 22222423,
 -1,
 23134566,
 23006327,
 -1,
 23200100,
 23078959,
 -1,
 -65181,
 23140652,
 92484,
 -1,
 23200635,
 92439,
 -65179,
 23143954,
 92464,
 -1,
 23334124,
 92495,
 -65177,
 23079155,
 92446,
 -65176,
 23469511,
 92511,
 -1,
 23532328,
 92406,
 23724402,
 23011053,
 -1,
 23789933,
 23668783,
 -1,
 -65172,
 23734834,
 92443,
 -1,
 23797949,
 92509,
 23986544,
 23727223,
 -1,
 -65169,
 23931457,
 92462,
 -1,
 23989367,
 92506,
 -65167,
 23925873,
 92461,
 -1,
 24118489,
 92469,
 24314234,
 23670100,
 -1,
 24379768,
 24258607,
 -1,
 24445303,
 24321051,
 -1,
 -65162,
 24387309,
 92470,
 -1,
 24451372,
 92468,
 -1,
 24390882,
 92453,
 -65159,
 24317246,
 92429,
 -1,
 24642407,
 92421,
 24838528,
 24256781,
 -1,
 24904062,
 24776001,
 -1,
 -65155,
 24845501,
 92490,
 -1,
 24910456,
 92512,
 -65153,
 24843138,
 92494,
 -1,
 25035607,
 92455,
 25231747,
 24783760,
 -1,
 -65150,
 25176132,
 92411,
 -1,
 25232601,
 92402,
 25428358,
 25170167,
 -1,
 -65147,
 25366106,
 92488,
 -1,
 25428713,
 92434,
 25690111,
 25366301,
 -1,
 -65144,
 25562744,
 92436,
 -1,
 25625321,
 92517,
 25821724,
 14813050,
 -1,
 25887166,
 25762456,
 -1,
 25952664,
 25825331,
 -1,
 26018195,
 25890867,
 -1,
 26083730,
 25962543,
 92362,
 -65137,
 26025196,
 92341,
 -65136,
 26089772,
 92347,
 -65135,
 26152200,
 92370,
 -1,
 26215282,
 92336,
 -1,
 26021182,
 92307,
 26476950,
 25957748,
 -1,
 -65131,
 26421440,
 92303,
 -1,
 26477817,
 92309,
 -65129,
 26418385,
 92368,
 -1,
 26608889,
 92395,
 26804640,
 25895783,
 -1,
 26870172,
 26748975,
 -1,
 -65125,
 26811973,
 92359,
 -1,
 26876568,
 92374,
 -65123,
 26811601,
 92371,
 -65122,
 27005388,
 92351,
 -65121,
 27070053,
 92325,
 -1,
 27132627,
 92350,
 27328937,
 26741378,
 -1,
 27394468,
 27266640,
 -1,
 -65117,
 27338258,
 92349,
 -1,
 27394953,
 92308,
 27591079,
 27329235,
 -1,
 -65114,
 27533037,
 92378,
 -1,
 27597100,
 92375,
 -65112,
 27532509,
 92317,
 -1,
 27726617,
 92331,
 27918769,
 27268410,
 -1,
 27984301,
 27855991,
 -1,
 -65108,
 27929194,
 92389,
 -1,
 27987180,
 92360,
 28180912,
 27919059,
 -1,
 -65105,
 28121388,
 92367,
 -1,
 28183861,
 92356,
 -1,
 28125400,
 92333,
 28443063,
 27862546,
 -1,
 28508597,
 28380279,
 -1,
 -65100,
 28453182,
 92345,
 -1,
 28514968,
 92372,
 -65098,
 28452916,
 92314,
 -1,
 28639977,
 92340,
 28836282,
 28388810,
 -1,
 -65095,
 28774017,
 92323,
 -1,
 28836563,
 92304,
 29032893,
 28771027,
 -1,
 -65092,
 28975293,
 92396,
 -1,
 29039547,
 92338,
 -1,
 28978594,
 92313,
 29295067,
 25827628,
 -1,
 29360593,
 29230593,
 -1,
 29426118,
 29297783,
 -1,
 29491652,
 29370415,
 -1,
 -65085,
 29437186,
 92385,
 -1,
 29497644,
 92315,
 -65083,
 29434181,
 92354,
 -1,
 29625642,
 92311,
 29819337,
 29364918,
 92381,
 -65080,
 29763090,
 92326,
 -1,
 29827650,
 92343,
 30015950,
 29754067,
 -1,
 30081485,
 29950677,
 -1,
 -65076,
 30023604,
 92387,
 -1,
 30082944,
 92318,
 -1,
 30022673,
 92383,
 30408703,
 29960239,
 -1,
 -65072,
 30280823,
 92324,
 -1,
 30344023,
 92364,
 30540248,
 29295315,
 -1,
 30605781,
 30477431,
 -1,
 -65068,
 30549060,
 92363,
 -1,
 30611868,
 92382,
 30867455,
 30539776,
 -1,
 -65065,
 30743490,
 92376,
 -1,
 30807545,
 92339,
 -65063,
 30484539,
 92391,
 -65062,
 30937896,
 92390,
 -1,
 31002750,
 92344,
 31195628,
 29234548,
 -1,
 31261159,
 31132791,
 -1,
 31326691,
 31205423,
 -1,
 31392225,
 31269735,
 -1,
 -65056,
 31330841,
 92319,
 -1,
 31395534,
 92384,
 -65054,
 31332652,
 92386,
 -1,
 31528392,
 92321,
 31719910,
 31267482,
 -1,
 -65051,
 31659716,
 92393,
 -1,
 31723372,
 92394,
 -1,
 31663634,
 92361,
 31982058,
 31205423,
 -1,
 -65047,
 31925778,
 92366,
 -1,
 31989135,
 92373,
 -65045,
 31924023,
 92328,
 -1,
 32113385,
 92329,
 32309747,
 31141204,
 -1,
 32375281,
 32253999,
 -1,
 -65041,
 32320738,
 92388,
 -65040,
 32381228,
 92305,
 -1,
 32440558,
 92322,
 -65038,
 32312988,
 92327,
 -1,
 32572137,
 92377,
 32768507,
 32253458,
 -1,
 32834039,
 32707789,
 -1,
 -65034,
 32778313,
 92358,
 -1,
 32834271,
 92334,
 33030650,
 32771191,
 -1,
 -65031,
 32975441,
 92346,
 -1,
 33039890,
 92400,
 -1,
 32965372,
 92332,
 33292803,
 32711527,
 -1,
 33358335,
 33231248,
 -1,
 -65026,
 33302744,
 92379,
 -1,
 33363060,
 92392,
 33554946,
 33295479,
 -1,
 -65023,
 33499754,
 92330,
 -1,
 33564348,
 92380,
 -1,
 33499221,
 92335,
 33817097,
 33232471,
 -1,
 33882631,
 33751763,
 -1,
 -65018,
 33824493,
 92342,
 -1,
 33888556,
 92357,
 -65016,
 33826863,
 92365,
 -1,
 34018420,
 92397,
 34210318,
 33758957,
 -1,
 34275853,
 34149046,
 -1,
 -65012,
 34218562,
 92316,
 -1,
 34282136,
 92398,
 -1,
 34213182,
 92399,
 34538003,
 34148403,
 -1,
 34603538,
 34476434,
 -1,
 -65007,
 34545989,
 92310,
 -1,
 34610925,
 92320,
 -1,
 34539026,
 92312,
 34865686,
 34483088,
 -1,
 -65003,
 34810201,
 92369,
 -1,
 34866333,
 92306,
 35062297,
 34810603,
 -1,
 -65000,
 35007746,
 92337,
 -1,
 35062655,
 92353,
 -64998,
 35005267,
 92355,
 -64997,
 35196975,
 92348,
 -1,
 35260243,
 92352,
 35455642,
 25756373,
 -1,
 35521088,
 35396248,
 -1,
 35586596,
 35464722,
 -1,
 35652131,
 35521753,
 92223,
 35782655,
 35586048,
 -1,
 -64990,
 35658726,
 92194,
 -1,
 35723811,
 92185,
 -1,
 35593691,
 92178,
 35979818,
 35524659,
 -1,
 36045352,
 35919427,
 -1,
 -64985,
 35986453,
 92182,
 -1,
 36045025,
 92160,
 -64983,
 35983576,
 92229,
 -1,
 36177069,
 92173,
 36373038,
 35925332,
 -1,
 36438573,
 36311734,
 92239,
 -1,
 36382268,
 92225,
 -1,
 36376118,
 92233,
 36635185,
 36318666,
 -1,
 -64976,
 36579598,
 92191,
 -1,
 36635352,
 92167,
 36831796,
 36578319,
 -1,
 -64973,
 36770600,
 92237,
 -1,
 36831955,
 92241,
 37028407,
 36771188,
 -1,
 -64970,
 36967389,
 92180,
 -1,
 37028598,
 92227,
 37225018,
 36965052,
 -1,
 -64967,
 37160083,
 92212,
 -1,
 37224620,
 92201,
 37421629,
 37159635,
 -1,
 -64964,
 37363901,
 92245,
 -1,
 37421784,
 92164,
 -64962,
 37360968,
 92231,
 -64961,
 37557125,
 92204,
 -1,
 37621054,
 92244,
 37814871,
 35461420,
 -1,
 37880396,
 37749459,
 -1,
 37945930,
 37817463,
 -1,
 38011463,
 37886252,
 92238,
 -64955,
 37956350,
 92174,
 -64954,
 38016574,
 92203,
 -1,
 38078051,
 92171,
 -64952,
 37954628,
 92230,
 -64951,
 38214673,
 92210,
 -1,
 38278657,
 92186,
 -64949,
 37887730,
 92221,
 -1,
 38411208,
 92175,
 38601297,
 37821467,
 -1,
 38666832,
 38542545,
 -1,
 -64945,
 38609053,
 92198,
 -1,
 38670026,
 92214,
 -1,
 38607517,
 92190,
 38928980,
 38536710,
 -1,
 -64941,
 38871229,
 92246,
 -1,
 38935569,
 92232,
 -64939,
 38873839,
 92176,
 -64938,
 39063672,
 92196,
 -1,
 39128713,
 92197,
 39322215,
 37757799,
 -1,
 39387744,
 39260560,
 -1,
 39453276,
 39331887,
 -1,
 -64933,
 39393580,
 92215,
 -1,
 39456147,
 92165,
 39649887,
 39391926,
 -1,
 -64930,
 39592261,
 92222,
 -1,
 39656174,
 92168,
 -1,
 39591374,
 92224,
 39912036,
 39328795,
 -1,
 -64926,
 39855634,
 92235,
 -64925,
 39919805,
 92220,
 -1,
 39983944,
 92208,
 -64923,
 39856743,
 92181,
 -64922,
 40113314,
 92195,
 -1,
 40177301,
 92177,
 40370808,
 39263981,
 -1,
 40436335,
 40305363,
 -1,
 40501868,
 40370899,
 -1,
 -64917,
 40444229,
 92226,
 -1,
 40507692,
 92236,
 -64915,
 40444960,
 92187,
 -64914,
 40639090,
 92189,
 -1,
 40698028,
 92200,
 40895094,
 40377583,
 -1,
 40960627,
 40836884,
 -1,
 -64910,
 40898693,
 92169,
 -1,
 40961542,
 92170,
 41222143,
 40901160,
 -1,
 -64907,
 41095301,
 92162,
 -1,
 41158150,
 92163,
 -64905,
 40839513,
 92205,
 -1,
 41291318,
 92202,
 41484929,
 40310132,
 -1,
 41550460,
 41421943,
 -1,
 -64901,
 41494748,
 92179,
 -1,
 41559570,
 92211,
 41747071,
 41485011,
 -1,
 -64898,
 41689277,
 92240,
 -1,
 41750306,
 92199,
 -64896,
 41691477,
 92213,
 -1,
 41885744,
 92219,
 42074761,
 41428498,
 -1,
 42140293,
 42018863,
 -1,
 -64892,
 42075003,
 92206,
 -1,
 42139859,
 92172,
 42336904,
 42077776,
 -1,
 -64889,
 42280629,
 92209,
 -1,
 42337134,
 92234,
 -1,
 42276059,
 92166,
 42599055,
 42014295,
 -1,
 42664588,
 42543151,
 92243,
 -1,
 42599291,
 92207,
 -64883,
 42605794,
 92216,
 -64882,
 42733113,
 92184,
 -1,
 42796252,
 92183,
 42992276,
 42537011,
 -1,
 43057811,
 42930707,
 -1,
 -64878,
 43000133,
 92188,
 -1,
 43061505,
 92193,
 -1,
 42993304,
 92161,
 43319959,
 42936367,
 -1,
 -64874,
 43260775,
 92228,
 -1,
 43319900,
 92192,
 -64872,
 43264651,
 92242,
 -64871,
 43459318,
 92218,
 -1,
 43519908,
 92217,
 43713259,
 35390979,
 -1,
 43778734,
 43653420,
 -1,
 43844259,
 43714049,
 -1,
 43909792,
 43778771,
 -1,
 -64865,
 43844863,
 92255,
 -1,
 43909323,
 92252,
 -64863,
 43854165,
 92292,
 -64862,
 44045520,
 92268,
 -1,
 44109485,
 92286,
 44303015,
 43778771,
 92300,
 44433407,
 44237046,
 -1,
 -64858,
 44313057,
 92296,
 -1,
 44371563,
 92295,
 44565162,
 44240669,
 -1,
 -64855,
 44506355,
 92267,
 -1,
 44569887,
 92284,
 44761773,
 44502608,
 -1,
 -64852,
 44705353,
 92290,
 -1,
 44769469,
 92281,
 -1,
 44703104,
 92287,
 45023935,
 43719320,
 -1,
 45089463,
 44961843,
 -1,
 45154997,
 45027379,
 -1,
 45220531,
 45099349,
 92282,
 -1,
 45154469,
 92283,
 -64844,
 45157971,
 92277,
 -1,
 45286124,
 92298,
 -64842,
 45096145,
 92302,
 -1,
 45422099,
 92276,
 45613754,
 45034836,
 -1,
 -64839,
 45552327,
 92269,
 -1,
 45613915,
 92288,
 45810365,
 45556583,
 -1,
 -64836,
 45748902,
 92247,
 -1,
 45813054,
 92299,
 -64834,
 45754174,
 92260,
 -1,
 45943872,
 92261,
 46138055,
 44966759,
 -1,
 46203587,
 46076372,
 -1,
 -64830,
 46147662,
 92266,
 -1,
 46212690,
 92265,
 -64828,
 46147769,
 92285,
 -64827,
 46338856,
 92249,
 -64826,
 46403136,
 92250,
 -1,
 46466030,
 92279,
 46662352,
 46077300,
 -1,
 46727884,
 46599760,
 -1,
 -64822,
 46673302,
 92272,
 -64821,
 46735517,
 92270,
 -1,
 46793559,
 92294,
 46990031,
 46666422,
 -1,
 -64818,
 46932157,
 92301,
 -1,
 46992629,
 92253,
 -1,
 46924836,
 92256,
 47252181,
 46604013,
 -1,
 -64814,
 47196471,
 92289,
 -64813,
 47256781,
 92263,
 -64812,
 47320322,
 92257,
 -1,
 47383901,
 92274,
 47579867,
 47191639,
 -1,
 47645401,
 47514323,
 -1,
 -64808,
 47585582,
 92259,
 -1,
 47645789,
 92273,
 -64806,
 47586516,
 92251,
 -1,
 47779382,
 92297,
 47973088,
 47523346,
 -1,
 48038623,
 47917105,
 -1,
 -64802,
 47979458,
 92264,
 -1,
 48044358,
 92248,
 -1,
 47973100,
 92280,
 48300771,
 47918420,
 -1,
 -64798,
 48238240,
 92254,
 -1,
 48301002,
 92258,
 48497382,
 48238856,
 -1,
 -64795,
 48441407,
 92262,
 -1,
 48503448,
 92271,
 48693993,
 48435060,
 -1,
 -64792,
 48638570,
 92291,
 -1,
 48696439,
 92293,
 -64790,
 48639228,
 92278,
 -1,
 48835321,
 92275,
 49086463,
 43650847,
 -1,
 49087226,
 48962200,
 -1,
 49152751,
 49031215,
 92697,
 -1,
 49087302,
 92696,
 49283826,
 49091898,
 -1,
 -64783,
 49227835,
 92698,
 -1,
 49283927,
 92688,
 49480437,
 49221683,
 -1,
 -64780,
 49419847,
 92711,
 -1,
 49483858,
 92712,
 -64778,
 49425819,
 92681,
 -64777,
 49620628,
 92704,
 -64776,
 49685532,
 92702,
 -64775,
 49746614,
 92708,
 -1,
 49810111,
 92687,
 50004739,
 49029991,
 -1,
 50070271,
 49942928,
 -1,
 -64771,
 50014255,
 92700,
 -64770,
 50076699,
 92713,
 -1,
 50140034,
 92691,
 -64768,
 50014823,
 92690,
 -64767,
 50270902,
 92692,
 -64766,
 50335438,
 92693,
 -1,
 50398247,
 92727,
 50594572,
 49943924,
 -1,
 50660103,
 50531447,
 -1,
 -64762,
 50603538,
 92695,
 -1,
 50666136,
 92710,
 -64760,
 50605436,
 92694,
 -64759,
 50800687,
 92677,
 -64758,
 50863889,
 92726,
 -64757,
 50928667,
 92719,
 -1,
 50987731,
 92675,
 51184405,
 50536717,
 -1,
 51249937,
 51121271,
 -1,
 -64753,
 51194474,
 92709,
 -64752,
 51255960,
 92721,
 -1,
 51317879,
 92679,
 51512084,
 51188406,
 -1,
 -64749,
 51450550,
 92683,
 -1,
 51514601,
 92684,
 -1,
 51456047,
 92707,
 51774236,
 51124524,
 92689,
 51839769,
 51709441,
 -1,
 -64744,
 51776830,
 92720,
 -1,
 51839721,
 92724,
 -64742,
 51780635,
 92723,
 -64741,
 51973360,
 92685,
 -1,
 52036307,
 92722,
 52232993,
 51717650,
 -1,
 52298528,
 52167379,
 -1,
 -64737,
 52235383,
 92680,
 -1,
 52298451,
 92686,
 -1,
 52235830,
 92725,
 52560678,
 52174573,
 -1,
 52626213,
 52497527,
 -1,
 -64732,
 52570730,
 92703,
 -1,
 52628599,
 92706,
 -1,
 52570171,
 92714,
 52888362,
 52500055,
 -1,
 -64728,
 52829639,
 92718,
 -64727,
 52892342,
 92717,
 -1,
 52953811,
 92682,
 53150509,
 52833620,
 -1,
 -64724,
 53091783,
 92699,
 -1,
 53150419,
 92701,
 53347120,
 53095312,
 -1,
 -64721,
 53291193,
 92705,
 -1,
 53347027,
 92716,
 -64719,
 53291911,
 92728,
 -64718,
 53487663,
 92676,
 -64717,
 53546964,
 92715,
 -1,
 53611753,
 92678,
 53805950,
 140818,
 -1,
 53871483,
 53740522,
 -1,
 53936994,
 53811088,
 -1,
 54002501,
 53879655,
 -1,
 54068035,
 53941153,
 -1,
 -64710,
 54013298,
 7132,
 -64709,
 54078383,
 7116,
 -64708,
 54141867,
 7129,
 -64707,
 54206779,
 7123,
 -64706,
 54271761,
 7112,
 -64705,
 54335811,
 7125,
 -64704,
 54400632,
 7135,
 -64703,
 54464914,
 7107,
 -64702,
 54530130,
 7119,
 -1,
 54592211,
 7105,
 -64700,
 54009524,
 7126,
 -1,
 54723283,
 7128,
 54920011,
 53942936,
 -1,
 -64697,
 54865266,
 7136,
 -64696,
 54926877,
 7127,
 -64695,
 54988882,
 7133,
 -64694,
 55052988,
 7138,
 -1,
 55116499,
 7113,
 55313234,
 54860076,
 -1,
 55378769,
 55247571,
 7124,
 55508991,
 55319289,
 -1,
 -64689,
 55387051,
 7130,
 -64688,
 55450311,
 7114,
 -1,
 55513490,
 7108,
 -1,
 55313926,
 7139,
 55771988,
 55254801,
 7111,
 -1,
 55711286,
 7117,
 -64683,
 55717234,
 7131,
 -64682,
 55847855,
 7115,
 -64681,
 55912495,
 7141,
 -64680,
 55976251,
 7122,
 -64679,
 56039032,
 7134,
 -64678,
 56104402,
 7110,
 -64677,
 56169788,
 7120,
 -64676,
 56234678,
 7140,
 -64675,
 56299922,
 7106,
 -64674,
 56365138,
 7118,
 -64673,
 56429244,
 7121,
 -64672,
 56493949,
 7137,
 -64671,
 56559110,
 7109,
 -1,
 56623827,
 7104,
 56820589,
 53881720,
 -1,
 56886117,
 56764463,
 7150,
 -1,
 56819837,
 7151,
 57017192,
 56825292,
 -1,
 -64665,
 56957979,
 7149,
 -1,
 57021110,
 7147,
 57213802,
 56953975,
 7143,
 -1,
 57150583,
 7145,
 -64661,
 57155362,
 7144,
 -64660,
 57285659,
 7148,
 -1,
 57348790,
 7146,
 57541493,
 56763239,
 -1,
 57607028,
 57486771,
 -1,
 57672562,
 57548525,
 -1,
 -64655,
 57611189,
 7165,
 -1,
 57672869,
 7167,
 -64653,
 57613002,
 7164,
 -1,
 57808238,
 7166,
 -1,
 57545592,
 7142,
 58065784,
 57483051,
 -1,
 -64649,
 58006882,
 7155,
 -1,
 58069358,
 7154,
 58327039,
 58001819,
 -1,
 -64646,
 58202911,
 7152,
 -1,
 58266000,
 7153,
 58459005,
 53809552,
 128704,
 -1,
 58402809,
 128705,
 -1,
 58402480,
 128267,
 58655622,
 53746328,
 -1,
 58721157,
 58594676,
 127974,
 58851327,
 58661798,
 -1,
 -64638,
 58731917,
 128180,
 -64637,
 58794048,
 128183,
 -64636,
 58855090,
 128182,
 -1,
 58919776,
 128181,
 -1,
 58655833,
 127820,
 59179916,
 58591093,
 128118,
 59310079,
 59113472,
 -1,
 -64631,
 59188711,
 128700,
 -64630,
 59246748,
 128036,
 -64629,
 59311883,
 127868,
 -1,
 59376781,
 128124,
 59573135,
 59121933,
 -1,
 -64626,
 59508291,
 128136,
 -1,
 59572302,
 128202,
 59769746,
 59508600,
 -1,
 -64623,
 59713464,
 128043,
 -1,
 59774348,
 128281,
 -64621,
 59712676,
 127936,
 -64620,
 59906180,
 127880,
 -1,
 59969767,
 128708,
 60163121,
 73997,
 -1,
 60228650,
 60097500,
 -1,
 60294107,
 60168080,
 -1,
 60359583,
 60238445,
 -1,
 60425118,
 60300354,
 -1,
 60490652,
 60367117,
 69643,
 -1,
 60432653,
 69644,
 60686335,
 60429911,
 69645,
 -1,
 60560983,
 69646,
 -1,
 60359379,
 69679,
 60818341,
 60302866,
 -1,
 60883875,
 60761618,
 -1,
 -64606,
 60821906,
 69662,
 -1,
 60883667,
 69661,
 -64604,
 60821906,
 69667,
 -1,
 61014739,
 69666,
 61211562,
 60759067,
 69649,
 61341695,
 61150961,
 -1,
 -64600,
 61219609,
 69686,
 -64599,
 61283207,
 69687,
 -1,
 61347967,
 69685,
 61539247,
 61151896,
 -1,
 -64596,
 61484402,
 69660,
 -64595,
 61545159,
 69665,
 -64594,
 61608018,
 69655,
 -1,
 61670099,
 69670,
 61866933,
 61475458,
 -1,
 61932467,
 61803138,
 -1,
 -64590,
 61870482,
 69664,
 -1,
 61932243,
 69663,
 -64588,
 61870482,
 69669,
 -1,
 62063315,
 69668,
 62260153,
 61801171,
 69637,
 -64585,
 62203951,
 69650,
 -64584,
 62263990,
 69648,
 -1,
 62325459,
 69638,
 62522301,
 62202727,
 -1,
 -64581,
 62464939,
 69681,
 -64580,
 62525842,
 69680,
 -1,
 62587603,
 69682,
 62784447,
 62466095,
 69641,
 -1,
 62728239,
 69642,
 62915522,
 62725869,
 -1,
 -64575,
 62853522,
 69672,
 -1,
 62915283,
 69671,
 63112133,
 62854743,
 -1,
 -64572,
 63051384,
 69684,
 -1,
 63111891,
 69678,
 63308744,
 63051124,
 -1,
 -64569,
 63246738,
 69652,
 -1,
 63308499,
 69651,
 63505355,
 63247674,
 -1,
 -64566,
 63443346,
 69659,
 -1,
 63505107,
 69658,
 63701965,
 63443638,
 69639,
 -1,
 63640246,
 69640,
 63833040,
 63639603,
 -1,
 -64561,
 63771026,
 69654,
 -1,
 63832787,
 69653,
 64029651,
 63768440,
 -1,
 -64558,
 63967634,
 69657,
 -1,
 64029395,
 69656,
 64226262,
 63964673,
 -1,
 -64555,
 64164242,
 69674,
 -1,
 64226003,
 69673,
 -64553,
 64171378,
 69676,
 -64552,
 64364859,
 69677,
 -64551,
 64428355,
 69675,
 -64550,
 64491922,
 69683,
 -1,
 64556151,
 69647,
 64750584,
 60234753,
 -1,
 64816100,
 64693778,
 -1,
 64881632,
 64760720,
 -1,
 -64545,
 64822299,
 69715,
 -1,
 64884134,
 69724,
 65078243,
 64819600,
 -1,
 -64542,
 65020390,
 69716,
 -1,
 65082522,
 69725,
 -1,
 65015102,
 69723,
 65340393,
 64758631,
 -1,
 65405927,
 65279239,
 69719,
 -1,
 65349660,
 69728,
 65601535,
 65343186,
 69720,
 -1,
 65480732,
 69729,
 65668080,
 65277725,
 -1,
 65733613,
 65608731,
 -1,
 -64532,
 65677803,
 69717,
 -1,
 65741636,
 69726,
 65994751,
 65671862,
 -1,
 -64529,
 65874564,
 69718,
 -1,
 65933355,
 69727,
 66126836,
 65609008,
 69714,
 66256895,
 66060288,
 -1,
 -64525,
 66135806,
 69733,
 -1,
 66196139,
 69732,
 66388982,
 66067252,
 69722,
 -1,
 66332700,
 69731,
 66584575,
 66325779,
 69721,
 -1,
 66465108,
 69730,
 66651147,
 64694893,
 -1,
 66716682,
 66592470,
 -1,
 66782207,
 66661176,
 -1,
 66847741,
 66724109,
 69694,
 -1,
 66789645,
 69695,
 67043327,
 66786903,
 69696,
 -1,
 66917975,
 69697,
 67109891,
 66716371,
 -1,
 -64511,
 67053615,
 69701,
 -64510,
 67113654,
 69699,
 -1,
 67175123,
 69688,
 67372037,
 67053615,
 69692,
 -1,
 67315759,
 69693,
 67503111,
 67310262,
 69690,
 -1,
 67441334,
 69691,
 -64504,
 67443739,
 69700,
 -64503,
 67570807,
 69698,
 -1,
 67634794,
 69689,
 -1,
 66655365,
 69702,
 67896348,
 66587266,
 -1,
 67961882,
 67834716,
 -1,
 68027408,
 67905042,
 -1,
 -64497,
 67972277,
 69736,
 -1,
 68031111,
 69737,
 68224019,
 67969895,
 -1,
 -64494,
 68162823,
 69740,
 -1,
 68226770,
 69741,
 68420630,
 68161309,
 -1,
 -64491,
 68361874,
 69738,
 -1,
 68424942,
 69739,
 -64489,
 68365787,
 69734,
 -64488,
 68558128,
 69735,
 -64487,
 68623156,
 69743,
 -1,
 68685075,
 69742,
 -64485,
 67903078,
 69704,
 -1,
 68813950,
 69703,
 69010466,
 67839066,
 -1,
 -64482,
 68954912,
 69634,
 -64481,
 69020084,
 69636,
 -64480,
 69080396,
 69635,
 -64479,
 69142454,
 69632,
 -1,
 69207248,
 69633,
 69468159,
 68952208,
 -1,
 69469222,
 69342807,
 -1,
 -64475,
 69410401,
 69709,
 -1,
 69473250,
 69707,
 69665833,
 69405533,
 -1,
 -64472,
 69609577,
 69706,
 -1,
 69674514,
 69705,
 -1,
 69601805,
 69708,
 69927983,
 60166838,
 -1,
 69993518,
 69864066,
 -1,
 -64467,
 69931163,
 127753,
 -1,
 69995667,
 128112,
 -1,
 69930252,
 128188,
 -64464,
 69868702,
 128148,
 -1,
 70192291,
 127838,
 70386755,
 60102231,
 -1,
 70452285,
 70320955,
 -1,
 70517815,
 70394475,
 -1,
 70583350,
 70454176,
 9193,
 -1,
 70517321,
 9197,
 -1,
 70526916,
 9199,
 70779961,
 70457188,
 9194,
 -1,
 70713929,
 9198,
 -64454,
 70723992,
 9195,
 -64453,
 70853952,
 128306,
 -64452,
 70918386,
 10067,
 -1,
 70978519,
 9196,
 71173184,
 70396092,
 -1,
 -64449,
 71111127,
 128153,
 -1,
 71173888,
 128216,
 71434239,
 71113755,
 -1,
 -64446,
 71314429,
 128033,
 -1,
 71378266,
 127804,
 71566417,
 70327323,
 -1,
 71631944,
 71508001,
 -1,
 -64442,
 71577056,
 12730,
 -64441,
 71636965,
 12729,
 -1,
 71700727,
 12728,
 71894092,
 71572635,
 -1,
 71959627,
 71833980,
 128278,
 -1,
 71893357,
 128209,
 -1,
 71902055,
 128218,
 -64435,
 71839060,
 128102,
 -64434,
 72101023,
 127923,
 -64433,
 72165861,
 128144,
 -64432,
 72227225,
 128163,
 -1,
 72287484,
 128023,
 72483931,
 71502967,
 -1,
 72549461,
 72424088,
 -1,
 -64428,
 72492921,
 127857,
 -1,
 72552533,
 983621,
 72746071,
 72489023,
 128276,
 -1,
 72679837,
 128277,
 72877146,
 72680147,
 -1,
 -64423,
 72820590,
 128147,
 -1,
 72884495,
 128059,
 -1,
 72814016,
 127866,
 73139300,
 72422070,
 -1,
 73204831,
 73081101,
 -1,
 -64418,
 73148110,
 127874,
 -1,
 73206402,
 128038,
 73401442,
 73140861,
 -1,
 -64415,
 73340081,
 128692,
 -1,
 73403511,
 128690,
 -64413,
 73341025,
 127921,
 -1,
 73537064,
 128089,
 73793535,
 73082927,
 -1,
 73794666,
 73671527,
 128652,
 73860201,
 73737746,
 -1,
 -64408,
 73802604,
 128101,
 -1,
 73859222,
 128100,
 -1,
 73793895,
 128655,
 -1,
 73732147,
 128027,
 74188299,
 9746,
 -1,
 74253765,
 74121939,
 -1,
 74319297,
 74193460,
 -1,
 74384808,
 74261981,
 -1,
 74450096,
 74324632,
 -1,
 74515594,
 74390168,
 -1,
 74581118,
 74455704,
 -1,
 74646646,
 74515155,
 -1,
 -64396,
 74590255,
 983843,
 -64395,
 74650294,
 983840,
 -1,
 74711763,
 983833,
 74908792,
 74590255,
 983836,
 -1,
 74852399,
 983837,
 75039866,
 74849307,
 983841,
 -1,
 74980379,
 983842,
 75170940,
 74977974,
 983834,
 -1,
 75109046,
 983835,
 75366399,
 75107447,
 983838,
 -1,
 75238519,
 983839,
 75433090,
 74515155,
 -1,
 -64384,
 75376687,
 983711,
 -64383,
 75436726,
 983708,
 -1,
 75498195,
 983701,
 75695236,
 75376687,
 983704,
 -1,
 75638831,
 983705,
 75826310,
 75635739,
 983709,
 -1,
 75766811,
 983710,
 75957384,
 75764406,
 983702,
 -1,
 75895478,
 983703,
 76152831,
 75893879,
 983706,
 -1,
 76024951,
 983707,
 76219543,
 74460500,
 -1,
 76285071,
 76153555,
 -1,
 -64371,
 76228655,
 983689,
 -64370,
 76288694,
 983686,
 -1,
 76350163,
 983679,
 76547217,
 76228655,
 983682,
 -1,
 76490799,
 983683,
 76678291,
 76487707,
 983687,
 -1,
 76618779,
 983688,
 76809365,
 76616374,
 983680,
 -1,
 76747446,
 983681,
 77004799,
 76745847,
 983684,
 -1,
 76876919,
 983685,
 77071524,
 76156979,
 -1,
 77137052,
 77005523,
 -1,
 -64358,
 77080623,
 983667,
 -64357,
 77140662,
 983664,
 -1,
 77202131,
 983657,
 77399198,
 77080623,
 983660,
 -1,
 77342767,
 983661,
 77530272,
 77339675,
 983665,
 -1,
 77470747,
 983666,
 77661346,
 77468342,
 983658,
 -1,
 77599414,
 983659,
 77856767,
 77597815,
 983662,
 -1,
 77728887,
 983663,
 77923496,
 77005523,
 -1,
 -64346,
 77867055,
 983733,
 -64345,
 77927094,
 983730,
 -1,
 77988563,
 983723,
 78185642,
 77867055,
 983726,
 -1,
 78129199,
 983727,
 78316716,
 78126107,
 983731,
 -1,
 78257179,
 983732,
 78447790,
 78254774,
 983724,
 -1,
 78385846,
 983725,
 78643199,
 78384247,
 983728,
 -1,
 78515319,
 983729,
 78709976,
 74392423,
 -1,
 78775487,
 78647696,
 -1,
 78841014,
 78709459,
 -1,
 -64332,
 78784559,
 983865,
 -64331,
 78844598,
 983862,
 -1,
 78906067,
 983855,
 79103160,
 78784559,
 983858,
 -1,
 79046703,
 983859,
 79234234,
 79043611,
 983863,
 -1,
 79174683,
 983864,
 79365308,
 79172278,
 983856,
 -1,
 79303350,
 983857,
 79496382,
 79301751,
 983860,
 -1,
 79432823,
 983861,
 -1,
 79438503,
 983911,
 79693004,
 78717799,
 -1,
 79758532,
 79626963,
 -1,
 -64318,
 79702063,
 983876,
 -64317,
 79762102,
 983873,
 -1,
 79823571,
 983866,
 80020678,
 79702063,
 983869,
 -1,
 79964207,
 983870,
 80151752,
 79961115,
 983874,
 -1,
 80092187,
 983875,
 80282826,
 80089782,
 983867,
 -1,
 80220854,
 983868,
 80478207,
 80219255,
 983871,
 -1,
 80350327,
 983872,
 80544976,
 79626963,
 -1,
 -64306,
 80488495,
 983887,
 -64305,
 80548534,
 983884,
 -1,
 80610003,
 983877,
 80807122,
 80488495,
 983880,
 -1,
 80750639,
 983881,
 80938196,
 80747547,
 983885,
 -1,
 80878619,
 983886,
 81069270,
 80876214,
 983878,
 -1,
 81007286,
 983879,
 81264639,
 81005687,
 983882,
 -1,
 81136759,
 983883,
 81331455,
 78648919,
 -1,
 81396979,
 81270359,
 -1,
 81462503,
 81335895,
 -1,
 81528031,
 81396435,
 -1,
 -64291,
 81471535,
 983810,
 -64290,
 81531574,
 983807,
 -1,
 81593043,
 983800,
 81790177,
 81471535,
 983803,
 -1,
 81733679,
 983804,
 81921251,
 81730587,
 983808,
 -1,
 81861659,
 983809,
 82052325,
 81859254,
 983801,
 -1,
 81990326,
 983802,
 82247679,
 81988727,
 983805,
 -1,
 82119799,
 983806,
 82314475,
 81396435,
 -1,
 -64279,
 82257967,
 983821,
 -64278,
 82318006,
 983818,
 -1,
 82379475,
 983811,
 82576621,
 82257967,
 983814,
 -1,
 82520111,
 983815,
 82707695,
 82517019,
 983819,
 -1,
 82648091,
 983820,
 82838769,
 82645686,
 983812,
 -1,
 82776758,
 983813,
 83034111,
 82775159,
 983816,
 -1,
 82906231,
 983817,
 83100919,
 81330899,
 -1,
 -64267,
 83044399,
 983788,
 -64266,
 83104438,
 983785,
 -1,
 83165907,
 983778,
 83363065,
 83044399,
 983781,
 -1,
 83306543,
 983782,
 83494139,
 83303451,
 983786,
 -1,
 83434523,
 983787,
 83625213,
 83432118,
 983779,
 -1,
 83563190,
 983780,
 83820543,
 83561591,
 983783,
 -1,
 83692663,
 983784,
 83887385,
 81270132,
 -1,
 83952909,
 83830103,
 -1,
 84018437,
 83886803,
 983899,
 -64253,
 83961903,
 983910,
 -64252,
 84021942,
 983907,
 -1,
 84083411,
 983900,
 84280583,
 83961903,
 983903,
 -1,
 84224047,
 983904,
 84411657,
 84220955,
 983908,
 -1,
 84352027,
 983909,
 84542731,
 84349622,
 983901,
 -1,
 84480694,
 983902,
 84738047,
 84479095,
 983905,
 -1,
 84610167,
 983906,
 84804881,
 83886803,
 -1,
 -64241,
 84748335,
 983656,
 -64240,
 84808374,
 983653,
 -1,
 84869843,
 983646,
 85067027,
 84748335,
 983649,
 -1,
 85010479,
 983650,
 85198101,
 85007387,
 983654,
 -1,
 85138459,
 983655,
 85329175,
 85136054,
 983647,
 -1,
 85267126,
 983648,
 85524479,
 85265527,
 983651,
 -1,
 85396599,
 983652,
 85591347,
 83830290,
 -1,
 85656871,
 85534226,
 -1,
 85722399,
 85590739,
 -1,
 -64227,
 85665839,
 983700,
 -64226,
 85725878,
 983697,
 -1,
 85787347,
 983690,
 85984545,
 85665839,
 983693,
 -1,
 85927983,
 983694,
 86115619,
 85924891,
 983698,
 -1,
 86055963,
 983699,
 86246693,
 86053558,
 983691,
 -1,
 86184630,
 983692,
 86441983,
 86183031,
 983695,
 -1,
 86314103,
 983696,
 86508843,
 85590739,
 -1,
 -64215,
 86452271,
 983722,
 -64214,
 86512310,
 983719,
 -1,
 86573779,
 983712,
 86770989,
 86452271,
 983715,
 -1,
 86714415,
 983716,
 86902063,
 86711323,
 983720,
 -1,
 86842395,
 983721,
 87033137,
 86839990,
 983713,
 -1,
 86971062,
 983714,
 87228415,
 86969463,
 983717,
 -1,
 87100535,
 983718,
 87295309,
 85532941,
 -1,
 87360833,
 87236877,
 -1,
 87426361,
 87294675,
 -1,
 -64201,
 87369775,
 983832,
 -64200,
 87429814,
 983829,
 -1,
 87491283,
 983822,
 87688507,
 87369775,
 983825,
 -1,
 87631919,
 983826,
 87819581,
 87628827,
 983830,
 -1,
 87759899,
 983831,
 87950655,
 87757494,
 983823,
 -1,
 87888566,
 983824,
 88145919,
 87886967,
 983827,
 -1,
 88018039,
 983828,
 88212805,
 87294675,
 -1,
 -64189,
 88156207,
 983777,
 -64188,
 88216246,
 983774,
 -1,
 88277715,
 983767,
 88474951,
 88156207,
 983770,
 -1,
 88418351,
 983771,
 88606025,
 88415259,
 983775,
 -1,
 88546331,
 983776,
 88737099,
 88543926,
 983768,
 -1,
 88674998,
 983769,
 88932351,
 88673399,
 983772,
 -1,
 88804471,
 983773,
 88999258,
 87240020,
 -1,
 89064786,
 88933075,
 -1,
 -64176,
 89008175,
 983766,
 -64175,
 89068214,
 983763,
 -1,
 89129683,
 983756,
 89326932,
 89008175,
 983759,
 -1,
 89270319,
 983760,
 89458006,
 89267227,
 983764,
 -1,
 89398299,
 983765,
 89589080,
 89395894,
 983757,
 -1,
 89526966,
 983758,
 89784319,
 89525367,
 983761,
 -1,
 89656439,
 983762,
 89851239,
 88943213,
 -1,
 89916767,
 89785043,
 -1,
 -64163,
 89860143,
 983799,
 -64162,
 89920182,
 983796,
 -1,
 89981651,
 983789,
 90178913,
 89860143,
 983792,
 -1,
 90122287,
 983793,
 90309987,
 90119195,
 983797,
 -1,
 90250267,
 983798,
 90441061,
 90247862,
 983790,
 -1,
 90378934,
 983791,
 90636287,
 90377335,
 983794,
 -1,
 90508407,
 983795,
 90703220,
 89792237,
 -1,
 90768748,
 90637011,
 -1,
 -64150,
 90712111,
 983744,
 -64149,
 90772150,
 983741,
 -1,
 90833619,
 983734,
 91030894,
 90712111,
 983737,
 -1,
 90974255,
 983738,
 91161968,
 90971163,
 983742,
 -1,
 91102235,
 983743,
 91293042,
 91099830,
 983735,
 -1,
 91230902,
 983736,
 91488255,
 91229303,
 983739,
 -1,
 91360375,
 983740,
 91555201,
 90642732,
 -1,
 91620729,
 91488979,
 -1,
 -64137,
 91564079,
 983755,
 -64136,
 91624118,
 983752,
 -1,
 91685587,
 983745,
 91882875,
 91564079,
 983748,
 -1,
 91826223,
 983749,
 92013949,
 91823131,
 983753,
 -1,
 91954203,
 983754,
 92145023,
 91951798,
 983746,
 -1,
 92082870,
 983747,
 92340223,
 92081271,
 983750,
 -1,
 92212343,
 983751,
 92407182,
 91493690,
 -1,
 92472710,
 92340947,
 -1,
 -64124,
 92416047,
 983854,
 -64123,
 92476086,
 983851,
 -1,
 92537555,
 983844,
 92734856,
 92416047,
 983847,
 -1,
 92678191,
 983848,
 92865930,
 92675099,
 983852,
 -1,
 92806171,
 983853,
 92997004,
 92803766,
 983845,
 -1,
 92934838,
 983846,
 93192191,
 92933239,
 983849,
 -1,
 93064311,
 983850,
 93259163,
 92344720,
 -1,
 93324691,
 93192915,
 -1,
 -64111,
 93268015,
 983898,
 -64110,
 93328054,
 983895,
 -1,
 93389523,
 983888,
 93586837,
 93268015,
 983891,
 -1,
 93530159,
 983892,
 93717911,
 93527067,
 983896,
 -1,
 93658139,
 983897,
 93848985,
 93655734,
 983889,
 -1,
 93786806,
 983890,
 94044159,
 93785207,
 983893,
 -1,
 93916279,
 983894,
 94175231,
 93194104,
 -1,
 94176672,
 94044883,
 -1,
 -64098,
 94119983,
 983678,
 -64097,
 94180022,
 983675,
 -1,
 94241491,
 983668,
 94438818,
 94119983,
 983671,
 -1,
 94382127,
 983672,
 94569892,
 94379035,
 983676,
 -1,
 94510107,
 983677,
 94700966,
 94507702,
 983669,
 -1,
 94638774,
 983670,
 94896127,
 94637175,
 983673,
 -1,
 94768247,
 983674,
 95027199,
 74320255,
 -1,
 95028654,
 94902936,
 983629,
 95094188,
 94968472,
 983627,
 -1,
 95034008,
 983639,
 -64083,
 95038804,
 983625,
 -1,
 95162419,
 983623,
 95356337,
 94970727,
 983643,
 -64080,
 95298407,
 983642,
 -1,
 95359376,
 983641,
 95552948,
 95295063,
 983634,
 95682559,
 95491671,
 983637,
 -1,
 95557207,
 983636,
 95749558,
 95495698,
 983628,
 -1,
 95692306,
 983626,
 95880632,
 95691021,
 983633,
 -1,
 95822093,
 983638,
 96011706,
 95819124,
 983622,
 -1,
 95954263,
 983645,
 -64069,
 95956308,
 983632,
 -64068,
 96086637,
 983635,
 -64067,
 96149229,
 983630,
 -64066,
 96213292,
 983631,
 -64065,
 96277818,
 983640,
 -64064,
 96342416,
 983644,
 -1,
 96405368,
 983624,
 96601540,
 74259096,
 -1,
 -64061,
 96538848,
 127818,
 -1,
 96600838,
 127883,
 -1,
 96546093,
 128661,
 96863704,
 74191542,
 -1,
 96929232,
 96798292,
 -1,
 96994765,
 96871271,
 -1,
 97060300,
 96938074,
 -1,
 -64054,
 96999876,
 3982,
 -64053,
 97064677,
 3981,
 -1,
 97129563,
 3983,
 -1,
 96998242,
 3980,
 97452031,
 96934273,
 -1,
 -64049,
 97331092,
 4058,
 -1,
 97392413,
 4057,
 97584594,
 96866524,
 128005,
 -1,
 97517680,
 128047,
 97715669,
 97521559,
 -1,
 -64044,
 97657837,
 11632,
 -1,
 97716618,
 11647,
 -64042,
 97657296,
 128555,
 -64041,
 97851916,
 9202,
 -1,
 97913094,
 127915,
 98108907,
 96805133,
 -1,
 98174432,
 98049051,
 -1,
 98239967,
 98115309,
 -1,
 98305502,
 98177743,
 -1,
 -64035,
 98242473,
 128032,
 -1,
 98307130,
 127865,
 -1,
 98243251,
 127942,
 -1,
 98179161,
 128654,
 98633189,
 98108115,
 -1,
 98698723,
 98572588,
 128650,
 -1,
 98631753,
 128651,
 -64028,
 98636722,
 128646,
 -1,
 98765381,
 128668,
 98960874,
 98570934,
 -1,
 99026409,
 98895026,
 -1,
 -64024,
 98968406,
 128208,
 -1,
 99028915,
 128681,
 -1,
 98962148,
 128305,
 -1,
 98904325,
 127930,
 99354099,
 98049051,
 -1,
 99419631,
 99294959,
 -1,
 -64018,
 99363963,
 128285,
 -1,
 99422672,
 127913,
 -64016,
 99359522,
 128069,
 -64015,
 99555732,
 127813,
 -64014,
 99620429,
 128508,
 -1,
 99685270,
 128701,
 99878396,
 99290231,
 -1,
 99943928,
 99817232,
 -1,
 -64010,
 99887912,
 128250,
 -64009,
 99951573,
 128301,
 -1,
 100016037,
 128222,
 100206075,
 99877587,
 -1,
 -64006,
 100147500,
 128198,
 -1,
 100207210,
 127861,
 -1,
 100146033,
 127934,
 100468226,
 99822480,
 -1,
 100533761,
 100408349,
 -1,
 -64001,
 100478158,
 128109,
 -64000,
 100538870,
 128108,
 -1,
 100602351,
 128149,
 -1,
 100471989,
 128256,
 100861447,
 100405648,
 -1,
 100926982,
 100804863,
 -1,
 -63995,
 100870519,
 128077,
 -1,
 100928461,
 128078,
 -1,
 100867698,
 128173,
 101189130,
 100804655,
 -1,
 -63991,
 101131071,
 128034,
 -1,
 101193766,
 127799,
 -1,
 101122717,
 128085,
 101451495,
 74121939,
 -1,
 101516978,
 101389911,
 -1,
 101582512,
 101451911,
 -1,
 101647911,
 101524327,
 -1,
 101713433,
 101591087,
 -1,
 101778968,
 101648091,
 -1,
 101844503,
 101715076,
 -1,
 101910037,
 101786542,
 -1,
 -63980,
 101845441,
 128807,
 -1,
 101909703,
 128814,
 -63978,
 101845441,
 128802,
 -1,
 102040775,
 128812,
 -1,
 101782637,
 128862,
 -1,
 101717984,
 128781,
 102368799,
 101647349,
 -1,
 102434334,
 102311442,
 128788,
 102563839,
 102367509,
 -1,
 -63971,
 102435272,
 128806,
 -1,
 102499527,
 128813,
 -1,
 102367850,
 128825,
 102762019,
 102311442,
 -1,
 102827554,
 102703502,
 128860,
 -1,
 102761063,
 128861,
 -1,
 102761785,
 128850,
 -63964,
 102703035,
 128839,
 -63963,
 102964261,
 128852,
 -63962,
 103027611,
 128795,
 -1,
 103090278,
 128847,
 103286330,
 101581523,
 -1,
 103351855,
 103227583,
 -1,
 103417390,
 103284736,
 -1,
 103482924,
 103361327,
 128776,
 -1,
 103416423,
 128777,
 103677951,
 103424490,
 128774,
 -1,
 103547495,
 128775,
 -1,
 103354363,
 128773,
 103810612,
 103290455,
 -1,
 103876146,
 103749059,
 128822,
 -1,
 103809639,
 128823,
 -63949,
 103819507,
 128837,
 -1,
 103943480,
 128874,
 -63947,
 103754243,
 128829,
 -63946,
 104080421,
 128855,
 -63945,
 104145713,
 128826,
 -63944,
 104209397,
 128811,
 -63943,
 104274276,
 128859,
 -1,
 104338551,
 128769,
 104531534,
 103221112,
 -1,
 104597062,
 104472845,
 -1,
 104662594,
 104540321,
 128869,
 104792063,
 104596069,
 -1,
 -63937,
 104661690,
 128873,
 -63936,
 104727220,
 128872,
 -63935,
 104792754,
 128871,
 -1,
 104858284,
 128870,
 105119743,
 104602719,
 -1,
 105121349,
 104991169,
 128803,
 -1,
 105054823,
 128804,
 -1,
 105059477,
 128798,
 105317962,
 104530643,
 -1,
 -63928,
 105259169,
 128846,
 -63927,
 105322785,
 128844,
 -1,
 105385044,
 128848,
 105580109,
 105258424,
 -1,
 -63924,
 105520638,
 128800,
 -1,
 105579707,
 128805,
 -1,
 105518150,
 128787,
 105842270,
 104472845,
 -1,
 105907804,
 105778295,
 -1,
 105973337,
 105845130,
 128818,
 106038869,
 105906789,
 -1,
 -63917,
 105972404,
 128821,
 -63916,
 106037938,
 128820,
 -1,
 106103468,
 128819,
 106364927,
 105971989,
 -1,
 106366552,
 106235079,
 128816,
 -1,
 106300007,
 128817,
 -1,
 106304661,
 128799,
 106563163,
 105907221,
 128827,
 -1,
 106496615,
 128828,
 -1,
 106506122,
 128877,
 106823679,
 105847882,
 128792,
 -1,
 106693223,
 128793,
 106890857,
 105776641,
 -1,
 106956387,
 106831353,
 128834,
 107085823,
 106889829,
 -1,
 -63902,
 106955442,
 128836,
 -1,
 107020972,
 128835,
 107218534,
 106890668,
 -1,
 -63899,
 107162233,
 128876,
 -1,
 107223431,
 128875,
 -63897,
 107160118,
 128857,
 -63896,
 107353734,
 128783,
 -1,
 107418790,
 128830,
 107611763,
 106834541,
 -1,
 107677298,
 107549366,
 -1,
 107742832,
 107617040,
 128778,
 107808367,
 107676261,
 -1,
 -63890,
 107741874,
 128780,
 -1,
 107807404,
 128779,
 -1,
 107741466,
 128815,
 108134399,
 107685862,
 128790,
 -1,
 108003943,
 128791,
 -1,
 107613666,
 128808,
 108267133,
 107552493,
 -1,
 108332664,
 108207131,
 -1,
 108398199,
 108276706,
 128843,
 -1,
 108334287,
 128858,
 -1,
 108340759,
 128856,
 108594811,
 108275759,
 -1,
 -63878,
 108537773,
 128868,
 -1,
 108601928,
 128867,
 -63876,
 108536241,
 128863,
 -1,
 108728899,
 128782,
 108922501,
 108209682,
 -1,
 108988033,
 108860338,
 -1,
 -63872,
 108923473,
 128840,
 -1,
 108986672,
 128809,
 109184643,
 108922199,
 128831,
 -1,
 109118055,
 128832,
 -63868,
 109128290,
 128845,
 -1,
 109257275,
 128849,
 109446796,
 108861740,
 -1,
 109512330,
 109383121,
 128784,
 109641727,
 109445733,
 -1,
 -63863,
 109511346,
 128786,
 -1,
 109576876,
 128785,
 -63861,
 109452667,
 128881,
 -1,
 109708548,
 128824,
 109905555,
 109384080,
 -1,
 109971088,
 109845531,
 -1,
 -63857,
 109914603,
 128878,
 -1,
 109978408,
 128854,
 110231551,
 109904912,
 -1,
 -63854,
 110108288,
 128883,
 -1,
 110169141,
 128882,
 110364313,
 109841026,
 -1,
 110429848,
 110302367,
 -1,
 110495383,
 110372117,
 128865,
 -1,
 110428775,
 128866,
 -1,
 110438238,
 128864,
 -1,
 110364152,
 128880,
 110757533,
 110302357,
 -1,
 110823068,
 110690608,
 128796,
 -1,
 110756455,
 128797,
 -1,
 110756468,
 128801,
 111019680,
 110701487,
 -1,
 -63841,
 110963970,
 128842,
 -1,
 111027884,
 128772,
 111216291,
 110960905,
 -1,
 -63838,
 111156203,
 128768,
 -1,
 111216870,
 128833,
 111412902,
 111156007,
 -1,
 -63835,
 111355817,
 128789,
 -1,
 111415574,
 128879,
 111609513,
 111351383,
 -1,
 -63832,
 111549544,
 128851,
 -1,
 111611047,
 128810,
 111806124,
 111546419,
 -1,
 -63829,
 111749363,
 128841,
 -1,
 111811773,
 128794,
 -63827,
 111749629,
 128853,
 -63826,
 111942807,
 128838,
 -63825,
 112005023,
 128770,
 -1,
 112069833,
 128771,
 -63823,
 101520172,
 128126,
 -1,
 112198959,
 9200,
 112395987,
 101458189,
 -1,
 112461520,
 112329489,
 -1,
 112527054,
 112403950,
 -1,
 112592578,
 112469522,
 -1,
 112658108,
 112536760,
 -1,
 112723642,
 112601823,
 -1,
 -63815,
 112657981,
 64446,
 -1,
 112722729,
 64445,
 -63813,
 112657981,
 64437,
 -1,
 112853801,
 64436,
 113115135,
 112595596,
 -1,
 113116864,
 112992232,
 -1,
 -63809,
 113051197,
 64441,
 -1,
 113115945,
 64440,
 -63807,
 113051197,
 64439,
 -1,
 113247017,
 64438,
 113444551,
 112528221,
 -1,
 113510086,
 113387028,
 -1,
 -63803,
 113444413,
 64435,
 -1,
 113509161,
 64434,
 -1,
 113453170,
 64444,
 113772234,
 113386725,
 -1,
 -63799,
 113706557,
 64449,
 -1,
 113771305,
 64448,
 113968845,
 113709058,
 -1,
 -63796,
 113903165,
 64443,
 -1,
 113967913,
 64442,
 -1,
 113910459,
 64447,
 -63793,
 112470977,
 1631,
 -1,
 114169752,
 1568,
 114425855,
 112404272,
 -1,
 -63790,
 114304369,
 127912,
 -1,
 114362972,
 128667,
 114558682,
 112335512,
 -1,
 114624215,
 114501138,
 128028,
 -63786,
 114561762,
 128260,
 -1,
 114625913,
 128246,
 114884607,
 114561075,
 -1,
 -63783,
 114762591,
 128544,
 -1,
 114822599,
 128162,
 115017439,
 114501679,
 -1,
 115082974,
 114960256,
 -1,
 -63779,
 115022893,
 128663,
 -1,
 115082648,
 127975,
 -1,
 115017292,
 127814,
 115345122,
 114959726,
 -1,
 -63775,
 115286778,
 9954,
 -1,
 115350894,
 128562,
 115541733,
 115284268,
 -1,
 -63772,
 115478009,
 127944,
 -1,
 115541835,
 128657,
 -63770,
 115484401,
 128095,
 -1,
 115674603,
 128673,
 115869582,
 101393255,
 -1,
 115935009,
 115810499,
 -1,
 116000515,
 115873367,
 -1,
 116066048,
 115934644,
 -1,
 -63764,
 116010442,
 127305,
 -63763,
 116075860,
 127304,
 -63762,
 116141314,
 127303,
 -63761,
 116206189,
 127301,
 -63760,
 116271151,
 127300,
 -63759,
 116336146,
 127299,
 -63758,
 116400397,
 127297,
 -63757,
 116465853,
 127296,
 -63756,
 116530203,
 127294,
 -63755,
 116594988,
 127292,
 -63754,
 116659799,
 127291,
 -63753,
 116725108,
 127290,
 -63752,
 116790586,
 127289,
 -63751,
 116855478,
 127288,
 -63750,
 116920720,
 127287,
 -63749,
 116985907,
 127286,
 -63748,
 117051165,
 127285,
 -63747,
 117116023,
 127284,
 -63746,
 117181058,
 127283,
 -63745,
 117245816,
 127282,
 -1,
 117310163,
 127280,
 117571583,
 116006026,
 -1,
 -63742,
 117448161,
 10191,
 -1,
 117507170,
 10190,
 117704468,
 115935096,
 -1,
 117770002,
 117642584,
 -1,
 117835529,
 117703366,
 -1,
 -63737,
 117768933,
 127539,
 -63736,
 117834447,
 127538,
 -1,
 117899964,
 127544,
 118097678,
 117768900,
 -1,
 118163213,
 118031048,
 -1,
 -63732,
 118096589,
 127542,
 -1,
 118162123,
 127543,
 -1,
 118099103,
 127541,
 118489087,
 118031034,
 -1,
 -63728,
 118358720,
 127546,
 -63727,
 118424246,
 127540,
 -1,
 118489774,
 127545,
 -63725,
 117710216,
 127378,
 -1,
 118625879,
 127377,
 118818583,
 117643928,
 -1,
 -63722,
 118755379,
 127382,
 -1,
 118820589,
 127381,
 119015194,
 118756826,
 -1,
 -63719,
 118956971,
 127490,
 -1,
 119019053,
 127489,
 -63717,
 118959071,
 127311,
 -63716,
 119155588,
 127386,
 -63715,
 119220607,
 127385,
 -63714,
 119285019,
 127384,
 -63713,
 119348379,
 127383,
 -63712,
 119411478,
 127380,
 -1,
 119476237,
 127379,
 119670585,
 115874092,
 -1,
 119736117,
 119607990,
 -1,
 119801652,
 119674912,
 -1,
 119867185,
 119738154,
 -1,
 119932714,
 119807392,
 128515,
 120061951,
 119865346,
 -1,
 -63704,
 119940938,
 128518,
 -63703,
 120005872,
 128516,
 -1,
 120064337,
 128517,
 120260398,
 119869840,
 -1,
 -63700,
 120200728,
 128520,
 -63699,
 120261816,
 128525,
 -1,
 120325152,
 128519,
 120586239,
 120202087,
 -1,
 -63696,
 120465732,
 128526,
 -1,
 120527417,
 128522,
 120782847,
 119801863,
 -1,
 -63693,
 120659360,
 128570,
 -1,
 120721885,
 128571,
 -1,
 119743199,
 128527,
 120981304,
 119669787,
 -1,
 -63689,
 120921578,
 128312,
 -1,
 120981235,
 128313,
 -1,
 120921257,
 128684,
 121243469,
 119611117,
 -1,
 121308997,
 121179255,
 -1,
 121374530,
 121242599,
 -1,
 121440065,
 121310644,
 128264,
 121569279,
 121373043,
 -1,
 -63681,
 121448206,
 128266,
 -63680,
 121511225,
 128265,
 -1,
 121571234,
 128263,
 -1,
 121373325,
 128586,
 121896959,
 121310327,
 -1,
 -63676,
 121768649,
 128676,
 -1,
 121833596,
 128172,
 122029898,
 121242323,
 -1,
 122095433,
 121971434,
 -1,
 -63672,
 122033155,
 128150,
 -1,
 122097199,
 10024,
 -1,
 122032378,
 127837,
 -63669,
 121970367,
 128051,
 -63668,
 122295954,
 128166,
 -1,
 122360954,
 128026,
 122554200,
 121186351,
 -1,
 122619732,
 122493592,
 -1,
 122685265,
 122561216,
 127749,
 -1,
 122618165,
 127748,
 -63662,
 122627068,
 127751,
 -63661,
 122752960,
 127803,
 -1,
 122815003,
 127774,
 123012951,
 122561383,
 -1,
 -63658,
 122953592,
 128671,
 -1,
 123015712,
 127843,
 -1,
 122954244,
 127940,
 123275107,
 122496530,
 -1,
 123340636,
 123216187,
 -1,
 -63653,
 123284434,
 127827,
 -1,
 123343681,
 128207,
 123537247,
 123276463,
 -1,
 -63650,
 123474923,
 127836,
 -1,
 123535542,
 128642,
 123733858,
 123471226,
 -1,
 -63647,
 123676874,
 128509,
 -1,
 123737197,
 128649,
 -1,
 123674047,
 9201,
 123996011,
 123212176,
 -1,
 124061544,
 123935771,
 -1,
 -63642,
 124005351,
 128703,
 -63641,
 124068664,
 127856,
 -1,
 124132941,
 127776,
 -63639,
 123999345,
 128674,
 -63638,
 124259582,
 128017,
 -1,
 124323284,
 127847,
 124520305,
 123934295,
 -1,
 124585839,
 124456190,
 -1,
 -63634,
 124530027,
 128554,
 -1,
 124589115,
 128164,
 -63632,
 124526129,
 127920,
 -1,
 124719829,
 127829,
 124913526,
 124459672,
 -1,
 124979061,
 124846803,
 -1,
 -63628,
 124917220,
 128013,
 -1,
 124982153,
 128012,
 -1,
 124919500,
 127938,
 125241211,
 124849271,
 -1,
 125306746,
 125176951,
 -1,
 -63623,
 125242199,
 127793,
 -1,
 125305485,
 128584,
 -1,
 125240698,
 128186,
 125568895,
 125175672,
 -1,
 125634430,
 125506167,
 127979,
 -1,
 125567309,
 127890,
 -1,
 125575921,
 128220,
 125831043,
 125502163,
 -1,
 -63615,
 125775158,
 127927,
 -63614,
 125839004,
 128225,
 -1,
 125900263,
 127862,
 126093190,
 125770779,
 -1,
 -63611,
 126033169,
 128284,
 -1,
 126095390,
 127846,
 126289801,
 126031220,
 -1,
 -63608,
 126232805,
 128128,
 -1,
 126292664,
 127935,
 126486412,
 126227126,
 -1,
 -63605,
 126430478,
 128303,
 -1,
 126490600,
 128510,
 -63603,
 126430659,
 128137,
 -1,
 126626831,
 127946,
 126814248,
 115810029,
 -1,
 126879710,
 126752472,
 -1,
 126945184,
 126821906,
 -1,
 127010710,
 126889153,
 -1,
 -63597,
 126952735,
 127138,
 -63596,
 127013359,
 127154,
 -63595,
 127077143,
 127170,
 -1,
 127142203,
 127186,
 127338395,
 126947991,
 -1,
 -63592,
 127280415,
 127139,
 -63591,
 127341039,
 127155,
 -63590,
 127404823,
 127171,
 -1,
 127469883,
 127187,
 127729663,
 127274318,
 -1,
 -63587,
 127608095,
 127146,
 -63586,
 127668719,
 127162,
 -63585,
 127732503,
 127178,
 -1,
 127797563,
 127194,
 127993771,
 126886759,
 -1,
 128059302,
 127931658,
 -1,
 -63581,
 128001311,
 127142,
 -63580,
 128061935,
 127158,
 -63579,
 128125719,
 127174,
 -1,
 128190779,
 127190,
 128450559,
 127995607,
 -1,
 -63576,
 128328991,
 127143,
 -63575,
 128389615,
 127159,
 -63574,
 128453399,
 127175,
 -1,
 128518459,
 127191,
 128714678,
 127931764,
 -1,
 128780209,
 128654122,
 -1,
 -63570,
 128722207,
 127148,
 -63569,
 128782831,
 127164,
 -63568,
 128846615,
 127180,
 -1,
 128911675,
 127196,
 129171455,
 128717837,
 -1,
 -63565,
 129049887,
 127150,
 -63564,
 129110511,
 127166,
 -63563,
 129174295,
 127182,
 -1,
 129239355,
 127198,
 129435585,
 128651037,
 -1,
 129501116,
 129375894,
 -1,
 -63559,
 129443103,
 127140,
 -63558,
 129503727,
 127156,
 -63557,
 129567511,
 127172,
 -1,
 129632571,
 127188,
 129892351,
 129438962,
 -1,
 -63554,
 129770783,
 127141,
 -63553,
 129831407,
 127157,
 -63552,
 129895191,
 127173,
 -1,
 129960251,
 127189,
 130156486,
 129376476,
 -1,
 -63549,
 130098463,
 127149,
 -63548,
 130159087,
 127165,
 -63547,
 130222871,
 127181,
 -1,
 130287931,
 127197,
 130484171,
 130095929,
 -1,
 -63544,
 130426143,
 127145,
 -63543,
 130486767,
 127161,
 -63542,
 130550551,
 127177,
 -1,
 130615611,
 127193,
 130811856,
 130422079,
 -1,
 -63539,
 130753823,
 127147,
 -63538,
 130814447,
 127163,
 -63537,
 130878231,
 127179,
 -1,
 130943291,
 127195,
 131139541,
 130747673,
 -1,
 -63534,
 131081503,
 127144,
 -63533,
 131142127,
 127160,
 -63532,
 131205911,
 127176,
 -1,
 131270971,
 127192,
 131467226,
 131072815,
 -1,
 -63529,
 131409183,
 127137,
 -63528,
 131469807,
 127153,
 -63527,
 131533591,
 127169,
 -1,
 131598651,
 127185,
 131794909,
 131401217,
 -1,
 -63524,
 131733115,
 127183,
 -1,
 131793719,
 127136,
 -1,
 131738627,
 127199,
 132057077,
 126815351,
 -1,
 132122605,
 131997965,
 -1,
 132188140,
 132064103,
 -1,
 132253675,
 132127980,
 -1,
 132319210,
 132186112,
 -1,
 132384743,
 132262967,
 -1,
 -63515,
 132325451,
 128590,
 -63514,
 132386759,
 128591,
 -1,
 132450018,
 128113,
 -63512,
 132325740,
 128588,
 -63511,
 132583442,
 128589,
 -1,
 132646674,
 128583,
 -1,
 132252664,
 128187,
 -1,
 132189920,
 128547,
 -1,
 132124654,
 127917,
 133040113,
 132061848,
 -1,
 -63505,
 132982361,
 9956,
 -63504,
 133047429,
 128532,
 -1,
 133108101,
 128039,
 133302260,
 132973267,
 -1,
 -63501,
 133243149,
 127824,
 -1,
 133302393,
 127825,
 -1,
 133237502,
 128694,
 133564423,
 131996699,
 -1,
 133629948,
 133507119,
 -1,
 133695482,
 133572456,
 -1,
 -63495,
 133631781,
 128545,
 -1,
 133695486,
 128574,
 -63493,
 133634313,
 127831,
 -1,
 133826681,
 128093,
 134023168,
 133568506,
 -1,
 134088703,
 133957610,
 128659,
 -1,
 134030204,
 128680,
 -1,
 134028413,
 128110,
 134285315,
 133965330,
 -1,
 -63486,
 134218519,
 128688,
 -1,
 134283559,
 127858,
 134481926,
 134227310,
 -1,
 -63483,
 134416160,
 128238,
 -1,
 134480900,
 128239,
 -1,
 134421617,
 128041,
 134744084,
 133497555,
 -1,
 134809613,
 134680728,
 -1,
 134875148,
 134742016,
 -1,
 -63477,
 134818877,
 128195,
 -1,
 134877026,
 128196,
 -1,
 134816013,
 128223,
 -63474,
 134753190,
 128062,
 -63473,
 135079263,
 128706,
 -63472,
 135144264,
 127881,
 -63471,
 135208840,
 128206,
 -63470,
 135273189,
 128060,
 -63469,
 135338122,
 127796,
 -1,
 135399675,
 128230,
 135596064,
 134681270,
 -1,
 135661593,
 135532595,
 128022,
 135790591,
 135593984,
 -1,
 -63464,
 135666588,
 128061,
 -1,
 135728933,
 128055,
 135923740,
 135600909,
 -1,
 -63461,
 135857395,
 127821,
 -1,
 135921749,
 127885,
 136120351,
 135861847,
 -1,
 -63458,
 136058455,
 128138,
 -1,
 136121482,
 128169,
 -1,
 136062375,
 128299,
 136382503,
 135538735,
 -1,
 136448036,
 136323341,
 -1,
 -63453,
 136389601,
 128091,
 -1,
 136454081,
 128156,
 -63451,
 136390175,
 128686,
 -63450,
 136586302,
 128204,
 -1,
 136644290,
 128226,
 -1,
 136323763,
 128120,
 136906947,
 126748536,
 -1,
 136972391,
 136844887,
 -1,
 137037921,
 136911899,
 -1,
 137103450,
 136972515,
 -1,
 137168982,
 137035894,
 -1,
 137234491,
 137111058,
 -1,
 137300021,
 137178000,
 -1,
 137365554,
 137239579,
 -1,
 -63439,
 137298596,
 128349,
 -1,
 137363725,
 128337,
 137625599,
 137301296,
 -1,
 -63436,
 137495204,
 128359,
 -1,
 137560333,
 128347,
 137758776,
 137237127,
 -1,
 -63433,
 137691812,
 128350,
 -1,
 137756941,
 128338,
 138018815,
 137694526,
 -1,
 -63430,
 137888420,
 128357,
 -1,
 137953549,
 128345,
 138152002,
 137175911,
 -1,
 138217535,
 138089735,
 -1,
 -63426,
 138150564,
 128353,
 -1,
 138215693,
 128341,
 138477567,
 138153682,
 -1,
 -63423,
 138347172,
 128354,
 -1,
 138412301,
 128342,
 138610761,
 138088221,
 -1,
 138676294,
 138550930,
 -1,
 -63419,
 138609316,
 128351,
 -1,
 138674445,
 128339,
 138936319,
 138613998,
 -1,
 -63416,
 138805924,
 128352,
 -1,
 138871053,
 128340,
 139069520,
 138546295,
 -1,
 139135053,
 139007954,
 -1,
 -63412,
 139068068,
 128358,
 -1,
 139133197,
 128346,
 139395071,
 139072316,
 -1,
 -63409,
 139264676,
 128355,
 -1,
 139329805,
 128343,
 139528275,
 139009328,
 -1,
 -63406,
 139461284,
 128348,
 -1,
 139526413,
 128336,
 139788287,
 139467572,
 -1,
 -63403,
 139657892,
 128356,
 -1,
 139723021,
 128344,
 139984895,
 137112620,
 -1,
 139987033,
 139862651,
 128257,
 -1,
 139919799,
 128258,
 -1,
 139922421,
 128259,
 140247039,
 137044968,
 -1,
 140249182,
 140122448,
 -1,
 -63395,
 140190048,
 128235,
 -1,
 140253409,
 128234,
 -63393,
 140191990,
 127746,
 -63392,
 140384410,
 128272,
 -1,
 140445440,
 128213,
 140642404,
 136975030,
 -1,
 -63389,
 140582732,
 128203,
 -1,
 140647255,
 127867,
 140902399,
 140575969,
 -1,
 -63386,
 140776436,
 128079,
 -1,
 140840375,
 127916,
 141035643,
 136911899,
 -1,
 141101168,
 140974744,
 -1,
 141166700,
 141043123,
 -1,
 -63381,
 141110507,
 128119,
 -1,
 141173845,
 128679,
 141363311,
 141102877,
 -1,
 -63378,
 141303430,
 128534,
 -1,
 141364806,
 127882,
 -1,
 141306545,
 127978,
 141625461,
 141040795,
 -1,
 141690996,
 141562550,
 -1,
 -63373,
 141630239,
 127859,
 -1,
 141692023,
 127850,
 -1,
 141626593,
 127834,
 141953143,
 141568912,
 128004,
 -1,
 141885552,
 128046,
 -63368,
 141896128,
 128145,
 -63367,
 142023072,
 7676,
 -63366,
 142088304,
 128165,
 -1,
 142149899,
 127864,
 142346380,
 140972432,
 -1,
 142411907,
 142281847,
 -1,
 142477440,
 142353174,
 -1,
 -63361,
 142421345,
 127800,
 -1,
 142480184,
 127826,
 -63359,
 142419361,
 127792,
 -63358,
 142614758,
 127937,
 -1,
 142675465,
 128227,
 142870663,
 142345549,
 -1,
 142936198,
 142813648,
 128200,
 -1,
 142868488,
 128185,
 -1,
 142871582,
 128201,
 143132810,
 142807734,
 -1,
 -63351,
 143070977,
 128696,
 -1,
 143132929,
 128020,
 -63349,
 143073989,
 127876,
 -1,
 143268947,
 127851,
 143460506,
 142279379,
 -1,
 143526034,
 143402514,
 128008,
 143654911,
 143458416,
 128049,
 143720447,
 143524211,
 -1,
 -63343,
 143600882,
 128572,
 -1,
 143664754,
 128569,
 143853718,
 143466765,
 -1,
 -63340,
 143793914,
 127887,
 -63339,
 143859358,
 127904,
 -1,
 143919767,
 128199,
 -63337,
 143792905,
 127852,
 -63336,
 144054806,
 128247,
 -63335,
 144119682,
 128197,
 -1,
 144181847,
 127797,
 144378025,
 143401229,
 -1,
 144443553,
 144317467,
 -1,
 144509087,
 144385367,
 -1,
 -63330,
 144444632,
 127884,
 -1,
 144507099,
 10060,
 -63328,
 144452773,
 128081,
 -1,
 144640321,
 128010,
 144836774,
 144387412,
 -1,
 144902309,
 144774118,
 -1,
 -63324,
 144838437,
 128546,
 -1,
 144902142,
 128575,
 -1,
 144844173,
 128302,
 145227775,
 144772215,
 -1,
 -63320,
 145105866,
 127769,
 -1,
 145165134,
 128179,
 145361074,
 144321876,
 -1,
 145426609,
 145302187,
 -1,
 145492142,
 145368246,
 -1,
 -63315,
 145433642,
 1319,
 -1,
 145498615,
 42593,
 145752063,
 145426378,
 -1,
 -63312,
 145630250,
 1318,
 -1,
 145695223,
 42592,
 -1,
 145361190,
 127744,
 145950907,
 145303599,
 -1,
 146016440,
 145891597,
 -1,
 146081975,
 145957133,
 -1,
 -63306,
 146025814,
 127835,
 -1,
 146083173,
 128177,
 -1,
 146020644,
 10160,
 146407423,
 145958254,
 -1,
 -63302,
 146283752,
 128707,
 -1,
 146343192,
 127854,
 146604031,
 145887926,
 -1,
 146606273,
 146481573,
 -1,
 146671808,
 146544433,
 -1,
 -63297,
 146607204,
 127568,
 -1,
 146671691,
 127569,
 -1,
 146614807,
 127914,
 -63294,
 146548767,
 127750,
 -1,
 146873110,
 127910,
 147065124,
 136845612,
 -1,
 147130610,
 146997971,
 -1,
 147196141,
 147069592,
 128104,
 147261671,
 147131075,
 -1,
 147327203,
 147199888,
 -1,
 147392732,
 147260115,
 -1,
 147458252,
 147333991,
 2126,
 -63285,
 147402186,
 2129,
 -1,
 147460496,
 2132,
 147654862,
 147400210,
 2133,
 -1,
 147596818,
 2120,
 147785936,
 147592564,
 2122,
 -1,
 147727275,
 2121,
 -63279,
 147729866,
 2118,
 -63278,
 147857677,
 2131,
 -63277,
 147923133,
 2130,
 -63276,
 147988205,
 2128,
 -63275,
 148052632,
 2125,
 -63274,
 148117804,
 2124,
 -63273,
 148182615,
 2123,
 -63272,
 148247474,
 2136,
 -63271,
 148312464,
 2116,
 -63270,
 148377651,
 2114,
 -63269,
 148441730,
 2115,
 -1,
 148506113,
 2113,
 148703455,
 147329718,
 -1,
 -63266,
 148645394,
 2119,
 -1,
 148707992,
 2127,
 -63264,
 148646442,
 2117,
 -63263,
 148837823,
 2135,
 -63262,
 148902298,
 2112,
 -1,
 148966491,
 2134,
 -63260,
 147270465,
 2138,
 -63259,
 149102724,
 2142,
 -63258,
 149164232,
 2139,
 -1,
 149226425,
 2137,
 149424364,
 147193856,
 -1,
 149489899,
 149367863,
 -1,
 -63254,
 149432317,
 128115,
 -1,
 149492090,
 128114,
 -1,
 149423206,
 128107,
 -1,
 149365646,
 128094,
 149817585,
 147134152,
 -1,
 -63249,
 149759988,
 3386,
 -63248,
 149822343,
 3369,
 -1,
 149883762,
 3406,
 -1,
 149757899,
 127809,
 150145294,
 147069979,
 -1,
 150210813,
 150087727,
 -1,
 150276346,
 150150094,
 -1,
 150341881,
 150209506,
 -1,
 -63241,
 150282584,
 128670,
 -63240,
 150341517,
 128672,
 -1,
 150406786,
 128693,
 -1,
 150274192,
 128507,
 150669564,
 150217697,
 128001,
 -1,
 150601840,
 128045,
 -1,
 150611649,
 128068,
 150866180,
 150149784,
 -1,
 150931712,
 150803974,
 128018,
 -1,
 150863984,
 128053,
 151062787,
 150867737,
 -1,
 -63230,
 151006356,
 128184,
 -1,
 151062025,
 128176,
 -1,
 151002596,
 128669,
 151324936,
 150800033,
 128241,
 151453695,
 151257088,
 -1,
 -63225,
 151333981,
 128242,
 -1,
 151395449,
 128244,
 151587083,
 151259952,
 -1,
 -63222,
 151525569,
 983969,
 -1,
 151589411,
 983968,
 -63220,
 151530869,
 128511,
 -63219,
 151726854,
 127909,
 -1,
 151788797,
 127889,
 151980310,
 150087727,
 -1,
 152045845,
 151921511,
 -1,
 152111380,
 151982799,
 -1,
 -63214,
 152052699,
 127932,
 -63213,
 152116129,
 127925,
 -1,
 152180234,
 127929,
 -1,
 152048288,
 127812,
 -1,
 151984372,
 127926,
 152504606,
 151917238,
 -1,
 152570138,
 152443687,
 -1,
 -63207,
 152505161,
 128189,
 -1,
 152569695,
 128656,
 152766749,
 152504879,
 -1,
 -63204,
 152708053,
 128300,
 -1,
 152772511,
 127908,
 -1,
 152705079,
 127756,
 153092095,
 152439927,
 -1,
 -63200,
 152971244,
 128647,
 -63199,
 153033649,
 128697,
 -63198,
 153098837,
 128221,
 -63197,
 153163944,
 127816,
 -1,
 153224573,
 127830,
 153422195,
 147004056,
 -1,
 153487714,
 153357431,
 -1,
 153553243,
 153423981,
 -1,
 153618754,
 153494862,
 -1,
 153684287,
 153556654,
 -1,
 -63190,
 153628106,
 127369,
 -63189,
 153693524,
 127368,
 -63188,
 153758978,
 127367,
 -63187,
 153824144,
 127366,
 -63186,
 153889389,
 127365,
 -63185,
 153954351,
 127364,
 -63184,
 154019346,
 127363,
 -63183,
 154084199,
 127362,
 -63182,
 154149133,
 127361,
 -63181,
 154214589,
 127360,
 -63180,
 154278939,
 127358,
 -63179,
 154344088,
 127357,
 -63178,
 154408308,
 127354,
 -63177,
 154473142,
 127352,
 -63176,
 154538384,
 127351,
 -63175,
 154603571,
 127350,
 -63174,
 154668829,
 127349,
 -63173,
 154733687,
 127348,
 -63172,
 154798722,
 127347,
 -63171,
 154863480,
 127346,
 -63170,
 154928641,
 127345,
 -1,
 154993363,
 127344,
 -63168,
 153627615,
 127375,
 -63167,
 155126323,
 10062,
 -1,
 155190019,
 127374,
 155451391,
 153553093,
 -1,
 -63164,
 155332042,
 127337,
 -63163,
 155397460,
 127336,
 -63162,
 155462914,
 127335,
 -63161,
 155528080,
 127334,
 -63160,
 155593325,
 127333,
 -63159,
 155658287,
 127332,
 -63158,
 155723282,
 127331,
 -63157,
 155788135,
 127330,
 -63156,
 155853069,
 127329,
 -63155,
 155918525,
 127328,
 -63154,
 155982875,
 127326,
 -63153,
 156048024,
 127325,
 -63152,
 156113196,
 127324,
 -63151,
 156178007,
 127323,
 -63150,
 156243316,
 127322,
 -63149,
 156308794,
 127321,
 -63148,
 156373686,
 127320,
 -63147,
 156438579,
 127318,
 -63146,
 156503837,
 127317,
 -63145,
 156568695,
 127316,
 -63144,
 156633730,
 127315,
 -63143,
 156698488,
 127314,
 -63142,
 156763649,
 127313,
 -1,
 156828371,
 127312,
 157026656,
 153496464,
 -1,
 157092191,
 156958951,
 -1,
 -63138,
 157035591,
 127770,
 -1,
 157099495,
 127761,
 -1,
 157033766,
 128240,
 -63135,
 156969559,
 128528,
 -1,
 157288728,
 128084,
 157485422,
 153426971,
 -1,
 157550954,
 157417472,
 -1,
 -63131,
 157492477,
 128685,
 -63130,
 157556563,
 128695,
 -63129,
 157621576,
 128286,
 -63128,
 157686360,
 128245,
 -63127,
 157748635,
 128683,
 -1,
 157812345,
 128691,
 158009708,
 157492863,
 128211,
 -1,
 157942225,
 128212,
 -63123,
 157950945,
 128067,
 -1,
 158079664,
 128689,
 158271857,
 157418195,
 -1,
 -63120,
 158210509,
 128219,
 -1,
 158274444,
 128133,
 -63118,
 158214709,
 128297,
 -1,
 158405452,
 127747,
 158599624,
 153359732,
 -1,
 158665135,
 158536286,
 -1,
 158730661,
 158599595,
 -1,
 158796159,
 158672402,
 -1,
 158861690,
 158738113,
 -1,
 -63111,
 158800923,
 983926,
 -1,
 158859987,
 983924,
 159058301,
 158798224,
 -1,
 -63108,
 158997531,
 983931,
 -1,
 159056595,
 983929,
 -63106,
 158997531,
 983930,
 -1,
 159187667,
 983928,
 159385988,
 158735000,
 -1,
 -63103,
 159329728,
 983922,
 -63102,
 159390747,
 983932,
 -63101,
 159453540,
 983917,
 -1,
 159515347,
 983927,
 159713674,
 159323508,
 -1,
 159779208,
 159650192,
 -1,
 -63097,
 159718427,
 983916,
 -1,
 159777491,
 983914,
 -63095,
 159718427,
 983915,
 -1,
 159908563,
 983913,
 160106896,
 159647608,
 -1,
 160172430,
 160043408,
 -1,
 -63091,
 160111643,
 983921,
 -1,
 160170707,
 983919,
 -63089,
 160111643,
 983920,
 -1,
 160301779,
 983918,
 160500116,
 160047975,
 -1,
 -63086,
 160441259,
 983943,
 -63085,
 160502162,
 983942,
 -1,
 160563923,
 983944,
 160762265,
 160440045,
 -1,
 160827800,
 160698768,
 -1,
 -63081,
 160767003,
 983936,
 -1,
 160826067,
 983934,
 -1,
 160767003,
 983935,
 161089948,
 160699991,
 -1,
 -63077,
 161029147,
 983940,
 -1,
 161088211,
 983946,
 161286559,
 161024642,
 -1,
 -63074,
 161225755,
 983925,
 -1,
 161284819,
 983923,
 -63072,
 161230272,
 983938,
 -63071,
 161426229,
 983941,
 -63070,
 161489646,
 983939,
 -63069,
 161552981,
 983937,
 -63068,
 161616274,
 983945,
 -1,
 161678854,
 983933,
 161876395,
 158667711,
 -1,
 161941928,
 161817436,
 983949,
 -1,
 161885524,
 983950,
 162136063,
 161882301,
 -1,
 -63062,
 162015279,
 983948,
 -1,
 162073719,
 983951,
 162332671,
 161819512,
 -1,
 -63059,
 162208977,
 983952,
 -63058,
 162269512,
 983947,
 -1,
 162333420,
 983953,
 162531774,
 158598536,
 -1,
 162597302,
 162465420,
 -1,
 -63054,
 162539567,
 983961,
 -63053,
 162602011,
 983963,
 -63052,
 162665142,
 983960,
 -63051,
 162729079,
 983962,
 -1,
 162792147,
 983959,
 163053567,
 162530003,
 -1,
 163056061,
 162927702,
 -1,
 163121595,
 162997778,
 -1,
 -63046,
 163063855,
 983965,
 -1,
 163126299,
 983966,
 -63044,
 163061485,
 983967,
 -1,
 163252310,
 983964,
 -1,
 162996648,
 110592,
 163514821,
 162468534,
 -1,
 163580356,
 163456343,
 128143,
 163645891,
 163517414,
 -1,
 -63038,
 163581749,
 128538,
 -1,
 163645462,
 128573,
 -1,
 163578075,
 128139,
 -1,
 163519082,
 128088,
 163973575,
 163450646,
 128273,
 -1,
 163907522,
 128287,
 -1,
 163912736,
 128040,
 164170253,
 158540045,
 -1,
 164235754,
 164105335,
 -1,
 164301285,
 164172092,
 -1,
 -63028,
 164244938,
 127487,
 -63027,
 164310356,
 127486,
 -63026,
 164375810,
 127485,
 -63025,
 164440976,
 127484,
 -63024,
 164506221,
 127483,
 -63023,
 164571183,
 127482,
 -63022,
 164636178,
 127481,
 -63021,
 164701031,
 127480,
 -63020,
 164765965,
 127479,
 -63019,
 164831421,
 127478,
 -63018,
 164896493,
 127477,
 -63017,
 164961307,
 127476,
 -63016,
 165026456,
 127475,
 -63015,
 165091628,
 127474,
 -63014,
 165156439,
 127473,
 -63013,
 165221748,
 127472,
 -63012,
 165287226,
 127471,
 -63011,
 165352118,
 127470,
 -63010,
 165417360,
 127469,
 -63009,
 165482547,
 127468,
 -63008,
 165547805,
 127467,
 -63007,
 165612663,
 127466,
 -63006,
 165677698,
 127465,
 -63005,
 165742456,
 127464,
 -63004,
 165807617,
 127463,
 -1,
 165872339,
 127462,
 -63002,
 164244307,
 128158,
 -63001,
 166012332,
 128699,
 -63000,
 166074377,
 128524,
 -62999,
 166136455,
 127822,
 -1,
 166201850,
 128665,
 166398455,
 164168403,
 -1,
 166463985,
 166335158,
 -1,
 166529519,
 166405096,
 -1,
 -62994,
 166465952,
 9995,
 -1,
 166530990,
 9994,
 -62992,
 166468320,
 127752,
 -1,
 166664472,
 128643,
 166857203,
 166398789,
 128251,
 -1,
 166789161,
 128280,
 166988277,
 166790682,
 128007,
 -1,
 166920304,
 128048,
 -62986,
 166929938,
 128000,
 -1,
 167057708,
 128015,
 167250431,
 166337563,
 -1,
 -62983,
 167193561,
 128675,
 -62982,
 167258390,
 128205,
 -62981,
 167322593,
 127801,
 -62980,
 167386664,
 128019,
 -62979,
 167450700,
 127906,
 -62978,
 167512326,
 128640,
 -1,
 167576935,
 127840,
 167774728,
 167187126,
 -1,
 167840259,
 167711011,
 -1,
 -62974,
 167780348,
 128270,
 -1,
 167842213,
 9957,
 168036870,
 167774297,
 -1,
 -62971,
 167971297,
 127832,
 -1,
 168035853,
 127833,
 -62969,
 167975711,
 128141,
 -1,
 168166943,
 127872,
 168427519,
 167716911,
 -1,
 168430092,
 168303470,
 -1,
 -62965,
 168367143,
 127933,
 -1,
 168431028,
 127939,
 -1,
 168366219,
 127945,
 168692316,
 164107863,
 -1,
 168757829,
 168624851,
 -1,
 168823355,
 168699747,
 -1,
 168888881,
 168764263,
 -1,
 168954408,
 168827243,
 -1,
 169019927,
 168895335,
 -1,
 169085462,
 168954022,
 -1,
 -62955,
 169021812,
 983617,
 -1,
 169083712,
 983618,
 -1,
 169017908,
 42921,
 169347610,
 168962061,
 -1,
 -62951,
 169283956,
 983615,
 -1,
 169345856,
 983616,
 169544221,
 169287083,
 -1,
 -62948,
 169480564,
 983613,
 -1,
 169542464,
 983614,
 169740832,
 169482920,
 -1,
 -62945,
 169679923,
 42917,
 -1,
 169741044,
 42897,
 169937443,
 169677412,
 -1,
 -62942,
 169873780,
 983619,
 -1,
 169935680,
 983620,
 -62940,
 169877782,
 42919,
 -62939,
 170071641,
 42894,
 -62938,
 170137001,
 42915,
 -62937,
 170201148,
 42913,
 -1,
 170263369,
 983612,
 170524671,
 168896650,
 -1,
 -62934,
 170403346,
 8348,
 -62933,
 170468199,
 8347,
 -62932,
 170532589,
 8346,
 -62931,
 170597016,
 8345,
 -62930,
 170662188,
 8344,
 -62929,
 170726999,
 8343,
 -62928,
 170792308,
 8342,
 -1,
 170856848,
 8341,
 171051578,
 168822730,
 -1,
 171117109,
 170990248,
 -1,
 -62924,
 171056179,
 42916,
 -1,
 171117300,
 42896,
 -62922,
 171059204,
 42893,
 -62921,
 171254677,
 42920,
 -62920,
 171319574,
 42918,
 -62919,
 171382185,
 42914,
 -1,
 171446332,
 42912,
 -1,
 170989484,
 43002,
 171706945,
 168763913,
 -1,
 171772479,
 171640557,
 -1,
 -62914,
 171707151,
 128311,
 -1,
 171772094,
 128309,
 -62912,
 171712965,
 128308,
 -1,
 171908586,
 128310,
 172100164,
 171648380,
 -1,
 -62909,
 172043335,
 127772,
 -1,
 172107239,
 127767,
 -1,
 172035181,
 128030,
 172362318,
 168696859,
 -1,
 172427849,
 172305031,
 -1,
 -62904,
 172365705,
 128140,
 -1,
 172429953,
 127977,
 172624459,
 172361955,
 128274,
 -1,
 172556838,
 128271,
 -62900,
 172567442,
 128261,
 -62899,
 172697768,
 128557,
 -1,
 172759145,
 127853,
 172952152,
 172297335,
 -1,
 173017684,
 172888091,
 -1,
 173083219,
 172950117,
 -1,
 -62894,
 173023228,
 128269,
 -1,
 173085093,
 9958,
 -1,
 173015234,
 128709,
 -62891,
 172957082,
 128006,
 -62890,
 173283942,
 127819,
 -62889,
 173345543,
 128210,
 -1,
 173409187,
 127811,
 173670399,
 172888758,
 -1,
 -62886,
 173547645,
 128132,
 -62885,
 173611853,
 128279,
 -1,
 173674778,
 128648,
 173869731,
 168627319,
 -1,
 173935240,
 173811432,
 -1,
 174000773,
 173876701,
 -1,
 174066286,
 173935234,
 -1,
 174131815,
 174009802,
 -1,
 174197347,
 174066807,
 43797,
 -1,
 174132343,
 43796,
 -62876,
 174139439,
 43793,
 -62875,
 174267419,
 43798,
 -62874,
 174330550,
 43794,
 -1,
 174392041,
 43795,
 174653439,
 174066444,
 -1,
 174656106,
 174525559,
 43789,
 -1,
 174591095,
 43788,
 -62869,
 174598191,
 43785,
 -62868,
 174726171,
 43790,
 -62867,
 174789302,
 43786,
 -1,
 174850793,
 43787,
 175049334,
 174000209,
 -1,
 175114865,
 174984311,
 43813,
 -1,
 175049847,
 43812,
 175245939,
 175047379,
 43808,
 -1,
 175178451,
 43811,
 -62860,
 175188015,
 43809,
 -62859,
 175315995,
 43814,
 -1,
 175379126,
 43810,
 175573630,
 174982679,
 -1,
 175639161,
 175508599,
 43821,
 -1,
 175574135,
 43820,
 175770235,
 175571667,
 43816,
 -1,
 175702739,
 43819,
 -62852,
 175712303,
 43817,
 -62851,
 175840283,
 43822,
 -1,
 175903414,
 43818,
 176160767,
 175515632,
 -1,
 176163457,
 176032887,
 43781,
 -1,
 176098423,
 43780,
 -62846,
 176105519,
 43777,
 -62845,
 176233499,
 43782,
 -62844,
 176296630,
 43778,
 -1,
 176358121,
 43779,
 176619519,
 173934940,
 -1,
 -62841,
 176499558,
 4958,
 -1,
 176558247,
 4957,
 176753297,
 173868284,
 128066,
 176818830,
 176694980,
 -1,
 176884365,
 176751315,
 -1,
 -62836,
 176825415,
 127759,
 -1,
 176888347,
 127758,
 -1,
 176819900,
 127757,
 177209343,
 176750869,
 -1,
 -62832,
 177087025,
 127806,
 -1,
 177150302,
 127805,
 177343127,
 176690960,
 -1,
 177408662,
 177277514,
 -1,
 -62828,
 177350532,
 128294,
 -62827,
 177414105,
 128268,
 -1,
 177477653,
 128161,
 -1,
 177348505,
 128024,
 177736346,
 177286521,
 -1,
 -62823,
 177677159,
 128064,
 -1,
 177738076,
 128083,
 177932957,
 177678862,
 -1,
 -62820,
 177872948,
 127972,
 -1,
 177932279,
 127984,
 178129568,
 177871512,
 -1,
 -62817,
 178072207,
 128233,
 -1,
 178129567,
 128282,
 -62815,
 178072894,
 128125,
 -62814,
 178268864,
 127794,
 -1,
 178324096,
 128231,
 178522854,
 173805341,
 -1,
 178588351,
 178455251,
 -1,
 178653883,
 178521976,
 -1,
 178719418,
 178588793,
 -1,
 178784949,
 178662450,
 -1,
 178850484,
 178716672,
 -1,
 178916012,
 178791870,
 -1,
 -62805,
 178859040,
 128540,
 -1,
 178923338,
 128541,
 179112623,
 178854939,
 -1,
 -62802,
 179052383,
 128560,
 -1,
 179115382,
 128582,
 -62800,
 179054194,
 128514,
 -62799,
 179248012,
 128581,
 -62798,
 179313123,
 128567,
 -62797,
 179378348,
 128548,
 -1,
 179439953,
 128531,
 -1,
 178790058,
 128566,
 179702456,
 178725735,
 -1,
 -62793,
 179636713,
 128561,
 -1,
 179701213,
 128523,
 -62791,
 179644192,
 128536,
 -1,
 179837324,
 128134,
 -1,
 178661263,
 127981,
 -62788,
 178597124,
 128224,
 -62787,
 180037337,
 127877,
 -62786,
 180099653,
 128106,
 -1,
 180164674,
 127810,
 180357839,
 178524854,
 -1,
 180423369,
 180297997,
 -1,
 180488902,
 180358263,
 128293,
 180554437,
 180432102,
 -1,
 -62780,
 180495207,
 127878,
 -1,
 180552029,
 127879,
 -1,
 180486241,
 128658,
 180879359,
 180430204,
 -1,
 -62776,
 180759623,
 127771,
 -1,
 180823527,
 127763,
 181013198,
 180364135,
 -1,
 181078733,
 180949392,
 128031,
 -62772,
 181015573,
 127907,
 -1,
 181076017,
 127845,
 -1,
 181020294,
 128074,
 -1,
 180950803,
 128193,
 181406421,
 180297997,
 -1,
 181471955,
 181345307,
 -1,
 -62766,
 181410769,
 128037,
 -1,
 181473333,
 128056,
 -62764,
 181408541,
 127844,
 -1,
 181603674,
 127839,
 181799642,
 181345307,
 -1,
 -62761,
 181742062,
 127808,
 -62760,
 181805778,
 127860,
 -62759,
 181870168,
 128099,
 -1,
 181932275,
 127745,
 182127328,
 181737047,
 -1,
 182192862,
 182066203,
 -1,
 -62755,
 182135787,
 127924,
 -1,
 182198360,
 128190,
 -62753,
 182135327,
 128563,
 -1,
 182325002,
 128170,
 182520547,
 182069481,
 -1,
 -62750,
 182463559,
 127773,
 -1,
 182527463,
 127765,
 182779903,
 182455415,
 -1,
 -62747,
 182657821,
 127905,
 -1,
 182715684,
 128552,
 182913832,
 178459024,
 -1,
 182979324,
 182848631,
 -1,
 183044858,
 182911699,
 -1,
 183110386,
 182987660,
 -1,
 183175917,
 183048380,
 -1,
 -62740,
 183116896,
 10079,
 -1,
 183176059,
 10080,
 183372528,
 183110274,
 -1,
 -62737,
 183311558,
 128178,
 -1,
 183375098,
 10135,
 -62735,
 183312350,
 10133,
 -1,
 183507530,
 10134,
 183700217,
 183050509,
 -1,
 183765752,
 183641620,
 -1,
 183831287,
 183708727,
 -1,
 -62730,
 183771690,
 128157,
 -1,
 183829831,
 128152,
 -1,
 183765717,
 128159,
 -1,
 183698061,
 128585,
 -1,
 183634990,
 127911,
 -62725,
 182985122,
 127807,
 -1,
 184162304,
 128641,
 184355598,
 182918171,
 -1,
 184421123,
 184295693,
 -1,
 184486658,
 184361953,
 128014,
 184614911,
 184418304,
 -1,
 -62719,
 184492350,
 127943,
 -1,
 184553253,
 128052,
 -1,
 184423716,
 128677,
 184814344,
 184363055,
 -1,
 184879879,
 184755172,
 -1,
 -62714,
 184822865,
 127969,
 -1,
 184878914,
 127968,
 -1,
 184820238,
 9203,
 185142027,
 184752923,
 -1,
 -62710,
 185075257,
 128029,
 -1,
 185139528,
 127855,
 -62708,
 185083544,
 127976,
 -62707,
 185279801,
 127973,
 -1,
 185338018,
 128298,
 185535262,
 184292022,
 -1,
 185600791,
 185475401,
 -1,
 185666326,
 185534092,
 -1,
 -62702,
 185608239,
 983956,
 -62701,
 185670683,
 983958,
 -62700,
 185733814,
 983955,
 -62699,
 185797751,
 983957,
 -1,
 185860819,
 983954,
 -1,
 185599245,
 110593,
 186125085,
 185536759,
 -1,
 186190620,
 186057317,
 -1,
 186256155,
 186131757,
 128644,
 -1,
 186188154,
 128645,
 -1,
 186192391,
 128096,
 -1,
 186122262,
 128262,
 -1,
 186058412,
 127802,
 186583847,
 185467603,
 -1,
 186649379,
 186521900,
 -1,
 -62687,
 186590615,
 128057,
 -62686,
 186653192,
 128296,
 -1,
 186713944,
 127828,
 -62684,
 186590821,
 128035,
 -62683,
 186851425,
 128587,
 -62682,
 186915587,
 128092,
 -1,
 186979467,
 128135,
 -1,
 186525986,
 128175,
 187239264,
 182848130,
 -1,
 187304766,
 187174007,
 -1,
 187370299,
 187247215,
 -1,
 187435827,
 187313016,
 -1,
 187501359,
 187377711,
 -1,
 -62674,
 187443385,
 2391,
 -1,
 187501687,
 2390,
 187697970,
 187440155,
 -1,
 -62671,
 187636854,
 2363,
 -1,
 187698295,
 2362,
 -1,
 187631093,
 2383,
 188022783,
 187373456,
 -1,
 188025655,
 187901999,
 -1,
 -62666,
 187967673,
 2423,
 -1,
 188025975,
 2422,
 188222266,
 187964443,
 -1,
 -62663,
 188161142,
 2420,
 -1,
 188222583,
 2419,
 -1,
 188155381,
 2421,
 -62660,
 187309885,
 127980,
 -62659,
 188422186,
 128666,
 -1,
 188483761,
 127795,
 188681034,
 187243547,
 -1,
 188746562,
 188624040,
 -1,
 -62655,
 188687570,
 128317,
 -1,
 188752345,
 128315,
 188943173,
 188688431,
 -1,
 -62652,
 188879120,
 127849,
 -1,
 188942003,
 10175,
 189139783,
 188878899,
 128021,
 -1,
 189071472,
 128054,
 -62648,
 189079009,
 128682,
 -62647,
 189208814,
 128044,
 -1,
 189268218,
 128687,
 189467475,
 188617398,
 -1,
 189533006,
 189410787,
 -1,
 -62643,
 189474279,
 128171,
 -1,
 189533989,
 128565,
 189729617,
 189473726,
 -1,
 -62640,
 189665061,
 128542,
 -1,
 189728611,
 128549,
 -62638,
 189669820,
 127919,
 -1,
 189858872,
 128160,
 190057306,
 189407501,
 -1,
 190122839,
 189996059,
 -1,
 -62634,
 190062548,
 128167,
 -1,
 190126550,
 128042,
 190319449,
 190055383,
 128009,
 -1,
 190251120,
 128050,
 -1,
 190254642,
 128087,
 190516063,
 189989587,
 -1,
 190581598,
 190454424,
 -1,
 -62627,
 190517604,
 127841,
 -1,
 190580853,
 128131,
 -1,
 190522386,
 128168,
 -1,
 190458497,
 128192,
 190909330,
 187181968,
 -1,
 190974829,
 190845328,
 -1,
 191040364,
 190911721,
 -1,
 -62620,
 190982492,
 128070,
 -62619,
 191046976,
 128307,
 -62618,
 191111757,
 128073,
 -62617,
 191176946,
 10068,
 -62616,
 191240007,
 128072,
 -62615,
 191304182,
 9989,
 -62614,
 191369152,
 128174,
 -62613,
 191434480,
 10069,
 -1,
 191499184,
 128071,
 -1,
 190972940,
 128011,
 191761275,
 190907091,
 -1,
 191826804,
 191702700,
 -1,
 191892339,
 191758336,
 -1,
 -62607,
 191835068,
 127754,
 -62606,
 191891756,
 128702,
 -1,
 191956794,
 128003,
 -1,
 191830512,
 127817,
 192220023,
 191769904,
 -1,
 -62602,
 192155944,
 127764,
 -1,
 192219674,
 127762,
 192416634,
 192158530,
 -1,
 -62599,
 192352552,
 127766,
 -1,
 192416282,
 127768,
 -1,
 192359185,
 128075,
 192678790,
 191699995,
 -1,
 192744325,
 192616748,
 -1,
 192809860,
 192676950,
 128105,
 192875395,
 192750441,
 -1,
 -62592,
 192816055,
 128097,
 -62591,
 192877008,
 128082,
 -62590,
 192940339,
 128090,
 -1,
 193005317,
 128098,
 -1,
 192807308,
 128111,
 -1,
 192744840,
 128698,
 -1,
 192681944,
 128058,
 193399690,
 192615346,
 -1,
 -62584,
 193336862,
 128521,
 -62583,
 193399932,
 127863,
 -1,
 193464975,
 127888,
 193661839,
 193334391,
 -1,
 193727374,
 193594722,
 -1,
 -62579,
 193662757,
 128553,
 -1,
 193726462,
 128576,
 -1,
 193661647,
 128146,
 194052095,
 193601805,
 -1,
 -62575,
 193924437,
 128295,
 -1,
 193987813,
 127873,
 194186169,
 190848027,
 -1,
 194251678,
 194125549,
 -1,
 194317212,
 194186561,
 -1,
 194382744,
 194255184,
 -1,
 -62569,
 194322784,
 128236,
 -1,
 194386145,
 128237,
 -62567,
 194320533,
 128275,
 -62566,
 194515393,
 128080,
 -62565,
 194580363,
 128194,
 -1,
 194643712,
 128214,
 -62563,
 194258739,
 128191,
 -1,
 194777686,
 9934,
 194972585,
 194191629,
 -1,
 195038120,
 194909457,
 -1,
 195103653,
 194977076,
 -1,
 -62558,
 195044495,
 2933,
 -62557,
 195109067,
 2930,
 -62556,
 195170709,
 2931,
 -1,
 195235107,
 2934,
 195493887,
 195045127,
 -1,
 -62553,
 195372185,
 2935,
 -1,
 195436755,
 2932,
 -1,
 194970755,
 128217,
 195693488,
 194910872,
 -1,
 195759023,
 195627367,
 -1,
 -62548,
 195700320,
 128662,
 -62547,
 195764246,
 128660,
 -62546,
 195823455,
 128653,
 -1,
 195888585,
 128664,
 -1,
 195690984,
 128283,
 196152243,
 195630843,
 -1,
 -62542,
 196095176,
 128117,
 -1,
 196155768,
 128116,
 -62540,
 196095234,
 128002,
 -62539,
 196291142,
 128228,
 -62538,
 196351360,
 128076,
 -62537,
 196415356,
 127970,
 -62536,
 196479712,
 127842,
 -1,
 196545086,
 128025,
 196742099,
 194121779,
 -1,
 196807622,
 196681997,
 -1,
 196873151,
 196742393,
 -1,
 -62531,
 196809175,
 128154,
 -62530,
 196871936,
 128215,
 -1,
 196936947,
 127823,
 197135298,
 196809806,
 -1,
 -62527,
 197070667,
 128513,
 -1,
 197134384,
 128568,
 197331909,
 197067475,
 -1,
 -62524,
 197271440,
 127815,
 -1,
 197332040,
 127891,
 -1,
 197271265,
 128151,
 197594057,
 196749359,
 -1,
 -62520,
 197530852,
 127928,
 -1,
 197592348,
 128130,
 197790668,
 197531794,
 -1,
 -62517,
 197733398,
 127775,
 -1,
 197789223,
 127760,
 197987279,
 197725303,
 -1,
 -62514,
 197926402,
 983912,
 -1,
 197990715,
 128142,
 -62512,
 197925929,
 128016,
 -62511,
 198120593,
 128103,
 -62510,
 198185596,
 128123,
 -1,
 198247468,
 127922,
 198446052,
 196678326,
 -1,
 198511585,
 198384280,
 -1,
 198577116,
 198451373,
 -1,
 198642650,
 198514343,
 -1,
 -62504,
 198583492,
 128289,
 -62503,
 198645706,
 128292,
 -1,
 198707162,
 128288,
 -62501,
 198583818,
 128291,
 -1,
 198843401,
 128290,
 -62499,
 198519502,
 9959,
 -62498,
 198971352,
 128129,
 -62497,
 199035680,
 8377,
 -62496,
 199100783,
 128232,
 -1,
 199165732,
 128229,
 -62494,
 198454732,
 127982,
 -62493,
 199301743,
 128127,
 -1,
 199362653,
 127848,
 199560175,
 198382906,
 -1,
 199625710,
 199492307,
 -1,
 199691245,
 199565103,
 -1,
 -62488,
 199632374,
 128304,
 -62487,
 199696436,
 127971,
 -62486,
 199761042,
 128121,
 -62485,
 199823719,
 128122,
 -62484,
 199887724,
 127886,
 -1,
 199952375,
 127983,
 -1,
 199624942,
 127875,
 -1,
 199560371,
 128086,
 200281082,
 199502445,
 -1,
 200346616,
 200217270,
 -1,
 200412150,
 200280816,
 -1,
 200477685,
 200343552,
 -1,
 -62476,
 200413288,
 127918,
 -1,
 200476571,
 128249,
 -1,
 200411118,
 128252,
 -62473,
 200350913,
 127931,
 -1,
 200673069,
 128243,
 -62471,
 200285366,
 127755,
 -1,
 200805913,
 128678,
 201001983,
 200222767,
 -1,
 201067518,
 200941317,
 -1,
 -62467,
 201008338,
 128316,
 -1,
 201073113,
 128314,
 -1,
 201005779,
 128530,
 -1,
 200945024,
 128155]
_charnames_2112 = [
2273,
2267,
2265,
2266,
2264,
2271,
2256,
2269,
2253,
2255,
2254,
2262,
2261,
2260,
2249,
2270,
2259,
2250,
2258,
2257,
2251,
2252,
2274,
2272,
2263,
2278,
2275,
2277,
-1,
-1,
2276,
]

_charnames_2383 = [
2866,
-1,
-1,
-1,
-1,
-1,
-1,
2862,
2861,
]

_charnames_7104 = [
865,
834,
860,
832,
848,
864,
857,
850,
829,
842,
847,
853,
826,
851,
861,
833,
858,
862,
855,
828,
844,
830,
835,
839,
836,
827,
846,
852,
825,
840,
856,
831,
838,
863,
841,
849,
859,
854,
884,
872,
874,
873,
876,
871,
875,
870,
867,
868,
889,
890,
887,
886,
]

_charnames_8341 = [
2608,
2607,
2606,
2605,
2604,
2603,
2602,
2601,
]

_charnames_9193 = [
1076,
1079,
1081,
1084,
1077,
1080,
1078,
1713,
1890,
1494,
2823,
]

_charnames_9989 = [
2920,
-1,
-1,
-1,
-1,
2542,
2541,
]

_charnames_10060 = [
2206,
-1,
2368,
-1,
-1,
-1,
-1,
1083,
2918,
2922,
]

_charnames_42912 = [
2617,
2598,
2616,
2597,
2611,
2590,
2615,
2595,
2614,
2582,
]

_charnames_43777 = [
2689,
2691,
2692,
2688,
2687,
2690,
-1,
-1,
2666,
2668,
2669,
2665,
2664,
2667,
-1,
-1,
2659,
2661,
2662,
2658,
2657,
2660,
]

_charnames_43808 = [
2673,
2675,
2677,
2674,
2672,
2671,
2676,
-1,
2681,
2683,
2685,
2682,
2680,
2679,
2684,
]

_charnames_64434 = [
1733,
1732,
1723,
1722,
1729,
1728,
1727,
1726,
1740,
1739,
1734,
1721,
1720,
1741,
1737,
1736,
]

_charnames_69632 = [
1056,
1057,
1053,
1055,
1054,
949,
952,
971,
972,
957,
958,
922,
923,
924,
925,
986,
951,
933,
950,
967,
966,
975,
974,
941,
978,
977,
970,
969,
939,
930,
929,
946,
945,
940,
932,
931,
948,
947,
942,
961,
960,
981,
980,
984,
982,
983,
964,
926,
955,
954,
956,
985,
963,
937,
935,
936,
1026,
1033,
1029,
1030,
1027,
1028,
1019,
1020,
1021,
1022,
1032,
1025,
1031,
1024,
1034,
1051,
1050,
1064,
1063,
1061,
1065,
1060,
-1,
-1,
-1,
-1,
1008,
990,
993,
1003,
1006,
997,
999,
1014,
1012,
995,
991,
994,
1004,
1007,
998,
1000,
1015,
1013,
1011,
1010,
1046,
1047,
1038,
1039,
1044,
1045,
1041,
1042,
1049,
1048,
]

_charnames_92160 = [
551,
659,
628,
629,
572,
603,
648,
560,
606,
625,
626,
582,
644,
553,
580,
587,
596,
614,
547,
634,
565,
612,
550,
654,
653,
546,
585,
620,
657,
621,
592,
559,
662,
658,
545,
613,
597,
598,
590,
638,
622,
569,
631,
581,
574,
630,
643,
651,
611,
646,
584,
635,
568,
639,
591,
602,
652,
665,
664,
640,
610,
586,
605,
543,
607,
556,
618,
566,
661,
552,
583,
573,
595,
557,
647,
609,
619,
562,
579,
555,
637,
563,
663,
650,
575,
571,
594,
699,
734,
708,
709,
729,
671,
718,
737,
670,
719,
723,
738,
727,
701,
702,
740,
722,
733,
706,
705,
680,
673,
696,
714,
741,
713,
728,
724,
746,
694,
691,
745,
710,
735,
684,
689,
690,
681,
707,
674,
685,
697,
721,
683,
743,
672,
744,
715,
678,
677,
730,
692,
700,
675,
717,
693,
404,
441,
495,
533,
402,
419,
405,
528,
453,
530,
445,
437,
451,
523,
423,
460,
479,
529,
482,
496,
440,
463,
414,
455,
497,
490,
491,
512,
424,
506,
432,
502,
514,
401,
535,
444,
471,
438,
398,
517,
456,
474,
435,
504,
399,
538,
418,
415,
413,
539,
536,
452,
537,
431,
518,
501,
410,
428,
486,
397,
467,
464,
519,
488,
430,
406,
532,
400,
412,
436,
489,
411,
422,
470,
498,
421,
509,
513,
454,
468,
461,
480,
450,
481,
459,
494,
427,
473,
472,
510,
484,
485,
407,
443,
520,
524,
525,
505,
299,
386,
246,
282,
247,
360,
249,
259,
240,
265,
385,
234,
312,
236,
331,
342,
311,
252,
318,
332,
377,
335,
322,
284,
268,
301,
293,
324,
376,
250,
329,
231,
346,
389,
233,
391,
269,
288,
355,
270,
305,
290,
363,
289,
281,
358,
256,
297,
338,
264,
344,
323,
375,
330,
383,
345,
232,
285,
255,
328,
368,
366,
262,
356,
239,
286,
242,
374,
369,
373,
271,
274,
319,
336,
244,
235,
347,
294,
334,
260,
343,
302,
241,
354,
243,
258,
251,
388,
333,
380,
350,
348,
263,
382,
357,
295,
279,
317,
304,
315,
310,
337,
277,
313,
275,
367,
278,
314,
364,
303,
359,
381,
349,
276,
298,
321,
392,
36,
120,
100,
165,
222,
160,
72,
154,
209,
49,
40,
68,
112,
13,
179,
215,
152,
22,
73,
119,
172,
162,
51,
28,
91,
11,
27,
50,
211,
45,
85,
155,
17,
98,
198,
12,
46,
93,
159,
23,
38,
113,
151,
69,
34,
19,
142,
199,
117,
133,
86,
116,
177,
153,
124,
220,
217,
166,
65,
110,
203,
29,
149,
97,
101,
54,
63,
206,
115,
173,
143,
56,
141,
105,
39,
80,
130,
168,
188,
205,
8,
178,
90,
14,
201,
190,
59,
84,
136,
21,
57,
53,
87,
95,
189,
62,
103,
200,
186,
102,
67,
9,
171,
79,
60,
134,
18,
76,
187,
192,
43,
225,
121,
223,
224,
164,
75,
109,
111,
35,
148,
135,
24,
131,
138,
139,
128,
129,
176,
83,
44,
70,
216,
193,
221,
167,
94,
212,
210,
25,
30,
146,
147,
185,
61,
77,
161,
180,
106,
89,
92,
123,
181,
104,
125,
191,
202,
779,
817,
776,
819,
784,
798,
757,
809,
786,
787,
794,
799,
761,
753,
789,
767,
766,
768,
769,
775,
773,
750,
749,
752,
811,
764,
812,
759,
803,
758,
814,
804,
788,
760,
782,
774,
755,
756,
765,
805,
818,
815,
808,
807,
778,
791,
783,
795,
793,
792,
800,
777,
770,
816,
]

_charnames_127136 = [
2012,
2006,
1938,
1943,
1976,
1981,
1954,
1959,
2001,
1991,
1948,
1996,
1965,
1986,
1970,
-1,
-1,
2007,
1939,
1944,
1977,
1982,
1955,
1960,
2002,
1992,
1949,
1997,
1966,
1987,
1971,
-1,
-1,
2008,
1940,
1945,
1978,
1983,
1956,
1961,
2003,
1993,
1950,
1998,
1967,
1988,
1972,
2011,
-1,
2009,
1941,
1946,
1979,
1984,
1957,
1962,
2004,
1994,
1951,
1999,
1968,
1989,
1973,
2013,
]

_charnames_127280 = [
1791,
-1,
1790,
1789,
1788,
1787,
1786,
1785,
1784,
1783,
1782,
1781,
1780,
-1,
1779,
-1,
1778,
1777,
-1,
1776,
1775,
1774,
-1,
1773,
1772,
1771,
-1,
-1,
-1,
-1,
-1,
1818,
2394,
2393,
2392,
2391,
2390,
2389,
2388,
-1,
2387,
2386,
2385,
2384,
2383,
2382,
2381,
-1,
2380,
2379,
2378,
2377,
2376,
2375,
2374,
2373,
2372,
2371,
-1,
-1,
-1,
-1,
-1,
-1,
2366,
2365,
2364,
2363,
2362,
2361,
2360,
2359,
2358,
-1,
2357,
-1,
-1,
2356,
2355,
-1,
2354,
2353,
2352,
2351,
2350,
2349,
2348,
2347,
2346,
2345,
-1,
-1,
-1,
-1,
2369,
2367,
-1,
1811,
1810,
1824,
1823,
1814,
1813,
1822,
1821,
1820,
1819,
]

_charnames_127462 = [
2532,
2531,
2530,
2529,
2528,
2527,
2526,
2525,
2524,
2523,
2522,
2521,
2520,
2519,
2518,
2517,
2516,
2515,
2514,
2513,
2512,
2511,
2510,
2509,
2508,
2507,
-1,
1817,
1816,
]

_charnames_127538 = [
1799,
1798,
1808,
1805,
1803,
1804,
1800,
1809,
1807,
]

_charnames_127744 = [
2225,
2777,
2142,
2418,
1872,
1871,
2241,
1873,
2543,
1068,
2928,
3064,
2333,
2701,
2700,
2699,
3019,
2398,
2934,
2760,
2933,
2786,
2936,
2627,
2937,
2215,
2397,
2759,
2626,
2785,
1875,
3018,
1895,
]

_charnames_127792 = [
2176,
1912,
2721,
2877,
2066,
2201,
-1,
1545,
2174,
2554,
2845,
1874,
1090,
2704,
2703,
2810,
2774,
2289,
2750,
2647,
2324,
1520,
1758,
3011,
2338,
2931,
1474,
2645,
901,
2074,
2536,
3006,
2034,
2035,
2175,
1882,
2850,
1904,
2339,
2042,
2564,
2565,
2164,
2229,
1885,
1865,
1072,
2772,
2558,
2908,
2999,
1878,
2771,
2764,
1925,
1898,
3043,
2883,
2163,
2187,
2198,
2637,
2234,
2826,
1894,
1107,
2050,
2162,
2775,
1530,
1922,
2952,
2170,
1501,
1114,
2147,
906,
-1,
-1,
-1,
2567,
2961,
1117,
3053,
2186,
2748,
2755,
2756,
915,
2063,
2158,
1475,
2205,
2075,
3051,
2195,
2953,
2317,
1917,
3012,
]

_charnames_127904 = [
2196,
2788,
2556,
2763,
2332,
2316,
2242,
2809,
1745,
1518,
2240,
1495,
2150,
2028,
3059,
2897,
1903,
1122,
3026,
1101,
2780,
2322,
2325,
1920,
3015,
2323,
1514,
3062,
2321,
2570,
1531,
1928,
914,
2177,
1909,
2571,
1879,
-1,
1502,
2816,
1763,
2572,
1933,
]

_charnames_127968 = [
2822,
2821,
2998,
3048,
2715,
2828,
895,
1757,
2827,
2632,
2159,
1916,
2875,
2746,
3041,
3052,
2716,
]

_charnames_128000 = [
2549,
2298,
2995,
2930,
2165,
1488,
2644,
2547,
2189,
2903,
2208,
2924,
1908,
1907,
2814,
2550,
3023,
1897,
2302,
2555,
2185,
2885,
2069,
1104,
2710,
3000,
1868,
1130,
1748,
2825,
2628,
2762,
1500,
1089,
1544,
2851,
905,
2769,
1118,
2032,
2503,
2054,
2902,
912,
2888,
2299,
2166,
1489,
2548,
2190,
2904,
1866,
2817,
2303,
2886,
2072,
2770,
2848,
2949,
1113,
2065,
2071,
2061,
-1,
2712,
-1,
2696,
2412,
2300,
1519,
2915,
2923,
2919,
2917,
2765,
2938,
2997,
1540,
1541,
2149,
2969,
2207,
2944,
2713,
2401,
1546,
3054,
2905,
2500,
1123,
2945,
2082,
2853,
2043,
2284,
1765,
2843,
2943,
2946,
2776,
1128,
1127,
1100,
3024,
2245,
2941,
2749,
2283,
1535,
1534,
2047,
2947,
1069,
2022,
2282,
2281,
2994,
2993,
902,
2154,
2087,
3049,
3050,
3025,
907,
2720,
1712,
3042,
1927,
3037,
3016,
2909,
2649,
2416,
2745,
2854,
909,
1932,
2077,
2499,
2631,
2566,
3022,
2495,
1102,
2167,
2958,
1112,
1071,
1536,
1863,
3013,
2806,
1086,
3004,
3071,
2083,
2805,
2533,
2807,
2898,
2709,
1753,
1103,
1902,
2169,
1867,
2901,
2910,
2078,
2783,
2892,
1860,
1542,
2921,
2855,
2306,
2230,
2798,
2216,
897,
900,
899,
898,
2305,
2181,
1914,
2026,
1070,
2328,
2781,
2972,
2911,
2766,
2970,
2058,
2059,
2200,
1529,
2197,
2180,
2182,
910,
2146,
2085,
2553,
2064,
1883,
1511,
1098,
2646,
2410,
2411,
2144,
2971,
3005,
1087,
2984,
1099,
2415,
1918,
2337,
1527,
2060,
2747,
1921,
2086,
2178,
2996,
3040,
2067,
2722,
3039,
2718,
2141,
2140,
2966,
2967,
2052,
2053,
2399,
2308,
2310,
3063,
2311,
2407,
1750,
2199,
-1,
3060,
1525,
2545,
3061,
-1,
-1,
-1,
1537,
2135,
2136,
2137,
1749,
2635,
2844,
1856,
1852,
1855,
1854,
893,
2708,
2641,
2561,
2634,
2143,
2501,
2633,
2968,
1109,
1110,
1097,
2650,
2546,
913,
2719,
2991,
1924,
1517,
2406,
2502,
3033,
3031,
3035,
3034,
3032,
2753,
2707,
2960,
2849,
2417,
2829,
2079,
2331,
1526,
2213,
1930,
3047,
1513,
1082,
2916,
2623,
2622,
2624,
2621,
1846,
1847,
3069,
2881,
3068,
2880,
]

_charnames_128336 = [
2130,
2097,
2103,
2117,
2120,
2110,
2113,
2127,
2133,
2106,
2124,
2100,
2129,
2096,
2102,
2116,
2119,
2109,
2112,
2126,
2132,
2105,
2123,
2099,
]

_charnames_128507 = [
2297,
1521,
1888,
1931,
2315,
-1,
3008,
2735,
1829,
1832,
1833,
1831,
1837,
1835,
2951,
1840,
2743,
2535,
1836,
1839,
1844,
2400,
-1,
3070,
2739,
2031,
-1,
2157,
-1,
2744,
-1,
2497,
-1,
2730,
2731,
2895,
-1,
1752,
2040,
2211,
2027,
2738,
2896,
-1,
-1,
2789,
2956,
1901,
1493,
-1,
2636,
-1,
-1,
2733,
2742,
1761,
2782,
-1,
2893,
2740,
2737,
3009,
2193,
1842,
1843,
2192,
2498,
2041,
2212,
2957,
-1,
-1,
-1,
-1,
2736,
2734,
2025,
1913,
2808,
1857,
2852,
2023,
2024,
2020,
2021,
]

_charnames_128640 = [
2557,
2811,
1886,
2544,
2841,
2842,
1507,
2335,
2651,
1889,
1505,
1506,
1125,
2989,
1503,
1129,
2329,
1764,
2757,
2045,
2988,
1476,
2987,
1756,
2990,
2537,
2876,
1746,
1508,
2307,
2294,
1877,
2295,
1766,
1896,
2552,
1859,
2818,
3065,
2155,
2046,
1512,
2887,
2408,
1848,
2404,
2084,
2889,
2049,
2413,
1121,
2409,
1120,
2296,
2036,
2405,
2184,
2336,
2948,
2534,
904,
1522,
2929,
1893,
891,
892,
2062,
2233,
916,
2643,
]

_charnames_128768 = [
1697,
1593,
1710,
1711,
1695,
1582,
1580,
1581,
1578,
1579,
1643,
1646,
1645,
1560,
1660,
1639,
1670,
1673,
1672,
1613,
1562,
1700,
1648,
1649,
1628,
1629,
1707,
1573,
1690,
1691,
1605,
1624,
1611,
1692,
1557,
1603,
1604,
1612,
1564,
1555,
1650,
1664,
1704,
1591,
1558,
1565,
1556,
1647,
1622,
1623,
1616,
1620,
1619,
1618,
1584,
1585,
1675,
1566,
1590,
1625,
1626,
1588,
1640,
1665,
1666,
1698,
1631,
1634,
1633,
1586,
1709,
1571,
1663,
1706,
1694,
1653,
1608,
1667,
1607,
1574,
1609,
1668,
1570,
1703,
1572,
1708,
1679,
1589,
1655,
1638,
1654,
1592,
1568,
1569,
1559,
1659,
1687,
1685,
1686,
1658,
1657,
1596,
1601,
1600,
1599,
1598,
1587,
1637,
1636,
1627,
1678,
1701,
1688,
1674,
1682,
1681,
]

_charnames_983612 = [
2599,
2587,
2588,
2584,
2585,
2580,
2581,
2593,
2594,
1108,
1464,
1453,
1472,
1452,
1461,
1450,
1460,
1449,
1468,
1469,
1466,
1462,
1457,
1467,
1459,
1458,
1463,
1451,
1470,
1456,
1455,
1454,
1471,
1465,
1296,
1301,
1302,
1297,
1298,
1303,
1304,
1295,
1299,
1300,
1294,
1179,
1184,
1185,
1180,
1181,
1186,
1187,
1178,
1182,
1183,
1177,
1439,
1444,
1445,
1440,
1441,
1446,
1447,
1438,
1442,
1443,
1437,
1166,
1171,
1172,
1167,
1168,
1173,
1174,
1165,
1169,
1170,
1164,
1310,
1315,
1316,
1311,
1312,
1317,
1318,
1309,
1313,
1314,
1308,
1153,
1158,
1159,
1154,
1155,
1160,
1161,
1152,
1156,
1157,
1151,
1322,
1327,
1328,
1323,
1324,
1329,
1330,
1321,
1325,
1326,
1320,
1191,
1196,
1197,
1192,
1193,
1198,
1199,
1190,
1194,
1195,
1189,
1387,
1392,
1393,
1388,
1389,
1394,
1395,
1386,
1390,
1391,
1385,
1400,
1405,
1406,
1401,
1402,
1407,
1408,
1399,
1403,
1404,
1398,
1361,
1366,
1367,
1362,
1363,
1368,
1369,
1360,
1364,
1365,
1359,
1348,
1353,
1354,
1349,
1350,
1355,
1356,
1347,
1351,
1352,
1346,
1270,
1275,
1276,
1271,
1272,
1277,
1278,
1269,
1273,
1274,
1268,
1374,
1379,
1380,
1375,
1376,
1381,
1382,
1373,
1377,
1378,
1372,
1246,
1251,
1252,
1247,
1248,
1253,
1254,
1245,
1249,
1250,
1244,
1258,
1263,
1264,
1259,
1260,
1265,
1266,
1257,
1261,
1262,
1256,
1336,
1341,
1342,
1337,
1338,
1343,
1344,
1335,
1339,
1340,
1334,
1141,
1146,
1147,
1142,
1143,
1148,
1149,
1140,
1144,
1145,
1139,
1413,
1418,
1419,
1414,
1415,
1420,
1421,
1412,
1416,
1417,
1411,
1205,
1210,
1211,
1206,
1207,
1212,
1213,
1204,
1208,
1209,
1203,
1219,
1224,
1225,
1220,
1221,
1226,
1227,
1218,
1222,
1223,
1217,
1231,
1236,
1237,
1232,
1233,
1238,
1239,
1230,
1234,
1235,
1229,
1426,
1431,
1432,
1427,
1428,
1433,
1434,
1425,
1429,
1430,
1424,
1281,
1284,
1289,
1290,
1285,
1286,
1291,
1292,
1283,
1287,
1288,
1282,
1214,
3021,
2441,
2439,
2440,
2438,
2434,
2447,
2445,
2446,
2444,
2432,
2462,
2425,
2461,
2424,
2435,
2430,
2428,
2429,
2427,
2433,
2468,
2455,
2456,
2454,
2466,
2463,
2465,
2458,
2464,
2450,
2449,
2451,
2467,
2459,
2477,
2473,
2470,
2471,
2474,
2476,
2478,
2837,
2835,
2833,
2836,
2834,
2485,
2483,
2481,
2484,
2482,
2492,
2489,
2490,
2491,
2314,
2313,
]

def lookup_charcode(code):
    res = -1
    if code == 1318: res = 2223
    elif code == 1319: res = 2220
    elif code == 1568: res = 1743
    elif code == 1631: res = 1742
    elif 2112 <= code <= 2142: res = _charnames_2112[code-2112]
    elif code == 2362: res = 2865
    elif code == 2363: res = 2864
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 2873
    elif code == 2420: res = 2872
    elif code == 2421: res = 2874
    elif code == 2422: res = 2870
    elif code == 2423: res = 2869
    elif code == 2930: res = 2978
    elif code == 2931: res = 2979
    elif code == 2932: res = 2983
    elif code == 2933: res = 2977
    elif code == 2934: res = 2980
    elif code == 2935: res = 2982
    elif code == 3369: res = 2287
    elif code == 3386: res = 2286
    elif code == 3406: res = 2288
    elif code == 3980: res = 1484
    elif code == 3981: res = 1482
    elif code == 3982: res = 1481
    elif code == 3983: res = 1483
    elif code == 4057: res = 1487
    elif code == 4058: res = 1486
    elif code == 4957: res = 2695
    elif code == 4958: res = 2694
    elif 7104 <= code <= 7155: res = _charnames_7104[code-7104]
    elif code == 7164: res = 882
    elif code == 7165: res = 880
    elif code == 7166: res = 883
    elif code == 7167: res = 881
    elif code == 7676: res = 2168
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif code == 8377: res = 3038
    elif 9193 <= code <= 9203: res = _charnames_9193[code-9193]
    elif code == 9934: res = 2973
    elif code == 9954: res = 1760
    elif code == 9956: res = 2030
    elif code == 9957: res = 2562
    elif code == 9958: res = 2642
    elif code == 9959: res = 3036
    elif 9989 <= code <= 9995: res = _charnames_9989[code-9989]
    elif code == 10024: res = 1864
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 2795
    elif code == 10080: res = 2796
    elif code == 10133: res = 2800
    elif code == 10134: res = 2801
    elif code == 10135: res = 2799
    elif code == 10160: res = 2231
    elif code == 10175: res = 2884
    elif code == 10190: res = 1794
    elif code == 10191: res = 1793
    elif code == 11632: res = 1491
    elif code == 11647: res = 1492
    elif code == 12728: res = 1095
    elif code == 12729: res = 1094
    elif code == 12730: res = 1093
    elif code == 42592: res = 2224
    elif code == 42593: res = 2221
    elif code == 42893: res = 2613
    elif code == 42894: res = 2596
    elif code == 42896: res = 2612
    elif code == 42897: res = 2591
    elif 42912 <= code <= 42921: res = _charnames_42912[code-42912]
    elif code == 43002: res = 2618
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif code == 110592: res = 2493
    elif code == 110593: res = 2838
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127280 <= code <= 127386: res = _charnames_127280[code-127280]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127546: res = _charnames_127538[code-127538]
    elif code == 127568: res = 2238
    elif code == 127569: res = 2239
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128317: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 983612 <= code <= 983969: res = _charnames_983612[code-983612]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCB or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7168),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdkddddddddddddddd\x15\x15\x15lmddddddddddd\x15\x15\x15\x15nddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15oddddddddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddpddddddddddddddd'
'ddddddddddddddddqrstuvwxddddddddddddddddddddddddyz{|}~\x7f\x80dddddddd'
'\x81\x825555555\x83\x84\x8555555555555555555555555\x8655555\x8755555555555555555\x885555'
'5555555555555555555555555555555555\x8955555555555555555555555555555'
'55555555555555555555555555555555555555\x8a5555555555555555\x8b\x8c\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x865\x8c\x8d\x8d\x8d\x8d\x8e'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d'
'\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8e'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x8f\x90dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x91'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x91'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xc9\x85\x85z\x97z\x85\x86\x8fd\x85\xa4sZts;;;;;;;;;;t\x85\xb2\xb1\xb2\x85'
'\x8500000000000000000000000000\x8f\x85d\x9eW\x9e\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x8f\xb1d\xb1\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xc6}\x97\x97\x93\x97\xc2\xbe\x9b\xc1\x14m\xb1\x06\xbe\x9e\xb6\xa6II\x9b\x16\xbe\x7f\x9bI\x14iNNN}'
'//////-/////////-//////\xa9-/////-\x14\x14\x14\x16\x16\x16\x16\x14\x16\x14\x14\x14\x16\x14\x14\x16\x16\x14\x16\x14\x14\x16\x16\x16\xa9\x14\x14\x14\x16\x14\x16\x14\x16'
'/\x14/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x14/\x14/\x16/\x16/\x16/\x14/\x16/\x16/\x16/\x16/\x16-\x14/\x16/\x14/\x16/\x16/\x14-\x14/\x16/\x16\x14/\x16/\x16/\x16-'
'\x14-\x14/\x14/\x16/\x14\x14-\x14/\x14/\x16/\x16-\x14/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16-\x14/\x16/\x14/\x16/\x16/\x16/\x16/\x16/\x16//\x16/\x16/\x16\x16'
'\x16//\x16/\x16//\x16///\x16\x16////\x16//\x16///\x16\x16\x16//\x16//\x16/\x16/\x16//\x16/\x16\x16/\x16//\x16///\x16/\x16//\x16\x16(/\x16\x16\x16'
'((((/,\x16/,\x16/,\x16/\x14/\x14/\x14/\x14/\x14/\x14/\x14/\x14\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16/,\x16/\x16///\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16\x16\x16//\x16//\x16'
'\x16/\x16////\x16/\x16/\x16/\x16/\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16(\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e""\x1d\x1d\x1d\x1d\x1d'
'\x1e\x1e\x9d\x9d\x9b\x9d" "   " ""\x19\x1d\x9d\x9d\x9d\x9d\x9d\x9d\x9b\x9b\x9b\x9b\x9d\x9b\x9d\x9b\x1e\x1e\x1e\x1e\x1e\x9d\x9d\x9d\x9d\x9d\x9d\x9d"\x9d\x1d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d'
'4444444444444444444444444444444444444444444444444444444444444444'
'444445444444444444444444444444444444444444444444/\x16/\x16"\x9d/\x16\x10\x10\x1c\x16\x16\x16\x83\x10'
'\x10\x10\x10\x10\x9d\x9d/\x84///\x10/\x10//\x16-----------------\x10-------//\x16\x16\x16\x16\x16\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x16\x14\x14\x14\x14\x14\x14\x14\x16\x16\x16\x16\x16/\x16\x16///\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16/\x16\xae/\x16//\x16\x16///'
'/-//////////////--------------------------------\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x16\x14\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16\xbc6666622/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'//\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10///////////////'
'///////////////////////\x10\x10\x1d||||||\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x10|]\x10\x10\x10\x10\x10\x10666666666666666666666666666666666666666666666_6'
'\x8966\x8966\x896\x10\x10\x10\x10\x10\x10\x10\x10+++++++++++++++++++++++++++\x10\x10\x10\x10\x10+++\x89\x8a\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x05\x05\x05\x05\x10\x10\xae\xae\xa0yy\x92rn\xc1\xc166666666666n\x10\x10nn%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'\x18%%%%%%%%%%6666666666666666666668888888888yoon%%6%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%n%6666666\x05\xc1666666\x18\x1866\xc16666%%::::::::::%%%\xb5\xb5%'
'nnnnnnnnnnnnnn\x10\x05%6%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%6666666666666666'
'66666666666\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%66666666666%\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'==========+++++++++++++++++++++++++++++++++666666666##\xc1\x83\x83\x83#\x10\x10\x10\x10\x10'
'++++++++++++++++++++++6666#666666666#666#66666\x10\x10\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x10'
'+++++++++++++++++++++++++666\x10\x10\x89\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'6661((((((((((((((((((((((((((((((((((((((((((((((((((((((616(11'
'1666666661111611(6666666((((((((((66||<<<<<<<<<<|\x1d((((((\x10((((((('
'\x10611\x10((((((((\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10(\x10\x10\x10((((\x10\x106(11'
'16666\x10\x1011\x10\x10116(\x10\x10\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10((\x10(((66\x10\x10<<<<<<<<<<((\x96\x96KKKKKK\xbc\x96\x10\x10\x10\x10'
'\x10661\x10((((((\x10\x10\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10((\x10((\x10((\x10\x106\x1011'
'166\x10\x10\x10\x1066\x10\x10666\x10\x10\x106\x10\x10\x10\x10\x10\x10\x10((((\x10(\x10\x10\x10\x10\x10\x10\x10<<<<<<<<<<66(((6\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10661\x10(((((((((\x10(((\x10((((((((((((((((((((((\x10(((((((\x10((\x10(((((\x10\x106(11'
'166666\x10661\x10116\x10\x10(\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<\x10\x96\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10611\x10((((((((\x10\x10((\x10\x10((((((((((((((((((((((\x10(((((((\x10((\x10(((((\x10\x106(16'
'16666\x10\x1011\x10\x10116\x10\x10\x10\x10\x10\x10\x10\x1061\x10\x10\x10\x10((\x10(((66\x10\x10<<<<<<<<<<\xbc(KKKKKK\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x106(\x10((((((\x10\x10\x10(((\x10((((\x10\x10\x10((\x10(\x10((\x10\x10\x10((\x10\x10\x10(((\x10\x10\x10((((((((((((\x10\x10\x10\x1011'
'611\x10\x10\x10111\x101116\x10\x10(\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10<<<<<<<<<<KKK\xc1\xc1\xc1\xc1\xc1\xc1\x96\xc1\x10\x10\x10\x10\x10'
'\x10111\x10((((((((\x10(((\x10(((((((((((((((((((((((\x10((((((((((\x10(((((\x10\x10\x10(66'
'61111\x10666\x106666\x10\x10\x10\x10\x10\x10\x1066\x10((\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10PPPPPPP\xbc'
'\x10\x1011\x10((((((((\x10(((\x10(((((((((((((((((((((((\x10((((((((((\x10(((((\x10\x106(13'
'11111\x10311\x101166\x10\x10\x10\x10\x10\x10\x1011\x10\x10\x10\x10\x10\x10\x10(\x10((66\x10\x10<<<<<<<<<<\x10((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x1011\x10((((((((\x10(((\x10(((((((((((((((((((((((((((((((((((((((((\x10\x10(11'
'16666\x10111\x101116(\x10\x10\x10\x10\x10\x10\x10\x101\x10\x10\x10\x10\x10\x10\x10\x10((66\x10\x10<<<<<<<<<<KKKKKK\x10\x10\x10\xbc(((((('
'\x10\x1011\x10((((((((((((((((((\x10\x10\x10((((((((((((((((((((((((\x10(((((((((\x10(\x10\x10'
'(((((((\x10\x10\x106\x10\x10\x10\x10111666\x106\x1011111111\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1011|\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10((((((((((((((((((((((((((((((((((((((((((((((((6('6666666\x10\x10\x10\x10\x96"
'((((((\x1d66666666|<<<<<<<<<<||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
"\x10((\x10(\x10\x10((\x10(\x10\x10(\x10\x10\x10\x10\x10\x10((((\x10(((((((\x10(((\x10(\x10(\x10\x10((\x10((((6('666666\x1066(\x10\x10"
'(((((\x10\x1d\x10666666\x10\x10<<<<<<<<<<\x10\x10((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(\xbc\xbc\xbc|||||||||||||||\xbc\xbc\xbc\xbc\xbc66\xbc\xbc\xbc\xbc\xbc\xbc<<<<<<<<<<KKKKKKKKKK\xbc6\xbc6\xbc6\x8ec\x8ec11'
'((((((((\x10((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10666666666666661'
'66666|66(((((66666666666\x10666666666666666666666666666666666666\x10\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc6\xbc\xbc\xbc\xbc\xbc\xbc\x10\xbc\xbc|||||\xbc\xbc\xbc\xbc||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((11666616666661661166('
'<<<<<<<<<<||||||((((((1166((((666(111((1111111(((6666((((((((((('
'((611661111116(1<<<<<<<<<<1116\xbc\xbc////////////////////////////////'
'//////\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((((((((((((((|\x1d\x10\x10\x10'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))(((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((()))))(((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((())))))'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((\x10((((\x10\x10(((((((\x10(\x10((((\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((\x10((((\x10\x10(((((((((((((((((((((((((((((((((\x10((((\x10\x10(((((((\x10'
'(\x10((((\x10\x10(((((((((((((((\x10(((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((\x10((((\x10\x10(((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((\x10\x10666\xbc||||||||LLLLLLLLLKKKKKKKKKKK\x10\x10\x10'
'((((((((((((((((\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
']((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((||((((((((((((((((('
'\xc8((((((((((((((((((((((((((\x8ec\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((|||AAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((\x10((((666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((((((((((((((((((666||\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((66\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((\x10(((\x1066\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((((((\x08\x081666666611'
'11111161166666666666|||\x1d|||\x96(6\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10PPPPPPPPPP\x10\x10\x10\x10\x10\x10'
'\x83\x83\x83\x83\x83\x83]\x83\x83\x83\x83666\xc8\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((\x1d((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((6(\x10\x10\x10\x10\x10(((((((((((((((('
'((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((\x10\x10\x10666111166111\x10\x10\x10\x10116111111666\x10\x10\x10\x10'
'\xc1\x10\x10\x10\x83\x83<<<<<<<<<<((((((((((((((((((((((((((((((\x10\x10(((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x101111111111111111'
'1(((((((11\x10\x10\x10\x10\x10\x10<<<<<<<<<<L\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'(((((((((((((((((((((((66111\x10\x10||(((((((((((((((((((((((((((((((('
'(((((((((((((((((((((1616666666\x1061611666666661111116666666666\x10\x106'
'<<<<<<<<<<\x10\x10\x10\x10\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10|||||||\x1d||||||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'66661(((((((((((((((((((((((((((((((((((((((((((((((616666616111'
'11611(((((((\x10\x10\x10\x10<<<<<<<<<<|||||||\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc666666666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10'
'661((((((((((((((((((((((((((((((1666611661\x10\x10\x10((<<<<<<<<<<\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((61661116166611\x10\x10\x10\x10\x10\x10\x10\x10||||'
'((((((((((((((((((((((((((((((((((((11111111666666661166\x10\x10\x10|||||'
'<<<<<<<<<<\x10\x10\x10(((<<<<<<<<<<((((((((((((((((((((((((((((((\x1d\x1d\x1d\x1d\x1d\x1d||'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10666|666666666666616666666((((6((((1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e'
'\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e'
'666666666666666666666666666666666666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x106666'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x10\x10//////\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x16\x16////////'
'\x16\x16\x16\x16\x16\x16\x10\x10//////\x10\x10\x16\x16\x16\x16\x16\x16\x16\x16\x10/\x10/\x10/\x10/\x16\x16\x16\x16\x16\x16\x16\x16////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10'
'\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x16\x16\x16,,,,,,,,\x16\x16\x16\x16\x16\x10\x16\x16////,\x9d\x16\x9d'
'\x9d\x9d\x16\x16\x16\x10\x16\x16////,\x9d\x9d\x9d\x16\x16\x16\x16\x10\x10\x16\x16////\x10\x9d\x9d\x9d\x16\x16\x16\x16\x16\x16\x16\x16/////\x9d\x9d\x9d\x10\x10\x16\x16\x16\x10\x16\x16////,\x9d\x9d\x10'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x07\x07\x07\x08\r\\]]\\\\\\}\x83kh\x8dljg\x8dl}}}\x83~}}~\xc4\xc5\t\x0e\x0c\n\x0f\xc6wywwy}\x83\x83\x83mi}\x83\x83}V'
'V\x83\x83\x83\xa1\x8ec\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\xae\x83V\x83\x83\x83\x83\x83\x83\x83\x83\x83\x83\xc8\x07\x07\x07\x07\x07\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07J\x1d\x10\x10IJJJJJ\xa3\xa3\xae\x8ec\x19'
'JIIIIJJJJJ\xa3\xa3\xae\x8ec\x10\x1e\x1e\x1e\x1e\x1e\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x10\x10\x10\x96\x96\x96\x96\x96\x96\x96\x96\x96\x95\x96\x96\x93\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10666666666666622226222666666666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1/\xbe\xc1\xbe\xc1/\xc1\xbe\x16///\x16\x16///\x14\xc1/\xbe\xc1\xb0/////\xc1\xc1\xc1\xbe\xbe\xc1/\xc1-\xc1/\xc1/-//\xb8\x16////\x16((((\x16\xc1\xc1\x16\x16//'
'\xaf\xae\xae\xae\xae/\x16\x16\x16\x16\xc1\xae\xc1\xc1\x16\xbcPPPNNPPPPPPNNNNP>>>>>>>>>>>>BBBB??????????CCCCCC'
'AAA/\x16AAAAN\x10\x10\x10\x10\x10\x10\xa9\xa9\xa9\xa9\xa9\xbe\xbe\xbe\xbe\xbe\xae\xae\xc1\xc1\xc1\xc1\xae\xc1\xc1\xae\xc1\xc1\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xc1\xc1\xa9\xc1\xa9\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xa9\xaf\xaa\xaa\xaf\xae\xae\xa9\xaa\xaf\xaf\xaa\xaf\xaf\xae\xa9\xae\xaa\xa3\xa7\xae\xaa\xaf\xae\xae\xae\xaa\xaf\xaf\xaa\xa9\xaa\xaa\xaf\xaf\xa9\xaf\xa9\xaf\xa9\xa9\xa9\xa9\xaa\xaa\xaf\xaa\xaf\xaf\xaf\xaf\xaf\xa9\xa9\xa9\xa9\xae\xaf\xae\xaf\xaa\xaa\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaa\xaf\xaf\xaf\xaa\xae\xae\xae\xae\xae\xaa\xaf\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaa\xa9\xaf\xae\xaa\xaa\xaa\xaa\xaf\xaf\xaa\xaa\xae\xae\xaa\xaa\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaa\xaa\xaf\xaf\xaa\xaa\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xae\xae\xa9\xae\xae\xaf\xa9\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xa9\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaa'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xaf\xaf\xaf\xaf\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xaf\xaf\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x91f\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xc1\xae\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10OOOOOOOOONNNNNNNNNNNOOOOOOOOONNN'
'NNNNNNNNIIIIIIIIIHHHHHHHHHHH\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbbQNNNNNNNNNNOOOOOOOOONO'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xbe\xa9\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1'
'\xbe\xa9\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xc1\xc1\xbe\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae'
'\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xbe\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xc1\xbe\xbe\xc1\xa9\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xbe'
'\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\xbe\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbe\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ecOOOOOOOOON'
'QQQQQQQQQPQQQQQQQQQP\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xaf\xae\xae\xaf\xaf\x8ec\xae\xaf\xaf\xae\x10\xaf\x10\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\x8fd\x8fd\x8fd\x8fd\x8ec\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\x8ec\x8fd\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\x8ec\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xae\xae\xae\xae\xae\xae\xae'
'\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xae\xae\x8ec\x8ec\xaf\xae\xae\xae\xae\xaf\xae\xaf\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\x8ec\xae\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xaf\xaf\xae\xae\xaf\xae\xaf\xae\xae\xaf\xae\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae'
'\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xae\xaf\xaf\xae\xae\xaf\xaf\xae\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf'
'\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xae\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xae\xae\xae\xae\xaf\xaf\xaf\xae\xae\xae\xae\xaf\xae\xae\xae\xaf\xaf\xaf\xaf\xaf\xae\xaf\xae\xae'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae\xae'
'\xae\xae\xae\xae\xae\xc1\xc1\xae\xae\xae\xae\xae\xae\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xbe\xbe\xbe\xbe\xbe\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'///////////////////////////////////////////////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10/\x16///\x16\x16/\x16/\x16/\x16////\x16/\x16\x16/\x16\x16\x16\x16\x16\x16\x16\x1e//'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\xc1\xc1\xc1\xc1\xc1\xc1/\x16/\x16666\x10\x10\x10\x10\x10\x10\x10\x83\x83\x83\x83P\x83\x83'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x1d|\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x106'
'(((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((\x10(((((((\x10(((((((\x10(((((((\x10'
'(((((((\x10(((((((\x10(((((((\x10(((((((\x1066666666666666666666666666666666'
'\x83\x83mimi\x83\x83\x83mi\x83mi\x83\x83\x83\x83\x83\x83\x83\x83\x83]\x83\x83]\x83mi\x83\x83mi\x8ec\x8ec\x8ec\x8ec\x83\x83\x83\x83\x83!\x83\x83\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10'
'\xc7\x87\x87\x87\xc3\x1f)D\x91f\x91f\x91f\x91f\x91f\xc3\xc3\x91f\x91f\x91f\x91f^\x90ee\xc3DDDDDDDDD777777^\x1f\x1f\x1f\x1f\x1f\xc3\xc3DDD\x1f)\x87\xc3\xc1'
'\x10)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))\x10\x1077\x9f\x9f\x1f\x1f)^)))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))\x87\x1f\x1f\x1f)'
'\x10\x10\x10\x10\x10)))))))))))))))))))))))))))))))))))))))))\x10\x10\x10)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))\x10\xbd\xbdMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd)))))))))))))))))))))))))))\x10\x10\x10\x10\x10'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10))))))))))))))))'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\x10MMMMMMMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xc3RRRRRRRRRRRRRRR\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xbd'
'MMMMMMMMMM\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbdRRRRRRRRRRRRRRR'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xc3\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xc3\xc3\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3\xc3\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc3'
')))))*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))*))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'*))*)))*)*))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))'
'))))))))))))*)))))))*)*))))))))))))))))))))))))))))))))))))))))*'
'*))))))))))))))))))))))))))))))*))))))))*)))))))))))))))))))))))'
')))))))))))))*))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))*))))))))))))))))))))))))))))))))))*)*)*))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')*)***))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')****)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))))))*)))))))*))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))**'
'))))))))))))***)*)))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))'
'))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*)'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))*))))*))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))'
'))))))*)))))*)))))))))))))))))))))))))))))))))))))))))))*)))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
')))))))))))))))))))))\x1f))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))\x10\x10\x10\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x10\x10\x10\x10\x10\x10\x10\x10\x10((((((((((((((((((((((((((((((((((((((((\x1d\x1d\x1d\x1d\x1d\x1d||'
'((((((((((((\x1d\x83\x83\x83((((((((((((((((<<<<<<<<<<((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16(6222\x83\x10\x10\x10\x10\x10\x10\x10\x1066\x83"'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((((((((((AAAAAAAAAA66||||||\x10\x10\x10\x10\x10\x10\x10\x10'
'\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d"""""""""\x9d\x9d/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x16\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16'
'/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16/\x16\x1e\x16\x16\x16\x16\x16\x16\x16\x16/\x16/\x16//\x16'
'/\x16/\x16/\x16/\x16"\x9a\x9a/\x16/\x16\x10/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10/\x16/\x16/\x16/\x16/\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x16((((('
'((6(((6((((6(((((((((((((((((((((((11661\xc1\xc1\xc1\xc1\x10\x10\x10\x10KKKKKK\xbc\xbc\x96\xb7\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((((((\x83\x83\x83\x83\x10\x10\x10\x10\x10\x10\x10\x10'
'11((((((((((((((((((((((((((((((((((((((((((((((((((111111111111'
'11116\x10\x10\x10\x10\x10\x10\x10\x10\x10||<<<<<<<<<<\x10\x10\x10\x10\x10\x10666666666666666666((((((|||(\x10\x10\x10\x10'
'<<<<<<<<<<((((((((((((((((((((((((((((66666666||(((((((((((((((('
'(((((((6666666666611\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10|)))))))))))))))))))))))))))))\x10\x10\x10'
'6661(((((((((((((((((((((((((((((((((((((((((((((((6116666116111'
'1|||||||||||||\x10\x1d<<<<<<<<<<\x10\x10\x10\x10||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((66666611661166\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((6((((((((61\x10\x10<<<<<<<<<<\x10\x10||||((((((((((((((((\x1d((((((\xbc\xbc\xbc(1\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((((((((((((((((((((6(666((66(((((66'
'(6(\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10((\x1d||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10((((((\x10\x10((((((\x10\x10((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((\x10(((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((11611611|16\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10))))))))))))))))'
')))))))\x10\x10\x10\x10)))))))))))))))))))))))))))))))))))))))))))))))))\x10\x10\x10\x10'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))*)))))))*))))*)))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))*)))))))))))))'
')))))))))))))))))*)*)))))))))))))))))))))))))))))))))))))))))*))'
'))))))))))))))))))))))))))))))))))))))))))))))\x11\x11))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))\x11\x11))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x16\x16\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x16\x16\x16\x16\x16\x10\x10\x10\x10\x10+6++++++++++\xa3+++++++++++++\x10+++++\x10+\x10'
'++\x10++\x10++++++++++%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99'
'\x99\x99\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$$$$$$%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x8db'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%\x10\x10%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10%%%%%%%%%%$$\x92\xc1\x10\x10'
'4444444444444444\x87\x87\x87\x88\x87\x87\x87\x90e\x87\x10\x10\x10\x10\x10\x106666666\x10\x10\x10\x10\x10\x10\x10\x10\x10\x87^^XX\x90e\x90e\x90e\x90e\x90e\x90'
'e\x90e\x90e\x87\x87\x90e\x87\x87\x87\x87XXXu\x87v\x10\x87v\x87\x87^\x91f\x91f\x91f{\x87\x87\xa5[\xb4\xb4\xb3\x10\x87\x98{\x87\x10\x10\x10\x10$%$%$\x10$%$%$%$%$%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x10\x10\x07'
'\x10\x80\x80x\x94x\x80\x81\x8b`\x80\xa2pYqp9999999999q\x80\xac\xab\xac\x80\x80..........................\x8b\x80`\x9cU'
'\x9c\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8b\xab`\xab\x8b`\x82\x8ca\x82\x82&&&&&&&&&&\x1b&&&&&&&&&&&&&&&'
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\x1a\x1a&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\x10'
'\x10\x10&&&&&&\x10\x10&&&&&&\x10\x10&&&&&&\x10\x10&&&\x10\x10\x10\x94\x94\xab\x9c\xbf\x94\x94\x10\xc0\xad\xad\xad\xad\xc0\xc0\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x0b\x0b\x0b\xc1\xbe\x10\x10'
'((((((((((((\x10((((((((((((((((((((((((((\x10(((((((((((((((((((\x10((\x10('
'((((((((((((((\x10\x10((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10'
'|\x83\xbc\x10\x10\x10\x10KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEPPPP\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1P\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc6\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((\x10\x10\x10(((((((((((((((((((((((((((((((('
'(((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((\x10KKKK\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10(((((((((((((((('
'(A((((((((A\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'((((((((((((((((((((((((((((((\x10|(((((((((((((((((((((((((((((((('
'((((\x10\x10\x10\x10((((((((|AAAAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'////////////////////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16(((((((((((((((((((((((((((((((((((((((((((((((('
'((((((((((((((((((((((((((((((\x10\x10<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++\x10\x10+\x10++++++++++++++++++++++++++++++++++++++++++++\x10++\x10\x10\x10+\x10\x10+'
'++++++++++++++++++++++\x10\x89SSSSSSSS\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++SSSSSS\x10\x10\x10\x83++++++++++++++++++++++++++\x10\x10\x10\x10\x10\x89'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'+666\x1066\x10\x10\x10\x10\x106666++++\x10+++\x10+++++++++++++++++++++++++++\x10\x10\x10\x10666\x10\x10\x10\x106'
'TTTTSSSS\x10\x10\x10\x10\x10\x10\x10\x10\x89\x89\x89\x89\x89\x89\x89\x89\x89\x10\x10\x10\x10\x10\x10\x10+++++++++++++++++++++++++++++SS\x89'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x10\x10\x10\x83\x83\x83\x83\x83\x83\x83'
'++++++++++++++++++++++\x10\x10SSSSSSSS+++++++++++++++++++\x10\x10\x10\x10\x10SSSSSSSS'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10GGGGGGGGGFFFFFFFFFFFFFFFFFFFFFF\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'161(((((((((((((((((((((((((((((((((((((((((((((((((((((66666666'
'6666666|||||||\x10\x10\x10\x10QQQQQQQQQPPPPPPPPPPP<<<<<<<<<<\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'661(((((((((((((((((((((((((((((((((((((((((((((11166661166||\x08||'
'||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((('
'(((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA@@AAAAAAAAAAAA'
'AAAAAAAAAAAAAAAAAAAAAA@@AAAAAAAAAAA\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10||||\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'(((((((((((((((((((((((((((((((((((((((((((((((((((((((((\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'))\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc11666\xbc\xbc\xbc111111\x07\x07\x07\x07\x07\x07\x07\x0766666'
'666\xbc\xbc6666666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc6666\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1666\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10KKKKKKKKKKKKKKKKKK\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////'
'//////////////\x16\x16\x16\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////////////'
'//\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16/\x10//\x10\x10/\x10\x10//\x10\x10////\x10////////\x16\x16\x16\x16\x10\x16\x10\x16\x16\x16'
'\x16\x16\x16\x16\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16//\x10////\x10\x10////////\x10///////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//\x10////\x10'
'/////\x10/\x10\x10\x10///////\x10\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////////'
'//////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16//////////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////'
'//////////////////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16////////////////'
'//////////\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x10\x10////////////////////////'
'/\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/////////////////////////\xa8\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\xaf\x16\x16\x16\x16\x16\x16/\x16\x10\x10::::::::::::::::::::::::::::::::::::::::::::::::::'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'IIIIIIIIIII\x10\x10\x10\x10\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xbc\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\x10\x10\x10\x10\x10\x10\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbd\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10\x10\x10\x10\x10'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\xbd\xbd\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10'
'\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xbc\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1'
'\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\x10\xc1\x10\xc1\x10\xc1\x10\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\xc1\xc1\xc1\xc1\x10\xc1\x10\x10\xc1\xc1\xc1\xc1\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\x10\x10\x10\x10\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
')*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))*)))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))*))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*)))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))*))))))))*)))))))))))))))*)))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))*))))))))))))))))))*))'
')))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))*)))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))*)))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))*))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))))))))))))))))))))))))*))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
')))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
')))))))))))))))))))))))))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))'
'))))))))))))))))))))))))))))))\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x10\x10'
'\x10\x07\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07\x07'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'4444444444444444444444444444444444444444444444444444444444444444'
'4444444444444444444444444444444444444444444444444444444444444444'
'4444444444444444444444444444444444444444444444444444444444444444'
'444444444444444444444444444444444444444444444444\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x10\x10'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
613: 42893,
1319: 1318,
42593: 42592,
42897: 42896,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_toupper_corrected = {
}
_tolower = {
1318: 1319,
42592: 42593,
42893: 613,
42896: 42897,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
}

_tolower_corrected = {
}
_totitle = {
613: 42893,
1319: 1318,
42593: 42592,
42897: 42896,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
}

_canon_decomposition = {
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
418,
419,
3294,
3741,
3743,
3747,
3749,
4048,
40981,
65048,
118981,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2137: 220,
2138: 220,
2139: 220,
4957: 230,
4958: 230,
7142: 7,
7154: 9,
7155: 9,
7676: 233,
11647: 9,
69702: 9,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

