# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=12.1.0 --output=unicodedb_12_1_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '12.1.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x05 AND '
'\n AND ARROW'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\x0b AND WRENCH'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\r BAT AND BALL'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x07 BUBBLE'
'\x07 BUTTON'
'\r BUTTON MOUSE'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\n CHARACTER'
'\x05 CHWV'
'\x07 CIRCLE'
'\x05 COAT'
'\n CONJOINED'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\x02 E'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x08 FACING '
'\x06 FINAL'
'\x13 FLUTTERING IN WIND'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x05 GUNU'
'\t HITTING '
'\x05 HOOK'
'\x08 HUNDRED'
'\x05 ICON'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x04 KEY'
'\x02 L'
'\x06 LARGE'
'\t LEERAEWA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x13 LOVE YOU HAND SIGN'
'\x08 MACHINE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x08 MAKSURA'
'\x05 MARK'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\t OF BLOOD'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\t OF PAPER'
'\r OF THE HORNS'
'\x08 OF YARN'
'\x05 OPEN'
'\x07 OPEN-O'
'\x04 ORE'
'\x04 OUT'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x11 OVER MUSH TIMES '
'\x16 OVER STAMPED ENVELOPE'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x06 PLUS '
'\x0c PLUS KASKAL'
'\x12 PLUS PAP PLUS LU3'
'\x07 PLUS U'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\t RICKSHAW'
'\x0c RING LITTLE'
'\t ROTATED '
'\x17 ROTATED NINETY DEGREES'
'\x02 S'
'\x08 SATCHEL'
'\x07 SECANT'
'\n SEPARATOR'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x05 TABS'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES KUR'
'\x0b TIMES TAK4'
'\x07 TO BAR'
'\x05 TONE'
'\x0f TOUCHING INDEX'
'\x05 TREE'
'\x02 U'
'\x04 U U'
'\x04 WEB'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x12 WITH CROSSED-TAIL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\n WITH DOTS'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x0b WITH FLASH'
'\x0e WITH FLOURISH'
'\x17 WITH HALF-CIRCLE BELOW'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\x12 WITH KAVYKA ABOVE'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\x0e WITH ORNAMENT'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\n WITH RING'
'\x11 WITH SOUND WAVES'
'\x0b WITH STRAW'
'\x0c WITH STROKE'
'\x12 WITH VERTICAL BAR'
'\x19 WITH VERTICAL LINE BELOW'
'\x13 WITH VERTICAL TAIL'
'\x0b WITHIN DOT'
'\x0b WRIST FLEX'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\x02-A'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x08-HEADED '
'\t-LOW TONE'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x07-MU-MO-'
'\x0f-NO-EVIL MONKEY'
'\x0b-OFF SYMBOL'
'\x0f-PIECE SWIMSUIT'
'\n-POINTING '
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x07-THIRTY'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x050 DOO'
'\x030 E'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\t0 LONG LE'
'\x060 NGGI'
'\x060 NGGO'
'\x060 NYON'
'\x060 NYUN'
'\x040 PU'
'\x040 SA'
'\x030 W'
'\x040 YE'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0208'
'\x011'
'\x031 A'
'\x041 BA'
'\x041 DO'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x041 HA'
'\x041 IN'
'\x041 KI'
'\n1 LONG MBE'
'\x061 NDEE'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 RA'
'\x041 SU'
'\x051 TEE'
'\x041 VU'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-2'
'\x051-VAS'
'\x0217'
'\x0218'
'\x012'
'\x022 '
'\x032 B'
'\x042 BU'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x052 POO'
'\x052 SEE'
'\x042 TI'
'\x082 TIMES '
'\t2 TIMES A'
'\x102 TIMES IGI GUNU'
'\n2 TIMES UD'
'\x042 VI'
'\x032 Y'
'\x042 YA'
'\x052-VAS'
'\x0320B'
'\x0222'
'\x0224'
'\x0726 EYYY'
'\x03272'
'\x013'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 TA'
'\n3 TIMES ZA'
'\x053 VEE'
'\x053 WEI'
'\x043 YU'
'\x053-VAS'
'\x0230'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0236'
'\x0238'
'\x014'
'\x034 A'
'\x054 ABB'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x054-VAS'
'\x03408'
'\x0242'
'\x0248'
'\x0249'
'\x015'
'\x045 AN'
'\x045 BB'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x055 NDU'
'\x075 NGGEE'
'\x045 OO'
'\x045 TE'
'\x175 TIMES THREE DISH TENU'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WO'
'\x055-VAS'
'\x03533'
'\x03550'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 WEE'
'\x046 WU'
'\x056-VAS'
'\x0262'
'\x0264'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x057 JEE'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 VO'
'\x057-VAS'
'\x0270'
'\x0271'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x048 BO'
'\x048 DU'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x048 JI'
'\x038 K'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x019'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 SI'
'\x049 SO'
'\x049 TO'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x04914D'
'\x0292'
'\x03981'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A MFON'
'\x0bA TENU GUNU'
'\x05A YUE'
'\x02A-'
'\x06A-KARA'
'\x02A4'
'\x07A6 TENU'
'\x02A7'
'\x03A7A'
'\x02AA'
'\x04AACU'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\tAAZHAAKKU'
'\x02AB'
'\x03AB2'
'\x03ABA'
'\nABATA TREE'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x05ABOVE'
'\x03AC '
'\rACCOMMODATION'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x04ADA '
'\x05ADULT'
'\x02AE'
'\x03AEA'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\tAF PERSON'
'\x04AFEL'
'\x0eAFETY SCISSORS'
'\tAFFE FACE'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x03AG '
'\x04AGE '
'\x05AGGER'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x02AH'
'\x16AH WITH TWO DOTS ABOVE'
'\x02AI'
'\x03AIN'
'\x04AIN '
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\x1fAISED HAND WITH FINGERS SPLAYED'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x02AJ'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x0cAK4 PLUS SAG'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x08AKHA YAT'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x05ALEPH'
'\x05ALETH'
'\x04ALF '
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x04ALL '
'\x05ALLOT'
'\x03ALO'
'\x05ALPHA'
'\x0cALT PAN SIGN'
'\x08ALTERNAT'
'\nALTERNATE '
'\x13ALTERNATE LAKH MARK'
'\x11ALTERNATE NUMBER '
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x06ALTIRE'
'\x02AM'
'\x12AM WITH DOUBLE BAR'
'\x04AMBA'
'\tAME WITH '
'\x05AMEDH'
'\x03AMI'
'\x04AMMA'
'\rAMMA WITH DOT'
'\x06AMOND '
'\x06AMPIRE'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\rAN RUPEE SIGN'
'\x04AN X'
'\x03ANA'
'\x10ANABAZAR SQUARE '
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x11AND BLACK SQUARES'
'\x0eAND COLD SWEAT'
'\x12AND LOW RIGHT RING'
'\x0cAND ODD SIGN'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\nANDHI MARK'
'\nANDRABINDU'
'\x03ANG'
'\x05ANGEL'
'\x0cANGER BUBBLE'
'\tANGGEUAET'
'\x05ANGKA'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x06ANIMAL'
'\x05ANNON'
'\x0fANS-SERIF ARROW'
'\tANTAYALAN'
'\x19ANTED NORTH ARROW WITH HO'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x0eANUSVARA ABOVE'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APH'
'\x14APITAL H WITH STROKE'
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x0bAR A SIGN A'
'\x04ARAE'
'\x04ARAM'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDSMAN'
'\x03ARE'
'\x03ARF'
'\nARFUL FACE'
'\x03ARK'
'\x03ARL'
'\x03ARM'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\rARRED TRIDENT'
'\x08ARRIVING'
'\x05ARROW'
'\x12ARROW SHAFT WIDTH '
'\x0bARROW WITH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x05ARTAR'
'\x17ARTY HORN AND PARTY HAT'
'\x04ARUM'
'\x04ARY '
'\x02AS'
'\x05ASAL '
'\x10ASALIZATION MARK'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASH'
'\x17ASHTRA SIGN CANDRABINDU'
'\x05ASKAL'
'\nASPIRATION'
'\x03ASS'
'\x0bASS OF MILK'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATEBOARD'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\x03ATI'
'\x08ATIKRAMA'
'\x05ATIN '
'\nATIN CROSS'
'\x12ATIN SMALL LETTER '
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x03AUJ'
'\x03AUM'
'\x03AUS'
'\nAUTOMOBILE'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x05AWAY '
'\x0bAWNING FACE'
'\x02AY'
'\x08AY-NIGHT'
'\x03AYD'
'\nAYER BEADS'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\x0bB TIMES SHE'
'\x02BA'
'\x19BA ROTATED NINETY DEGREES'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x05BACUS'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x06BAHAR2'
'\x03BAL'
'\x04BALD'
'\x04BALL'
'\rBALL AND HOOP'
'\rBALLPOINT PEN'
'\x03BAN'
'\x03BAR'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\rBASAN LETTER '
'\x08BATAEAN '
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\rBEGIN SEGMENT'
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x04BELT'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x08BER POLE'
'\x07BERGINE'
'\x03BET'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBIAL SIGN'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x05BINDU'
'\x0bBINDU BELOW'
'\tBING CANE'
'\x07BINING '
'\x08BINOVILE'
'\x0bBIRGA WITH '
'\x06BISCUS'
'\x06BISHOP'
'\x0fBISHOP ROTATED '
'\tBITE LIPS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x06BLACK '
'\x0cBLACK CIRCLE'
'\x19BLACK CIRCLED WHITE ARROW'
'\nBLACK FLAG'
'\rBLACK OCTAGON'
'\x0eBLACK PENTAGON'
'\rBLACK SQUARES'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\nBLOND HAIR'
'\x04BLOW'
'\x0cBLOWING FACE'
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x11BOLD WHITE CIRCLE'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x07BOTTOM '
'\x15BOTTOM U-SHAPED ARROW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x08BRA FACE'
'\x0cBRATION MODE'
'\x19BREVE WITH INVERTED BREVE'
'\x11BREW YOD TRIANGLE'
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x12BSERVER EYE SYMBOL'
'\x03BSP'
'\x05BSTER'
'\x02BU'
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C CLEF'
'\x06C SIGN'
'\x08C SIYAQ '
'\x02CA'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x03CAI'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x0cCANDRA ABOVE'
'\x0bCANDRABINDU'
'\x11CANDRABINDU ABOVE'
'\x04CANO'
'\x04CAP '
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x12CAPITAL LETTER YOT'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARON'
'\x04CASE'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x05CCOLI'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x0eCERTAINTY SIGN'
'\x06CEVITU'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\tCHANICAL '
'\x14CHARACTER INTRODUCER'
'\x0cCHARACTER-1B'
'\x05CHART'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x06CHESS '
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHILLU '
'\x05CHIME'
'\x08CHINESE '
'\x0bCHING CHICK'
'\nCHING HAND'
'\x03CHO'
'\x04CHO '
'\x05CHOOI'
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\x03CHU'
'\x05CHUTE'
'\x04CIM '
'\x06CIRCLE'
'\x12CIRCLE NUKTA ABOVE'
'\x0fCIRCLE WITH DOT'
'\x08CIRCLED '
'\nCIRCLED CA'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x11CIRCLES WITH DOTS'
'\x0fCIRCUMFLEX AND '
'\rCITATION MARK'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x1dCKED FACE WITH EXPLODING HEAD'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x03CKS'
'\x05CKTIE'
'\x02CL'
'\x07CLEAVER'
'\x08CLIMBING'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x17CLUSTER-INITIAL LETTER '
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLATE BAR'
'\nCOLD SWEAT'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\nCOMPONENT '
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x16CONSONANT MODIFIER BAR'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x16CONSONANT SIGN MEDIAL '
'\x18CONSONANT SIGN PASANGAN '
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x04COON'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x10CREAMING IN FEAR'
'\x0bCREDIT SIGN'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\x05CROSS'
'\x06CROSS '
'\nCROSS MARK'
'\x15CROSSE STICK AND BALL'
'\x07CROSSED'
'\tCROSSED O'
'\x0cCROSSED-TAIL'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x08CURLICUE'
'\x06CURLY '
'\nCURLY HAIR'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\nCY MESSAGE'
'\x04CYCL'
'\x01D'
'\x02D '
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x0bD MIDDLE UP'
'\x16D PLUS GISH TIMES TAK4'
'\x06D SIGN'
'\x08D SYMBOL'
'\x11D TIMES DISH TENU'
'\x0cD TIMES ESH2'
'\x0eD-UP NEWSPAPER'
'\x02DA'
'\x07DA FACE'
'\nDA SATANGA'
'\nDA2 TIMES '
'\x03DAA'
'\x03DAD'
'\x03DAH'
'\x05DAIC '
'\x19DAL WITH THREE DOTS BELOW'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x05DARA3'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDHI'
'\x05DDING'
'\x08DDY BEAR'
'\x02DE'
'\x06DE DOG'
'\x18DE INVERTED BRIDGE BELOW'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\nDECORATION'
'\nDED PERSON'
'\x03DEN'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\nDEOGRAPH A'
'\x16DEOGRAPHIC TALLY MARK '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\x03DES'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x06DGEHOG'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\tDIAERESIS'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\rDIC MARK SIGN'
'\x06DIGIT '
'\x08DIM GUNU'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x04DIUM'
'\x05DLING'
'\x03DNA'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x08DOT REPH'
'\x10DOTTED CRESCENTS'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\x1cDOUBLE ANUSVARA ANTARGOMUKHA'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\x13DOUBLE MIDDLE TILDE'
'\x0fDOUBLE ORNAMENT'
'\x0bDOUBLE RING'
'\x11DOUBLE RING ABOVE'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE-LINED HEAD MARK'
'\x04DOWN'
'\x05DOWN '
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\x18DOWNSCALING FACTOR KIIZH'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x02DR'
'\x04DRAM'
'\tDRAM SIGN'
'\x05DRINK'
'\x14DRY CULTIVATION SIGN'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x0cDUG TIMES NI'
'\x0eDUN3 GUNU GUNU'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\x05DWICH'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x14E CONSONANT MODIFIER'
'\x07E DRINK'
'\x07E GLASS'
'\x06E HOOK'
'\x11E LIGHT MOON ARTA'
'\x05E OF '
'\x08E OF POO'
'\x07E WITH '
'\x0cE WITH GRAVE'
'\x0bE WITH VEIL'
'\x02E-'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x03EAD'
'\x07EAD ORE'
'\x04EANS'
'\x0bEARS OF JOY'
'\x04EART'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x05EATH '
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x08ED BRICK'
'\x06ED CAP'
'\x07ED FACE'
'\x08ED FLAGS'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\tED PLANET'
'\x07ED RICE'
'\tED SYMBOL'
'\x0eED SYMBOL FOR '
'\nEDESTRIANS'
'\x05EDIC '
'\rEDIC ANUSVARA'
'\x0bEDICAL MASK'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x03EEM'
'\x04EEM '
'\x19EEM WITH THREE DOTS ABOVE'
'\x03EEN'
'\x06EENTH-'
'\x06EENTHS'
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x02EF'
'\tEFAIDRIN '
'\tEFORMED T'
'\x15EFT HORIZONTAL SECANT'
'\x1bEFT POINTING BACKHAND INDEX'
'\x14EFTWARDS ARROW WITH '
'\x02EH'
'\x08EH WITH '
'\x17EH WITH SMALL TEH ABOVE'
'\x02EI'
'\x05EIDON'
'\x05EIGHT'
'\x06EIGHT '
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x03EIN'
'\x04EIPT'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x08ELEPHANT'
'\x0cELETION MARK'
'\x03ELI'
'\x0bELLOW HEART'
'\x0bELTIC CROSS'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x05EMLJA'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x0bEN STRAIGHT'
'\x0bEN THOUSAND'
'\x0bEN TWELFTHS'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x0bEND SEGMENT'
'\x05ENDAR'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x06ENNANT'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\nENTRY SIGN'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x08ENVELOPE'
'\x05EOPLE'
'\x08EOUT BOX'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x03EPH'
'\x04EPHA'
'\x1cEPIGRAPHIC LETTER SIDEWAYS I'
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\nEQUIHOPPER'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x03ERA'
'\x0eERA NAME REIWA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04EREN'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x03ERT'
'\x03ERU'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\rESH2 ASTERISK'
'\rESH2 PLUS LAL'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x08ET SHOES'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x04ETOS'
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVAL COMMA'
'\x04EVEN'
'\x08EVEN OF '
'\rEVEN TWELFTHS'
'\x13EVEN U VARIANT FORM'
'\x08EVENTEEN'
'\x06EVENTY'
'\x0cEVERING FACE'
'\x0eEVERSED OPEN E'
'\x0bEVERSED TSE'
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0eEXCLAMATION OH'
'\x0bEXED BICEPS'
'\x06EXHALE'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EYK'
'\nEZING FACE'
'\x01F'
'\x02F '
'\x10F WITH DOT BELOW'
'\rF WITH STROKE'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x04FAST'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FETH'
'\x05FETY '
'\x04FEUQ'
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\x04FFLE'
'\x02FI'
'\x05FIER '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\x14FINAL CONSONANT MARK'
'\x15FINAL CONSONANT SIGN '
'\rFINAL LETTER '
'\tFINAL NUN'
'\x08FINGER C'
'\x1bFINGER COVERING CLOSED LIPS'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAME'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\nFLUTTERING'
'\x03FLY'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x04FOR '
'\x08FOR STOP'
'\nFORMATION '
'\x06FORMEE'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x12FORTY-FIVE DEGREES'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\tFOUR BENT'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\tFRACTION '
'\rFRACTION ONE '
'\x11FRACTION ONE HALF'
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x13FT-POINTING FLEURON'
'\x05FTEEN'
'\x03FTY'
'\x02FU'
'\x03FUE'
'\tFULL STOP'
'\x01G'
'\x06G FACE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02GA'
'\x03GAA'
'\nGAB TIMES '
'\x18GAF WITH INVERTED STROKE'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x05GALI '
'\x04GAME'
'\tGAN2 TENU'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x05GAROO'
'\x07GATIVE '
'\x05GAZE-'
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x06GDIAN '
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GEMINAT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x07GENERAL'
'\x03GER'
'\x05GGER '
'\nGGING FACE'
'\x05GGLES'
'\x0fGGLY LINE BELOW'
'\x12GGLY VERTICAL LINE'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x02GI'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\rGIFT ENVELOPE'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x07GRADUAL'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x0cGRAPHUS MARK'
'\x06GRASP '
'\x05GRAVE'
'\x0bGREEK CROSS'
'\x06GREEN '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x0eGUL JONGSEONG '
'\x05GULUS'
'\x0eGUNU TIMES ASH'
'\rGUNU TIMES HA'
'\x05GVANG'
'\x02GY'
'\x04GYAN'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\tHA PLUS A'
'\x03HAA'
'\x03HAB'
'\x05HADDA'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x07HAJANI '
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x04HALA'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x14HALF CIRCLE WITH DOT'
'\x08HALF GUR'
'\tHALF NOTE'
'\x05HALF-'
'\x05HALQA'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAND'
'\x13HAND COVERING MOUTH'
'\x0cHAND FORMAT '
'\tHAND SIGN'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x0bHAR2 TIMES '
'\x08HARBAHAY'
'\tHARD SIGN'
'\x06HARIOT'
'\x03HAT'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x02HD'
'\x02HE'
'\x03HEA'
'\tHEAD MARK'
'\x1bHEAD MARK WITH MOON AND SUN'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\tHEADSCARF'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x0bHEATED FACE'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\nHEMATICAL '
'\x04HENG'
'\rHER CHRISTMAS'
'\nHERMOMETER'
'\x04HERO'
'\x04HERU'
'\x0eHESIVE BANDAGE'
'\x05HESS '
'\x04HETH'
'\x05HEUAE'
'\x06HEUAEP'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHI TIMES ASH2'
'\x0cHIBITED SIGN'
'\rHIEROGLYPHIC '
'\x06HIEUKH'
'\x04HIGH'
'\x05HIGH '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x03HII'
'\x12HILOSOPHERS SULFUR'
'\x05HIMEL'
'\x03HIN'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x07HIRTEEN'
'\x05HIRTY'
'\x08HITTING '
'\x07HIUCHUS'
'\x06HIVETE'
'\x04HMI '
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x05HOLUS'
'\x03HOM'
'\x04HOM '
'\x04HOOK'
'\x05HOOK '
'\tHOOK MARK'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x11HORIZONTAL JOINER'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x05HORSE'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\x05HOTEL'
'\x08HOULDER '
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x06HREE D'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0cHREE FINGERS'
'\x1cHREE HUNDRED FIFTEEN DEGREES'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x14HREE-DOT NUKTA ABOVE'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x04HUB2'
'\x04HUET'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\tHWA WITH '
'\x04HWAH'
'\x02HY'
'\x06HYPHEN'
'\x01I'
'\x0eI AND SKI BOOT'
'\x06I GUNU'
'\x06I HOOK'
'\x07I NTEUM'
'\nI PLUS ZA7'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x1dI TIMES ASH OVER HI TIMES ASH'
'\x0cI TIMES TAK4'
'\x07I WITH '
'\x02I-'
'\x05I-RES'
'\x02I2'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\tIAL LINE '
'\x07IAMOND '
'\x18IAMOND CONTAINING BLACK '
'\x05IARDS'
'\x06IB YAM'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x05ICKET'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x03IDE'
'\x03IDO'
'\x0bIDUOUS TREE'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IETH'
'\rIFI ROHINGYA '
'\x06IFTEEN'
'\x04IFTH'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\nIGATING RA'
'\x13IGATURE AYIN-DALETH'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x12IGATURE ZAYIN-YODH'
'\x06IGGLES'
'\x04IGHT'
'\nIGHT ANGLE'
'\nIGHT RULER'
'\rIGHT TWELFTHS'
'\x13IGHT U VARIANT FORM'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x07IGHTEEN'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x12IGSAW PUZZLE PIECE'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\x02IM'
'\x07IM GUNU'
'\nIMALUNGUN '
'\x04IMEL'
'\x05IMGBA'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\x12IN POSSESSION SIGN'
'\x18IN WITH THREE DOTS BELOW'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x10INDEPENDENT SHIN'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x0eINDICTION SIGN'
'\x03INE'
'\x08INFINITY'
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\nING LITTLE'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x0cING ROTATED '
'\x13ING SHIRT WITH SASH'
'\tING STONE'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x06INHALE'
'\x08INITIAL '
'\x11INITIAL LETTER RA'
'\x05INNA '
'\x07INNABAR'
'\tINNYIIYHE'
'\x0eINOLOGICAL DOT'
'\nINSERT AT '
'\x0eINSERTION SIGN'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x0cINVERTEBRATE'
'\x08INVERTED'
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x04INY '
'\x03ION'
'\x08ION MARK'
'\x02IP'
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x02IR'
'\x03IR2'
'\x05IRACY'
'\x05IRAMA'
'\x05IRCLE'
'#IRCLE CONTAINING BLACK SMALL CIRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x0eIRCULAR VIRAMA'
'\x05IRCUT'
'\x04IRON'
'\x08IRPLANE '
'\x06IRTEEN'
'\x04IRTY'
'\x0bIRTY-SECOND'
'\x03IRY'
'\x02IS'
'\x03ISA'
'\x03ISH'
'\rISH LIRA SIGN'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x0eISSION TICKETS'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITALIC LETTER '
'\x0bITARY MEDAL'
'\x04ITE '
'\x0eITERATION MARK'
'\x16ITHI NUMBER SIGN ABOVE'
'\x03ITO'
'\x07ITTING '
'\x03IVE'
'\x04IVE '
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x12IVE U VARIANT FORM'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x11IX U VARIANT FORM'
'\x06IXTEEN'
'\x04IXTY'
'\x06IXTY P'
'\rIYA FRACTION '
'\x04IYAQ'
'\x05IYEOK'
'\x03IYO'
'\x0fIZED WHEELCHAIR'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x1aJ WITH DOT ABOVE AND TILDE'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x05JERVI'
'\x03JHA'
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x06JOINER'
'\x05JUDUL'
'\x01K'
'\x02K '
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x15K WITH OBLIQUE STROKE'
'\x02K-'
'\x05K-020'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x08KAIYARAA'
'\x03KAK'
'\x04KAKO'
'\x04KALI'
'\x03KAM'
'\x04KAPH'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x05KAROR'
'\x06KASAR '
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x03KAU'
'\x06KAVYKA'
'\rKAVYKA ABOVE '
'\x05KBALL'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\tKEN HEART'
'\x05KESH2'
'\x03KET'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x06KHINYA'
'\x05KHMU '
'\x02KI'
'\x06KILLER'
'\nKINDI MVOP'
'\tKING BOOT'
'\tKING FACE'
'\x04KINI'
'\x19KISIM5 TIMES U2 PLUS MASH'
'\x04KISS'
'\x07KKURUNI'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x03KOI'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x0bKTAIL GLASS'
'\x05KTOP '
'\x03KU3'
'\x03KUE'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x12KUSHU2 PLUS KASKAL'
'\x05KWAEN'
'\x06KY WAY'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL OF THREAD'
'\x07L WITH '
'\x10L WITH DESCENDER'
'\x1aL WITH DOUBLE MIDDLE TILDE'
'\x02LA'
'\x04LAAM'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x18LACK CIRCLED WHITE ARROW'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x0bLACKLETTER '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x07LAK-050'
'\x04LAKH'
'\tLAKH MARK'
'\x03LAM'
'\x04LAM '
'\x04LAMA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\tLAND SIGN'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x03LAP'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x08LATION X'
'\x03LAU'
'\x03LAW'
'\x08LAYALAM '
'\x04LBOX'
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDER'
'\x02LE'
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x0cLEADING EYES'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x16LEFT-POINTING TRIANGLE'
'\x17LEFT-SHADED WHITE ARROW'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x03LEG'
'\x03LEI'
'\x08LEN LEAF'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x04LEPH'
'\x03LET'
'\x06LETTER'
'\x07LETTER '
'\x18LETTER CHA WITH TWO DOTS'
'\x0bLETTER LLLA'
'\x11LETTER MALAYALAM '
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x08LETTER S'
'\x1aLETTER SMALL CAPITAL OMEGA'
'\x08LETTER Y'
'\nLETTER ZHA'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x03LF '
'\rLF BLACK STAR'
'\x07LF FACE'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x04LIFI'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\x04LINE'
'\x05LINE '
'\x0bLINE FILLER'
'\x05LING '
'\x03LIP'
'\x04LIPS'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x03LLA'
'\tLLAR SIGN'
'\x07LLEYBUS'
'\x06LLHORN'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x03LLL'
'\x04LLLA'
'\x10LLOW PAN OF FOOD'
'\tLLY MARK '
'\x02LM'
'\x02LO'
'\x05LOAN '
'\x08LOCATION'
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x04LONG'
'\nLONG FINAL'
'\x0fLONG HOOK BELOW'
'\tLONG TIP '
'\nLONG TSHEG'
'\x0eLONG-LEGGED DE'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x07LOTTAL '
'\x0eLOTUS POSITION'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\nLOW KAVYKA'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x05LOWER'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x04LPHA'
'\x05LPHIN'
'\x17LSCHREIBER PAUSE SYMBOL'
'\x02LT'
'\tLT SHAKER'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x03LU3'
'\x03LUB'
'\x04LUE '
'\x07LUGGAGE'
'\x03LUM'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x01M'
'\x02M '
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x08M SYMBOL'
'\nM TIMES ME'
'\x07M WITH '
'\x0cM WITH TILDE'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x07MACRON '
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x06MADDAH'
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\rMALL CAPITAL '
'\x0eMALL CAPITAL I'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x08MALL YUS'
'\x03MAN'
'\x08MANDARIN'
'\x03MAQ'
'\rMAR TIMES KUG'
'\x04MARK'
'\x05MARK '
'\tMARK CIM '
'\tMARK SHAD'
'\x08MARRATAN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0bMBLER GLASS'
'\x16MBOL FOR MARKS CHAPTER'
'\x0bMBU LETTER '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x06ME DIE'
'\x04MED '
'\x0cMEDARY CAMEL'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x07MENIAN '
'\x05MENOE'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x0bMIC LETTER '
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x04MIIM'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\x08MILLIONS'
'\x04MILY'
'\rMINDER RIBBON'
'\x05MINGO'
'\x1eMINTON RACQUET AND SHUTTLECOCK'
'\nMINUS SIGN'
'\nMISMA SIGN'
'\x04MIZE'
'\x03MMA'
'\x02MO'
'\rMOBILE PHONES'
'\x1aMODIFIER FITZPATRICK TYPE-'
'"MODIFIER LETTER SHAN REDUPLICATION'
'\rMODIFIER MARK'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\x0bMOON SELENA'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x04MPET'
'\x06MPLING'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x18MTAVRULI CAPITAL LETTER '
'\x02MU'
'\x04MUAS'
'\x04MUCH'
'\x08MULTIPLE'
'\x11MUM LETTER PHASE-'
'\x04MUSH'
'\x08MY HOUSE'
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x11N PLUS KAK PLUS A'
'\x07N WITH '
'\x10N WITH LEFT HOOK'
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x0fNA DOUBLE HELIX'
'\tNA KHONNA'
'\x08NA METEK'
'\x03NAA'
'\x05NADA '
'\x04NAKE'
'\x03NAM'
'\x04NAM2'
'\x03NAR'
'\x08NARROW O'
'\x0cNARROW SHAFT'
'\x05NASHI'
'\x03NAU'
'\x04NBOW'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\tNCH FRIES'
'\x13NCTUS ELEVATUS MARK'
'\x02ND'
'\x0bND OF PIECE'
'\x15ND TELEPHONE RECEIVER'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\nNDINAGARI '
'\x0cNDING PERSON'
'\x13NDRED POINTS SYMBOL'
'\nNDU TEMPLE'
'\x02NE'
'\x11NE EYEBROW RAISED'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x04NED '
'\x08NED FOOD'
'\x0eNEELING PERSON'
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
'\x08NEIFORM '
'\x03NEL'
'\x04NEMA'
'\x05NENOE'
'\x03NET'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x03NEY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x0bNG LEFT LEG'
'\x14NG WITH CROSSED-TAIL'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\tNGER SHIP'
'\x05NGINE'
'\nNGLICANA W'
'\x04NGUE'
'\x05NGUE '
'\tNGUN SIGN'
'\x02NI'
'\x03NIE'
'\x05NIGHT'
'\tNIGHT OF '
'\x0bNIKOLSBURG '
'\x04NINE'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x13NINE U VARIANT FORM'
'\x08NINETEEN'
'\x06NINETY'
'\x0eNINETY DEGREES'
'\tNING MOOD'
'\rNING MOVEMENT'
'\x0bNITIAL IZHE'
'\x0cNJALA GONDI '
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x03NNI'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x0cNORTHERN TSE'
'\x04NOSE'
'\x0cNOTCHED HOOK'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x06NOVILE'
'\x04NOWC'
'\x08NOWLEDGE'
'\x08NRES TOS'
'\x04NRUA'
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\x07NSPLUTO'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x10NTAIGANA LETTER '
'\tNTESSENCE'
'\x05NTHA '
'\x0bNTIMONY ORE'
'\x05NTXIV'
'\x03NUB'
'\x05NUKTA'
'\x07NUMBER '
'\x11NUMBER MARK ABOVE'
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\rNUMERIC SIGN '
'\x03NUN'
'\x07NUSVARA'
'\x04NUTS'
'\x08NVERTED '
'\x03NYA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x02O '
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\x06O MARK'
'\x07O WITH '
'\x10O WITH DOT ABOVE'
'\x02O-'
'\x04O-YO'
'\x04OALA'
'\x03OAP'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x04OBRO'
'\x07OCALIC '
'\x08OCALIC M'
'\x08OCALIC R'
'\x07OCATION'
'\x03OCK'
'\x08OCK SALT'
'\x05OCKET'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x03ODA'
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\nOF HYGIEIA'
'\x07OF SOAP'
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x02OG'
'\x08OGOGRAM '
'\x0cOGOGRAM NYAJ'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x06OITIC '
'\x04OJI '
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\x0cOKING SYMBOL'
'\x02OL'
'\x03OLD'
'\x04OLD '
'\x05OLDER'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x05OLLON'
'\rOLVING HEARTS'
'\x02OM'
'\x14OM HALF BLACK CIRCLE'
'\x08OM NTEUM'
'\x0bOMAN SIYAQ '
'\x08OMANIAN '
'\x05OMBIE'
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x0eOMING ENVELOPE'
'\x04OMMA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x08ON CROSS'
'\x07ON FACE'
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0bONE HUNDRED'
'\x1fONE HUNDRED THIRTY-FIVE DEGREES'
'\x1bONE LARGE AND ONE SMALL EYE'
'\x10ONE QUARTER SIGN'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x04ONG '
'\tONG GRAVE'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x16ONJOINING MACRON BELOW'
'\x06ONOCLE'
'\x1aONOMICAL SYMBOL FOR URANUS'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x04ONUT'
'\x02OO'
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x02OP'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\tOPERATOR '
'\x03OPH'
'\x04OPOD'
'\x06OPPER '
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x05ORAIL'
'\x07ORANGE '
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x04ORD '
'\rORD SEPARATOR'
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nOROME SIGN'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x06OSING '
'\x05OSTER'
'\x02OT'
'\x08OT MBUAE'
'\x07OT NGOM'
'\tOTAL SIGN'
'\x07OTATED '
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x07OUBLE O'
'\x07OUBLE R'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x05OUR K'
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\x12OUR U VARIANT FORM'
'\x07OURTEEN'
'\x0bOUSEL HORSE'
'\x03OUT'
'\nOUT HANDLE'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\nOUTHERN TA'
'\x04OVAL'
'\x05OVER '
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\x16OVER NU11 BUR OVER BUR'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SHE'
'\x07OVERLAY'
'\x0eOVERLAY MIDDLE'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\nOWEL SIGN '
'\x03OWN'
'\rOWN POINTING '
'\x03OX '
'\x02OY'
'\x07OYSTICK'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x17P WITH EXCLAMATION MARK'
'\x02PA'
'\rPA NJI PIPAEM'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x05PALI '
'\x04PALM'
'\x03PAN'
'\x07PANESE '
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x0ePARATED SYMBOL'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\nPASSIMBANG'
'\x04PAWN'
'\rPAWN ROTATED '
'\x06PBOARD'
'\x02PE'
'\x0cPE CARTRIDGE'
'\x06PEAKS '
'\x04PEEI'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\x07PENNANT'
'\x0fPENSION RAILWAY'
'\tPENT SIGN'
'\tPENTAGRAM'
'\x06PEPPER'
'\x03PER'
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x06PERSON'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x04PHAB'
'\x05PHANT'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x06PICKET'
'\x07PICTURE'
'\x03PIN'
'\x04PING'
'\x05PING '
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x0bPLACEHOLDER'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\nPLE DAGGER'
'\tPLE HEART'
'\x08PLE LEAF'
'\x0ePLE WITH HEART'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x07PLOYAN '
'\x04PLUG'
'\x05PLUS '
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\nPPOPOTAMUS'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\tPREFIXED '
'\x11PRESSIONLESS FACE'
'\x06PRINTS'
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x07PSTICKS'
'\x0ePTUNE FORM TWO'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x17PUNCTUATION END OF TEXT'
'#PUNCTUATION SIGN DIAGONAL QUADCOLON'
'\x03PUQ'
'\x07PURPLE '
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x06PWATCH'
'\x01Q'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x13QUADRUPLE CRESCENTS'
'\x1eQUALS SIGN WITH INFINITY BELOW'
'\x06QUARE '
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\x0bQUARTER GUR'
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x08QUARTERS'
'\x05QUEEN'
'\tQUEEN OF '
'\x0eQUEEN ROTATED '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x08QUINTILE'
'\x01R'
'\tR COASTER'
'\x07R PLUS '
'\x03R S'
'\x06R SIGN'
'\x06R WITH'
'\x10R WITH RIGHT LEG'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x07R2 GUNU'
'\x02RA'
'\x03RA '
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RAAKAN'
'\x06RACING'
'\x0bRADITIONAL '
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x0bRAISED FLAG'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x04RAMA'
'\x04RAN '
'\nRANG CITI '
'\x0bRANSMISSION'
'\x07RANTHA '
'\x03RAT'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x06RAVEL-'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\nRCHAIC KHA'
'\tRCHAIC SA'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\nRDHACANDRA'
'\x02RE'
'\tREAK HERE'
'\x04REAM'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x11REATIONAL VEHICLE'
'\x08RECEIVER'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\x04RED '
'\x08RED HAIR'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x19REE-HUNDRED-AND-TWENTIETH'
'\x13REE-QUARTER CIRCLE '
'\tREFORMED '
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x0cREN CROSSING'
'\x10REPETITION MARK-'
'\x04RESH'
'\nRESH BELOW'
'\tRESH-AYIN'
'\x10RESH-AYIN-DALETH'
'\x07RESSION'
'\x17RETROFLEX HOOK AND BELT'
'\x03REU'
'\x0fREVERSE SOLIDUS'
'\nREVERSED I'
'\x0cREVERSED TSE'
'\x0eREVERSED-SCHWA'
'\x03REX'
'\x04RFER'
'\x18RGLASS WITH FLOWING SAND'
'\x03RHO'
'\x02RI'
'\x03RI '
'\x07RIANGLE'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x17RIGHT HORIZONTAL SECANT'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x14RIGHT POINTING INDEX'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x06RIN2 X'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\nRING THUMB'
'\x07RINKLES'
'&RIOUS FACE WITH SYMBOLS COVERING MOUTH'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x07RIPPLE '
'\x05RIPT '
'\tRIS FORM '
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x17RK SIDEWAYS NOON GHUNNA'
'\rRK SUNGLASSES'
'\nRKING FACE'
'\x03RKL'
'\x04RLIC'
'\x06RLICUE'
'\x03RMT'
'\x18RMUKHI ABBREVIATION SIGN'
'\x13RNISH VERSE DIVIDER'
'\x02RO'
'\x03RO '
'\x06ROCKET'
'\x0cROLLING EYES'
'\x03ROM'
'\x05RONOS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROOK'
'\rROOK ROTATED '
'\x06ROPLET'
'\x04ROSS'
'\x03ROT'
'\x14ROTATED ARDHAVISARGA'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\nROUNDED ER'
'\x05ROWN '
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\nRRIS WHEEL'
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x04RSO-'
'\x02RT'
'\rRTABLE STEREO'
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x05RUMP-'
'\x04RUNI'
'\nRUPEE MARK'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x1dS DIGRAPH WITH RETROFLEX HOOK'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\rS UP TOGETHER'
'\x07S-SAJDA'
'\x08S-SERIF '
'\x02SA'
'\x07SA VAH '
'\x03SAA'
'\x03SAD'
'\x05SADHE'
'\x03SAH'
'\x05SAKIN'
'\x05SAKTA'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x06SANDAL'
'\x07SANDHI '
'\x0bSANDHI MARK'
'\x10SANS-SERIF ARROW'
'\nSANSKRIT S'
'\x0bSAPPOINTED '
'\x03SAR'
'\x0cSARAM GONDI '
'\x05SARGA'
'\x03SAU'
'\x06SAUCER'
'\nSCENT MOON'
'\x05SCHWA'
'\x07SCOOTER'
'\x05SCOPE'
'\x08SCRIPT X'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\x08SENTAGON'
':SENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x07SERPINA'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x0fSEVENTY DEGREES'
'\x02SH'
'\x03SH '
'\x15SH AMPERSAND ORNAMENT'
'\x0bSH PLUS SHU'
'\x1bSH TIMES GISH CROSSING GISH'
'\x03SH2'
'\x11SH2 CROSSING ESH2'
'\x03SH3'
'\x03SHA'
'\tSHAB CEEB'
'\x04SHAD'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x08SHAN SAW'
'\x17SHAPE WITH A DOT INSIDE'
'\x0bSHE AT LEFT'
'\tSHED FACE'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x0eSHESHIG TIMES '
'\x11SHESHIG TIMES BAD'
'\x13SHHA WITH DESCENDER'
'\x03SHI'
'\x07SHIFT T'
'\x04SHIM'
'\x04SHIN'
'\x05SHIRT'
'\nSHMIRI YEH'
'\x06SHORT '
'\x08SHORT ER'
'\x05SHPIN'
'\rSHTIN TIMES U'
'\x03SHU'
'\x04SHU '
'\x04SHU2'
'\x04SHUL'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\x04SIGN'
'\x05SIGN '
'\x11SIGN O WITH CROSS'
'\x10SIGN PALI VIRAMA'
'\x0cSIGN SIDDHAM'
'\x07SIGN UD'
'\x0bSIGN VIRAMA'
'\x03SII'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\x04SIXT'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x13SLANTED NORTH ARROW'
'\x05SMALL'
'\x06SMALL '
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\x07SMALL W'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x07SOLDIER'
'\x05SOLVE'
'\x0eSONAL COMPUTER'
'\x06SOUTH '
'\x0cSOUTHERN TSE'
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x03SPE'
'\rSPEECH BUBBLE'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x05SPINE'
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x03SQU'
'\x06SQUARE'
'\x08SQUARED '
'\x07SQUARES'
'\x08SQUEEZED'
'\x02SS'
'\x03SSA'
'\rSSAGE WAITING'
'\x0bSSANGKIYEOK'
'\rSSANGYESIEUNG'
'\x03SSI'
'\x1aSSIAN ASTROLOGICAL SYMBOL '
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x04SSUS'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x07ST TUBE'
'\nST-FEEDING'
'\tSTAL BALL'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x05START'
'\x0bSTEAMY ROOM'
'\tSTEBASKET'
'\tSTER FACE'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\x06STRING'
'\x06STROKE'
'\x0cSTROKE BELOW'
'"STRONG CENTRALIZATION STROKE BELOW'
'\x0eSTRONG ISOLATE'
'\x06STROOM'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x04SUCK'
'\x06SUCKED'
'\x05SURYA'
'\x03SUU'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\x0cT ABOVE LEFT'
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x05T OF '
'\tT OF MEAT'
'\x06T SHOE'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x0cTACKED COMMA'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x10TAI LAING DIGIT '
'\x0fTAI LAING TONE-'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\nTAMAN SIGN'
'\x03TAN'
'\x03TAR'
'\x08TAR EYES'
'\x06TARGET'
'\x11TARTING FROM SIGN'
'\x06TATED '
'\x03TAW'
'\x04TAXI'
'\nTCOIN SIGN'
'\x02TE'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x04TEEN'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\x03TEN'
'\x05TENSE'
'\x04TENU'
'\x03TER'
'\x0eTERMINAL MARK-'
'\x0cTERNATE AYIN'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\x0bTH-THALATHA'
'\x06THAKKU'
'\x07THALIYA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x05THING'
'\x05THIRD'
'\x0cTHLETIC SHOE'
'\x08THOSCOPE'
'\x0eTHOUGHT BUBBLE'
'\x08THOUSAND'
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0cTHREE HEARTS'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x04TIC '
'\x06TICAL '
'\nTICAL DISC'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x05TILDE'
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES KUR'
'\x08TIMES UD'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x0bTION BOTTLE'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\x06TITLO '
'\x03TIU'
'\x03TLE'
'\x06TLESS '
'\x02TO'
'\x06TO BAR'
'\x08TO FORM '
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x04TONE'
'\x05TONE '
'\x05TONE-'
'\x06TONGUE'
'\x04TOP '
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x13TOUCHTONE TELEPHONE'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x03TRA'
'\x05TRACK'
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x03TRE'
'\tTREDECILE'
'\nTREFACTION'
'\tTRETCHED '
'\x03TRI'
'\x08TRI DISH'
'\x0bTRIAN CAMEL'
'\x08TRIANGLE'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE FLAME'
'\x03TRO'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'\x05TSEEB'
'\x05TSHEG'
'\x02TT'
'\x03TTA'
'\x03TTE'
'\x0cTTED SOLIDUS'
'\x04TTER'
'\x05TTER '
'\x03TTH'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x03TUJ'
'\x0bTUNE COOKIE'
'\x03TUP'
'\x06TURBAN'
'\x05TURN '
'\x07TURNED '
'\nTURNED AYB'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED SECTION MARK'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x13TWENTY-FIVE DEGREES'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\x1bTWO HUNDRED SEVENTY DEGREES'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x04TZEL'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x13U OVER BU TIMES NA2'
'\x08U TIMES '
'\x05U U U'
'\x07U WITH '
'\x10U WITH LEFT HOOK'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x04U11 '
'\x03U2 '
'\x08U2 PLUS '
'\nU2 PLUS BA'
'\x02U3'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUAL WHEELCHAIR'
'\x03UAM'
'\nUAM TSHOOJ'
'\x06UANGXI'
'\x02UB'
'\x03UB '
'\x03UBE'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x08UBJOINER'
'\x04UBLE'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\tUG TIMES '
'\x06UGGAGE'
'\x07UGGLING'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x04UKTA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x05ULAR '
'\x07ULATION'
'\x07ULCANUS'
'\tULL MOON '
'\x08ULL STOP'
'\x03ULT'
'\x02UM'
'\x03UM '
'\tUM TIMES '
'\x12UM WITH DRUMSTICKS'
'\x08UMBRELLA'
'\x05UMBS '
'\x02UN'
'\x07UN MEUT'
'\x0cUNBLENDED UK'
'\x03UND'
'\x05UNDER'
'\x06UNDER '
'\x1aUNEVEN EYES AND WAVY MOUTH'
'\x03UNG'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\rUP TACK ABOVE'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x03UR '
'\nUR HUNDRED'
'\x06UR OF '
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x03URL'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'\tURNED GAN'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x0bURRENT SIGN'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\x06USHPIN'
'\x0eUSPENSION MARK'
'\x06USTER-'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\x04UTAN'
'\nUTBOX TRAY'
'\x05UTEUX'
'\x04UTH '
'\nUTH OR SPY'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x06UTRAL '
'\x04UTTY'
'\x02UU'
'\tUVUZHAKKU'
'\x02UX'
'\x07UZHAKKU'
'\x01V'
'\x07V BELOW'
'\x07V WITH '
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x07VARIANT'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\tVE THUMB '
'\x07VED ICE'
'\x04VEDE'
'\x0eVEDIC ANUSVARA'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\nVERAGE BOX'
'\rVERGREEN TREE'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x13VERTICAL BAR VIRAMA'
'\rVERTICAL BARS'
'\x0fVERTICAL JOINER'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x0bVERY SMALL '
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VES'
'\x04VEST'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x03VHA'
'\x02VI'
'\x0cVICTORY HAND'
'\nVIE CAMERA'
'\x10VIEWING CEREMONY'
'\tVIGINTILE'
'\x07VILLAIN'
'\x03VIN'
'\tVINE LEAF'
'\x05VING '
'\tVING MASK'
'\x06VIRAMA'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x06VOCADO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x08VOLAPUK '
'\x08VOMITING'
'\x03VOP'
'\x04VOS '
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0bVOWEL SIGN '
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x02VW'
'\x03VY '
'\rVY CHECK MARK'
'\x01W'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x05WAQFA'
'\x04WARD'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x05WELVE'
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x03WER'
'\x04WER '
'\x11WER PLAYING CARDS'
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x14WET CULTIVATION SIGN'
'\x05WFISH'
'\x06WHITE '
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\nWHITE HAIR'
'\x0bWHITE JOKER'
'\x0cWHITE SQUARE'
'\nWHOLE NOTE'
'\x02WI'
'\x04WIDE'
'\x07WIDE ES'
'\x05WIDTH'
'\x07WIFRUIT'
'\x06WINDOW'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x10WITH HEARING AID'
'\x12WITH JUSTIFICATION'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\nWITH SPOON'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x07WN FACE'
'\x08WN HEART'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x07WO DOTS'
'\x08WO DOTS '
'\nWO FINGERS'
'\x0bWO HUNDRED '
'\x06WO OF '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\x15WO-CIRCLE NUKTA ABOVE'
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WUAET'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\tX WITH LO'
'\tX-X BELOW'
'\x02XA'
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x02XE'
'\x04XEYN'
'\nXHEEJ CEEV'
'\x02XI'
'\x08XIANGQI '
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x07XT LINE'
'\x0bXTINGUISHER'
'\x15XTRA SHORT VOWEL MARK'
'\x05XW XW'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x07Y GREEN'
'\x06Y LOOP'
'\x08Y POPPER'
'\nY THOUSAND'
'\x16Y WITH SHORT RIGHT LEG'
'\x08Y-FOURTH'
'\tY-FOURTHS'
'\x02YA'
'\x07YA LAMP'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x03YAN'
'\x0cYAN NUMERAL '
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x07YELLOW '
'\x08YEN SIGN'
'\tYESIEUNG-'
'\x04YEUX'
'\x05YGIEA'
'\x02YI'
'\x03YI '
'\x0eYI WITH STROKE'
'\x16YIAKENG PUACHUE HMONG '
'\x03YIN'
'\x05YING '
'\nYING CARD '
'\tYING FACE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x0cYLEFT SYMBOL'
'\x08YLLABLE '
'\x12YLLABLE LENGTHENER'
'\x07YMAIC L'
'\x05YMBOL'
'\x06YMBOL '
'\nYMBOL AIVA'
'\x0cYMBOL BINDU '
'\rYMBOL KIEVAN '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x04YODH'
'\x06YOMBO '
'\x12YPTIAN HIEROGLYPH '
'\x06YRENE '
'\x08YRILLIC '
'\x05YSTER'
'\x02YU'
'\x01Z'
'\x1dZ DIGRAPH WITH RETROFLEX HOOK'
'\x13Z WITH PALATAL HOOK'
'\x02ZA'
'\x03ZAH'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\nZAR AMULET'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x04ZEN '
'\x04ZERO'
'\x03ZHE'
'\x03ZHI'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOR'
'\nZU OVER ZU'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZHE'
'\x04ZZY '
)
_charnodes =[67479,
 -33564,
 -1,
 132262,
 17034,
 983080,
 197597,
 80820,
 -1,
 263132,
 171009,
 -1,
 328058,
 212117,
 -1,
 393581,
 266084,
 -1,
 459116,
 352144,
 -1,
 524501,
 406711,
 -1,
 590001,
 477958,
 121091,
 720895,
 524288,
 -1,
 721000,
 607923,
 120832,
 851967,
 655360,
 -1,
 852026,
 744495,
 120846,
 983039,
 786432,
 -1,
 983073,
 859654,
 -1,
 1048605,
 944017,
 120853,
 1179647,
 983040,
 -1,
 1179671,
 1083755,
 -1,
 1245206,
 1147158,
 120877,
 1376255,
 1179648,
 -1,
 -65515,
 1254288,
 120878,
 -1,
 1317411,
 120879,
 -1,
 1193928,
 120884,
 1572889,
 1130546,
 120857,
 -1,
 1508700,
 120882,
 1703963,
 1517042,
 120856,
 -1,
 1639738,
 120885,
 -65508,
 1662014,
 120855,
 -1,
 1787584,
 120854,
 2031615,
 1014729,
 -1,
 2031648,
 1912284,
 120858,
 -1,
 1967452,
 120883,
 -1,
 1966732,
 121001,
 2228269,
 952677,
 120862,
 2359295,
 2162688,
 -1,
 2359335,
 2235910,
 -1,
 -65499,
 2331096,
 120872,
 -65498,
 2385818,
 120893,
 -1,
 2443802,
 120873,
 2621482,
 2309269,
 -1,
 -65495,
 2582567,
 120874,
 -1,
 2639946,
 120875,
 2818092,
 2561162,
 120895,
 -1,
 2753424,
 120894,
 -1,
 2759203,
 120866,
 3014707,
 2192297,
 -1,
 3080242,
 2967386,
 120966,
 3211263,
 3014656,
 -1,
 -65487,
 3089296,
 120972,
 -1,
 3152419,
 120971,
 -1,
 3019302,
 120849,
 3407925,
 2965554,
 120850,
 -1,
 3343583,
 120867,
 3538999,
 3349027,
 120848,
 -1,
 3474792,
 120865,
 -65480,
 3510665,
 120871,
 -65479,
 3638575,
 120864,
 -1,
 3692189,
 120996,
 3866713,
 821611,
 -1,
 3932229,
 3834134,
 121052,
 4063231,
 3866624,
 -1,
 4063297,
 3967339,
 -1,
 -65473,
 4008125,
 121054,
 -65472,
 4072336,
 121055,
 -1,
 4135459,
 121056,
 4325444,
 4015801,
 -1,
 -65469,
 4276261,
 121059,
 -1,
 4332067,
 121057,
 -1,
 4267198,
 121058,
 4587599,
 3874310,
 -1,
 4653133,
 4558367,
 -1,
 4718668,
 4617129,
 -1,
 4784203,
 4691021,
 -1,
 -65462,
 4755672,
 121066,
 -1,
 4802763,
 121064,
 -1,
 4740534,
 121063,
 -1,
 4681972,
 120887,
 5177343,
 4606431,
 121067,
 -1,
 5056141,
 120892,
 5242963,
 4538551,
 121062,
 5373951,
 5189120,
 -1,
 -65454,
 5280038,
 120881,
 -1,
 5324850,
 120899,
 5505110,
 5191632,
 -1,
 -65451,
 5473529,
 121060,
 -1,
 5511715,
 121061,
 5767167,
 5444753,
 -1,
 -65448,
 5663629,
 120890,
 -1,
 5719601,
 120891,
 5898334,
 3817522,
 120843,
 6029311,
 5832704,
 -1,
 6029405,
 5921961,
 120852,
 -1,
 5965148,
 120870,
 -1,
 5986263,
 120844,
 6226018,
 5869869,
 120851,
 6356991,
 6161714,
 -1,
 -65439,
 6258966,
 120868,
 -1,
 6300560,
 120869,
 6488165,
 6189993,
 -1,
 -65436,
 6440889,
 121018,
 -1,
 6492696,
 120841,
 6684775,
 6429219,
 120838,
 -1,
 6620053,
 120861,
 -1,
 6628850,
 120842,
 6881407,
 690533,
 121077,
 7012351,
 6815744,
 -1,
 7012465,
 6918366,
 -1,
 7077998,
 6981219,
 -1,
 -65427,
 7052054,
 121086,
 -1,
 7094659,
 121088,
 -65425,
 7034540,
 120979,
 -65424,
 7227072,
 120840,
 -1,
 7288896,
 121089,
 7471222,
 6953569,
 -1,
 7536756,
 7423691,
 121083,
 -1,
 7472376,
 120876,
 -65419,
 7502300,
 121085,
 -1,
 7625802,
 121084,
 7798906,
 7438619,
 -1,
 -65416,
 7743677,
 121079,
 -65415,
 7807888,
 121080,
 -1,
 7871011,
 121081,
 8061053,
 7760827,
 -1,
 -65412,
 8031696,
 121087,
 -1,
 8075392,
 121090,
 -65410,
 8011548,
 121078,
 -1,
 8206280,
 121082,
 8388757,
 6839350,
 -1,
 8454285,
 8358251,
 -1,
 8519814,
 8396294,
 -1,
 8585349,
 8473121,
 -1,
 -65404,
 8556838,
 120888,
 -1,
 8601650,
 120889,
 -1,
 8557022,
 120886,
 8847499,
 8459409,
 -1,
 8913034,
 8809346,
 -1,
 -65399,
 8884518,
 120896,
 -1,
 8922465,
 120897,
 -1,
 8865584,
 120898,
 -65396,
 8803997,
 121035,
 -1,
 9126092,
 120880,
 9306255,
 8425766,
 121030,
 -1,
 9241948,
 121033,
 9437330,
 9270185,
 -1,
 -65391,
 9390009,
 121037,
 -1,
 9441816,
 121032,
 -65389,
 9393821,
 121036,
 -65388,
 9579252,
 121028,
 -1,
 9640488,
 120860,
 9830564,
 8345252,
 -1,
 9896092,
 9775860,
 120974,
 10027007,
 9830400,
 -1,
 10027163,
 9927275,
 -1,
 -65382,
 9995513,
 120975,
 -1,
 10036789,
 120976,
 -1,
 9988595,
 120977,
 10289311,
 9864803,
 -1,
 -65378,
 10250904,
 120985,
 -1,
 10306098,
 120986,
 10485921,
 10241715,
 120992,
 -1,
 10421547,
 120988,
 -65374,
 10457382,
 120978,
 -65373,
 10581104,
 120983,
 -1,
 10623523,
 120984,
 10813615,
 9796043,
 -1,
 10879145,
 10771503,
 121012,
 11010047,
 10813440,
 -1,
 -65368,
 10908799,
 121014,
 -1,
 10953616,
 121013,
 -65366,
 10850598,
 121006,
 -65365,
 11110757,
 121016,
 -65364,
 11170928,
 121007,
 -65363,
 11228829,
 121008,
 -65362,
 11290291,
 121015,
 -1,
 11348724,
 121003,
 -65360,
 10764060,
 121092,
 -1,
 11483236,
 120906,
 11730943,
 545130,
 120922,
 11796479,
 11599872,
 -1,
 11796675,
 11678903,
 -1,
 11862205,
 11750296,
 120908,
 11993087,
 11796480,
 -1,
 11993274,
 11878450,
 120919,
 12124159,
 11927552,
 -1,
 -65351,
 12028288,
 120920,
 -1,
 12083734,
 120921,
 -65349,
 11962738,
 120914,
 -65348,
 12204033,
 120910,
 -1,
 12261923,
 120912,
 12517375,
 11823846,
 120900,
 12582911,
 12386304,
 -1,
 12583105,
 12460944,
 120903,
 -1,
 12518616,
 120904,
 -65342,
 12533810,
 120902,
 -1,
 12655139,
 120901,
 12845257,
 11764630,
 -1,
 12910791,
 12787656,
 120930,
 13041663,
 12846428,
 120931,
 -1,
 12910837,
 120932,
 -65336,
 12867229,
 120933,
 -1,
 13059871,
 120929,
 13238480,
 12795676,
 120924,
 13369343,
 13172736,
 -1,
 13369551,
 13252253,
 120909,
 13500415,
 13303808,
 -1,
 -65330,
 13383681,
 120911,
 -1,
 13441571,
 120913,
 -1,
 13339008,
 120926,
 13697236,
 13207915,
 -1,
 -65326,
 13664534,
 120925,
 -65325,
 13711304,
 120928,
 -1,
 13769251,
 120927,
 -1,
 13638283,
 120923,
 14024977,
 466438,
 -1,
 14090480,
 13995551,
 -1,
 14156011,
 14052536,
 120941,
 14286847,
 14090240,
 -1,
 14287071,
 14182543,
 120940,
 14417919,
 14221312,
 -1,
 14418142,
 14322027,
 -1,
 -65315,
 14385430,
 120942,
 -1,
 14432200,
 120946,
 -1,
 14377494,
 120944,
 14680292,
 14239411,
 120834,
 14811135,
 14614528,
 -1,
 14811363,
 14715237,
 121068,
 -1,
 14746493,
 121069,
 -1,
 14776796,
 121024,
 15007975,
 14649707,
 -1,
 -65306,
 14975254,
 120943,
 -1,
 15022024,
 120947,
 15204585,
 14956189,
 120915,
 -1,
 15139709,
 120916,
 -65302,
 15163926,
 120945,
 -1,
 15293526,
 121040,
 15532031,
 14121777,
 120949,
 15597567,
 15400960,
 -1,
 -65298,
 15493263,
 120948,
 -65297,
 15555718,
 121039,
 -1,
 15615723,
 121020,
 15794439,
 14043615,
 120950,
 15925247,
 15728640,
 -1,
 15925503,
 15812275,
 120833,
 16056319,
 15859712,
 -1,
 16056572,
 15948847,
 120847,
 16187391,
 15990784,
 -1,
 16187641,
 16065843,
 -1,
 -65288,
 16133596,
 120859,
 -1,
 16188044,
 121002,
 -65286,
 16157029,
 120863,
 -65285,
 16349638,
 120967,
 -1,
 16406173,
 120997,
 -65283,
 16021980,
 121019,
 -65282,
 16531493,
 120845,
 -1,
 16587299,
 120839,
 16777475,
 15883318,
 -1,
 16843010,
 16742876,
 121038,
 -1,
 16777461,
 121045,
 -1,
 16814374,
 121031,
 17039622,
 16733860,
 -1,
 -65275,
 17010982,
 120980,
 -1,
 17057459,
 120993,
 -1,
 17005020,
 121009,
 17367039,
 15749537,
 120934,
 17432575,
 17235968,
 -1,
 17432844,
 17336683,
 -1,
 -65269,
 17400086,
 120935,
 -1,
 17446856,
 120937,
 17629454,
 17390697,
 121046,
 -1,
 17564855,
 121047,
 -65265,
 17588758,
 120936,
 -65264,
 17712896,
 121065,
 -1,
 17774669,
 120905,
 17957193,
 13974677,
 -1,
 18022715,
 17909829,
 120957,
 18153471,
 17956864,
 -1,
 18153763,
 18040499,
 120836,
 18284543,
 18087936,
 -1,
 18284829,
 18188645,
 121072,
 18415615,
 18219008,
 -1,
 18415899,
 18316516,
 -1,
 -65254,
 18373096,
 121073,
 -1,
 18432989,
 121053,
 -65252,
 18376847,
 121070,
 -1,
 18567409,
 121071,
 18743585,
 18242614,
 -1,
 18809120,
 18708934,
 120968,
 -1,
 18743670,
 120973,
 -1,
 18765469,
 120998,
 -65246,
 18708956,
 121025,
 -1,
 18956338,
 121051,
 19136809,
 18114703,
 120955,
 19267583,
 19070976,
 -1,
 19267880,
 19171691,
 -1,
 -65241,
 19235094,
 120959,
 -1,
 19281864,
 120956,
 -1,
 19227158,
 120961,
 19530030,
 19093149,
 120970,
 19660799,
 19464192,
 -1,
 19661101,
 19547827,
 120994,
 -1,
 19596587,
 120989,
 -1,
 19630437,
 120987,
 19857714,
 19499371,
 -1,
 19923249,
 19824918,
 120960,
 -1,
 19858862,
 120963,
 -1,
 19864183,
 120964,
 20119860,
 19823046,
 120999,
 -1,
 20054452,
 121004,
 20250934,
 20077615,
 121029,
 -1,
 20186205,
 121041,
 20382009,
 20198583,
 -1,
 -65224,
 20343538,
 120907,
 -1,
 20401067,
 120917,
 -65222,
 20349460,
 120958,
 -1,
 20537878,
 120962,
 20774911,
 17983523,
 120939,
 20840447,
 20643840,
 -1,
 20840771,
 20732982,
 -1,
 20906306,
 20806120,
 121050,
 21037055,
 20840448,
 -1,
 -65215,
 20933491,
 121048,
 -1,
 20989482,
 121049,
 -1,
 20875621,
 121034,
 21233991,
 20793048,
 -1,
 -65211,
 21205208,
 121023,
 -65210,
 21261171,
 121021,
 -1,
 21317162,
 121022,
 -65208,
 21199373,
 121017,
 -1,
 21439993,
 120938,
 21627234,
 17896580,
 120965,
 21757951,
 21561344,
 -1,
 21758294,
 21644979,
 120837,
 21889023,
 21692416,
 -1,
 21889361,
 21793125,
 121076,
 22020095,
 21823488,
 -1,
 -65200,
 21916531,
 121074,
 -1,
 21972522,
 121075,
 22151507,
 21854684,
 121027,
 -1,
 22086544,
 121026,
 22347775,
 22109238,
 -1,
 -65195,
 22247878,
 120969,
 -1,
 22304413,
 121000,
 22479195,
 21714596,
 -1,
 22544730,
 22431411,
 120995,
 22675455,
 22480201,
 120991,
 -1,
 22545296,
 120990,
 -1,
 22516006,
 120982,
 22806879,
 22436950,
 121044,
 22937599,
 22740992,
 -1,
 -65186,
 22834035,
 121042,
 -1,
 22890026,
 121043,
 23134207,
 22772171,
 -1,
 -65183,
 23025309,
 121011,
 -1,
 23079679,
 121005,
 23330815,
 21588918,
 120951,
 23396351,
 23199744,
 -1,
 23396711,
 23300459,
 -1,
 -65178,
 23363862,
 120952,
 -1,
 23410632,
 120954,
 -65176,
 23362012,
 121010,
 -65175,
 23552534,
 120953,
 -65174,
 23615148,
 120981,
 -65173,
 23676595,
 120835,
 -1,
 23738013,
 120918,
 -1,
 412108,
 121451,
 24051711,
 339260,
 121343,
 24117247,
 23920640,
 -1,
 24117625,
 24010174,
 -1,
 24183160,
 24053856,
 -1,
 24248693,
 24155967,
 -1,
 -65165,
 24218113,
 121346,
 -65164,
 24282361,
 121345,
 -1,
 24323624,
 121348,
 24575999,
 24196868,
 -1,
 -65161,
 24478969,
 121347,
 -1,
 24520232,
 121349,
 -1,
 24117608,
 121350,
 -1,
 24082875,
 121344,
 24838836,
 286011,
 -1,
 24904334,
 24810639,
 -1,
 24969717,
 24876863,
 -1,
 25035168,
 24911366,
 -1,
 25100694,
 25006872,
 -1,
 25166227,
 25034752,
 -1,
 25231753,
 25115797,
 -1,
 25297286,
 25170593,
 -1,
 25362820,
 25252081,
 121230,
 -1,
 25330753,
 121231,
 -65147,
 25330196,
 121228,
 -1,
 25451277,
 121229,
 25690111,
 25250695,
 -1,
 -65144,
 25573626,
 121254,
 -1,
 25632968,
 121261,
 25821582,
 25195269,
 -1,
 25887116,
 25776369,
 121226,
 -1,
 25855041,
 121227,
 -65139,
 25854484,
 121224,
 -1,
 25975565,
 121225,
 26214399,
 25790543,
 -1,
 26214802,
 26113663,
 -1,
 -65135,
 26182164,
 121232,
 -1,
 26237709,
 121233,
 -1,
 26161255,
 121247,
 26542079,
 25110148,
 -1,
 -65131,
 26444308,
 121248,
 -1,
 26499853,
 121249,
 26673563,
 25061742,
 -1,
 -65128,
 26640916,
 121147,
 -65127,
 26704908,
 121150,
 -65126,
 26761997,
 121148,
 -1,
 26824945,
 121149,
 27001247,
 26623754,
 -1,
 -65123,
 26968596,
 121151,
 -65122,
 27024141,
 121152,
 -1,
 27087089,
 121153,
 -1,
 26966985,
 121139,
 27328949,
 25007894,
 -1,
 27394482,
 27269222,
 -1,
 27460011,
 27338286,
 -1,
 27525543,
 27430004,
 -1,
 -65115,
 27492884,
 121244,
 -65114,
 27548429,
 121245,
 -1,
 27611377,
 121246,
 27852799,
 27470292,
 -1,
 -65111,
 27755028,
 121241,
 -65110,
 27810573,
 121242,
 -1,
 27873521,
 121243,
 28049839,
 27404496,
 -1,
 -65107,
 28017172,
 121268,
 -65106,
 28072717,
 121269,
 -1,
 28135665,
 121270,
 28377087,
 28000365,
 -1,
 -65103,
 28260602,
 121257,
 -1,
 28319944,
 121264,
 28573695,
 27359908,
 -1,
 -65100,
 28475801,
 121325,
 -1,
 28518861,
 121326,
 28705214,
 27294948,
 -1,
 28770749,
 28657761,
 -1,
 28836284,
 28738818,
 -1,
 28901818,
 28791025,
 121132,
 -1,
 28869697,
 121133,
 -65093,
 28869140,
 121130,
 -1,
 28990221,
 121131,
 -1,
 28810230,
 121134,
 -1,
 28720381,
 121253,
 29295046,
 28661674,
 -1,
 29360577,
 29262356,
 121237,
 -1,
 29295020,
 121240,
 29491652,
 29311085,
 -1,
 -65085,
 29440250,
 121256,
 -1,
 29499592,
 121263,
 -65083,
 29448973,
 121238,
 -1,
 29642993,
 121239,
 29819343,
 29235392,
 -1,
 29884875,
 29781123,
 -1,
 -65079,
 29852180,
 121154,
 -65078,
 29907725,
 121155,
 -1,
 29970673,
 121156,
 30212095,
 29831331,
 -1,
 -65075,
 30114324,
 121144,
 -65074,
 30169869,
 121145,
 -1,
 30232817,
 121146,
 30409174,
 29770295,
 -1,
 30474707,
 30359661,
 -1,
 -65070,
 30423290,
 121255,
 -1,
 30482632,
 121262,
 -65068,
 30442004,
 121234,
 -65067,
 30628621,
 121235,
 -1,
 30691569,
 121236,
 30867931,
 30379124,
 -1,
 30933465,
 30806820,
 121142,
 -1,
 30869579,
 121143,
 -65062,
 30907382,
 121141,
 -1,
 31032588,
 121140,
 31195616,
 30812628,
 -1,
 31261150,
 31134500,
 121137,
 -1,
 31197259,
 121138,
 -65057,
 31235062,
 121136,
 -1,
 31360249,
 121135,
 31523303,
 31135218,
 -1,
 31588836,
 31490586,
 -1,
 -65053,
 31555993,
 121315,
 -1,
 31599053,
 121317,
 31850495,
 31546132,
 -1,
 -65050,
 31752601,
 121316,
 -1,
 31795661,
 121318,
 31982059,
 31498235,
 -1,
 -65047,
 31949332,
 121157,
 -65046,
 32004877,
 121158,
 -1,
 32067825,
 121159,
 32244207,
 31944284,
 -1,
 -65043,
 32211476,
 121160,
 -65042,
 32267021,
 121161,
 -1,
 32329969,
 121162,
 32506356,
 32192043,
 -1,
 32571891,
 32459323,
 -1,
 -65038,
 32539033,
 121329,
 -1,
 32582093,
 121330,
 -1,
 32532479,
 121128,
 -1,
 32460030,
 121448,
 32899693,
 24917764,
 -1,
 32965130,
 32841222,
 -1,
 33030660,
 32936733,
 -1,
 33096191,
 32981101,
 -1,
 33161724,
 33044221,
 -1,
 -65029,
 33128980,
 121286,
 -1,
 33181937,
 121287,
 33423359,
 33103803,
 -1,
 -65026,
 33325588,
 121271,
 -1,
 33378545,
 121272,
 33554945,
 33050865,
 121303,
 -1,
 33522753,
 121304,
 -65022,
 33522196,
 121301,
 -65021,
 33643277,
 121302,
 -1,
 33694449,
 121305,
 33882632,
 32991598,
 -1,
 -65018,
 33849876,
 121204,
 -65017,
 33905421,
 121205,
 -1,
 33968369,
 121206,
 -65015,
 33848265,
 121198,
 -1,
 34094853,
 121207,
 34275866,
 32937750,
 -1,
 34341399,
 34216038,
 -1,
 34406931,
 34291821,
 -1,
 34472464,
 34354941,
 -1,
 -65009,
 34439700,
 121296,
 -1,
 34492657,
 121297,
 34734079,
 34414523,
 -1,
 -65006,
 34636308,
 121281,
 -1,
 34689265,
 121282,
 34865686,
 34372836,
 -1,
 -65003,
 34823944,
 121308,
 -1,
 34888168,
 121309,
 -1,
 34820337,
 121310,
 35192831,
 34306743,
 -1,
 -64999,
 35094937,
 121327,
 -1,
 35137997,
 121328,
 35324459,
 34232234,
 -1,
 35389994,
 35274861,
 -1,
 35455523,
 35337981,
 -1,
 35521056,
 35422746,
 -1,
 -64993,
 35488153,
 121292,
 -1,
 35531213,
 121294,
 35782655,
 35475703,
 -1,
 -64990,
 35684761,
 121293,
 -1,
 35727821,
 121295,
 35979263,
 35397563,
 -1,
 35979815,
 35881498,
 -1,
 -64986,
 35946905,
 121277,
 -1,
 35989965,
 121279,
 36241407,
 35934455,
 -1,
 -64983,
 36143513,
 121278,
 -1,
 36186573,
 121280,
 -1,
 35357204,
 121307,
 36438587,
 35275319,
 -1,
 36504122,
 36388973,
 -1,
 36569651,
 36452093,
 -1,
 36635185,
 36539508,
 -1,
 -64976,
 36602531,
 121290,
 -1,
 36655424,
 121291,
 -64974,
 36602401,
 121288,
 -1,
 36786430,
 121289,
 37027839,
 36511675,
 -1,
 37028407,
 36930074,
 -1,
 -64970,
 36998253,
 121275,
 -1,
 37038541,
 121273,
 37289983,
 36983031,
 -1,
 -64967,
 37194861,
 121276,
 -1,
 37235149,
 121274,
 -1,
 36471316,
 121306,
 37487172,
 36404452,
 -1,
 37552707,
 37439585,
 -1,
 37618242,
 37520642,
 -1,
 37683776,
 37572849,
 121191,
 -1,
 37651521,
 121192,
 -64959,
 37650964,
 121189,
 -1,
 37772045,
 121190,
 -1,
 37592054,
 121193,
 -1,
 37502212,
 121314,
 38077006,
 37426686,
 -1,
 38142536,
 38044186,
 -1,
 -64953,
 38109593,
 121319,
 -1,
 38152653,
 121322,
 38339147,
 38099732,
 -1,
 -64950,
 38306201,
 121320,
 -1,
 38349261,
 121323,
 38600703,
 38293751,
 -1,
 -64947,
 38502809,
 121321,
 -1,
 38545869,
 121324,
 38732372,
 38046836,
 -1,
 38797906,
 38671152,
 -1,
 -64943,
 38771702,
 121202,
 -1,
 38821310,
 121201,
 -64941,
 38771702,
 121200,
 -1,
 38962444,
 121199,
 39125593,
 38676948,
 -1,
 39191127,
 39064356,
 121196,
 -1,
 39127115,
 121197,
 -64936,
 39164918,
 121195,
 -1,
 39290105,
 121194,
 39453279,
 39065792,
 -1,
 39518814,
 39414915,
 -1,
 -64932,
 39485972,
 121208,
 -64931,
 39541517,
 121209,
 -1,
 39604465,
 121210,
 -1,
 39465119,
 121203,
 39846499,
 39428091,
 -1,
 -64927,
 39813652,
 121211,
 -64926,
 39869197,
 121212,
 -1,
 39932145,
 121213,
 40108647,
 39808604,
 -1,
 -64923,
 40075796,
 121214,
 -64922,
 40131341,
 121215,
 -1,
 40194289,
 121216,
 40370796,
 40056363,
 -1,
 40436331,
 40323651,
 -1,
 -64918,
 40403353,
 121331,
 -1,
 40446413,
 121332,
 -1,
 40396799,
 121129,
 -1,
 40324350,
 121449,
 40764035,
 32843974,
 -1,
 40829561,
 40704609,
 -1,
 40895092,
 40799072,
 -1,
 40960626,
 40849649,
 121187,
 -1,
 40928321,
 121188,
 -64909,
 40927764,
 121185,
 -1,
 41048845,
 121186,
 41287679,
 40835206,
 -1,
 41288311,
 41177329,
 121183,
 -1,
 41256001,
 121184,
 -64904,
 41255444,
 121181,
 -1,
 41376525,
 121182,
 41550462,
 40799072,
 -1,
 41615996,
 41505009,
 121179,
 -1,
 41583681,
 121180,
 -64899,
 41583124,
 121177,
 -1,
 41704205,
 121178,
 41943039,
 41490566,
 -1,
 41943681,
 41832689,
 121175,
 -1,
 41911361,
 121176,
 -64894,
 41910804,
 121173,
 -1,
 42031885,
 121174,
 42270719,
 40714283,
 -1,
 42271372,
 42176809,
 -1,
 42336907,
 42216185,
 -1,
 42402441,
 42275632,
 -1,
 -64888,
 42369556,
 121126,
 -1,
 42422513,
 121125,
 -64886,
 42369556,
 121122,
 -1,
 42553585,
 121121,
 -1,
 42303305,
 121123,
 -64883,
 42238241,
 121127,
 -1,
 42740542,
 121124,
 42991615,
 24875949,
 -1,
 42992283,
 42887316,
 -1,
 43057812,
 42956290,
 121418,
 43188223,
 42991616,
 -1,
 -64877,
 43097497,
 121420,
 -1,
 43162595,
 121419,
 43319960,
 43019190,
 121415,
 43450367,
 43253760,
 -1,
 -64873,
 43359641,
 121417,
 -1,
 43424739,
 121416,
 -64871,
 43293667,
 121414,
 -64870,
 43530184,
 121413,
 -1,
 43589945,
 121412,
 43778721,
 42933766,
 -1,
 43844256,
 43734964,
 -1,
 -64866,
 43802763,
 121403,
 -64865,
 43857864,
 121404,
 -1,
 43918360,
 121405,
 -1,
 43805045,
 121430,
 44171941,
 43747342,
 121424,
 44302335,
 44105728,
 -1,
 -64860,
 44205536,
 121426,
 -1,
 44251080,
 121425,
 44434089,
 44139202,
 121406,
 44564479,
 44367872,
 -1,
 -64856,
 44473315,
 121407,
 -1,
 44525711,
 121408,
 44696237,
 44388128,
 121421,
 44826623,
 44630016,
 -1,
 -64852,
 44735459,
 121423,
 -1,
 44775368,
 121422,
 44958385,
 44644613,
 121409,
 45088767,
 44892160,
 -1,
 -64848,
 44997603,
 121410,
 -1,
 45049999,
 121411,
 45285375,
 44932076,
 -1,
 -64845,
 45187481,
 121431,
 -1,
 45230541,
 121432,
 45417203,
 24807011,
 -1,
 45482704,
 45380881,
 -1,
 45548229,
 45455167,
 -1,
 45613760,
 45513749,
 -1,
 45679292,
 45586239,
 -1,
 -64838,
 45646233,
 121163,
 -64837,
 45689293,
 121164,
 -1,
 45749028,
 121165,
 46006271,
 45627140,
 -1,
 -64834,
 45908377,
 121166,
 -64833,
 45951437,
 121167,
 -1,
 46011172,
 121168,
 46203588,
 45553185,
 -1,
 -64830,
 46173293,
 121172,
 -64829,
 46236057,
 121170,
 -1,
 46279117,
 121171,
 -1,
 46170112,
 121169,
 46596095,
 45496068,
 -1,
 46596815,
 46496789,
 -1,
 46662347,
 46569279,
 -1,
 -64823,
 46629273,
 121220,
 -64822,
 46672333,
 121221,
 -1,
 46732068,
 121222,
 46989311,
 46610180,
 -1,
 -64819,
 46891417,
 121217,
 -64818,
 46934477,
 121218,
 -1,
 46994212,
 121219,
 -1,
 46563328,
 121223,
 47252197,
 45442027,
 -1,
 47317724,
 47210764,
 -1,
 47383253,
 47286881,
 -1,
 -64812,
 47352626,
 121436,
 -1,
 47389290,
 121435,
 47579864,
 47325135,
 -1,
 -64809,
 47547585,
 121439,
 -1,
 47597778,
 121440,
 -64807,
 47547598,
 121433,
 -64806,
 47734215,
 121438,
 -64805,
 47797673,
 121434,
 -1,
 47859935,
 121437,
 48038624,
 47288216,
 -1,
 -64802,
 48005529,
 121093,
 -64801,
 48062030,
 121094,
 -1,
 48110169,
 121095,
 48365567,
 48004224,
 -1,
 48366308,
 48273215,
 -1,
 -64797,
 48334110,
 121458,
 -1,
 48375356,
 121459,
 -1,
 48314145,
 121460,
 48693247,
 47197355,
 -1,
 48693999,
 48575264,
 121441,
 48824319,
 48627712,
 -1,
 48825069,
 48719442,
 -1,
 48890603,
 48794330,
 121443,
 -1,
 48825079,
 121444,
 49086463,
 48846476,
 121445,
 -1,
 48956151,
 121446,
 -64786,
 48782782,
 121442,
 -1,
 49093462,
 121447,
 49348607,
 48653051,
 -1,
 -64783,
 49241135,
 121390,
 -64782,
 49305559,
 121391,
 -1,
 49364953,
 121389,
 49546022,
 45380521,
 -1,
 49611554,
 49506790,
 -1,
 49677073,
 49547360,
 -1,
 49742596,
 49649471,
 -1,
 49808123,
 49709465,
 121250,
 49938431,
 49742380,
 -1,
 -64774,
 49821946,
 121258,
 -1,
 49881288,
 121265,
 50070271,
 49752525,
 121251,
 50200575,
 50004524,
 -1,
 -64770,
 50084090,
 121259,
 -1,
 50143432,
 121266,
 50397183,
 50008810,
 -1,
 50397955,
 50284453,
 -1,
 -64766,
 50346234,
 121260,
 -1,
 50405576,
 121267,
 -1,
 50343083,
 121252,
 50724863,
 49690372,
 -1,
 50725641,
 50626969,
 121311,
 50855935,
 50659884,
 -1,
 -64760,
 50738935,
 121298,
 -1,
 50798515,
 121283,
 50987789,
 50670029,
 121312,
 51118079,
 50922028,
 -1,
 -64756,
 51001079,
 121299,
 -1,
 51060659,
 121284,
 51314687,
 50926372,
 121313,
 51380223,
 51184172,
 -1,
 -64752,
 51263223,
 121300,
 -1,
 51322803,
 121285,
 51576831,
 49611500,
 -1,
 51577626,
 51448233,
 -1,
 -64748,
 51514652,
 121519,
 -64747,
 51580018,
 121518,
 -64746,
 51645398,
 121517,
 -64745,
 51710749,
 121516,
 -64744,
 51776069,
 121515,
 -64743,
 51841449,
 121514,
 -1,
 51906841,
 121513,
 -64741,
 51515097,
 121512,
 -64740,
 52039258,
 121511,
 -64739,
 52104628,
 121510,
 -64738,
 52170012,
 121509,
 -64737,
 52235378,
 121508,
 -64736,
 52300758,
 121507,
 -64735,
 52366109,
 121506,
 -1,
 52431429,
 121505,
 52690943,
 49581815,
 -1,
 -64732,
 52593049,
 121105,
 -64731,
 52649550,
 121106,
 -1,
 52697689,
 121107,
 52888400,
 49491115,
 -1,
 52953934,
 52862370,
 -1,
 53019447,
 52902423,
 -1,
 53084977,
 52991807,
 -1,
 53150510,
 53052665,
 121377,
 53280767,
 53084160,
 -1,
 -64723,
 53160397,
 121378,
 -1,
 53220132,
 121379,
 53477375,
 53091846,
 -1,
 -64720,
 53383971,
 121383,
 -1,
 53430872,
 121385,
 53673983,
 53032708,
 -1,
 53674806,
 53576953,
 121380,
 53805055,
 53608448,
 -1,
 -64715,
 53684685,
 121381,
 -1,
 53744420,
 121382,
 -1,
 53618229,
 121384,
 54002497,
 52985062,
 -1,
 54068027,
 53975382,
 -1,
 -64710,
 54026648,
 121372,
 -1,
 54068093,
 121370,
 54264638,
 54017328,
 -1,
 -64707,
 54225039,
 121369,
 -1,
 54272636,
 121371,
 -64705,
 54232009,
 121365,
 -64704,
 54421647,
 121364,
 -1,
 54469244,
 121366,
 54657861,
 53956941,
 -1,
 -64701,
 54628646,
 121374,
 -64700,
 54671173,
 121376,
 -1,
 54733556,
 121375,
 54920009,
 54599011,
 -1,
 -64697,
 54890790,
 121354,
 -64696,
 54943883,
 121355,
 -1,
 54995700,
 121356,
 55246847,
 54853632,
 -1,
 55247693,
 55122980,
 -1,
 -64692,
 55214489,
 121367,
 -1,
 55270990,
 121368,
 -1,
 55220621,
 121373,
 -64689,
 52927592,
 121452,
 -1,
 55449266,
 121392,
 55640941,
 52842444,
 -1,
 55706465,
 55591562,
 -1,
 55771996,
 55663268,
 -1,
 55837531,
 55727233,
 -1,
 -64683,
 55774644,
 121469,
 -64682,
 55840028,
 121468,
 -64681,
 55905394,
 121467,
 -64680,
 55970774,
 121466,
 -64679,
 56036125,
 121465,
 -64678,
 56101445,
 121464,
 -1,
 56166825,
 121463,
 -1,
 55780069,
 121462,
 56492031,
 55733432,
 -1,
 56492896,
 56360960,
 -1,
 -64673,
 56463888,
 121429,
 -1,
 56514674,
 121428,
 -1,
 56458538,
 121427,
 56819711,
 55665769,
 -1,
 56820586,
 56688640,
 -1,
 56886118,
 56770143,
 -1,
 -64667,
 56837291,
 121473,
 -1,
 56889540,
 121476,
 -64665,
 56858979,
 121474,
 -64664,
 57051938,
 121477,
 -64663,
 57103966,
 121478,
 -1,
 57157709,
 121475,
 57409535,
 56756320,
 -1,
 -64660,
 57317222,
 121471,
 -1,
 57358096,
 121472,
 57541514,
 55588023,
 -1,
 57607033,
 57495500,
 -1,
 57672568,
 57557923,
 -1,
 57738101,
 57638116,
 -1,
 57803636,
 57694701,
 -1,
 -64653,
 57770393,
 121116,
 -1,
 57826894,
 121118,
 -1,
 57749955,
 121119,
 58130431,
 57692407,
 -1,
 -64649,
 58032537,
 121115,
 -1,
 58089038,
 121117,
 -1,
 57632842,
 121456,
 58327937,
 57557642,
 -1,
 58393472,
 58283713,
 -1,
 -64644,
 58330396,
 121503,
 -64643,
 58395762,
 121502,
 -64642,
 58461142,
 121501,
 -64641,
 58526493,
 121500,
 -1,
 58591813,
 121499,
 -1,
 58351847,
 121470,
 58852229,
 58288468,
 -1,
 -64637,
 58825699,
 121363,
 -64636,
 58876043,
 121361,
 -1,
 58926104,
 121362,
 59114377,
 58789945,
 -1,
 59179912,
 59085129,
 121352,
 -1,
 59114872,
 121353,
 -1,
 59127775,
 121351,
 -1,
 59084924,
 121480,
 59442082,
 57507044,
 -1,
 59507605,
 59405155,
 -1,
 59573137,
 59473124,
 -1,
 59638672,
 59529709,
 -1,
 -64625,
 59605401,
 121111,
 -1,
 59661902,
 121113,
 -1,
 59584963,
 121114,
 59900820,
 59527415,
 -1,
 -64621,
 59867545,
 121110,
 -1,
 59924046,
 121112,
 -1,
 59848421,
 121120,
 60162969,
 59477082,
 -1,
 -64617,
 60129689,
 121099,
 -64616,
 60186190,
 121100,
 -1,
 60234329,
 121101,
 60425118,
 60113228,
 -1,
 60490653,
 60375115,
 -1,
 -64612,
 60457865,
 121453,
 -1,
 60518595,
 121454,
 -1,
 60459526,
 121457,
 60752801,
 60396181,
 -1,
 -64608,
 60720731,
 121108,
 -1,
 60758617,
 121109,
 -1,
 60698689,
 121481,
 61014966,
 59385442,
 -1,
 61080496,
 60989162,
 -1,
 61146024,
 61045988,
 -1,
 61211559,
 61097502,
 121339,
 -1,
 61145106,
 121340,
 -1,
 61167575,
 121336,
 61408171,
 61085322,
 -1,
 -64598,
 61374996,
 121333,
 -1,
 61427953,
 121334,
 -64596,
 61376526,
 121337,
 -64595,
 61568683,
 121338,
 -64594,
 61619167,
 121342,
 -64593,
 61682974,
 121335,
 -1,
 61748271,
 121341,
 61997055,
 61044124,
 -1,
 61998004,
 61890707,
 -1,
 -64589,
 61968678,
 121360,
 -1,
 62008052,
 121357,
 -64587,
 61968702,
 121359,
 -1,
 62139165,
 121358,
 62325694,
 60972671,
 -1,
 62391229,
 62286247,
 -1,
 62456763,
 62363414,
 -1,
 -64582,
 62421528,
 121395,
 -1,
 62473380,
 121396,
 -64580,
 62414987,
 121393,
 -1,
 62596120,
 121394,
 -1,
 62336453,
 121450,
 62849990,
 62266886,
 -1,
 62915523,
 62799637,
 -1,
 -64575,
 62883296,
 121388,
 -64574,
 62943665,
 121386,
 -1,
 63004811,
 121387,
 63242239,
 62874603,
 -1,
 -64571,
 63135031,
 121479,
 -1,
 63199053,
 121482,
 63374286,
 62790920,
 -1,
 63439819,
 63345494,
 -1,
 -64567,
 63406489,
 121102,
 -64566,
 63462990,
 121103,
 -1,
 63511129,
 121104,
 63766527,
 63385012,
 -1,
 -64563,
 63653992,
 121401,
 -1,
 63714451,
 121402,
 63898581,
 63312362,
 -1,
 63964114,
 63866331,
 -1,
 -64559,
 63915954,
 121398,
 -1,
 63964349,
 121400,
 64225279,
 63904822,
 -1,
 -64556,
 64112614,
 121397,
 -1,
 64160957,
 121399,
 64357337,
 63847441,
 -1,
 -64553,
 64323993,
 121096,
 -64552,
 64380494,
 121097,
 -1,
 64428633,
 121098,
 -64550,
 64329546,
 121455,
 -64549,
 64590317,
 121461,
 -1,
 64646631,
 121483,
 -1,
 197478,
 129304,
 64881765,
 140898,
 -1,
 64947290,
 64825510,
 -1,
 65012770,
 64902297,
 -1,
 65078250,
 64980579,
 -1,
 65143779,
 65051456,
 71129,
 -1,
 65094282,
 71130,
 65274854,
 65111651,
 -1,
 -64539,
 65223843,
 71065,
 -1,
 65277796,
 71064,
 65471465,
 65223829,
 -1,
 -64536,
 65435214,
 71128,
 -1,
 65474404,
 71070,
 -1,
 65408868,
 71069,
 65733617,
 65049591,
 -1,
 65799152,
 65692751,
 -1,
 65864686,
 65762217,
 71046,
 -1,
 65827753,
 71047,
 66060287,
 65818572,
 71048,
 -1,
 65949644,
 71049,
 -1,
 65736548,
 71082,
 66192374,
 65671012,
 71040,
 -64525,
 66162207,
 71053,
 -64524,
 66214110,
 71131,
 -64523,
 66273930,
 71051,
 -1,
 66326372,
 71041,
 66520059,
 66150015,
 -1,
 -64520,
 66493785,
 71063,
 -64519,
 66543320,
 71068,
 -64518,
 66599327,
 71058,
 -1,
 66654052,
 71073,
 66847745,
 66463330,
 -1,
 66913279,
 66791010,
 -1,
 -64514,
 66862243,
 71067,
 -1,
 66916196,
 71066,
 -64512,
 66862243,
 71072,
 -1,
 67047268,
 71071,
 67240965,
 66813156,
 -1,
 -64509,
 67206526,
 71084,
 -64508,
 67255459,
 71083,
 -1,
 67309412,
 71085,
 67503111,
 67210783,
 71044,
 -1,
 67472927,
 71045,
 67634186,
 67464376,
 -1,
 -64503,
 67583139,
 71075,
 -1,
 67637092,
 71074,
 67830797,
 67587459,
 -1,
 -64500,
 67779747,
 71055,
 -1,
 67833700,
 71054,
 68027408,
 67783861,
 -1,
 -64497,
 67976355,
 71062,
 -1,
 68030308,
 71061,
 68224018,
 67977866,
 71042,
 -1,
 68174474,
 71043,
 68355093,
 68172134,
 -1,
 -64492,
 68304035,
 71057,
 -1,
 68357988,
 71056,
 68551704,
 68296198,
 -1,
 -64489,
 68500643,
 71060,
 -1,
 68554596,
 71059,
 68748315,
 68491456,
 -1,
 -64486,
 68697251,
 71077,
 -1,
 68751204,
 71076,
 -64484,
 68722009,
 71079,
 -64483,
 68908029,
 71080,
 -64482,
 68969451,
 71052,
 -64481,
 69032301,
 71078,
 -64480,
 69095454,
 71081,
 -64479,
 69156003,
 71086,
 -1,
 69217451,
 71050,
 69403715,
 64978148,
 -1,
 69469243,
 69348523,
 -1,
 69534776,
 69412249,
 -1,
 69600310,
 69507497,
 -1,
 69665835,
 69569466,
 -1,
 69731370,
 69609479,
 -1,
 -64471,
 69701245,
 71114,
 -1,
 69740988,
 71115,
 -1,
 69693335,
 71122,
 69993519,
 69629219,
 -1,
 -64467,
 69962876,
 71118,
 -64466,
 70003273,
 71117,
 -1,
 70067462,
 71116,
 70255667,
 69935529,
 -1,
 -64463,
 70225345,
 71126,
 -64462,
 70284568,
 71125,
 -1,
 70334512,
 71127,
 -64460,
 70221602,
 71124,
 -64459,
 70480566,
 71123,
 -1,
 70527561,
 71121,
 70778879,
 69544611,
 71119,
 -1,
 70649789,
 71120,
 70909951,
 69496255,
 -1,
 -64454,
 70789521,
 71108,
 -1,
 70850922,
 71109,
 71106559,
 69420355,
 -1,
 71107647,
 71013859,
 -1,
 -64450,
 71073325,
 71102,
 -1,
 71136438,
 71103,
 -64448,
 71074062,
 71105,
 -64447,
 71263092,
 71104,
 -64446,
 71311005,
 71100,
 -1,
 71374089,
 71101,
 71566418,
 69375716,
 -1,
 71631946,
 71503716,
 -1,
 71697479,
 71588062,
 71132,
 -1,
 71667231,
 71133,
 -64440,
 71667231,
 71099,
 -64439,
 71778954,
 71097,
 -1,
 71831396,
 71087,
 72025164,
 71603827,
 71092,
 -1,
 71988137,
 71093,
 72156238,
 71994911,
 71090,
 -1,
 72125983,
 71091,
 72287312,
 72106634,
 71088,
 -1,
 72237706,
 71089,
 -64431,
 72246251,
 71098,
 -1,
 72363179,
 71096,
 72549462,
 71530205,
 -1,
 -64428,
 72485661,
 71112,
 -64427,
 72550981,
 71111,
 -1,
 72616361,
 71110,
 72811609,
 72492642,
 -1,
 -64424,
 72772192,
 71107,
 -1,
 72815674,
 71106,
 -1,
 72757431,
 71113,
 73138175,
 64894019,
 -1,
 73139296,
 73046215,
 -1,
 -64419,
 73109871,
 128414,
 -64418,
 73168995,
 128409,
 -64417,
 73224948,
 128408,
 -1,
 73280298,
 128415,
 73531391,
 73079671,
 -1,
 -64414,
 73437551,
 128416,
 -64413,
 73496675,
 128411,
 -64412,
 73552628,
 128410,
 -1,
 73607978,
 128417,
 73794722,
 64839295,
 -1,
 73860248,
 73743645,
 -1,
 73925765,
 73799058,
 -1,
 73991288,
 73884538,
 -1,
 74056813,
 73959011,
 -1,
 -64405,
 74029155,
 70123,
 -64404,
 74072167,
 70124,
 -1,
 74133584,
 70122,
 74318960,
 74022116,
 -1,
 -64401,
 74271859,
 70127,
 -1,
 74331136,
 70128,
 74515571,
 74278577,
 -1,
 -64398,
 74483940,
 70132,
 -1,
 74531389,
 70131,
 74712182,
 74462391,
 -1,
 -64395,
 74672543,
 70125,
 -1,
 74728498,
 70126,
 -64393,
 74670456,
 70130,
 -1,
 74854309,
 70129,
 75104255,
 73935107,
 -1,
 75105404,
 75007587,
 -1,
 -64389,
 75078402,
 70114,
 -1,
 75120994,
 70115,
 75302015,
 75070692,
 -1,
 -64386,
 75254829,
 70118,
 -1,
 75314119,
 70119,
 75498626,
 75248823,
 -1,
 -64383,
 75459298,
 70116,
 -1,
 75516815,
 70117,
 -64381,
 75458221,
 70113,
 -64380,
 75653439,
 70121,
 -1,
 75706206,
 70120,
 75891859,
 73881233,
 -1,
 75957385,
 75859555,
 -1,
 -64376,
 75930370,
 3560,
 -1,
 75972962,
 3561,
 76153996,
 75922660,
 -1,
 -64373,
 76106797,
 3564,
 -1,
 76166087,
 3565,
 76350607,
 76100791,
 -1,
 -64370,
 76311266,
 3562,
 -1,
 76368783,
 3563,
 -64368,
 76324846,
 3558,
 -64367,
 76506797,
 3559,
 -64366,
 76570943,
 3567,
 -1,
 76623710,
 3566,
 76873727,
 75834306,
 -1,
 76874903,
 76772265,
 -1,
 -64362,
 76820875,
 983935,
 -1,
 76878419,
 983934,
 -1,
 76848521,
 983933,
 77201407,
 73808803,
 -1,
 77202591,
 77070336,
 -1,
 77268125,
 77168803,
 -1,
 -64356,
 77241090,
 983154,
 -1,
 77283682,
 983157,
 -64354,
 77216743,
 983182,
 -1,
 77406273,
 983184,
 77660159,
 77138185,
 -1,
 -64351,
 77531933,
 983158,
 -1,
 77597253,
 983155,
 77792421,
 73767990,
 -1,
 -64348,
 77759622,
 128303,
 -1,
 77819730,
 128973,
 -1,
 77747598,
 128510,
 78054807,
 91115,
 983077,
 78120214,
 78028538,
 -1,
 78185696,
 78075033,
 -1,
 78251186,
 78153315,
 -1,
 78316717,
 78218851,
 -1,
 -64340,
 78265507,
 72295,
 -1,
 78319460,
 72294,
 78513328,
 78281956,
 -1,
 -64337,
 78462115,
 72310,
 -1,
 78516068,
 72309,
 -64335,
 78462115,
 72300,
 -1,
 78647140,
 72299,
 78841017,
 78194274,
 -1,
 78906550,
 78784098,
 -1,
 -64331,
 78855331,
 72297,
 -1,
 78909284,
 72296,
 -64329,
 78880609,
 72311,
 -64328,
 79051939,
 72302,
 -1,
 79105892,
 72301,
 79299774,
 78798463,
 -1,
 -64325,
 79273305,
 72293,
 -64324,
 79322840,
 72298,
 -64323,
 79378847,
 72288,
 -1,
 79433572,
 72303,
 79627458,
 79264996,
 -1,
 -64320,
 79592830,
 72320,
 -64319,
 79641763,
 72319,
 -1,
 79695716,
 72321,
 79889606,
 79580547,
 -1,
 -64316,
 79856597,
 72323,
 -64315,
 79903907,
 72285,
 -1,
 79957860,
 72284,
 80151753,
 79863597,
 -1,
 -64312,
 80100515,
 72312,
 -1,
 80154468,
 72313,
 80348364,
 80112824,
 -1,
 -64309,
 80297123,
 72305,
 -1,
 80351076,
 72304,
 80544975,
 80301237,
 -1,
 -64306,
 80493731,
 72292,
 -1,
 80547684,
 72291,
 80741586,
 80492902,
 -1,
 -64303,
 80690339,
 72287,
 -1,
 80744292,
 72286,
 80938197,
 80682502,
 -1,
 -64300,
 80886947,
 72290,
 -1,
 80940900,
 72289,
 81134808,
 80877760,
 -1,
 -64297,
 81083555,
 72307,
 -1,
 81137508,
 72306,
 -64295,
 81108313,
 72315,
 -64294,
 81302537,
 72318,
 -64293,
 81359869,
 72316,
 -64292,
 81418605,
 72308,
 -64291,
 81481758,
 72317,
 -64290,
 81542307,
 72322,
 -64289,
 81596260,
 72272,
 -1,
 81660005,
 72314,
 81855725,
 78132733,
 -1,
 81921251,
 81820900,
 72340,
 -1,
 81869973,
 72339,
 82052325,
 81878655,
 72334,
 -1,
 82000230,
 72332,
 -64282,
 82015145,
 72337,
 -64281,
 82139427,
 72336,
 -64280,
 82202572,
 72338,
 -64279,
 82267523,
 72331,
 -64278,
 82327910,
 72330,
 -64277,
 82388578,
 72333,
 -64276,
 82450624,
 72335,
 -1,
 82511973,
 72341,
 82707708,
 81827506,
 -1,
 82773243,
 82673995,
 -1,
 82838770,
 82744938,
 -1,
 -64271,
 82801577,
 72281,
 -1,
 82857932,
 72282,
 83035380,
 82808351,
 72275,
 -1,
 82980011,
 72274,
 83166454,
 82994155,
 72277,
 -1,
 83111083,
 72278,
 83297529,
 83103588,
 -1,
 -64264,
 83267103,
 72280,
 -1,
 83313290,
 72279,
 -64262,
 83247754,
 72273,
 -1,
 83438763,
 72276,
 -1,
 82728053,
 72283,
 83690755,
 82672868,
 -1,
 83756290,
 83641667,
 -1,
 -64257,
 83727942,
 72343,
 -64256,
 83792332,
 72325,
 -64255,
 83840301,
 72324,
 -1,
 83891465,
 72342,
 -1,
 83726111,
 72345,
 84149512,
 83647063,
 -1,
 -64251,
 84118712,
 72346,
 -64250,
 84180976,
 72347,
 -64249,
 84242447,
 72349,
 -1,
 84290241,
 72348,
 84477198,
 84091556,
 -1,
 84542732,
 84442340,
 -1,
 -64245,
 84491427,
 72328,
 -1,
 84545380,
 72329,
 -64243,
 84505597,
 72326,
 -1,
 84693022,
 72327,
 84870418,
 84426352,
 72352,
 85000191,
 84803615,
 -1,
 -64239,
 84905101,
 72350,
 -1,
 84948691,
 72351,
 85132565,
 84838429,
 -1,
 -64236,
 85068357,
 72354,
 -1,
 85133737,
 72353,
 -1,
 85080710,
 72344,
 85394767,
 78068291,
 -1,
 85460273,
 85349529,
 -1,
 85525789,
 85425380,
 -1,
 85591324,
 85462884,
 -1,
 -64229,
 85547938,
 69436,
 -1,
 85600428,
 69439,
 -1,
 85540897,
 69441,
 85853472,
 85479372,
 -1,
 -64225,
 85799631,
 69444,
 -1,
 85857129,
 69433,
 86050082,
 85802591,
 69427,
 -1,
 86018127,
 69430,
 86181157,
 85987172,
 -1,
 -64220,
 86154808,
 69437,
 -1,
 86201481,
 69424,
 -64218,
 86155230,
 69429,
 -64217,
 86351605,
 69431,
 -64216,
 86415329,
 69428,
 -64215,
 86476707,
 69442,
 -64214,
 86537982,
 69440,
 -64213,
 86601292,
 69438,
 -64212,
 86664127,
 69435,
 -64211,
 86727597,
 69434,
 -64210,
 86789643,
 69432,
 -64209,
 86850410,
 69426,
 -64208,
 86914431,
 69443,
 -1,
 86973012,
 69425,
 87164225,
 85402362,
 -1,
 87229749,
 87133623,
 -1,
 -64204,
 87169560,
 69447,
 -1,
 87232545,
 69449,
 87426360,
 87179452,
 -1,
 -64201,
 87366168,
 69453,
 -1,
 87429153,
 69452,
 87622971,
 87370133,
 -1,
 -64198,
 87562776,
 69446,
 -1,
 87625761,
 69448,
 87819582,
 87565870,
 -1,
 -64195,
 87759384,
 69451,
 -1,
 87822369,
 69450,
 -64193,
 87786833,
 69456,
 -64192,
 87979763,
 69455,
 -1,
 88037217,
 69454,
 88212808,
 87126468,
 -1,
 88278342,
 88182185,
 -1,
 88343877,
 88249603,
 69461,
 -1,
 88278643,
 69462,
 -1,
 88285622,
 69464,
 -64185,
 88227126,
 69465,
 -1,
 88482131,
 69463,
 88671566,
 88171386,
 -1,
 88737100,
 88639075,
 -1,
 -64181,
 88709219,
 69459,
 -1,
 88748112,
 69458,
 88997887,
 88696493,
 69457,
 -1,
 88867388,
 69460,
 -1,
 88622724,
 69445,
 89130363,
 85357572,
 -1,
 89195885,
 89085081,
 -1,
 89261397,
 89153151,
 -1,
 -64173,
 89234792,
 69857,
 -64172,
 89274837,
 69847,
 -1,
 89330106,
 69849,
 89523544,
 89217389,
 -1,
 -64169,
 89472149,
 69846,
 -1,
 89533611,
 69864,
 89720155,
 89468075,
 -1,
 -64166,
 89668757,
 69863,
 -1,
 89730865,
 69859,
 -64164,
 89693544,
 69852,
 -64163,
 89887764,
 69850,
 -64162,
 89952282,
 69861,
 -64161,
 90015523,
 69841,
 -64160,
 90078615,
 69840,
 -64159,
 90141774,
 69853,
 -64158,
 90205472,
 69851,
 -64157,
 90268978,
 69862,
 -64156,
 90329222,
 69848,
 -64155,
 90394092,
 69855,
 -64154,
 90459366,
 69856,
 -64153,
 90523034,
 69860,
 -64152,
 90586302,
 69854,
 -64151,
 90651093,
 69845,
 -64150,
 90711831,
 69844,
 -64149,
 90775107,
 69843,
 -64148,
 90839345,
 69842,
 -1,
 90902970,
 69858,
 91160575,
 89139459,
 -1,
 91161969,
 91063907,
 -1,
 -64144,
 91134722,
 69874,
 -1,
 91177314,
 69875,
 91358580,
 91127012,
 -1,
 -64141,
 91311149,
 69878,
 -1,
 91370439,
 69879,
 91555191,
 91305143,
 -1,
 -64138,
 91515618,
 69876,
 -1,
 91573135,
 69877,
 -64136,
 91529198,
 69872,
 -64135,
 91711149,
 69873,
 -64134,
 91775295,
 69881,
 -1,
 91828062,
 69880,
 92013964,
 89101229,
 -1,
 92079492,
 91986052,
 -1,
 92145025,
 92041274,
 -1,
 -64129,
 92116517,
 128601,
 -64128,
 92164718,
 128593,
 -1,
 92216723,
 128609,
 92407171,
 92113954,
 11113,
 -1,
 92341664,
 11129,
 -1,
 92372468,
 129111,
 92667903,
 92024181,
 -1,
 92669321,
 92565562,
 -1,
 -64121,
 92640805,
 128603,
 -64120,
 92689006,
 128595,
 -1,
 92741011,
 128611,
 92931467,
 92638242,
 11112,
 -1,
 92865952,
 11128,
 -1,
 92896756,
 129110,
 93128081,
 91961634,
 -1,
 93193616,
 93061120,
 -1,
 -64113,
 93159493,
 128428,
 -1,
 93209488,
 127846,
 -1,
 93133125,
 129358,
 93455763,
 93083068,
 128618,
 -1,
 93389387,
 128619,
 -64108,
 93420772,
 983181,
 -64107,
 93546126,
 128284,
 -64106,
 93600917,
 983043,
 -1,
 93659728,
 129510,
 93849147,
 78003349,
 -1,
 93914652,
 93785956,
 -1,
 93980186,
 93877161,
 -1,
 94045721,
 93917413,
 -1,
 94111195,
 94000281,
 -1,
 94176675,
 94082039,
 -1,
 94242210,
 94135375,
 -1,
 94307744,
 94204841,
 70025,
 -1,
 94270377,
 70026,
 94502911,
 94261196,
 70027,
 -1,
 94392268,
 70028,
 -1,
 94179172,
 70062,
 94635433,
 94144099,
 -1,
 94700967,
 94602851,
 -1,
 -64090,
 94649507,
 70044,
 -1,
 94703460,
 70043,
 -64088,
 94649507,
 70049,
 -1,
 94834532,
 70048,
 95028654,
 94592639,
 -1,
 -64085,
 95001945,
 70042,
 -64084,
 95051480,
 70047,
 -64083,
 95107487,
 70037,
 -1,
 95162212,
 70052,
 95356340,
 94971490,
 -1,
 95421874,
 95299170,
 -1,
 -64079,
 95370403,
 70046,
 -1,
 95424356,
 70045,
 -64077,
 95370403,
 70051,
 -1,
 95555428,
 70050,
 95749560,
 95293284,
 70019,
 -64074,
 95718943,
 70032,
 -64073,
 95765130,
 70030,
 -1,
 95817572,
 70020,
 96011708,
 95714532,
 -1,
 -64070,
 95976830,
 70064,
 -64069,
 96025763,
 70063,
 -1,
 96079716,
 70065,
 96273854,
 95981087,
 70023,
 -1,
 96243231,
 70024,
 96404929,
 96234680,
 -1,
 -64064,
 96353443,
 70054,
 -1,
 96407396,
 70053,
 96601540,
 96358348,
 -1,
 -64061,
 96555038,
 70061,
 -1,
 96604004,
 70060,
 96798151,
 96554371,
 -1,
 -64058,
 96746659,
 70034,
 -1,
 96800612,
 70033,
 96994762,
 96750773,
 -1,
 -64055,
 96943267,
 70041,
 -1,
 96997220,
 70040,
 97191372,
 96944778,
 70021,
 -1,
 97141386,
 70022,
 97322447,
 97139046,
 -1,
 -64050,
 97270947,
 70036,
 -1,
 97324900,
 70035,
 97519058,
 97263110,
 -1,
 -64047,
 97467555,
 70039,
 -1,
 97521508,
 70038,
 97715669,
 97458368,
 -1,
 -64044,
 97664163,
 70056,
 -1,
 97718116,
 70055,
 -64042,
 97688921,
 70058,
 -64041,
 97874941,
 70059,
 -64040,
 97936363,
 70031,
 -64039,
 97999213,
 70057,
 -64038,
 98057379,
 70066,
 -1,
 98118827,
 70029,
 98305517,
 94082738,
 -1,
 98371052,
 98271563,
 -1,
 98436578,
 98342506,
 -1,
 98502112,
 98399145,
 70072,
 -1,
 98464681,
 70073,
 98697215,
 98455500,
 70074,
 -1,
 98586572,
 70075,
 98764262,
 98373476,
 -1,
 -64028,
 98733599,
 70079,
 -64027,
 98779786,
 70077,
 -1,
 98832228,
 70067,
 99026408,
 98733599,
 70070,
 -1,
 98995743,
 70071,
 99157482,
 98976394,
 70068,
 -1,
 99107466,
 70069,
 -64021,
 99116011,
 70078,
 -1,
 99232939,
 70076,
 -1,
 98327946,
 70091,
 99485185,
 98270436,
 -1,
 99550714,
 99435843,
 -1,
 99616242,
 99522019,
 -1,
 -64015,
 99581485,
 70018,
 -1,
 99644598,
 70080,
 99812853,
 99553124,
 -1,
 -64012,
 99783692,
 70081,
 -1,
 99836867,
 70017,
 -64010,
 99783116,
 70083,
 -64009,
 99975438,
 70107,
 -64008,
 100033396,
 70090,
 -64007,
 100093229,
 70082,
 -1,
 100146845,
 70016,
 100337151,
 99495083,
 -1,
 100402686,
 100279717,
 -1,
 -64003,
 100338245,
 70111,
 -1,
 100403625,
 70110,
 -1,
 100363703,
 70088,
 -64000,
 100307913,
 70093,
 -1,
 100602943,
 70089,
 100795922,
 99427938,
 -1,
 100861456,
 100746550,
 -1,
 100926982,
 100828771,
 -1,
 -63995,
 100899586,
 70098,
 -1,
 100942178,
 70099,
 101123593,
 100891876,
 -1,
 -63992,
 101076013,
 70102,
 -1,
 101135303,
 70103,
 101320204,
 101070007,
 -1,
 -63989,
 101280482,
 70100,
 -1,
 101337999,
 70101,
 -63987,
 101294062,
 70096,
 -63986,
 101476013,
 70097,
 -63985,
 101540159,
 70105,
 -1,
 101592926,
 70104,
 -63983,
 100821600,
 70086,
 -1,
 101717050,
 70085,
 101910037,
 100740267,
 -1,
 -63980,
 101883077,
 70092,
 -1,
 101928455,
 70106,
 -63978,
 101869010,
 70084,
 -63977,
 102055595,
 70108,
 -63976,
 102114354,
 70109,
 -1,
 102174729,
 70087,
 -1,
 93998467,
 129416,
 -63973,
 93951063,
 127847,
 -1,
 102389514,
 129368,
 102565424,
 93873131,
 -1,
 102630954,
 102530181,
 -1,
 102696483,
 102579616,
 -1,
 -63968,
 102666657,
 113827,
 -63967,
 102716642,
 113824,
 -63966,
 102771544,
 113826,
 -1,
 102835268,
 113825,
 103024168,
 102629376,
 -1,
 103089703,
 102963392,
 -1,
 -63962,
 103035156,
 11103,
 -1,
 103092371,
 11087,
 -1,
 103055872,
 11086,
 -63959,
 102989028,
 129651,
 -1,
 103292491,
 127856,
 103482925,
 102592771,
 -1,
 -63956,
 103451818,
 128722,
 -1,
 103487788,
 128717,
 -63954,
 103454825,
 128703,
 -63953,
 103639564,
 127776,
 -1,
 103686669,
 129327,
 103876150,
 102515338,
 -1,
 103941684,
 103823653,
 -1,
 -63949,
 103902067,
 983075,
 -1,
 103958058,
 983078,
 -63947,
 103902392,
 128674,
 -1,
 104083393,
 128737,
 104269369,
 103838633,
 -1,
 -63944,
 104239097,
 129335,
 -1,
 104285722,
 129424,
 -63942,
 104242411,
 983197,
 -1,
 104410809,
 128017,
 104597145,
 93811375,
 -1,
 104662680,
 104535507,
 -1,
 104728212,
 104605284,
 -1,
 104793692,
 104681420,
 -1,
 104859223,
 104732616,
 -1,
 104924758,
 104799941,
 -1,
 -63934,
 104898349,
 127305,
 -63933,
 104963307,
 127304,
 -63932,
 105028650,
 127303,
 -63931,
 105092087,
 127301,
 -63930,
 105156127,
 127300,
 -63929,
 105219683,
 127299,
 -63928,
 105280425,
 127297,
 -63927,
 105345653,
 127296,
 -63926,
 105407467,
 127294,
 -63925,
 105470243,
 127292,
 -63924,
 105533388,
 127291,
 -63923,
 105598339,
 127290,
 -63922,
 105663669,
 127289,
 -63921,
 105726602,
 127288,
 -63920,
 105790613,
 127287,
 -63919,
 105855334,
 127286,
 -63918,
 105919671,
 127285,
 -63917,
 105983147,
 127284,
 -63916,
 106047074,
 127283,
 -63915,
 106110470,
 127282,
 -1,
 106172260,
 127280,
 -1,
 104890967,
 127397,
 106495999,
 104817643,
 -1,
 106497627,
 106380117,
 -1,
 -63910,
 106457344,
 10191,
 -1,
 106501085,
 10190,
 -1,
 106464304,
 127401,
 106759790,
 104734214,
 -1,
 106825324,
 106712413,
 -1,
 106890850,
 106761652,
 -1,
 -63904,
 106827694,
 127539,
 -63903,
 106893152,
 127538,
 -1,
 106958096,
 127544,
 107152999,
 106827036,
 -1,
 107218534,
 107089471,
 -1,
 -63899,
 107155161,
 127542,
 -1,
 107220570,
 127543,
 -1,
 107162928,
 127541,
 107480683,
 107089010,
 -1,
 -63895,
 107416856,
 127546,
 -63894,
 107482213,
 127540,
 -1,
 107547417,
 127545,
 -1,
 107417432,
 127547,
 -63891,
 106784831,
 127378,
 -1,
 107761612,
 127377,
 107939445,
 106724580,
 -1,
 108004978,
 107883691,
 -1,
 -63887,
 107975831,
 127393,
 -1,
 108012420,
 127388,
 -63885,
 107964836,
 127384,
 -63884,
 108153976,
 127395,
 -1,
 108216942,
 127402,
 108398202,
 107906659,
 -1,
 108463737,
 108369686,
 -1,
 -63880,
 108422144,
 127389,
 -1,
 108474710,
 127394,
 -1,
 108413287,
 127387,
 108725886,
 108346517,
 -1,
 -63876,
 108675859,
 127400,
 -63875,
 108735516,
 127399,
 -1,
 108797446,
 127398,
 108988034,
 108672183,
 -1,
 -63872,
 108951102,
 127379,
 -63871,
 109013768,
 127390,
 -1,
 109071307,
 127392,
 109250181,
 108958711,
 -1,
 -63868,
 109214948,
 127386,
 -1,
 109274274,
 127404,
 109446792,
 109219359,
 -1,
 -63865,
 109407450,
 127385,
 -1,
 109461084,
 127403,
 109643403,
 109405163,
 -1,
 -63862,
 109600765,
 127396,
 -1,
 109661571,
 127383,
 109840014,
 109600383,
 -1,
 -63859,
 109787494,
 127382,
 -1,
 109851712,
 127381,
 110036625,
 109792858,
 -1,
 -63856,
 110001534,
 127490,
 -1,
 110055246,
 127489,
 -63854,
 110008356,
 127311,
 -63853,
 110183375,
 127380,
 -1,
 110243691,
 127391,
 110493695,
 104660992,
 -1,
 -63850,
 110397315,
 128918,
 -63849,
 110457008,
 11216,
 -1,
 110506515,
 13055,
 -1,
 104612815,
 129425,
 110757568,
 104566303,
 -1,
 110823095,
 110714495,
 -1,
 110888626,
 110765931,
 -1,
 110954150,
 110850513,
 -1,
 111019680,
 110914744,
 -1,
 -63841,
 110990002,
 7362,
 -1,
 111023257,
 7361,
 -63839,
 110986727,
 7360,
 -63838,
 111170869,
 7364,
 -63837,
 111234525,
 7365,
 -63836,
 111290105,
 7366,
 -63835,
 111353430,
 7363,
 -1,
 111417582,
 7367,
 111609517,
 110908569,
 -1,
 111675050,
 111556050,
 -1,
 -63831,
 111630627,
 7103,
 -1,
 111693187,
 7102,
 -63829,
 111638329,
 7099,
 -63828,
 111826225,
 7100,
 -1,
 111876775,
 7101,
 112068272,
 111551487,
 -1,
 -63825,
 112039726,
 7085,
 -1,
 112089453,
 7084,
 -63823,
 112034185,
 7083,
 -1,
 112203869,
 7098,
 112395956,
 110852739,
 127749,
 -1,
 112329634,
 127748,
 -63819,
 112361312,
 127751,
 -63818,
 112473918,
 127803,
 -1,
 112527047,
 127774,
 112723642,
 110787812,
 -1,
 -63815,
 112684713,
 128671,
 -1,
 112738214,
 127843,
 112920253,
 112684756,
 -1,
 -63812,
 112891417,
 129465,
 -1,
 112934756,
 129464,
 113116863,
 112859328,
 983102,
 -1,
 113083615,
 983101,
 -1,
 113080184,
 127940,
 113313512,
 110724707,
 983189,
 113379028,
 113250148,
 -1,
 113444558,
 113341353,
 -1,
 113510091,
 113411778,
 -1,
 113575623,
 113474788,
 -1,
 -63802,
 113544289,
 983180,
 -1,
 113586143,
 983132,
 -63800,
 113543237,
 983044,
 -63799,
 113734007,
 983175,
 -63798,
 113786521,
 983042,
 -1,
 113851455,
 983174,
 114098175,
 113444305,
 -1,
 -63795,
 113997852,
 11243,
 -1,
 114053834,
 11242,
 114230993,
 113411683,
 -1,
 -63792,
 114200539,
 128509,
 -1,
 114248060,
 128649,
 -63790,
 114188212,
 129485,
 -63789,
 114384350,
 128387,
 -1,
 114436424,
 127967,
 114624218,
 113323179,
 -1,
 114689752,
 114561860,
 -1,
 -63785,
 114640748,
 127836,
 -1,
 114688660,
 128642,
 -63783,
 114657484,
 129658,
 -1,
 114844191,
 11836,
 115017438,
 114593311,
 -1,
 -63780,
 114978034,
 128723,
 -63779,
 115029391,
 129369,
 -1,
 115091750,
 127897,
 115279587,
 114979753,
 -1,
 115345122,
 115216228,
 -1,
 -63775,
 115316750,
 127827,
 -1,
 115360955,
 128207,
 -1,
 115296299,
 983188,
 115607270,
 115237867,
 -1,
 -63771,
 115569262,
 9201,
 -1,
 115614185,
 128480,
 -63769,
 115579946,
 983045,
 -1,
 115768548,
 983169,
 115934985,
 113274040,
 983117,
 116000501,
 115879083,
 -1,
 116066034,
 115937848,
 -1,
 116131568,
 116011502,
 128264,
 116260863,
 116065745,
 -1,
 -63762,
 116164931,
 128266,
 -63761,
 116221720,
 128265,
 -1,
 116268661,
 128263,
 -63759,
 116082564,
 128483,
 -1,
 116394181,
 128586,
 116654079,
 116010155,
 -1,
 -63756,
 116533138,
 128676,
 -1,
 116596759,
 128172,
 116786940,
 115958763,
 -1,
 116852473,
 116745195,
 -1,
 -63752,
 116809343,
 129348,
 -1,
 116871134,
 129525,
 -63750,
 116822973,
 128051,
 -63749,
 117013654,
 127941,
 -1,
 117072093,
 129533,
 117245699,
 116736650,
 -1,
 117311233,
 117208241,
 -1,
 -63745,
 117276735,
 128026,
 -63744,
 117334687,
 128466,
 -1,
 117382748,
 128467,
 117637119,
 117254227,
 128375,
 -1,
 117507532,
 128376,
 117704456,
 117182308,
 983176,
 117769991,
 117668648,
 -1,
 -63738,
 117720987,
 128150,
 -1,
 117781172,
 10024,
 -1,
 117717741,
 127837,
 -1,
 117657941,
 128166,
 118097701,
 115890467,
 -1,
 118163232,
 118047370,
 -1,
 118228767,
 118118018,
 -1,
 118294300,
 118174947,
 -1,
 118359827,
 118258916,
 -1,
 118425362,
 118316221,
 128522,
 118554623,
 118358047,
 -1,
 -63727,
 118458648,
 129392,
 -1,
 118504844,
 129325,
 -1,
 118395153,
 128526,
 118753048,
 118319292,
 128515,
 118882303,
 118685727,
 -1,
 -63722,
 118786524,
 128518,
 -63721,
 118850248,
 128516,
 -1,
 118891226,
 128517,
 119144447,
 118701205,
 -1,
 -63718,
 119040380,
 128520,
 -63717,
 119090526,
 128525,
 -1,
 119149267,
 128519,
 119406591,
 118234941,
 -1,
 -63714,
 119302332,
 128570,
 -1,
 119357116,
 128571,
 -1,
 118192925,
 128527,
 119605028,
 118100680,
 -1,
 -63710,
 119564585,
 128312,
 -63709,
 119610440,
 128313,
 -1,
 119673327,
 128745,
 -1,
 119563652,
 128684,
 119932733,
 118070507,
 -1,
 119998265,
 119895962,
 -1,
 120063800,
 119935015,
 -1,
 120129335,
 120018118,
 -1,
 120194863,
 120086143,
 -1,
 120260397,
 120151679,
 -1,
 -63700,
 120217304,
 2149,
 -1,
 120262500,
 2148,
 -63698,
 120233305,
 2146,
 -1,
 120404383,
 2144,
 120588082,
 120149694,
 -1,
 -63695,
 120541214,
 2153,
 -1,
 120590180,
 2152,
 -63693,
 120556737,
 2147,
 -63692,
 120751061,
 2154,
 -63691,
 120812541,
 2151,
 -63690,
 120868058,
 2145,
 -1,
 120920743,
 2150,
 -1,
 120096191,
 983202,
 -1,
 120021213,
 128137,
 121243452,
 119955071,
 983094,
 -63685,
 121184540,
 983093,
 -1,
 121246114,
 128333,
 -1,
 121199292,
 128325,
 121505619,
 119869284,
 -1,
 121571143,
 121462399,
 -1,
 121636678,
 121535861,
 -1,
 121702213,
 121585377,
 -1,
 121767748,
 121645524,
 -1,
 -63677,
 121736485,
 128630,
 -1,
 121774885,
 128631,
 -1,
 121722848,
 128632,
 -1,
 121653492,
 128634,
 -1,
 121580694,
 129386,
 122160970,
 121541244,
 -1,
 -63671,
 122120405,
 129429,
 -1,
 122165012,
 43205,
 122357580,
 122128371,
 128752,
 -1,
 122290291,
 128225,
 122488655,
 122303876,
 -1,
 -63666,
 122459581,
 129466,
 -1,
 122515267,
 129527,
 -63664,
 122461353,
 127927,
 -63663,
 122648474,
 129403,
 -63662,
 122706110,
 129474,
 -1,
 122769030,
 127862,
 122947432,
 121458636,
 -1,
 123012957,
 122891435,
 -1,
 123078491,
 122958209,
 -1,
 123144026,
 123029342,
 -1,
 -63656,
 123110964,
 128164,
 -63655,
 123155678,
 128564,
 -1,
 123211819,
 128716,
 -1,
 123116805,
 128554,
 -63652,
 123048882,
 128373,
 -1,
 123414114,
 128759,
 123602786,
 122962570,
 -1,
 123668321,
 123550519,
 -1,
 -63648,
 123634389,
 128578,
 -1,
 123681044,
 128577,
 -1,
 123608985,
 127829,
 123930469,
 123562432,
 -1,
 -63644,
 123878549,
 129445,
 -1,
 123929268,
 127920,
 124190719,
 123868378,
 -1,
 -63641,
 124091113,
 11100,
 -1,
 124151146,
 11098,
 124323699,
 122891435,
 -1,
 124389228,
 124267691,
 -1,
 -63637,
 124332365,
 127793,
 -1,
 124389573,
 128584,
 -63635,
 124356313,
 983168,
 -63634,
 124549664,
 129324,
 -63633,
 124612008,
 11259,
 -63632,
 124671357,
 129331,
 -63631,
 124725587,
 11250,
 -63630,
 124789619,
 129352,
 -1,
 124852073,
 128186,
 125044607,
 124263942,
 -1,
 125110136,
 125006761,
 -1,
 -63626,
 125068730,
 128220,
 -63625,
 125127088,
 128624,
 -1,
 125185703,
 128437,
 125372283,
 125068267,
 -1,
 -63622,
 125336624,
 129410,
 -1,
 125397486,
 128756,
 125568893,
 125321436,
 127979,
 -1,
 125502607,
 127890,
 -63618,
 125518474,
 983185,
 -1,
 125638103,
 129507,
 125831047,
 125001343,
 -1,
 125896579,
 125791299,
 -1,
 -63614,
 125836392,
 127938,
 -1,
 125894968,
 127956,
 126093190,
 125833060,
 -1,
 -63611,
 126045827,
 128013,
 -1,
 126109092,
 128012,
 -1,
 126037703,
 129319,
 126355341,
 125783427,
 -1,
 126420875,
 126324255,
 -1,
 -63606,
 126378440,
 129448,
 -1,
 126441150,
 128128,
 -63604,
 126370444,
 127935,
 -1,
 126556035,
 128761,
 126748562,
 126326550,
 -1,
 126814097,
 126685028,
 -1,
 -63600,
 126779274,
 128629,
 -1,
 126836351,
 129442,
 -1,
 126764560,
 127946,
 127076246,
 126713060,
 -1,
 -63596,
 127012708,
 983133,
 -63595,
 127077149,
 983159,
 -1,
 127142469,
 983156,
 -1,
 127023680,
 983183,
 127405559,
 34403,
 -1,
 127470825,
 127340388,
 -1,
 127535847,
 127426175,
 -1,
 127601382,
 127482214,
 -1,
 127666917,
 127570830,
 -1,
 127732452,
 127607630,
 -1,
 127797260,
 127667484,
 -1,
 127862697,
 127733465,
 -1,
 -63584,
 127799001,
 101050,
 -63583,
 127864410,
 101049,
 -63582,
 127929780,
 101048,
 -63581,
 127995164,
 101047,
 -63580,
 128060530,
 101046,
 -63579,
 128125910,
 101045,
 -63578,
 128191261,
 101044,
 -63577,
 128256581,
 101043,
 -63576,
 128321961,
 101042,
 -1,
 128387353,
 101041,
 128583604,
 127798874,
 -1,
 -63573,
 128519897,
 101040,
 -63572,
 128585306,
 101039,
 -63571,
 128650676,
 101038,
 -63570,
 128716060,
 101037,
 -63569,
 128781426,
 101036,
 -63568,
 128846806,
 101035,
 -63567,
 128912157,
 101034,
 -63566,
 128977477,
 101033,
 -63565,
 129042857,
 101032,
 -1,
 129108249,
 101031,
 129304511,
 128519604,
 -1,
 -63562,
 129240793,
 101030,
 -63561,
 129306202,
 101029,
 -63560,
 129371572,
 101028,
 -63559,
 129436956,
 101027,
 -63558,
 129502322,
 101026,
 -63557,
 129567702,
 101025,
 -63556,
 129633053,
 101024,
 -63555,
 129698373,
 101023,
 -63554,
 129763753,
 101022,
 -1,
 129829145,
 101021,
 130025418,
 129240348,
 -1,
 -63551,
 129961689,
 101020,
 -63550,
 130027098,
 101019,
 -63549,
 130092468,
 101018,
 -63548,
 130157852,
 101017,
 -63547,
 130223218,
 101016,
 -63546,
 130288598,
 101015,
 -63545,
 130353949,
 101014,
 -63544,
 130419269,
 101013,
 -63543,
 130484649,
 101012,
 -1,
 130550041,
 101011,
 130746325,
 129961074,
 -1,
 -63540,
 130682585,
 101010,
 -63539,
 130747994,
 101009,
 -63538,
 130813364,
 101008,
 -63537,
 130878748,
 101007,
 -63536,
 130944114,
 101006,
 -63535,
 131009494,
 101005,
 -63534,
 131074845,
 101004,
 -63533,
 131140165,
 101003,
 -63532,
 131205545,
 101002,
 -1,
 131270937,
 101001,
 131467232,
 130681814,
 -1,
 -63529,
 131403481,
 101000,
 -63528,
 131468890,
 100999,
 -63527,
 131534260,
 100998,
 -63526,
 131599644,
 100997,
 -63525,
 131665010,
 100996,
 -63524,
 131730390,
 100995,
 -63523,
 131795741,
 100994,
 -63522,
 131861061,
 100993,
 -63521,
 131926441,
 100992,
 -1,
 131991833,
 100991,
 132188139,
 131402525,
 -1,
 -63518,
 132124377,
 100990,
 -63517,
 132189786,
 100989,
 -63516,
 132255156,
 100988,
 -63515,
 132320540,
 100987,
 -63514,
 132385906,
 100986,
 -63513,
 132451286,
 100985,
 -63512,
 132516637,
 100984,
 -63511,
 132581957,
 100983,
 -63510,
 132647337,
 100982,
 -1,
 132712729,
 100981,
 132909046,
 132123205,
 -1,
 -63507,
 132845273,
 100980,
 -63506,
 132910682,
 100979,
 -63505,
 132976052,
 100978,
 -63504,
 133041436,
 100977,
 -63503,
 133106802,
 100976,
 -63502,
 133172182,
 100975,
 -63501,
 133237533,
 100974,
 -63500,
 133302853,
 100973,
 -63499,
 133368233,
 100972,
 -1,
 133433625,
 100971,
 133629953,
 132843945,
 -1,
 -63496,
 133566169,
 100970,
 -63495,
 133631578,
 100969,
 -63494,
 133696948,
 100968,
 -63493,
 133762332,
 100967,
 -63492,
 133827698,
 100966,
 -63491,
 133893078,
 100965,
 -63490,
 133958429,
 100964,
 -63489,
 134023749,
 100963,
 -63488,
 134089129,
 100962,
 -1,
 134154521,
 100961,
 134414335,
 133564697,
 -1,
 -63485,
 134287065,
 100960,
 -63484,
 134352474,
 100959,
 -63483,
 134417844,
 100958,
 -63482,
 134483228,
 100957,
 -63481,
 134548594,
 100956,
 -63480,
 134613974,
 100955,
 -63479,
 134679325,
 100954,
 -63478,
 134744645,
 100953,
 -63477,
 134810025,
 100952,
 -1,
 134875417,
 100951,
 135071867,
 127732850,
 -1,
 135137304,
 135007961,
 -1,
 -63473,
 135073497,
 100950,
 -63472,
 135138906,
 100949,
 -63471,
 135204276,
 100948,
 -63470,
 135269660,
 100947,
 -63469,
 135335026,
 100946,
 -63468,
 135400406,
 100945,
 -63467,
 135465757,
 100944,
 -63466,
 135531077,
 100943,
 -63465,
 135596457,
 100942,
 -1,
 135661849,
 100941,
 135858211,
 135073370,
 -1,
 -63462,
 135794393,
 100940,
 -63461,
 135859802,
 100939,
 -63460,
 135925172,
 100938,
 -63459,
 135990556,
 100937,
 -63458,
 136055922,
 100936,
 -63457,
 136121302,
 100935,
 -63456,
 136186653,
 100934,
 -63455,
 136251973,
 100933,
 -63454,
 136317353,
 100932,
 -1,
 136382745,
 100931,
 136579118,
 135794100,
 -1,
 -63451,
 136515289,
 100930,
 -63450,
 136580698,
 100929,
 -63449,
 136646068,
 100928,
 -63448,
 136711452,
 100927,
 -63447,
 136776818,
 100926,
 -63446,
 136842198,
 100925,
 -63445,
 136907549,
 100924,
 -63444,
 136972869,
 100923,
 -63443,
 137038249,
 100922,
 -1,
 137103641,
 100921,
 137300025,
 136514844,
 -1,
 -63440,
 137236185,
 100920,
 -63439,
 137301594,
 100919,
 -63438,
 137366964,
 100918,
 -63437,
 137432348,
 100917,
 -63436,
 137497714,
 100916,
 -63435,
 137563094,
 100915,
 -63434,
 137628445,
 100914,
 -63433,
 137693765,
 100913,
 -63432,
 137759145,
 100912,
 -1,
 137824537,
 100911,
 138020932,
 137235570,
 -1,
 -63429,
 137957081,
 100910,
 -63428,
 138022490,
 100909,
 -63427,
 138087860,
 100908,
 -63426,
 138153244,
 100907,
 -63425,
 138218610,
 100906,
 -63424,
 138283990,
 100905,
 -63423,
 138349341,
 100904,
 -63422,
 138414661,
 100903,
 -63421,
 138480041,
 100902,
 -1,
 138545433,
 100901,
 138741839,
 137956310,
 -1,
 -63418,
 138677977,
 100900,
 -63417,
 138743386,
 100899,
 -63416,
 138808756,
 100898,
 -63415,
 138874140,
 100897,
 -63414,
 138939506,
 100896,
 -63413,
 139004886,
 100895,
 -63412,
 139070237,
 100894,
 -63411,
 139135557,
 100893,
 -63410,
 139200937,
 100892,
 -1,
 139266329,
 100891,
 139462746,
 138677021,
 -1,
 -63407,
 139398873,
 100890,
 -63406,
 139464282,
 100889,
 -63405,
 139529652,
 100888,
 -63404,
 139595036,
 100887,
 -63403,
 139660402,
 100886,
 -63402,
 139725782,
 100885,
 -63401,
 139791133,
 100884,
 -63400,
 139856453,
 100883,
 -63399,
 139921833,
 100882,
 -1,
 139987225,
 100881,
 140183653,
 139397701,
 -1,
 -63396,
 140119769,
 100880,
 -63395,
 140185178,
 100879,
 -63394,
 140250548,
 100878,
 -63393,
 140315932,
 100877,
 -63392,
 140381298,
 100876,
 -63391,
 140446678,
 100875,
 -63390,
 140512029,
 100874,
 -63389,
 140577349,
 100873,
 -63388,
 140642729,
 100872,
 -1,
 140708121,
 100871,
 140904560,
 140118441,
 -1,
 -63385,
 140840665,
 100870,
 -63384,
 140906074,
 100869,
 -63383,
 140971444,
 100868,
 -63382,
 141036828,
 100867,
 -63381,
 141102194,
 100866,
 -63380,
 141167574,
 100865,
 -63379,
 141232925,
 100864,
 -63378,
 141298245,
 100863,
 -63377,
 141363625,
 100862,
 -1,
 141429017,
 100861,
 141688831,
 140839193,
 -1,
 -63374,
 141561561,
 100860,
 -63373,
 141626970,
 100859,
 -63372,
 141692340,
 100858,
 -63371,
 141757724,
 100857,
 -63370,
 141823090,
 100856,
 -63369,
 141888470,
 100855,
 -63368,
 141953821,
 100854,
 -63367,
 142019141,
 100853,
 -63366,
 142084521,
 100852,
 -1,
 142149913,
 100851,
 142346474,
 135007190,
 -1,
 142411911,
 142282457,
 -1,
 -63362,
 142347993,
 100850,
 -63361,
 142413402,
 100849,
 -63360,
 142478772,
 100848,
 -63359,
 142544156,
 100847,
 -63358,
 142609522,
 100846,
 -63357,
 142674902,
 100845,
 -63356,
 142740253,
 100844,
 -63355,
 142805573,
 100843,
 -63354,
 142870953,
 100842,
 -1,
 142936345,
 100841,
 143132818,
 142347866,
 -1,
 -63351,
 143068889,
 100840,
 -63350,
 143134298,
 100839,
 -63349,
 143199668,
 100838,
 -63348,
 143265052,
 100837,
 -63347,
 143330418,
 100836,
 -63346,
 143395798,
 100835,
 -63345,
 143461149,
 100834,
 -63344,
 143526469,
 100833,
 -63343,
 143591849,
 100832,
 -1,
 143657241,
 100831,
 143853725,
 143068596,
 -1,
 -63340,
 143789785,
 100830,
 -63339,
 143855194,
 100829,
 -63338,
 143920564,
 100828,
 -63337,
 143985948,
 100827,
 -63336,
 144051314,
 100826,
 -63335,
 144116694,
 100825,
 -63334,
 144182045,
 100824,
 -63333,
 144247365,
 100823,
 -63332,
 144312745,
 100822,
 -1,
 144378137,
 100821,
 144574632,
 143789340,
 -1,
 -63329,
 144510681,
 100820,
 -63328,
 144576090,
 100819,
 -63327,
 144641460,
 100818,
 -63326,
 144706844,
 100817,
 -63325,
 144772210,
 100816,
 -63324,
 144837590,
 100815,
 -63323,
 144902941,
 100814,
 -63322,
 144968261,
 100813,
 -63321,
 145033641,
 100812,
 -1,
 145099033,
 100811,
 145295539,
 144510066,
 -1,
 -63318,
 145231577,
 100810,
 -63317,
 145296986,
 100809,
 -63316,
 145362356,
 100808,
 -63315,
 145427740,
 100807,
 -63314,
 145493106,
 100806,
 -63313,
 145558486,
 100805,
 -63312,
 145623837,
 100804,
 -63311,
 145689157,
 100803,
 -63310,
 145754537,
 100802,
 -1,
 145819929,
 100801,
 146016446,
 145230806,
 -1,
 -63307,
 145952473,
 100800,
 -63306,
 146017882,
 100799,
 -63305,
 146083252,
 100798,
 -63304,
 146148636,
 100797,
 -63303,
 146214002,
 100796,
 -63302,
 146279382,
 100795,
 -63301,
 146344733,
 100794,
 -63300,
 146410053,
 100793,
 -63299,
 146475433,
 100792,
 -1,
 146540825,
 100791,
 146737353,
 145951517,
 -1,
 -63296,
 146673369,
 100790,
 -63295,
 146738778,
 100789,
 -63294,
 146804148,
 100788,
 -63293,
 146869532,
 100787,
 -63292,
 146934898,
 100786,
 -63291,
 147000278,
 100785,
 -63290,
 147065629,
 100784,
 -63289,
 147130949,
 100783,
 -63288,
 147196329,
 100782,
 -1,
 147261721,
 100781,
 147458260,
 146672197,
 -1,
 -63285,
 147394265,
 100780,
 -63284,
 147459674,
 100779,
 -63283,
 147525044,
 100778,
 -63282,
 147590428,
 100777,
 -63281,
 147655794,
 100776,
 -63280,
 147721174,
 100775,
 -63279,
 147786525,
 100774,
 -63278,
 147851845,
 100773,
 -63277,
 147917225,
 100772,
 -1,
 147982617,
 100771,
 148179167,
 147392937,
 -1,
 -63274,
 148115161,
 100770,
 -63273,
 148180570,
 100769,
 -63272,
 148245940,
 100768,
 -63271,
 148311324,
 100767,
 -63270,
 148376690,
 100766,
 -63269,
 148442070,
 100765,
 -63268,
 148507421,
 100764,
 -63267,
 148572741,
 100763,
 -63266,
 148638121,
 100762,
 -1,
 148703513,
 100761,
 148963327,
 148113689,
 -1,
 -63263,
 148836057,
 100760,
 -63262,
 148901466,
 100759,
 -63261,
 148966836,
 100758,
 -63260,
 149032220,
 100757,
 -63259,
 149097586,
 100756,
 -63258,
 149162966,
 100755,
 -63257,
 149228317,
 100754,
 -63256,
 149293637,
 100753,
 -63255,
 149359017,
 100752,
 -1,
 149424409,
 100751,
 149621081,
 142281501,
 -1,
 149686518,
 149556953,
 -1,
 -63251,
 149622489,
 100750,
 -63250,
 149687898,
 100749,
 -63249,
 149753268,
 100748,
 -63248,
 149818652,
 100747,
 -63247,
 149884018,
 100746,
 -63246,
 149949398,
 100745,
 -63245,
 150014749,
 100744,
 -63244,
 150080069,
 100743,
 -63243,
 150145449,
 100742,
 -1,
 150210841,
 100741,
 150407425,
 149622362,
 -1,
 -63240,
 150343385,
 100740,
 -63239,
 150408794,
 100739,
 -63238,
 150474164,
 100738,
 -63237,
 150539548,
 100737,
 -63236,
 150604914,
 100736,
 -63235,
 150670294,
 100735,
 -63234,
 150735645,
 100734,
 -63233,
 150800965,
 100733,
 -63232,
 150866345,
 100732,
 -1,
 150931737,
 100731,
 151128332,
 150343092,
 -1,
 -63229,
 151064281,
 100730,
 -63228,
 151129690,
 100729,
 -63227,
 151195060,
 100728,
 -63226,
 151260444,
 100727,
 -63225,
 151325810,
 100726,
 -63224,
 151391190,
 100725,
 -63223,
 151456541,
 100724,
 -63222,
 151521861,
 100723,
 -63221,
 151587241,
 100722,
 -1,
 151652633,
 100721,
 151849239,
 151063836,
 -1,
 -63218,
 151785177,
 100720,
 -63217,
 151850586,
 100719,
 -63216,
 151915956,
 100718,
 -63215,
 151981340,
 100717,
 -63214,
 152046706,
 100716,
 -63213,
 152112086,
 100715,
 -63212,
 152177437,
 100714,
 -63211,
 152242757,
 100713,
 -63210,
 152308137,
 100712,
 -1,
 152373529,
 100711,
 152570146,
 151784562,
 -1,
 -63207,
 152506073,
 100710,
 -63206,
 152571482,
 100709,
 -63205,
 152636852,
 100708,
 -63204,
 152702236,
 100707,
 -63203,
 152767602,
 100706,
 -63202,
 152832982,
 100705,
 -63201,
 152898333,
 100704,
 -63200,
 152963653,
 100703,
 -63199,
 153029033,
 100702,
 -1,
 153094425,
 100701,
 153291053,
 152505302,
 -1,
 -63196,
 153226969,
 100700,
 -63195,
 153292378,
 100699,
 -63194,
 153357748,
 100698,
 -63193,
 153423132,
 100697,
 -63192,
 153488498,
 100696,
 -63191,
 153553878,
 100695,
 -63190,
 153619229,
 100694,
 -63189,
 153684549,
 100693,
 -63188,
 153749929,
 100692,
 -1,
 153815321,
 100691,
 154011960,
 153226013,
 -1,
 -63185,
 153947865,
 100690,
 -63184,
 154013274,
 100689,
 -63183,
 154078644,
 100688,
 -63182,
 154144028,
 100687,
 -63181,
 154209394,
 100686,
 -63180,
 154274774,
 100685,
 -63179,
 154340125,
 100684,
 -63178,
 154405445,
 100683,
 -63177,
 154470825,
 100682,
 -1,
 154536217,
 100681,
 154732867,
 153946693,
 -1,
 -63174,
 154668761,
 100680,
 -63173,
 154734170,
 100679,
 -63172,
 154799540,
 100678,
 -63171,
 154864924,
 100677,
 -63170,
 154930290,
 100676,
 -63169,
 154995670,
 100675,
 -63168,
 155061021,
 100674,
 -63167,
 155126341,
 100673,
 -63166,
 155191721,
 100672,
 -1,
 155257113,
 100671,
 155453774,
 154667433,
 -1,
 -63163,
 155389657,
 100670,
 -63162,
 155455066,
 100669,
 -63161,
 155520436,
 100668,
 -63160,
 155585820,
 100667,
 -63159,
 155651186,
 100666,
 -63158,
 155716566,
 100665,
 -63157,
 155781917,
 100664,
 -63156,
 155847237,
 100663,
 -63155,
 155912617,
 100662,
 -1,
 155978009,
 100661,
 156237823,
 155388185,
 -1,
 -63152,
 156110553,
 100660,
 -63151,
 156175962,
 100659,
 -63150,
 156241332,
 100658,
 -63149,
 156306716,
 100657,
 -63148,
 156372082,
 100656,
 -63147,
 156437462,
 100655,
 -63146,
 156502813,
 100654,
 -63145,
 156568133,
 100653,
 -63144,
 156633513,
 100652,
 -1,
 156698905,
 100651,
 156895688,
 149555781,
 -1,
 156961125,
 156831449,
 -1,
 -63140,
 156896985,
 100650,
 -63139,
 156962394,
 100649,
 -63138,
 157027764,
 100648,
 -63137,
 157093148,
 100647,
 -63136,
 157158514,
 100646,
 -63135,
 157223894,
 100645,
 -63134,
 157289245,
 100644,
 -63133,
 157354565,
 100643,
 -63132,
 157419945,
 100642,
 -1,
 157485337,
 100641,
 157682032,
 156896858,
 -1,
 -63129,
 157617881,
 100640,
 -63128,
 157683290,
 100639,
 -63127,
 157748660,
 100638,
 -63126,
 157814044,
 100637,
 -63125,
 157879410,
 100636,
 -63124,
 157944790,
 100635,
 -63123,
 158010141,
 100634,
 -63122,
 158075461,
 100633,
 -63121,
 158140841,
 100632,
 -1,
 158206233,
 100631,
 158402939,
 157617588,
 -1,
 -63118,
 158338777,
 100630,
 -63117,
 158404186,
 100629,
 -63116,
 158469556,
 100628,
 -63115,
 158534940,
 100627,
 -63114,
 158600306,
 100626,
 -63113,
 158665686,
 100625,
 -63112,
 158731037,
 100624,
 -63111,
 158796357,
 100623,
 -63110,
 158861737,
 100622,
 -1,
 158927129,
 100621,
 159123846,
 158338332,
 -1,
 -63107,
 159059673,
 100620,
 -63106,
 159125082,
 100619,
 -63105,
 159190452,
 100618,
 -63104,
 159255836,
 100617,
 -63103,
 159321202,
 100616,
 -63102,
 159386582,
 100615,
 -63101,
 159451933,
 100614,
 -63100,
 159517253,
 100613,
 -63099,
 159582633,
 100612,
 -1,
 159648025,
 100611,
 159844753,
 159059058,
 -1,
 -63096,
 159780569,
 100610,
 -63095,
 159845978,
 100609,
 -63094,
 159911348,
 100608,
 -63093,
 159976732,
 100607,
 -63092,
 160042098,
 100606,
 -63091,
 160107478,
 100605,
 -63090,
 160172829,
 100604,
 -63089,
 160238149,
 100603,
 -63088,
 160303529,
 100602,
 -1,
 160368921,
 100601,
 160565660,
 159779798,
 -1,
 -63085,
 160501465,
 100600,
 -63084,
 160566874,
 100599,
 -63083,
 160632244,
 100598,
 -63082,
 160697628,
 100597,
 -63081,
 160762994,
 100596,
 -63080,
 160828374,
 100595,
 -63079,
 160893725,
 100594,
 -63078,
 160959045,
 100593,
 -63077,
 161024425,
 100592,
 -1,
 161089817,
 100591,
 161286567,
 160500509,
 -1,
 -63074,
 161222361,
 100590,
 -63073,
 161287770,
 100589,
 -63072,
 161353140,
 100588,
 -63071,
 161418524,
 100587,
 -63070,
 161483890,
 100586,
 -63069,
 161549270,
 100585,
 -63068,
 161614621,
 100584,
 -63067,
 161679941,
 100583,
 -63066,
 161745321,
 100582,
 -1,
 161810713,
 100581,
 162007474,
 161221189,
 -1,
 -63063,
 161943257,
 100580,
 -63062,
 162008666,
 100579,
 -63061,
 162074036,
 100578,
 -63060,
 162139420,
 100577,
 -63059,
 162204786,
 100576,
 -63058,
 162270166,
 100575,
 -63057,
 162335517,
 100574,
 -63056,
 162400837,
 100573,
 -63055,
 162466217,
 100572,
 -1,
 162531609,
 100571,
 162728381,
 161941929,
 -1,
 -63052,
 162664153,
 100570,
 -63051,
 162729562,
 100569,
 -63050,
 162794932,
 100568,
 -63049,
 162860316,
 100567,
 -63048,
 162925682,
 100566,
 -63047,
 162991062,
 100565,
 -63046,
 163056413,
 100564,
 -63045,
 163121733,
 100563,
 -63044,
 163187113,
 100562,
 -1,
 163252505,
 100561,
 163512319,
 162662681,
 -1,
 -63041,
 163385049,
 100560,
 -63040,
 163450458,
 100559,
 -63039,
 163515828,
 100558,
 -63038,
 163581212,
 100557,
 -63037,
 163646578,
 100556,
 -63036,
 163711958,
 100555,
 -63035,
 163777309,
 100554,
 -63034,
 163842629,
 100553,
 -63033,
 163908009,
 100552,
 -1,
 163973401,
 100551,
 164170295,
 156830121,
 -1,
 164235732,
 164105945,
 -1,
 -63029,
 164171481,
 100550,
 -63028,
 164236890,
 100549,
 -63027,
 164302260,
 100548,
 -63026,
 164367644,
 100547,
 -63025,
 164433010,
 100546,
 -63024,
 164498390,
 100545,
 -63023,
 164563741,
 100544,
 -63022,
 164629061,
 100543,
 -63021,
 164694441,
 100542,
 -1,
 164759833,
 100541,
 164956639,
 164171354,
 -1,
 -63018,
 164892377,
 100540,
 -63017,
 164957786,
 100539,
 -63016,
 165023156,
 100538,
 -63015,
 165088540,
 100537,
 -63014,
 165153906,
 100536,
 -63013,
 165219286,
 100535,
 -63012,
 165284637,
 100534,
 -63011,
 165349957,
 100533,
 -63010,
 165415337,
 100532,
 -1,
 165480729,
 100531,
 165677546,
 164892084,
 -1,
 -63007,
 165613273,
 100530,
 -63006,
 165678682,
 100529,
 -63005,
 165744052,
 100528,
 -63004,
 165809436,
 100527,
 -63003,
 165874802,
 100526,
 -63002,
 165940182,
 100525,
 -63001,
 166005533,
 100524,
 -63000,
 166070853,
 100523,
 -62999,
 166136233,
 100522,
 -1,
 166201625,
 100521,
 166398453,
 165612828,
 -1,
 -62996,
 166334169,
 100520,
 -62995,
 166399578,
 100519,
 -62994,
 166464948,
 100518,
 -62993,
 166530332,
 100517,
 -62992,
 166595698,
 100516,
 -62991,
 166661078,
 100515,
 -62990,
 166726429,
 100514,
 -62989,
 166791749,
 100513,
 -62988,
 166857129,
 100512,
 -1,
 166922521,
 100511,
 167119360,
 166333554,
 -1,
 -62985,
 167055065,
 100510,
 -62984,
 167120474,
 100509,
 -62983,
 167185844,
 100508,
 -62982,
 167251228,
 100507,
 -62981,
 167316594,
 100506,
 -62980,
 167381974,
 100505,
 -62979,
 167447325,
 100504,
 -62978,
 167512645,
 100503,
 -62977,
 167578025,
 100502,
 -1,
 167643417,
 100501,
 167840267,
 167054294,
 -1,
 -62974,
 167775961,
 100500,
 -62973,
 167841370,
 100499,
 -62972,
 167906740,
 100498,
 -62971,
 167972124,
 100497,
 -62970,
 168037490,
 100496,
 -62969,
 168102870,
 100495,
 -62968,
 168168221,
 100494,
 -62967,
 168233541,
 100493,
 -62966,
 168298921,
 100492,
 -1,
 168364313,
 100491,
 168561174,
 167775005,
 -1,
 -62963,
 168496857,
 100490,
 -62962,
 168562266,
 100489,
 -62961,
 168627636,
 100488,
 -62960,
 168693020,
 100487,
 -62959,
 168758386,
 100486,
 -62958,
 168823766,
 100485,
 -62957,
 168889117,
 100484,
 -62956,
 168954437,
 100483,
 -62955,
 169019817,
 100482,
 -1,
 169085209,
 100481,
 169282081,
 168495685,
 -1,
 -62952,
 169217753,
 100480,
 -62951,
 169283162,
 100479,
 -62950,
 169348532,
 100478,
 -62949,
 169413916,
 100477,
 -62948,
 169479282,
 100476,
 -62947,
 169544662,
 100475,
 -62946,
 169610013,
 100474,
 -62945,
 169675333,
 100473,
 -62944,
 169740713,
 100472,
 -1,
 169806105,
 100471,
 170002988,
 169216425,
 -1,
 -62941,
 169938649,
 100470,
 -62940,
 170004058,
 100469,
 -62939,
 170069428,
 100468,
 -62938,
 170134812,
 100467,
 -62937,
 170200178,
 100466,
 -62936,
 170265558,
 100465,
 -62935,
 170330909,
 100464,
 -62934,
 170396229,
 100463,
 -62933,
 170461609,
 100462,
 -1,
 170527001,
 100461,
 170786815,
 169937177,
 -1,
 -62930,
 170659545,
 100460,
 -62929,
 170724954,
 100459,
 -62928,
 170790324,
 100458,
 -62927,
 170855708,
 100457,
 -62926,
 170921074,
 100456,
 -62925,
 170986454,
 100455,
 -62924,
 171051805,
 100454,
 -62923,
 171117125,
 100453,
 -62922,
 171182505,
 100452,
 -1,
 171247897,
 100451,
 171444901,
 164104473,
 -1,
 171510339,
 171380441,
 -1,
 -62918,
 171445977,
 100450,
 -62917,
 171511386,
 100449,
 -62916,
 171576756,
 100448,
 -62915,
 171642140,
 100447,
 -62914,
 171707506,
 100446,
 -62913,
 171772886,
 100445,
 -62912,
 171838237,
 100444,
 -62911,
 171903557,
 100443,
 -62910,
 171968937,
 100442,
 -1,
 172034329,
 100441,
 172231246,
 171445850,
 -1,
 -62907,
 172166873,
 100440,
 -62906,
 172232282,
 100439,
 -62905,
 172297652,
 100438,
 -62904,
 172363036,
 100437,
 -62903,
 172428402,
 100436,
 -62902,
 172493782,
 100435,
 -62901,
 172559133,
 100434,
 -62900,
 172624453,
 100433,
 -62899,
 172689833,
 100432,
 -1,
 172755225,
 100431,
 172952153,
 172166580,
 -1,
 -62896,
 172887769,
 100430,
 -62895,
 172953178,
 100429,
 -62894,
 173018548,
 100428,
 -62893,
 173083932,
 100427,
 -62892,
 173149298,
 100426,
 -62891,
 173214678,
 100425,
 -62890,
 173280029,
 100424,
 -62889,
 173345349,
 100423,
 -62888,
 173410729,
 100422,
 -1,
 173476121,
 100421,
 173673060,
 172887324,
 -1,
 -62885,
 173608665,
 100420,
 -62884,
 173674074,
 100419,
 -62883,
 173739444,
 100418,
 -62882,
 173804828,
 100417,
 -62881,
 173870194,
 100416,
 -62880,
 173935574,
 100415,
 -62879,
 174000925,
 100414,
 -62878,
 174066245,
 100413,
 -62877,
 174131625,
 100412,
 -1,
 174197017,
 100411,
 174393967,
 173608050,
 -1,
 -62874,
 174329561,
 100410,
 -62873,
 174394970,
 100409,
 -62872,
 174460340,
 100408,
 -62871,
 174525724,
 100407,
 -62870,
 174591090,
 100406,
 -62869,
 174656470,
 100405,
 -62868,
 174721821,
 100404,
 -62867,
 174787141,
 100403,
 -62866,
 174852521,
 100402,
 -1,
 174917913,
 100401,
 175114874,
 174328790,
 -1,
 -62863,
 175050457,
 100400,
 -62862,
 175115866,
 100399,
 -62861,
 175181236,
 100398,
 -62860,
 175246620,
 100397,
 -62859,
 175311986,
 100396,
 -62858,
 175377366,
 100395,
 -62857,
 175442717,
 100394,
 -62856,
 175508037,
 100393,
 -62855,
 175573417,
 100392,
 -1,
 175638809,
 100391,
 175835781,
 175049501,
 -1,
 -62852,
 175771353,
 100390,
 -62851,
 175836762,
 100389,
 -62850,
 175902132,
 100388,
 -62849,
 175967516,
 100387,
 -62848,
 176032882,
 100386,
 -62847,
 176098262,
 100385,
 -62846,
 176163613,
 100384,
 -62845,
 176228933,
 100383,
 -62844,
 176294313,
 100382,
 -1,
 176359705,
 100381,
 176556688,
 175770181,
 -1,
 -62841,
 176492249,
 100380,
 -62840,
 176557658,
 100379,
 -62839,
 176623028,
 100378,
 -62838,
 176688412,
 100377,
 -62837,
 176753778,
 100376,
 -62836,
 176819158,
 100375,
 -62835,
 176884509,
 100374,
 -62834,
 176949829,
 100373,
 -62833,
 177015209,
 100372,
 -1,
 177080601,
 100371,
 177277595,
 176490921,
 -1,
 -62830,
 177213145,
 100370,
 -62829,
 177278554,
 100369,
 -62828,
 177343924,
 100368,
 -62827,
 177409308,
 100367,
 -62826,
 177474674,
 100366,
 -62825,
 177540054,
 100365,
 -62824,
 177605405,
 100364,
 -62823,
 177670725,
 100363,
 -62822,
 177736105,
 100362,
 -1,
 177801497,
 100361,
 178061311,
 177211673,
 -1,
 -62819,
 177934041,
 100360,
 -62818,
 177999450,
 100359,
 -62817,
 178064820,
 100358,
 -62816,
 178130204,
 100357,
 -62815,
 178195570,
 100356,
 -62814,
 178260950,
 100355,
 -62813,
 178326301,
 100354,
 -62812,
 178391621,
 100353,
 -1,
 178457001,
 100352,
 178716671,
 171380148,
 -1,
 178719409,
 178588630,
 -1,
 -62808,
 178654937,
 101100,
 -62807,
 178720346,
 101099,
 -62806,
 178785716,
 101098,
 -62805,
 178851100,
 101097,
 -62804,
 178916466,
 101096,
 -62803,
 178981846,
 101095,
 -62802,
 179047197,
 101094,
 -62801,
 179112517,
 101093,
 -62800,
 179177897,
 101092,
 -1,
 179243289,
 101091,
 179440316,
 178653981,
 -1,
 -62797,
 179375833,
 101090,
 -62796,
 179441242,
 101089,
 -62795,
 179506612,
 101088,
 -62794,
 179571996,
 101087,
 -62793,
 179637362,
 101086,
 -62792,
 179702742,
 101085,
 -62791,
 179768093,
 101084,
 -62790,
 179833413,
 101083,
 -62789,
 179898793,
 101082,
 -1,
 179964185,
 101081,
 180161223,
 179374661,
 -1,
 -62786,
 180096729,
 101080,
 -62785,
 180162138,
 101079,
 -62784,
 180227508,
 101078,
 -62783,
 180292892,
 101077,
 -62782,
 180358258,
 101076,
 -62781,
 180423638,
 101075,
 -62780,
 180488989,
 101074,
 -62779,
 180554309,
 101073,
 -62778,
 180619689,
 101072,
 -1,
 180685081,
 101071,
 180882130,
 180095401,
 -1,
 -62775,
 180817625,
 101070,
 -62774,
 180883034,
 101069,
 -62773,
 180948404,
 101068,
 -62772,
 181013788,
 101067,
 -62771,
 181079154,
 101066,
 -62770,
 181144534,
 101065,
 -62769,
 181209885,
 101064,
 -62768,
 181275205,
 101063,
 -62767,
 181340585,
 101062,
 -1,
 181405977,
 101061,
 181603037,
 180816153,
 -1,
 -62764,
 181538521,
 101060,
 -62763,
 181603930,
 101059,
 -62762,
 181669300,
 101058,
 -62761,
 181734684,
 101057,
 -62760,
 181800050,
 101056,
 -62759,
 181865430,
 101055,
 -62758,
 181930781,
 101054,
 -62757,
 181996101,
 101053,
 -62756,
 182061481,
 101052,
 -1,
 182126873,
 101051,
 182386687,
 181537906,
 -1,
 -62753,
 182258802,
 101106,
 -62752,
 182324182,
 101105,
 -62751,
 182389533,
 101104,
 -62750,
 182454853,
 101103,
 -62749,
 182520233,
 101102,
 -1,
 182585625,
 101101,
 -1,
 127683421,
 94176,
 -1,
 127611493,
 127818,
 -1,
 127537131,
 127883,
 182979717,
 127491256,
 -1,
 183045183,
 182942948,
 -1,
 183110691,
 183017081,
 -1,
 183175979,
 183066239,
 -1,
 183241477,
 183131775,
 -1,
 183307001,
 183197311,
 -1,
 183372529,
 183242596,
 -1,
 -62737,
 183340575,
 983864,
 -62736,
 183386762,
 983861,
 -1,
 183439204,
 983854,
 183634675,
 183340575,
 983857,
 -1,
 183602719,
 983858,
 183765749,
 183591915,
 983862,
 -1,
 183722987,
 983863,
 183896823,
 183714442,
 983855,
 -1,
 183845514,
 983856,
 184090623,
 183839915,
 983859,
 -1,
 183970987,
 983860,
 184158973,
 183242596,
 -1,
 -62725,
 184127007,
 983732,
 -62724,
 184173194,
 983729,
 -1,
 184225636,
 983722,
 184421119,
 184127007,
 983725,
 -1,
 184389151,
 983726,
 184552193,
 184378347,
 983730,
 -1,
 184509419,
 983731,
 184683267,
 184500874,
 983723,
 -1,
 184631946,
 983724,
 184877055,
 184626347,
 983727,
 -1,
 184757419,
 983728,
 184945426,
 183213291,
 -1,
 185010954,
 184880996,
 -1,
 -62712,
 184978975,
 983710,
 -62711,
 185025162,
 983707,
 -1,
 185077604,
 983700,
 185273100,
 184978975,
 983703,
 -1,
 185241119,
 983704,
 185404174,
 185230315,
 983708,
 -1,
 185361387,
 983709,
 185535248,
 185352842,
 983701,
 -1,
 185483914,
 983702,
 185729023,
 185478315,
 983705,
 -1,
 185609387,
 983706,
 185797407,
 184891750,
 -1,
 185862935,
 185732964,
 -1,
 -62699,
 185830943,
 983688,
 -62698,
 185877130,
 983685,
 -1,
 185929572,
 983678,
 186125081,
 185830943,
 983681,
 -1,
 186093087,
 983682,
 186256155,
 186082283,
 983686,
 -1,
 186213355,
 983687,
 186387229,
 186204810,
 983679,
 -1,
 186335882,
 983680,
 186580991,
 186330283,
 983683,
 -1,
 186461355,
 983684,
 186649379,
 185732964,
 -1,
 -62687,
 186617375,
 983754,
 -62686,
 186663562,
 983751,
 -1,
 186716004,
 983744,
 186911525,
 186617375,
 983747,
 -1,
 186879519,
 983748,
 187042599,
 186868715,
 983752,
 -1,
 186999787,
 983753,
 187173673,
 186991242,
 983745,
 -1,
 187122314,
 983746,
 187367423,
 187116715,
 983749,
 -1,
 187247787,
 983750,
 187435859,
 183139556,
 -1,
 187501370,
 187382933,
 -1,
 187566897,
 187436900,
 -1,
 -62673,
 187534879,
 983886,
 -62672,
 187581066,
 983883,
 -1,
 187633508,
 983876,
 187829043,
 187534879,
 983879,
 -1,
 187797023,
 983880,
 187960117,
 187786219,
 983884,
 -1,
 187917291,
 983885,
 188091191,
 187908746,
 983877,
 -1,
 188039818,
 983878,
 188222265,
 188034219,
 983881,
 -1,
 188165291,
 983882,
 -1,
 188184992,
 983932,
 188418887,
 187464932,
 -1,
 188484415,
 188354404,
 -1,
 -62659,
 188452383,
 983897,
 -62658,
 188498570,
 983894,
 -1,
 188551012,
 983887,
 188746561,
 188452383,
 983890,
 -1,
 188714527,
 983891,
 188877635,
 188703723,
 983895,
 -1,
 188834795,
 983896,
 189008709,
 188826250,
 983888,
 -1,
 188957322,
 983889,
 189202431,
 188951723,
 983892,
 -1,
 189082795,
 983893,
 189270859,
 188354404,
 -1,
 -62647,
 189238815,
 983908,
 -62646,
 189285002,
 983905,
 -1,
 189337444,
 983898,
 189533005,
 189238815,
 983901,
 -1,
 189500959,
 983902,
 189664079,
 189490155,
 983906,
 -1,
 189621227,
 983907,
 189795153,
 189612682,
 983899,
 -1,
 189743754,
 983900,
 189988863,
 189738155,
 983903,
 -1,
 189869227,
 983904,
 190057338,
 187387852,
 -1,
 190122862,
 190009292,
 -1,
 190188386,
 190074828,
 -1,
 190253914,
 190123876,
 -1,
 -62632,
 190221855,
 983831,
 -62631,
 190268042,
 983828,
 -1,
 190320484,
 983821,
 190516060,
 190221855,
 983824,
 -1,
 190483999,
 983825,
 190647134,
 190473195,
 983829,
 -1,
 190604267,
 983830,
 190778208,
 190595722,
 983822,
 -1,
 190726794,
 983823,
 190971903,
 190721195,
 983826,
 -1,
 190852267,
 983827,
 191040358,
 190123876,
 -1,
 -62620,
 191008287,
 983842,
 -62619,
 191054474,
 983839,
 -1,
 191106916,
 983832,
 191302504,
 191008287,
 983835,
 -1,
 191270431,
 983836,
 191433578,
 191259627,
 983840,
 -1,
 191390699,
 983841,
 191564652,
 191382154,
 983833,
 -1,
 191513226,
 983834,
 191758335,
 191507627,
 983837,
 -1,
 191638699,
 983838,
 191826802,
 190058340,
 -1,
 -62608,
 191794719,
 983809,
 -62607,
 191840906,
 983806,
 -1,
 191893348,
 983799,
 192088948,
 191794719,
 983802,
 -1,
 192056863,
 983803,
 192220022,
 192046059,
 983807,
 -1,
 192177131,
 983808,
 192351096,
 192168586,
 983800,
 -1,
 192299658,
 983801,
 192544767,
 192294059,
 983804,
 -1,
 192425131,
 983805,
 192613268,
 190008707,
 -1,
 192678792,
 192578514,
 -1,
 192744320,
 192614244,
 983920,
 -62594,
 192712223,
 983931,
 -62593,
 192758410,
 983928,
 -1,
 192810852,
 983921,
 193006466,
 192712223,
 983924,
 -1,
 192974367,
 983925,
 193137540,
 192963563,
 983929,
 -1,
 193094635,
 983930,
 193268614,
 193086090,
 983922,
 -1,
 193217162,
 983923,
 193462271,
 193211563,
 983926,
 -1,
 193342635,
 983927,
 193530764,
 192614244,
 -1,
 -62582,
 193498655,
 983677,
 -62581,
 193544842,
 983674,
 -1,
 193597284,
 983667,
 193792910,
 193498655,
 983670,
 -1,
 193760799,
 983671,
 193923984,
 193749995,
 983675,
 -1,
 193881067,
 983676,
 194055058,
 193872522,
 983668,
 -1,
 194003594,
 983669,
 194248703,
 193997995,
 983672,
 -1,
 194129067,
 983673,
 194317230,
 192579171,
 -1,
 194382754,
 194283107,
 -1,
 194448282,
 194318180,
 -1,
 -62568,
 194416159,
 983721,
 -62567,
 194462346,
 983718,
 -1,
 194514788,
 983711,
 194710428,
 194416159,
 983714,
 -1,
 194678303,
 983715,
 194841502,
 194667499,
 983719,
 -1,
 194798571,
 983720,
 194972576,
 194790026,
 983712,
 -1,
 194921098,
 983713,
 195166207,
 194915499,
 983716,
 -1,
 195046571,
 983717,
 195234726,
 194318180,
 -1,
 -62556,
 195202591,
 983743,
 -62555,
 195248778,
 983740,
 -1,
 195301220,
 983733,
 195496872,
 195202591,
 983736,
 -1,
 195464735,
 983737,
 195627946,
 195453931,
 983741,
 -1,
 195585003,
 983742,
 195759020,
 195576458,
 983734,
 -1,
 195707530,
 983735,
 195952639,
 195701931,
 983738,
 -1,
 195833003,
 983739,
 196021192,
 194278313,
 -1,
 196086716,
 195982249,
 -1,
 196152244,
 196022116,
 -1,
 -62542,
 196120095,
 983853,
 -62541,
 196166282,
 983850,
 -1,
 196218724,
 983843,
 196414390,
 196120095,
 983846,
 -1,
 196382239,
 983847,
 196545464,
 196371435,
 983851,
 -1,
 196502507,
 983852,
 196676538,
 196493962,
 983844,
 -1,
 196625034,
 983845,
 196870143,
 196619435,
 983848,
 -1,
 196750507,
 983849,
 196938688,
 196022116,
 -1,
 -62530,
 196906527,
 983798,
 -62529,
 196952714,
 983795,
 -1,
 197005156,
 983788,
 197200834,
 196906527,
 983791,
 -1,
 197168671,
 983792,
 197331908,
 197157867,
 983796,
 -1,
 197288939,
 983797,
 197462982,
 197280394,
 983789,
 -1,
 197411466,
 983790,
 197656575,
 197405867,
 983793,
 -1,
 197536939,
 983794,
 197725141,
 195992811,
 -1,
 197790669,
 197660516,
 -1,
 -62517,
 197758495,
 983787,
 -62516,
 197804682,
 983784,
 -1,
 197857124,
 983777,
 198052815,
 197758495,
 983780,
 -1,
 198020639,
 983781,
 198183889,
 198009835,
 983785,
 -1,
 198140907,
 983786,
 198314963,
 198132362,
 983778,
 -1,
 198263434,
 983779,
 198508543,
 198257835,
 983782,
 -1,
 198388907,
 983783,
 198577122,
 197694455,
 -1,
 198642650,
 198512484,
 -1,
 -62504,
 198610463,
 983820,
 -62503,
 198656650,
 983817,
 -1,
 198709092,
 983810,
 198904796,
 198610463,
 983813,
 -1,
 198872607,
 983814,
 199035870,
 198861803,
 983818,
 -1,
 198992875,
 983819,
 199166944,
 198984330,
 983811,
 -1,
 199115402,
 983812,
 199360511,
 199109803,
 983815,
 -1,
 199240875,
 983816,
 199429103,
 198536376,
 -1,
 199494631,
 199364452,
 -1,
 -62491,
 199462431,
 983765,
 -62490,
 199508618,
 983762,
 -1,
 199561060,
 983755,
 199756777,
 199462431,
 983758,
 -1,
 199724575,
 983759,
 199887851,
 199713771,
 983763,
 -1,
 199844843,
 983764,
 200018925,
 199836298,
 983756,
 -1,
 199967370,
 983757,
 200212479,
 199961771,
 983760,
 -1,
 200092843,
 983761,
 200281084,
 199383331,
 -1,
 200346612,
 200216420,
 -1,
 -62478,
 200314399,
 983776,
 -62477,
 200360586,
 983773,
 -1,
 200413028,
 983766,
 200608758,
 200314399,
 983769,
 -1,
 200576543,
 983770,
 200739832,
 200565739,
 983774,
 -1,
 200696811,
 983775,
 200870906,
 200688266,
 983767,
 -1,
 200819338,
 983768,
 201064447,
 200813739,
 983771,
 -1,
 200944811,
 983772,
 201133065,
 200232117,
 -1,
 201198593,
 201068388,
 -1,
 -62465,
 201166367,
 983875,
 -62464,
 201212554,
 983872,
 -1,
 201264996,
 983865,
 201460739,
 201166367,
 983868,
 -1,
 201428511,
 983869,
 201591813,
 201417707,
 983873,
 -1,
 201548779,
 983874,
 201722887,
 201540234,
 983866,
 -1,
 201671306,
 983867,
 201916415,
 201665707,
 983870,
 -1,
 201796779,
 983871,
 201985046,
 201079957,
 -1,
 202050574,
 201920356,
 -1,
 -62452,
 202018335,
 983919,
 -62451,
 202064522,
 983916,
 -1,
 202116964,
 983909,
 202312720,
 202018335,
 983912,
 -1,
 202280479,
 983913,
 202443794,
 202269675,
 983917,
 -1,
 202400747,
 983918,
 202574868,
 202392202,
 983910,
 -1,
 202523274,
 983911,
 202768383,
 202517675,
 983914,
 -1,
 202648747,
 983915,
 202899455,
 201924102,
 -1,
 202902555,
 202772324,
 -1,
 -62439,
 202870303,
 983699,
 -62438,
 202916490,
 983696,
 -1,
 202968932,
 983689,
 203164701,
 202870303,
 983692,
 -1,
 203132447,
 983693,
 203295775,
 203121643,
 983697,
 -1,
 203252715,
 983698,
 203426849,
 203244170,
 983690,
 -1,
 203375242,
 983691,
 203620351,
 203369643,
 983694,
 -1,
 203500715,
 983695,
 203689020,
 183059779,
 -1,
 203754538,
 203648184,
 -1,
 203820073,
 203689828,
 -1,
 -62425,
 203786344,
 73691,
 -62424,
 203841293,
 73694,
 -1,
 203888004,
 73697,
 -1,
 203777615,
 73695,
 204147759,
 203723767,
 -1,
 204213294,
 204083044,
 -1,
 -62419,
 204174356,
 73696,
 -1,
 204230128,
 73713,
 -1,
 204156930,
 73699,
 204475443,
 204103233,
 -1,
 -62415,
 204444642,
 73689,
 -62414,
 204507247,
 73712,
 -1,
 204558117,
 73692,
 204737592,
 204426627,
 -1,
 204803127,
 204705311,
 -1,
 -62410,
 204775415,
 73698,
 -1,
 204831945,
 73690,
 -1,
 204738485,
 73693,
 -62407,
 204706799,
 73688,
 -62406,
 205021284,
 73685,
 -62405,
 205070337,
 73686,
 -1,
 205131734,
 73687,
 -62403,
 203655050,
 73711,
 -62402,
 205287097,
 73708,
 -1,
 205329117,
 73703,
 205524058,
 182984198,
 -1,
 205589593,
 205481955,
 -1,
 205655110,
 205545087,
 983650,
 205720644,
 205610623,
 983648,
 -1,
 205676159,
 983660,
 -62395,
 205692139,
 983646,
 -1,
 205797734,
 983644,
 205982793,
 205618404,
 983664,
 -62392,
 205946084,
 983663,
 -1,
 205995157,
 983662,
 206179404,
 205934540,
 983655,
 206307327,
 206131148,
 983658,
 -1,
 206196684,
 983657,
 206376014,
 206145123,
 983649,
 -1,
 206341731,
 983647,
 206507088,
 206336937,
 983654,
 -1,
 206468009,
 983659,
 206638162,
 206458243,
 983643,
 -1,
 206603218,
 983666,
 -62381,
 206609643,
 983653,
 -62380,
 206738423,
 983656,
 -62379,
 206793912,
 983651,
 -62378,
 206854435,
 983652,
 -62377,
 206916789,
 983661,
 -62376,
 206978197,
 983665,
 -1,
 207035910,
 983645,
 -1,
 205558540,
 73706,
 207293562,
 205469845,
 -1,
 207359090,
 207251121,
 -1,
 207424610,
 207324771,
 -1,
 207490144,
 207371413,
 -1,
 -62369,
 207451749,
 73664,
 -1,
 207506063,
 73669,
 -62367,
 207460442,
 73672,
 -1,
 207630657,
 73675,
 207817831,
 207389152,
 -1,
 207883366,
 207761067,
 -1,
 -62363,
 207817285,
 73674,
 -1,
 207882665,
 73673,
 -1,
 207854918,
 73667,
 208145514,
 207764830,
 -1,
 -62359,
 208079429,
 73682,
 -1,
 208144809,
 73681,
 208342125,
 208090295,
 -1,
 -62356,
 208300439,
 73668,
 -1,
 208356397,
 73679,
 208538736,
 208285534,
 -1,
 -62353,
 208487443,
 73666,
 -1,
 208551061,
 73676,
 -62351,
 208499453,
 73680,
 -1,
 208693072,
 73665,
 208866425,
 207325446,
 -1,
 208931958,
 208830944,
 -1,
 -62347,
 208903503,
 73671,
 -1,
 208940722,
 73678,
 -62345,
 208899462,
 73677,
 -62344,
 209089339,
 73683,
 -1,
 209137562,
 73670,
 -1,
 208808825,
 73684,
 209390719,
 207259235,
 -1,
 209456254,
 209351714,
 -1,
 -62339,
 209413012,
 73705,
 -1,
 209462488,
 73704,
 -1,
 209414612,
 73709,
 -62336,
 209361068,
 73700,
 -62335,
 209678850,
 73727,
 -62334,
 209735880,
 73702,
 -62333,
 209798718,
 73710,
 -62332,
 209857588,
 73701,
 -1,
 209916949,
 73707,
 210111713,
 182930819,
 -1,
 210177248,
 210073501,
 -1,
 210242753,
 210130073,
 -1,
 210308237,
 210177892,
 71296,
 -62326,
 210275871,
 71305,
 -62325,
 210335051,
 71352,
 -62324,
 210387594,
 71303,
 -1,
 210440036,
 71297,
 210635923,
 210273891,
 -1,
 210701457,
 210601571,
 -1,
 -62320,
 210648227,
 71317,
 -1,
 210702180,
 71316,
 -62318,
 210648227,
 71322,
 -1,
 210833252,
 71321,
 211029144,
 210591359,
 -1,
 -62315,
 211000665,
 71315,
 -62314,
 211050200,
 71320,
 -62313,
 211106207,
 71310,
 -1,
 211160932,
 71325,
 211356830,
 210970210,
 -1,
 211422364,
 211297890,
 -1,
 -62309,
 211369123,
 71319,
 -1,
 211423076,
 71318,
 -62307,
 211369123,
 71324,
 -1,
 211554148,
 71323,
 211750048,
 211324447,
 71300,
 -1,
 211717663,
 71301,
 211881123,
 211713252,
 -1,
 -62302,
 211827875,
 71335,
 -1,
 211881828,
 71336,
 212077734,
 211841961,
 -1,
 -62299,
 212038653,
 71338,
 -1,
 212078436,
 71332,
 212274345,
 212036792,
 -1,
 -62296,
 212221091,
 71327,
 -1,
 212275044,
 71326,
 212470956,
 212225411,
 -1,
 -62293,
 212417699,
 71307,
 -1,
 212471652,
 71306,
 212667567,
 212421813,
 -1,
 -62290,
 212614307,
 71314,
 -1,
 212668260,
 71313,
 212864177,
 212615818,
 71298,
 -1,
 212812426,
 71299,
 212995252,
 212810086,
 -1,
 -62285,
 212941987,
 71309,
 -1,
 212995940,
 71308,
 213191863,
 212934150,
 -1,
 -62282,
 213138595,
 71312,
 -1,
 213192548,
 71311,
 213388474,
 213129408,
 -1,
 -62279,
 213335203,
 71329,
 -1,
 213389156,
 71328,
 -62277,
 213359961,
 71331,
 -62276,
 213554185,
 71334,
 -62275,
 213607403,
 71304,
 -62274,
 213670253,
 71330,
 -62273,
 213733406,
 71333,
 -62272,
 213793955,
 71337,
 -1,
 213855403,
 71302,
 214043855,
 210184451,
 -1,
 214109381,
 214009443,
 -1,
 -62268,
 214080258,
 71362,
 -1,
 214122850,
 71363,
 214305992,
 214072548,
 -1,
 -62265,
 214256685,
 71366,
 -1,
 214315975,
 71367,
 214502603,
 214250679,
 -1,
 -62262,
 214461154,
 71364,
 -1,
 214518671,
 71365,
 -62260,
 214474734,
 71360,
 -62259,
 214656685,
 71361,
 -62258,
 214720831,
 71369,
 -1,
 214773598,
 71368,
 214961370,
 214013668,
 -1,
 215026900,
 214896484,
 -1,
 -62254,
 214994463,
 71349,
 -62253,
 215040650,
 71347,
 -1,
 215093092,
 71341,
 215289046,
 214994463,
 71344,
 -1,
 215256607,
 71345,
 215420120,
 215237258,
 71342,
 -1,
 215368330,
 71343,
 -62247,
 215376875,
 71348,
 -1,
 215493803,
 71346,
 215744511,
 214925643,
 -1,
 215747806,
 215651811,
 -1,
 -62243,
 215711277,
 71340,
 -1,
 215774390,
 71350,
 -62241,
 215704436,
 71351,
 -1,
 215880969,
 71339,
 -1,
 210121080,
 129377,
 216141028,
 210065179,
 -1,
 -62237,
 216098477,
 119671,
 -1,
 216151698,
 119672,
 216337638,
 216078528,
 983061,
 -1,
 216289798,
 127955,
 -62233,
 216308869,
 128661,
 -62232,
 216428111,
 128429,
 -1,
 216474300,
 127790,
 216665455,
 127419018,
 -1,
 216730970,
 216626089,
 -1,
 216796505,
 216679011,
 -1,
 216861994,
 216749209,
 -1,
 216927476,
 216830967,
 -1,
 216993011,
 216884303,
 -1,
 217058545,
 216953769,
 70791,
 -1,
 217019305,
 70792,
 217251839,
 217010124,
 70793,
 -1,
 217141196,
 70794,
 -1,
 216928100,
 70827,
 217386234,
 216893027,
 -1,
 217451768,
 217351779,
 -1,
 -62217,
 217398435,
 70810,
 -1,
 217452388,
 70809,
 -62215,
 217398435,
 70815,
 -1,
 217583460,
 70814,
 217779455,
 217341567,
 -1,
 -62212,
 217750873,
 70808,
 -62211,
 217800408,
 70813,
 -62210,
 217856415,
 70803,
 -1,
 217911140,
 70818,
 218107141,
 217720418,
 -1,
 218172675,
 218048098,
 -1,
 -62206,
 218119331,
 70812,
 -1,
 218173284,
 70811,
 -62204,
 218119331,
 70817,
 -1,
 218304356,
 70816,
 218500361,
 218042212,
 70785,
 -62201,
 218467871,
 70798,
 -62200,
 218514058,
 70796,
 -1,
 218566500,
 70786,
 218762509,
 218463460,
 -1,
 -62197,
 218725758,
 70829,
 -62196,
 218774691,
 70828,
 -1,
 218828644,
 70830,
 219024655,
 218730015,
 70789,
 -1,
 218992159,
 70790,
 219155730,
 218983608,
 -1,
 -62191,
 219102371,
 70820,
 -1,
 219156324,
 70819,
 219352341,
 219106691,
 -1,
 -62188,
 219298979,
 70800,
 -1,
 219352932,
 70799,
 219548952,
 219303093,
 -1,
 -62185,
 219495587,
 70807,
 -1,
 219549540,
 70806,
 219745562,
 219497098,
 70787,
 -1,
 219693706,
 70788,
 219876637,
 219691366,
 -1,
 -62180,
 219823267,
 70802,
 -1,
 219877220,
 70801,
 220073248,
 219815430,
 -1,
 -62177,
 220019875,
 70805,
 -1,
 220073828,
 70804,
 220269859,
 220010688,
 -1,
 -62174,
 220216483,
 70822,
 -1,
 220270436,
 70821,
 -62172,
 220241241,
 70824,
 -62171,
 220427261,
 70825,
 -62170,
 220488683,
 70797,
 -62169,
 220551533,
 70823,
 -62168,
 220614686,
 70826,
 -62167,
 220675235,
 70831,
 -1,
 220736683,
 70795,
 220925245,
 216831716,
 -1,
 220990768,
 220894826,
 -1,
 221056302,
 220951465,
 70837,
 -1,
 221017001,
 70838,
 221249535,
 221007820,
 70839,
 -1,
 221138892,
 70840,
 221318452,
 220925796,
 -1,
 -62158,
 221285919,
 70846,
 -62157,
 221332106,
 70843,
 -1,
 221384548,
 70832,
 221580598,
 221285919,
 70835,
 -1,
 221548063,
 70836,
 221711673,
 221544646,
 -1,
 -62152,
 221668331,
 70845,
 -1,
 221719723,
 70842,
 221908283,
 221659786,
 70833,
 -1,
 221856394,
 70834,
 -62148,
 221864939,
 70844,
 -1,
 221981867,
 70841,
 222170443,
 220866819,
 -1,
 222235969,
 222135907,
 -1,
 -62144,
 222206722,
 70866,
 -1,
 222249314,
 70867,
 222432580,
 222199012,
 -1,
 -62141,
 222383149,
 70870,
 -1,
 222442439,
 70871,
 222629191,
 222377143,
 -1,
 -62138,
 222587618,
 70868,
 -1,
 222645135,
 70869,
 -62136,
 222601198,
 70864,
 -62135,
 222783149,
 70865,
 -62134,
 222847295,
 70873,
 -1,
 222900062,
 70872,
 223087956,
 222134603,
 -1,
 223153487,
 223057379,
 -1,
 -62130,
 223116845,
 70849,
 -1,
 223179958,
 70850,
 223350098,
 223088484,
 -1,
 -62127,
 223319052,
 70852,
 -1,
 223372227,
 70848,
 -62125,
 223306612,
 70851,
 -1,
 223485597,
 70847,
 223677783,
 223022948,
 -1,
 -62122,
 223633860,
 70784,
 -1,
 223680955,
 70854,
 -62120,
 223634898,
 70855,
 -1,
 223820935,
 70853,
 -1,
 216739311,
 128555,
 224071013,
 216668749,
 -1,
 224136545,
 224034020,
 -1,
 224202080,
 224104208,
 -1,
 -62114,
 224156383,
 3982,
 -62113,
 224219571,
 3981,
 -1,
 224282981,
 3983,
 -1,
 224150856,
 3980,
 224591871,
 224090711,
 -1,
 -62109,
 224496514,
 4058,
 -62108,
 224547418,
 4057,
 -1,
 224598880,
 983208,
 224791915,
 224015812,
 -1,
 224857449,
 224744725,
 -1,
 -62104,
 224814059,
 11623,
 -1,
 224865451,
 11622,
 -62102,
 224821011,
 11632,
 -1,
 224994202,
 11647,
 225185133,
 224737954,
 128005,
 -1,
 225116636,
 128047,
 -62098,
 225139683,
 9202,
 -1,
 225255995,
 127915,
 225447311,
 216611989,
 -1,
 225512835,
 225408574,
 -1,
 225578363,
 225443840,
 -1,
 225643895,
 225539357,
 -1,
 -62092,
 225605590,
 128487,
 -62091,
 225661594,
 128486,
 -62090,
 225712664,
 128485,
 -1,
 225775649,
 128484,
 -62088,
 225608558,
 128491,
 -62087,
 225931303,
 128962,
 -62086,
 225992823,
 128423,
 -1,
 226041334,
 128433,
 226295807,
 225511520,
 -1,
 226299266,
 226174564,
 -1,
 226364800,
 226265859,
 -1,
 -62081,
 226326911,
 11162,
 -1,
 226382828,
 11160,
 -62079,
 226326741,
 11161,
 -1,
 226513735,
 11163,
 -1,
 226242598,
 11835,
 226758026,
 225460874,
 -1,
 226823561,
 226713215,
 -1,
 226889096,
 226754560,
 -1,
 -62073,
 226852305,
 128936,
 -1,
 226901022,
 128929,
 -1,
 226840311,
 129300,
 -1,
 226784624,
 129353,
 227216781,
 226726070,
 -1,
 -62068,
 227185025,
 128077,
 -1,
 227224398,
 128078,
 -62066,
 227175096,
 128173,
 -1,
 227357291,
 127777,
 227544490,
 225407913,
 -1,
 227610008,
 227479396,
 -1,
 227675539,
 227563811,
 128650,
 -1,
 227606857,
 128651,
 227806614,
 227614214,
 -1,
 -62059,
 227773200,
 128668,
 -1,
 227823229,
 128434,
 -62057,
 227762962,
 11223,
 -1,
 227952170,
 128646,
 228134304,
 227558026,
 -1,
 228199838,
 228070485,
 -1,
 228265373,
 228167772,
 -1,
 -62052,
 228228285,
 128208,
 -1,
 228275910,
 128681,
 -1,
 228217397,
 128710,
 -62049,
 228159397,
 11851,
 -1,
 228468753,
 128305,
 228658599,
 228090859,
 -1,
 228724134,
 228617400,
 -1,
 228789669,
 228672381,
 -1,
 -62044,
 228734600,
 128032,
 -1,
 228797486,
 127865,
 -1,
 228737664,
 127942,
 -1,
 228677340,
 128654,
 229179391,
 228625951,
 -1,
 -62039,
 229072382,
 127930,
 -1,
 229125340,
 11231,
 229313987,
 227511839,
 -1,
 229379521,
 229274537,
 -1,
 229445053,
 229335057,
 -1,
 229510578,
 229407972,
 -1,
 229576113,
 229469093,
 -1,
 -62032,
 229546137,
 128597,
 -1,
 229584266,
 128599,
 -1,
 229519425,
 11829,
 229838263,
 229451362,
 -1,
 229903798,
 229786940,
 -1,
 -62027,
 229874434,
 8586,
 -1,
 229917026,
 8587,
 -1,
 229839260,
 11832,
 230165946,
 229794392,
 -1,
 -62023,
 230135961,
 128596,
 -1,
 230174090,
 128598,
 -62021,
 230122845,
 128399,
 -62020,
 230302495,
 11826,
 -1,
 230366142,
 11202,
 230559168,
 229395843,
 -1,
 -62017,
 230509226,
 8378,
 -1,
 230569125,
 129411,
 -1,
 230525578,
 128034,
 -62014,
 229333680,
 129347,
 -1,
 230774408,
 127799,
 230952411,
 229256363,
 -1,
 231017941,
 230903756,
 -1,
 231083470,
 230985749,
 -1,
 231149003,
 231047499,
 -1,
 231214538,
 231088890,
 -1,
 -62007,
 231153321,
 3072,
 -1,
 231216402,
 3076,
 -1,
 231178510,
 3191,
 231538687,
 231101593,
 -1,
 -62003,
 231439467,
 3162,
 -1,
 231495429,
 3124,
 231735295,
 231025835,
 -1,
 231738835,
 231632676,
 -1,
 231804370,
 231699925,
 128222,
 -1,
 231737224,
 128380,
 -1,
 231761521,
 128384,
 -61996,
 231708238,
 128250,
 -1,
 231964247,
 128301,
 232132056,
 230952804,
 -1,
 -61993,
 232092640,
 128198,
 -1,
 232138207,
 127861,
 -61991,
 232096868,
 129514,
 -61990,
 232284651,
 127934,
 -1,
 232335274,
 129528,
 232525290,
 230908907,
 -1,
 232590819,
 232484026,
 -1,
 232656354,
 232537251,
 -1,
 232721889,
 232609118,
 -1,
 -61984,
 232685194,
 11833,
 -1,
 232725374,
 11210,
 -1,
 232687203,
 127913,
 -1,
 232626794,
 128285,
 233049574,
 232547307,
 -1,
 -61979,
 233015375,
 129463,
 -1,
 233066926,
 129520,
 -61977,
 233005319,
 128069,
 -61976,
 233200280,
 127813,
 -61975,
 233263042,
 128508,
 -1,
 233326052,
 128701,
 233508340,
 232494870,
 -1,
 233573875,
 233464811,
 -1,
 233639410,
 233504768,
 -1,
 -61970,
 233610139,
 128109,
 -61969,
 233669486,
 128490,
 -61968,
 233724858,
 128108,
 -61967,
 233782990,
 128149,
 -1,
 233840118,
 128432,
 -1,
 233572478,
 11834,
 -1,
 233523978,
 128256,
 234225663,
 233441376,
 -1,
 -61962,
 234127541,
 128085,
 -1,
 234190708,
 129430,
 234361953,
 127359267,
 -1,
 234426434,
 234302635,
 -1,
 234491634,
 234380927,
 -1,
 234557168,
 234432470,
 -1,
 234622679,
 234522128,
 -1,
 234688106,
 234555673,
 -1,
 234753544,
 234622681,
 -1,
 -61953,
 234688294,
 125069,
 -61952,
 234753724,
 125123,
 -61951,
 234818998,
 124959,
 -61950,
 234884409,
 125036,
 -61949,
 234949782,
 124932,
 -61948,
 235015189,
 124952,
 -61947,
 235080508,
 125097,
 -61946,
 235145828,
 125088,
 -61945,
 235211280,
 124999,
 -1,
 235276642,
 125047,
 235474451,
 234688090,
 -1,
 -61942,
 235409115,
 124993,
 -61941,
 235474545,
 125024,
 -61940,
 235539933,
 125043,
 -61939,
 235605343,
 125056,
 -61938,
 235670779,
 125117,
 -61937,
 235736067,
 124985,
 -61936,
 235801411,
 125039,
 -61935,
 235866784,
 125049,
 -61934,
 235932160,
 125071,
 -1,
 235997580,
 125015,
 236195358,
 235408820,
 -1,
 -61931,
 236130096,
 124980,
 -61930,
 236195435,
 125021,
 -61929,
 236260916,
 125119,
 -61928,
 236326223,
 124933,
 -61927,
 236391559,
 125022,
 -61926,
 236456952,
 125089,
 -61925,
 236522350,
 124986,
 -61924,
 236587661,
 125080,
 -61923,
 236652996,
 125099,
 -1,
 236718384,
 125100,
 236916265,
 236129564,
 -1,
 -61920,
 236850997,
 125002,
 -61919,
 236916419,
 125068,
 -61918,
 236981766,
 125107,
 -61917,
 237047175,
 125074,
 -61916,
 237112475,
 124931,
 -61915,
 237177890,
 125108,
 -61914,
 237243231,
 125009,
 -61913,
 237308551,
 125076,
 -61912,
 237373979,
 124945,
 -1,
 237439344,
 125124,
 237637172,
 236850290,
 -1,
 -61909,
 237571820,
 124951,
 -61908,
 237637301,
 125121,
 -61907,
 237702683,
 125066,
 -61906,
 237767976,
 125095,
 -61905,
 237833429,
 125000,
 -61904,
 237898761,
 124987,
 -61903,
 237964106,
 125041,
 -61902,
 238029395,
 125044,
 -61901,
 238094843,
 125072,
 -1,
 238160254,
 125070,
 238358079,
 237571030,
 -1,
 -61898,
 238292794,
 124946,
 -61897,
 238358161,
 124934,
 -61896,
 238423538,
 125078,
 -61895,
 238488904,
 125046,
 -61894,
 238554373,
 124942,
 -61893,
 238619633,
 125090,
 -61892,
 238685066,
 125048,
 -61891,
 238750297,
 125037,
 -61890,
 238815691,
 125033,
 -1,
 238881090,
 125035,
 239078986,
 238291741,
 -1,
 -61887,
 239013664,
 125029,
 -61886,
 239079087,
 125028,
 -61885,
 239144490,
 125027,
 -61884,
 239209763,
 125020,
 -61883,
 239275138,
 125019,
 -61882,
 239340518,
 125018,
 -61881,
 239406005,
 125013,
 -61880,
 239471356,
 125012,
 -61879,
 239536677,
 125011,
 -1,
 239602003,
 125005,
 239799893,
 239012421,
 -1,
 -61876,
 239734497,
 125004,
 -61875,
 239799944,
 125003,
 -61874,
 239865325,
 124984,
 -61873,
 239930714,
 124983,
 -61872,
 239996065,
 124982,
 -61871,
 240061507,
 124998,
 -61870,
 240126873,
 124997,
 -61869,
 240192191,
 124996,
 -61868,
 240257547,
 124976,
 -1,
 240322947,
 124975,
 240520800,
 239733161,
 -1,
 -61865,
 240455467,
 124974,
 -61864,
 240520801,
 124992,
 -61863,
 240586171,
 124991,
 -61862,
 240651550,
 124990,
 -61861,
 240717042,
 124964,
 -61860,
 240782296,
 124963,
 -61859,
 240847702,
 124962,
 -61858,
 240912974,
 124957,
 -61857,
 240978351,
 124956,
 -1,
 241043745,
 124955,
 241303551,
 240453913,
 -1,
 -61854,
 241176313,
 124950,
 -61853,
 241241762,
 124949,
 -61852,
 241307136,
 124948,
 -61851,
 241372579,
 124938,
 -61850,
 241437952,
 124937,
 -61849,
 241503310,
 124936,
 -61848,
 241568612,
 124930,
 -61847,
 241633887,
 124929,
 -1,
 241699285,
 124928,
 241958911,
 234621353,
 -1,
 241962614,
 241831514,
 -1,
 -61843,
 241897202,
 124954,
 -61842,
 241962664,
 125079,
 -61841,
 242028025,
 125083,
 -61840,
 242093379,
 125034,
 -61839,
 242158838,
 125114,
 -61838,
 242224168,
 125065,
 -61837,
 242289528,
 125058,
 -61836,
 242354931,
 125113,
 -61835,
 242420148,
 124995,
 -1,
 242485542,
 124994,
 242683521,
 241896884,
 -1,
 -61832,
 242618086,
 124935,
 -61831,
 242683494,
 124973,
 -61830,
 242748962,
 125067,
 -61829,
 242814270,
 125032,
 -61828,
 242879654,
 125010,
 -61827,
 242945039,
 125082,
 -61826,
 243010473,
 125116,
 -61825,
 243075731,
 125081,
 -61824,
 243141126,
 125101,
 -1,
 243206519,
 125122,
 243404428,
 242617628,
 -1,
 -61821,
 243339034,
 125031,
 -61820,
 243404412,
 125061,
 -61819,
 243469782,
 125064,
 -61818,
 243535150,
 125063,
 -61817,
 243600592,
 124967,
 -61816,
 243665974,
 125120,
 -61815,
 243731241,
 124965,
 -61814,
 243796665,
 124977,
 -61813,
 243861978,
 125084,
 -1,
 243927373,
 125008,
 244125335,
 243338354,
 -1,
 -61810,
 244059915,
 125054,
 -61809,
 244125340,
 125093,
 -61808,
 244190695,
 125006,
 -61807,
 244256127,
 125052,
 -61806,
 244321420,
 125059,
 -61805,
 244386843,
 124953,
 -61804,
 244452211,
 124988,
 -61803,
 244517543,
 125109,
 -61802,
 244582934,
 125115,
 -1,
 244648219,
 124958,
 244846242,
 244059094,
 -1,
 -61799,
 244780819,
 125111,
 -61798,
 244846198,
 125096,
 -61797,
 244911664,
 124968,
 -61796,
 244977016,
 125051,
 -61795,
 245042364,
 125075,
 -61794,
 245107784,
 125118,
 -61793,
 245173167,
 124944,
 -61792,
 245238396,
 125086,
 -61791,
 245303855,
 125016,
 -1,
 245369160,
 125038,
 245567149,
 244779805,
 -1,
 -61788,
 245501760,
 124947,
 -61787,
 245567068,
 124961,
 -61786,
 245632453,
 124969,
 -61785,
 245697943,
 124979,
 -61784,
 245763217,
 124971,
 -61783,
 245828655,
 125112,
 -61782,
 245893942,
 125023,
 -61781,
 245959274,
 125087,
 -61780,
 246024656,
 124970,
 -1,
 246090044,
 125042,
 246288056,
 245500485,
 -1,
 -61777,
 246222591,
 125103,
 -61776,
 246288001,
 125040,
 -61775,
 246353427,
 125055,
 -61774,
 246418845,
 124939,
 -61773,
 246484162,
 125104,
 -61772,
 246549483,
 125094,
 -61771,
 246614916,
 125102,
 -61770,
 246680218,
 125077,
 -61769,
 246745642,
 125017,
 -1,
 246810985,
 125053,
 247008963,
 246221225,
 -1,
 -61766,
 246943493,
 125106,
 -61765,
 247008968,
 124940,
 -61764,
 247074317,
 125030,
 -61763,
 247139724,
 124978,
 -61762,
 247205064,
 125050,
 -61761,
 247270483,
 124941,
 -61760,
 247335770,
 125007,
 -61759,
 247401072,
 125092,
 -61758,
 247466431,
 125060,
 -1,
 247531864,
 124989,
 247729870,
 246941977,
 -1,
 -61755,
 247664454,
 125014,
 -61754,
 247729814,
 125091,
 -61753,
 247795152,
 125098,
 -61752,
 247860587,
 125057,
 -61751,
 247925936,
 125085,
 -61750,
 247991357,
 125001,
 -61749,
 248056607,
 124960,
 -61748,
 248122035,
 125073,
 -61747,
 248187321,
 125026,
 -1,
 248252716,
 124966,
 248512511,
 247664345,
 -1,
 -61744,
 248384970,
 125025,
 -61743,
 248450449,
 124981,
 -61742,
 248515700,
 124972,
 -61741,
 248581209,
 124943,
 -61740,
 248646480,
 125045,
 -61739,
 248711853,
 125110,
 -61738,
 248777189,
 125105,
 -1,
 248842550,
 125062,
 249040612,
 234563843,
 -1,
 249106139,
 249005667,
 -1,
 -61734,
 249076482,
 125128,
 -1,
 249119074,
 125129,
 249302750,
 249068772,
 -1,
 -61731,
 249252909,
 125132,
 -1,
 249312199,
 125133,
 249499361,
 249246903,
 -1,
 -61728,
 249457378,
 125130,
 -1,
 249514895,
 125131,
 -61726,
 249456301,
 125127,
 -61725,
 249651519,
 125135,
 -1,
 249704286,
 125134,
 249954303,
 248980229,
 -1,
 249958124,
 249857635,
 -1,
 250023659,
 249900203,
 -1,
 250089194,
 249978495,
 -1,
 -61719,
 250051812,
 125137,
 -1,
 250086688,
 125140,
 -1,
 250032381,
 125136,
 -1,
 249971029,
 125139,
 250416879,
 249905725,
 -1,
 -61714,
 250379492,
 125138,
 -1,
 250414368,
 125141,
 -1,
 250371291,
 125142,
 -61711,
 234519894,
 128697,
 -1,
 250636547,
 128334,
 250810260,
 234451881,
 -1,
 250875795,
 250766664,
 -1,
 250941293,
 250816031,
 -1,
 251006778,
 250897274,
 -1,
 251072265,
 250971747,
 -1,
 251137791,
 251041558,
 -1,
 251203325,
 251093995,
 68033,
 251330559,
 251133952,
 -1,
 251334396,
 251216445,
 68051,
 -1,
 251266326,
 68078,
 -1,
 251300068,
 68060,
 251592703,
 251146577,
 68042,
 -1,
 251462934,
 68069,
 251662087,
 251083925,
 -1,
 251727621,
 251622974,
 68034,
 251854847,
 251658240,
 -1,
 251858692,
 251740733,
 68052,
 -1,
 251790614,
 68079,
 -1,
 251824356,
 68061,
 252116991,
 251677322,
 68043,
 -1,
 251987222,
 68070,
 252248063,
 251605072,
 68041,
 -1,
 252118294,
 68068,
 252317464,
 251034852,
 -1,
 252382993,
 252267565,
 68037,
 252448527,
 252313600,
 -1,
 252514062,
 252396093,
 68055,
 -1,
 252445974,
 68082,
 -1,
 252479716,
 68064,
 252772351,
 252415491,
 68046,
 -1,
 252642582,
 68073,
 252903423,
 252326855,
 68038,
 252907286,
 252772352,
 -1,
 252972821,
 252854845,
 68056,
 -1,
 252904726,
 68083,
 -1,
 252938468,
 68065,
 253231103,
 252874243,
 68047,
 -1,
 253101334,
 68074,
 253300521,
 252261559,
 -1,
 253366049,
 253256683,
 -1,
 253431583,
 253334140,
 68035,
 253558783,
 253362176,
 -1,
 253562654,
 253444669,
 68053,
 -1,
 253494550,
 68080,
 -1,
 253528292,
 68062,
 253820927,
 253394080,
 68044,
 -1,
 253691158,
 68071,
 253951999,
 253313674,
 -1,
 253955879,
 253858863,
 68036,
 254083071,
 253886464,
 -1,
 254086950,
 253968957,
 68054,
 -1,
 254018838,
 68081,
 -1,
 254052580,
 68063,
 254345215,
 253901137,
 68045,
 -1,
 254215446,
 68072,
 254414639,
 253255999,
 68040,
 254480174,
 254345216,
 -1,
 254545709,
 254427709,
 68058,
 -1,
 254477590,
 68085,
 -1,
 254511332,
 68067,
 -1,
 254447110,
 68076,
 254807861,
 254357342,
 68039,
 254873396,
 254738432,
 -1,
 254938931,
 254820925,
 68057,
 -1,
 254870806,
 68084,
 -1,
 254904548,
 68066,
 -1,
 254844196,
 68075,
 255262719,
 254764717,
 68032,
 255328255,
 255131648,
 -1,
 255332153,
 255214141,
 68050,
 -1,
 255264022,
 68077,
 -1,
 255297764,
 68059,
 255528795,
 250957772,
 -1,
 255594328,
 255472425,
 -1,
 255659840,
 255559267,
 -1,
 -61634,
 255615979,
 68022,
 -61633,
 255667371,
 68021,
 -1,
 255725412,
 68020,
 255921987,
 255622372,
 -1,
 -61630,
 255863979,
 68017,
 -1,
 255922020,
 68015,
 256118598,
 255876735,
 -1,
 -61627,
 256060587,
 68010,
 -1,
 256118628,
 68009,
 256315209,
 256068995,
 -1,
 -61624,
 256261283,
 68013,
 -1,
 256315236,
 68018,
 256511819,
 256249700,
 68000,
 -1,
 256472406,
 68016,
 -61620,
 256482649,
 68004,
 -61619,
 256612142,
 68005,
 -61618,
 256668669,
 68011,
 -61617,
 256733815,
 68019,
 -61616,
 256797938,
 68007,
 -61615,
 256861163,
 68003,
 -61614,
 256924013,
 68008,
 -61613,
 256987166,
 68012,
 -61612,
 257049226,
 68002,
 -61611,
 257114018,
 68014,
 -61610,
 257174699,
 68001,
 -61609,
 257238766,
 68023,
 -1,
 257300689,
 68006,
 257556479,
 255550705,
 -1,
 -61606,
 257456952,
 68030,
 -1,
 257508886,
 68031,
 257753087,
 255473813,
 -1,
 257757024,
 257656419,
 -1,
 -61602,
 257727284,
 68087,
 -61601,
 257769934,
 68088,
 -1,
 257831039,
 68095,
 258019171,
 257719524,
 -1,
 -61598,
 257969230,
 68091,
 -1,
 258028501,
 68092,
 258215782,
 257975985,
 -1,
 -61595,
 258182510,
 68086,
 -1,
 258227499,
 68029,
 258412393,
 258159799,
 -1,
 -61592,
 258370367,
 68089,
 -1,
 258427885,
 68090,
 258609004,
 258354347,
 -1,
 -61589,
 258561351,
 68028,
 -1,
 258622662,
 68093,
 -1,
 258564429,
 68094,
 258932735,
 250888132,
 -1,
 258936721,
 258823321,
 -1,
 259002229,
 258901603,
 -1,
 259067762,
 258944171,
 67994,
 -1,
 259000418,
 67995,
 259198836,
 259002212,
 67992,
 -1,
 259131490,
 67993,
 -1,
 259154923,
 67996,
 259395450,
 258956927,
 -1,
 259460984,
 259337387,
 67980,
 -1,
 259393634,
 67981,
 259653631,
 259395428,
 67978,
 -1,
 259524706,
 67979,
 259723134,
 259357924,
 -1,
 259788669,
 259657572,
 67987,
 -1,
 259721314,
 67988,
 -1,
 259730603,
 67989,
 259985280,
 259683325,
 67982,
 -1,
 259917922,
 67983,
 260116355,
 259935619,
 -1,
 -61566,
 260062371,
 67985,
 -1,
 260116324,
 67990,
 260312965,
 260053201,
 67974,
 -1,
 260245602,
 67975,
 -61562,
 260283737,
 67972,
 -61561,
 260413230,
 67973,
 -61560,
 260469367,
 67991,
 -61559,
 260533490,
 67976,
 -61558,
 260596715,
 67971,
 -61557,
 260659565,
 67977,
 -61556,
 260722718,
 67984,
 -61555,
 260784778,
 67970,
 -61554,
 260849570,
 67986,
 -61553,
 260910251,
 67969,
 -61552,
 260974318,
 67997,
 -1,
 261033828,
 67968,
 261292031,
 258901583,
 67998,
 -1,
 261163106,
 67999,
 -1,
 250834688,
 129500,
 261427224,
 250750562,
 -1,
 261492738,
 261369558,
 -1,
 261558203,
 261455076,
 -1,
 261623738,
 261511696,
 -1,
 261689243,
 261578367,
 93819,
 -61542,
 261659883,
 93815,
 -1,
 261699942,
 983265,
 261885854,
 261623652,
 93805,
 -61539,
 261851782,
 93796,
 -1,
 261898890,
 93822,
 262082464,
 261856491,
 93823,
 -1,
 262049311,
 93811,
 262213538,
 262038507,
 93821,
 -1,
 262155435,
 93818,
 262344612,
 262163843,
 93804,
 -1,
 262302904,
 93798,
 262475686,
 262290581,
 983264,
 -1,
 262433976,
 93814,
 -61529,
 262446893,
 93797,
 -61528,
 262577194,
 93816,
 -61527,
 262641430,
 93795,
 -61526,
 262706167,
 93794,
 -61525,
 262770207,
 93810,
 -61524,
 262833763,
 93800,
 -61523,
 262896868,
 93793,
 -61522,
 262960041,
 93820,
 -61521,
 263025269,
 93813,
 -61520,
 263089336,
 93799,
 -61519,
 263149859,
 93792,
 -61518,
 263213004,
 93812,
 -61517,
 263277749,
 93806,
 -61516,
 263340682,
 93803,
 -61515,
 263403878,
 93801,
 -61514,
 263468215,
 93802,
 -61513,
 263531691,
 93807,
 -61512,
 263595618,
 93817,
 -61511,
 263659014,
 93809,
 -1,
 263723200,
 93808,
 -1,
 261594794,
 93849,
 263983072,
 261496326,
 -1,
 264048607,
 263918922,
 -1,
 264114112,
 264003199,
 93787,
 -61505,
 264084715,
 93783,
 -1,
 264124774,
 983263,
 264310723,
 264048484,
 93773,
 -61502,
 264276614,
 93764,
 -1,
 264323722,
 93790,
 264507333,
 264281323,
 93791,
 -1,
 264474143,
 93779,
 264638407,
 264463339,
 93789,
 -1,
 264580267,
 93786,
 264769481,
 264588675,
 93772,
 -1,
 264727736,
 93766,
 264900555,
 264715413,
 983262,
 -1,
 264858808,
 93782,
 -61492,
 264871725,
 93765,
 -61491,
 265002026,
 93784,
 -61490,
 265066262,
 93763,
 -61489,
 265130999,
 93762,
 -61488,
 265195039,
 93778,
 -61487,
 265258595,
 93768,
 -61486,
 265321700,
 93761,
 -61485,
 265384873,
 93788,
 -61484,
 265450101,
 93781,
 -61483,
 265514168,
 93767,
 -61482,
 265574691,
 93760,
 -61481,
 265637836,
 93780,
 -61480,
 265702581,
 93774,
 -61479,
 265765514,
 93771,
 -61478,
 265828710,
 93769,
 -61477,
 265893047,
 93770,
 -61476,
 265956523,
 93775,
 -61475,
 266020450,
 93785,
 -61474,
 266083846,
 93777,
 -1,
 266148032,
 93776,
 -1,
 264005184,
 93847,
 266407921,
 263923971,
 -1,
 266473446,
 266372707,
 -1,
 266538980,
 266443522,
 93826,
 -1,
 266469378,
 93845,
 266731519,
 266486114,
 93827,
 -1,
 266600450,
 93846,
 266801129,
 266435812,
 -1,
 -61464,
 266751021,
 93830,
 -1,
 266810311,
 93831,
 266997739,
 266757805,
 93825,
 -1,
 266928130,
 93844,
 267128814,
 266941623,
 -1,
 -61459,
 267086562,
 93828,
 -1,
 267144079,
 93829,
 -61457,
 267100142,
 93824,
 -61456,
 267280703,
 93833,
 -1,
 267333470,
 93832,
 267522048,
 266363770,
 -1,
 267587574,
 267486819,
 -1,
 -61452,
 267556923,
 93836,
 -61451,
 267599967,
 93837,
 -1,
 267661392,
 93834,
 267849721,
 267549924,
 -1,
 -61448,
 267799660,
 93840,
 -1,
 267858935,
 93841,
 268046332,
 267793591,
 -1,
 -61445,
 268004191,
 93838,
 -1,
 268059686,
 93839,
 268242943,
 267988139,
 -1,
 -61442,
 268195137,
 93835,
 -1,
 268256528,
 93842,
 -1,
 268198255,
 93843,
 -61439,
 267467100,
 93848,
 -1,
 268448888,
 93850,
 268697599,
 261440138,
 -1,
 268701719,
 268603532,
 -1,
 268767241,
 268664036,
 -1,
 268832776,
 268717104,
 -1,
 -61433,
 268796829,
 128950,
 -1,
 268857383,
 128971,
 -1,
 268768061,
 128938,
 269094926,
 268711095,
 -1,
 269160461,
 269052686,
 -1,
 -61428,
 269119314,
 128967,
 -1,
 269163483,
 128965,
 -1,
 269110233,
 128944,
 269422609,
 269060389,
 -1,
 -61424,
 269381458,
 128963,
 -1,
 269425627,
 128961,
 269619220,
 269365092,
 -1,
 -61421,
 269583261,
 128956,
 -1,
 269643815,
 128974,
 -61419,
 269588795,
 128911,
 -61418,
 269761566,
 128931,
 -1,
 269819025,
 128901,
 -1,
 268645308,
 11852,
 270078010,
 261370644,
 -1,
 270143529,
 270029977,
 -1,
 270209053,
 270109886,
 -1,
 -61412,
 270154915,
 43749,
 -1,
 270208868,
 43748,
 270405664,
 270171364,
 -1,
 -61409,
 270368126,
 43754,
 -1,
 270417059,
 43753,
 270602275,
 270360191,
 -1,
 -61406,
 270572889,
 43747,
 -1,
 270622424,
 43752,
 270798886,
 270542744,
 -1,
 -61403,
 270744739,
 43751,
 -1,
 270798692,
 43750,
 -61401,
 270754795,
 43745,
 -61400,
 270937259,
 43744,
 -1,
 270999603,
 43746,
 271192116,
 270111735,
 -1,
 271257651,
 271150182,
 -1,
 271323184,
 271191908,
 -1,
 271388719,
 271257444,
 -1,
 -61394,
 271355423,
 43759,
 -1,
 271401610,
 43757,
 -1,
 271355423,
 43758,
 -61391,
 271291974,
 43765,
 -61390,
 271619039,
 43756,
 -1,
 271664541,
 43755,
 -1,
 271206873,
 43766,
 271913015,
 271126372,
 -1,
 -61386,
 271868356,
 43762,
 -1,
 271924735,
 43761,
 -61384,
 271883187,
 43764,
 -61383,
 272074267,
 43763,
 -1,
 272113815,
 43760,
 272306237,
 270016567,
 -1,
 -61380,
 272258148,
 129471,
 -1,
 272307694,
 129470,
 -61378,
 272272538,
 128647,
 -61377,
 272466905,
 983172,
 -61376,
 272522555,
 128221,
 -61375,
 272586573,
 127816,
 -1,
 272635756,
 127830,
 272830996,
 234360676,
 -1,
 272896185,
 272785023,
 128104,
 272961674,
 272843674,
 -1,
 273027190,
 272913561,
 -1,
 273092684,
 272989412,
 -1,
 273158218,
 273026916,
 -1,
 -61367,
 273111970,
 68312,
 -1,
 273164460,
 68317,
 -61365,
 273121456,
 68323,
 -1,
 273301537,
 68322,
 273485904,
 273057379,
 -1,
 -61362,
 273431914,
 68309,
 -61361,
 273494816,
 68302,
 -1,
 273553539,
 68324,
 273748052,
 273420132,
 -1,
 -61358,
 273718840,
 68313,
 -61357,
 273765513,
 68288,
 -1,
 273815731,
 68314,
 274010199,
 273719085,
 -1,
 -61354,
 273956438,
 68298,
 -1,
 274012339,
 68297,
 274206810,
 273980458,
 -1,
 -61351,
 274163921,
 68319,
 -1,
 274208049,
 68305,
 274403421,
 274166389,
 -1,
 -61348,
 274360529,
 68318,
 -1,
 274415850,
 68320,
 274600032,
 274353539,
 -1,
 -61345,
 274546187,
 68306,
 -1,
 274601265,
 68304,
 274796643,
 274549941,
 -1,
 -61342,
 274742870,
 68300,
 -1,
 274798771,
 68299,
 274993253,
 274742879,
 68294,
 -1,
 274958415,
 68301,
 275124328,
 274938214,
 -1,
 -61337,
 275072517,
 68291,
 -1,
 275136539,
 68292,
 275320939,
 275064418,
 -1,
 -61334,
 275266922,
 68308,
 -1,
 275321494,
 68293,
 275517550,
 275257536,
 -1,
 -61331,
 275464067,
 68290,
 -1,
 275526432,
 68289,
 -61329,
 275488501,
 68303,
 -61328,
 275683297,
 68295,
 -61327,
 275740398,
 68321,
 -61326,
 275803724,
 68315,
 -61325,
 275866559,
 68311,
 -61324,
 275930029,
 68310,
 -61323,
 275992751,
 68307,
 -1,
 276051270,
 68316,
 276238463,
 272986564,
 -1,
 276303995,
 276179287,
 -1,
 276369530,
 276268643,
 68340,
 -1,
 276301887,
 68339,
 -1,
 276336438,
 68338,
 -61316,
 276270510,
 68341,
 -61315,
 276530305,
 68336,
 -61314,
 276584054,
 68342,
 -1,
 276641501,
 68337,
 276828294,
 276194170,
 -1,
 276893827,
 276792931,
 -1,
 -61310,
 276863075,
 68334,
 -1,
 276901968,
 68333,
 277090437,
 276850349,
 68331,
 -1,
 277021244,
 68335,
 -1,
 277034642,
 68332,
 277287049,
 276762614,
 -1,
 -61304,
 277223960,
 68326,
 -1,
 277286945,
 68325,
 -1,
 277250433,
 68296,
 277549227,
 272901915,
 -1,
 277614759,
 277501081,
 -1,
 277680288,
 277548900,
 -1,
 277745808,
 277642468,
 2126,
 -61297,
 277716781,
 2129,
 -1,
 277757077,
 2132,
 277942418,
 277710435,
 2133,
 -1,
 277907043,
 2120,
 278073492,
 277892483,
 2122,
 -1,
 278035838,
 2121,
 -61291,
 278044461,
 2118,
 -61290,
 278164393,
 2131,
 -61289,
 278229621,
 2130,
 -61288,
 278293688,
 2128,
 -61287,
 278355583,
 2125,
 -61286,
 278419747,
 2124,
 -61285,
 278482892,
 2123,
 -61284,
 278545962,
 2136,
 -61283,
 278609045,
 2116,
 -61282,
 278673766,
 2114,
 -61281,
 278734434,
 2115,
 -1,
 278796480,
 2113,
 278991011,
 277627530,
 -1,
 -61278,
 278955619,
 2119,
 -1,
 279010943,
 2127,
 -61276,
 278958950,
 2117,
 -61275,
 279137768,
 2135,
 -61274,
 279199076,
 2112,
 -1,
 279260292,
 2134,
 -61272,
 277583485,
 2138,
 -61271,
 279409080,
 2142,
 -61270,
 279460486,
 2139,
 -1,
 279515509,
 2137,
 279711924,
 277479424,
 -1,
 279777455,
 279681449,
 -1,
 -61266,
 279743749,
 128115,
 -1,
 279788596,
 128114,
 279974066,
 279725613,
 -1,
 -61263,
 279940455,
 129333,
 -1,
 279977412,
 128372,
 -61261,
 279914333,
 128378,
 -1,
 280106018,
 128107,
 -61259,
 279678671,
 129469,
 -61258,
 280266747,
 128368,
 -61257,
 280329551,
 128094,
 -61256,
 280378311,
 129389,
 -1,
 280434551,
 8380,
 280629532,
 272858656,
 -1,
 280695031,
 280581273,
 -1,
 280760514,
 280659555,
 -1,
 280826047,
 280725091,
 -1,
 -61250,
 280771747,
 72983,
 -1,
 280825700,
 72982,
 -61248,
 280785917,
 73008,
 -61247,
 280968355,
 72988,
 -1,
 281022308,
 72987,
 281219271,
 280714879,
 -1,
 -61244,
 281189721,
 72981,
 -61243,
 281239256,
 72986,
 -61242,
 281295263,
 72976,
 -1,
 281349988,
 72991,
 281546957,
 281159266,
 -1,
 281612491,
 281486946,
 -1,
 -61238,
 281558179,
 72985,
 -1,
 281612132,
 72984,
 -61236,
 281558179,
 72990,
 -1,
 281743204,
 72989,
 281940177,
 281481060,
 72960,
 -61233,
 281906719,
 72971,
 -61232,
 281952906,
 72968,
 -1,
 282005348,
 72961,
 282202325,
 281902308,
 -1,
 -61229,
 282164606,
 73002,
 -61228,
 282213539,
 73001,
 -1,
 282267492,
 73003,
 282464473,
 282152323,
 -1,
 -61225,
 282428373,
 73006,
 -61224,
 282475683,
 72973,
 -1,
 282529636,
 72972,
 282726621,
 282414261,
 -1,
 -61221,
 282682329,
 73007,
 -61220,
 282737827,
 72980,
 -1,
 282791780,
 72979,
 282988767,
 282693151,
 72964,
 -1,
 282955295,
 72965,
 283119842,
 282946744,
 -1,
 -61215,
 283065507,
 72993,
 -1,
 283119460,
 72992,
 283316453,
 283070412,
 -1,
 -61212,
 283267102,
 73005,
 -1,
 283316068,
 72999,
 283513063,
 283263626,
 72962,
 -1,
 283460234,
 72963,
 283644138,
 283457894,
 -1,
 -61207,
 283589795,
 72975,
 -1,
 283643748,
 72974,
 283840749,
 283581958,
 -1,
 -61204,
 283786403,
 72978,
 -1,
 283840356,
 72977,
 284037360,
 283777216,
 -1,
 -61201,
 283983011,
 72995,
 -1,
 284036964,
 72994,
 -61199,
 284007769,
 72997,
 -61198,
 284201993,
 73000,
 -61197,
 284259325,
 72998,
 -61196,
 284320747,
 72969,
 -61195,
 284383597,
 72996,
 -61194,
 284441763,
 73004,
 -1,
 284503211,
 72966,
 284692741,
 280663031,
 -1,
 284758276,
 284650598,
 -1,
 284823805,
 284692324,
 -1,
 -61189,
 284790303,
 73023,
 -61188,
 284836490,
 73020,
 -1,
 284888932,
 73009,
 285085951,
 284790303,
 73012,
 -1,
 285052447,
 73013,
 285217025,
 285033098,
 73010,
 -1,
 285164170,
 73011,
 -61182,
 285185651,
 73014,
 -61181,
 285303787,
 73021,
 -1,
 285355179,
 73018,
 -1,
 284707289,
 73029,
 285610259,
 284633347,
 -1,
 285675785,
 285574755,
 -1,
 -61176,
 285645570,
 73042,
 -1,
 285688162,
 73043,
 285872396,
 285637860,
 -1,
 -61173,
 285821997,
 73046,
 -1,
 285881287,
 73047,
 286069007,
 285815991,
 -1,
 -61170,
 286026466,
 73044,
 -1,
 286083983,
 73045,
 -61168,
 286040046,
 73040,
 -61167,
 286221997,
 73041,
 -61166,
 286286143,
 73049,
 -1,
 286338910,
 73048,
 286527769,
 285573451,
 -1,
 -61163,
 286496326,
 73025,
 -61162,
 286548852,
 73026,
 -61161,
 286604579,
 73028,
 -61160,
 286662281,
 73027,
 -1,
 286725385,
 73024,
 286982143,
 286487465,
 -1,
 -61157,
 286863765,
 73030,
 -1,
 286920601,
 73031,
 287117690,
 280589225,
 -1,
 287183225,
 287056053,
 -1,
 287248713,
 287145188,
 -1,
 287314246,
 287215359,
 -1,
 287379750,
 287278691,
 -1,
 287445284,
 287341796,
 -1,
 -61149,
 287390883,
 72867,
 -1,
 287444836,
 72866,
 -61147,
 287390883,
 72859,
 -1,
 287575908,
 72858,
 287772970,
 287334015,
 -1,
 -61144,
 287743321,
 72857,
 -61143,
 287783327,
 72853,
 -1,
 287838052,
 72861,
 288035117,
 287743789,
 -1,
 -61140,
 287980707,
 72870,
 -1,
 288034660,
 72871,
 288231728,
 287997156,
 -1,
 -61137,
 288177315,
 72876,
 -1,
 288231268,
 72877,
 288428339,
 288189624,
 -1,
 -61134,
 288373923,
 72863,
 -1,
 288427876,
 72862,
 288624950,
 288378243,
 -1,
 -61131,
 288570531,
 72851,
 -1,
 288624484,
 72850,
 288821561,
 288564834,
 -1,
 -61128,
 288792417,
 72868,
 -1,
 288821092,
 72860,
 289018172,
 288759302,
 -1,
 -61125,
 288963747,
 72855,
 -1,
 289017700,
 72854,
 -61123,
 288988505,
 72873,
 -61122,
 289183534,
 72869,
 -61121,
 289240061,
 72874,
 -61120,
 289298797,
 72865,
 -61119,
 289361950,
 72875,
 -61118,
 289426650,
 72856,
 -61117,
 289488035,
 72878,
 -61116,
 289552799,
 72852,
 -61115,
 289609937,
 72864,
 -1,
 289673060,
 72879,
 289931263,
 287262019,
 -1,
 -61112,
 289808029,
 72886,
 -1,
 289871113,
 72885,
 290066801,
 287200409,
 -1,
 290132304,
 290031203,
 -1,
 290197838,
 290094308,
 -1,
 -61107,
 290143395,
 72835,
 -1,
 290197348,
 72834,
 -61105,
 290143395,
 72827,
 -1,
 290328420,
 72826,
 290525524,
 290086527,
 -1,
 -61102,
 290495833,
 72825,
 -61101,
 290535839,
 72821,
 -1,
 290590564,
 72829,
 290787671,
 290496301,
 -1,
 -61098,
 290733219,
 72838,
 -1,
 290787172,
 72839,
 290984282,
 290749668,
 -1,
 -61095,
 290929827,
 72844,
 -1,
 290983780,
 72845,
 291180893,
 290942136,
 -1,
 -61092,
 291126435,
 72831,
 -1,
 291180388,
 72830,
 291377504,
 291130755,
 -1,
 -61089,
 291323043,
 72819,
 -1,
 291376996,
 72818,
 291574115,
 291317346,
 -1,
 -61086,
 291544929,
 72836,
 -1,
 291573604,
 72828,
 291770726,
 291511814,
 -1,
 -61083,
 291716259,
 72823,
 -1,
 291770212,
 72822,
 -61081,
 291741017,
 72841,
 -61080,
 291936046,
 72837,
 -61079,
 291992573,
 72842,
 -61078,
 292051309,
 72833,
 -61077,
 292114462,
 72843,
 -61076,
 292179162,
 72824,
 -61075,
 292240547,
 72846,
 -61074,
 292305311,
 72820,
 -61073,
 292362449,
 72832,
 -61072,
 292425572,
 72847,
 -1,
 292489317,
 72840,
 292688247,
 290035428,
 -1,
 -61069,
 292654623,
 72882,
 -61068,
 292709355,
 72884,
 -61067,
 292766346,
 72881,
 -61066,
 292826283,
 72883,
 -1,
 292884402,
 72880,
 -61064,
 292641383,
 72817,
 -1,
 293027430,
 72816,
 -1,
 287148438,
 129355,
 293278129,
 287063285,
 -1,
 293343661,
 293228492,
 -1,
 293409196,
 293286697,
 -1,
 293474691,
 293373539,
 -1,
 293540225,
 293439075,
 -1,
 -61056,
 293485731,
 69983,
 -1,
 293539684,
 69982,
 -61054,
 293485731,
 69988,
 -1,
 293670756,
 69987,
 293867913,
 293414498,
 -1,
 293933447,
 293807714,
 -1,
 -61050,
 293878947,
 69985,
 -1,
 293932900,
 69984,
 -61048,
 293878947,
 69990,
 -1,
 294063972,
 69989,
 294261133,
 293822079,
 -1,
 -61045,
 294231385,
 69981,
 -61044,
 294280920,
 69986,
 -1,
 294326116,
 69991,
 294523280,
 294220713,
 -1,
 -61041,
 294482941,
 70002,
 -1,
 294522724,
 69997,
 294719891,
 294481080,
 -1,
 -61038,
 294665379,
 69993,
 -1,
 294719332,
 69992,
 294916502,
 294669699,
 -1,
 -61035,
 294861987,
 69974,
 -1,
 294915940,
 69973,
 295113113,
 294866101,
 -1,
 -61032,
 295058595,
 69980,
 -1,
 295112548,
 69979,
 295309724,
 295057766,
 -1,
 -61029,
 295255203,
 69976,
 -1,
 295309156,
 69975,
 295506335,
 295247366,
 -1,
 -61026,
 295451811,
 69978,
 -1,
 295505764,
 69977,
 295702946,
 295442624,
 -1,
 -61023,
 295648419,
 69995,
 -1,
 295702372,
 69994,
 -61021,
 295670793,
 69999,
 -61020,
 295865887,
 69970,
 -61019,
 295927166,
 70000,
 -61018,
 295986155,
 69972,
 -61017,
 296049005,
 69996,
 -61016,
 296112158,
 69998,
 -61015,
 296174218,
 69969,
 -61014,
 296238243,
 70001,
 -61013,
 296299691,
 69971,
 -1,
 296357732,
 69968,
 -1,
 293356676,
 70006,
 296620464,
 293305572,
 -1,
 -61009,
 296568158,
 70003,
 -1,
 296627664,
 70005,
 -1,
 296554505,
 70004,
 296882638,
 293228072,
 -1,
 296948166,
 296834201,
 -1,
 297013687,
 296902271,
 -1,
 -61003,
 296983897,
 73451,
 -61002,
 297023903,
 73442,
 -1,
 297078628,
 73448,
 -61000,
 296983897,
 73452,
 -60999,
 297243657,
 73455,
 -60998,
 297305842,
 73446,
 -60997,
 297368958,
 73456,
 -60996,
 297432061,
 73453,
 -60995,
 297495794,
 73443,
 -60994,
 297556333,
 73445,
 -60993,
 297619486,
 73454,
 -60992,
 297684442,
 73440,
 -60991,
 297749722,
 73450,
 -60990,
 297810335,
 73441,
 -60989,
 297871086,
 73447,
 -60988,
 297934370,
 73449,
 -60987,
 297998545,
 73444,
 -1,
 298061668,
 73457,
 298258891,
 296916708,
 -1,
 -60984,
 298225183,
 73460,
 -60983,
 298279915,
 73462,
 -60982,
 298336906,
 73459,
 -1,
 298396843,
 73461,
 -60980,
 298216999,
 73463,
 -60979,
 298528936,
 73464,
 -1,
 298587254,
 73458,
 298783214,
 296833445,
 -1,
 298848734,
 298727573,
 -1,
 298914266,
 298804913,
 -1,
 298979796,
 298878563,
 -1,
 -60973,
 298948698,
 3419,
 -1,
 298987841,
 3420,
 299176407,
 298923191,
 -1,
 -60970,
 299133335,
 3417,
 -1,
 299189293,
 3422,
 -60968,
 299139557,
 3446,
 -60967,
 299329360,
 3416,
 -1,
 299380627,
 3447,
 299630591,
 298879238,
 -1,
 -60964,
 299535750,
 3421,
 -60963,
 299598319,
 3448,
 -1,
 299642778,
 3418,
 299831783,
 298800281,
 -1,
 299897315,
 299770072,
 -1,
 -60959,
 299867371,
 3413,
 -60958,
 299915555,
 3412,
 -1,
 299980545,
 3414,
 -60956,
 299863269,
 3386,
 -60955,
 300114433,
 3369,
 -60954,
 300165555,
 3406,
 -1,
 300225947,
 3423,
 300482559,
 299794763,
 -1,
 300487148,
 300359174,
 -1,
 -60950,
 300443150,
 3328,
 -60949,
 300501600,
 3388,
 -1,
 300553290,
 3329,
 -60947,
 300455151,
 3387,
 -1,
 300707229,
 3407,
 300880394,
 298753396,
 -1,
 300945911,
 300844643,
 -1,
 301011443,
 300914454,
 -1,
 -60942,
 300966891,
 119522,
 -1,
 301019166,
 119532,
 301208054,
 300956821,
 -1,
 -60939,
 301168190,
 119523,
 -1,
 301222531,
 119533,
 -1,
 301150288,
 119530,
 301470204,
 300907748,
 -1,
 301535738,
 301419565,
 119526,
 -1,
 301500398,
 119536,
 301727743,
 301478855,
 119527,
 -1,
 301631470,
 119537,
 301797890,
 301413559,
 -1,
 301863423,
 301755106,
 119524,
 -1,
 301828078,
 119534,
 302055423,
 301810314,
 -1,
 -60927,
 301962287,
 119525,
 -1,
 302004555,
 119535,
 302191110,
 301739179,
 -1,
 302256645,
 302138539,
 119528,
 -1,
 302198439,
 119538,
 -1,
 302208321,
 119531,
 302453256,
 302145855,
 119529,
 -1,
 302417902,
 119539,
 -60919,
 302424046,
 119520,
 -1,
 302540461,
 119521,
 302715407,
 300844643,
 -1,
 302780942,
 302661435,
 -1,
 -60915,
 302742152,
 10187,
 -1,
 302789897,
 10189,
 -1,
 302722245,
 129481,
 303043090,
 302659942,
 -1,
 -60911,
 302997619,
 129522,
 -1,
 303049899,
 129497,
 -60909,
 303013009,
 128470,
 -1,
 303198138,
 127809,
 303370979,
 272777866,
 -1,
 303436500,
 303306017,
 -1,
 303501971,
 303387801,
 -1,
 303567403,
 303466083,
 -1,
 303632928,
 303523659,
 -1,
 -60902,
 303566426,
 94105,
 -60901,
 303631796,
 94104,
 -60900,
 303697180,
 94103,
 -60899,
 303762546,
 94102,
 -60898,
 303827926,
 94101,
 -60897,
 303893277,
 94100,
 -1,
 303958597,
 94099,
 304157221,
 303594724,
 -1,
 -60894,
 304119166,
 93994,
 -60893,
 304168099,
 93998,
 -60892,
 304229547,
 94025,
 -1,
 304287588,
 94007,
 304484904,
 304108935,
 -1,
 -60889,
 304455001,
 93980,
 -1,
 304484196,
 93978,
 -60887,
 304449266,
 93966,
 -60886,
 304622763,
 94024,
 -1,
 304680804,
 93962,
 304878136,
 303521407,
 -1,
 304943663,
 304848107,
 -1,
 -60882,
 304888995,
 93997,
 -1,
 304942948,
 93996,
 305140274,
 304897663,
 -1,
 -60879,
 305085603,
 93973,
 -1,
 305139556,
 93972,
 305336885,
 305084774,
 -1,
 -60876,
 305282211,
 93988,
 -1,
 305336164,
 93987,
 305533495,
 305270628,
 93968,
 -1,
 305495469,
 94032,
 -1,
 305478819,
 93969,
 305730116,
 304848685,
 -1,
 305795647,
 305700653,
 -1,
 305861181,
 305757412,
 -1,
 -60868,
 305831257,
 94017,
 -1,
 305860452,
 94014,
 -60866,
 305831257,
 94016,
 -1,
 305991524,
 94013,
 306188866,
 305757412,
 -1,
 -60863,
 306134179,
 94006,
 -1,
 306188132,
 94012,
 -60861,
 306134179,
 94005,
 -1,
 306319204,
 94011,
 306516559,
 305700366,
 -1,
 306582091,
 306480739,
 -1,
 306647625,
 306543844,
 -1,
 -60856,
 306592931,
 94000,
 -1,
 306646884,
 94009,
 -60854,
 306611954,
 93964,
 -1,
 306777956,
 93965,
 -60852,
 306539762,
 93954,
 -60851,
 306930140,
 93970,
 -60850,
 306990554,
 93984,
 -1,
 307047590,
 94001,
 307237466,
 306475945,
 -1,
 307303001,
 307179232,
 -1,
 307368536,
 307259211,
 -1,
 -60845,
 307301978,
 94111,
 -60844,
 307367196,
 94110,
 -60843,
 307432562,
 94109,
 -60842,
 307497942,
 94108,
 -60841,
 307563077,
 94107,
 -1,
 307628457,
 94106,
 -1,
 307331042,
 94002,
 -1,
 307267511,
 94026,
 307958373,
 307177058,
 -1,
 308023904,
 307928877,
 -1,
 -60835,
 307994465,
 93995,
 -60834,
 308059659,
 94023,
 -60833,
 308100259,
 93999,
 -1,
 308154212,
 94008,
 308351587,
 307975559,
 -1,
 -60830,
 308321625,
 93981,
 -1,
 308350820,
 93979,
 -60828,
 308291310,
 93967,
 -1,
 308481892,
 93963,
 308679277,
 307892068,
 -1,
 308744812,
 308639034,
 -1,
 308810346,
 308698751,
 -1,
 -60823,
 308754847,
 93989,
 -1,
 308809572,
 93971,
 -60821,
 308781107,
 94015,
 -1,
 308959597,
 93958,
 -1,
 308690069,
 94019,
 309203570,
 308640996,
 -1,
 -60817,
 309173771,
 94022,
 -60816,
 309230974,
 94004,
 -60815,
 309279907,
 94003,
 -1,
 309333860,
 94010,
 309531256,
 309153740,
 -1,
 309596790,
 309476501,
 -1,
 -60811,
 309566809,
 93977,
 -1,
 309596004,
 93976,
 -60809,
 309566809,
 93975,
 -1,
 309727076,
 93974,
 309924477,
 309475686,
 -1,
 309990012,
 309869717,
 -1,
 -60805,
 309935267,
 93993,
 -1,
 309989220,
 93992,
 -1,
 309923684,
 93983,
 310252160,
 309892087,
 -1,
 -60801,
 310195419,
 93961,
 -1,
 310251364,
 93960,
 310448771,
 310211189,
 -1,
 -60798,
 310393247,
 93986,
 -1,
 310447972,
 93985,
 310645382,
 310406328,
 -1,
 -60795,
 310595614,
 93955,
 -1,
 310644580,
 93952,
 310841993,
 310597923,
 -1,
 -60792,
 310787235,
 93957,
 -1,
 310841188,
 93956,
 311038604,
 310787221,
 -1,
 -60789,
 310983843,
 94020,
 -1,
 311037796,
 93990,
 311235215,
 310974656,
 -1,
 -60786,
 311195546,
 94021,
 -1,
 311234404,
 93953,
 -60784,
 311204957,
 93991,
 -60783,
 311400238,
 94018,
 -60782,
 311447002,
 93982,
 -1,
 311506139,
 93959,
 311694025,
 303470308,
 -1,
 311759519,
 311640714,
 94049,
 311825048,
 311693156,
 94050,
 311951359,
 311778943,
 94051,
 -1,
 311834982,
 94052,
 312021658,
 311780331,
 94053,
 -1,
 311976114,
 94086,
 -60773,
 311987743,
 94056,
 -60772,
 312107186,
 94057,
 -60771,
 312165002,
 94055,
 -60770,
 312228198,
 94084,
 -1,
 312290475,
 94054,
 312480424,
 311725599,
 94058,
 312545955,
 312414052,
 94059,
 312672255,
 312499839,
 94060,
 -1,
 312555878,
 94061,
 -60764,
 312512031,
 94062,
 -60763,
 312698094,
 94079,
 -60762,
 312762546,
 94064,
 -60761,
 312820362,
 94087,
 -1,
 312880981,
 94063,
 313070257,
 312414052,
 94036,
 313135787,
 313024127,
 94039,
 -1,
 313080166,
 94040,
 313266861,
 313076907,
 94067,
 -1,
 313207979,
 94068,
 -60754,
 313232927,
 94075,
 -60753,
 313344650,
 94073,
 -60752,
 313409439,
 94038,
 -1,
 313462628,
 94037,
 313660088,
 313011371,
 94045,
 313725620,
 313619369,
 94071,
 -1,
 313684905,
 94069,
 313856694,
 313679487,
 94046,
 -1,
 313801062,
 94047,
 -60745,
 313803402,
 94074,
 -1,
 313921380,
 94085,
 314118847,
 313615339,
 94041,
 314184380,
 314059947,
 -1,
 -60741,
 314154219,
 94048,
 -1,
 314209193,
 94082,
 -60739,
 314150431,
 94076,
 -60738,
 314336235,
 94042,
 -1,
 314390886,
 94081,
 314577602,
 314088683,
 94065,
 -60735,
 314544170,
 94080,
 -1,
 314589834,
 94066,
 314774212,
 314545942,
 94044,
 -1,
 314729451,
 94043,
 314905286,
 314735647,
 94072,
 -1,
 314864553,
 94070,
 315036360,
 314859135,
 94077,
 -1,
 314980710,
 94078,
 -1,
 315004673,
 94083,
 315232974,
 311659214,
 -1,
 -60725,
 315198182,
 94096,
 -60724,
 315258838,
 94095,
 -60723,
 315300376,
 94098,
 -1,
 315363361,
 94097,
 315621375,
 315195723,
 -1,
 315626194,
 315520659,
 -1,
 -60719,
 315594383,
 94034,
 -1,
 315627314,
 94035,
 -60717,
 315564971,
 94031,
 -1,
 315758386,
 94033,
 315953884,
 303375541,
 -1,
 316019417,
 315909099,
 -1,
 -60713,
 315981399,
 128300,
 -60712,
 316043038,
 127908,
 -1,
 316086732,
 129440,
 316342271,
 315949056,
 -1,
 -60709,
 316237441,
 983235,
 -1,
 316286841,
 983236,
 316478176,
 315908380,
 -1,
 -60706,
 316431666,
 128469,
 -60705,
 316483893,
 128189,
 -1,
 316546496,
 128656,
 316801023,
 316428236,
 -1,
 -60702,
 316690363,
 127756,
 -1,
 316754764,
 127894,
 316937121,
 303326187,
 -1,
 317002597,
 316876386,
 -1,
 317068132,
 316949130,
 -1,
 317133649,
 316997632,
 -1,
 317199143,
 317084825,
 -1,
 317264623,
 317166583,
 -1,
 317330158,
 317219919,
 -1,
 317395692,
 317289385,
 71174,
 -1,
 317354921,
 71175,
 317587455,
 317345740,
 71176,
 -1,
 317476812,
 71177,
 -1,
 317263716,
 71210,
 317723381,
 317228643,
 -1,
 317788915,
 317687395,
 -1,
 -60686,
 317734051,
 71193,
 -1,
 317788004,
 71192,
 -60684,
 317734051,
 71198,
 -1,
 317919076,
 71197,
 318116602,
 317677183,
 -1,
 -60681,
 318086489,
 71191,
 -60680,
 318136024,
 71196,
 -60679,
 318192031,
 71186,
 -1,
 318246756,
 71201,
 318444288,
 318056034,
 -1,
 318509822,
 318383714,
 -1,
 -60675,
 318454947,
 71195,
 -1,
 318508900,
 71194,
 -60673,
 318454947,
 71200,
 -1,
 318639972,
 71199,
 318837508,
 318377828,
 71168,
 -60670,
 318803487,
 71181,
 -60669,
 318849674,
 71179,
 -1,
 318902116,
 71169,
 319099656,
 318799076,
 -1,
 -60666,
 319061374,
 71212,
 -60665,
 319110307,
 71211,
 -1,
 319164260,
 71213,
 319361802,
 319065631,
 71172,
 -1,
 319327775,
 71173,
 319492877,
 319319224,
 -1,
 -60660,
 319437987,
 71203,
 -1,
 319491940,
 71202,
 319689488,
 319442892,
 -1,
 -60657,
 319639582,
 71215,
 -1,
 319688548,
 71209,
 319886099,
 319638915,
 -1,
 -60654,
 319831203,
 71183,
 -1,
 319885156,
 71182,
 320082710,
 319835317,
 -1,
 -60651,
 320027811,
 71190,
 -1,
 320081764,
 71189,
 320279320,
 320029322,
 71170,
 -1,
 320225930,
 71171,
 320410395,
 320223590,
 -1,
 -60646,
 320355491,
 71185,
 -1,
 320409444,
 71184,
 320607006,
 320347654,
 -1,
 -60643,
 320552099,
 71188,
 -1,
 320606052,
 71187,
 320803617,
 320542912,
 -1,
 -60640,
 320748707,
 71205,
 -1,
 320802660,
 71204,
 -60638,
 320773465,
 71207,
 -60637,
 320959485,
 71208,
 -60636,
 321020907,
 71180,
 -60635,
 321083757,
 71206,
 -60634,
 321141923,
 71214,
 -1,
 321203371,
 71178,
 321393463,
 317167332,
 -1,
 321458989,
 321361514,
 -1,
 321524523,
 321418153,
 71221,
 -1,
 321483689,
 71222,
 321716223,
 321474508,
 71223,
 -1,
 321605580,
 71224,
 321786673,
 321392484,
 -1,
 -60625,
 321752607,
 71228,
 -60624,
 321798794,
 71226,
 -1,
 321851236,
 71216,
 322048819,
 321752607,
 71219,
 -1,
 322014751,
 71220,
 322179893,
 321995402,
 71217,
 -1,
 322126474,
 71218,
 -60618,
 322135019,
 71227,
 -1,
 322251947,
 71225,
 322442056,
 321332834,
 -1,
 322507590,
 322389302,
 -1,
 322573116,
 322471523,
 -1,
 -60613,
 322542338,
 71250,
 -1,
 322584930,
 71251,
 322769727,
 322534628,
 -1,
 -60610,
 322718765,
 71254,
 -1,
 322778055,
 71255,
 322966338,
 322712759,
 -1,
 -60607,
 322923234,
 71252,
 -1,
 322980751,
 71253,
 -60605,
 322936814,
 71248,
 -60604,
 323118765,
 71249,
 -60603,
 323182911,
 71257,
 -1,
 323235678,
 71256,
 -60601,
 322464352,
 71234,
 -1,
 323359802,
 71233,
 323556176,
 322404683,
 -1,
 323621708,
 323524067,
 -1,
 -60597,
 323583533,
 71230,
 -1,
 323646646,
 71231,
 323818319,
 323555172,
 -1,
 -60594,
 323777919,
 71232,
 -1,
 323838915,
 71229,
 -1,
 323764841,
 71236,
 -1,
 323489801,
 71235,
 324206591,
 317076917,
 -1,
 324211555,
 324097177,
 -1,
 324277083,
 324174362,
 -1,
 324342617,
 324227020,
 -1,
 324408152,
 324273617,
 -1,
 -60585,
 324361372,
 43870,
 -1,
 324421973,
 43869,
 -1,
 324355168,
 43001,
 -60582,
 324308577,
 43871,
 -1,
 324616006,
 43868,
 324801376,
 324214278,
 -1,
 324866911,
 324771611,
 -1,
 -60578,
 324829942,
 42653,
 -1,
 324877869,
 42652,
 -1,
 324801845,
 43000,
 325189631,
 324744350,
 -1,
 -60574,
 325081097,
 983993,
 -1,
 325140452,
 983992,
 -1,
 324148517,
 43867,
 -1,
 317010549,
 129339,
 325456769,
 316956287,
 -1,
 325522297,
 325401559,
 -1,
 325587819,
 325486074,
 71273,
 325713919,
 325518801,
 -1,
 -60566,
 325609829,
 71274,
 -1,
 325659283,
 71275,
 325849967,
 325549031,
 71265,
 325976063,
 325780945,
 -1,
 -60562,
 325871973,
 71269,
 -1,
 325921427,
 71270,
 326112114,
 325813859,
 -1,
 -60559,
 326079196,
 71276,
 -1,
 326138439,
 71267,
 326308724,
 326060337,
 71271,
 -1,
 326239870,
 71272,
 326439799,
 326245164,
 -1,
 -60554,
 326396261,
 71264,
 -1,
 326445715,
 71268,
 -60552,
 326390945,
 6264,
 -1,
 326576649,
 71266,
 326767486,
 325465253,
 -1,
 326833021,
 326696960,
 -1,
 -60548,
 326802051,
 128184,
 -1,
 326834472,
 128176,
 -1,
 326764721,
 129297,
 327095168,
 326717113,
 128018,
 -1,
 327025116,
 128053,
 -1,
 327051547,
 128669,
 327291787,
 325422623,
 -1,
 327357320,
 327246624,
 -1,
 327422855,
 327291355,
 -1,
 -60539,
 327382103,
 128670,
 -60538,
 327425594,
 128672,
 -1,
 327490244,
 128693,
 -1,
 327352864,
 128507,
 327750538,
 327319142,
 128001,
 -1,
 327680476,
 128045,
 -1,
 327714895,
 128068,
 327947155,
 327255651,
 -1,
 328012690,
 327903488,
 -1,
 328078224,
 327942144,
 -1,
 -60529,
 328040015,
 128757,
 -1,
 328080496,
 128741,
 -60527,
 328046599,
 128739,
 -1,
 328223900,
 129468,
 -1,
 327958347,
 129334,
 328471448,
 327902187,
 -1,
 328536983,
 328425089,
 -1,
 -60522,
 328504830,
 127889,
 -1,
 328539723,
 129390,
 -1,
 328476263,
 128496,
 328799132,
 328407787,
 128241,
 328925183,
 328728576,
 -1,
 -60517,
 328833573,
 128242,
 -1,
 328885469,
 128244,
 329061279,
 328762285,
 -1,
 -60514,
 329010051,
 129439,
 -1,
 329067691,
 128332,
 -60512,
 329031020,
 128511,
 -1,
 329225715,
 127909,
 329389040,
 316902943,
 -1,
 329454552,
 329341115,
 -1,
 329520087,
 329389230,
 -1,
 329585622,
 329471129,
 -1,
 329651116,
 329524834,
 -1,
 329716650,
 329590370,
 -1,
 -60504,
 329661603,
 70292,
 -60503,
 329721582,
 70291,
 -1,
 329781092,
 70290,
 -60501,
 329661603,
 70297,
 -1,
 329912164,
 70296,
 330109874,
 329614947,
 -1,
 330175408,
 330073699,
 -1,
 -60497,
 330120355,
 70289,
 -1,
 330174308,
 70288,
 -60495,
 330120355,
 70295,
 -1,
 330305380,
 70294,
 330503094,
 330068905,
 -1,
 -60492,
 330462205,
 70311,
 -60491,
 330513571,
 70312,
 -1,
 330567524,
 70306,
 330765242,
 330456703,
 -1,
 -60488,
 330734937,
 70287,
 -60487,
 330784472,
 70293,
 -1,
 330829668,
 70298,
 331027389,
 330722488,
 -1,
 -60484,
 330972323,
 70300,
 -1,
 331026276,
 70299,
 331224000,
 330976643,
 -1,
 -60481,
 331168931,
 70277,
 -1,
 331222884,
 70276,
 331420611,
 331173045,
 -1,
 -60478,
 331369690,
 70285,
 -1,
 331419492,
 70284,
 331617222,
 331364710,
 -1,
 -60475,
 331562147,
 70280,
 -1,
 331616100,
 70278,
 331813833,
 331554310,
 -1,
 -60472,
 331758755,
 70283,
 -1,
 331812708,
 70282,
 332010444,
 331749568,
 -1,
 -60469,
 331955363,
 70303,
 -1,
 332009316,
 70301,
 -60467,
 331980121,
 70305,
 -60466,
 332174345,
 70308,
 -60465,
 332238367,
 70274,
 -60464,
 332299646,
 70309,
 -60463,
 332355949,
 70304,
 -60462,
 332419102,
 70307,
 -60461,
 332481162,
 70273,
 -60460,
 332545187,
 70310,
 -60459,
 332606635,
 70275,
 -1,
 332664676,
 70272,
 -1,
 329547389,
 70313,
 -1,
 329468300,
 127926,
 333053951,
 329415908,
 -1,
 333059055,
 332940157,
 -1,
 333124588,
 333020388,
 -1,
 333190123,
 333094594,
 -1,
 333255649,
 333130923,
 -1,
 333321184,
 333202712,
 -1,
 -60449,
 333287718,
 119271,
 -1,
 333327092,
 119270,
 -1,
 333274990,
 119263,
 333583332,
 333214504,
 -1,
 -60445,
 333549862,
 119269,
 -1,
 333589236,
 119268,
 333779943,
 333526199,
 -1,
 -60442,
 333730158,
 119272,
 -1,
 333792880,
 119264,
 -60440,
 333748552,
 119266,
 -60439,
 333936105,
 119265,
 -60438,
 333987156,
 119267,
 -1,
 334044683,
 119262,
 -1,
 333128822,
 127932,
 334304238,
 333074109,
 127929,
 -1,
 334235450,
 127896,
 -1,
 334258842,
 127925,
 -1,
 333005312,
 127812,
 334566441,
 329349996,
 -1,
 334631960,
 334517401,
 -1,
 334697462,
 334595683,
 -1,
 -60428,
 334642786,
 92757,
 -60427,
 334704565,
 92766,
 -1,
 334761828,
 92736,
 334959609,
 334652395,
 92754,
 -60424,
 334914539,
 92753,
 -1,
 334974924,
 92749,
 335156221,
 334908803,
 -1,
 -60421,
 335111147,
 92761,
 -60420,
 335166671,
 92744,
 -1,
 335228215,
 92748,
 335418368,
 335115177,
 -1,
 -60417,
 335373291,
 92755,
 -1,
 335430282,
 92765,
 335614979,
 335375544,
 -1,
 -60414,
 335560614,
 92743,
 -1,
 335613796,
 92752,
 335811590,
 335568511,
 -1,
 -60411,
 335758890,
 92751,
 -1,
 335821630,
 92737,
 336008201,
 335763747,
 -1,
 -60408,
 335955439,
 92739,
 -1,
 336007415,
 92750,
 336204811,
 335958046,
 92763,
 -1,
 336158335,
 92762,
 336335886,
 336149667,
 -1,
 -60403,
 336290795,
 92745,
 -1,
 336347786,
 92764,
 336532496,
 336276651,
 92760,
 -1,
 336465764,
 92758,
 336663570,
 336471790,
 92741,
 -1,
 336609930,
 92746,
 -60397,
 336633586,
 92738,
 -60396,
 336762670,
 92759,
 -60395,
 336822431,
 92756,
 -60394,
 336863530,
 92747,
 -60393,
 336926929,
 92740,
 -1,
 336990052,
 92742,
 337248255,
 334571106,
 -1,
 337253415,
 337134902,
 -1,
 337318941,
 337217123,
 -1,
 -60388,
 337287938,
 92770,
 -1,
 337330530,
 92771,
 337515552,
 337280228,
 -1,
 -60385,
 337464365,
 92774,
 -1,
 337523655,
 92775,
 337712163,
 337458359,
 -1,
 -60382,
 337668834,
 92772,
 -1,
 337726351,
 92773,
 -60380,
 337682414,
 92768,
 -60379,
 337864365,
 92769,
 -60378,
 337928511,
 92777,
 -1,
 337981278,
 92776,
 -60376,
 337209952,
 92783,
 -1,
 338105402,
 92782,
 338302046,
 334536065,
 -1,
 338367562,
 338252953,
 -1,
 338433088,
 338331431,
 -1,
 338498610,
 338372194,
 -1,
 338564144,
 338437730,
 -1,
 -60369,
 338508963,
 43502,
 -1,
 338562916,
 43501,
 -60367,
 338508963,
 43516,
 -1,
 338693988,
 43515,
 338891829,
 338452095,
 -1,
 -60364,
 338861401,
 43495,
 -1,
 338910936,
 43503,
 339088440,
 338840757,
 -1,
 -60361,
 339033251,
 43500,
 -1,
 339087204,
 43499,
 339285051,
 339032422,
 -1,
 -60358,
 339229859,
 43498,
 -1,
 339283812,
 43497,
 339481662,
 339220672,
 -1,
 -60355,
 339426467,
 43518,
 -1,
 339480420,
 43517,
 -60353,
 339433166,
 43514,
 -1,
 339621083,
 43496,
 339869695,
 338395011,
 -1,
 339874887,
 339743651,
 -1,
 -60349,
 339829212,
 43491,
 -60348,
 339889449,
 43490,
 -60347,
 339950307,
 43488,
 -60346,
 340009011,
 43489,
 -1,
 340073127,
 43492,
 340328447,
 339843119,
 -1,
 -60343,
 340230114,
 43647,
 -1,
 340271155,
 43646,
 340464728,
 338331442,
 -1,
 340530254,
 340428387,
 -1,
 -60339,
 340499202,
 43506,
 -1,
 340541794,
 43507,
 340726865,
 340491492,
 -1,
 -60336,
 340675629,
 43510,
 -1,
 340734919,
 43511,
 340923476,
 340669623,
 -1,
 -60333,
 340880098,
 43508,
 -1,
 340937615,
 43509,
 -60331,
 340893678,
 43504,
 -60330,
 341075629,
 43505,
 -60329,
 341139775,
 43513,
 -1,
 341192542,
 43512,
 341382237,
 340427083,
 -1,
 341447772,
 341346115,
 -1,
 -60325,
 341380210,
 43645,
 -1,
 341445189,
 43644,
 -1,
 341409800,
 43493,
 -1,
 341335399,
 43494,
 -60321,
 338269974,
 983173,
 -60320,
 341743350,
 983216,
 -1,
 341794340,
 983228,
 341973472,
 234295140,
 -1,
 342038263,
 341925503,
 -1,
 342103785,
 341972972,
 -1,
 342168803,
 342034857,
 -1,
 342234235,
 342100249,
 -1,
 342299754,
 342166964,
 83070,
 -60312,
 342236678,
 83073,
 -60311,
 342300864,
 83072,
 -1,
 342364004,
 83071,
 342561902,
 342232022,
 83062,
 -60308,
 342498822,
 83065,
 -60307,
 342563008,
 83064,
 -1,
 342626148,
 83063,
 342824049,
 342494322,
 83066,
 -60304,
 342759616,
 83068,
 -1,
 342822756,
 83067,
 343020659,
 342755909,
 83059,
 -1,
 342953828,
 83060,
 343151733,
 342952361,
 83057,
 -1,
 343084900,
 83058,
 343282807,
 343083289,
 83055,
 -1,
 343215972,
 83056,
 -60296,
 343215833,
 83075,
 -60295,
 343346778,
 83074,
 -60294,
 343411996,
 83069,
 -1,
 343477021,
 83061,
 343676041,
 342165929,
 -1,
 343741567,
 343607577,
 83076,
 -60290,
 343677120,
 83078,
 -1,
 343740260,
 83077,
 343938177,
 343673970,
 83083,
 -1,
 343871332,
 83084,
 -60286,
 343871193,
 83088,
 -60285,
 344002138,
 83087,
 -60284,
 344067508,
 83086,
 -60283,
 344132892,
 83085,
 -60282,
 344198102,
 83082,
 -60281,
 344263453,
 83081,
 -60280,
 344328773,
 83080,
 -1,
 344394153,
 83079,
 344593557,
 343608093,
 -1,
 344659084,
 344525938,
 83105,
 -1,
 344592228,
 83106,
 -60275,
 344592089,
 83110,
 -60274,
 344723034,
 83109,
 -60273,
 344788404,
 83108,
 -60272,
 344853788,
 83107,
 -60271,
 344918998,
 83104,
 -60270,
 344984349,
 83103,
 -60269,
 345049669,
 83102,
 -60268,
 345115049,
 83101,
 -1,
 345180441,
 83100,
 345380001,
 344525381,
 -1,
 345445528,
 345312370,
 83094,
 -1,
 345378660,
 83095,
 -60263,
 345378521,
 83099,
 -60262,
 345509466,
 83098,
 -60261,
 345574836,
 83097,
 -60260,
 345640220,
 83096,
 -60259,
 345705430,
 83093,
 -60258,
 345770781,
 83092,
 -60257,
 345836101,
 83091,
 -60256,
 345901481,
 83090,
 -1,
 345966873,
 83089,
 346166444,
 345312985,
 -1,
 -60253,
 346099417,
 83170,
 -60252,
 346164826,
 83169,
 -60251,
 346230196,
 83168,
 -60250,
 346295580,
 83167,
 -60249,
 346360946,
 83166,
 -60248,
 346426326,
 83165,
 -60247,
 346491677,
 83164,
 -60246,
 346556997,
 83163,
 -60245,
 346622377,
 83162,
 -1,
 346687769,
 83161,
 346887351,
 346099290,
 -1,
 -60242,
 346820313,
 83160,
 -60241,
 346885722,
 83159,
 -60240,
 346951092,
 83158,
 -60239,
 347016476,
 83157,
 -60238,
 347081842,
 83156,
 -60237,
 347147222,
 83155,
 -60236,
 347212573,
 83154,
 -60235,
 347277893,
 83153,
 -60234,
 347343273,
 83152,
 -1,
 347408665,
 83151,
 347608258,
 346820020,
 -1,
 -60231,
 347541209,
 83150,
 -60230,
 347606618,
 83149,
 -60229,
 347671988,
 83148,
 -60228,
 347737372,
 83147,
 -60227,
 347802738,
 83146,
 -60226,
 347868118,
 83145,
 -60225,
 347933469,
 83144,
 -60224,
 347998789,
 83143,
 -60223,
 348064169,
 83142,
 -1,
 348129561,
 83141,
 348329165,
 347540764,
 -1,
 -60220,
 348262105,
 83140,
 -60219,
 348327514,
 83139,
 -60218,
 348392884,
 83138,
 -60217,
 348458268,
 83137,
 -60216,
 348523634,
 83136,
 -60215,
 348589014,
 83135,
 -60214,
 348654365,
 83134,
 -60213,
 348719685,
 83133,
 -60212,
 348785065,
 83132,
 -1,
 348850457,
 83131,
 349050072,
 348261490,
 -1,
 -60209,
 348983001,
 83130,
 -60208,
 349048410,
 83129,
 -60207,
 349113780,
 83128,
 -60206,
 349179164,
 83127,
 -60205,
 349244530,
 83126,
 -60204,
 349309910,
 83125,
 -60203,
 349375261,
 83124,
 -60202,
 349440581,
 83123,
 -60201,
 349505961,
 83122,
 -1,
 349571353,
 83121,
 349831167,
 348982230,
 -1,
 -60198,
 349703897,
 83120,
 -60197,
 349769306,
 83119,
 -60196,
 349834676,
 83118,
 -60195,
 349900060,
 83117,
 -60194,
 349965426,
 83116,
 -60193,
 350030806,
 83115,
 -60192,
 350096157,
 83114,
 -60191,
 350161477,
 83113,
 -60190,
 350226857,
 83112,
 -1,
 350292249,
 83111,
 350492002,
 342100765,
 -1,
 350557429,
 350423837,
 -1,
 350622953,
 350489884,
 83322,
 -60185,
 350559750,
 83325,
 -60184,
 350623936,
 83324,
 -1,
 350687076,
 83323,
 350885101,
 350554693,
 -1,
 -60181,
 350821894,
 83318,
 -60180,
 350886080,
 83317,
 -1,
 350949220,
 83316,
 -60178,
 350818009,
 83328,
 -60177,
 351080026,
 83327,
 -60176,
 351145396,
 83326,
 -60175,
 351210610,
 83321,
 -60174,
 351275990,
 83320,
 -60173,
 351341341,
 83319,
 -60172,
 351406505,
 83315,
 -1,
 351471897,
 83314,
 351671556,
 350490202,
 -1,
 351737080,
 351603996,
 83381,
 -1,
 351670116,
 83382,
 351868155,
 351669021,
 -1,
 -60166,
 351801188,
 83378,
 -1,
 351863881,
 83377,
 352064765,
 351799721,
 83374,
 -1,
 351997796,
 83375,
 -60162,
 351997657,
 83385,
 -60161,
 352128602,
 83384,
 -60160,
 352193972,
 83383,
 -60159,
 352259186,
 83380,
 -60158,
 352324566,
 83379,
 -60157,
 352389701,
 83376,
 -1,
 352454937,
 83373,
 352654609,
 351603996,
 -1,
 352720135,
 352587354,
 83359,
 -1,
 352653156,
 83360,
 352851209,
 352652246,
 83354,
 -1,
 352784228,
 83355,
 -60150,
 352784089,
 83361,
 -60149,
 352914868,
 83358,
 -60148,
 352980252,
 83357,
 -60147,
 353045618,
 83356,
 -60146,
 353110813,
 83353,
 -60145,
 353176133,
 83352,
 -60144,
 353241513,
 83351,
 -1,
 353306905,
 83350,
 353506589,
 352587188,
 -1,
 353572116,
 353438121,
 83363,
 -1,
 353505124,
 83364,
 -60139,
 353504985,
 83372,
 -60138,
 353635930,
 83371,
 -60137,
 353701300,
 83370,
 -60136,
 353766684,
 83369,
 -60135,
 353832050,
 83368,
 -60134,
 353897430,
 83367,
 -60133,
 353962781,
 83366,
 -60132,
 354028101,
 83365,
 -1,
 354093337,
 83362,
 354293033,
 353438834,
 -1,
 354358560,
 354225881,
 83348,
 -1,
 354291556,
 83349,
 -60127,
 354291290,
 83347,
 -60126,
 354422196,
 83346,
 -60125,
 354487580,
 83345,
 -60124,
 354552946,
 83344,
 -60123,
 354618326,
 83343,
 -60122,
 354683677,
 83342,
 -60121,
 354748997,
 83341,
 -60120,
 354814377,
 83340,
 -1,
 354879769,
 83339,
 355079477,
 354224709,
 -1,
 355145004,
 355012313,
 83312,
 -1,
 355077988,
 83313,
 -60115,
 355077722,
 83311,
 -60114,
 355208628,
 83310,
 -60113,
 355274012,
 83309,
 -60112,
 355339378,
 83308,
 -60111,
 355404758,
 83307,
 -60110,
 355470109,
 83306,
 -60109,
 355535429,
 83305,
 -60108,
 355600809,
 83304,
 -1,
 355666201,
 83303,
 355865921,
 355010841,
 -1,
 355931448,
 355798745,
 83291,
 -1,
 355864420,
 83292,
 -60103,
 355864154,
 83290,
 -60102,
 355995060,
 83289,
 -60101,
 356060444,
 83288,
 -60100,
 356125810,
 83287,
 -60099,
 356191190,
 83286,
 -60098,
 356256541,
 83285,
 -60097,
 356321861,
 83284,
 -60096,
 356387241,
 83283,
 -1,
 356452633,
 83282,
 356652364,
 355798745,
 -1,
 -60093,
 356585177,
 83395,
 -60092,
 356650586,
 83394,
 -60091,
 356715956,
 83393,
 -60090,
 356781340,
 83392,
 -60089,
 356846706,
 83391,
 -60088,
 356912086,
 83390,
 -60087,
 356977454,
 83389,
 -60086,
 357042757,
 83388,
 -60085,
 357108137,
 83387,
 -1,
 357173529,
 83386,
 357373271,
 356584406,
 -1,
 -60082,
 357306073,
 83338,
 -60081,
 357371482,
 83337,
 -60080,
 357436852,
 83336,
 -60079,
 357502236,
 83335,
 -60078,
 357567602,
 83334,
 -60077,
 357632982,
 83333,
 -60076,
 357698333,
 83332,
 -60075,
 357763653,
 83331,
 -60074,
 357829033,
 83330,
 -1,
 357894425,
 83329,
 358154239,
 357304745,
 -1,
 -60071,
 358026969,
 83302,
 -60070,
 358092378,
 83301,
 -60069,
 358157748,
 83300,
 -60068,
 358223132,
 83299,
 -60067,
 358288498,
 83298,
 -60066,
 358353878,
 83297,
 -60065,
 358419229,
 83296,
 -60064,
 358484549,
 83295,
 -60063,
 358549929,
 83294,
 -1,
 358615321,
 83293,
 358815196,
 350423621,
 -1,
 358880626,
 358746393,
 -1,
 358946151,
 358812229,
 83173,
 -60058,
 358881472,
 83175,
 -1,
 358944612,
 83174,
 359142761,
 358878937,
 83183,
 -1,
 359075684,
 83184,
 359273835,
 359075252,
 83180,
 -1,
 359206756,
 83181,
 -60052,
 359206490,
 83182,
 -60051,
 359337244,
 83179,
 -60050,
 359402610,
 83178,
 -60049,
 359467990,
 83177,
 -60048,
 359533341,
 83176,
 -60047,
 359598505,
 83172,
 -1,
 359663897,
 83171,
 359863679,
 358813401,
 -1,
 359929205,
 359796441,
 83280,
 -1,
 359862116,
 83281,
 360060279,
 359861206,
 83274,
 -1,
 359993188,
 83275,
 -60040,
 359992922,
 83279,
 -60039,
 360123828,
 83278,
 -60038,
 360189212,
 83277,
 -60037,
 360254578,
 83276,
 -60036,
 360319773,
 83273,
 -60035,
 360385093,
 83272,
 -60034,
 360450473,
 83271,
 -1,
 360515865,
 83270,
 360715660,
 359795113,
 -1,
 360781186,
 360647964,
 83192,
 -1,
 360714084,
 83193,
 360912260,
 360713330,
 83190,
 -1,
 360845156,
 83191,
 -60027,
 360845017,
 83196,
 -60026,
 360975962,
 83195,
 -60025,
 361041332,
 83194,
 -60024,
 361106390,
 83189,
 -60023,
 361171741,
 83188,
 -60022,
 361237061,
 83187,
 -60021,
 361302441,
 83186,
 -1,
 361367833,
 83185,
 361567640,
 360648282,
 -1,
 361633167,
 361500377,
 83268,
 -1,
 361566052,
 83269,
 -60016,
 361565786,
 83267,
 -60015,
 361696692,
 83266,
 -60014,
 361762076,
 83265,
 -60013,
 361827442,
 83264,
 -60012,
 361892822,
 83263,
 -60011,
 361958173,
 83262,
 -60010,
 362023493,
 83261,
 -60009,
 362088873,
 83260,
 -1,
 362154265,
 83259,
 362354084,
 361499932,
 -1,
 362419611,
 362286516,
 83245,
 -1,
 362352484,
 83246,
 -60004,
 362352345,
 83248,
 -60003,
 362483290,
 83247,
 -60002,
 362548508,
 83244,
 -60001,
 362613874,
 83243,
 -60000,
 362679254,
 83242,
 -59999,
 362744605,
 83241,
 -59998,
 362809925,
 83240,
 -59997,
 362875305,
 83239,
 -1,
 362940697,
 83238,
 363140528,
 362285637,
 -1,
 363206055,
 363072948,
 83204,
 -1,
 363138916,
 83205,
 -59992,
 363138777,
 83207,
 -59991,
 363269722,
 83206,
 -59990,
 363334940,
 83203,
 -59989,
 363400306,
 83202,
 -59988,
 363465686,
 83201,
 -59987,
 363531037,
 83200,
 -59986,
 363596357,
 83199,
 -59985,
 363661737,
 83198,
 -1,
 363727129,
 83197,
 363926971,
 363072948,
 -1,
 -59982,
 363859673,
 83258,
 -59981,
 363925082,
 83257,
 -59980,
 363990452,
 83256,
 -59979,
 364055836,
 83255,
 -59978,
 364121202,
 83254,
 -59977,
 364186582,
 83253,
 -59976,
 364251933,
 83252,
 -59975,
 364317253,
 83251,
 -59974,
 364382633,
 83250,
 -1,
 364448025,
 83249,
 364647878,
 363859058,
 -1,
 -59971,
 364580569,
 83237,
 -59970,
 364645978,
 83236,
 -59969,
 364711348,
 83235,
 -59968,
 364776732,
 83234,
 -59967,
 364842098,
 83233,
 -59966,
 364907478,
 83232,
 -59965,
 364972829,
 83231,
 -59964,
 365038149,
 83230,
 -59963,
 365103529,
 83229,
 -1,
 365168921,
 83228,
 365368785,
 364579798,
 -1,
 -59960,
 365301465,
 83227,
 -59959,
 365366874,
 83226,
 -59958,
 365432244,
 83225,
 -59957,
 365497628,
 83224,
 -59956,
 365562994,
 83223,
 -59955,
 365628374,
 83222,
 -59954,
 365693725,
 83221,
 -59953,
 365759045,
 83220,
 -59952,
 365824425,
 83219,
 -1,
 365889817,
 83218,
 366149631,
 365300509,
 -1,
 -59949,
 366022361,
 83217,
 -59948,
 366087770,
 83216,
 -59947,
 366153140,
 83215,
 -59946,
 366218524,
 83214,
 -59945,
 366283890,
 83213,
 -59944,
 366349270,
 83212,
 -59943,
 366414621,
 83211,
 -59942,
 366479941,
 83210,
 -59941,
 366545321,
 83209,
 -1,
 366610713,
 83208,
 366810710,
 358746393,
 -1,
 366876140,
 366742486,
 -1,
 366941665,
 366808348,
 82994,
 -59936,
 366876864,
 82996,
 -1,
 366940004,
 82995,
 367138275,
 366873714,
 82992,
 -1,
 367071076,
 82993,
 367269349,
 367069609,
 82987,
 -1,
 367202148,
 82988,
 -59930,
 367202009,
 82999,
 -59929,
 367332954,
 82998,
 -59928,
 367398324,
 82997,
 -59927,
 367463382,
 82991,
 -59926,
 367528733,
 82990,
 -59925,
 367594053,
 82989,
 -1,
 367659289,
 82986,
 367859194,
 366808348,
 -1,
 367924721,
 367791388,
 83016,
 -59921,
 367861254,
 83019,
 -59920,
 367925440,
 83018,
 -1,
 367988580,
 83017,
 -59918,
 367857369,
 83022,
 -59917,
 368119386,
 83021,
 -59916,
 368184756,
 83020,
 -59915,
 368249970,
 83015,
 -59914,
 368315350,
 83014,
 -59913,
 368380701,
 83013,
 -59912,
 368446021,
 83012,
 -59911,
 368511401,
 83011,
 -1,
 368576793,
 83010,
 368776711,
 367791833,
 -1,
 368842237,
 368709210,
 83052,
 -1,
 368775012,
 83053,
 368973311,
 368774580,
 83050,
 -1,
 368906084,
 83051,
 -59904,
 368905945,
 83054,
 -59903,
 369036572,
 83049,
 -59902,
 369101938,
 83048,
 -59901,
 369167318,
 83047,
 -59900,
 369232669,
 83046,
 -59899,
 369297989,
 83045,
 -59898,
 369363369,
 83044,
 -1,
 369428761,
 83043,
 369628691,
 368708381,
 -1,
 369694218,
 369561305,
 82984,
 -1,
 369626980,
 82985,
 -59893,
 369626714,
 82983,
 -59892,
 369757620,
 82982,
 -59891,
 369823004,
 82981,
 -59890,
 369888370,
 82980,
 -59889,
 369953750,
 82979,
 -59888,
 370019101,
 82978,
 -59887,
 370084421,
 82977,
 -59886,
 370149801,
 82976,
 -1,
 370215193,
 82975,
 370415135,
 369560133,
 -1,
 370480662,
 370347292,
 82970,
 -1,
 370413412,
 82971,
 -59881,
 370413273,
 82974,
 -59880,
 370544218,
 82973,
 -59879,
 370609588,
 82972,
 -59878,
 370674802,
 82969,
 -59877,
 370740182,
 82968,
 -59876,
 370805533,
 82967,
 -59875,
 370870853,
 82966,
 -59874,
 370936233,
 82965,
 -1,
 371001625,
 82964,
 371201579,
 370346409,
 -1,
 371267106,
 371132697,
 82953,
 -1,
 371199844,
 82954,
 -59869,
 371199705,
 82963,
 -59868,
 371330650,
 82962,
 -59867,
 371396020,
 82961,
 -59866,
 371461404,
 82960,
 -59865,
 371526770,
 82959,
 -59864,
 371592150,
 82958,
 -59863,
 371657501,
 82957,
 -59862,
 371722821,
 82956,
 -1,
 371788201,
 82955,
 371988022,
 371134042,
 -1,
 -59859,
 371920601,
 83042,
 -59858,
 371986010,
 83041,
 -59857,
 372051380,
 83040,
 -59856,
 372116764,
 83039,
 -59855,
 372182130,
 83038,
 -59854,
 372247510,
 83037,
 -59853,
 372312861,
 83036,
 -59852,
 372378181,
 83035,
 -59851,
 372443561,
 83034,
 -1,
 372508953,
 83033,
 372708929,
 371920308,
 -1,
 -59848,
 372641497,
 83032,
 -59847,
 372706906,
 83031,
 -59846,
 372772276,
 83030,
 -59845,
 372837660,
 83029,
 -59844,
 372903026,
 83028,
 -59843,
 372968406,
 83027,
 -59842,
 373033757,
 83026,
 -59841,
 373099077,
 83025,
 -59840,
 373164457,
 83024,
 -1,
 373229849,
 83023,
 373429836,
 372640882,
 -1,
 -59837,
 373362393,
 83009,
 -59836,
 373427802,
 83008,
 -59835,
 373493172,
 83007,
 -59834,
 373558556,
 83006,
 -59833,
 373623922,
 83005,
 -59832,
 373689302,
 83004,
 -59831,
 373754653,
 83003,
 -59830,
 373819973,
 83002,
 -59829,
 373885353,
 83001,
 -1,
 373950745,
 83000,
 374210559,
 373360921,
 -1,
 -59826,
 374083289,
 82952,
 -59825,
 374148698,
 82951,
 -59824,
 374214068,
 82950,
 -59823,
 374279452,
 82949,
 -59822,
 374344818,
 82948,
 -59821,
 374410198,
 82947,
 -59820,
 374475549,
 82946,
 -59819,
 374540869,
 82945,
 -1,
 374606249,
 82944,
 374806215,
 366742486,
 -1,
 374871652,
 374738034,
 -1,
 374937178,
 374803892,
 83455,
 -1,
 374869860,
 83456,
 375068252,
 374868249,
 83447,
 -1,
 375000932,
 83448,
 -59811,
 375000793,
 83458,
 -59810,
 375131738,
 83457,
 -59809,
 375196956,
 83454,
 -59808,
 375262322,
 83453,
 -59807,
 375327702,
 83452,
 -59806,
 375393053,
 83451,
 -59805,
 375458373,
 83450,
 -1,
 375523753,
 83449,
 375723633,
 374802857,
 -1,
 375789160,
 375654681,
 -1,
 -59801,
 375721833,
 83407,
 -1,
 375783641,
 83406,
 -59799,
 375721689,
 83416,
 -59798,
 375918170,
 83415,
 -59797,
 375983540,
 83414,
 -59796,
 376048924,
 83413,
 -59795,
 376114290,
 83412,
 -59794,
 376179670,
 83411,
 -59793,
 376245021,
 83410,
 -59792,
 376310341,
 83409,
 -1,
 376375721,
 83408,
 376575612,
 375656026,
 -1,
 -59789,
 376508121,
 83488,
 -59788,
 376573530,
 83487,
 -59787,
 376638900,
 83486,
 -59786,
 376704284,
 83485,
 -59785,
 376769650,
 83484,
 -59784,
 376835030,
 83483,
 -59783,
 376900381,
 83482,
 -59782,
 376965701,
 83481,
 -59781,
 377031081,
 83480,
 -1,
 377096473,
 83479,
 377296519,
 376507828,
 -1,
 -59778,
 377229017,
 83478,
 -59777,
 377294426,
 83477,
 -59776,
 377359796,
 83476,
 -59775,
 377425180,
 83475,
 -59774,
 377490546,
 83474,
 -59773,
 377555926,
 83473,
 -59772,
 377621277,
 83472,
 -59771,
 377686597,
 83471,
 -59770,
 377751977,
 83470,
 -1,
 377817369,
 83469,
 378017426,
 377228572,
 -1,
 -59767,
 377949913,
 83468,
 -59766,
 378015322,
 83467,
 -59765,
 378080692,
 83466,
 -59764,
 378146076,
 83465,
 -59763,
 378211442,
 83464,
 -59762,
 378276822,
 83463,
 -59761,
 378342173,
 83462,
 -59760,
 378407493,
 83461,
 -59759,
 378472873,
 83460,
 -1,
 378538265,
 83459,
 378738333,
 377949142,
 -1,
 -59756,
 378670809,
 83446,
 -59755,
 378736218,
 83445,
 -59754,
 378801588,
 83444,
 -59753,
 378866972,
 83443,
 -59752,
 378932338,
 83442,
 -59751,
 378997718,
 83441,
 -59750,
 379063069,
 83440,
 -59749,
 379128389,
 83439,
 -59748,
 379193769,
 83438,
 -1,
 379259161,
 83437,
 379459240,
 378669853,
 -1,
 -59745,
 379391705,
 83436,
 -59744,
 379457114,
 83435,
 -59743,
 379522484,
 83434,
 -59742,
 379587868,
 83433,
 -59741,
 379653234,
 83432,
 -59740,
 379718614,
 83431,
 -59739,
 379783965,
 83430,
 -59738,
 379849285,
 83429,
 -59737,
 379914665,
 83428,
 -1,
 379980057,
 83427,
 380180147,
 379390533,
 -1,
 -59734,
 380112601,
 83426,
 -59733,
 380178010,
 83425,
 -59732,
 380243380,
 83424,
 -59731,
 380308764,
 83423,
 -59730,
 380374130,
 83422,
 -59729,
 380439510,
 83421,
 -59728,
 380504861,
 83420,
 -59727,
 380570181,
 83419,
 -59726,
 380635561,
 83418,
 -1,
 380700953,
 83417,
 380901054,
 380111129,
 -1,
 -59723,
 380833497,
 83405,
 -59722,
 380898906,
 83404,
 -59721,
 380964276,
 83403,
 -59720,
 381029660,
 83402,
 -59719,
 381095026,
 83401,
 -59718,
 381160406,
 83400,
 -59717,
 381225757,
 83399,
 -59716,
 381291077,
 83398,
 -59715,
 381356457,
 83397,
 -1,
 381421849,
 83396,
 381681663,
 380833497,
 -1,
 -59712,
 381554100,
 83496,
 -59711,
 381619484,
 83495,
 -59710,
 381684850,
 83494,
 -59709,
 381750230,
 83493,
 -59708,
 381815581,
 83492,
 -59707,
 381880901,
 83491,
 -59706,
 381946281,
 83490,
 -1,
 382011673,
 83489,
 382271487,
 374738034,
 -1,
 382277331,
 382143045,
 -1,
 -59702,
 382209753,
 83525,
 -59701,
 382275162,
 83524,
 -59700,
 382340532,
 83523,
 -59699,
 382405916,
 83522,
 -59698,
 382471282,
 83521,
 -59697,
 382536662,
 83520,
 -59696,
 382602013,
 83519,
 -59695,
 382667333,
 83518,
 -59694,
 382732713,
 83517,
 -1,
 382798105,
 83516,
 382998238,
 382208425,
 -1,
 -59691,
 382930649,
 83515,
 -59690,
 382996058,
 83514,
 -59689,
 383061428,
 83513,
 -59688,
 383126812,
 83512,
 -59687,
 383192178,
 83511,
 -59686,
 383257558,
 83510,
 -59685,
 383322909,
 83509,
 -59684,
 383388229,
 83508,
 -59683,
 383453609,
 83507,
 -1,
 383519001,
 83506,
 383719144,
 382929177,
 -1,
 -59680,
 383651545,
 83505,
 -59679,
 383716954,
 83504,
 -59678,
 383782324,
 83503,
 -59677,
 383847708,
 83502,
 -59676,
 383913074,
 83501,
 -59675,
 383978454,
 83500,
 -59674,
 384043805,
 83499,
 -59673,
 384109125,
 83498,
 -1,
 384174505,
 83497,
 -1,
 383650752,
 83526,
 384440051,
 342066787,
 128028,
 384505586,
 384385966,
 -1,
 384571121,
 384470033,
 -1,
 -59667,
 384535280,
 11151,
 -59666,
 384596160,
 11148,
 -59665,
 384657562,
 11119,
 -59664,
 384717619,
 11150,
 -1,
 384769239,
 11149,
 -1,
 384510902,
 128260,
 -1,
 384446695,
 128246,
 385155071,
 384383334,
 -1,
 -59659,
 385060914,
 128551,
 -59658,
 385121500,
 128544,
 -1,
 385167877,
 128162,
 385357907,
 341996457,
 -1,
 385423435,
 385290267,
 -1,
 385488822,
 385374573,
 -1,
 385554357,
 385452162,
 -1,
 385619748,
 385492578,
 -1,
 385685281,
 385573867,
 -1,
 385750812,
 385650530,
 -1,
 385816324,
 385713763,
 -1,
 385881858,
 385760405,
 -1,
 -59647,
 385822513,
 126646,
 -1,
 385880693,
 126648,
 -59645,
 385822513,
 126645,
 -1,
 386011578,
 126632,
 386209544,
 385776868,
 -1,
 -59642,
 386154290,
 126644,
 -59641,
 386215591,
 126638,
 -1,
 386273473,
 126641,
 386471691,
 386178913,
 -1,
 -59638,
 386418218,
 126630,
 -1,
 386481301,
 126650,
 386668302,
 386410222,
 -1,
 -59635,
 386617292,
 126627,
 -1,
 386672226,
 126649,
 -59633,
 386637225,
 126633,
 -59632,
 386832353,
 126629,
 -59631,
 386889379,
 126643,
 -59630,
 386953855,
 126642,
 -59629,
 387015219,
 126637,
 -59628,
 387079026,
 126636,
 -59627,
 387141793,
 126635,
 -59626,
 387206854,
 126647,
 -59625,
 387271941,
 126626,
 -59624,
 387333310,
 126631,
 -59623,
 387398375,
 126651,
 -59622,
 387462483,
 126640,
 -59621,
 387521021,
 126625,
 -1,
 387584471,
 126639,
 387842047,
 385714830,
 -1,
 -59618,
 387740287,
 126495,
 -59617,
 387801651,
 126493,
 -59616,
 387855699,
 126494,
 -1,
 387914237,
 126492,
 388169727,
 385617764,
 -1,
 -59613,
 388059084,
 126467,
 -1,
 388114018,
 126489,
 388306761,
 385568716,
 -1,
 388372296,
 388261955,
 -1,
 388437804,
 388335203,
 -1,
 388503338,
 388381845,
 -1,
 -59607,
 388443953,
 126614,
 -1,
 388502133,
 126616,
 -59605,
 388443953,
 126613,
 -1,
 388633018,
 126600,
 388831024,
 388398308,
 -1,
 -59602,
 388775730,
 126612,
 -59601,
 388837031,
 126606,
 -1,
 388894913,
 126609,
 389093171,
 388800353,
 -1,
 -59598,
 389039658,
 126598,
 -1,
 389102741,
 126618,
 389289782,
 389037205,
 -1,
 -59595,
 389230385,
 126596,
 -1,
 389288378,
 126599,
 389486393,
 389228270,
 -1,
 -59592,
 389435340,
 126595,
 -1,
 389490274,
 126617,
 389683004,
 389418852,
 -1,
 -59589,
 389632662,
 126592,
 -1,
 389695018,
 126607,
 -59587,
 389651881,
 126601,
 -59586,
 389847009,
 126597,
 -59585,
 389904035,
 126611,
 -59584,
 389968511,
 126610,
 -59583,
 390029875,
 126605,
 -59582,
 390093682,
 126604,
 -59581,
 390156449,
 126603,
 -59580,
 390221510,
 126615,
 -59579,
 390286597,
 126594,
 -59578,
 390347495,
 126619,
 -59577,
 390411603,
 126608,
 -1,
 390470141,
 126593,
 -1,
 388305732,
 126475,
 390731627,
 388267236,
 -1,
 390797160,
 390695856,
 -1,
 390862671,
 390760035,
 -1,
 -59571,
 390807351,
 126582,
 -59570,
 390868785,
 126581,
 -1,
 390926778,
 126568,
 391124819,
 390823140,
 -1,
 -59567,
 391069490,
 126580,
 -59566,
 391130791,
 126574,
 -1,
 391188673,
 126577,
 391386968,
 391063138,
 -1,
 391452503,
 391342615,
 -1,
 -59562,
 391394643,
 126590,
 -1,
 391453181,
 126588,
 -1,
 391385281,
 126585,
 391714651,
 391335299,
 -1,
 -59558,
 391658686,
 126583,
 -1,
 391713091,
 126570,
 391911262,
 391658645,
 -1,
 -59555,
 391851825,
 126564,
 -1,
 391909818,
 126567,
 -59553,
 391880548,
 126586,
 -59552,
 392076713,
 126569,
 -59551,
 392131199,
 126578,
 -59550,
 392192563,
 126573,
 -59549,
 392256370,
 126572,
 -59548,
 392318213,
 126562,
 -59547,
 392379111,
 126587,
 -59546,
 392443219,
 126576,
 -59545,
 392501757,
 126561,
 -1,
 392565207,
 126575,
 -59543,
 390741810,
 126484,
 -59542,
 392703655,
 126478,
 -1,
 392761537,
 126481,
 392959876,
 390678639,
 -1,
 393025392,
 392920292,
 -1,
 -59538,
 392970034,
 126516,
 -59537,
 393031335,
 126510,
 -1,
 393089217,
 126513,
 393287539,
 392988259,
 -1,
 -59534,
 393232183,
 126518,
 -1,
 393293617,
 126517,
 393484150,
 393235843,
 -1,
 -59531,
 393428158,
 126519,
 -1,
 393482563,
 126506,
 393680761,
 393428117,
 -1,
 -59528,
 393621297,
 126500,
 -1,
 393679290,
 126503,
 -59526,
 393649577,
 126505,
 -59525,
 393835135,
 126514,
 -59524,
 393896499,
 126509,
 -59523,
 393960306,
 126508,
 -59522,
 394023073,
 126507,
 -59521,
 394087685,
 126498,
 -59520,
 394148583,
 126523,
 -59519,
 394212691,
 126512,
 -59518,
 394274579,
 126521,
 -59517,
 394336765,
 126497,
 -1,
 394400215,
 126511,
 394598302,
 392922723,
 -1,
 394663834,
 394530660,
 -1,
 394729369,
 394610142,
 -1,
 394794891,
 394689764,
 -1,
 -59511,
 394739506,
 126548,
 -59510,
 394800807,
 126542,
 -1,
 394858689,
 126545,
 395057040,
 394733154,
 -1,
 395122575,
 395012631,
 -1,
 -59506,
 395080319,
 126559,
 -1,
 395141683,
 126557,
 -1,
 395055297,
 126553,
 -59503,
 395025833,
 126537,
 -59502,
 395342463,
 126546,
 -59501,
 395403827,
 126541,
 -59500,
 395464865,
 126539,
 -59499,
 395529926,
 126551,
 -59498,
 395595013,
 126530,
 -59497,
 395656382,
 126535,
 -59496,
 395721447,
 126555,
 -1,
 395776471,
 126543,
 -1,
 394673301,
 126472,
 396040093,
 394607765,
 -1,
 -59492,
 395980593,
 126486,
 -1,
 396038773,
 126488,
 -1,
 395980593,
 126485,
 396302241,
 394567521,
 -1,
 -59488,
 396248618,
 126470,
 -1,
 396311701,
 126490,
 396498852,
 396257479,
 -1,
 -59485,
 396450690,
 126704,
 -1,
 396508354,
 126705,
 396695463,
 396447107,
 -1,
 -59482,
 396639422,
 126487,
 -1,
 396693827,
 126474,
 396892074,
 396627812,
 -1,
 -59479,
 396841622,
 126464,
 -1,
 396903978,
 126479,
 -59477,
 396860841,
 126473,
 -59476,
 397055969,
 126469,
 -59475,
 397112995,
 126483,
 -59474,
 397177471,
 126482,
 -59473,
 397238835,
 126477,
 -59472,
 397302642,
 126476,
 -59471,
 397364485,
 126466,
 -59470,
 397425854,
 126471,
 -59469,
 397490919,
 126491,
 -59468,
 397555027,
 126480,
 -1,
 397613565,
 126465,
 -1,
 385514231,
 2303,
 397875189,
 385449188,
 -1,
 397940689,
 397844131,
 -1,
 398006213,
 397903459,
 -1,
 398071743,
 397974285,
 -1,
 398137277,
 398038357,
 -1,
 -59460,
 398072344,
 64446,
 -1,
 398135329,
 64445,
 -59458,
 398072344,
 64437,
 -1,
 398266401,
 64436,
 398524415,
 398016888,
 -1,
 398530499,
 398422084,
 -1,
 -59454,
 398465560,
 64441,
 -1,
 398528545,
 64440,
 -59452,
 398465560,
 64439,
 -1,
 398659617,
 64438,
 398858186,
 397945175,
 -1,
 398923721,
 398820965,
 -1,
 -59448,
 398858776,
 64435,
 -1,
 398921761,
 64434,
 -1,
 398888778,
 64444,
 399185869,
 398819992,
 -1,
 -59444,
 399120920,
 64449,
 -1,
 399183905,
 64448,
 399382480,
 399128597,
 -1,
 -59441,
 399317528,
 64443,
 -1,
 399380513,
 64442,
 -1,
 399342022,
 64447,
 399644648,
 397892077,
 -1,
 399710181,
 399589342,
 -1,
 399775710,
 399677206,
 -1,
 399841245,
 399731005,
 -1,
 399906778,
 399773540,
 -1,
 -59433,
 399870044,
 2266,
 -59432,
 399932781,
 2267,
 -59431,
 399995887,
 2260,
 -1,
 400055994,
 2268,
 -59429,
 399873910,
 2271,
 -59428,
 400194977,
 2269,
 -1,
 400257698,
 2270,
 -1,
 399775875,
 2291,
 400496609,
 399736036,
 -1,
 -59424,
 400442728,
 2273,
 -1,
 400494785,
 2261,
 -59422,
 400454271,
 2263,
 -59421,
 400646712,
 2264,
 -59420,
 400701297,
 2272,
 -1,
 400757207,
 2262,
 401014783,
 399661019,
 -1,
 -59417,
 400922593,
 2259,
 -1,
 400974392,
 2265,
 401151988,
 399585722,
 -1,
 401217523,
 401120685,
 -1,
 401283054,
 401149796,
 -1,
 401348589,
 401232534,
 983633,
 -1,
 401277645,
 983635,
 -1,
 401288363,
 983640,
 -59409,
 401252138,
 983638,
 -59408,
 401512417,
 983634,
 -59407,
 401575455,
 983637,
 -59406,
 401630391,
 983636,
 -1,
 401681579,
 983639,
 -1,
 401171016,
 983641,
 -1,
 401098098,
 1540,
 402004005,
 397824515,
 -1,
 402069538,
 401968347,
 -1,
 402135037,
 402001764,
 -1,
 402200572,
 402077909,
 -1,
 -59398,
 402158207,
 2236,
 -59397,
 402219571,
 2237,
 -1,
 402273619,
 2235,
 -1,
 402146897,
 2227,
 402528257,
 402103752,
 -1,
 -59393,
 402489972,
 2234,
 -59392,
 402537847,
 2216,
 -1,
 402598298,
 2217,
 402790406,
 402486185,
 -1,
 402855941,
 402730804,
 -1,
 -59388,
 402817652,
 2233,
 -1,
 402872229,
 2218,
 -1,
 402810165,
 2220,
 403118091,
 402725377,
 -1,
 403183626,
 403079706,
 -1,
 -59383,
 403149817,
 2208,
 -1,
 403200887,
 2230,
 -1,
 403127671,
 2209,
 403445774,
 403080803,
 -1,
 -59379,
 403386173,
 2232,
 -1,
 403444157,
 2211,
 403642385,
 403406052,
 -1,
 -59376,
 403606390,
 2225,
 -1,
 403640524,
 2223,
 403838996,
 403593507,
 -1,
 -59373,
 403779213,
 2215,
 -1,
 403838438,
 1564,
 404035607,
 403787724,
 -1,
 -59370,
 403991626,
 2221,
 -1,
 404034375,
 2214,
 404232218,
 403983834,
 -1,
 -59367,
 404193467,
 1568,
 -1,
 404239548,
 2228,
 -59365,
 404201320,
 2226,
 -59364,
 404396005,
 2219,
 -59363,
 404451971,
 2213,
 -59362,
 404516456,
 2231,
 -59361,
 404573450,
 2210,
 -59360,
 404634033,
 2224,
 -59359,
 404698455,
 2212,
 -1,
 404760353,
 2222,
 405012479,
 402012457,
 -1,
 -59356,
 404888088,
 2297,
 -1,
 404951073,
 2295,
 405149745,
 401966691,
 -1,
 405215280,
 405104305,
 -1,
 405280810,
 405179831,
 -1,
 -59351,
 405215768,
 2286,
 -1,
 405278753,
 2283,
 405477421,
 405235382,
 -1,
 -59348,
 405412376,
 2285,
 -1,
 405475361,
 2282,
 405733375,
 405428138,
 -1,
 -59345,
 405608984,
 2287,
 -1,
 405671969,
 2284,
 -1,
 405181120,
 2275,
 405936184,
 405087746,
 -1,
 406001716,
 405884470,
 2278,
 -1,
 405964658,
 2281,
 406132790,
 405943587,
 2276,
 -1,
 406095730,
 2279,
 406323199,
 406071118,
 2277,
 -1,
 406226802,
 2280,
 406394941,
 405874274,
 -1,
 406460475,
 406350460,
 2299,
 -1,
 406390377,
 2300,
 -59332,
 406407900,
 2274,
 -1,
 406524792,
 2302,
 406722625,
 406353891,
 -1,
 406788160,
 406655009,
 2296,
 -1,
 406718057,
 2301,
 -1,
 406723096,
 2298,
 406984773,
 406677652,
 -1,
 -59325,
 406933073,
 2290,
 -59324,
 406992181,
 2288,
 -1,
 407054164,
 2289,
 407246920,
 406926633,
 -1,
 -59321,
 407206342,
 2292,
 -1,
 407251354,
 2293,
 -59319,
 407214032,
 1631,
 -59318,
 407397250,
 1541,
 -1,
 407457340,
 2294,
 407640144,
 385375180,
 -1,
 407705679,
 407601710,
 -1,
 -59314,
 407674386,
 1416,
 -1,
 407735578,
 1376,
 -1,
 407645220,
 1423,
 408027135,
 407603603,
 -1,
 -59310,
 407929928,
 127912,
 -1,
 407971267,
 128667,
 408164603,
 385306572,
 -1,
 408230135,
 408101024,
 -1,
 408295534,
 408190180,
 -1,
 408361056,
 408260127,
 -1,
 408426591,
 408296477,
 -1,
 408492126,
 408366318,
 -1,
 408557660,
 408452536,
 -1,
 -59301,
 408495196,
 128807,
 -1,
 408556800,
 128814,
 -59299,
 408495196,
 128802,
 -1,
 408687872,
 128812,
 -1,
 408439164,
 128862,
 -1,
 408376706,
 128781,
 409016422,
 408294005,
 -1,
 409081957,
 408979043,
 128788,
 409206783,
 409010987,
 -1,
 -59292,
 409085027,
 128806,
 -1,
 409146624,
 128813,
 -1,
 409012328,
 128825,
 409409642,
 408979043,
 -1,
 409475177,
 409367801,
 128860,
 -1,
 409405538,
 128861,
 -1,
 409409102,
 128850,
 -59285,
 409366368,
 128839,
 -59284,
 409625649,
 128852,
 -59283,
 409683433,
 128795,
 -1,
 409739231,
 128847,
 409933953,
 408227684,
 -1,
 409999478,
 409891506,
 -1,
 410065013,
 409927680,
 -1,
 410130547,
 410031701,
 128776,
 -1,
 410060898,
 128777,
 410320895,
 410089117,
 128774,
 -1,
 410191970,
 128775,
 -1,
 410007470,
 128773,
 410458235,
 409948108,
 -1,
 410523769,
 410406402,
 128822,
 -1,
 410454114,
 128823,
 -59270,
 410488969,
 128837,
 -1,
 410595374,
 128874,
 -59268,
 410423971,
 128829,
 -59267,
 410746967,
 128855,
 -59266,
 410811513,
 128826,
 -59265,
 410870622,
 128811,
 -59264,
 410933729,
 128859,
 -1,
 410995148,
 128769,
 411179157,
 409869830,
 -1,
 411244685,
 411136937,
 -1,
 411310217,
 411209629,
 128869,
 411435007,
 411240544,
 -1,
 -59258,
 411307122,
 128873,
 -59257,
 411372502,
 128872,
 -59256,
 411437853,
 128871,
 -1,
 411503173,
 128870,
 411762687,
 411264153,
 -1,
 411768972,
 411640924,
 128803,
 -1,
 411699298,
 128804,
 -1,
 411716213,
 128798,
 411965585,
 411176804,
 -1,
 -59249,
 411923026,
 128846,
 -59248,
 411982112,
 128844,
 -1,
 412036193,
 128848,
 412227732,
 411920602,
 -1,
 -59245,
 412182864,
 128800,
 -1,
 412226804,
 128805,
 -1,
 412174480,
 128787,
 412489893,
 411136937,
 -1,
 412555427,
 412429483,
 -1,
 412620960,
 412499044,
 128818,
 412686492,
 412551264,
 -1,
 -59238,
 412617686,
 128821,
 -59237,
 412683037,
 128820,
 -1,
 412748357,
 128819,
 413007871,
 412615467,
 -1,
 413014175,
 412882176,
 128816,
 -1,
 412944482,
 128817,
 -1,
 412961397,
 128799,
 413210786,
 412553901,
 128827,
 -1,
 413141090,
 128828,
 -1,
 413174568,
 128877,
 413466623,
 412509301,
 128792,
 -1,
 413337698,
 128793,
 413538480,
 412424384,
 -1,
 413604010,
 413493560,
 128834,
 413728767,
 413534304,
 -1,
 -59223,
 413600541,
 128836,
 -1,
 413665861,
 128835,
 413866157,
 413538227,
 -1,
 -59220,
 413832216,
 128876,
 -1,
 413883014,
 128875,
 -59218,
 413824949,
 128857,
 -59217,
 414011484,
 128783,
 -1,
 414075576,
 128830,
 414259386,
 413504503,
 -1,
 414324921,
 414204554,
 -1,
 414390455,
 414277678,
 128778,
 414455990,
 414320736,
 -1,
 -59211,
 414386973,
 128780,
 -1,
 414452293,
 128779,
 -1,
 414384944,
 128815,
 414777343,
 414354535,
 128790,
 -1,
 414648418,
 128791,
 -1,
 414265907,
 128808,
 414914756,
 414215352,
 -1,
 414980287,
 414868459,
 -1,
 415045822,
 414947367,
 128843,
 -1,
 414985695,
 128858,
 -1,
 415008384,
 128856,
 415242434,
 414944799,
 -1,
 -59199,
 415206309,
 128868,
 -1,
 415266769,
 128867,
 -59197,
 415200734,
 128863,
 -1,
 415383560,
 128782,
 415570124,
 414877283,
 -1,
 415635656,
 415516202,
 -1,
 -59193,
 415573432,
 128840,
 -1,
 415630219,
 128809,
 415832266,
 415569590,
 128831,
 -1,
 415762530,
 128832,
 -59189,
 415798234,
 128845,
 -1,
 415922106,
 128849,
 416094419,
 415521059,
 -1,
 416159953,
 416035362,
 128784,
 416284671,
 416090208,
 -1,
 -59184,
 416156445,
 128786,
 -1,
 416221765,
 128785,
 -59182,
 416114694,
 128881,
 -1,
 416355721,
 128824,
 416553178,
 416038037,
 -1,
 416618711,
 416506859,
 -1,
 -59178,
 416584316,
 128878,
 -1,
 416644208,
 128854,
 416874495,
 416551580,
 -1,
 -59175,
 416770758,
 128883,
 -1,
 416820255,
 128882,
 417011936,
 416491106,
 -1,
 417077471,
 416959135,
 -1,
 417143006,
 417039130,
 128865,
 -1,
 417073250,
 128866,
 -1,
 417106428,
 128864,
 -1,
 417011867,
 128880,
 417405156,
 416959093,
 -1,
 417470691,
 417334155,
 128796,
 -1,
 417400930,
 128797,
 -1,
 417400946,
 128801,
 417667303,
 417371950,
 -1,
 -59162,
 417635370,
 128842,
 -1,
 417695769,
 128772,
 417863914,
 417624988,
 -1,
 -59159,
 417817422,
 128768,
 -1,
 417866226,
 128833,
 418060525,
 417816860,
 -1,
 -59156,
 418024343,
 128789,
 -1,
 418069257,
 128879,
 418257136,
 418009036,
 -1,
 -59153,
 418210985,
 128851,
 -1,
 418262336,
 128810,
 418453747,
 418199910,
 -1,
 -59150,
 418418825,
 128841,
 -1,
 418473364,
 128794,
 -59148,
 418419357,
 128853,
 -59147,
 418604356,
 128838,
 -59146,
 418657906,
 128770,
 -1,
 418721135,
 128771,
 -59144,
 408181027,
 983201,
 -59143,
 418857987,
 128126,
 -59142,
 418919084,
 983054,
 -1,
 418977303,
 9200,
 419174770,
 408102498,
 -1,
 419240301,
 419123365,
 -1,
 419305769,
 419175942,
 -1,
 419371304,
 419239242,
 -1,
 419436803,
 419323519,
 -1,
 -59135,
 419405145,
 125209,
 -59134,
 419467452,
 125200,
 -1,
 419511459,
 125211,
 419698951,
 419384707,
 -1,
 -59131,
 419655707,
 125216,
 -59130,
 419708067,
 125213,
 -1,
 419762499,
 125201,
 419961098,
 419667179,
 -1,
 -59127,
 419905119,
 125198,
 -1,
 419958628,
 125202,
 420157709,
 419921124,
 -1,
 -59124,
 420104344,
 125189,
 -1,
 420166819,
 125217,
 420354320,
 420100454,
 -1,
 -59121,
 420288972,
 125214,
 -1,
 420351844,
 125208,
 420550931,
 420292194,
 -1,
 -59118,
 420494499,
 125197,
 -1,
 420548538,
 125185,
 420747542,
 420485312,
 -1,
 -59115,
 420691551,
 125191,
 -1,
 420745060,
 125188,
 -59113,
 420716434,
 125215,
 -59112,
 420911073,
 125199,
 -59111,
 420975625,
 125212,
 -59110,
 421039647,
 125203,
 -59109,
 421104874,
 125210,
 -59108,
 421164029,
 125192,
 -59107,
 421229178,
 125207,
 -59106,
 421293644,
 125190,
 -59105,
 421356523,
 125196,
 -59104,
 421420211,
 125187,
 -59103,
 421482529,
 125186,
 -59102,
 421547321,
 125204,
 -59101,
 421610122,
 125195,
 -59100,
 421674147,
 125206,
 -59099,
 421737691,
 125194,
 -59098,
 421801131,
 125193,
 -59097,
 421863630,
 125205,
 -1,
 421925555,
 125184,
 -1,
 419325933,
 125256,
 422189395,
 419267118,
 -1,
 422254894,
 422141567,
 -1,
 -59092,
 422223193,
 125243,
 -59091,
 422285500,
 125234,
 -1,
 422329507,
 125245,
 422517042,
 422202755,
 -1,
 -59088,
 422473755,
 125250,
 -59087,
 422526115,
 125247,
 -1,
 422580547,
 125235,
 422779189,
 422485227,
 -1,
 -59084,
 422723167,
 125232,
 -1,
 422776676,
 125236,
 422975800,
 422739172,
 -1,
 -59081,
 422922392,
 125223,
 -1,
 422984867,
 125251,
 423172411,
 422918502,
 -1,
 -59078,
 423107020,
 125248,
 -1,
 423169892,
 125242,
 423369022,
 423110242,
 -1,
 -59075,
 423312547,
 125231,
 -1,
 423366586,
 125219,
 423565633,
 423303360,
 -1,
 -59072,
 423509599,
 125225,
 -1,
 423563108,
 125222,
 -59070,
 423534482,
 125249,
 -59069,
 423729121,
 125233,
 -59068,
 423793673,
 125246,
 -59067,
 423857695,
 125237,
 -59066,
 423922922,
 125244,
 -59065,
 423982077,
 125226,
 -59064,
 424047226,
 125241,
 -59063,
 424111692,
 125224,
 -59062,
 424174571,
 125230,
 -59061,
 424238259,
 125221,
 -59060,
 424300577,
 125220,
 -59059,
 424365369,
 125238,
 -59058,
 424428170,
 125229,
 -59057,
 424492195,
 125240,
 -59056,
 424555739,
 125228,
 -59055,
 424619179,
 125227,
 -59054,
 424681678,
 125239,
 -1,
 424743603,
 125218,
 424941921,
 422127875,
 -1,
 425007447,
 424904291,
 -1,
 -59050,
 424975106,
 125266,
 -1,
 425017698,
 125267,
 425204058,
 424967396,
 -1,
 -59047,
 425151533,
 125270,
 -1,
 425210823,
 125271,
 425400669,
 425145527,
 -1,
 -59044,
 425356002,
 125268,
 -1,
 425413519,
 125269,
 -59042,
 425369582,
 125264,
 -59041,
 425551533,
 125265,
 -59040,
 425615679,
 125273,
 -1,
 425668446,
 125272,
 425859428,
 424894079,
 -1,
 -59037,
 425824327,
 125258,
 -1,
 425858791,
 125259,
 426056039,
 425805935,
 -1,
 -59034,
 426013559,
 125279,
 -1,
 426062925,
 125278,
 426252650,
 425998941,
 -1,
 -59031,
 426199424,
 125254,
 -1,
 426257584,
 125257,
 -59029,
 426219219,
 125253,
 -59028,
 426392945,
 125255,
 -1,
 426447544,
 125252,
 426645872,
 419191075,
 -1,
 -59025,
 426593015,
 127903,
 -1,
 426652452,
 11237,
 -59023,
 426610821,
 129489,
 -1,
 426786670,
 129657,
 426973634,
 419119282,
 -1,
 427039128,
 426923161,
 -1,
 427104633,
 426970980,
 71442,
 427229183,
 427055316,
 -1,
 -59017,
 427132658,
 71429,
 -59016,
 427178399,
 71446,
 -1,
 427235537,
 71450,
 427432317,
 427056767,
 -1,
 -59013,
 427400537,
 71440,
 -59012,
 427440543,
 71426,
 -1,
 427495268,
 71427,
 427694464,
 427394659,
 -1,
 -59009,
 427637923,
 71436,
 -1,
 427691876,
 71428,
 427891075,
 427650232,
 -1,
 -59006,
 427834531,
 71431,
 -1,
 427888484,
 71430,
 428087686,
 427838851,
 -1,
 -59003,
 428031139,
 71425,
 -1,
 428085092,
 71424,
 428284297,
 428035253,
 -1,
 -59000,
 428227747,
 71449,
 -1,
 428281700,
 71434,
 428480908,
 428226918,
 -1,
 -58997,
 428424355,
 71447,
 -1,
 428478308,
 71445,
 428677519,
 428418658,
 -1,
 -58994,
 428620963,
 71444,
 -1,
 428674916,
 71443,
 428874130,
 428611776,
 -1,
 -58991,
 428817571,
 71448,
 -1,
 428871524,
 71432,
 -58989,
 428834174,
 71439,
 -58988,
 429028349,
 71437,
 -58987,
 429087085,
 71433,
 -58986,
 429150238,
 71438,
 -58985,
 429210787,
 71441,
 -1,
 429269043,
 71435,
 429463972,
 427005668,
 -1,
 429529502,
 429395812,
 71456,
 -58981,
 429496086,
 71463,
 -58980,
 429545763,
 71466,
 -58979,
 429605514,
 71465,
 -1,
 429657956,
 71457,
 429857184,
 429493791,
 71460,
 -1,
 429821471,
 71461,
 429988258,
 429802122,
 71458,
 -1,
 429933194,
 71459,
 -58973,
 429941739,
 71464,
 -1,
 430058667,
 71462,
 430250418,
 429402371,
 -1,
 430315944,
 430212707,
 -1,
 -58969,
 430283522,
 71474,
 -1,
 430326114,
 71475,
 430512555,
 430275812,
 -1,
 -58966,
 430459949,
 71478,
 -1,
 430519239,
 71479,
 430709166,
 430453943,
 -1,
 -58963,
 430664418,
 71476,
 -1,
 430721935,
 71477,
 -58961,
 430677998,
 71472,
 -58960,
 430859949,
 71473,
 -58959,
 430924095,
 71481,
 -1,
 430976862,
 71480,
 431167930,
 430210276,
 -1,
 431233465,
 431113539,
 -1,
 431298999,
 431193316,
 -1,
 -58954,
 431249949,
 71484,
 -1,
 431304137,
 71485,
 -58952,
 431258807,
 71486,
 -1,
 431443675,
 71467,
 -1,
 431202014,
 71487,
 431692223,
 431105000,
 -1,
 431757758,
 431640524,
 -1,
 -58947,
 431703105,
 71455,
 -1,
 431755108,
 71453,
 -1,
 431715325,
 71454,
 432078847,
 431645600,
 -1,
 -58943,
 431986787,
 71483,
 -1,
 432025680,
 71482,
 432216521,
 426937887,
 -1,
 432282056,
 432179861,
 -1,
 432347591,
 432232739,
 -1,
 -58938,
 432301109,
 128663,
 -1,
 432347020,
 127975,
 -1,
 432276563,
 128762,
 -1,
 432216641,
 127814,
 432675278,
 432178241,
 -1,
 432740813,
 432632745,
 -1,
 -58932,
 432695240,
 9954,
 -1,
 432738547,
 11225,
 -1,
 432695172,
 128562,
 433002962,
 432630968,
 -1,
 -58928,
 432959448,
 983194,
 -58927,
 433022398,
 11236,
 -1,
 433069574,
 983195,
 433265110,
 432953635,
 -1,
 -58924,
 433221419,
 127994,
 -58923,
 433271375,
 127944,
 -1,
 433331624,
 128657,
 433527257,
 433212026,
 -1,
 -58920,
 433465411,
 128747,
 -1,
 433526364,
 128748,
 433723867,
 433463782,
 983053,
 -1,
 433676991,
 983052,
 -58916,
 433691762,
 129683,
 -58915,
 433821283,
 129361,
 -58914,
 433883327,
 128095,
 -58913,
 433926721,
 128673,
 -1,
 433985822,
 129518,
 434184161,
 341907648,
 -1,
 434249158,
 434114404,
 -1,
 434314516,
 434200151,
 -1,
 434379458,
 434252973,
 -1,
 434444832,
 434331263,
 -1,
 434510335,
 434387302,
 -1,
 434575855,
 434457987,
 -1,
 434641386,
 434540063,
 -1,
 -58903,
 434597048,
 92598,
 -1,
 434657571,
 92619,
 434837997,
 434582330,
 -1,
 -58900,
 434805802,
 92543,
 -1,
 434835703,
 92553,
 435093503,
 434769764,
 92531,
 -1,
 434967407,
 92601,
 435165688,
 434518374,
 -1,
 435231220,
 435129887,
 -1,
 -58894,
 435188782,
 92550,
 -58893,
 435252408,
 92624,
 -1,
 435294511,
 92563,
 435552255,
 435170475,
 -1,
 435558903,
 435457712,
 92607,
 -1,
 435521123,
 92535,
 -1,
 435498610,
 92557,
 435755514,
 435130032,
 92640,
 -1,
 435717731,
 92657,
 435886589,
 435708907,
 -1,
 -58884,
 435843701,
 92544,
 -1,
 435907768,
 92541,
 -58882,
 435827600,
 92579,
 -1,
 436014948,
 92658,
 436214281,
 434447970,
 -1,
 436279813,
 436146020,
 -1,
 436345348,
 436211558,
 -1,
 -58877,
 436306688,
 92562,
 -1,
 436362862,
 92637,
 -1,
 436300984,
 92518,
 436607496,
 436224650,
 -1,
 -58873,
 436564597,
 92558,
 -1,
 436606317,
 92592,
 -1,
 436572348,
 92528,
 436869647,
 436161717,
 -1,
 436935182,
 436808875,
 -1,
 437000717,
 436874411,
 92628,
 -1,
 436928981,
 92648,
 -1,
 436966380,
 92547,
 -1,
 436867329,
 92554,
 437262868,
 436830083,
 -1,
 437328403,
 437227039,
 -1,
 -58862,
 437282917,
 92527,
 -1,
 437333163,
 92545,
 -1,
 437273599,
 92540,
 437590551,
 437231405,
 -1,
 -58858,
 437555823,
 92609,
 -1,
 437589357,
 92583,
 437787162,
 437558798,
 -1,
 -58855,
 437723741,
 92589,
 -1,
 437787225,
 92608,
 437983773,
 437749347,
 -1,
 -58852,
 437948553,
 92604,
 -1,
 437982501,
 92622,
 438180383,
 437915492,
 92662,
 -1,
 438119595,
 92613,
 -1,
 438128467,
 92584,
 438377016,
 434400440,
 -1,
 438442535,
 438341151,
 92576,
 438508069,
 438374244,
 -1,
 -58844,
 438465141,
 92618,
 -1,
 438512811,
 92529,
 -58842,
 438458659,
 92561,
 -1,
 438643883,
 92649,
 438835757,
 438374244,
 -1,
 438901290,
 438767460,
 92524,
 -1,
 438851875,
 92536,
 439091199,
 438830061,
 -1,
 -58836,
 438982932,
 92634,
 -1,
 439038322,
 92625,
 439228977,
 438780554,
 92663,
 439353343,
 439168171,
 -1,
 -58832,
 439256675,
 92621,
 -1,
 439300535,
 92593,
 439491126,
 439168171,
 -1,
 439556661,
 439455263,
 -1,
 -58828,
 439524394,
 92647,
 -1,
 439584355,
 92605,
 -1,
 439496739,
 92548,
 439877631,
 439444459,
 92568,
 -1,
 439772751,
 92610,
 439949899,
 438327587,
 -1,
 440015422,
 439881572,
 92667,
 440080956,
 439954603,
 92600,
 -1,
 440031523,
 92542,
 -58819,
 440038005,
 92668,
 -1,
 440167608,
 92555,
 440343104,
 439960202,
 92654,
 -1,
 440282735,
 92611,
 440474179,
 440285725,
 -1,
 -58814,
 440414288,
 92581,
 -1,
 440471396,
 92551,
 440670790,
 440408524,
 -1,
 -58811,
 440635529,
 92520,
 -1,
 440675499,
 92582,
 -58809,
 440636899,
 92617,
 -58808,
 440831664,
 92614,
 -58807,
 440886863,
 92671,
 -58806,
 440939914,
 92591,
 -1,
 441004112,
 92666,
 441195102,
 439912035,
 -1,
 441260626,
 441126756,
 -1,
 441326159,
 441192292,
 92635,
 -1,
 441283189,
 92577,
 -58800,
 441283189,
 92636,
 -58799,
 441407779,
 92530,
 -1,
 441462871,
 92559,
 441653846,
 441224735,
 -1,
 441719381,
 441604387,
 92586,
 -1,
 441651440,
 92569,
 -1,
 441651440,
 92566,
 441915994,
 441607147,
 -1,
 441981529,
 441869291,
 92537,
 -1,
 441933439,
 92519,
 -1,
 441938549,
 92630,
 442236927,
 441855147,
 -1,
 442243677,
 442142239,
 92669,
 -1,
 442175781,
 92572,
 -1,
 442195583,
 92672,
 442440304,
 441162987,
 -1,
 442505828,
 442404383,
 -1,
 -58783,
 442462837,
 92644,
 -58782,
 442523263,
 92645,
 -58781,
 442577335,
 92594,
 -1,
 442634510,
 92641,
 442833513,
 442446650,
 -1,
 442899047,
 442765552,
 92567,
 -1,
 442861155,
 92623,
 -58776,
 442866730,
 92639,
 -1,
 442980643,
 92606,
 443161196,
 442788073,
 -1,
 -58773,
 443123185,
 92642,
 -1,
 443163823,
 92643,
 443357807,
 443105930,
 -1,
 -58770,
 443319907,
 92590,
 -1,
 443362927,
 92564,
 -1,
 443290917,
 92588,
 443619964,
 442399972,
 -1,
 443685494,
 443563157,
 -1,
 443751028,
 443638763,
 92659,
 -1,
 443708021,
 92660,
 -58763,
 443697609,
 92638,
 -1,
 443822940,
 92580,
 444013177,
 443624619,
 -1,
 -58760,
 443975267,
 92560,
 -1,
 444017835,
 92534,
 -58758,
 443977401,
 92571,
 -58757,
 444163538,
 92525,
 -1,
 444207026,
 92549,
 444406409,
 443568076,
 -1,
 444471939,
 444359659,
 -1,
 444537473,
 444425195,
 -1,
 -58752,
 444499555,
 92556,
 -1,
 444554879,
 92523,
 -58750,
 444494453,
 92664,
 -1,
 444684579,
 92539,
 444865159,
 444403556,
 -1,
 -58747,
 444822133,
 92633,
 -58746,
 444886200,
 92521,
 -1,
 444928836,
 92575,
 -58744,
 444829215,
 92653,
 -1,
 445068105,
 92595,
 445258390,
 444353923,
 -1,
 445323918,
 445222431,
 -1,
 -58740,
 445285987,
 92620,
 -58739,
 445343845,
 92538,
 -1,
 445395699,
 92587,
 445586067,
 445263019,
 -1,
 445651602,
 445550111,
 -1,
 -58735,
 445619242,
 92646,
 -1,
 445649136,
 92570,
 -1,
 445613667,
 92599,
 -58732,
 445542155,
 92532,
 -58731,
 445866987,
 92665,
 -1,
 445923978,
 92670,
 446110370,
 445199543,
 -1,
 446175902,
 446074399,
 -1,
 446241436,
 446103552,
 -1,
 -58726,
 446199497,
 92661,
 -58725,
 446251658,
 92616,
 -1,
 446307945,
 92626,
 446562303,
 446180523,
 92596,
 -1,
 446465635,
 92612,
 446634656,
 446107492,
 92603,
 -1,
 446591605,
 92673,
 -58719,
 446588370,
 92627,
 -1,
 446705263,
 92651,
 446896815,
 446052710,
 -1,
 446962348,
 446839957,
 -1,
 447027882,
 446901419,
 -1,
 447093417,
 446991903,
 -1,
 -58713,
 447061034,
 92552,
 -58712,
 447110783,
 92565,
 -1,
 447156464,
 92615,
 -1,
 447055459,
 92602,
 -58709,
 446981586,
 92674,
 -1,
 447352771,
 92578,
 447610879,
 446896588,
 -1,
 -58706,
 447517676,
 92597,
 -1,
 447579747,
 92585,
 447748789,
 446854057,
 -1,
 447814323,
 447680356,
 -1,
 -58702,
 447771253,
 92526,
 -1,
 447818923,
 92656,
 -58700,
 447759882,
 92546,
 -1,
 447951800,
 92655,
 448142010,
 447715094,
 -1,
 448207545,
 448106015,
 -1,
 -58696,
 448160747,
 92533,
 -1,
 448212139,
 92650,
 -1,
 448148408,
 92574,
 448469695,
 448107511,
 -1,
 448535230,
 448408747,
 -1,
 -58691,
 448499376,
 92573,
 -1,
 448539819,
 92652,
 -1,
 448488914,
 92522,
 -58688,
 448422891,
 92631,
 -58687,
 448742026,
 92632,
 -1,
 448794468,
 92629,
 448994153,
 434316900,
 -1,
 449059575,
 448945791,
 -1,
 449125077,
 449001830,
 -1,
 449190605,
 449072515,
 -1,
 449256137,
 449131322,
 -1,
 -58680,
 449214362,
 92432,
 -1,
 449253669,
 92457,
 -58678,
 449224101,
 92435,
 -58677,
 449417404,
 92412,
 -58676,
 449463295,
 92476,
 -1,
 449516837,
 92414,
 449773567,
 449132902,
 -1,
 449780434,
 449646436,
 -1,
 449845969,
 449712964,
 92465,
 -1,
 449777904,
 92409,
 -1,
 449801400,
 92483,
 -58669,
 449746741,
 92467,
 -58668,
 450007326,
 92485,
 -1,
 450048952,
 92475,
 450239197,
 449072309,
 -1,
 450304728,
 450183818,
 92403,
 -1,
 450244207,
 92405,
 450435803,
 450245434,
 -1,
 -58662,
 450397795,
 92407,
 -1,
 450433271,
 92430,
 -58660,
 450400233,
 92487,
 -1,
 450565413,
 92418,
 450763493,
 450198756,
 -1,
 450829025,
 450708479,
 -1,
 -58656,
 450791011,
 92459,
 -1,
 450849976,
 92447,
 451025636,
 450772117,
 -1,
 -58653,
 450990987,
 92486,
 -1,
 451030639,
 92408,
 -1,
 450990217,
 92480,
 451287786,
 450731243,
 -1,
 -58649,
 451252170,
 92463,
 -58648,
 451297930,
 92493,
 -58647,
 451359475,
 92450,
 -1,
 451416900,
 92410,
 451615472,
 451225186,
 -1,
 451681006,
 451554475,
 -1,
 -58643,
 451646444,
 92425,
 -1,
 451685547,
 92437,
 -58641,
 451634767,
 92440,
 -1,
 451810116,
 92471,
 452008693,
 451577443,
 -1,
 452074228,
 451947691,
 -1,
 -58637,
 452038793,
 92472,
 -1,
 452078763,
 92505,
 -1,
 452039647,
 92514,
 -58634,
 451972639,
 92503,
 -1,
 452280970,
 92507,
 452467474,
 449009955,
 92497,
 452532991,
 452408503,
 -1,
 452598523,
 452486123,
 92445,
 -1,
 452550271,
 92404,
 452729598,
 452539194,
 -1,
 -58627,
 452691555,
 92424,
 -1,
 452727024,
 92458,
 -1,
 452674559,
 92466,
 452991747,
 452475421,
 -1,
 -58623,
 452945129,
 92438,
 -58622,
 453002239,
 92444,
 -1,
 453063535,
 92442,
 453253896,
 452930731,
 -1,
 453319431,
 453217823,
 -1,
 -58618,
 453281379,
 92427,
 -1,
 453336703,
 92478,
 -1,
 453258866,
 92496,
 453581580,
 453187776,
 -1,
 453647115,
 453513138,
 92448,
 -1,
 453575856,
 92515,
 -1,
 453611803,
 92401,
 453843727,
 453513060,
 -1,
 -58610,
 453792400,
 92426,
 -1,
 453849313,
 92482,
 -58608,
 453809833,
 92510,
 -58607,
 454004255,
 92499,
 -1,
 454059904,
 92441,
 454236965,
 452426980,
 -1,
 454302492,
 454179989,
 -1,
 454368025,
 454241451,
 -1,
 454433560,
 454331935,
 -1,
 -58601,
 454401066,
 92501,
 -1,
 454430960,
 92417,
 -1,
 454372523,
 92413,
 -58598,
 454331935,
 92504,
 -58597,
 454650086,
 92508,
 -1,
 454706589,
 92500,
 454892320,
 454266399,
 -1,
 -58594,
 454856223,
 92498,
 -58593,
 454896811,
 92419,
 -1,
 454955248,
 92473,
 455154467,
 454823780,
 -1,
 -58590,
 455111285,
 92516,
 -1,
 455175352,
 92423,
 -58588,
 455109056,
 92452,
 -1,
 455291740,
 92428,
 455482163,
 454184323,
 -1,
 455547693,
 455421099,
 -1,
 455613228,
 455511583,
 -1,
 -58583,
 455568568,
 92460,
 -58582,
 455633347,
 92431,
 -58581,
 455694627,
 92454,
 -1,
 455741755,
 92415,
 -1,
 455575139,
 92420,
 456006449,
 455511583,
 92489,
 -58577,
 455963253,
 92479,
 -58576,
 456025554,
 92422,
 -1,
 456089215,
 92474,
 -58574,
 455974309,
 92502,
 -1,
 456234810,
 92449,
 456399679,
 455444067,
 -1,
 456465210,
 456338603,
 -1,
 456530745,
 456429087,
 -1,
 -58569,
 456492643,
 92416,
 -58568,
 456547967,
 92481,
 -1,
 456593678,
 92451,
 -1,
 456470130,
 92456,
 456858428,
 456429087,
 92433,
 -1,
 456812992,
 92477,
 -58563,
 456812774,
 92492,
 -58562,
 456934026,
 92513,
 -1,
 456986864,
 92491,
 457186121,
 456347596,
 -1,
 457251654,
 457125035,
 -1,
 457317188,
 457215519,
 -1,
 -58557,
 457267491,
 92484,
 -1,
 457314587,
 92439,
 -58555,
 457279075,
 92464,
 -1,
 457453170,
 92495,
 -58553,
 457216137,
 92446,
 -58552,
 457599206,
 92511,
 -1,
 457655295,
 92406,
 457841490,
 457141432,
 -1,
 457907021,
 457805343,
 -1,
 -58548,
 457872267,
 92443,
 -1,
 457929333,
 92509,
 458103632,
 457845931,
 -1,
 -58545,
 458068882,
 92462,
 -1,
 458108075,
 92506,
 -58543,
 458049929,
 92461,
 -1,
 458233125,
 92469,
 458431322,
 457809131,
 -1,
 458496856,
 458395167,
 -1,
 458562391,
 458449899,
 -1,
 -58538,
 458517688,
 92470,
 -1,
 458578211,
 92468,
 -1,
 458529711,
 92453,
 -58535,
 458436688,
 92429,
 -1,
 458756359,
 92421,
 458955616,
 458388393,
 -1,
 459021150,
 458895443,
 -1,
 -58531,
 458974612,
 92490,
 -1,
 459038281,
 92512,
 -58529,
 458966429,
 92494,
 -1,
 459149559,
 92455,
 459348835,
 458921750,
 -1,
 -58526,
 459312825,
 92411,
 -1,
 459347237,
 92402,
 459545446,
 459291360,
 -1,
 -58523,
 459486020,
 92488,
 -1,
 459542450,
 92434,
 459800575,
 459486391,
 -1,
 -58520,
 459682658,
 92436,
 -1,
 459739058,
 92517,
 459938812,
 448929288,
 -1,
 460004254,
 459890303,
 -1,
 460069752,
 459946342,
 -1,
 460135283,
 460011878,
 -1,
 460200818,
 460099103,
 92362,
 -58513,
 460154447,
 92341,
 -58512,
 460216611,
 92347,
 -58511,
 460271299,
 92370,
 -1,
 460329234,
 92336,
 -1,
 460140624,
 92307,
 460594038,
 460082563,
 -1,
 -58507,
 460558289,
 92303,
 -1,
 460592493,
 92309,
 -58505,
 460547538,
 92368,
 -1,
 460723565,
 92395,
 460921728,
 460029156,
 -1,
 460987260,
 460885535,
 -1,
 -58501,
 460941772,
 92359,
 -1,
 461004415,
 92374,
 -58499,
 460940754,
 92371,
 -58498,
 461127184,
 92351,
 -58497,
 461189967,
 92325,
 -1,
 461246308,
 92350,
 461446025,
 460858978,
 -1,
 461511556,
 461386554,
 -1,
 -58493,
 461473379,
 92349,
 -1,
 461508905,
 92308,
 461708167,
 461442916,
 -1,
 -58490,
 461663416,
 92378,
 -1,
 461723939,
 92375,
 -58488,
 461661734,
 92317,
 -1,
 461849554,
 92331,
 462035857,
 461393077,
 -1,
 462101389,
 461974699,
 -1,
 -58484,
 462066668,
 92389,
 -1,
 462106226,
 92360,
 462298000,
 462032740,
 -1,
 -58481,
 462248227,
 92367,
 -1,
 462303267,
 92356,
 -1,
 462262249,
 92333,
 462560151,
 461997667,
 -1,
 462625685,
 462498987,
 -1,
 -58476,
 462590219,
 92345,
 -1,
 462642815,
 92372,
 -58474,
 462589487,
 92314,
 -1,
 462753714,
 92340,
 462953370,
 462528301,
 -1,
 -58471,
 462893931,
 92323,
 -1,
 462950244,
 92304,
 463149981,
 462884708,
 -1,
 -58468,
 463106677,
 92396,
 -1,
 463168244,
 92338,
 -1,
 463117911,
 92313,
 463412155,
 459954467,
 -1,
 463477681,
 463345856,
 -1,
 463543206,
 463416491,
 -1,
 463608740,
 463506975,
 -1,
 -58461,
 463576106,
 92385,
 -1,
 463624483,
 92315,
 -58459,
 463565870,
 92354,
 -1,
 463744952,
 92311,
 463936425,
 463487626,
 92381,
 -58456,
 463898211,
 92326,
 -1,
 463960011,
 92343,
 464133038,
 463867748,
 -1,
 464198573,
 464064358,
 -1,
 -58452,
 464154420,
 92387,
 -1,
 464199205,
 92318,
 -1,
 464151517,
 92383,
 464519167,
 464096799,
 -1,
 -58448,
 464399531,
 92324,
 -1,
 464457975,
 92364,
 464657336,
 463408996,
 -1,
 464722869,
 464596139,
 -1,
 -58444,
 464683261,
 92363,
 -1,
 464738984,
 92382,
 464977919,
 464650240,
 -1,
 -58441,
 464872204,
 92376,
 -1,
 464932524,
 92339,
 -58439,
 464621232,
 92391,
 -58438,
 465060863,
 92390,
 -1,
 465123878,
 92344,
 465312716,
 463359363,
 -1,
 465378247,
 465251499,
 -1,
 465443779,
 465341983,
 -1,
 465509313,
 465403108,
 -1,
 -58432,
 465452942,
 92319,
 -1,
 465515448,
 92384,
 -58430,
 465459491,
 92386,
 -1,
 465653264,
 92321,
 465836998,
 465395329,
 -1,
 -58427,
 465785249,
 92393,
 -1,
 465843518,
 92394,
 -1,
 465798755,
 92361,
 466099146,
 465341983,
 -1,
 -58423,
 466060899,
 92366,
 -1,
 466118760,
 92373,
 -58421,
 466054562,
 92328,
 -1,
 466227122,
 92329,
 466426835,
 465280235,
 -1,
 466492369,
 466390559,
 -1,
 -58417,
 466459567,
 92388,
 -58416,
 466508067,
 92305,
 -1,
 466551553,
 92322,
 -58414,
 466432902,
 92327,
 -1,
 466685874,
 92377,
 466885595,
 466388579,
 -1,
 466951127,
 466832162,
 -1,
 -58410,
 466915006,
 92358,
 -1,
 466947984,
 92334,
 467147738,
 466889899,
 -1,
 -58407,
 467112871,
 92346,
 -1,
 467175011,
 92400,
 -1,
 467079119,
 92332,
 467409891,
 466844900,
 -1,
 467475423,
 467352725,
 -1,
 -58402,
 467439593,
 92379,
 -1,
 467487177,
 92392,
 467672034,
 467414187,
 -1,
 -58399,
 467637228,
 92330,
 -1,
 467699786,
 92380,
 -1,
 467635914,
 92335,
 467934185,
 467357644,
 -1,
 467999719,
 467865444,
 -1,
 -58394,
 467954872,
 92342,
 -1,
 468015395,
 92357,
 -58392,
 467963423,
 92365,
 -1,
 468142537,
 92397,
 468327406,
 467889336,
 -1,
 468392941,
 468271754,
 -1,
 -58388,
 468350923,
 92316,
 -1,
 468409983,
 92398,
 -1,
 468332624,
 92399,
 468655091,
 468269414,
 -1,
 468720626,
 468597923,
 -1,
 -58383,
 468677678,
 92310,
 -1,
 468741304,
 92320,
 -1,
 468654505,
 92312,
 468982774,
 468621078,
 -1,
 -58379,
 468947238,
 92369,
 -1,
 468980860,
 92306,
 469179385,
 468948418,
 -1,
 -58376,
 469146666,
 92337,
 -1,
 469176607,
 92353,
 -58374,
 469138596,
 92355,
 -58373,
 469317976,
 92348,
 -1,
 469376432,
 92352,
 469572730,
 459870054,
 -1,
 469638176,
 469524095,
 -1,
 469703684,
 469599843,
 -1,
 469769219,
 469636389,
 92223,
 469893119,
 469696512,
 -1,
 -58366,
 469787448,
 92194,
 -1,
 469851125,
 92185,
 -1,
 469723386,
 92178,
 470096906,
 469645670,
 -1,
 470162440,
 470044550,
 -1,
 -58361,
 470115301,
 92182,
 -1,
 470155996,
 92160,
 -58359,
 470104726,
 92229,
 -1,
 470291625,
 92173,
 470490126,
 470064363,
 -1,
 470555661,
 470434442,
 92239,
 -1,
 470517413,
 92225,
 -1,
 470495987,
 92233,
 470752273,
 470458157,
 -1,
 -58352,
 470716607,
 92191,
 -1,
 470749053,
 92167,
 470948884,
 470712195,
 -1,
 -58349,
 470893567,
 92237,
 -1,
 470945636,
 92241,
 471145495,
 470896003,
 -1,
 -58346,
 471091001,
 92180,
 -1,
 471142345,
 92227,
 471342106,
 471082734,
 -1,
 -58343,
 471274604,
 92212,
 -1,
 471335554,
 92201,
 471538717,
 471273316,
 -1,
 -58340,
 471495285,
 92245,
 -1,
 471535485,
 92164,
 -58338,
 471485682,
 92231,
 -58337,
 471680416,
 92204,
 -1,
 471740496,
 92244,
 471931959,
 469588259,
 -1,
 471997484,
 471863140,
 -1,
 472063018,
 471936171,
 -1,
 472128551,
 472013091,
 92238,
 -58331,
 472094165,
 92174,
 -58330,
 472141663,
 92203,
 -1,
 472193696,
 92171,
 -58328,
 472088829,
 92230,
 -58327,
 472343517,
 92210,
 -1,
 472403636,
 92186,
 -58325,
 472018119,
 92221,
 -1,
 472539930,
 92175,
 472718385,
 471950315,
 -1,
 472783920,
 472671698,
 -1,
 -58321,
 472740414,
 92198,
 -1,
 472789940,
 92214,
 -1,
 472735364,
 92190,
 473046068,
 472651985,
 -1,
 -58317,
 473002613,
 92246,
 -1,
 473064413,
 92232,
 -58315,
 473011654,
 92176,
 -58314,
 473184800,
 92196,
 -1,
 473248627,
 92197,
 473439303,
 471891172,
 -1,
 473504832,
 473382037,
 -1,
 473570364,
 473468447,
 -1,
 -58309,
 473520419,
 92215,
 -1,
 473575692,
 92165,
 473766975,
 473514634,
 -1,
 -58306,
 473723950,
 92222,
 -1,
 473784212,
 92168,
 -1,
 473721069,
 92224,
 474029124,
 473457643,
 -1,
 -58302,
 473990755,
 92235,
 -58301,
 474051189,
 92220,
 -1,
 474112447,
 92208,
 -58299,
 473994207,
 92181,
 -58298,
 474237602,
 92195,
 -1,
 474297215,
 92177,
 474487896,
 473394360,
 -1,
 474553423,
 474419044,
 -1,
 474618956,
 474484580,
 -1,
 -58293,
 474575918,
 92226,
 -1,
 474634531,
 92236,
 -58291,
 474578933,
 92187,
 -58290,
 474766858,
 92189,
 -1,
 474808962,
 92200,
 475012182,
 474506834,
 -1,
 475077715,
 474967285,
 -1,
 -58286,
 475019821,
 92169,
 -1,
 475076817,
 92170,
 475332607,
 475028474,
 -1,
 -58283,
 475216429,
 92162,
 -1,
 475273425,
 92163,
 -58281,
 474976550,
 92205,
 -1,
 475411187,
 92202,
 475602017,
 474434947,
 -1,
 475667548,
 475540651,
 -1,
 -58277,
 475631678,
 92179,
 -1,
 475694691,
 92211,
 475864159,
 475598692,
 -1,
 -58274,
 475820661,
 92240,
 -1,
 475870427,
 92199,
 -58272,
 475828514,
 92213,
 -1,
 476016799,
 92219,
 476191849,
 475563619,
 -1,
 476257381,
 476155423,
 -1,
 -58268,
 476188955,
 92206,
 -1,
 476250821,
 92172,
 476453992,
 476197690,
 -1,
 -58265,
 476416062,
 92209,
 -1,
 476451086,
 92234,
 -1,
 476400436,
 92166,
 476716143,
 476139468,
 -1,
 476781676,
 476679711,
 92243,
 -1,
 476713243,
 92207,
 -58259,
 476735045,
 92216,
 -58258,
 476852982,
 92184,
 -1,
 476910888,
 92183,
 477109364,
 476658022,
 -1,
 477174899,
 477052808,
 -1,
 -58254,
 477131822,
 92188,
 -1,
 477182708,
 92193,
 -1,
 477108954,
 92161,
 477437047,
 477072927,
 -1,
 -58250,
 477389266,
 92228,
 -1,
 477431895,
 92192,
 -58248,
 477402227,
 92242,
 -58247,
 477592452,
 92218,
 -1,
 477640323,
 92217,
 477830347,
 469506242,
 -1,
 477895822,
 477780259,
 -1,
 477961347,
 477829312,
 -1,
 478026880,
 477892452,
 -1,
 -58241,
 477959551,
 92255,
 -1,
 478020285,
 92252,
 -58239,
 477991202,
 92292,
 -58238,
 478169893,
 92268,
 -1,
 478229399,
 92286,
 478420103,
 477892452,
 92300,
 478543871,
 478348044,
 -1,
 -58234,
 478450290,
 92296,
 -1,
 478491477,
 92295,
 478682250,
 478360759,
 -1,
 -58231,
 478635623,
 92267,
 -1,
 478694541,
 92284,
 478878861,
 478622522,
 -1,
 -58228,
 478840498,
 92290,
 -1,
 478900853,
 92281,
 -1,
 478832651,
 92287,
 479141023,
 477847167,
 -1,
 479206551,
 479082854,
 -1,
 479272085,
 479148390,
 -1,
 479337619,
 479236386,
 92282,
 -1,
 479265403,
 92283,
 -58220,
 479277885,
 92277,
 -1,
 479399871,
 92298,
 -58218,
 479225298,
 92302,
 -1,
 479547106,
 92276,
 479730842,
 479173867,
 -1,
 -58215,
 479675049,
 92269,
 -1,
 479727867,
 92288,
 479927453,
 479689956,
 -1,
 -58212,
 479871533,
 92247,
 -1,
 479932496,
 92299,
 -58210,
 479889860,
 92260,
 -1,
 480062537,
 92261,
 480255143,
 479100132,
 -1,
 480320675,
 480198239,
 -1,
 -58206,
 480284355,
 92266,
 -1,
 480347835,
 92265,
 -58204,
 480284618,
 92285,
 -58203,
 480461823,
 92249,
 -58202,
 480523014,
 92250,
 -1,
 480580197,
 92279,
 480779440,
 480202115,
 -1,
 480844972,
 480719674,
 -1,
 -58198,
 480812544,
 92272,
 -58197,
 480866878,
 92270,
 -1,
 480907511,
 92294,
 481107119,
 480789130,
 -1,
 -58194,
 481063541,
 92301,
 -1,
 481111684,
 92253,
 -1,
 481039172,
 92256,
 481369269,
 480734392,
 -1,
 -58190,
 481333508,
 92289,
 -58189,
 481381154,
 92263,
 -58188,
 481439421,
 92257,
 -1,
 481498836,
 92274,
 481696955,
 481316812,
 -1,
 481762489,
 481628004,
 -1,
 -58184,
 481712431,
 92259,
 -1,
 481760207,
 92273,
 -58182,
 481715690,
 92251,
 -1,
 481899251,
 92297,
 482090176,
 481658467,
 -1,
 482155711,
 482053665,
 -1,
 -58178,
 482108172,
 92264,
 -1,
 482171331,
 92248,
 -1,
 482086847,
 92280,
 482417859,
 482057451,
 -1,
 -58174,
 482358154,
 92254,
 -1,
 482414982,
 92258,
 482614470,
 482360059,
 -1,
 -58171,
 482578100,
 92262,
 -1,
 482631295,
 92271,
 482811081,
 482555206,
 -1,
 -58168,
 482776044,
 92291,
 -1,
 482815147,
 92293,
 -58166,
 482778148,
 92278,
 -1,
 482973136,
 92275,
 483196927,
 477770937,
 -1,
 483204314,
 483090047,
 -1,
 483269839,
 483167775,
 92697,
 -1,
 483201264,
 92696,
 483400914,
 483216565,
 -1,
 -58159,
 483364528,
 92698,
 -1,
 483397879,
 92688,
 483597525,
 483342694,
 -1,
 -58156,
 483545013,
 92711,
 -1,
 483604895,
 92712,
 -58154,
 483565067,
 92681,
 -58153,
 483756010,
 92704,
 -58152,
 483819490,
 92702,
 -58151,
 483869322,
 92708,
 -1,
 483927823,
 92687,
 484121827,
 483163364,
 -1,
 484187359,
 484064405,
 -1,
 -58147,
 484150815,
 92700,
 -58146,
 484205547,
 92713,
 -1,
 484263325,
 92691,
 -58144,
 484152287,
 92690,
 -58143,
 484393610,
 92692,
 -58142,
 484455352,
 92693,
 -1,
 484512602,
 92727,
 484711660,
 484068739,
 -1,
 484777191,
 484650155,
 -1,
 -58138,
 484738659,
 92695,
 -1,
 484793983,
 92710,
 -58136,
 484744613,
 92694,
 -58135,
 484937247,
 92677,
 -58134,
 484994290,
 92726,
 -58133,
 485057515,
 92719,
 -1,
 485101412,
 92675,
 485301493,
 484668329,
 -1,
 485367025,
 485239979,
 -1,
 -58129,
 485331948,
 92709,
 -58128,
 485383807,
 92721,
 -1,
 485436587,
 92679,
 485629172,
 485311114,
 -1,
 -58125,
 485573258,
 92683,
 -1,
 485633647,
 92684,
 -1,
 485592607,
 92707,
 485891324,
 485251363,
 92689,
 485956857,
 485824704,
 -1,
 -58120,
 485896272,
 92720,
 -1,
 485953458,
 92724,
 -58118,
 485909483,
 92723,
 -58117,
 486092406,
 92685,
 -1,
 486149988,
 92722,
 486350081,
 485852771,
 -1,
 486415616,
 486281060,
 -1,
 -58113,
 486354091,
 92680,
 -1,
 486412132,
 92686,
 -1,
 486355699,
 92725,
 486677766,
 486304952,
 -1,
 486743301,
 486616235,
 -1,
 -58108,
 486708204,
 92703,
 -1,
 486747307,
 92706,
 -1,
 486706864,
 92714,
 487005450,
 486625228,
 -1,
 -58104,
 486959334,
 92718,
 -58103,
 487015050,
 92717,
 -1,
 487067492,
 92682,
 487267597,
 486972651,
 -1,
 -58100,
 487221478,
 92699,
 -1,
 487264100,
 92701,
 487464208,
 487233302,
 -1,
 -58097,
 487428042,
 92705,
 -1,
 487460708,
 92716,
 -58095,
 487429884,
 92728,
 -58094,
 487624223,
 92676,
 -58093,
 487667565,
 92715,
 -1,
 487730799,
 92678,
 487923038,
 434275939,
 129415,
 487988571,
 487854651,
 -1,
 488054082,
 487937177,
 -1,
 488119589,
 488013028,
 -1,
 488185123,
 488064506,
 -1,
 -58086,
 488152409,
 7132,
 -58085,
 488216366,
 7116,
 -58084,
 488275326,
 7129,
 -58083,
 488338429,
 7123,
 -58082,
 488402162,
 7112,
 -58081,
 488462701,
 7125,
 -58080,
 488525854,
 7135,
 -58079,
 488586403,
 7107,
 -58078,
 488651167,
 7119,
 -1,
 488705892,
 7105,
 -58076,
 488139691,
 7126,
 -1,
 488836964,
 7128,
 489037099,
 488070783,
 -1,
 -58073,
 489004377,
 7136,
 -58072,
 489056652,
 7127,
 -58071,
 489109919,
 7133,
 -58070,
 489170670,
 7138,
 -1,
 489230180,
 7113,
 489430322,
 488986915,
 -1,
 489495857,
 489361252,
 7124,
 489619455,
 489447327,
 -1,
 -58065,
 489520510,
 7130,
 -58064,
 489578200,
 7114,
 -1,
 489634979,
 7108,
 -1,
 489429201,
 7139,
 489889076,
 489385202,
 7111,
 -1,
 489836375,
 7117,
 -58059,
 489856345,
 7131,
 -58058,
 489985838,
 7115,
 -58057,
 490049055,
 7141,
 -58056,
 490107901,
 7122,
 -58055,
 490164254,
 7134,
 -58054,
 490229274,
 7110,
 -58053,
 490294490,
 7120,
 -58052,
 490357386,
 7140,
 -58051,
 490421411,
 7106,
 -58050,
 490486175,
 7118,
 -58049,
 490546926,
 7121,
 -58048,
 490610210,
 7137,
 -58047,
 490674385,
 7109,
 -1,
 490737508,
 7104,
 490937677,
 488019684,
 -1,
 491003205,
 490901023,
 7150,
 -1,
 490930701,
 7151,
 491134280,
 490950164,
 -1,
 -58041,
 491086827,
 7149,
 -1,
 491143818,
 7147,
 491330890,
 491072683,
 7143,
 -1,
 491269291,
 7145,
 -58037,
 491285810,
 7144,
 -58036,
 491414507,
 7148,
 -1,
 491471498,
 7146,
 491658581,
 490896612,
 -1,
 491724116,
 491626165,
 -1,
 491789650,
 491678904,
 -1,
 -58031,
 491734650,
 7165,
 -1,
 491787425,
 7167,
 -58029,
 491740917,
 7164,
 -1,
 491933053,
 7166,
 -1,
 491668861,
 7142,
 492182872,
 491613523,
 -1,
 -58025,
 492136312,
 7155,
 -1,
 492190673,
 7154,
 492437503,
 492118978,
 -1,
 -58022,
 492331186,
 7152,
 -1,
 492387477,
 7153,
 492576093,
 487931029,
 128704,
 -1,
 492539117,
 128705,
 -1,
 492537913,
 128267,
 492772750,
 487881956,
 -1,
 492838284,
 492731777,
 -1,
 492903811,
 492786841,
 -1,
 492969316,
 492842155,
 92908,
 -58013,
 492921312,
 92880,
 -1,
 492973227,
 92907,
 493165927,
 492936427,
 -1,
 -58010,
 493110257,
 92885,
 -1,
 493170604,
 92900,
 493362537,
 493131566,
 92891,
 -1,
 493299611,
 92902,
 493493611,
 493325855,
 92906,
 -1,
 493460513,
 92896,
 493624685,
 493446123,
 92904,
 -1,
 493577195,
 92905,
 493755760,
 493571459,
 -1,
 -58001,
 493710624,
 92888,
 -1,
 493752164,
 92881,
 493952371,
 493697382,
 -1,
 -57998,
 493886864,
 92893,
 -1,
 493949370,
 92886,
 494148982,
 493889122,
 -1,
 -57995,
 494101483,
 92894,
 -1,
 494157828,
 92887,
 -57993,
 494116885,
 92892,
 -57992,
 494311161,
 92899,
 -57991,
 494373525,
 92897,
 -57990,
 494435942,
 92882,
 -57989,
 494497010,
 92901,
 -57988,
 494557868,
 92884,
 -57987,
 494620019,
 92889,
 -57986,
 494682762,
 92909,
 -57985,
 494748283,
 92890,
 -57984,
 494810331,
 92883,
 -57983,
 494870418,
 92895,
 -57982,
 494934225,
 92898,
 -1,
 494997348,
 92903,
 495197579,
 492839674,
 -1,
 495263111,
 495146967,
 -1,
 -57978,
 495192231,
 92915,
 -1,
 495257000,
 92913,
 495459722,
 495206361,
 -1,
 -57975,
 495388816,
 92916,
 -1,
 495453608,
 92912,
 -1,
 495410199,
 92914,
 -1,
 495139164,
 92917,
 495845375,
 492785320,
 129530,
 -1,
 495720778,
 127936,
 495918495,
 492721854,
 -1,
 495984029,
 495870955,
 -1,
 496049564,
 495945317,
 -1,
 496115099,
 495983701,
 -1,
 496180634,
 496081985,
 -1,
 496246168,
 496113856,
 -1,
 496311703,
 496199064,
 -1,
 -57962,
 496270941,
 128503,
 -1,
 496312434,
 128505,
 -1,
 496243405,
 128499,
 -57959,
 496205405,
 128501,
 -1,
 496522813,
 11197,
 -1,
 496128479,
 128502,
 -1,
 496074333,
 128500,
 -1,
 496002639,
 127880,
 -57954,
 495923965,
 129648,
 -1,
 496829300,
 129526,
 497032616,
 495869567,
 -1,
 497098150,
 496979331,
 127974,
 497221631,
 497050280,
 -1,
 -57949,
 497130989,
 128180,
 -57948,
 497184985,
 128183,
 -57947,
 497234844,
 128182,
 -1,
 497297787,
 128181,
 -57945,
 497044851,
 129685,
 -1,
 497423290,
 127820,
 497622452,
 496967174,
 -1,
 497687986,
 497569155,
 -1,
 497753519,
 497646820,
 -1,
 497819054,
 497701074,
 -1,
 -57939,
 497777385,
 11101,
 -1,
 497837428,
 11099,
 -1,
 497773827,
 983056,
 498139135,
 497680384,
 -1,
 -57935,
 498047498,
 128281,
 -1,
 498099390,
 128386,
 -57933,
 497650631,
 128043,
 -1,
 498230863,
 129363,
 498408890,
 497556995,
 128118,
 498532351,
 498335744,
 -1,
 -57929,
 498435636,
 128700,
 -57928,
 498475218,
 128036,
 -57927,
 498539720,
 127868,
 -1,
 498603097,
 128124,
 498802111,
 498365353,
 -1,
 498867646,
 498728960,
 -1,
 -57923,
 498820309,
 129532,
 -1,
 498868323,
 128202,
 -1,
 498801208,
 128136,
 499129795,
 498743654,
 -1,
 -57919,
 499093485,
 129366,
 -57918,
 499136970,
 128708,
 -1,
 499199934,
 129391,
 499449855,
 499066466,
 -1,
 -57915,
 499342589,
 127992,
 -1,
 499399330,
 129441,
 499588719,
 434205609,
 -1,
 499654238,
 499519332,
 -1,
 499719773,
 499597445,
 -1,
 499785229,
 499668121,
 -1,
 499850705,
 499749879,
 -1,
 499916240,
 499803215,
 -1,
 499981774,
 499872681,
 69643,
 -1,
 499938217,
 69644,
 500170751,
 499929036,
 69645,
 -1,
 500060108,
 69646,
 -1,
 499847012,
 69679,
 500309463,
 499811939,
 -1,
 500374997,
 500270691,
 -1,
 -57900,
 500317347,
 69662,
 -1,
 500371300,
 69661,
 -57898,
 500317347,
 69667,
 -1,
 500502372,
 69666,
 500702684,
 500261867,
 69649,
 500826111,
 500650484,
 -1,
 -57894,
 500726841,
 69686,
 -57893,
 500785665,
 69687,
 -1,
 500848389,
 69685,
 501030369,
 500653695,
 -1,
 -57890,
 500997465,
 69660,
 -57889,
 501047000,
 69665,
 -57888,
 501103007,
 69655,
 -1,
 501157732,
 69670,
 501358055,
 500967010,
 -1,
 501423589,
 501294690,
 -1,
 -57884,
 501365923,
 69664,
 -1,
 501419876,
 69663,
 -57882,
 501365923,
 69669,
 -1,
 501550948,
 69668,
 501751275,
 501288804,
 69637,
 -57879,
 501714463,
 69650,
 -57878,
 501760650,
 69648,
 -1,
 501813092,
 69638,
 502013423,
 501710052,
 -1,
 -57875,
 501972350,
 69681,
 -57874,
 502021283,
 69680,
 -1,
 502075236,
 69682,
 502275569,
 501976607,
 69641,
 -1,
 502238751,
 69642,
 502406644,
 502230200,
 -1,
 -57869,
 502348963,
 69672,
 -1,
 502402916,
 69671,
 502603255,
 502353868,
 -1,
 -57866,
 502550558,
 69684,
 -1,
 502599524,
 69678,
 502799866,
 502549891,
 -1,
 -57863,
 502742179,
 69652,
 -1,
 502796132,
 69651,
 502996477,
 502746293,
 -1,
 -57860,
 502938787,
 69659,
 -1,
 502992740,
 69658,
 503193087,
 502940298,
 69639,
 -1,
 503136906,
 69640,
 503324162,
 503134566,
 -1,
 -57855,
 503266467,
 69654,
 -1,
 503320420,
 69653,
 503520773,
 503258630,
 -1,
 -57852,
 503463075,
 69657,
 -1,
 503517028,
 69656,
 503717384,
 503453888,
 -1,
 -57849,
 503659683,
 69674,
 -1,
 503713636,
 69673,
 -57847,
 503684441,
 69676,
 -57846,
 503870461,
 69677,
 -57845,
 503929197,
 69675,
 -57844,
 503987363,
 69683,
 -1,
 504048811,
 69647,
 504241707,
 499737466,
 -1,
 504307222,
 504202851,
 -1,
 504372754,
 504272662,
 -1,
 -57839,
 504325099,
 69715,
 -1,
 504377681,
 69724,
 504569365,
 504315029,
 -1,
 -57836,
 504526398,
 69716,
 -1,
 504580746,
 69725,
 -1,
 504508496,
 69723,
 504831515,
 504265956,
 -1,
 504897049,
 504777773,
 69719,
 -1,
 504860163,
 69728,
 505085951,
 504837063,
 69720,
 -1,
 504991235,
 69729,
 505159202,
 504771767,
 -1,
 505224735,
 505111531,
 -1,
 -57826,
 505188988,
 69717,
 -1,
 505248928,
 69726,
 505479167,
 505168522,
 -1,
 -57823,
 505386031,
 69718,
 -1,
 505428305,
 69727,
 505617958,
 505112237,
 69714,
 505741311,
 505544704,
 -1,
 -57819,
 505645284,
 69733,
 -1,
 505692733,
 69732,
 505880104,
 505569599,
 69722,
 -1,
 505843203,
 69731,
 506011178,
 505818974,
 69721,
 -1,
 505978091,
 69730,
 -1,
 505957750,
 69759,
 506207806,
 504206327,
 -1,
 506273341,
 506162278,
 -1,
 506338866,
 506238570,
 -1,
 506404400,
 506295209,
 69694,
 -1,
 506360745,
 69695,
 506593279,
 506351564,
 69696,
 -1,
 506482636,
 69697,
 506666550,
 506269540,
 -1,
 -57804,
 506629663,
 69701,
 -57803,
 506675850,
 69699,
 -1,
 506728292,
 69688,
 506928696,
 506629663,
 69692,
 -1,
 506891807,
 69693,
 507059770,
 506872458,
 69690,
 -1,
 507003530,
 69691,
 -57797,
 507012075,
 69700,
 -57796,
 507129003,
 69698,
 -1,
 507189931,
 69689,
 -1,
 506218969,
 69702,
 507453007,
 506144354,
 -1,
 507518541,
 507397430,
 -1,
 507584067,
 507479651,
 -1,
 -57790,
 507550466,
 69736,
 -1,
 507593058,
 69737,
 507780678,
 507542756,
 -1,
 -57787,
 507726893,
 69740,
 -1,
 507786183,
 69741,
 507977289,
 507720887,
 -1,
 -57784,
 507931362,
 69738,
 -1,
 507988879,
 69739,
 -57782,
 507944942,
 69734,
 -57781,
 508126893,
 69735,
 -57780,
 508191039,
 69743,
 -1,
 508243806,
 69742,
 -57778,
 507472480,
 69704,
 -1,
 508367930,
 69703,
 508567125,
 507412811,
 -1,
 -57775,
 508532294,
 69634,
 -57774,
 508596684,
 69636,
 -57773,
 508644653,
 69635,
 -57772,
 508698269,
 69632,
 -1,
 508761353,
 69633,
 509018111,
 508522948,
 -1,
 509025881,
 508907468,
 -1,
 -57768,
 508979793,
 69709,
 -1,
 509036365,
 69707,
 509222492,
 508963159,
 -1,
 -57765,
 509185837,
 69706,
 -1,
 509249123,
 69705,
 -1,
 509158628,
 69708,
 -1,
 499664426,
 129504,
 509550182,
 499597962,
 -1,
 509615714,
 509488851,
 -1,
 -57759,
 509574372,
 129650,
 -1,
 509615903,
 128188,
 509812325,
 509552226,
 -1,
 -57756,
 509753937,
 127753,
 -1,
 509816082,
 128112,
 -1,
 509747686,
 129521,
 510074475,
 509502443,
 -1,
 -57752,
 510040764,
 129294,
 -57751,
 510092754,
 129529,
 -57750,
 510152344,
 128148,
 -1,
 510205836,
 129382,
 510459903,
 510012724,
 -1,
 -57747,
 510362732,
 129329,
 -57746,
 510414250,
 983124,
 -1,
 510469730,
 127838,
 510664436,
 499530963,
 -1,
 510729901,
 510612633,
 -1,
 510795383,
 510694391,
 -1,
 510860918,
 510747727,
 -1,
 510926453,
 510817193,
 72710,
 -1,
 510882729,
 72711,
 -1,
 510873548,
 72712,
 -1,
 510791524,
 72746,
 511188605,
 510756451,
 -1,
 511254139,
 511149667,
 -1,
 -57734,
 511196323,
 72729,
 -1,
 511250276,
 72728,
 -57732,
 511196323,
 72734,
 -1,
 511381348,
 72733,
 511581826,
 511139455,
 -1,
 -57729,
 511548761,
 72727,
 -57728,
 511598296,
 72732,
 -57727,
 511654303,
 72722,
 -1,
 511709028,
 72737,
 511909512,
 511518306,
 -1,
 511975046,
 511845986,
 -1,
 -57723,
 511917219,
 72731,
 -1,
 511971172,
 72730,
 -57721,
 511917219,
 72736,
 -1,
 512102244,
 72735,
 512302732,
 511840100,
 72704,
 -57718,
 512265759,
 72717,
 -57717,
 512311946,
 72715,
 -1,
 512364388,
 72705,
 512564880,
 512261348,
 -1,
 -57714,
 512523646,
 72748,
 -57713,
 512572579,
 72747,
 -1,
 512626532,
 72749,
 512827026,
 512527903,
 72708,
 -1,
 512790047,
 72709,
 512958101,
 512781496,
 -1,
 -57708,
 512900259,
 72739,
 -1,
 512954212,
 72738,
 513154712,
 512904579,
 -1,
 -57705,
 513096867,
 72719,
 -1,
 513150820,
 72718,
 513351323,
 513100981,
 -1,
 -57702,
 513293475,
 72726,
 -1,
 513347428,
 72725,
 513547933,
 513294986,
 72706,
 -1,
 513491594,
 72707,
 513679008,
 513489254,
 -1,
 -57697,
 513621155,
 72721,
 -1,
 513675108,
 72720,
 513875619,
 513613318,
 -1,
 -57694,
 513817763,
 72724,
 -1,
 513871716,
 72723,
 514072230,
 513808576,
 -1,
 -57691,
 514014371,
 72741,
 -1,
 514068324,
 72740,
 -57689,
 514039129,
 72743,
 -57688,
 514225149,
 72744,
 -57687,
 514286571,
 72716,
 -57686,
 514349421,
 72742,
 -57685,
 514412574,
 72745,
 -57684,
 514473123,
 72750,
 -1,
 514534571,
 72714,
 514727623,
 510681978,
 -1,
 514793142,
 514688611,
 -1,
 514858674,
 514758422,
 -1,
 -57679,
 514810859,
 72795,
 -1,
 514863441,
 72804,
 515055285,
 514800789,
 -1,
 -57676,
 515012158,
 72796,
 -1,
 515066506,
 72805,
 -1,
 514994256,
 72803,
 515317435,
 514751716,
 -1,
 515382969,
 515263533,
 72799,
 -1,
 515345923,
 72808,
 515571711,
 515322823,
 72800,
 -1,
 515476995,
 72809,
 515645122,
 515257527,
 -1,
 515710655,
 515597291,
 -1,
 -57666,
 515674748,
 72797,
 -1,
 515734688,
 72806,
 515964927,
 515654282,
 -1,
 -57663,
 515871791,
 72798,
 -1,
 515914065,
 72807,
 516103876,
 515596607,
 72802,
 -1,
 516066819,
 72811,
 516234950,
 516042590,
 72801,
 -1,
 516201707,
 72810,
 -1,
 516187821,
 72794,
 516431574,
 514692836,
 -1,
 516497100,
 516396650,
 -1,
 516562635,
 516453289,
 72756,
 -1,
 516518825,
 72757,
 -1,
 516509644,
 72758,
 516759248,
 516427620,
 -1,
 -57650,
 516722207,
 72763,
 -57649,
 516768394,
 72761,
 -1,
 516820836,
 72751,
 517021394,
 516722207,
 72754,
 -1,
 516984351,
 72755,
 517152468,
 516965002,
 72752,
 -1,
 517096074,
 72753,
 -57643,
 517104619,
 72762,
 -1,
 517221547,
 72760,
 517414631,
 516367970,
 -1,
 517480165,
 517358902,
 -1,
 517545691,
 517441123,
 -1,
 -57638,
 517511938,
 72786,
 -1,
 517554530,
 72787,
 517742302,
 517504228,
 -1,
 -57635,
 517688365,
 72790,
 -1,
 517747655,
 72791,
 517938913,
 517682359,
 -1,
 -57632,
 517892834,
 72788,
 -1,
 517950351,
 72789,
 -57630,
 517906414,
 72784,
 -57629,
 518088365,
 72785,
 -57628,
 518152511,
 72793,
 -1,
 518205278,
 72792,
 -57626,
 517433952,
 72770,
 -1,
 518329402,
 72769,
 518528751,
 517374283,
 -1,
 518594283,
 518493667,
 -1,
 -57622,
 518553133,
 72766,
 -1,
 518616246,
 72767,
 518790894,
 518524772,
 -1,
 -57619,
 518755340,
 72768,
 -1,
 518808515,
 72765,
 -1,
 518725277,
 72764,
 519053042,
 518470141,
 -1,
 -57615,
 518982213,
 72773,
 -1,
 519047593,
 72772,
 -57613,
 519019464,
 72771,
 -1,
 519193157,
 72812,
 519380862,
 510611404,
 -1,
 519446392,
 519311458,
 -1,
 519511854,
 519380486,
 -1,
 519577376,
 519454589,
 -1,
 519642890,
 519523715,
 -1,
 519708423,
 519594275,
 -1,
 519773955,
 519636074,
 -1,
 519839488,
 519734883,
 -1,
 519905023,
 519805729,
 -1,
 -57602,
 519867793,
 129585,
 -1,
 519929715,
 129597,
 -1,
 519848336,
 129606,
 -57599,
 519792331,
 129564,
 -57598,
 520118655,
 129555,
 -1,
 520173493,
 129543,
 520421375,
 519702624,
 -1,
 -57595,
 520321967,
 129618,
 -57594,
 520385348,
 129617,
 -1,
 520428351,
 129619,
 520683519,
 519653376,
 -1,
 -57591,
 520588764,
 129593,
 -1,
 520642943,
 129551,
 520822546,
 519605522,
 -1,
 520888078,
 520768899,
 -1,
 -57587,
 520839459,
 129576,
 -1,
 520898394,
 129572,
 -57585,
 520846255,
 129574,
 -57584,
 521040708,
 129573,
 -57583,
 521104946,
 129577,
 -1,
 521149247,
 129575,
 521346837,
 520780724,
 -1,
 -57580,
 521309660,
 129595,
 -1,
 521363839,
 129553,
 521543448,
 521302868,
 -1,
 -57577,
 521506268,
 129594,
 -1,
 521560447,
 129552,
 521740059,
 521498167,
 -1,
 -57574,
 521702876,
 129598,
 -1,
 521757055,
 129556,
 521936669,
 521679309,
 129609,
 -1,
 521864308,
 129612,
 522125311,
 521870150,
 -1,
 -57569,
 522030556,
 129596,
 -1,
 522084735,
 129554,
 522264365,
 519541545,
 -1,
 522329892,
 522228274,
 -1,
 -57565,
 522287447,
 11179,
 -1,
 522343388,
 11178,
 522526503,
 522287431,
 -1,
 -57562,
 522490431,
 11181,
 -1,
 522529759,
 11183,
 522723114,
 522474445,
 -1,
 -57559,
 522687039,
 11180,
 -1,
 522726367,
 11182,
 522977279,
 522660775,
 -1,
 -57556,
 522877271,
 11177,
 -1,
 522933212,
 11176,
 -1,
 522209801,
 9210,
 523181882,
 519461652,
 -1,
 523247409,
 523145655,
 9206,
 -1,
 523174222,
 11205,
 523378484,
 523207194,
 -1,
 -57549,
 523327632,
 128927,
 -1,
 523380959,
 128921,
 523575094,
 523335960,
 9205,
 -1,
 523501902,
 11208,
 523706168,
 523522932,
 9204,
 -1,
 523632974,
 11207,
 523894783,
 523643746,
 9207,
 -1,
 523764046,
 11206,
 523968324,
 523140324,
 -1,
 524033855,
 523924201,
 -1,
 -57539,
 523974534,
 9209,
 -57538,
 524034007,
 11200,
 -1,
 524099055,
 128306,
 524296002,
 523982405,
 -1,
 -57535,
 524256177,
 128909,
 -1,
 524296505,
 128900,
 -57533,
 524242826,
 128369,
 -1,
 524423509,
 9984,
 524623694,
 523924393,
 -1,
 524689229,
 524567723,
 -1,
 524754763,
 524617969,
 -1,
 524820297,
 524692173,
 9193,
 -1,
 524748798,
 9197,
 -57526,
 524782575,
 9199,
 -1,
 524896963,
 128898,
 -57524,
 524720047,
 11166,
 -1,
 525009955,
 128413,
 -1,
 524642732,
 127990,
 525279065,
 524559970,
 -1,
 525344597,
 525233265,
 -1,
 525410131,
 525273329,
 -1,
 -57518,
 525355715,
 128899,
 -1,
 525413069,
 9196,
 -57516,
 525375407,
 11167,
 -1,
 525534243,
 128419,
 525737816,
 525288260,
 -1,
 -57513,
 525690454,
 11230,
 -1,
 525737943,
 11201,
 -1,
 525695938,
 127778,
 525999968,
 525226650,
 -1,
 526065502,
 525928689,
 -1,
 526131037,
 526002893,
 9194,
 -1,
 526059518,
 9198,
 -1,
 526076611,
 128896,
 -57505,
 526030767,
 11164,
 -1,
 526255139,
 128412,
 526458726,
 525963558,
 -1,
 526524260,
 526387441,
 -1,
 -57501,
 526469827,
 128897,
 -1,
 526527181,
 9195,
 -57499,
 526489519,
 11165,
 -1,
 526648355,
 128418,
 526851948,
 526419555,
 -1,
 526917483,
 526797175,
 -1,
 -57495,
 526877617,
 128908,
 -57494,
 526932112,
 128925,
 -1,
 526985439,
 128919,
 -1,
 526871205,
 128383,
 527245167,
 526816648,
 -1,
 -57490,
 527194256,
 128926,
 -1,
 527247583,
 128920,
 527441778,
 527199416,
 -1,
 -57487,
 527405934,
 128392,
 -1,
 527446262,
 127986,
 527638389,
 527383701,
 -1,
 -57484,
 527576409,
 128420,
 -1,
 527635893,
 128426,
 -57482,
 527594373,
 10067,
 -57481,
 527787140,
 11204,
 -1,
 527841126,
 128447,
 528031611,
 519409613,
 -1,
 -57478,
 527974070,
 128153,
 -1,
 528030890,
 128216,
 528285695,
 527983595,
 -1,
 -57475,
 528193729,
 128033,
 -1,
 528254007,
 127804,
 528424870,
 519332843,
 -1,
 528490377,
 528372162,
 -1,
 528555907,
 528455879,
 -1,
 -57470,
 528516017,
 128912,
 -1,
 528556345,
 128902,
 528752518,
 528514276,
 -1,
 -57467,
 528698427,
 128951,
 -1,
 528749373,
 128939,
 -57465,
 528694302,
 128932,
 -57464,
 528889521,
 128945,
 -1,
 528953213,
 128957,
 529145743,
 528445584,
 -1,
 -57461,
 529113136,
 12730,
 -57460,
 529163283,
 12590,
 -57459,
 529228249,
 12591,
 -57458,
 529290631,
 12729,
 -1,
 529349344,
 12728,
 529538966,
 529110806,
 -1,
 529604501,
 529485772,
 -1,
 529670036,
 529530880,
 -1,
 -57453,
 529635935,
 129379,
 -1,
 529687754,
 128335,
 -1,
 529614682,
 127923,
 -1,
 529530917,
 127993,
 529997722,
 529491290,
 128366,
 530063257,
 529947218,
 128278,
 -1,
 529990922,
 128209,
 -1,
 530021604,
 128218,
 530259868,
 529964267,
 128102,
 -1,
 530218326,
 128713,
 530390942,
 530223734,
 128144,
 -1,
 530318151,
 127893,
 530522017,
 530353342,
 -1,
 -57440,
 530474453,
 11211,
 -1,
 530534944,
 127870,
 530718627,
 530471203,
 983258,
 -1,
 530651328,
 128163,
 -57436,
 530685086,
 129354,
 -57435,
 530800608,
 129460,
 -1,
 530847088,
 128023,
 531046339,
 528362667,
 -1,
 531111859,
 530996863,
 -1,
 531177392,
 531053021,
 -1,
 531242924,
 531125401,
 -1,
 -57429,
 531207268,
 2556,
 -1,
 531254987,
 983642,
 531439535,
 531173220,
 -1,
 -57426,
 531390916,
 2432,
 -1,
 531438011,
 2557,
 -1,
 531398120,
 2558,
 531759103,
 531138147,
 -1,
 -57422,
 531653616,
 127857,
 -1,
 531693700,
 11102,
 531898300,
 531042148,
 -1,
 531963831,
 531854249,
 -1,
 -57418,
 531900408,
 129492,
 -1,
 531956188,
 128059,
 532160442,
 531913467,
 -1,
 -57415,
 532097125,
 127901,
 -1,
 532158200,
 127900,
 -57413,
 532122174,
 128147,
 -1,
 532291618,
 127958,
 532488128,
 531845068,
 983055,
 532611071,
 532434892,
 128276,
 -57409,
 532496609,
 128718,
 -1,
 532547067,
 128277,
 -57407,
 532452536,
 129475,
 -57406,
 532689406,
 127866,
 -1,
 532751970,
 128719,
 532946896,
 531009055,
 -1,
 533012425,
 532905188,
 128652,
 533077960,
 532973155,
 -1,
 -57401,
 533036295,
 128101,
 -1,
 533070428,
 128100,
 -1,
 533005554,
 128655,
 533340107,
 532974806,
 129480,
 -1,
 533280592,
 129419,
 533471181,
 533288676,
 128363,
 -1,
 533399507,
 128364,
 -57394,
 533429326,
 127791,
 -57393,
 533546431,
 127959,
 -1,
 533608806,
 128027,
 533798876,
 532890250,
 -1,
 533864404,
 533754793,
 -1,
 -57389,
 533825655,
 127874,
 -1,
 533866082,
 128038,
 534061015,
 533812926,
 -1,
 -57386,
 534004581,
 127921,
 -1,
 534064616,
 129506,
 534257626,
 533997149,
 -1,
 -57383,
 534203142,
 128692,
 -1,
 534260907,
 128690,
 -57381,
 534218668,
 8383,
 -1,
 534400769,
 128089,
 534585311,
 533765355,
 -1,
 -57378,
 534552470,
 983267,
 -1,
 534611898,
 983257,
 -57376,
 534543588,
 983057,
 -1,
 534736656,
 983125,
 534913963,
 434134655,
 -1,
 534978960,
 534875679,
 -1,
 535044493,
 534937838,
 -1,
 535110028,
 534978646,
 -1,
 535175410,
 535038533,
 -1,
 535240695,
 535112875,
 -1,
 -57368,
 535180471,
 111343,
 -57367,
 535243947,
 111342,
 -57366,
 535307874,
 111341,
 -57365,
 535371270,
 111340,
 -57364,
 535435456,
 111339,
 -57363,
 535498596,
 111338,
 -57362,
 535563993,
 111337,
 -57361,
 535629402,
 111336,
 -57360,
 535694772,
 111335,
 -57359,
 535760156,
 111334,
 -57358,
 535825522,
 111333,
 -57357,
 535890902,
 111332,
 -57356,
 535956253,
 111331,
 -57355,
 536021573,
 111330,
 -57354,
 536086953,
 111329,
 -1,
 536152345,
 111328,
 536354824,
 535176802,
 -1,
 -57351,
 536294583,
 111327,
 -57350,
 536358059,
 111326,
 -57349,
 536421986,
 111325,
 -57348,
 536485382,
 111324,
 -57347,
 536549568,
 111323,
 -57346,
 536612708,
 111322,
 -57345,
 536678105,
 111321,
 -57344,
 536743514,
 111320,
 -57343,
 536808884,
 111319,
 -57342,
 536874268,
 111318,
 -57341,
 536939634,
 111317,
 -57340,
 537005014,
 111316,
 -57339,
 537070365,
 111315,
 -57338,
 537135685,
 111314,
 -57337,
 537201065,
 111313,
 -1,
 537266457,
 111312,
 537468953,
 536288774,
 -1,
 -57334,
 537408695,
 111311,
 -57333,
 537472171,
 111310,
 -57332,
 537536098,
 111309,
 -57331,
 537599494,
 111308,
 -57330,
 537663680,
 111307,
 -57329,
 537726820,
 111306,
 -57328,
 537792217,
 111305,
 -57327,
 537857626,
 111304,
 -57326,
 537922996,
 111303,
 -57325,
 537988380,
 111302,
 -57324,
 538053746,
 111301,
 -57323,
 538119126,
 111300,
 -57322,
 538184477,
 111299,
 -57321,
 538249797,
 111298,
 -57320,
 538315177,
 111297,
 -1,
 538380569,
 111296,
 538583082,
 537401536,
 -1,
 -57317,
 538522807,
 111295,
 -57316,
 538586283,
 111294,
 -57315,
 538650210,
 111293,
 -57314,
 538713606,
 111292,
 -57313,
 538777792,
 111291,
 -57312,
 538840932,
 111290,
 -57311,
 538906329,
 111289,
 -57310,
 538971738,
 111288,
 -57309,
 539037108,
 111287,
 -57308,
 539102492,
 111286,
 -57307,
 539167858,
 111285,
 -57306,
 539233238,
 111284,
 -57305,
 539298589,
 111283,
 -57304,
 539363909,
 111282,
 -57303,
 539429289,
 111281,
 -1,
 539494681,
 111280,
 539697211,
 538513252,
 -1,
 -57300,
 539636919,
 111279,
 -57299,
 539700395,
 111278,
 -57298,
 539764322,
 111277,
 -57297,
 539827718,
 111276,
 -57296,
 539891904,
 111275,
 -57295,
 539955044,
 111274,
 -57294,
 540020441,
 111273,
 -57293,
 540085850,
 111272,
 -57292,
 540151220,
 111271,
 -57291,
 540216604,
 111270,
 -57290,
 540281970,
 111269,
 -57289,
 540347350,
 111268,
 -57288,
 540412701,
 111267,
 -57287,
 540478021,
 111266,
 -57286,
 540543401,
 111265,
 -1,
 540608793,
 111264,
 540811340,
 539627225,
 -1,
 -57283,
 540751031,
 111263,
 -57282,
 540814507,
 111262,
 -57281,
 540878434,
 111261,
 -57280,
 540941830,
 111260,
 -57279,
 541006016,
 111259,
 -57278,
 541069156,
 111258,
 -57277,
 541134553,
 111257,
 -57276,
 541199962,
 111256,
 -57275,
 541265332,
 111255,
 -57274,
 541330716,
 111254,
 -57273,
 541396082,
 111253,
 -57272,
 541461462,
 111252,
 -57271,
 541526813,
 111251,
 -57270,
 541592133,
 111250,
 -57269,
 541657513,
 111249,
 -1,
 541722905,
 111248,
 541925469,
 540741210,
 -1,
 -57266,
 541865143,
 111247,
 -57265,
 541928619,
 111246,
 -57264,
 541992546,
 111245,
 -57263,
 542055942,
 111244,
 -57262,
 542120128,
 111243,
 -57261,
 542183268,
 111242,
 -57260,
 542248665,
 111241,
 -57259,
 542314074,
 111240,
 -57258,
 542379444,
 111239,
 -57257,
 542444828,
 111238,
 -57256,
 542510194,
 111237,
 -57255,
 542575574,
 111236,
 -57254,
 542640925,
 111235,
 -57253,
 542706245,
 111234,
 -57252,
 542771625,
 111233,
 -1,
 542837017,
 111232,
 543039598,
 541855156,
 -1,
 -57249,
 542979255,
 111231,
 -57248,
 543042731,
 111230,
 -57247,
 543106658,
 111229,
 -57246,
 543170054,
 111228,
 -57245,
 543234240,
 111227,
 -57244,
 543297380,
 111226,
 -57243,
 543362777,
 111225,
 -57242,
 543428186,
 111224,
 -57241,
 543493556,
 111223,
 -57240,
 543558940,
 111222,
 -57239,
 543624306,
 111221,
 -57238,
 543689686,
 111220,
 -57237,
 543755037,
 111219,
 -57236,
 543820357,
 111218,
 -57235,
 543885737,
 111217,
 -1,
 543951129,
 111216,
 544153727,
 542969116,
 -1,
 -57232,
 544093367,
 111215,
 -57231,
 544156843,
 111214,
 -57230,
 544220770,
 111213,
 -57229,
 544284166,
 111212,
 -57228,
 544348352,
 111211,
 -57227,
 544411492,
 111210,
 -57226,
 544476889,
 111209,
 -57225,
 544542298,
 111208,
 -57224,
 544607668,
 111207,
 -57223,
 544673052,
 111206,
 -57222,
 544738418,
 111205,
 -57221,
 544803798,
 111204,
 -57220,
 544869149,
 111203,
 -57219,
 544934469,
 111202,
 -57218,
 544999849,
 111201,
 -1,
 545065241,
 111200,
 545267856,
 544083058,
 -1,
 -57215,
 545207479,
 111199,
 -57214,
 545270955,
 111198,
 -57213,
 545334882,
 111197,
 -57212,
 545398278,
 111196,
 -57211,
 545462464,
 111195,
 -57210,
 545525604,
 111194,
 -57209,
 545591001,
 111193,
 -57208,
 545656410,
 111192,
 -57207,
 545721780,
 111191,
 -57206,
 545787164,
 111190,
 -57205,
 545852530,
 111189,
 -57204,
 545917910,
 111188,
 -57203,
 545983261,
 111187,
 -57202,
 546048581,
 111186,
 -57201,
 546113961,
 111185,
 -1,
 546179353,
 111184,
 546381985,
 545197014,
 -1,
 -57198,
 546321591,
 111183,
 -57197,
 546385067,
 111182,
 -57196,
 546448994,
 111181,
 -57195,
 546512390,
 111180,
 -57194,
 546576576,
 111179,
 -57193,
 546639716,
 111178,
 -57192,
 546705113,
 111177,
 -57191,
 546770522,
 111176,
 -57190,
 546835892,
 111175,
 -57189,
 546901276,
 111174,
 -57188,
 546966642,
 111173,
 -57187,
 547032022,
 111172,
 -57186,
 547097373,
 111171,
 -57185,
 547162693,
 111170,
 -57184,
 547228073,
 111169,
 -1,
 547293465,
 111168,
 547496114,
 546310941,
 -1,
 -57181,
 547435703,
 111167,
 -57180,
 547499179,
 111166,
 -57179,
 547563106,
 111165,
 -57178,
 547626502,
 111164,
 -57177,
 547690688,
 111163,
 -57176,
 547753828,
 111162,
 -57175,
 547819225,
 111161,
 -57174,
 547884634,
 111160,
 -57173,
 547950004,
 111159,
 -57172,
 548015388,
 111158,
 -57171,
 548080754,
 111157,
 -57170,
 548146134,
 111156,
 -57169,
 548211485,
 111155,
 -57168,
 548276805,
 111154,
 -57167,
 548342185,
 111153,
 -1,
 548407577,
 111152,
 548610243,
 547424837,
 -1,
 -57164,
 548549815,
 111151,
 -57163,
 548613291,
 111150,
 -57162,
 548677218,
 111149,
 -57161,
 548740614,
 111148,
 -57160,
 548804800,
 111147,
 -57159,
 548867940,
 111146,
 -57158,
 548933337,
 111145,
 -57157,
 548998746,
 111144,
 -57156,
 549064116,
 111143,
 -57155,
 549129500,
 111142,
 -57154,
 549194866,
 111141,
 -57153,
 549260246,
 111140,
 -57152,
 549325597,
 111139,
 -57151,
 549390917,
 111138,
 -57150,
 549456297,
 111137,
 -1,
 549521689,
 111136,
 549724372,
 548538793,
 -1,
 -57147,
 549663927,
 111135,
 -57146,
 549727403,
 111134,
 -57145,
 549791330,
 111133,
 -57144,
 549854726,
 111132,
 -57143,
 549918912,
 111131,
 -57142,
 549982052,
 111130,
 -57141,
 550047449,
 111129,
 -57140,
 550112858,
 111128,
 -57139,
 550178228,
 111127,
 -57138,
 550243612,
 111126,
 -57137,
 550308978,
 111125,
 -57136,
 550374358,
 111124,
 -57135,
 550439709,
 111123,
 -57134,
 550505029,
 111122,
 -57133,
 550570409,
 111121,
 -1,
 550635801,
 111120,
 550838501,
 549652761,
 -1,
 -57130,
 550778039,
 111119,
 -57129,
 550841515,
 111118,
 -57128,
 550905442,
 111117,
 -57127,
 550968838,
 111116,
 -57126,
 551033024,
 111115,
 -57125,
 551096164,
 111114,
 -57124,
 551161561,
 111113,
 -57123,
 551226970,
 111112,
 -57122,
 551292340,
 111111,
 -57121,
 551357724,
 111110,
 -57120,
 551423090,
 111109,
 -57119,
 551488470,
 111108,
 -57118,
 551553821,
 111107,
 -57117,
 551619141,
 111106,
 -57116,
 551684521,
 111105,
 -1,
 551749913,
 111104,
 552009727,
 550778039,
 -1,
 -57113,
 551884992,
 111355,
 -57112,
 551948132,
 111354,
 -57111,
 552013529,
 111353,
 -57110,
 552078938,
 111352,
 -57109,
 552144308,
 111351,
 -57108,
 552209692,
 111350,
 -57107,
 552275058,
 111349,
 -57106,
 552340438,
 111348,
 -57105,
 552405789,
 111347,
 -57104,
 552471109,
 111346,
 -57103,
 552536489,
 111345,
 -1,
 552601881,
 111344,
 552861695,
 535103913,
 -1,
 552870148,
 552744119,
 -1,
 -57099,
 552809655,
 111103,
 -57098,
 552873131,
 111102,
 -57097,
 552937058,
 111101,
 -57096,
 553000454,
 111100,
 -57095,
 553064640,
 111099,
 -57094,
 553127780,
 111098,
 -57093,
 553193177,
 111097,
 -57092,
 553258586,
 111096,
 -57091,
 553323956,
 111095,
 -57090,
 553389340,
 111094,
 -57089,
 553454706,
 111093,
 -57088,
 553520086,
 111092,
 -57087,
 553585437,
 111091,
 -57086,
 553650757,
 111090,
 -57085,
 553716137,
 111089,
 -1,
 553781529,
 111088,
 553984277,
 552807595,
 -1,
 -57082,
 553923767,
 111087,
 -57081,
 553987243,
 111086,
 -57080,
 554051170,
 111085,
 -57079,
 554114566,
 111084,
 -57078,
 554178752,
 111083,
 -57077,
 554241892,
 111082,
 -57076,
 554307289,
 111081,
 -57075,
 554372698,
 111080,
 -57074,
 554438068,
 111079,
 -57073,
 554503452,
 111078,
 -57072,
 554568818,
 111077,
 -57071,
 554634198,
 111076,
 -57070,
 554699549,
 111075,
 -57069,
 554764869,
 111074,
 -57068,
 554830249,
 111073,
 -1,
 554895641,
 111072,
 555098406,
 553920098,
 -1,
 -57065,
 555037879,
 111071,
 -57064,
 555101355,
 111070,
 -57063,
 555165282,
 111069,
 -57062,
 555228678,
 111068,
 -57061,
 555292864,
 111067,
 -57060,
 555356004,
 111066,
 -57059,
 555421401,
 111065,
 -57058,
 555486810,
 111064,
 -57057,
 555552180,
 111063,
 -57056,
 555617564,
 111062,
 -57055,
 555682930,
 111061,
 -57054,
 555748310,
 111060,
 -57053,
 555813661,
 111059,
 -57052,
 555878981,
 111058,
 -57051,
 555944361,
 111057,
 -1,
 556009753,
 111056,
 556212535,
 555032070,
 -1,
 -57048,
 556151991,
 111055,
 -57047,
 556215467,
 111054,
 -57046,
 556279394,
 111053,
 -57045,
 556342790,
 111052,
 -57044,
 556406976,
 111051,
 -57043,
 556470116,
 111050,
 -57042,
 556535513,
 111049,
 -57041,
 556600922,
 111048,
 -57040,
 556666292,
 111047,
 -57039,
 556731676,
 111046,
 -57038,
 556797042,
 111045,
 -57037,
 556862422,
 111044,
 -57036,
 556927773,
 111043,
 -57035,
 556993093,
 111042,
 -57034,
 557058473,
 111041,
 -1,
 557123865,
 111040,
 557326664,
 556144832,
 -1,
 -57031,
 557266103,
 111039,
 -57030,
 557329579,
 111038,
 -57029,
 557393506,
 111037,
 -57028,
 557456902,
 111036,
 -57027,
 557521088,
 111035,
 -57026,
 557584228,
 111034,
 -57025,
 557649625,
 111033,
 -57024,
 557715034,
 111032,
 -57023,
 557780404,
 111031,
 -57022,
 557845788,
 111030,
 -57021,
 557911154,
 111029,
 -57020,
 557976534,
 111028,
 -57019,
 558041885,
 111027,
 -57018,
 558107205,
 111026,
 -57017,
 558172585,
 111025,
 -1,
 558237977,
 111024,
 558440793,
 557256548,
 -1,
 -57014,
 558380215,
 111023,
 -57013,
 558443691,
 111022,
 -57012,
 558507618,
 111021,
 -57011,
 558571014,
 111020,
 -57010,
 558635200,
 111019,
 -57009,
 558698340,
 111018,
 -57008,
 558763737,
 111017,
 -57007,
 558829146,
 111016,
 -57006,
 558894516,
 111015,
 -57005,
 558959900,
 111014,
 -57004,
 559025266,
 111013,
 -57003,
 559090646,
 111012,
 -57002,
 559155997,
 111011,
 -57001,
 559221317,
 111010,
 -57000,
 559286697,
 111009,
 -1,
 559352089,
 111008,
 559554922,
 558370521,
 -1,
 -56997,
 559494327,
 111007,
 -56996,
 559557803,
 111006,
 -56995,
 559621730,
 111005,
 -56994,
 559685126,
 111004,
 -56993,
 559749312,
 111003,
 -56992,
 559812452,
 111002,
 -56991,
 559877849,
 111001,
 -56990,
 559943258,
 111000,
 -56989,
 560008628,
 110999,
 -56988,
 560074012,
 110998,
 -56987,
 560139378,
 110997,
 -56986,
 560204758,
 110996,
 -56985,
 560270109,
 110995,
 -56984,
 560335429,
 110994,
 -56983,
 560400809,
 110993,
 -1,
 560466201,
 110992,
 560669051,
 559484506,
 -1,
 -56980,
 560608439,
 110991,
 -56979,
 560671915,
 110990,
 -56978,
 560735842,
 110989,
 -56977,
 560799238,
 110988,
 -56976,
 560863424,
 110987,
 -56975,
 560926564,
 110986,
 -56974,
 560991961,
 110985,
 -56973,
 561057370,
 110984,
 -56972,
 561122740,
 110983,
 -56971,
 561188124,
 110982,
 -56970,
 561253490,
 110981,
 -56969,
 561318870,
 110980,
 -56968,
 561384221,
 110979,
 -56967,
 561449541,
 110978,
 -56966,
 561514921,
 110977,
 -1,
 561580313,
 110976,
 561840127,
 560598452,
 -1,
 -56963,
 561722551,
 110975,
 -56962,
 561786027,
 110974,
 -56961,
 561849954,
 110973,
 -56960,
 561913350,
 110972,
 -56959,
 561977536,
 110971,
 -56958,
 562040676,
 110970,
 -56957,
 562106073,
 110969,
 -56956,
 562171482,
 110968,
 -56955,
 562236852,
 110967,
 -56954,
 562302236,
 110966,
 -56953,
 562367602,
 110965,
 -56952,
 562432982,
 110964,
 -56951,
 562498333,
 110963,
 -56950,
 562563653,
 110962,
 -56949,
 562629033,
 110961,
 -1,
 562694425,
 110960,
 -1,
 535055197,
 94177,
 562962831,
 534990796,
 983041,
 -1,
 562909132,
 983040,
 -1,
 562923125,
 128297,
 563159686,
 534916267,
 -1,
 563225115,
 563123990,
 -1,
 563290642,
 563154790,
 -1,
 563356125,
 563238041,
 -1,
 563421598,
 563306111,
 -1,
 563487128,
 563387627,
 -1,
 -56937,
 563428515,
 70681,
 -1,
 563482468,
 70680,
 563683739,
 563427686,
 -1,
 -56934,
 563625123,
 70675,
 -1,
 563679076,
 70674,
 -56932,
 563633880,
 70686,
 -56931,
 563821731,
 70692,
 -1,
 563875684,
 70691,
 564076965,
 563385335,
 -1,
 564142500,
 564028495,
 -1,
 564208034,
 564097961,
 70662,
 -1,
 564163497,
 70663,
 564396031,
 564154316,
 70664,
 -1,
 564285388,
 70665,
 -1,
 564080213,
 70751,
 564535723,
 564037219,
 -1,
 564601257,
 564495971,
 -1,
 -56920,
 564542627,
 70683,
 -1,
 564596580,
 70682,
 -56918,
 564542627,
 70688,
 -1,
 564727652,
 70687,
 564928945,
 564471394,
 -1,
 564994479,
 564864610,
 -1,
 -56914,
 564935843,
 70685,
 -1,
 564989796,
 70684,
 -56912,
 564935843,
 70690,
 -1,
 565120868,
 70689,
 565322165,
 564858724,
 70656,
 -56909,
 565284383,
 70669,
 -56908,
 565330570,
 70667,
 -1,
 565383012,
 70657,
 565584313,
 565279972,
 -1,
 -56905,
 565542270,
 70706,
 -56904,
 565591203,
 70705,
 -1,
 565645156,
 70707,
 565846459,
 565546527,
 70660,
 -1,
 565808671,
 70661,
 565977534,
 565801897,
 -1,
 -56899,
 565918883,
 70701,
 -1,
 565972836,
 70700,
 566174145,
 565931192,
 -1,
 -56896,
 566115491,
 70694,
 -1,
 566169444,
 70693,
 566370756,
 566122787,
 -1,
 -56893,
 566312099,
 70698,
 -1,
 566366052,
 70697,
 566567367,
 566317004,
 -1,
 -56890,
 566508707,
 70703,
 -1,
 566562660,
 70702,
 566763978,
 566513027,
 -1,
 -56887,
 566705315,
 70671,
 -1,
 566759268,
 70670,
 566960589,
 566709429,
 -1,
 -56884,
 566901923,
 70679,
 -1,
 566955876,
 70678,
 567157199,
 566903434,
 70658,
 -1,
 567100042,
 70659,
 567288274,
 567097702,
 -1,
 -56879,
 567229603,
 70673,
 -1,
 567283556,
 70672,
 567484885,
 567221766,
 -1,
 -56876,
 567426211,
 70677,
 -1,
 567480164,
 70676,
 567681496,
 567417024,
 -1,
 -56873,
 567622819,
 70696,
 -1,
 567676772,
 70695,
 -56871,
 567647577,
 70699,
 -56870,
 567842606,
 70704,
 -56869,
 567895019,
 70668,
 -56868,
 567950499,
 70708,
 -1,
 568011947,
 70666,
 568205805,
 563320548,
 -1,
 568271331,
 568170090,
 -1,
 568336865,
 568226729,
 70714,
 -1,
 568292265,
 70715,
 568524799,
 568283084,
 70716,
 -1,
 568414156,
 70717,
 568599015,
 568201060,
 -1,
 -56859,
 568561183,
 70721,
 -56858,
 568607370,
 70719,
 -1,
 568659812,
 70709,
 568861161,
 568561183,
 70712,
 -1,
 568823327,
 70713,
 568992235,
 568803978,
 70710,
 -1,
 568935050,
 70711,
 -56852,
 568943595,
 70720,
 -1,
 569060523,
 70718,
 569254398,
 568141410,
 -1,
 569319932,
 569197878,
 -1,
 569385458,
 569280099,
 -1,
 -56847,
 569350914,
 70738,
 -1,
 569393506,
 70739,
 569582069,
 569343204,
 -1,
 -56844,
 569527341,
 70742,
 -1,
 569586631,
 70743,
 569778680,
 569521335,
 -1,
 -56841,
 569731810,
 70740,
 -1,
 569789327,
 70741,
 -56839,
 569745390,
 70736,
 -56838,
 569927341,
 70737,
 -56837,
 569991487,
 70745,
 -1,
 570044254,
 70744,
 -56835,
 569272928,
 70732,
 -1,
 570168378,
 70731,
 570368524,
 569212132,
 -1,
 570434059,
 570311306,
 -1,
 570499594,
 570375095,
 -1,
 570565124,
 570463715,
 -1,
 -56829,
 570523181,
 70725,
 -1,
 570586294,
 70722,
 570761735,
 570494820,
 -1,
 -56826,
 570725388,
 70727,
 -1,
 570778563,
 70724,
 -56824,
 570712948,
 70726,
 -56823,
 570897881,
 70728,
 -1,
 570957469,
 70723,
 -1,
 570435487,
 70730,
 -1,
 570364991,
 70750,
 -56819,
 570322822,
 70747,
 -56818,
 571237842,
 70729,
 -56817,
 571295932,
 70749,
 -56816,
 571357682,
 70734,
 -56815,
 571417375,
 70733,
 -1,
 571478025,
 70735,
 571679255,
 563216384,
 -1,
 571744790,
 571628961,
 -1,
 -56811,
 571709887,
 127770,
 -1,
 571770420,
 127761,
 -1,
 571692651,
 983063,
 572006938,
 571627120,
 -1,
 -56807,
 571963350,
 11155,
 -1,
 572019354,
 11154,
 -1,
 571966293,
 128240,
 572269140,
 563165711,
 -1,
 572334648,
 572203363,
 -1,
 572400182,
 572281214,
 -1,
 -56801,
 572366637,
 127337,
 -56800,
 572431595,
 127336,
 -56799,
 572496938,
 127335,
 -56798,
 572561174,
 127334,
 -56797,
 572625911,
 127333,
 -56796,
 572689951,
 127332,
 -56795,
 572753507,
 127331,
 -56794,
 572816612,
 127330,
 -56793,
 572879785,
 127329,
 -56792,
 572945013,
 127328,
 -56791,
 573006827,
 127326,
 -56790,
 573070975,
 127325,
 -56789,
 573135139,
 127324,
 -56788,
 573198284,
 127323,
 -56787,
 573263235,
 127322,
 -56786,
 573328565,
 127321,
 -56785,
 573391498,
 127320,
 -56784,
 573454694,
 127318,
 -56783,
 573519031,
 127317,
 -56782,
 573582507,
 127316,
 -56781,
 573646434,
 127315,
 -56780,
 573709830,
 127314,
 -56779,
 573774016,
 127313,
 -1,
 573837156,
 127312,
 -56777,
 572361683,
 128982,
 -1,
 573998001,
 128984,
 574169683,
 572294072,
 -1,
 574235216,
 574116222,
 -1,
 -56773,
 574201645,
 127369,
 -56772,
 574266603,
 127368,
 -56771,
 574331946,
 127367,
 -56770,
 574396182,
 127366,
 -56769,
 574460919,
 127365,
 -56768,
 574524959,
 127364,
 -56767,
 574588515,
 127363,
 -56766,
 574651620,
 127362,
 -56765,
 574714793,
 127361,
 -56764,
 574780021,
 127360,
 -56763,
 574841835,
 127358,
 -56762,
 574905983,
 127357,
 -56761,
 574967171,
 127354,
 -56760,
 575029898,
 127352,
 -56759,
 575093909,
 127351,
 -56758,
 575158630,
 127350,
 -56757,
 575222967,
 127349,
 -56756,
 575286443,
 127348,
 -56755,
 575350370,
 127347,
 -56754,
 575413766,
 127346,
 -56753,
 575477952,
 127345,
 -1,
 575541092,
 127344,
 -56751,
 574199844,
 127375,
 -56750,
 575677760,
 10062,
 -1,
 575737824,
 127374,
 -1,
 574099591,
 983091,
 576004736,
 572232659,
 -1,
 576070271,
 575938753,
 -1,
 576135781,
 576015747,
 -1,
 576201313,
 576086307,
 129540,
 576323583,
 576128106,
 -1,
 576332382,
 576226915,
 -1,
 576397917,
 576297761,
 -1,
 -56740,
 576359825,
 129586,
 -1,
 576421747,
 129603,
 -1,
 576340368,
 129607,
 -56737,
 576284363,
 129565,
 -56736,
 576610687,
 129561,
 -1,
 576665525,
 129544,
 576913407,
 576145242,
 129536,
 576978943,
 576783466,
 -1,
 -56732,
 576884188,
 129599,
 -1,
 576938367,
 129557,
 577118829,
 576097554,
 -1,
 577184361,
 577064323,
 -1,
 -56728,
 577134883,
 129582,
 -1,
 577193818,
 129578,
 -56726,
 577141679,
 129580,
 -56725,
 577336132,
 129579,
 -56724,
 577400370,
 129583,
 -1,
 577444671,
 129581,
 577643121,
 577076143,
 129538,
 577765375,
 577569898,
 -1,
 -56720,
 577670620,
 129601,
 -1,
 577724799,
 129559,
 577905269,
 577598276,
 129537,
 578027519,
 577832042,
 -1,
 -56716,
 577932764,
 129600,
 -1,
 577986943,
 129558,
 578167417,
 577859122,
 129541,
 578289663,
 578094186,
 -1,
 -56712,
 578194908,
 129604,
 -1,
 578249087,
 129562,
 578429565,
 578100031,
 129539,
 578551807,
 578356330,
 -1,
 -56708,
 578457052,
 129602,
 -1,
 578511231,
 129560,
 578748415,
 578367949,
 129610,
 -1,
 578618484,
 129613,
 -1,
 576009438,
 128528,
 -56703,
 575970481,
 983130,
 -56702,
 578847804,
 11228,
 -56701,
 578909544,
 129299,
 -56700,
 578974097,
 11209,
 -56699,
 579030988,
 983131,
 -1,
 579084884,
 128084,
 579281687,
 563089252,
 -1,
 579347166,
 579231657,
 -1,
 579412679,
 579294361,
 -1,
 579478159,
 579372643,
 -1,
 579543693,
 579438179,
 -1,
 -56692,
 579484835,
 72121,
 -1,
 579538788,
 72120,
 -56690,
 579484835,
 72126,
 -1,
 579669860,
 72125,
 579871380,
 579427967,
 -1,
 -56687,
 579837273,
 72119,
 -56686,
 579886808,
 72124,
 -56685,
 579942815,
 72114,
 -1,
 579997540,
 72129,
 580199066,
 579806818,
 -1,
 580264600,
 580134498,
 -1,
 -56681,
 580205731,
 72123,
 -1,
 580259684,
 72122,
 -56679,
 580205731,
 72128,
 -1,
 580390756,
 72127,
 580592286,
 580128612,
 72096,
 -56676,
 580554271,
 72109,
 -56675,
 580600458,
 72107,
 -1,
 580652900,
 72097,
 580854434,
 580555767,
 -1,
 580919969,
 580805728,
 72102,
 -1,
 580875177,
 72103,
 -1,
 580849508,
 72138,
 581116582,
 580812004,
 -1,
 -56668,
 581074302,
 72140,
 -56667,
 581123235,
 72139,
 -1,
 581177188,
 72141,
 581378728,
 581078559,
 72100,
 -1,
 581340703,
 72101,
 581509803,
 581333929,
 -1,
 -56662,
 581465085,
 72144,
 -1,
 581504868,
 72136,
 581706414,
 581463224,
 -1,
 -56659,
 581647523,
 72131,
 -1,
 581701476,
 72130,
 581903025,
 581652428,
 -1,
 -56656,
 581849118,
 72143,
 -1,
 581898084,
 72137,
 582099636,
 581848451,
 -1,
 -56653,
 582040739,
 72111,
 -1,
 582094692,
 72110,
 582296247,
 582044853,
 -1,
 -56650,
 582237347,
 72118,
 -1,
 582291300,
 72117,
 582492857,
 582238858,
 72098,
 -1,
 582435466,
 72099,
 582623932,
 582433126,
 -1,
 -56645,
 582565027,
 72113,
 -1,
 582618980,
 72112,
 582820543,
 582557190,
 -1,
 -56642,
 582761635,
 72116,
 -1,
 582815588,
 72115,
 583017154,
 582752448,
 -1,
 -56639,
 582958243,
 72133,
 -1,
 583012196,
 72132,
 -56637,
 582983001,
 72135,
 -56636,
 583164907,
 72108,
 -56635,
 583227757,
 72134,
 -56634,
 583285923,
 72142,
 -1,
 583347371,
 72106,
 583541461,
 579376868,
 -1,
 583606988,
 583470948,
 -1,
 -56630,
 583568927,
 72157,
 -56629,
 583615114,
 72155,
 -1,
 583667556,
 72145,
 583869134,
 583571059,
 72150,
 -1,
 583824297,
 72151,
 584000208,
 583831071,
 72148,
 -1,
 583962143,
 72149,
 584131282,
 583942794,
 72146,
 -1,
 584073866,
 72147,
 -56621,
 584085853,
 72164,
 -56620,
 584213483,
 72156,
 -1,
 584264875,
 72154,
 584458973,
 583500107,
 -1,
 584524505,
 584422883,
 -1,
 -56616,
 584482349,
 72159,
 -1,
 584545462,
 72160,
 584721116,
 584453988,
 -1,
 -56613,
 584684556,
 72161,
 -1,
 584737731,
 72158,
 -1,
 584679694,
 72162,
 -1,
 584400555,
 72163,
 585048849,
 579279264,
 -1,
 585114372,
 584995993,
 -1,
 585179882,
 585053650,
 -1,
 -56606,
 585146101,
 67724,
 -56605,
 585203888,
 67740,
 -56604,
 585262015,
 67732,
 -56603,
 585325485,
 67730,
 -56602,
 585388207,
 67728,
 -56601,
 585453067,
 67726,
 -56600,
 585514591,
 67718,
 -56599,
 585570900,
 67714,
 -1,
 585634448,
 67712,
 585835247,
 585137380,
 -1,
 585900782,
 585764708,
 -1,
 -56595,
 585849762,
 67734,
 -1,
 585902252,
 67737,
 -1,
 585842721,
 67741,
 586162930,
 585795171,
 -1,
 -56591,
 586101536,
 67723,
 -1,
 586160259,
 67742,
 586359540,
 586104415,
 67719,
 -1,
 586319951,
 67722,
 586490615,
 586288996,
 -1,
 -56586,
 586456632,
 67735,
 -1,
 586503305,
 67713,
 -56584,
 586457054,
 67721,
 -56583,
 586653429,
 67725,
 -56582,
 586717153,
 67720,
 -56581,
 586774254,
 67739,
 -56580,
 586838698,
 67738,
 -56579,
 586903116,
 67736,
 -56578,
 586965951,
 67733,
 -56577,
 587029421,
 67731,
 -56576,
 587092143,
 67729,
 -56575,
 587157003,
 67727,
 -56574,
 587217770,
 67716,
 -56573,
 587278139,
 67717,
 -1,
 587340372,
 67715,
 587539216,
 585065338,
 -1,
 587604747,
 587499107,
 -1,
 587670281,
 587568918,
 -1,
 -56568,
 587621355,
 67752,
 -1,
 587673937,
 67758,
 -56566,
 587612514,
 67753,
 -1,
 587804752,
 67757,
 587997965,
 587556525,
 67751,
 -1,
 587924028,
 67759,
 588185599,
 587936951,
 -1,
 -56561,
 588081890,
 67754,
 -1,
 588139407,
 67756,
 -1,
 587474304,
 67755,
 -56558,
 585015241,
 129535,
 -56557,
 588354363,
 129314,
 -56556,
 588417621,
 127966,
 -56555,
 588471019,
 128219,
 -56554,
 588533123,
 983092,
 -1,
 588596655,
 128133,
 588784498,
 579247649,
 -1,
 588850001,
 588730316,
 -1,
 588915536,
 588788521,
 -1,
 588981032,
 588865151,
 -1,
 589046559,
 588940899,
 -1,
 -56547,
 589012061,
 123155,
 -56546,
 589069694,
 123149,
 -1,
 589107044,
 123138,
 589308706,
 588999864,
 -1,
 -56543,
 589254686,
 123166,
 -1,
 589303652,
 123164,
 -56541,
 589274457,
 123152,
 -56540,
 589460477,
 123153,
 -56539,
 589525623,
 123161,
 -56538,
 589581786,
 123143,
 -56537,
 589635106,
 123148,
 -1,
 589696868,
 123141,
 589898540,
 588940899,
 -1,
 -56534,
 589864029,
 123156,
 -56533,
 589921662,
 123137,
 -1,
 589959012,
 123139,
 590160687,
 589863978,
 -1,
 -56530,
 590126425,
 123163,
 -1,
 590155620,
 123142,
 590357298,
 590115753,
 -1,
 -56527,
 590312445,
 123171,
 -1,
 590352228,
 123158,
 590553909,
 590310584,
 -1,
 -56524,
 590499870,
 123169,
 -1,
 590548836,
 123162,
 590750519,
 590504939,
 123176,
 -1,
 590701547,
 123177,
 590881594,
 590698787,
 -1,
 -56519,
 590827550,
 123168,
 -1,
 590876516,
 123136,
 591078204,
 590822563,
 123140,
 -1,
 591019157,
 123167,
 591209278,
 591015083,
 123178,
 -1,
 591146155,
 123179,
 591340353,
 591144546,
 -1,
 -56512,
 591286302,
 123165,
 -1,
 591335268,
 123151,
 591536963,
 591269732,
 123172,
 -1,
 591466340,
 123173,
 -56508,
 591503201,
 123147,
 -56507,
 591633753,
 123160,
 -56506,
 591697686,
 123180,
 -56505,
 591762441,
 123154,
 -56504,
 591826463,
 123175,
 -56503,
 591887742,
 123146,
 -56502,
 591950455,
 123159,
 -56501,
 592007198,
 123145,
 -56500,
 592072154,
 123150,
 -56499,
 592134794,
 123174,
 -56498,
 592198047,
 123170,
 -56497,
 592262363,
 123157,
 -1,
 592322082,
 123144,
 -1,
 588866810,
 123214,
 592585567,
 588785923,
 -1,
 592651093,
 592545379,
 -1,
 -56492,
 592616194,
 123202,
 -1,
 592658786,
 123203,
 592847704,
 592608484,
 -1,
 -56489,
 592792621,
 123206,
 -1,
 592851911,
 123207,
 593044315,
 592786615,
 -1,
 -56486,
 592997090,
 123204,
 -1,
 593054607,
 123205,
 -56484,
 593010670,
 123200,
 -56483,
 593192621,
 123201,
 -56482,
 593256767,
 123209,
 -1,
 593309534,
 123208,
 593503079,
 592546516,
 -1,
 -56479,
 593466359,
 123187,
 -56478,
 593525988,
 123188,
 -56477,
 593582371,
 123185,
 -56476,
 593644725,
 123186,
 -56475,
 593705318,
 123189,
 -56474,
 593765986,
 123190,
 -1,
 593828032,
 123184,
 594027377,
 593460452,
 -1,
 594092912,
 593970499,
 -1,
 594158447,
 594032513,
 -1,
 -56469,
 594118835,
 123192,
 -56468,
 594177792,
 123191,
 -56467,
 594237233,
 123193,
 -56466,
 594299163,
 123195,
 -1,
 594351283,
 123194,
 -1,
 594123995,
 123196,
 -1,
 594058882,
 123197,
 -1,
 593961324,
 123215,
 594748320,
 588735467,
 -1,
 594813832,
 594703273,
 -1,
 594879367,
 594774095,
 -1,
 594944902,
 594804736,
 -1,
 595010430,
 594909316,
 -1,
 595075963,
 594964538,
 -1,
 -56455,
 595039781,
 128600,
 -56454,
 595087982,
 128592,
 -1,
 595139987,
 128608,
 595338109,
 595037218,
 11110,
 -1,
 595264928,
 11126,
 -1,
 595295732,
 129108,
 595591167,
 594947445,
 -1,
 595600259,
 595488826,
 -1,
 -56447,
 595564069,
 128602,
 -56446,
 595612270,
 128594,
 -1,
 595664275,
 128610,
 595862405,
 595561506,
 11111,
 -1,
 595789216,
 11127,
 -1,
 595820020,
 129109,
 -1,
 594881949,
 128746,
 -1,
 594815221,
 8379,
 596190099,
 594739200,
 -1,
 596255628,
 596143288,
 -1,
 -56437,
 596199891,
 128370,
 -1,
 596258372,
 128695,
 596452239,
 596187328,
 -1,
 -56434,
 596407693,
 983126,
 -1,
 596460487,
 128691,
 -56432,
 596411106,
 128685,
 -56431,
 596600625,
 128286,
 -56430,
 596663614,
 128245,
 -1,
 596717894,
 128683,
 596911005,
 596149859,
 -1,
 596976538,
 596847787,
 128456,
 597042071,
 596909226,
 128211,
 -1,
 596969026,
 128212,
 597229567,
 596968432,
 -1,
 -56423,
 597113418,
 128457,
 -1,
 597173858,
 128458,
 597426175,
 596910225,
 -1,
 -56420,
 597325955,
 128324,
 -1,
 597381896,
 128323,
 -56418,
 596868710,
 128067,
 -56417,
 597515969,
 128689,
 -1,
 597581095,
 65934,
 597762981,
 594693953,
 -1,
 597828516,
 597698146,
 -1,
 -56413,
 597780865,
 2046,
 -1,
 597824720,
 2045,
 -1,
 597788519,
 2047,
 598090664,
 597694656,
 -1,
 -56409,
 598049611,
 983196,
 -1,
 598097045,
 983127,
 -56407,
 598040383,
 983227,
 -56406,
 598233036,
 983066,
 -1,
 598295784,
 127747,
 598485006,
 534846982,
 -1,
 598549804,
 598445599,
 -1,
 598615324,
 598499419,
 -1,
 598680840,
 598573387,
 -1,
 598746141,
 598626252,
 -1,
 598811666,
 598675300,
 -1,
 598877199,
 598756817,
 -1,
 598942671,
 598805788,
 -1,
 599008193,
 598870591,
 75009,
 599130111,
 598934913,
 -1,
 599139257,
 599035423,
 -1,
 -56393,
 599096487,
 75019,
 -56392,
 599139938,
 75018,
 -1,
 599198277,
 75017,
 599401404,
 599098979,
 -1,
 -56389,
 599338155,
 75016,
 -1,
 599397744,
 75015,
 -56387,
 599347230,
 75014,
 -56386,
 599543682,
 75013,
 -56385,
 599600245,
 75012,
 -56384,
 599660836,
 75011,
 -1,
 599725840,
 75010,
 599925709,
 598936684,
 75021,
 600047615,
 599852417,
 -1,
 600056774,
 599952927,
 -1,
 -56379,
 600013991,
 75030,
 -1,
 600057442,
 75029,
 600253384,
 599999785,
 75024,
 -1,
 600179238,
 75025,
 -56375,
 600211548,
 75028,
 -56374,
 600337799,
 75027,
 -56373,
 600400156,
 75026,
 -56372,
 600455583,
 75023,
 -1,
 600517725,
 75022,
 -56370,
 599854032,
 75020,
 -1,
 600639910,
 75008,
 600843236,
 598870998,
 -1,
 600908762,
 600771542,
 -1,
 600974297,
 600837849,
 74993,
 601096191,
 600900993,
 -1,
 601105366,
 600993123,
 -1,
 -56363,
 601058669,
 74997,
 -1,
 601118971,
 74996,
 -56361,
 601067170,
 74998,
 -56360,
 601244969,
 74995,
 -1,
 601308209,
 74994,
 -1,
 600902057,
 74992,
 601564127,
 600837849,
 -1,
 -56356,
 601492594,
 75006,
 -56355,
 601557789,
 75005,
 -56354,
 601623109,
 75004,
 -1,
 601688345,
 75003,
 601891810,
 601492594,
 -1,
 -56351,
 601820596,
 75000,
 -1,
 601884953,
 74999,
 -56349,
 601820886,
 75002,
 -1,
 602017343,
 75001,
 602219507,
 600770841,
 -1,
 602285032,
 602148442,
 -1,
 -56345,
 602212844,
 74974,
 -1,
 602278169,
 74973,
 602481643,
 602213490,
 -1,
 -56342,
 602409385,
 74970,
 -1,
 602474777,
 74969,
 602678254,
 602409541,
 -1,
 -56339,
 602606706,
 74967,
 -1,
 602671529,
 74966,
 -56337,
 602607453,
 74975,
 -56336,
 602803781,
 74972,
 -56335,
 602869166,
 74971,
 -56334,
 602934208,
 74968,
 -1,
 602999203,
 74965,
 603202559,
 602147397,
 -1,
 603268088,
 603130437,
 -1,
 -56330,
 603197018,
 74982,
 -56329,
 603262066,
 74981,
 -1,
 603326745,
 74980,
 603530235,
 603196700,
 -1,
 -56326,
 603458844,
 74985,
 -1,
 603524210,
 74984,
 603726846,
 603457961,
 -1,
 -56323,
 603655897,
 74979,
 -1,
 603719961,
 74978,
 -1,
 603655123,
 74983,
 603989000,
 603130653,
 -1,
 604054532,
 603917270,
 -1,
 -56318,
 603983450,
 74988,
 -56317,
 604048820,
 74987,
 -1,
 604113693,
 74986,
 604316679,
 603983450,
 -1,
 -56314,
 604244950,
 74990,
 -1,
 604310301,
 74989,
 -1,
 604245842,
 74991,
 604578827,
 603917748,
 -1,
 -56310,
 604507247,
 75032,
 -1,
 604572430,
 75031,
 604775438,
 604506537,
 -1,
 -56307,
 604703849,
 74977,
 -1,
 604769216,
 74976,
 -1,
 604704020,
 75007,
 605093887,
 598817190,
 -1,
 -56303,
 605003804,
 74964,
 -1,
 605043518,
 74632,
 605290495,
 598773397,
 -1,
 605299739,
 605194777,
 -1,
 605365270,
 605252959,
 75036,
 -1,
 605291528,
 75037,
 -56297,
 605325139,
 75038,
 -56296,
 605454570,
 74635,
 -56295,
 605502740,
 75035,
 -56294,
 605565665,
 74634,
 -1,
 605628730,
 75034,
 -56292,
 605257849,
 74633,
 -1,
 605764714,
 75033,
 605955157,
 598681186,
 -1,
 606020679,
 605916703,
 -1,
 606086214,
 605960559,
 -1,
 606151718,
 606031820,
 -1,
 606217253,
 606080868,
 -1,
 606282788,
 606165283,
 74911,
 -1,
 606209417,
 74912,
 -1,
 606227924,
 74910,
 -1,
 606179357,
 74913,
 606544940,
 606096771,
 -1,
 606610475,
 606506527,
 -1,
 606676010,
 606568691,
 74908,
 -1,
 606602235,
 74909,
 -1,
 606630825,
 74907,
 -1,
 606541612,
 74906,
 606938161,
 606484838,
 -1,
 607003696,
 606880394,
 74900,
 -56273,
 606961539,
 74902,
 -1,
 607024117,
 74901,
 -1,
 606932836,
 74899,
 607265845,
 606886179,
 -1,
 -56269,
 607208074,
 74916,
 -56268,
 607269556,
 74915,
 -1,
 607328016,
 74914,
 607527993,
 607194980,
 -1,
 607593528,
 607485827,
 74894,
 -1,
 607518914,
 74895,
 -1,
 607544071,
 74893,
 607790140,
 607485156,
 -1,
 -56261,
 607732379,
 74920,
 -1,
 607796831,
 74919,
 607986751,
 607730837,
 -1,
 -56258,
 607928970,
 74904,
 -1,
 607981412,
 74903,
 608183362,
 607921762,
 -1,
 -56255,
 608145596,
 74897,
 -1,
 608192042,
 74896,
 -56253,
 608137009,
 74918,
 -56252,
 608330012,
 74917,
 -56251,
 608388397,
 74905,
 -1,
 608449119,
 74898,
 -1,
 606017733,
 74614,
 608707662,
 605962890,
 -1,
 608773197,
 608655651,
 -1,
 608838732,
 608699777,
 -1,
 -56245,
 608800339,
 74891,
 -1,
 608847145,
 74890,
 -1,
 608766696,
 74892,
 -1,
 608731040,
 74613,
 609222655,
 608636772,
 -1,
 609231956,
 609106278,
 -1,
 609297491,
 609157120,
 -1,
 -56238,
 609258016,
 74889,
 -1,
 609308422,
 74611,
 -1,
 609225501,
 74612,
 -1,
 609158548,
 74888,
 609625213,
 605895014,
 -1,
 609690740,
 609554276,
 -1,
 609756275,
 609618628,
 -1,
 609821788,
 609705952,
 74948,
 609943551,
 609747956,
 -1,
 -56229,
 609827646,
 74950,
 -1,
 609889569,
 74949,
 610083936,
 609767372,
 -1,
 610149471,
 610014020,
 74944,
 -1,
 610076041,
 74945,
 -1,
 610111514,
 74946,
 610346084,
 610023839,
 74939,
 610467839,
 610300853,
 -1,
 -56221,
 610361312,
 74941,
 -1,
 610412720,
 74940,
 610608233,
 610281058,
 -1,
 610673768,
 610570236,
 -1,
 -56217,
 610618927,
 74937,
 -1,
 610682157,
 74936,
 -1,
 610616818,
 74935,
 610935916,
 610537316,
 -1,
 -56213,
 610893768,
 74618,
 -1,
 610950799,
 74617,
 -56211,
 610902032,
 74952,
 -56210,
 611090603,
 74951,
 -56209,
 611147369,
 74947,
 -56208,
 611209122,
 74943,
 -56207,
 611269798,
 74942,
 -56206,
 611332668,
 74938,
 -1,
 611391797,
 74934,
 -1,
 609687764,
 74953,
 611656823,
 609652255,
 -1,
 -56202,
 611591833,
 74957,
 -1,
 611650263,
 74956,
 611853434,
 611598986,
 -1,
 -56199,
 611811244,
 74955,
 -1,
 611858790,
 74620,
 612106239,
 611789995,
 -1,
 -56196,
 612008156,
 74954,
 -1,
 612043531,
 74619,
 612246676,
 609574527,
 -1,
 612312207,
 612189738,
 74639,
 612377742,
 612247300,
 -1,
 612443267,
 612339231,
 75050,
 -56190,
 612400295,
 75052,
 -1,
 612434971,
 75051,
 612639879,
 612383078,
 -1,
 612705414,
 612582026,
 74642,
 -1,
 612663171,
 75043,
 -1,
 612667481,
 75044,
 -56184,
 612593018,
 75049,
 -56183,
 612850315,
 75048,
 -56182,
 612913290,
 75047,
 -56181,
 612978338,
 75046,
 -56180,
 613040038,
 75045,
 -56179,
 613099786,
 75042,
 -1,
 613161276,
 74641,
 -1,
 612306649,
 74640,
 613426323,
 612273808,
 -1,
 -56175,
 613386260,
 983260,
 -56174,
 613448693,
 74643,
 -1,
 613510118,
 983261,
 -1,
 613355424,
 74638,
 613754024,
 612191706,
 -1,
 613819559,
 613680513,
 -1,
 613885082,
 613781023,
 -1,
 613950617,
 613839785,
 74963,
 -1,
 613878341,
 74631,
 -1,
 613877191,
 74962,
 614147229,
 613824870,
 -1,
 -56164,
 614109092,
 74625,
 -1,
 614156966,
 74624,
 614343840,
 614076260,
 -1,
 -56161,
 614301662,
 74623,
 -1,
 614359815,
 74622,
 -56159,
 614305002,
 74630,
 -56158,
 614498552,
 74629,
 -56157,
 614558962,
 74628,
 -56156,
 614619408,
 74627,
 -56155,
 614682074,
 74961,
 -56154,
 614743977,
 74626,
 -1,
 614800784,
 74960,
 -1,
 613772477,
 74607,
 615064765,
 613690539,
 -1,
 615130296,
 615030761,
 -1,
 615195827,
 615088234,
 -1,
 615261357,
 615144168,
 74930,
 -1,
 615218404,
 74931,
 615392431,
 615206942,
 74928,
 -1,
 615337932,
 74929,
 -56144,
 615351735,
 74932,
 -56143,
 615466285,
 74927,
 -56142,
 615530406,
 74926,
 -1,
 615585552,
 74925,
 615841791,
 615156249,
 -1,
 615851191,
 615742692,
 -1,
 -56138,
 615812639,
 74933,
 -1,
 615857759,
 74616,
 -1,
 615791692,
 74615,
 616113339,
 615058116,
 -1,
 -56134,
 616066399,
 74922,
 -1,
 616124318,
 74921,
 -56132,
 616071116,
 74924,
 -1,
 616266175,
 74923,
 616441041,
 615021796,
 -1,
 616506569,
 616381589,
 -1,
 616572101,
 616443053,
 -1,
 616637636,
 616525823,
 -1,
 -56126,
 616594972,
 75061,
 -56125,
 616652561,
 75060,
 -1,
 616710696,
 75059,
 -1,
 616590371,
 75058,
 616965320,
 616533657,
 -1,
 -56121,
 616901924,
 75063,
 -1,
 616967272,
 75062,
 -1,
 616894371,
 75057,
 617227472,
 616436115,
 -1,
 617293007,
 617187865,
 -1,
 -56116,
 617252691,
 75056,
 -56115,
 617316393,
 75055,
 -56114,
 617366829,
 74646,
 -1,
 617427024,
 75054,
 -1,
 617233529,
 75053,
 -1,
 617169659,
 75064,
 617751773,
 616402463,
 -1,
 617817307,
 617706409,
 -1,
 617882840,
 617778762,
 -1,
 617948375,
 617828300,
 -1,
 -56106,
 617909933,
 75072,
 -1,
 617943615,
 75071,
 -1,
 617883507,
 75070,
 618266623,
 617810503,
 -1,
 -56102,
 618170922,
 75069,
 -1,
 618219816,
 75068,
 -56100,
 617765197,
 74648,
 -1,
 618333636,
 74649,
 618538214,
 617680740,
 -1,
 618603748,
 618469568,
 -1,
 618669283,
 618530177,
 -1,
 618734818,
 618619839,
 74608,
 -1,
 618661136,
 74880,
 -1,
 618692851,
 74881,
 -1,
 618597069,
 74609,
 -56091,
 618551876,
 74610,
 -1,
 618931922,
 74882,
 619128046,
 618486051,
 -1,
 619193580,
 619090770,
 -1,
 619259115,
 619119538,
 -1,
 -56086,
 619204089,
 75041,
 -1,
 619264415,
 75040,
 -1,
 619187102,
 74637,
 -56083,
 619135665,
 75039,
 -1,
 619459279,
 74636,
 619652342,
 619059392,
 -1,
 619717877,
 619581284,
 -1,
 619783412,
 619658776,
 -1,
 -56078,
 619749217,
 74886,
 -56077,
 619798812,
 74885,
 -1,
 619843555,
 74884,
 -1,
 619718336,
 74883,
 -1,
 619679286,
 74887,
 620176636,
 619611747,
 -1,
 620242170,
 620138640,
 -1,
 -56071,
 620202253,
 75067,
 -1,
 620247528,
 75066,
 -56069,
 620184345,
 74647,
 -1,
 620368454,
 75065,
 620569857,
 620142381,
 -1,
 620635392,
 620531231,
 -1,
 -56065,
 620563674,
 75075,
 -1,
 620626907,
 75074,
 -1,
 620564395,
 75073,
 620897541,
 620510357,
 -1,
 -56061,
 620860242,
 74621,
 -56060,
 620905181,
 74959,
 -1,
 620957572,
 74958,
 621215743,
 620850360,
 -1,
 -56057,
 621103567,
 74645,
 -1,
 621163219,
 74644,
 621356315,
 598631345,
 -1,
 621421841,
 621292715,
 -1,
 621487376,
 621367478,
 -1,
 621552910,
 621425847,
 -1,
 -56051,
 621504927,
 74855,
 -1,
 621560882,
 74856,
 -56049,
 621514232,
 74854,
 -1,
 621700903,
 74853,
 -1,
 621429972,
 74861,
 621946132,
 621378788,
 -1,
 -56045,
 621890650,
 74859,
 -1,
 621949923,
 74860,
 622142743,
 621897393,
 -1,
 -56042,
 622097166,
 74851,
 -1,
 622148939,
 74852,
 622339354,
 622081207,
 -1,
 -56039,
 622291788,
 74857,
 -1,
 622349306,
 74858,
 -1,
 622289243,
 74862,
 -1,
 621310490,
 74868,
 622667043,
 598569897,
 -1,
 622732576,
 622621609,
 -1,
 -56033,
 622697712,
 127835,
 -1,
 622735505,
 128177,
 622985215,
 622677964,
 -1,
 -56030,
 622894356,
 10160,
 -1,
 622938145,
 129356,
 623125799,
 622619832,
 -1,
 -56027,
 623068129,
 11232,
 -56026,
 623124043,
 129473,
 -1,
 623183845,
 129380,
 623387946,
 623084609,
 -1,
 -56023,
 623339083,
 128707,
 -1,
 623383985,
 127854,
 -56021,
 623347400,
 129385,
 -1,
 623519185,
 129362,
 623715855,
 598490261,
 -1,
 623781277,
 623652011,
 -1,
 623846807,
 623735721,
 -1,
 623912340,
 623797630,
 -1,
 623977875,
 623870510,
 -1,
 624043331,
 623937123,
 -1,
 624108857,
 624000228,
 -1,
 -56012,
 624071671,
 43960,
 -56011,
 624135711,
 43959,
 -56010,
 624190443,
 43958,
 -56009,
 624247434,
 43957,
 -56008,
 624307371,
 43956,
 -1,
 624365412,
 43955,
 624567616,
 624054220,
 -1,
 -56005,
 624530423,
 43954,
 -56004,
 624594463,
 43953,
 -56003,
 624649195,
 43952,
 -56002,
 624706186,
 43951,
 -56001,
 624766123,
 43950,
 -1,
 624824164,
 43949,
 -55999,
 624509578,
 43944,
 -55998,
 624962731,
 43942,
 -1,
 625020772,
 43940,
 625222986,
 624000228,
 43933,
 -55995,
 625185783,
 43938,
 -55994,
 625249823,
 43937,
 -55993,
 625304555,
 43936,
 -55992,
 625361546,
 43935,
 -55991,
 625421483,
 43934,
 -1,
 625479524,
 43932,
 625681746,
 625172095,
 -1,
 625747277,
 625610596,
 43918,
 -1,
 625687701,
 43920,
 -55986,
 625710071,
 43925,
 -55985,
 625839647,
 43924,
 -55984,
 625894379,
 43923,
 -55983,
 625951370,
 43922,
 -1,
 626011307,
 43921,
 626206042,
 625622165,
 -1,
 -55980,
 626168823,
 43906,
 -55979,
 626232863,
 43905,
 -55978,
 626287595,
 43904,
 -55977,
 626351832,
 43919,
 -55976,
 626410122,
 43903,
 -55975,
 626470059,
 43902,
 -1,
 626528100,
 43901,
 626730338,
 626140770,
 -1,
 -55972,
 626693111,
 43947,
 -55971,
 626757151,
 43946,
 -55970,
 626811883,
 43945,
 -55969,
 626872350,
 43948,
 -55968,
 626934410,
 43943,
 -55967,
 626994347,
 43941,
 -1,
 627052388,
 43939,
 627254633,
 626695403,
 -1,
 -55964,
 627217399,
 5116,
 -55963,
 627281439,
 5115,
 -55962,
 627336171,
 5114,
 -55961,
 627393162,
 5113,
 -55960,
 627453099,
 5112,
 -1,
 627511140,
 43967,
 627713392,
 627218198,
 -1,
 -55957,
 627676151,
 43966,
 -55956,
 627740191,
 43965,
 -55955,
 627794923,
 43964,
 -55954,
 627851914,
 43963,
 -55953,
 627911851,
 43962,
 -1,
 627969892,
 43961,
 628172151,
 627667631,
 -1,
 -55950,
 628134903,
 43931,
 -55949,
 628198943,
 43930,
 -55948,
 628253675,
 43929,
 -55947,
 628310666,
 43928,
 -55946,
 628370603,
 43927,
 -1,
 628428644,
 43926,
 628630910,
 628119843,
 -1,
 -55943,
 628593655,
 5117,
 -55942,
 628657695,
 43917,
 -55941,
 628712427,
 43916,
 -55940,
 628769418,
 43915,
 -55939,
 628829355,
 43914,
 -1,
 628887396,
 43913,
 629089669,
 628576204,
 -1,
 -55936,
 629052407,
 43912,
 -55935,
 629116447,
 43911,
 -55934,
 629171179,
 43910,
 -55933,
 629228170,
 43909,
 -55932,
 629288107,
 43908,
 -1,
 629346148,
 43907,
 629548428,
 629029222,
 -1,
 -55929,
 629511159,
 43900,
 -55928,
 629575199,
 43899,
 -55927,
 629629931,
 43898,
 -55926,
 629686922,
 43897,
 -55925,
 629746859,
 43896,
 -1,
 629804900,
 43894,
 -55923,
 629511159,
 43893,
 -55922,
 629968415,
 43892,
 -55921,
 630023147,
 43891,
 -55920,
 630083034,
 43895,
 -55919,
 630145674,
 43890,
 -55918,
 630205611,
 43889,
 -1,
 630263652,
 43888,
 -1,
 623924440,
 5109,
 630587391,
 623866793,
 -1,
 -55914,
 630496507,
 127800,
 -1,
 630539279,
 127826,
 630728090,
 623783083,
 -1,
 -55911,
 630685293,
 129472,
 -1,
 630749694,
 128227,
 -55909,
 630686958,
 127792,
 -55908,
 630879083,
 127937,
 -1,
 630923824,
 128638,
 631121414,
 623710052,
 -1,
 631186940,
 631066413,
 -1,
 631252434,
 631133337,
 -1,
 631317926,
 631211619,
 -1,
 631383460,
 631277155,
 -1,
 -55901,
 631323824,
 69906,
 -1,
 631377842,
 69905,
 -55899,
 631323824,
 69911,
 -1,
 631508914,
 69910,
 631711147,
 631266943,
 -1,
 -55896,
 631676260,
 69904,
 -55895,
 631725822,
 69909,
 -55894,
 631781794,
 69899,
 -1,
 631836594,
 69914,
 632038833,
 631645794,
 -1,
 632104367,
 631973474,
 -1,
 -55890,
 632044720,
 69908,
 -1,
 632098738,
 69907,
 -55888,
 632044720,
 69913,
 -1,
 632229810,
 69912,
 632432052,
 632003819,
 -1,
 -55885,
 632397156,
 69920,
 -1,
 632426418,
 69921,
 632628663,
 632384696,
 -1,
 -55882,
 632569008,
 69916,
 -1,
 632623026,
 69915,
 632825274,
 632573900,
 -1,
 -55879,
 632765616,
 69956,
 -1,
 632819634,
 69923,
 633021885,
 632769923,
 -1,
 -55876,
 632962224,
 69896,
 -1,
 633016242,
 69895,
 633218496,
 632966325,
 -1,
 -55873,
 633158832,
 69903,
 -1,
 633212850,
 69902,
 633415107,
 633157990,
 -1,
 -55870,
 633355440,
 69898,
 -1,
 633409458,
 69897,
 633611718,
 633347590,
 -1,
 -55867,
 633552048,
 69901,
 -1,
 633606066,
 69900,
 633808329,
 633542848,
 -1,
 -55864,
 633748656,
 69918,
 -1,
 633802674,
 69917,
 -55862,
 633771825,
 69924,
 -55861,
 633966111,
 69893,
 -55860,
 634027401,
 69925,
 -55859,
 634090512,
 69922,
 -55858,
 634149232,
 69919,
 -55857,
 634208906,
 69892,
 -55856,
 634272944,
 69926,
 -55855,
 634334379,
 69894,
 -1,
 634392498,
 69891,
 634594785,
 631215095,
 -1,
 634660320,
 634547302,
 -1,
 634725848,
 634589028,
 69927,
 -55850,
 634687007,
 69935,
 -55849,
 634733194,
 69933,
 -1,
 634785636,
 69957,
 634987994,
 634687007,
 69930,
 -1,
 634949151,
 69931,
 635119068,
 634938347,
 69934,
 -1,
 635060874,
 69936,
 635250142,
 635060874,
 69928,
 -1,
 635191946,
 69929,
 635437055,
 635186347,
 69932,
 -1,
 635323018,
 69958,
 -1,
 634603993,
 69939,
 635577842,
 634529378,
 -1,
 635643376,
 635520310,
 -1,
 635708902,
 635602531,
 -1,
 -55835,
 635673346,
 69944,
 -1,
 635715938,
 69945,
 635905513,
 635665636,
 -1,
 -55832,
 635849773,
 69948,
 -1,
 635909063,
 69949,
 636102124,
 635843767,
 -1,
 -55829,
 636054242,
 69946,
 -1,
 636111759,
 69947,
 -55827,
 636067822,
 69942,
 -55826,
 636249773,
 69943,
 -55825,
 636313919,
 69951,
 -1,
 636366686,
 69950,
 -55823,
 635595360,
 69954,
 -1,
 636490810,
 69953,
 636691960,
 635534564,
 -1,
 636757495,
 636634435,
 -1,
 -55819,
 636720710,
 69890,
 -55818,
 636755613,
 69888,
 -1,
 636818697,
 69889,
 -1,
 636693968,
 69952,
 -55815,
 636646263,
 69955,
 -55814,
 637035524,
 69937,
 -55813,
 637098356,
 69940,
 -1,
 637147195,
 69938,
 637347333,
 631141289,
 -1,
 637412865,
 637306602,
 -1,
 637478400,
 637375073,
 128200,
 -1,
 637403237,
 128185,
 -1,
 637414405,
 128201,
 637730815,
 637341866,
 983058,
 637796351,
 637599744,
 -1,
 -55804,
 637704678,
 983139,
 -1,
 637763420,
 983136,
 -1,
 637290956,
 129681,
 638002699,
 631063178,
 -1,
 638068233,
 637948351,
 129490,
 -1,
 638023376,
 128696,
 -55798,
 638021653,
 128063,
 -1,
 638132779,
 128020,
 638330382,
 637953003,
 -1,
 -55795,
 638284169,
 129378,
 -1,
 638329551,
 127851,
 -1,
 638286545,
 127876,
 638592764,
 623666155,
 -1,
 638658222,
 638540067,
 -1,
 638723755,
 638589723,
 -1,
 638789206,
 638663014,
 -1,
 638854725,
 638734452,
 -1,
 638920221,
 638819563,
 -1,
 638985754,
 638856363,
 -1,
 639051289,
 638940073,
 -1,
 -55784,
 639012383,
 122911,
 -1,
 639058570,
 122912,
 -1,
 639010210,
 122885,
 -55781,
 638946847,
 122915,
 -55780,
 639263723,
 122918,
 -1,
 639309755,
 122913,
 639510051,
 638861962,
 122891,
 639575585,
 639461854,
 -1,
 -55776,
 639533752,
 122919,
 -1,
 639572707,
 122921,
 -55774,
 639541235,
 122889,
 -1,
 639721894,
 122890,
 639903273,
 639466724,
 -1,
 639968807,
 639843477,
 -1,
 -55770,
 639928050,
 122907,
 -1,
 639962980,
 122910,
 -55768,
 639916586,
 122916,
 -1,
 640112594,
 122900,
 640296492,
 639868717,
 -1,
 -55765,
 640237694,
 122886,
 -1,
 640299082,
 122888,
 640493103,
 640255587,
 -1,
 -55762,
 640456432,
 122901,
 -1,
 640516349,
 122908,
 640689714,
 640431287,
 -1,
 -55759,
 640645860,
 122903,
 -1,
 640699184,
 122922,
 640886325,
 640624226,
 -1,
 -55756,
 640836682,
 122884,
 -1,
 640896291,
 122892,
 641082936,
 640817344,
 -1,
 -55753,
 641044565,
 122881,
 -1,
 641090618,
 122920,
 -55751,
 641045599,
 122882,
 -55750,
 641241164,
 122902,
 -55749,
 641301214,
 122899,
 -55748,
 641364082,
 122898,
 -55747,
 641427475,
 122897,
 -55746,
 641490736,
 122896,
 -55745,
 641556087,
 122895,
 -55744,
 641619638,
 122894,
 -55743,
 641682941,
 122893,
 -55742,
 641744745,
 122904,
 -55741,
 641809299,
 122883,
 -55740,
 641868053,
 122909,
 -1,
 641931452,
 122880,
 642187263,
 638809303,
 -1,
 642197072,
 642066691,
 -1,
 642262602,
 642156131,
 -1,
 -55735,
 642226946,
 70504,
 -1,
 642269538,
 70505,
 642459213,
 642200759,
 -1,
 -55732,
 642411234,
 70506,
 -1,
 642468751,
 70507,
 -55730,
 642424814,
 70502,
 -55729,
 642613715,
 70508,
 -1,
 642672301,
 70503,
 642908159,
 642143385,
 -1,
 -55726,
 642815459,
 70515,
 -55725,
 642870514,
 70516,
 -55724,
 642932440,
 70514,
 -55723,
 642993626,
 70513,
 -1,
 643043172,
 70512,
 643245678,
 638734284,
 -1,
 643311209,
 643176409,
 -1,
 643376731,
 643272281,
 -1,
 -55718,
 643323395,
 7664,
 -1,
 643377331,
 7668,
 643573342,
 643326987,
 -1,
 -55715,
 643520003,
 7661,
 -1,
 643573939,
 7667,
 643769952,
 643504320,
 7656,
 -1,
 643707660,
 7657,
 643901027,
 643698532,
 -1,
 -55710,
 643848344,
 7655,
 -1,
 643892825,
 7666,
 -55708,
 643864342,
 7665,
 -55707,
 644054601,
 7658,
 -55706,
 644115640,
 7662,
 -55705,
 644173827,
 7660,
 -55704,
 644232375,
 7659,
 -1,
 644297423,
 7663,
 644546559,
 643253303,
 -1,
 644556397,
 644421643,
 -1,
 -55700,
 644511755,
 65064,
 -1,
 644567738,
 65063,
 -1,
 644497929,
 6841,
 644818560,
 643177990,
 -1,
 644884095,
 644783899,
 -1,
 644949628,
 644830361,
 -1,
 645015156,
 644914411,
 -1,
 -55693,
 644956810,
 42614,
 -1,
 645018288,
 42617,
 645211766,
 644976159,
 42615,
 -1,
 645156708,
 42612,
 645342840,
 645153418,
 42613,
 -1,
 645294594,
 42655,
 -55687,
 645300982,
 42618,
 -55686,
 645424683,
 42619,
 -55685,
 645479981,
 42616,
 -1,
 645541587,
 42654,
 645791743,
 644909695,
 -1,
 -55682,
 645691392,
 65071,
 -1,
 645747376,
 65070,
 -1,
 644835242,
 65069,
 645998220,
 644752994,
 -1,
 646063754,
 645948395,
 -1,
 646129288,
 646025000,
 -1,
 646194823,
 646053888,
 -1,
 -55675,
 646147541,
 6844,
 -55674,
 646211756,
 6840,
 -1,
 646269248,
 7676,
 -1,
 646129264,
 6832,
 -55671,
 646093536,
 6835,
 -1,
 646481512,
 7672,
 -55669,
 646005536,
 6833,
 -1,
 646590453,
 7675,
 646784660,
 645948395,
 -1,
 646850195,
 646730189,
 -1,
 -55665,
 646815705,
 66424,
 -55664,
 646873493,
 66426,
 -55663,
 646930541,
 66425,
 -55662,
 646981991,
 66423,
 -1,
 647041952,
 66422,
 -1,
 646803074,
 6839,
 647308953,
 646743651,
 -1,
 647374488,
 647251385,
 -1,
 -55657,
 647329803,
 65066,
 -1,
 647385786,
 65065,
 -1,
 647330401,
 6836,
 647636637,
 647261640,
 -1,
 -55653,
 647588908,
 6846,
 -55652,
 647633432,
 6845,
 -1,
 647696417,
 6843,
 647898784,
 647600467,
 -1,
 -55649,
 647838397,
 6838,
 -1,
 647899069,
 7673,
 648095395,
 647846295,
 -1,
 -55646,
 648050699,
 65068,
 -1,
 648106682,
 65067,
 648292006,
 648040047,
 -1,
 -55643,
 648247254,
 7670,
 -1,
 648303258,
 7671,
 -55641,
 648256595,
 6837,
 -55640,
 648450473,
 7669,
 -55639,
 648512862,
 6842,
 -55638,
 648562513,
 6834,
 -1,
 648616709,
 70459,
 648871935,
 638676152,
 -1,
 -55635,
 648771353,
 128476,
 -1,
 648812349,
 129517,
 649012960,
 638610616,
 -1,
 649078495,
 648972712,
 -1,
 649144029,
 649015684,
 -1,
 649209551,
 649094010,
 -1,
 649275066,
 649168483,
 -1,
 649340598,
 649238294,
 -1,
 -55627,
 649290742,
 66292,
 -1,
 649343313,
 66283,
 649537209,
 649280661,
 -1,
 -55624,
 649492034,
 66293,
 -1,
 649546378,
 66284,
 -1,
 649474128,
 66282,
 649799361,
 649231588,
 -1,
 649864894,
 649743405,
 -1,
 -55619,
 649825795,
 66287,
 -1,
 649855548,
 66296,
 650117119,
 649802695,
 -1,
 -55616,
 650022403,
 66288,
 -1,
 650052156,
 66297,
 650258120,
 649737399,
 -1,
 650323653,
 650208235,
 -1,
 -55612,
 650285699,
 66294,
 -1,
 650345632,
 66285,
 650575871,
 650265226,
 -1,
 -55609,
 650482742,
 66295,
 -1,
 650525009,
 66286,
 650716875,
 650207551,
 -1,
 -55606,
 650677763,
 66290,
 -1,
 650707516,
 66299,
 650913486,
 650653534,
 -1,
 -55603,
 650878187,
 66289,
 -1,
 650904124,
 66298,
 -1,
 650864319,
 66291,
 651175644,
 649144579,
 -1,
 651241171,
 651134563,
 -1,
 -55598,
 651205378,
 66274,
 -1,
 651247970,
 66275,
 651437782,
 651197668,
 -1,
 -55595,
 651381805,
 66278,
 -1,
 651441095,
 66279,
 651634393,
 651375799,
 -1,
 -55592,
 651586274,
 66276,
 -1,
 651643791,
 66277,
 -55590,
 651585197,
 66273,
 -55589,
 651780415,
 66281,
 -1,
 651833182,
 66280,
 -1,
 651135223,
 66272,
 -55586,
 649101884,
 11507,
 -1,
 652025557,
 11506,
 -1,
 649043564,
 127279,
 652289772,
 648961663,
 -1,
 652355301,
 652227767,
 -1,
 -55581,
 652317512,
 128533,
 -55580,
 652372684,
 128534,
 -1,
 652423984,
 127882,
 652617448,
 652315812,
 -1,
 -55577,
 652574517,
 983186,
 -1,
 652627768,
 127899,
 652814059,
 652576151,
 -1,
 -55574,
 652778460,
 128119,
 -1,
 652837190,
 128679,
 -1,
 652776613,
 127978,
 653076209,
 652240218,
 -1,
 653141744,
 653017738,
 -1,
 -55569,
 653090994,
 127859,
 -1,
 653143211,
 127850,
 -1,
 653078051,
 127834,
 653403891,
 653039382,
 128004,
 -1,
 653328860,
 128046,
 653534966,
 653364767,
 -1,
 -55563,
 653488067,
 128145,
 -1,
 653533195,
 128715,
 653731577,
 653467142,
 -1,
 -55560,
 653682711,
 129381,
 -1,
 653741936,
 127864,
 -55558,
 653687637,
 11855,
 -55557,
 653874930,
 128165,
 -1,
 653924201,
 129509,
 654124906,
 638521188,
 -1,
 654190409,
 654086022,
 -1,
 654255944,
 654136473,
 -1,
 654321419,
 654188038,
 -1,
 654386949,
 654261397,
 -1,
 654452483,
 654315364,
 66873,
 -1,
 654411363,
 66902,
 -55548,
 654404743,
 66889,
 -1,
 654525066,
 66890,
 654714632,
 654351705,
 -1,
 -55545,
 654679275,
 66891,
 -1,
 654743318,
 66911,
 654966783,
 654643044,
 -1,
 -55542,
 654876391,
 66912,
 -1,
 654930857,
 66882,
 655107857,
 654277860,
 -1,
 655173392,
 655047829,
 -1,
 655238927,
 655101796,
 66877,
 -1,
 655183235,
 66896,
 -1,
 655191175,
 66909,
 -1,
 655111336,
 66906,
 655501079,
 655042146,
 -1,
 655566613,
 655466285,
 -1,
 -55532,
 655531422,
 66895,
 -1,
 655562904,
 66901,
 -55530,
 655531376,
 66881,
 -1,
 655693673,
 66867,
 655894300,
 655466285,
 -1,
 655959835,
 655834261,
 -1,
 -55526,
 655902116,
 66871,
 -1,
 655953764,
 66875,
 -1,
 655889898,
 66869,
 656221984,
 655853155,
 -1,
 -55522,
 656186782,
 66899,
 -55521,
 656231465,
 66908,
 -1,
 656283358,
 66872,
 656484132,
 656163466,
 -1,
 -55518,
 656448177,
 66910,
 -55517,
 656504116,
 66876,
 -1,
 656565209,
 66879,
 656746279,
 656448747,
 -1,
 -55514,
 656698466,
 66874,
 -1,
 656742564,
 66913,
 656942890,
 656700023,
 -1,
 -55511,
 656907499,
 66887,
 -1,
 656962473,
 66893,
 657139501,
 656895160,
 -1,
 -55508,
 657083433,
 66914,
 -1,
 657141840,
 66903,
 657336112,
 657084364,
 -1,
 -55505,
 657301096,
 66885,
 -1,
 657331104,
 66878,
 657532723,
 657280387,
 -1,
 -55502,
 657476646,
 66915,
 -1,
 657528176,
 66884,
 657729334,
 657476789,
 -1,
 -55499,
 657670494,
 66883,
 -1,
 657725624,
 66897,
 657925945,
 657668454,
 -1,
 -55496,
 657868271,
 66866,
 -1,
 657932181,
 66904,
 658122556,
 657861803,
 -1,
 -55493,
 658087655,
 66870,
 -1,
 658118848,
 66868,
 658319167,
 658050916,
 -1,
 -55490,
 658270464,
 66888,
 -1,
 658331835,
 66864,
 -55488,
 658283637,
 66880,
 -55487,
 658478554,
 66907,
 -55486,
 658535647,
 66905,
 -55485,
 658597455,
 66898,
 -55484,
 658662074,
 66894,
 -55483,
 658725440,
 66892,
 -55482,
 658784154,
 66886,
 -55481,
 658847002,
 66900,
 -1,
 658905673,
 66865,
 -1,
 654189016,
 66927,
 659171154,
 654139007,
 983098,
 659236685,
 659103684,
 983097,
 -55476,
 659181972,
 128473,
 -1,
 659226967,
 983170,
 659433296,
 659170914,
 -1,
 -55473,
 659397867,
 127852,
 -1,
 659444227,
 128367,
 -55471,
 659383479,
 128758,
 -1,
 659578902,
 129387,
 659760988,
 659125161,
 -1,
 659826519,
 659695204,
 -1,
 659892054,
 659769011,
 128199,
 -1,
 659816866,
 128450,
 -1,
 659830203,
 128451,
 660088666,
 659780521,
 -1,
 -55463,
 660040128,
 129365,
 -1,
 660095790,
 983073,
 -55461,
 660040911,
 127887,
 -1,
 660237159,
 127904,
 660416353,
 659719779,
 128008,
 660537343,
 660341212,
 128049,
 660602879,
 660407761,
 -1,
 -55456,
 660511767,
 128572,
 -1,
 660572111,
 128569,
 660744037,
 660363555,
 -1,
 660809572,
 660681231,
 128247,
 -1,
 660735698,
 128248,
 -1,
 660762439,
 127957,
 661006184,
 660688844,
 -1,
 -55449,
 660950990,
 129305,
 -1,
 661008596,
 128197,
 -55447,
 660959078,
 11839,
 -1,
 661136830,
 127797,
 661333942,
 654069708,
 -1,
 661399467,
 661283819,
 -1,
 661464990,
 661332454,
 -1,
 661530519,
 661389794,
 -1,
 661596028,
 661489251,
 -1,
 661661558,
 661559062,
 -1,
 661727091,
 661611499,
 -1,
 -55438,
 661653777,
 128349,
 -1,
 661717795,
 128337,
 661979135,
 661663774,
 -1,
 -55435,
 661850385,
 128359,
 -1,
 661914403,
 128347,
 662120313,
 661602658,
 -1,
 -55432,
 662046993,
 128350,
 -1,
 662111011,
 128338,
 662372351,
 662057040,
 -1,
 -55429,
 662243601,
 128357,
 -1,
 662307619,
 128345,
 662513539,
 661552356,
 -1,
 662579072,
 662457389,
 -1,
 -55425,
 662505745,
 128353,
 -1,
 662569763,
 128341,
 662831103,
 662516679,
 -1,
 -55422,
 662702353,
 128354,
 -1,
 662766371,
 128342,
 662972298,
 662451383,
 -1,
 663037831,
 662924002,
 -1,
 -55418,
 662964497,
 128351,
 -1,
 663028515,
 128339,
 663289855,
 662981519,
 -1,
 -55415,
 663161105,
 128352,
 -1,
 663225123,
 128340,
 663431057,
 662908075,
 -1,
 663496590,
 663377217,
 -1,
 -55411,
 663423249,
 128358,
 -1,
 663487267,
 128346,
 663748607,
 663438507,
 -1,
 -55408,
 663619857,
 128355,
 -1,
 663683875,
 128343,
 663889812,
 663381677,
 -1,
 -55405,
 663816465,
 128348,
 -1,
 663880483,
 128336,
 664141823,
 663839039,
 -1,
 -55402,
 664013073,
 128356,
 -1,
 664077091,
 128344,
 664338431,
 661494174,
 -1,
 664348572,
 664238038,
 -1,
 664414107,
 664311688,
 128257,
 -1,
 664339989,
 128258,
 -1,
 664338480,
 128472,
 -55395,
 664308792,
 11118,
 -1,
 664546230,
 128259,
 664741797,
 661421719,
 -1,
 664807330,
 664689101,
 -1,
 -55391,
 664761444,
 128235,
 -1,
 664819843,
 128234,
 -55389,
 664768685,
 127746,
 -55388,
 664950591,
 128272,
 -1,
 665001130,
 128213,
 665200554,
 664702887,
 -1,
 -55385,
 665160474,
 127786,
 -55384,
 665223921,
 127784,
 -55383,
 665285727,
 127783,
 -1,
 665343572,
 127785,
 -1,
 665164468,
 129313,
 665593777,
 661327716,
 -1,
 665659311,
 665546993,
 -1,
 -55378,
 665601909,
 128079,
 -1,
 665661941,
 127916,
 -55376,
 665617440,
 127963,
 -1,
 665804304,
 128385,
 666042367,
 665535114,
 -1,
 666052533,
 665936331,
 -1,
 -55372,
 665992091,
 129346,
 -1,
 666048997,
 127867,
 -1,
 666005061,
 128203,
 666314715,
 661298411,
 -1,
 666380250,
 666270122,
 -1,
 666445775,
 666337838,
 -1,
 666511295,
 666404451,
 -1,
 666576830,
 666440392,
 -1,
 -55364,
 666541457,
 7303,
 -55363,
 666601399,
 7300,
 -1,
 666648109,
 7302,
 -1,
 666518001,
 7301,
 666904515,
 666445410,
 -1,
 -55359,
 666869815,
 1323,
 -55358,
 666921580,
 42649,
 -1,
 666968174,
 1325,
 667166662,
 666858409,
 -1,
 -55355,
 667118296,
 7296,
 -1,
 667169827,
 42593,
 667363273,
 667102379,
 -1,
 -55352,
 667311785,
 1321,
 -1,
 667373554,
 1327,
 -55350,
 667326811,
 7299,
 -55349,
 667521223,
 7304,
 -55348,
 667582603,
 1319,
 -55347,
 667639578,
 7298,
 -55346,
 667703174,
 7297,
 -1,
 667755881,
 42651,
 668008447,
 666377925,
 -1,
 668018644,
 667887202,
 -1,
 -55342,
 667983927,
 1322,
 -55341,
 668035692,
 42648,
 -1,
 668082286,
 1324,
 668280791,
 667954347,
 -1,
 -55338,
 668229289,
 1320,
 -1,
 668291058,
 1326,
 -55336,
 668237963,
 1318,
 -55335,
 668432216,
 42592,
 -1,
 668476777,
 42650,
 -1,
 666313326,
 127744,
 668739569,
 666268585,
 983074,
 668805094,
 668689387,
 -1,
 668870627,
 668763090,
 -1,
 668936162,
 668794880,
 -1,
 669001697,
 668889225,
 128322,
 -1,
 668927725,
 128321,
 -1,
 668949074,
 10060,
 -1,
 668872183,
 127884,
 -55324,
 668834481,
 128081,
 -55323,
 669207280,
 129360,
 -1,
 669262527,
 128010,
 669460459,
 668769515,
 -1,
 669525994,
 669402974,
 -1,
 -55319,
 669463774,
 128546,
 -1,
 669523764,
 128575,
 -1,
 669484151,
 128302,
 669788141,
 669402024,
 129431,
 -1,
 669712587,
 127951,
 669919216,
 669723819,
 -1,
 -55313,
 669875774,
 127769,
 -1,
 669919551,
 128179,
 -1,
 669847520,
 129408,
 670181383,
 668680842,
 -1,
 670246916,
 670135607,
 -1,
 670312451,
 670192255,
 -1,
 670377978,
 670246201,
 -1,
 670443513,
 670316442,
 129282,
 670564351,
 670369233,
 -1,
 -55304,
 670469550,
 129281,
 -1,
 670513163,
 129280,
 -1,
 670396553,
 128320,
 670771199,
 670319242,
 -1,
 670836734,
 670705697,
 -1,
 -55299,
 670772365,
 127568,
 -1,
 670834561,
 127569,
 -1,
 670785696,
 128712,
 -55296,
 670735402,
 11198,
 -55295,
 671058899,
 128981,
 -55294,
 671122353,
 128983,
 -1,
 671161507,
 11199,
 -1,
 670274355,
 127914,
 671426566,
 670207506,
 127961,
 -1,
 671350969,
 127750,
 -1,
 671375464,
 127910,
 671623178,
 670125374,
 -1,
 -55287,
 671560887,
 64047,
 -1,
 671624363,
 64046,
 -55285,
 671580413,
 983187,
 -55284,
 671759248,
 983200,
 -55283,
 671821842,
 128328,
 -1,
 671883272,
 983171,
 672082845,
 598429644,
 -1,
 672147909,
 672023178,
 -1,
 672213414,
 672095871,
 -1,
 672278947,
 672148651,
 -1,
 672344479,
 672208243,
 -1,
 672409715,
 672274624,
 -1,
 672475236,
 672336153,
 -1,
 672540708,
 672401989,
 -1,
 672606233,
 672467525,
 67090,
 -55272,
 672553251,
 67092,
 -1,
 672609463,
 67091,
 672802844,
 672532905,
 67087,
 -55269,
 672749859,
 67089,
 -1,
 672806071,
 67088,
 672999454,
 672729885,
 67093,
 -1,
 672946467,
 67094,
 -55265,
 672927449,
 67100,
 -55264,
 673058394,
 67098,
 -55263,
 673123764,
 67097,
 -55262,
 673189148,
 67096,
 -55261,
 673254358,
 67095,
 -1,
 673319193,
 67086,
 673523758,
 672468082,
 -1,
 -55258,
 673451737,
 67123,
 -55257,
 673517146,
 67122,
 -55256,
 673582516,
 67121,
 -55255,
 673647900,
 67120,
 -55254,
 673713266,
 67119,
 -55253,
 673778646,
 67118,
 -55252,
 673843997,
 67117,
 -55251,
 673909161,
 67116,
 -1,
 673974553,
 67115,
 674179128,
 673450265,
 -1,
 -55248,
 674107097,
 67080,
 -55247,
 674172506,
 67079,
 -55246,
 674237876,
 67078,
 -55245,
 674303260,
 67077,
 -55244,
 674368626,
 67076,
 -55243,
 674434006,
 67075,
 -55242,
 674499357,
 67074,
 -55241,
 674564677,
 67073,
 -1,
 674630057,
 67072,
 674834497,
 674106326,
 -1,
 -55238,
 674762457,
 67114,
 -55237,
 674827866,
 67113,
 -55236,
 674893236,
 67112,
 -55235,
 674958620,
 67111,
 -55234,
 675023986,
 67110,
 -55233,
 675089366,
 67109,
 -55232,
 675154345,
 67108,
 -1,
 675219737,
 67107,
 675424329,
 674762164,
 -1,
 -55229,
 675352281,
 67136,
 -55228,
 675417690,
 67135,
 -55227,
 675483060,
 67134,
 -55226,
 675548444,
 67133,
 -55225,
 675613654,
 67132,
 -55224,
 675679005,
 67131,
 -1,
 675744025,
 67130,
 675948624,
 675352154,
 -1,
 -55221,
 675876276,
 67142,
 -55220,
 675941660,
 67141,
 -55219,
 676007026,
 67140,
 -55218,
 676072005,
 67139,
 -55217,
 676137385,
 67138,
 -1,
 676202777,
 67137,
 676407383,
 675876124,
 -1,
 -55214,
 676335321,
 67129,
 -55213,
 676400564,
 67128,
 -55212,
 676465948,
 67127,
 -55211,
 676531314,
 67126,
 -55210,
 676596137,
 67125,
 -1,
 676661529,
 67124,
 676866142,
 676334365,
 -1,
 -55207,
 676794073,
 67106,
 -55206,
 676859482,
 67105,
 -55205,
 676924852,
 67104,
 -55204,
 676989910,
 67103,
 -55203,
 677054889,
 67102,
 -1,
 677120281,
 67101,
 677380095,
 676792745,
 -1,
 -55200,
 677252532,
 67085,
 -55199,
 677317916,
 67084,
 -55198,
 677382941,
 67083,
 -55197,
 677448105,
 67082,
 -1,
 677513497,
 67081,
 677773311,
 672401833,
 -1,
 677783657,
 677644869,
 -1,
 -55193,
 677710621,
 67148,
 -55192,
 677775941,
 67147,
 -1,
 677841177,
 67145,
 678045804,
 677711450,
 -1,
 -55189,
 677973594,
 67155,
 -1,
 678037785,
 67154,
 678242415,
 677972931,
 -1,
 -55186,
 678172864,
 67150,
 -1,
 678236004,
 67149,
 -55184,
 678170453,
 67156,
 -55183,
 678366786,
 67153,
 -55182,
 678432177,
 67152,
 -1,
 678496834,
 67144,
 678701262,
 672337010,
 -1,
 678766719,
 678628954,
 -1,
 -55178,
 678694617,
 67324,
 -55177,
 678760026,
 67323,
 -55176,
 678825396,
 67322,
 -55175,
 678890780,
 67321,
 -55174,
 678956146,
 67320,
 -55173,
 679021526,
 67319,
 -55172,
 679086877,
 67318,
 -55171,
 679152197,
 67317,
 -55170,
 679217577,
 67316,
 -1,
 679282969,
 67315,
 679487626,
 678694324,
 -1,
 -55167,
 679415513,
 67314,
 -55166,
 679480922,
 67313,
 -55165,
 679546292,
 67312,
 -55164,
 679611676,
 67311,
 -55163,
 679677042,
 67310,
 -55162,
 679742422,
 67309,
 -55161,
 679807773,
 67308,
 -55160,
 679873093,
 67307,
 -55159,
 679938473,
 67306,
 -1,
 680003865,
 67305,
 680208532,
 679414898,
 -1,
 -55156,
 680136409,
 67298,
 -55155,
 680201652,
 67297,
 -55154,
 680267036,
 67296,
 -55153,
 680332402,
 67295,
 -55152,
 680397782,
 67294,
 -55151,
 680463133,
 67293,
 -55150,
 680528453,
 67292,
 -55149,
 680593833,
 67291,
 -1,
 680659225,
 67290,
 680863902,
 680135453,
 -1,
 -55146,
 680791769,
 67282,
 -55145,
 680857178,
 67281,
 -55144,
 680922548,
 67280,
 -55143,
 680987932,
 67279,
 -55142,
 681053298,
 67278,
 -55141,
 681118678,
 67277,
 -55140,
 681183813,
 67276,
 -55139,
 681249193,
 67275,
 -1,
 681314585,
 67274,
 681519272,
 680790597,
 -1,
 -55136,
 681447129,
 67273,
 -55135,
 681512538,
 67272,
 -55134,
 681577908,
 67271,
 -55133,
 681643292,
 67270,
 -55132,
 681708658,
 67269,
 -55131,
 681774038,
 67268,
 -55130,
 681839389,
 67267,
 -55129,
 681904553,
 67266,
 -1,
 681969945,
 67265,
 682174641,
 681445657,
 -1,
 -55126,
 682102489,
 67258,
 -55125,
 682167898,
 67257,
 -55124,
 682233116,
 67256,
 -55123,
 682298482,
 67255,
 -55122,
 682363862,
 67254,
 -55121,
 682429213,
 67253,
 -55120,
 682494533,
 67252,
 -1,
 682559913,
 67251,
 682764473,
 682101718,
 -1,
 -55117,
 682692313,
 67289,
 -55116,
 682757722,
 67288,
 -55115,
 682823092,
 67287,
 -55114,
 682888306,
 67286,
 -55113,
 682953285,
 67285,
 -55112,
 683018665,
 67284,
 -1,
 683084057,
 67283,
 683288768,
 682692313,
 -1,
 -55109,
 683216474,
 67330,
 -55108,
 683281692,
 67329,
 -55107,
 683347058,
 67328,
 -55106,
 683412438,
 67327,
 -55105,
 683477573,
 67326,
 -1,
 683542953,
 67325,
 683747527,
 683216156,
 -1,
 -55102,
 683675353,
 67304,
 -55101,
 683740762,
 67303,
 -55100,
 683805980,
 67302,
 -55099,
 683871346,
 67301,
 -55098,
 683936726,
 67300,
 -1,
 684002077,
 67299,
 684261375,
 683674025,
 -1,
 -55095,
 684133660,
 67264,
 -55094,
 684199026,
 67263,
 -55093,
 684264221,
 67262,
 -55092,
 684329541,
 67261,
 -55091,
 684394921,
 67260,
 -1,
 684460313,
 67259,
 684665124,
 678628125,
 -1,
 684730589,
 684591529,
 -1,
 684796116,
 684657437,
 -1,
 -55086,
 684727814,
 67173,
 -55085,
 684792000,
 67172,
 -1,
 684855140,
 67171,
 -55083,
 684723929,
 67179,
 -55082,
 684985946,
 67178,
 -55081,
 685051316,
 67177,
 -55080,
 685116700,
 67176,
 -55079,
 685182066,
 67175,
 -55078,
 685247446,
 67174,
 -55077,
 685312581,
 67170,
 -55076,
 685377961,
 67169,
 -1,
 685443353,
 67168,
 685648106,
 684656921,
 -1,
 685713634,
 685575897,
 -1,
 -55072,
 685645318,
 67167,
 -55071,
 685709504,
 67166,
 -1,
 685772644,
 67165,
 -55069,
 685641306,
 67164,
 -55068,
 685903284,
 67163,
 -55067,
 685968668,
 67162,
 -55066,
 686034034,
 67161,
 -55065,
 686099414,
 67160,
 -55064,
 686164765,
 67159,
 -55063,
 686230085,
 67158,
 -1,
 686295465,
 67157,
 686500085,
 685575452,
 -1,
 -55060,
 686427865,
 67229,
 -55059,
 686493274,
 67228,
 -55058,
 686558644,
 67227,
 -55057,
 686624028,
 67226,
 -55056,
 686689394,
 67225,
 -55055,
 686754774,
 67224,
 -55054,
 686820125,
 67223,
 -55053,
 686885445,
 67222,
 -55052,
 686950825,
 67221,
 -1,
 687016217,
 67220,
 687220992,
 686427250,
 -1,
 -55049,
 687148761,
 67219,
 -55048,
 687214170,
 67218,
 -55047,
 687279540,
 67217,
 -55046,
 687344924,
 67216,
 -55045,
 687410290,
 67215,
 -55044,
 687475670,
 67214,
 -55043,
 687541021,
 67213,
 -55042,
 687606341,
 67212,
 -55041,
 687671721,
 67211,
 -1,
 687737113,
 67210,
 687941899,
 687147990,
 -1,
 -55038,
 687869657,
 67209,
 -55037,
 687935066,
 67208,
 -55036,
 688000436,
 67207,
 -55035,
 688065820,
 67206,
 -55034,
 688131186,
 67205,
 -55033,
 688196566,
 67204,
 -55032,
 688261917,
 67203,
 -55031,
 688327237,
 67202,
 -55030,
 688392617,
 67201,
 -1,
 688458009,
 67200,
 688662806,
 687868701,
 -1,
 -55027,
 688590553,
 67199,
 -55026,
 688655962,
 67198,
 -55025,
 688721332,
 67197,
 -55024,
 688786716,
 67196,
 -55023,
 688852082,
 67195,
 -55022,
 688917462,
 67194,
 -55021,
 688982813,
 67193,
 -55020,
 689048133,
 67192,
 -55019,
 689113513,
 67191,
 -1,
 689178905,
 67190,
 689383713,
 688589381,
 -1,
 -55016,
 689311449,
 67189,
 -55015,
 689376858,
 67188,
 -55014,
 689442228,
 67187,
 -55013,
 689507612,
 67186,
 -55012,
 689572978,
 67185,
 -55011,
 689638358,
 67184,
 -55010,
 689703709,
 67183,
 -55009,
 689769029,
 67182,
 -55008,
 689834409,
 67181,
 -1,
 689899801,
 67180,
 690159615,
 689311156,
 -1,
 -55005,
 690031017,
 67231,
 -1,
 690096409,
 67230,
 690301280,
 684592412,
 -1,
 690366768,
 690227625,
 -1,
 -55001,
 690294489,
 67348,
 -55000,
 690359898,
 67347,
 -54999,
 690425268,
 67346,
 -54998,
 690490652,
 67345,
 -54997,
 690556018,
 67344,
 -54996,
 690621398,
 67343,
 -54995,
 690686749,
 67342,
 -54994,
 690752069,
 67341,
 -54993,
 690817449,
 67340,
 -1,
 690882841,
 67339,
 691087674,
 690293874,
 -1,
 -54990,
 691015385,
 67377,
 -54989,
 691080794,
 67376,
 -54988,
 691146164,
 67375,
 -54987,
 691211548,
 67374,
 -54986,
 691276914,
 67373,
 -54985,
 691342294,
 67372,
 -54984,
 691407645,
 67371,
 -54983,
 691472965,
 67370,
 -1,
 691538345,
 67369,
 691743044,
 691014213,
 -1,
 -54980,
 691670745,
 67357,
 -54979,
 691736154,
 67356,
 -54978,
 691801524,
 67355,
 -54977,
 691866908,
 67354,
 -54976,
 691932118,
 67353,
 -54975,
 691997469,
 67352,
 -54974,
 692062789,
 67351,
 -54973,
 692128169,
 67350,
 -1,
 692193561,
 67349,
 692398413,
 691669974,
 -1,
 -54970,
 692326105,
 67368,
 -54969,
 692391514,
 67367,
 -54968,
 692456732,
 67366,
 -54967,
 692522098,
 67365,
 -54966,
 692587478,
 67364,
 -54965,
 692652829,
 67363,
 -54964,
 692718149,
 67362,
 -1,
 692783385,
 67361,
 692988246,
 692324633,
 -1,
 -54961,
 692915929,
 67338,
 -54960,
 692981338,
 67337,
 -54959,
 693046556,
 67336,
 -54958,
 693111766,
 67335,
 -54957,
 693177117,
 67334,
 -54956,
 693242437,
 67333,
 -54955,
 693307817,
 67332,
 -1,
 693373209,
 67331,
 693578076,
 692915484,
 -1,
 -54952,
 693504982,
 67382,
 -54951,
 693570333,
 67381,
 -54950,
 693635653,
 67380,
 -54949,
 693701033,
 67379,
 -1,
 693766425,
 67378,
 694026239,
 693504797,
 -1,
 -54946,
 693898842,
 67360,
 -54945,
 693964212,
 67359,
 -1,
 694029270,
 67358,
 694233467,
 690228660,
 -1,
 694298993,
 694159641,
 -1,
 694364521,
 694226649,
 -1,
 694430056,
 694290528,
 -1,
 -54939,
 694357333,
 67404,
 -54938,
 694422526,
 67403,
 -54937,
 694487913,
 67402,
 -1,
 694553207,
 67401,
 -1,
 694354552,
 67400,
 -54934,
 694292109,
 67399,
 -54933,
 694750691,
 67398,
 -54932,
 694816053,
 67397,
 -54931,
 694881406,
 67396,
 -54930,
 694946786,
 67395,
 -54929,
 695012133,
 67394,
 -54928,
 695077450,
 67393,
 -1,
 695142827,
 67392,
 695347577,
 694225321,
 -1,
 -54925,
 695274944,
 67411,
 -54924,
 695340153,
 67410,
 -54923,
 695405532,
 67409,
 -54922,
 695470993,
 67408,
 -54921,
 695536376,
 67407,
 -54920,
 695601697,
 67406,
 -1,
 695667080,
 67405,
 -54918,
 695274442,
 67413,
 -1,
 695798545,
 67412,
 696002961,
 694160342,
 -1,
 696068487,
 695929113,
 -1,
 -54914,
 695996236,
 67241,
 -54913,
 696061645,
 67240,
 -54912,
 696127033,
 67239,
 -54911,
 696192424,
 67238,
 -54910,
 696257802,
 67237,
 -54909,
 696323167,
 67236,
 -54908,
 696388538,
 67235,
 -54907,
 696453889,
 67234,
 -54906,
 696519225,
 67233,
 -1,
 696584593,
 67232,
 696844287,
 695994793,
 -1,
 -54903,
 696717005,
 67250,
 -54902,
 696782393,
 67249,
 -54901,
 696847784,
 67248,
 -54900,
 696913162,
 67247,
 -54899,
 696978527,
 67246,
 -54898,
 697043898,
 67245,
 -54897,
 697109249,
 67244,
 -54896,
 697174585,
 67243,
 -1,
 697239953,
 67242,
 697444762,
 695930579,
 -1,
 -54893,
 697372084,
 67431,
 -54892,
 697437468,
 67430,
 -54891,
 697502834,
 67429,
 -54890,
 697568214,
 67428,
 -54889,
 697633565,
 67427,
 -54888,
 697698885,
 67426,
 -54887,
 697764265,
 67425,
 -1,
 697829657,
 67424,
 698034590,
 697371049,
 -1,
 -54884,
 697961414,
 67151,
 -54883,
 698026759,
 67146,
 -1,
 698091927,
 67143,
 -1,
 697960862,
 67099,
 698417151,
 672268288,
 -1,
 698427810,
 698320644,
 983068,
 -1,
 698352811,
 983142,
 -1,
 698365257,
 983062,
 698679295,
 672222595,
 -1,
 -54875,
 698560011,
 128391,
 -1,
 698615042,
 128279,
 698821054,
 672151910,
 -1,
 698886589,
 698761734,
 -1,
 698952123,
 698810368,
 -1,
 699017648,
 698889399,
 -1,
 699083181,
 698968859,
 -1,
 -54868,
 699040897,
 128964,
 -1,
 699082312,
 11212,
 699334655,
 699026323,
 -1,
 -54865,
 699237277,
 128943,
 -1,
 699297831,
 128969,
 699476403,
 698975843,
 -1,
 -54862,
 699439169,
 128978,
 -1,
 699482550,
 128960,
 699673014,
 699432164,
 -1,
 -54859,
 699616315,
 128949,
 -1,
 699667261,
 128937,
 -54857,
 699636027,
 128910,
 -54856,
 699823186,
 128648,
 -54855,
 699874334,
 128930,
 -54854,
 699936637,
 128955,
 -1,
 699998328,
 128504,
 700252159,
 698900878,
 128498,
 -1,
 700121346,
 128497,
 -1,
 698816530,
 128626,
 700393920,
 698773894,
 128482,
 -1,
 700352959,
 128132,
 700524995,
 700340947,
 -1,
 -54846,
 700484460,
 6430,
 -1,
 700529808,
 6429,
 -54844,
 700489684,
 129422,
 -1,
 700671583,
 129409,
 700853024,
 672075620,
 -1,
 700918494,
 700811827,
 -1,
 700983932,
 700873956,
 -1,
 701049459,
 700930576,
 -1,
 701114842,
 701009439,
 -1,
 701180376,
 701038592,
 -1,
 701245911,
 701143465,
 -1,
 701311440,
 701192607,
 -1,
 -54834,
 701270512,
 983623,
 -54833,
 701316120,
 983589,
 -1,
 701370555,
 983621,
 701573587,
 701267172,
 -1,
 -54830,
 701533342,
 42937,
 -1,
 701579570,
 43854,
 701770198,
 701523207,
 -1,
 -54827,
 701729264,
 983619,
 -1,
 701763771,
 983617,
 -1,
 701715178,
 43858,
 -1,
 701176174,
 43855,
 -54823,
 701129707,
 43875,
 -1,
 702038666,
 43856,
 702228971,
 701050027,
 -1,
 702294506,
 702154193,
 -1,
 702360032,
 702256417,
 983567,
 702480383,
 702283807,
 -1,
 -54817,
 702364696,
 983569,
 -1,
 702419131,
 983571,
 702622179,
 702309639,
 -1,
 -54814,
 702581232,
 983597,
 -1,
 702615739,
 983595,
 702818790,
 702556580,
 -1,
 -54811,
 702777840,
 983601,
 -1,
 702812347,
 983599,
 703015401,
 702751176,
 -1,
 -54808,
 702962064,
 983573,
 -1,
 703012633,
 983575,
 -1,
 702953269,
 43828,
 -1,
 702243009,
 43836,
 703343097,
 702184676,
 -1,
 703408628,
 703274502,
 -1,
 703474161,
 703363699,
 -1,
 703539696,
 703427497,
 43851,
 -1,
 703465416,
 43852,
 -1,
 703478136,
 43830,
 703791103,
 703414897,
 -1,
 -54797,
 703675416,
 983629,
 -1,
 703729851,
 983630,
 703932919,
 703333841,
 -1,
 -54794,
 703894817,
 983587,
 -1,
 703947835,
 42921,
 -54792,
 703892086,
 43845,
 -1,
 704057964,
 43872,
 704260615,
 703283850,
 -1,
 704326147,
 704185809,
 -1,
 704391679,
 704260516,
 -1,
 -54787,
 704350704,
 983603,
 -54786,
 704396312,
 983602,
 -1,
 704450747,
 983578,
 704653826,
 704341267,
 -1,
 -54783,
 704612848,
 983607,
 -1,
 704647355,
 983605,
 -1,
 704600491,
 983577,
 704915974,
 704275408,
 -1,
 -54779,
 704865463,
 43840,
 -1,
 704910039,
 43876,
 -1,
 704866818,
 43873,
 705178132,
 704218723,
 -1,
 705243667,
 705139385,
 -1,
 705309199,
 705192939,
 -1,
 705374733,
 705244413,
 -1,
 -54772,
 705332554,
 43841,
 -1,
 705380627,
 43842,
 705626111,
 705299331,
 43843,
 -1,
 705497073,
 43844,
 705702418,
 705270785,
 -1,
 -54767,
 705641496,
 983627,
 -1,
 705695931,
 983628,
 -1,
 705663018,
 43857,
 -1,
 705199337,
 43879,
 706030112,
 705127403,
 -1,
 706095643,
 705982107,
 -1,
 706161178,
 706020817,
 -1,
 -54760,
 706118986,
 43839,
 -54759,
 706165784,
 983625,
 -1,
 706220219,
 983626,
 -1,
 706096299,
 43874,
 706488863,
 706021393,
 983581,
 706609151,
 706412575,
 -1,
 -54754,
 706493464,
 983583,
 -1,
 706547899,
 983585,
 -1,
 706435997,
 42935,
 706816556,
 705960128,
 -1,
 706882085,
 706760808,
 -1,
 706947620,
 706831339,
 43837,
 -1,
 706873329,
 43838,
 -1,
 706882731,
 43826,
 707144234,
 706809700,
 -1,
 707209769,
 707099709,
 -1,
 -54744,
 707144875,
 43827,
 -1,
 707203799,
 43824,
 -1,
 707165871,
 43853,
 -54741,
 707080972,
 42933,
 -1,
 707397342,
 42903,
 707602996,
 706760652,
 -1,
 707668531,
 707528145,
 -1,
 -54737,
 707627504,
 983611,
 -54736,
 707688225,
 42894,
 -54735,
 707746890,
 43833,
 -54734,
 707807573,
 43831,
 -1,
 707865215,
 43832,
 -1,
 707604698,
 43829,
 708127294,
 707530596,
 -1,
 708192828,
 708050944,
 -1,
 708258363,
 708155817,
 -1,
 708323898,
 708207879,
 -1,
 -54727,
 708282864,
 983593,
 -1,
 708317371,
 983591,
 -1,
 708270507,
 983565,
 -1,
 708212581,
 43825,
 -54723,
 708141308,
 42947,
 -1,
 708586757,
 983624,
 708782661,
 708065638,
 -1,
 708848195,
 708728763,
 -1,
 -54719,
 708808223,
 42943,
 -54718,
 708854410,
 42941,
 -1,
 708906852,
 42939,
 -54716,
 708787363,
 983199,
 -1,
 709035876,
 42913,
 709241421,
 708713990,
 -1,
 709306954,
 709181350,
 43859,
 709427199,
 709232473,
 -1,
 -54711,
 709326968,
 43860,
 -1,
 709382952,
 43861,
 709623807,
 709232081,
 -1,
 -54708,
 709520699,
 42900,
 -1,
 709564778,
 42899,
 709765715,
 709205065,
 -1,
 709831250,
 709714101,
 43863,
 709951487,
 709754880,
 -1,
 -54703,
 709859907,
 43865,
 -1,
 709891074,
 43864,
 -1,
 709793569,
 43862,
 710158937,
 709718984,
 -1,
 710224472,
 710082560,
 -1,
 -54698,
 710183408,
 983615,
 -54697,
 710239291,
 42919,
 -1,
 710288755,
 43849,
 -1,
 710175607,
 43847,
 710552159,
 710106751,
 -1,
 710617694,
 710477265,
 -1,
 -54692,
 710566971,
 42917,
 -54691,
 710617179,
 42897,
 -1,
 710681971,
 43835,
 -1,
 710556044,
 983579,
 710945379,
 710514327,
 -1,
 -54687,
 710905802,
 42911,
 -54686,
 710960311,
 42909,
 -1,
 711004400,
 42907,
 711207528,
 710884501,
 -1,
 711273063,
 711157805,
 -1,
 -54682,
 711212056,
 983631,
 -1,
 711266491,
 983632,
 -1,
 711198611,
 42901,
 711535212,
 711140962,
 -1,
 711600747,
 711486068,
 43848,
 -1,
 711525935,
 43850,
 -1,
 711565103,
 43878,
 711797359,
 711481688,
 -1,
 -54674,
 711756272,
 983613,
 -1,
 711796083,
 43834,
 -54672,
 711761199,
 43866,
 -54671,
 711937467,
 42915,
 -54670,
 712002751,
 983609,
 -1,
 712062157,
 42905,
 712310783,
 701009775,
 -1,
 -54667,
 712214115,
 8348,
 -54666,
 712277220,
 8347,
 -54665,
 712338616,
 8346,
 -54664,
 712400511,
 8345,
 -54663,
 712464675,
 8344,
 -54662,
 712527820,
 8343,
 -54661,
 712592771,
 8342,
 -1,
 712653973,
 8341,
 712846039,
 700915397,
 -1,
 712911499,
 712781053,
 -1,
 712977026,
 712873249,
 983566,
 713097215,
 712900639,
 -1,
 -54655,
 712981528,
 983568,
 -1,
 713035963,
 983570,
 713239173,
 712926471,
 -1,
 -54652,
 713198064,
 983596,
 -1,
 713232571,
 983594,
 713435784,
 713173412,
 -1,
 -54649,
 713394672,
 983600,
 -1,
 713429179,
 983598,
 713687039,
 713368008,
 -1,
 -54646,
 713578896,
 983572,
 -1,
 713629465,
 983574,
 713829012,
 712871513,
 -1,
 713894544,
 713775519,
 -1,
 -54642,
 713853424,
 983622,
 -54641,
 713899032,
 983588,
 -1,
 713953467,
 983620,
 714156691,
 713843975,
 -1,
 -54638,
 714115568,
 983618,
 -1,
 714150075,
 983616,
 -1,
 714114378,
 42936,
 714418843,
 713784548,
 -1,
 714484377,
 714343889,
 -1,
 -54633,
 714446113,
 983586,
 -54632,
 714499131,
 42920,
 -1,
 714555575,
 42949,
 -54630,
 714430977,
 42926,
 -1,
 714679568,
 42924,
 714877602,
 714357094,
 -1,
 714943136,
 714823611,
 -1,
 -54626,
 714903071,
 42942,
 -54625,
 714949258,
 42940,
 -1,
 715001700,
 42938,
 -54623,
 714882211,
 983198,
 -1,
 715130724,
 42912,
 715336360,
 714826731,
 -1,
 715401895,
 715261969,
 983580,
 715522047,
 715325471,
 -1,
 -54618,
 715406360,
 983582,
 -1,
 715460795,
 983584,
 -1,
 715348893,
 42934,
 715729583,
 715263844,
 -1,
 715795118,
 715654609,
 -1,
 715860653,
 715744519,
 -1,
 -54612,
 715819504,
 983592,
 -1,
 715854011,
 983590,
 -1,
 715807147,
 983564,
 -1,
 715743484,
 42946,
 716188339,
 715691671,
 -1,
 -54607,
 716148682,
 42910,
 -54606,
 716203191,
 42908,
 -1,
 716247280,
 42906,
 716450487,
 716147986,
 -1,
 -54603,
 716408419,
 42929,
 -54602,
 716459395,
 42928,
 -1,
 716520597,
 42893,
 716712636,
 716403625,
 -1,
 716778171,
 716637649,
 -1,
 -54598,
 716737008,
 983614,
 -1,
 716792891,
 42918,
 -1,
 716715028,
 42923,
 717040321,
 716653320,
 -1,
 717105856,
 716989703,
 -1,
 -54593,
 717064688,
 983606,
 -1,
 717099195,
 983604,
 -1,
 717052331,
 983576,
 717368006,
 716971526,
 -1,
 717433541,
 717293009,
 -1,
 -54588,
 717385019,
 42948,
 -1,
 717429098,
 42898,
 -1,
 717373350,
 42931,
 717695689,
 717315745,
 -1,
 -54584,
 717644859,
 42916,
 -1,
 717695067,
 42896,
 717892300,
 717639658,
 -1,
 -54581,
 717851120,
 983610,
 -1,
 717888030,
 42925,
 718088911,
 717835447,
 -1,
 -54578,
 718047728,
 983608,
 -1,
 718087539,
 42930,
 718285522,
 718018752,
 -1,
 -54575,
 718222092,
 42932,
 -1,
 718276318,
 42902,
 -54573,
 718249805,
 42950,
 -54572,
 718428512,
 983612,
 -54571,
 718491067,
 42914,
 -54570,
 718552215,
 42922,
 -1,
 718615757,
 42904,
 718809821,
 712791281,
 -1,
 718875356,
 718756339,
 -1,
 -54566,
 718835018,
 43002,
 -54565,
 718894031,
 43846,
 -1,
 718959221,
 42927,
 -1,
 718817442,
 42895,
 -1,
 718746010,
 42999,
 719268605,
 700867565,
 -1,
 719334140,
 719213721,
 -1,
 719399665,
 719285576,
 -1,
 719465190,
 719332962,
 -1,
 719530725,
 719398498,
 -1,
 -54556,
 719469731,
 3730,
 -1,
 719523684,
 3729,
 -1,
 719469731,
 3736,
 719792873,
 719424702,
 -1,
 -54552,
 719731875,
 3728,
 -1,
 719785828,
 3727,
 719989484,
 719740543,
 -1,
 -54549,
 719953241,
 3726,
 -1,
 720002776,
 3731,
 -54547,
 719935182,
 3756,
 -54546,
 720129321,
 3724,
 -54545,
 720190179,
 3718,
 -54544,
 720248883,
 3721,
 -1,
 720312999,
 3744,
 720513780,
 719355397,
 -1,
 -54541,
 720469374,
 3753,
 -1,
 720518307,
 3752,
 720710391,
 720457426,
 -1,
 -54538,
 720659425,
 3807,
 -1,
 720714695,
 3806,
 720907002,
 720648020,
 -1,
 -54535,
 720856655,
 983204,
 -1,
 720902296,
 983205,
 -54533,
 720862057,
 983206,
 -1,
 721049384,
 983207,
 -1,
 719290723,
 3770,
 721300248,
 719221673,
 -1,
 721365783,
 721238605,
 -1,
 721431303,
 721295552,
 -1,
 721496836,
 721377539,
 -1,
 -54526,
 721454001,
 128998,
 -54525,
 721496287,
 128311,
 -1,
 721559865,
 128309,
 721813503,
 721452074,
 -1,
 -54522,
 721716145,
 129003,
 -1,
 721756473,
 128996,
 721955595,
 721381665,
 -1,
 -54519,
 721912753,
 128999,
 -54518,
 721955039,
 128310,
 -1,
 722018617,
 128992,
 722217742,
 721919461,
 -1,
 -54515,
 722174897,
 129000,
 -1,
 722215225,
 128993,
 722414353,
 722171404,
 -1,
 -54512,
 722371505,
 128997,
 -1,
 722411833,
 128308,
 722610964,
 722367042,
 -1,
 -54509,
 722568113,
 129002,
 -1,
 722608441,
 128995,
 722862079,
 722549802,
 -1,
 -54506,
 722764721,
 129001,
 -1,
 722805049,
 128994,
 -1,
 721306300,
 8382,
 723069723,
 721257555,
 -1,
 -54502,
 723032511,
 127772,
 -1,
 723093044,
 127767,
 723266334,
 722999488,
 -1,
 -54499,
 723201982,
 127991,
 -1,
 723255664,
 129404,
 -54497,
 723201180,
 128030,
 -1,
 723395915,
 129357,
 723594105,
 700787883,
 -1,
 723659633,
 723532066,
 -1,
 723725142,
 723621761,
 -1,
 723790651,
 723682915,
 -1,
 723856185,
 723744673,
 -1,
 723921720,
 723781767,
 -1,
 723987254,
 723850853,
 11104,
 724107263,
 723910656,
 -1,
 724118324,
 724015529,
 -1,
 724183852,
 724064113,
 -1,
 -54485,
 724144673,
 11172,
 -1,
 724183954,
 11174,
 724380463,
 724117972,
 -1,
 -54482,
 724342085,
 983237,
 -1,
 724386067,
 11130,
 -54480,
 724342135,
 129072,
 -54479,
 724524835,
 129056,
 -54478,
 724589373,
 129060,
 -54477,
 724647673,
 129068,
 -1,
 724704390,
 129064,
 -54475,
 724077208,
 11120,
 -1,
 724855805,
 11136,
 -54473,
 723938596,
 11140,
 -1,
 724969349,
 11114,
 -1,
 723845294,
 129168,
 -54470,
 723819372,
 11244,
 -1,
 725182579,
 129186,
 725363523,
 723719806,
 -1,
 725429055,
 725320218,
 -1,
 -54466,
 725388252,
 129024,
 -1,
 725430744,
 129040,
 -54464,
 725377677,
 129176,
 -54463,
 725572440,
 129028,
 -54462,
 725635367,
 129032,
 -1,
 725692888,
 129044,
 725887815,
 725293248,
 -1,
 -54459,
 725838392,
 129184,
 -54458,
 725897272,
 11144,
 -1,
 725946471,
 129192,
 726149962,
 725843172,
 -1,
 -54455,
 726102768,
 129080,
 -1,
 726144192,
 129104,
 726346573,
 726102953,
 -1,
 -54452,
 726295678,
 128620,
 -1,
 726353144,
 129190,
 726543184,
 726286049,
 -1,
 -54449,
 726475609,
 129088,
 -1,
 726537829,
 129092,
 726739795,
 726480055,
 -1,
 -54446,
 726694798,
 129194,
 -1,
 726747216,
 129076,
 -54444,
 726702299,
 129172,
 -54443,
 726881163,
 129188,
 -1,
 726934361,
 129084,
 727133034,
 723648512,
 -1,
 727198562,
 727071907,
 -1,
 727264097,
 727143774,
 -1,
 727329632,
 727195961,
 129287,
 727449599,
 727254481,
 -1,
 727460702,
 727352931,
 -1,
 -54435,
 727423749,
 129285,
 -1,
 727466350,
 129284,
 -54433,
 727398411,
 129283,
 -1,
 727591313,
 129286,
 -1,
 727260123,
 11240,
 -1,
 727211898,
 128379,
 727919461,
 727152604,
 -1,
 -54428,
 727878690,
 11108,
 -1,
 727940596,
 129112,
 -54426,
 727882762,
 128398,
 -54425,
 728074453,
 128492,
 -54424,
 728138592,
 128488,
 -54423,
 728193288,
 128709,
 -1,
 728241247,
 128494,
 728498175,
 727058528,
 -1,
 728509294,
 728380654,
 -1,
 -54419,
 728446605,
 129307,
 -1,
 728503853,
 1422,
 -54417,
 728468152,
 8294,
 -54416,
 728658008,
 128269,
 -1,
 728710616,
 9958,
 728902516,
 723587395,
 -1,
 -54413,
 728866060,
 129388,
 -1,
 728891897,
 127811,
 -54411,
 728863863,
 127898,
 -54410,
 729049225,
 128006,
 -54409,
 729111960,
 127819,
 -54408,
 729168230,
 129461,
 -1,
 729229466,
 128210,
 729426836,
 723543019,
 -1,
 729492360,
 729388822,
 -1,
 729557892,
 729428465,
 -1,
 729623427,
 729502367,
 -1,
 729688960,
 729574584,
 -1,
 -54401,
 729624715,
 128393,
 -1,
 729682400,
 128396,
 -54399,
 729626607,
 128395,
 -54398,
 729818304,
 128397,
 -1,
 729880920,
 128394,
 -1,
 729577636,
 128318,
 730202111,
 729481216,
 -1,
 730213255,
 730091112,
 11847,
 -1,
 730138217,
 11848,
 -1,
 730144081,
 128261,
 730409869,
 729424358,
 128274,
 730475404,
 730351674,
 -1,
 -54389,
 730439662,
 983079,
 -1,
 730490541,
 983076,
 -1,
 730400556,
 128271,
 730737552,
 730371122,
 -1,
 -54385,
 730682514,
 128140,
 -1,
 730743110,
 127977,
 -54383,
 730697657,
 128557,
 -54382,
 730892873,
 129524,
 -54381,
 730945259,
 127853,
 -1,
 730996106,
 129438,
 731196313,
 729379753,
 -1,
 -54378,
 731145195,
 983225,
 -54377,
 731207971,
 983220,
 -54376,
 731267722,
 983230,
 -1,
 731327659,
 983222,
 -54374,
 731160141,
 129317,
 -54373,
 731484166,
 129523,
 -54372,
 731533482,
 129433,
 -1,
 731591863,
 983065,
 731786770,
 672021653,
 -1,
 731852109,
 731720875,
 -1,
 731917559,
 731800381,
 -1,
 731982795,
 731860355,
 -1,
 732048302,
 731910038,
 -1,
 732113829,
 731974057,
 110615,
 -54364,
 732039593,
 110625,
 -1,
 732104985,
 110624,
 -54362,
 732057219,
 110626,
 -54361,
 732237529,
 110623,
 -54360,
 732302938,
 110622,
 -54359,
 732368308,
 110621,
 -54358,
 732433692,
 110620,
 -54357,
 732499058,
 110619,
 -54356,
 732564438,
 110618,
 -54355,
 732629789,
 110617,
 -1,
 732695109,
 110616,
 732900279,
 731988752,
 -1,
 -54352,
 732827226,
 110634,
 -54351,
 732892596,
 110633,
 -54350,
 732957980,
 110632,
 -54349,
 733023346,
 110631,
 -54348,
 733088726,
 110630,
 -54347,
 733154077,
 110629,
 -54346,
 733219397,
 110628,
 -1,
 733284777,
 110627,
 733490111,
 732860018,
 -1,
 -54343,
 733416884,
 110641,
 -54342,
 733482268,
 110640,
 -54341,
 733547634,
 110639,
 -54340,
 733613014,
 110638,
 -54339,
 733678365,
 110637,
 -54338,
 733743685,
 110636,
 -1,
 733809065,
 110635,
 734014406,
 733424926,
 -1,
 -54335,
 733941020,
 110647,
 -54334,
 734006386,
 110646,
 -54333,
 734071766,
 110645,
 -54332,
 734137117,
 110644,
 -54331,
 734202437,
 110643,
 -1,
 734267817,
 110642,
 734527487,
 733963300,
 -1,
 -54328,
 734416600,
 110651,
 -54327,
 734464797,
 110650,
 -54326,
 734530117,
 110649,
 -1,
 734595497,
 110648,
 734800885,
 731921557,
 -1,
 734866392,
 734728086,
 -1,
 734931920,
 734792105,
 110750,
 -54321,
 734857641,
 110760,
 -1,
 734923033,
 110759,
 -54319,
 734858969,
 110758,
 -54318,
 735055450,
 110757,
 -54317,
 735120820,
 110756,
 -54316,
 735186204,
 110755,
 -54315,
 735251570,
 110754,
 -54314,
 735316950,
 110753,
 -54313,
 735382301,
 110752,
 -1,
 735447621,
 110751,
 735652833,
 734815268,
 -1,
 -54310,
 735579738,
 110785,
 -54309,
 735645108,
 110784,
 -54308,
 735710492,
 110783,
 -54307,
 735775858,
 110782,
 -54306,
 735841238,
 110781,
 -54305,
 735906589,
 110780,
 -54304,
 735971909,
 110779,
 -1,
 736037289,
 110778,
 736242665,
 735593232,
 -1,
 -54301,
 736169396,
 110767,
 -54300,
 736234780,
 110766,
 -54299,
 736300146,
 110765,
 -54298,
 736365526,
 110764,
 -54297,
 736430877,
 110763,
 -54296,
 736496197,
 110762,
 -1,
 736561577,
 110761,
 736766961,
 736177438,
 -1,
 -54293,
 736693684,
 110777,
 -54292,
 736759068,
 110776,
 -54291,
 736824434,
 110775,
 -54290,
 736889814,
 110774,
 -54289,
 736955165,
 110773,
 -54288,
 737020485,
 110772,
 -1,
 737085865,
 110771,
 737345535,
 736726642,
 -1,
 -54285,
 737217309,
 110770,
 -54284,
 737282629,
 110769,
 -1,
 737348009,
 110768,
 737553437,
 734756068,
 -1,
 737618943,
 737513074,
 -1,
 -54280,
 737545818,
 110673,
 -54279,
 737611188,
 110672,
 -54278,
 737676572,
 110671,
 -54277,
 737741938,
 110670,
 -54276,
 737807318,
 110669,
 -54275,
 737872669,
 110668,
 -54274,
 737937989,
 110667,
 -1,
 738003369,
 110666,
 738208776,
 737546134,
 -1,
 -54271,
 738135642,
 110659,
 -54270,
 738201012,
 110658,
 -54269,
 738266396,
 110657,
 -54268,
 738331762,
 110656,
 -54267,
 738397142,
 110655,
 -54266,
 738462493,
 110654,
 -54265,
 738527813,
 110653,
 -1,
 738593193,
 110652,
 738798608,
 738157604,
 -1,
 -54262,
 738725300,
 110685,
 -54261,
 738790684,
 110684,
 -54260,
 738856050,
 110683,
 -54259,
 738921430,
 110682,
 -54258,
 738986781,
 110681,
 -54257,
 739052101,
 110680,
 -1,
 739117481,
 110679,
 739322903,
 738738960,
 -1,
 -54254,
 739249436,
 110665,
 -54253,
 739314802,
 110664,
 -54252,
 739380182,
 110663,
 -54251,
 739445533,
 110662,
 -54250,
 739510853,
 110661,
 -1,
 739576233,
 110660,
 739835903,
 739257630,
 -1,
 -54247,
 739708018,
 110678,
 -54246,
 739773398,
 110677,
 -54245,
 739838749,
 110676,
 -54244,
 739904069,
 110675,
 -1,
 739969449,
 110674,
 740174918,
 737500799,
 -1,
 740240424,
 740102038,
 -1,
 -54240,
 740167385,
 110726,
 -54239,
 740232794,
 110725,
 -54238,
 740298164,
 110724,
 -54237,
 740363548,
 110723,
 -54236,
 740428914,
 110722,
 -54235,
 740494294,
 110721,
 -54234,
 740559645,
 110720,
 -54233,
 740624965,
 110719,
 -1,
 740690345,
 110718,
 740895793,
 740180752,
 -1,
 -54230,
 740853687,
 110734,
 -54229,
 740887988,
 110733,
 -54228,
 740953372,
 110732,
 -54227,
 741018738,
 110731,
 -54226,
 741084118,
 110730,
 -54225,
 741149469,
 110729,
 -54224,
 741214789,
 110728,
 -1,
 741280169,
 110727,
 741485625,
 740830494,
 -1,
 -54221,
 741429054,
 110744,
 -54220,
 741477660,
 110743,
 -54219,
 741543026,
 110742,
 -54218,
 741608406,
 110741,
 -54217,
 741673757,
 110740,
 -54216,
 741739077,
 110739,
 -1,
 741804457,
 110738,
 742009919,
 741434404,
 -1,
 -54213,
 741936242,
 110749,
 -54212,
 742001622,
 110748,
 -54211,
 742066973,
 110747,
 -54210,
 742132293,
 110746,
 -1,
 742197673,
 110745,
 742403139,
 741969522,
 -1,
 -54207,
 742329117,
 110737,
 -54206,
 742394437,
 110736,
 -1,
 742459817,
 110735,
 742719487,
 742328509,
 -1,
 -54203,
 742591045,
 110878,
 -1,
 742656425,
 110877,
 742861932,
 740132451,
 -1,
 742927441,
 742796574,
 -1,
 -54199,
 742854361,
 110710,
 -54198,
 742919770,
 110709,
 -54197,
 742985140,
 110708,
 -54196,
 743050524,
 110707,
 -54195,
 743115890,
 110706,
 -54194,
 743181270,
 110705,
 -54193,
 743246621,
 110704,
 -54192,
 743311941,
 110703,
 -1,
 743377321,
 110702,
 743582809,
 742876196,
 -1,
 -54189,
 743535613,
 110717,
 -54188,
 743574812,
 110716,
 -54187,
 743640178,
 110715,
 -54186,
 743705558,
 110714,
 -54185,
 743770909,
 110713,
 -54184,
 743836229,
 110712,
 -1,
 743901609,
 110711,
 744107105,
 743523088,
 -1,
 -54181,
 744033716,
 110696,
 -54180,
 744099100,
 110695,
 -54179,
 744164466,
 110694,
 -54178,
 744229846,
 110693,
 -54177,
 744295197,
 110692,
 -54176,
 744360517,
 110691,
 -1,
 744425897,
 110690,
 744631399,
 744066674,
 -1,
 -54173,
 744589973,
 110701,
 -54172,
 744623062,
 110700,
 -54171,
 744688413,
 110699,
 -54170,
 744753733,
 110698,
 -1,
 744819113,
 110697,
 745078783,
 744558486,
 -1,
 -54167,
 744950742,
 110689,
 -54166,
 745016093,
 110688,
 -54165,
 745081413,
 110687,
 -1,
 745146793,
 110686,
 745352333,
 742814633,
 -1,
 745417845,
 745292560,
 -1,
 -54161,
 745344436,
 110839,
 -54160,
 745409820,
 110838,
 -54159,
 745475186,
 110837,
 -54158,
 745540566,
 110836,
 -54157,
 745605917,
 110835,
 -54156,
 745671237,
 110834,
 -1,
 745736617,
 110833,
 745942140,
 745377394,
 -1,
 -54153,
 745868572,
 110845,
 -54152,
 745933938,
 110844,
 -54151,
 745999318,
 110843,
 -54150,
 746064669,
 110842,
 -54149,
 746129989,
 110841,
 -1,
 746195369,
 110840,
 746400899,
 745890852,
 -1,
 -54146,
 746327324,
 110855,
 -54145,
 746392690,
 110854,
 -54144,
 746458070,
 110853,
 -54143,
 746523421,
 110852,
 -54142,
 746588741,
 110851,
 -1,
 746654121,
 110850,
 746859656,
 746335518,
 -1,
 -54139,
 746785750,
 110849,
 -54138,
 746851101,
 110848,
 -54137,
 746916421,
 110847,
 -1,
 746981801,
 110846,
 747241471,
 746786710,
 -1,
 -54134,
 747113430,
 110832,
 -54133,
 747178781,
 110831,
 -54132,
 747244101,
 110830,
 -1,
 747309481,
 110829,
 747515054,
 745298211,
 -1,
 747580566,
 747455248,
 -1,
 -54128,
 747507124,
 110799,
 -54127,
 747572508,
 110798,
 -54126,
 747637874,
 110797,
 -54125,
 747703254,
 110796,
 -54124,
 747768605,
 110795,
 -54123,
 747833925,
 110794,
 -1,
 747899305,
 110793,
 748104862,
 747507606,
 -1,
 -54120,
 748031412,
 110792,
 -54119,
 748096796,
 110791,
 -54118,
 748162162,
 110790,
 -54117,
 748227542,
 110789,
 -54116,
 748292893,
 110788,
 -54115,
 748358213,
 110787,
 -1,
 748423593,
 110786,
 748629157,
 748053540,
 -1,
 -54112,
 748555548,
 110812,
 -54111,
 748620914,
 110811,
 -54110,
 748686294,
 110810,
 -54109,
 748751645,
 110809,
 -54108,
 748816965,
 110808,
 -1,
 748882345,
 110807,
 749087914,
 748588658,
 -1,
 -54105,
 749013974,
 110803,
 -54104,
 749079325,
 110802,
 -54103,
 749144645,
 110801,
 -1,
 749210025,
 110800,
 749469695,
 749022494,
 -1,
 -54100,
 749361517,
 110806,
 -54099,
 749406789,
 110805,
 -1,
 749472169,
 110804,
 749677768,
 747476758,
 -1,
 749743287,
 749626404,
 -1,
 -54095,
 749669812,
 110876,
 -54094,
 749735196,
 110875,
 -54093,
 749800562,
 110874,
 -54092,
 749865942,
 110873,
 -54091,
 749931293,
 110872,
 -54090,
 749996613,
 110871,
 -1,
 750061993,
 110870,
 750267581,
 749683472,
 -1,
 -54087,
 750193778,
 110865,
 -54086,
 750259158,
 110864,
 -54085,
 750324509,
 110863,
 -54084,
 750389829,
 110862,
 -1,
 750455209,
 110861,
 750660803,
 750194582,
 -1,
 -54081,
 750586994,
 110860,
 -54080,
 750652374,
 110859,
 -54079,
 750717725,
 110858,
 -54078,
 750783045,
 110857,
 -1,
 750848425,
 110856,
 751108095,
 750595358,
 -1,
 -54075,
 750980054,
 110869,
 -54074,
 751045405,
 110868,
 -54073,
 751110725,
 110867,
 -1,
 751176105,
 110866,
 751381724,
 749640939,
 -1,
 751447248,
 751330340,
 -1,
 -54069,
 751373596,
 110828,
 -54068,
 751438962,
 110827,
 -54067,
 751504342,
 110826,
 -54066,
 751569693,
 110825,
 -54065,
 751635013,
 110824,
 -1,
 751700393,
 110823,
 751906007,
 751374230,
 -1,
 -54062,
 751869682,
 110818,
 -54061,
 751897714,
 110817,
 -54060,
 751963094,
 110816,
 -54059,
 752028445,
 110815,
 -54058,
 752093765,
 110814,
 -1,
 752159145,
 110813,
 752418815,
 751865458,
 -1,
 -54055,
 752290774,
 110822,
 -54054,
 752356125,
 110821,
 -54053,
 752421445,
 110820,
 -1,
 752486825,
 110819,
 752692451,
 751316254,
 -1,
 -54050,
 752618780,
 110611,
 -54049,
 752684146,
 110610,
 -54048,
 752749526,
 110609,
 -54047,
 752814877,
 110608,
 -54046,
 752880197,
 110607,
 -1,
 752945577,
 983266,
 753151209,
 752651890,
 -1,
 -54043,
 753077362,
 110606,
 -54042,
 753142742,
 110605,
 -54041,
 753208093,
 110604,
 -54040,
 753273413,
 110603,
 -1,
 753338793,
 110602,
 753544430,
 753091344,
 -1,
 -54037,
 753470422,
 110601,
 -54036,
 753535773,
 110600,
 -54035,
 753601093,
 110599,
 -1,
 753666473,
 110598,
 753872115,
 753471382,
 -1,
 -54032,
 753834754,
 110597,
 -54031,
 753863453,
 110596,
 -54030,
 753928773,
 110595,
 -1,
 753994153,
 110594,
 754253823,
 753820708,
 -1,
 -54027,
 754125597,
 110614,
 -54026,
 754190917,
 110613,
 -1,
 754256297,
 110612,
 754462023,
 731844452,
 -1,
 754527550,
 754423556,
 -1,
 754593032,
 754482404,
 -1,
 754658561,
 754543525,
 -1,
 754724094,
 754620554,
 -1,
 -54019,
 754685477,
 128605,
 -1,
 754720147,
 128613,
 754974719,
 754658683,
 -1,
 -54016,
 754882085,
 128607,
 -1,
 754916755,
 128615,
 755117316,
 754601008,
 -1,
 -54013,
 755073949,
 128952,
 -1,
 755134503,
 128972,
 755313927,
 755044196,
 -1,
 -54010,
 755262166,
 128635,
 -1,
 755325161,
 128940,
 -1,
 755246360,
 128625,
 755576081,
 754536396,
 -1,
 755641612,
 755526726,
 -1,
 -54005,
 755597728,
 10079,
 -1,
 755640868,
 10080,
 755838223,
 755576604,
 -1,
 -54002,
 755781899,
 129052,
 -1,
 755839448,
 129048,
 -54000,
 755778667,
 128627,
 -1,
 755963854,
 128327,
 756165913,
 755502948,
 -1,
 756231448,
 756120665,
 -1,
 756296983,
 756180653,
 129180,
 756416511,
 756219904,
 -1,
 -53994,
 756320441,
 129183,
 -1,
 756366635,
 129182,
 -1,
 756256248,
 129181,
 -1,
 756178412,
 128628,
 756690208,
 756114008,
 -1,
 756755741,
 756652170,
 -1,
 -53988,
 756717093,
 128604,
 -1,
 756751763,
 128612,
 757006335,
 756690299,
 -1,
 -53985,
 756913701,
 128606,
 -1,
 756948371,
 128614,
 757148967,
 756622946,
 -1,
 757214502,
 757097451,
 -1,
 757280037,
 757177070,
 -1,
 -53980,
 757223691,
 129055,
 -1,
 757281240,
 129051,
 -1,
 757225170,
 128178,
 -1,
 757156889,
 10135,
 757607724,
 757084004,
 -1,
 757673259,
 757559326,
 -1,
 -53974,
 757624658,
 128977,
 -1,
 757668827,
 128975,
 -1,
 757629853,
 128958,
 757935407,
 757569735,
 -1,
 -53970,
 757892017,
 128913,
 -1,
 757932345,
 128903,
 758132018,
 757895757,
 -1,
 -53967,
 758075659,
 129053,
 -1,
 758133208,
 129049,
 758328629,
 758091126,
 -1,
 -53964,
 758280018,
 128980,
 -1,
 758324187,
 128979,
 758525240,
 758282600,
 -1,
 -53961,
 758468875,
 129054,
 -1,
 758526424,
 129050,
 758721851,
 758462103,
 -1,
 -53958,
 758678429,
 128946,
 -1,
 758738983,
 128970,
 -53956,
 758673413,
 10133,
 -53955,
 758865180,
 10134,
 -1,
 758925556,
 128633,
 759115078,
 754480041,
 -1,
 759180613,
 759072357,
 -1,
 759246148,
 759142825,
 -1,
 -53950,
 759204454,
 127892,
 -53949,
 759265193,
 128157,
 -1,
 759305829,
 128152,
 -1,
 759179245,
 128159,
 -1,
 759105733,
 128585,
 -1,
 759049237,
 127911,
 759704906,
 754405324,
 -1,
 -53943,
 759650467,
 11263,
 -1,
 759710655,
 128641,
 -53941,
 759657780,
 127807,
 -53940,
 759834771,
 129428,
 -1,
 759897407,
 1519,
 760098252,
 731778916,
 -1,
 760163743,
 760045183,
 -1,
 760229266,
 760103960,
 -1,
 760294773,
 760173721,
 -1,
 760360279,
 760237443,
 -1,
 760425813,
 760301706,
 -1,
 -53932,
 760388953,
 68889,
 -1,
 760452910,
 68887,
 -53930,
 760364195,
 68872,
 -1,
 760549220,
 68881,
 760753499,
 760307327,
 -1,
 -53927,
 760716633,
 68891,
 -53926,
 760756639,
 68890,
 -1,
 760811364,
 68885,
 761015646,
 760710755,
 -1,
 -53923,
 760973042,
 68868,
 -1,
 761007972,
 68867,
 761212257,
 760970468,
 -1,
 -53920,
 761150627,
 68880,
 -1,
 761204580,
 68879,
 761408868,
 761164713,
 -1,
 -53917,
 761361405,
 68877,
 -1,
 761401188,
 68876,
 761605479,
 761341538,
 -1,
 -53914,
 761538286,
 68875,
 -1,
 761597796,
 68874,
 -53912,
 761569121,
 68878,
 -53911,
 761765209,
 68888,
 -53910,
 761829166,
 68886,
 -53909,
 761893897,
 68892,
 -53908,
 761949426,
 68866,
 -53907,
 762009965,
 68884,
 -53906,
 762073118,
 68883,
 -53905,
 762137818,
 68869,
 -53904,
 762199203,
 68871,
 -53903,
 762263967,
 68882,
 -53902,
 762328283,
 68873,
 -53901,
 762388002,
 68870,
 -53900,
 762452177,
 68865,
 -1,
 762515300,
 68864,
 762719619,
 760228099,
 -1,
 762785145,
 762676835,
 -1,
 -53896,
 762747650,
 68914,
 -1,
 762790242,
 68915,
 762981756,
 762739940,
 -1,
 -53893,
 762924077,
 68918,
 -1,
 762983367,
 68919,
 763178367,
 762918071,
 -1,
 -53890,
 763128546,
 68916,
 -1,
 763186063,
 68917,
 -53888,
 763142126,
 68912,
 -53887,
 763324077,
 68913,
 -53886,
 763388223,
 68921,
 -1,
 763440990,
 68920,
 763637129,
 762681010,
 -1,
 -53883,
 763596319,
 68895,
 -53882,
 763651051,
 68897,
 -53881,
 763708042,
 68894,
 -53880,
 763767979,
 68896,
 -1,
 763826020,
 68893,
 764030351,
 763593035,
 -1,
 764095886,
 763987698,
 -1,
 -53876,
 764052481,
 68903,
 -53875,
 764108504,
 68902,
 -1,
 764165400,
 68901,
 -1,
 764034596,
 68900,
 764477439,
 763976279,
 -1,
 -53871,
 764378523,
 68898,
 -1,
 764436203,
 68899,
 764620185,
 760167509,
 -1,
 764685720,
 764583414,
 -1,
 764751255,
 764628355,
 -1,
 -53866,
 764693650,
 983209,
 -1,
 764755922,
 983212,
 -1,
 764707815,
 983210,
 -1,
 764642291,
 983211,
 765132799,
 764552802,
 -1,
 765144477,
 765008081,
 -1,
 -53860,
 765089470,
 129342,
 -1,
 765147494,
 128092,
 -53858,
 765100026,
 129309,
 -1,
 765265669,
 129310,
 765472195,
 760120931,
 -1,
 765537730,
 765424827,
 -1,
 765603259,
 765482137,
 -1,
 765668775,
 765557988,
 -1,
 765734310,
 765595492,
 -1,
 -53851,
 765680546,
 67822,
 -1,
 765733036,
 67825,
 -1,
 765673505,
 67828,
 765996458,
 765625955,
 -1,
 -53847,
 765932320,
 67816,
 -1,
 765991043,
 67829,
 766193068,
 765935199,
 67812,
 -1,
 766150735,
 67815,
 766324143,
 766119780,
 -1,
 -53842,
 766287591,
 67823,
 -1,
 766334089,
 67808,
 -53840,
 766287844,
 67814,
 -53839,
 766484213,
 67817,
 -53838,
 766547937,
 67813,
 -53837,
 766603946,
 67826,
 -53836,
 766668364,
 67824,
 -53835,
 766731199,
 67821,
 -53834,
 766794669,
 67820,
 -53833,
 766857391,
 67819,
 -53832,
 766922251,
 67818,
 -53831,
 766983018,
 67810,
 -53830,
 767043394,
 67811,
 -1,
 767105620,
 67809,
 767361023,
 765551482,
 -1,
 767372735,
 767264355,
 -1,
 -53826,
 767334499,
 67838,
 -1,
 767373392,
 67837,
 767569345,
 767321773,
 67835,
 -1,
 767492668,
 67839,
 -1,
 767506066,
 67836,
 -1,
 765468911,
 128035,
 767831496,
 765417763,
 -1,
 767897030,
 767777754,
 128296,
 -1,
 767819865,
 128736,
 -53817,
 767853751,
 128057,
 -1,
 767958457,
 127828,
 -53815,
 767784288,
 128436,
 -53814,
 768110878,
 128587,
 -53813,
 768166511,
 128135,
 -1,
 768223319,
 11233,
 768421361,
 760046571,
 -1,
 768486876,
 768373673,
 -1,
 768552408,
 768429228,
 -1,
 768617943,
 768509539,
 -1,
 768683478,
 768544736,
 -1,
 768749013,
 768643170,
 983059,
 768868351,
 768671744,
 -1,
 -53804,
 768776678,
 983140,
 -1,
 768835420,
 983137,
 -1,
 768672371,
 11134,
 -1,
 768635954,
 128677,
 -1,
 768547760,
 11203,
 769261567,
 768507494,
 128014,
 769327103,
 769130496,
 -1,
 -53797,
 769225755,
 127943,
 -1,
 769275102,
 128052,
 769469922,
 768445983,
 -1,
 769535457,
 769425001,
 -1,
 769600992,
 769465759,
 127968,
 -1,
 769555684,
 127960,
 -1,
 769563081,
 127969,
 -1,
 769488765,
 9203,
 769863143,
 769427043,
 -1,
 769928678,
 769785856,
 -1,
 -53787,
 769879757,
 127798,
 -1,
 769927523,
 127789,
 -1,
 769863614,
 127976,
 770190827,
 769806284,
 -1,
 770256362,
 770136116,
 128616,
 -1,
 770179659,
 128617,
 -1,
 770190507,
 128371,
 770452974,
 770138268,
 -1,
 -53779,
 770382305,
 128029,
 -1,
 770442300,
 127855,
 -53777,
 770409359,
 127973,
 -53776,
 770600120,
 983123,
 -1,
 770646278,
 128298,
 770846218,
 768361098,
 -1,
 770911742,
 770798655,
 -1,
 770977273,
 770841294,
 -1,
 -53771,
 770936351,
 983980,
 -53770,
 770991083,
 983982,
 -53769,
 771048074,
 983979,
 -53768,
 771108011,
 983981,
 -1,
 771166052,
 983978,
 771370493,
 770933424,
 -1,
 -53765,
 771318763,
 110930,
 -53764,
 771375754,
 110928,
 -1,
 771435691,
 110929,
 -1,
 771298726,
 110593,
 771698182,
 770849504,
 -1,
 771763715,
 771623008,
 -1,
 771829250,
 771720061,
 128644,
 -1,
 771753432,
 128645,
 -1,
 771768097,
 128096,
 772079615,
 771686400,
 -1,
 -53755,
 771974284,
 983122,
 -1,
 772021585,
 128262,
 -53753,
 771649802,
 129435,
 -53752,
 772169685,
 128725,
 -53751,
 772230893,
 129406,
 -1,
 772283192,
 127802,
 772484622,
 770805279,
 -1,
 -53748,
 772440117,
 128559,
 -53747,
 772497345,
 128175,
 -1,
 772553388,
 129303,
 772746769,
 772441699,
 983060,
 -53744,
 772701412,
 983138,
 -1,
 772754613,
 983141,
 -1,
 772709893,
 11226,
 773009531,
 731737272,
 -1,
 773074791,
 772935524,
 -1,
 773140173,
 773013066,
 -1,
 773205578,
 773070342,
 -1,
 773271087,
 773154787,
 -1,
 773336607,
 773217919,
 -1,
 773402139,
 773293667,
 -1,
 -53734,
 773357107,
 92957,
 -1,
 773406274,
 92971,
 -53732,
 773345693,
 92960,
 -53731,
 773541476,
 92962,
 -53730,
 773595241,
 92968,
 -1,
 773658665,
 92972,
 773860899,
 773274773,
 -1,
 -53727,
 773807926,
 92969,
 -53726,
 773869981,
 92965,
 -1,
 773920809,
 92959,
 774123046,
 773791238,
 -1,
 -53723,
 774061634,
 92967,
 -1,
 774117417,
 92975,
 -53721,
 774086037,
 92964,
 -53720,
 774282340,
 92974,
 -53719,
 774345768,
 92956,
 -53718,
 774403341,
 92961,
 -53717,
 774468253,
 92963,
 -53716,
 774533074,
 92970,
 -53715,
 774593181,
 92966,
 -53714,
 774656413,
 92958,
 -1,
 774707241,
 92973,
 774963199,
 773214398,
 -1,
 774975030,
 774866531,
 -1,
 775040565,
 774929636,
 -1,
 -53709,
 775002123,
 93069,
 -53708,
 775044880,
 93053,
 -1,
 775098336,
 93062,
 -1,
 774979748,
 93061,
 775368250,
 774917507,
 -1,
 -53704,
 775330478,
 93070,
 -53703,
 775383068,
 93058,
 -1,
 775437492,
 93064,
 775630397,
 775331051,
 -1,
 -53700,
 775564923,
 93054,
 -1,
 775623221,
 93068,
 775827008,
 775590903,
 -1,
 -53697,
 775789224,
 93071,
 -1,
 775819829,
 93066,
 776023619,
 775770060,
 -1,
 -53694,
 775965343,
 93055,
 -1,
 776017987,
 93056,
 776220230,
 775961763,
 -1,
 -53691,
 776182440,
 93059,
 -1,
 776231203,
 93065,
 -53689,
 776183013,
 93057,
 -53688,
 776367891,
 93063,
 -53687,
 776429124,
 93060,
 -1,
 776484101,
 93067,
 776679037,
 773161291,
 -1,
 776744534,
 776610100,
 -1,
 776810064,
 776701539,
 -1,
 776875599,
 776772833,
 93044,
 -1,
 776798562,
 93045,
 -1,
 776831811,
 92997,
 777072211,
 776740358,
 -1,
 -53678,
 777031394,
 93043,
 -1,
 777076525,
 92985,
 -53676,
 777023912,
 93046,
 -53675,
 777216712,
 93047,
 -1,
 777272546,
 93042,
 777465440,
 776707114,
 -1,
 777530974,
 777428203,
 -1,
 777596509,
 777465480,
 -1,
 -53670,
 777554780,
 92990,
 -53669,
 777615254,
 92989,
 -53668,
 777675626,
 92988,
 -1,
 777729280,
 92991,
 -1,
 777545756,
 93028,
 -53665,
 777470748,
 93034,
 -1,
 777918539,
 92996,
 778120810,
 777426605,
 -1,
 778186342,
 778077795,
 -1,
 778251877,
 778124437,
 -1,
 -53660,
 778200530,
 92983,
 -1,
 778257180,
 92986,
 -1,
 778207206,
 92984,
 -53657,
 778141340,
 92992,
 -53656,
 778461905,
 92994,
 -53655,
 778524927,
 93027,
 -1,
 778581326,
 92987,
 778776174,
 778077795,
 -1,
 -53652,
 778738810,
 93037,
 -53651,
 778780752,
 93030,
 -1,
 778836009,
 93039,
 779038323,
 778721571,
 -1,
 779103858,
 778972799,
 -1,
 -53647,
 779062450,
 93038,
 -1,
 779126202,
 92993,
 -1,
 779064112,
 93041,
 779366006,
 778985087,
 -1,
 -53643,
 779324657,
 93035,
 -1,
 779383462,
 93033,
 779562617,
 779304085,
 -1,
 -53640,
 779510640,
 93032,
 -1,
 779572640,
 93029,
 -53638,
 779526183,
 93031,
 -53637,
 779704240,
 93040,
 -53636,
 779764587,
 92995,
 -1,
 779819098,
 93036,
 780021416,
 776640185,
 -1,
 780086925,
 779947876,
 -1,
 780152450,
 780048150,
 -1,
 -53631,
 780112887,
 92943,
 -1,
 780146880,
 92942,
 780349061,
 780111391,
 -1,
 -53628,
 780309495,
 92933,
 -1,
 780343488,
 92932,
 780545672,
 780288650,
 -1,
 -53625,
 780506103,
 92939,
 -1,
 780540096,
 92938,
 780742283,
 780472164,
 -1,
 -53622,
 780702711,
 92955,
 -1,
 780736704,
 92954,
 -53620,
 780702711,
 92951,
 -1,
 780867776,
 92950,
 781069971,
 780045855,
 -1,
 781135505,
 780996452,
 -1,
 -53616,
 781095927,
 92945,
 -1,
 781129920,
 92944,
 -53614,
 781095927,
 92935,
 -1,
 781260992,
 92934,
 781463193,
 781018091,
 -1,
 781528727,
 781411307,
 -1,
 -53610,
 781489143,
 92941,
 -1,
 781523136,
 92940,
 -53608,
 781489143,
 92947,
 -1,
 781654208,
 92946,
 781856415,
 781402762,
 -1,
 781921949,
 781782884,
 -1,
 -53604,
 781882359,
 92949,
 -1,
 781916352,
 92948,
 -53602,
 781882359,
 92931,
 -1,
 782047424,
 92930,
 782249637,
 781790379,
 -1,
 782315171,
 782183595,
 -1,
 -53598,
 782275575,
 92929,
 -1,
 782309568,
 92928,
 -53596,
 782275575,
 92937,
 -1,
 782440640,
 92936,
 782696447,
 782210838,
 -1,
 -53593,
 782603255,
 92953,
 -1,
 782637248,
 92952,
 782839478,
 779954435,
 -1,
 782905004,
 782796387,
 -1,
 -53589,
 782867202,
 93010,
 -1,
 782909794,
 93011,
 783101615,
 782859492,
 -1,
 -53586,
 783043629,
 93014,
 -1,
 783102919,
 93015,
 783298226,
 783037623,
 -1,
 -53583,
 783248098,
 93012,
 -1,
 783305615,
 93013,
 -53581,
 783261678,
 93008,
 -53580,
 783443629,
 93009,
 -53579,
 783507775,
 93017,
 -1,
 783560542,
 93016,
 783756994,
 782787450,
 -1,
 783822526,
 783713891,
 -1,
 783888061,
 783757392,
 -1,
 783953596,
 783810560,
 -1,
 -53573,
 783911149,
 93021,
 -1,
 783948534,
 93024,
 -1,
 783908068,
 93019,
 -1,
 783841714,
 93025,
 784281281,
 783761981,
 -1,
 -53568,
 784235748,
 93020,
 -1,
 784270050,
 93023,
 -1,
 784227547,
 93022,
 784596991,
 783702621,
 -1,
 784608966,
 784500323,
 -1,
 -53563,
 784568052,
 92976,
 -1,
 784603207,
 92982,
 784805577,
 784563428,
 -1,
 -53560,
 784764638,
 92980,
 -1,
 784819179,
 92977,
 785002188,
 784747907,
 -1,
 -53557,
 784940614,
 92979,
 -1,
 785003188,
 92978,
 -1,
 784941230,
 92981,
 785264406,
 773099044,
 -1,
 785329921,
 785207244,
 -1,
 785395452,
 785265449,
 -1,
 785460956,
 785331383,
 -1,
 785526491,
 785401450,
 -1,
 785592020,
 785473151,
 72416,
 -1,
 785529190,
 72419,
 -53547,
 785554667,
 72420,
 -53546,
 785684246,
 72418,
 -53545,
 785745507,
 72414,
 -53544,
 785804472,
 72412,
 -53543,
 785864995,
 72415,
 -53542,
 785928140,
 72417,
 -1,
 785993091,
 72413,
 -1,
 785452900,
 72403,
 786247390,
 785419807,
 72409,
 -1,
 786173796,
 72410,
 786378465,
 786204259,
 -1,
 -53536,
 786316451,
 72399,
 -1,
 786370404,
 72398,
 786575076,
 786328760,
 -1,
 -53533,
 786513059,
 72401,
 -1,
 786567012,
 72384,
 786771687,
 786521727,
 -1,
 -53530,
 786708895,
 72391,
 -1,
 786763620,
 72400,
 786968298,
 786713987,
 -1,
 -53527,
 786906275,
 72394,
 -1,
 786960228,
 72385,
 787164908,
 786907786,
 72407,
 -1,
 787091300,
 72411,
 787295983,
 787095046,
 -1,
 -53522,
 787233955,
 72404,
 -1,
 787287908,
 72397,
 -53520,
 787259233,
 72389,
 -53519,
 787452937,
 72390,
 -53518,
 787512702,
 72395,
 -53517,
 787575805,
 72402,
 -53516,
 787637227,
 72408,
 -53515,
 787700077,
 72387,
 -53514,
 787763230,
 72386,
 -53513,
 787823779,
 72392,
 -53512,
 787888543,
 72393,
 -53511,
 787950763,
 72406,
 -53510,
 788014830,
 72388,
 -53509,
 788076753,
 72396,
 -1,
 788139876,
 72405,
 788398079,
 785345618,
 72436,
 788463615,
 788267008,
 -1,
 788475648,
 788354897,
 72435,
 -1,
 788398578,
 72438,
 -1,
 788411852,
 72439,
 788672265,
 785284576,
 -1,
 788737799,
 788630217,
 72428,
 788856831,
 788660224,
 -1,
 788868870,
 788748113,
 72427,
 -1,
 788791794,
 72429,
 -1,
 788805068,
 72430,
 789118975,
 788675495,
 72423,
 -1,
 788988402,
 72426,
 789196558,
 788626072,
 72422,
 789315583,
 789118976,
 -1,
 789327629,
 789206865,
 72421,
 -1,
 789250546,
 72424,
 -1,
 789263820,
 72425,
 789524242,
 789142560,
 72431,
 789643263,
 789446656,
 -1,
 -53487,
 789534550,
 72433,
 -1,
 789591500,
 72434,
 789839871,
 789461927,
 72437,
 789905407,
 789708800,
 -1,
 -53483,
 789812256,
 72432,
 -1,
 789853644,
 72440,
 790048580,
 785209125,
 -1,
 790114114,
 790011668,
 -1,
 790179638,
 790057475,
 -1,
 790245173,
 790138075,
 -1,
 790310687,
 790199524,
 -1,
 790376222,
 790237028,
 -1,
 -53475,
 790322082,
 67695,
 -1,
 790374572,
 67698,
 -1,
 790315041,
 67701,
 790638370,
 790267491,
 -1,
 -53471,
 790573856,
 67688,
 -1,
 790632579,
 67702,
 790834980,
 790576735,
 67684,
 -1,
 790792271,
 67687,
 790966055,
 790761316,
 -1,
 -53466,
 790928952,
 67696,
 -1,
 790975625,
 67680,
 -53464,
 790929374,
 67686,
 -53463,
 791125749,
 67689,
 -53462,
 791189473,
 67685,
 -53461,
 791246574,
 67700,
 -53460,
 791311018,
 67699,
 -53459,
 791375436,
 67697,
 -53458,
 791438271,
 67694,
 -53457,
 791501741,
 67692,
 -53456,
 791564463,
 67691,
 -53455,
 791629323,
 67690,
 -53454,
 791690090,
 67682,
 -53453,
 791754273,
 67693,
 -53452,
 791815995,
 67683,
 -1,
 791878228,
 67681,
 -1,
 790182199,
 67703,
 792145729,
 790127482,
 -1,
 792211261,
 792102499,
 -1,
 792276795,
 792172310,
 -1,
 -53446,
 792224747,
 67706,
 -1,
 792277329,
 67711,
 -53444,
 792215906,
 67707,
 -1,
 792408144,
 67710,
 792604480,
 792147127,
 -1,
 -53441,
 792554210,
 67708,
 -1,
 792611727,
 67709,
 -1,
 792553133,
 67705,
 -1,
 792099073,
 67704,
 -53437,
 790068575,
 129330,
 -1,
 792855998,
 127796,
 793063248,
 790000553,
 -1,
 793128780,
 793020003,
 -1,
 793194315,
 793068346,
 -1,
 -53432,
 793153830,
 983149,
 -53431,
 793196488,
 983145,
 -53430,
 793258740,
 983146,
 -1,
 793319701,
 983148,
 -1,
 793156891,
 127881,
 793587535,
 793055076,
 -1,
 -53426,
 793525252,
 11853,
 -1,
 793583918,
 129666,
 -1,
 793541582,
 129436,
 793849690,
 793000294,
 -1,
 793915225,
 793783467,
 128463,
 793980759,
 793837568,
 -1,
 794046294,
 793942447,
 -1,
 -53419,
 794006190,
 128195,
 -1,
 794053167,
 128479,
 -1,
 793982198,
 128196,
 -53416,
 793935076,
 128464,
 -1,
 794260393,
 128223,
 -1,
 793863333,
 128724,
 794505055,
 793805778,
 -1,
 794570590,
 794438827,
 -1,
 -53411,
 794517740,
 128755,
 -1,
 794568375,
 11261,
 -1,
 794521763,
 128706,
 794832738,
 794451583,
 -1,
 -53407,
 794765041,
 128060,
 -1,
 794828368,
 129374,
 795029348,
 794764898,
 983121,
 -1,
 794962195,
 983120,
 -53403,
 794990360,
 128062,
 -53402,
 795111160,
 128206,
 -1,
 795156999,
 128230,
 795357147,
 773017548,
 -1,
 795422674,
 795283300,
 -1,
 795488209,
 795385410,
 -1,
 795553680,
 795444835,
 -1,
 795619201,
 795507907,
 -1,
 795684727,
 795543977,
 127201,
 -53394,
 795610841,
 127219,
 -53393,
 795676250,
 127218,
 -53392,
 795741620,
 127217,
 -53391,
 795807004,
 127216,
 -53390,
 795872370,
 127215,
 -53389,
 795937750,
 127214,
 -53388,
 796003101,
 127213,
 -53387,
 796068421,
 127212,
 -53386,
 796133801,
 127211,
 -1,
 796199193,
 127210,
 796405626,
 795609669,
 127202,
 -53383,
 796330409,
 127221,
 -1,
 796395801,
 127220,
 -53381,
 796331737,
 127209,
 -53380,
 796528218,
 127208,
 -53379,
 796593588,
 127207,
 -53378,
 796658972,
 127206,
 -53377,
 796724338,
 127205,
 -53376,
 796789718,
 127204,
 -1,
 796855069,
 127203,
 797060998,
 795581229,
 -1,
 -53373,
 797016910,
 127138,
 -53372,
 797064910,
 127154,
 -53371,
 797124839,
 127170,
 -1,
 797188766,
 127186,
 797388683,
 797000109,
 -1,
 -53368,
 797344590,
 127139,
 -53367,
 797392590,
 127155,
 -53366,
 797452519,
 127171,
 -1,
 797516446,
 127187,
 797769727,
 797323360,
 -1,
 -53363,
 797672270,
 127146,
 -53362,
 797720270,
 127162,
 -53361,
 797780199,
 127178,
 -1,
 797844126,
 127194,
 798044061,
 795489463,
 -1,
 798109592,
 797991915,
 -1,
 798175127,
 798069390,
 -1,
 -53356,
 798131022,
 127140,
 -53355,
 798179022,
 127156,
 -53354,
 798238951,
 127172,
 -1,
 798302878,
 127188,
 -1,
 798123409,
 127200,
 798621695,
 798051267,
 -1,
 -53350,
 798524238,
 127141,
 -53349,
 798572238,
 127157,
 -53348,
 798632167,
 127173,
 -1,
 798696094,
 127189,
 798896040,
 797998308,
 -1,
 798961571,
 798837812,
 -1,
 -53344,
 798917454,
 127142,
 -53343,
 798965454,
 127158,
 -53342,
 799025383,
 127174,
 -1,
 799089310,
 127190,
 799342591,
 798897100,
 -1,
 -53339,
 799245134,
 127143,
 -53338,
 799293134,
 127159,
 -53337,
 799353063,
 127175,
 -1,
 799416990,
 127191,
 799616947,
 798838147,
 -1,
 799682478,
 799564073,
 -1,
 -53333,
 799638350,
 127148,
 -53332,
 799686350,
 127164,
 -53331,
 799746279,
 127180,
 -1,
 799810206,
 127196,
 800063487,
 799623108,
 -1,
 -53328,
 799966030,
 127150,
 -53327,
 800014030,
 127166,
 -53326,
 800073959,
 127182,
 -1,
 800137886,
 127198,
 800337848,
 799568714,
 -1,
 -53323,
 800293710,
 127149,
 -53322,
 800341710,
 127165,
 -53321,
 800401639,
 127181,
 -1,
 800465566,
 127197,
 800665533,
 800284996,
 -1,
 -53318,
 800621390,
 127145,
 -53317,
 800669390,
 127161,
 -53316,
 800729319,
 127177,
 -1,
 800793246,
 127193,
 800993218,
 800607453,
 -1,
 -53313,
 800949070,
 127147,
 -53312,
 800997070,
 127163,
 -53311,
 801056999,
 127179,
 -1,
 801120926,
 127195,
 801320903,
 800927603,
 -1,
 -53308,
 801276750,
 127144,
 -53307,
 801324750,
 127160,
 -53306,
 801384679,
 127176,
 -1,
 801448606,
 127192,
 801648588,
 801247318,
 -1,
 -53303,
 801604430,
 127137,
 -53302,
 801652430,
 127153,
 -53301,
 801712359,
 127169,
 -1,
 801776286,
 127185,
 801976271,
 801577152,
 -1,
 -53298,
 801919057,
 127183,
 -1,
 801968222,
 127136,
 -53296,
 801937711,
 127199,
 -1,
 802125338,
 127167,
 -1,
 795418533,
 128720,
 802369498,
 795381279,
 983150,
 802488319,
 802327199,
 -1,
 802500567,
 802391651,
 -1,
 -53290,
 802462466,
 11219,
 -1,
 802505058,
 11220,
 802750463,
 802436279,
 -1,
 -53287,
 802646754,
 11221,
 -1,
 802704271,
 11222,
 -1,
 802301538,
 983147,
 802959360,
 795311553,
 -1,
 803024881,
 802903193,
 -1,
 803090402,
 802979044,
 -1,
 803155937,
 803016548,
 -1,
 -53280,
 803101602,
 68493,
 -1,
 803154092,
 68495,
 -1,
 803094561,
 68496,
 803418084,
 803028575,
 68484,
 -1,
 803375183,
 68487,
 -53275,
 803381214,
 68486,
 -53274,
 803512053,
 68488,
 -53273,
 803575801,
 68485,
 -53272,
 803637155,
 68497,
 -53271,
 803696204,
 68494,
 -53270,
 803759039,
 68492,
 -53269,
 803822513,
 68491,
 -53268,
 803885231,
 68490,
 -53267,
 803950091,
 68489,
 -53266,
 804010858,
 68482,
 -53265,
 804071227,
 68483,
 -53264,
 804133460,
 68481,
 -1,
 804197008,
 68480,
 804401147,
 802972538,
 -1,
 804466680,
 804357731,
 -1,
 804532214,
 804427542,
 -1,
 -53259,
 804479979,
 68522,
 -1,
 804532561,
 68526,
 -53257,
 804471138,
 68523,
 -1,
 804663376,
 68525,
 804859898,
 804415149,
 68521,
 -1,
 804782652,
 68527,
 -1,
 804796412,
 68524,
 805056510,
 804337696,
 -1,
 -53251,
 804989329,
 68508,
 -1,
 805053747,
 68507,
 -53249,
 805014867,
 68506,
 -1,
 805207677,
 68505,
 805384226,
 802892971,
 -1,
 805449749,
 805335977,
 -1,
 805515284,
 805403876,
 -1,
 805580819,
 805463631,
 -1,
 805646354,
 805502976,
 -1,
 805711882,
 805607849,
 -1,
 -53241,
 805662948,
 128590,
 -53240,
 805715617,
 129493,
 -53239,
 805779289,
 128591,
 -1,
 805837867,
 128113,
 806039565,
 805652013,
 -1,
 -53236,
 805995681,
 129494,
 -1,
 806049731,
 129496,
 -53234,
 805991567,
 128588,
 -53233,
 806172939,
 128589,
 -53232,
 806234475,
 129336,
 -53231,
 806298213,
 129495,
 -1,
 806362349,
 128583,
 -1,
 805573240,
 128187,
 -1,
 805516295,
 128547,
 -1,
 805451681,
 127917,
 806760474,
 805396095,
 -1,
 -53225,
 806717212,
 9956,
 -53224,
 806781385,
 128532,
 -53223,
 806829136,
 128039,
 -1,
 806880196,
 128390,
 807088160,
 806686564,
 -1,
 807153694,
 807017990,
 -1,
 -53219,
 807101553,
 129434,
 -1,
 807156885,
 127825,
 -53217,
 807105449,
 127824,
 -1,
 807297995,
 129372,
 -53215,
 807046078,
 129515,
 -1,
 807413898,
 128694,
 807612484,
 805331947,
 -1,
 807677994,
 807573613,
 -1,
 807743527,
 807632100,
 -1,
 -53210,
 807706269,
 9211,
 -1,
 807752324,
 9214,
 807993343,
 807691855,
 -1,
 -53207,
 807864533,
 9212,
 -1,
 807929090,
 9213,
 808136752,
 807636511,
 -1,
 808202286,
 808094264,
 -1,
 -53203,
 808137950,
 128545,
 -1,
 808197940,
 128574,
 -53201,
 808147183,
 127831,
 -1,
 808329224,
 128093,
 808529973,
 808093283,
 -1,
 808595508,
 808456036,
 -1,
 -53197,
 808553109,
 129364,
 -1,
 808590323,
 128688,
 -1,
 808518483,
 127858,
 808857658,
 808484068,
 -1,
 808923193,
 808814179,
 -1,
 -53192,
 808852731,
 128238,
 -1,
 808915588,
 128239,
 -1,
 808857432,
 11239,
 809185342,
 808801699,
 -1,
 809250877,
 809115413,
 128659,
 -1,
 809205053,
 128680,
 -1,
 809198817,
 128110,
 809447489,
 809135288,
 -1,
 -53184,
 809378939,
 127871,
 -1,
 809435533,
 8297,
 -53182,
 809401480,
 128254,
 -53181,
 809591986,
 128041,
 -1,
 809640512,
 128425,
 809840733,
 807564201,
 -1,
 809906260,
 809779850,
 -1,
 809971791,
 809866249,
 -1,
 810037326,
 809928648,
 -1,
 810102859,
 809961568,
 -1,
 -53174,
 810027589,
 983166,
 -1,
 810092969,
 983163,
 810352639,
 810024960,
 -1,
 -53171,
 810257829,
 983165,
 -1,
 810313389,
 983162,
 -1,
 809969234,
 983192,
 810614783,
 809918079,
 -1,
 810627154,
 810518553,
 128424,
 -1,
 810549829,
 128438,
 810811391,
 810557330,
 129332,
 -1,
 810714066,
 128120,
 810889304,
 809853931,
 -1,
 -53162,
 810843988,
 11224,
 -53161,
 810893239,
 128711,
 -1,
 810949393,
 129455,
 811151452,
 810822827,
 -1,
 -53158,
 811109914,
 129384,
 -53157,
 811171523,
 983256,
 -1,
 811219899,
 129328,
 -1,
 811079848,
 128255,
 811479148,
 809779850,
 -1,
 811544675,
 811425407,
 -1,
 811610210,
 811478187,
 -1,
 -53151,
 811537767,
 127821,
 -1,
 811598209,
 127885,
 -1,
 811540731,
 129295,
 811872359,
 811481446,
 128022,
 811991039,
 811794432,
 -1,
 -53146,
 811885179,
 128061,
 -1,
 811939038,
 128055,
 812134506,
 811814860,
 -1,
 -53143,
 812077004,
 128138,
 -1,
 812133620,
 128169,
 -53141,
 812090612,
 128299,
 -1,
 812264619,
 129383,
 812462198,
 811437599,
 -1,
 812527728,
 812413865,
 -1,
 -53137,
 812482150,
 128091,
 -1,
 812543920,
 128156,
 -53135,
 812484232,
 128686,
 -53134,
 812679382,
 128204,
 -53133,
 812736343,
 11854,
 -53132,
 812784644,
 128226,
 -53131,
 812845637,
 983167,
 -1,
 812911017,
 983164,
 813117561,
 812394082,
 -1,
 -53128,
 813056650,
 983233,
 -1,
 813118647,
 983224,
 -53126,
 813062435,
 983193,
 -1,
 813252776,
 11227,
 813445767,
 772957163,
 -1,
 813511060,
 813388223,
 -1,
 813576592,
 813432832,
 -1,
 813641972,
 813515352,
 -1,
 813707445,
 813597230,
 -1,
 813772959,
 813640875,
 68809,
 813838470,
 813719167,
 68825,
 813904004,
 813794915,
 68839,
 -1,
 813828348,
 68849,
 -53115,
 813866219,
 68826,
 -1,
 813964806,
 68805,
 814166153,
 813768198,
 68804,
 -53112,
 814120164,
 68806,
 -1,
 814169237,
 68841,
 814362763,
 814128941,
 68847,
 -1,
 814316772,
 68848,
 814493837,
 814319203,
 68838,
 -1,
 814456043,
 68840,
 814624911,
 814447844,
 68836,
 -1,
 814587693,
 68837,
 814755985,
 814569763,
 68824,
 -1,
 814705848,
 68833,
 814887059,
 814698444,
 68822,
 -1,
 814849259,
 68823,
 815018133,
 814823782,
 68813,
 -1,
 814980331,
 68814,
 -53098,
 814978039,
 68846,
 -53097,
 815100841,
 68834,
 -53096,
 815164600,
 68832,
 -53095,
 815222147,
 68819,
 -53094,
 815287477,
 68818,
 -53093,
 815348885,
 68815,
 -53092,
 815412407,
 68812,
 -53091,
 815475883,
 68811,
 -53090,
 815539810,
 68807,
 -1,
 815601856,
 68802,
 815804580,
 813698916,
 68800,
 -53087,
 815751019,
 68808,
 -53086,
 815815329,
 68803,
 -53085,
 815877507,
 68820,
 -1,
 815927140,
 68801,
 816132264,
 815762975,
 68842,
 -53082,
 816090655,
 68843,
 -53081,
 816151780,
 68850,
 -1,
 816210376,
 68821,
 816394411,
 816079851,
 68827,
 -53078,
 816341995,
 68828,
 -1,
 816393839,
 68831,
 816591022,
 816348332,
 -1,
 -53075,
 816549834,
 68845,
 -1,
 816604343,
 68830,
 816787633,
 816537907,
 -1,
 -53072,
 816746442,
 68844,
 -1,
 816800951,
 68829,
 816984243,
 816726666,
 68816,
 -1,
 816923274,
 68817,
 -53068,
 816939213,
 68835,
 -1,
 817046132,
 68810,
 817246443,
 813637317,
 -1,
 817311957,
 817179819,
 68745,
 817377468,
 817258111,
 68761,
 817443002,
 817333859,
 68775,
 -1,
 817367292,
 68785,
 -53061,
 817405163,
 68762,
 -1,
 817503750,
 68741,
 817705151,
 817307142,
 68740,
 -53058,
 817659108,
 68742,
 -1,
 817708181,
 68777,
 817901761,
 817667885,
 68783,
 -1,
 817855716,
 68784,
 818032835,
 817858147,
 68774,
 -1,
 817994987,
 68776,
 818163909,
 817986788,
 68772,
 -1,
 818126637,
 68773,
 818294983,
 818108707,
 68760,
 -1,
 818244792,
 68769,
 818426057,
 818237388,
 68758,
 -1,
 818388203,
 68759,
 818557131,
 818362726,
 68749,
 -1,
 818519275,
 68750,
 -53044,
 818516983,
 68782,
 -53043,
 818639785,
 68770,
 -53042,
 818703544,
 68768,
 -53041,
 818761091,
 68755,
 -53040,
 818826421,
 68754,
 -53039,
 818887829,
 68751,
 -53038,
 818951351,
 68748,
 -53037,
 819014827,
 68747,
 -53036,
 819078754,
 68743,
 -1,
 819140800,
 68738,
 819343578,
 817237860,
 68736,
 -53033,
 819289963,
 68744,
 -53032,
 819354273,
 68739,
 -53031,
 819416451,
 68756,
 -1,
 819466084,
 68737,
 819671262,
 819301919,
 68778,
 -53028,
 819629599,
 68779,
 -53027,
 819690724,
 68786,
 -1,
 819749320,
 68757,
 819933409,
 819618795,
 68763,
 -53024,
 819880939,
 68764,
 -1,
 819932783,
 68767,
 820130020,
 819887276,
 -1,
 -53021,
 820088778,
 68781,
 -1,
 820143287,
 68766,
 820326631,
 820076851,
 -1,
 -53018,
 820285386,
 68780,
 -1,
 820339895,
 68765,
 820523241,
 820265610,
 68752,
 -1,
 820462218,
 68753,
 -53014,
 820478157,
 68771,
 -1,
 820585076,
 68746,
 820838399,
 817193850,
 -1,
 820850928,
 820733613,
 68858,
 820969471,
 820772864,
 -1,
 -53009,
 820873444,
 68863,
 -1,
 820920893,
 68862,
 821113075,
 820786610,
 -1,
 -53006,
 821072943,
 68859,
 -1,
 821115217,
 68861,
 -1,
 821069834,
 68860,
 821375273,
 813597449,
 -1,
 821440794,
 821317580,
 -1,
 821506329,
 821375785,
 -1,
 821571841,
 821442002,
 -1,
 821637370,
 821528483,
 69403,
 -1,
 821561387,
 69404,
 821768444,
 821591441,
 69398,
 -1,
 821692459,
 69399,
 821899518,
 821715903,
 69391,
 -1,
 821823531,
 69392,
 -52993,
 821837407,
 69382,
 -52992,
 821959252,
 69379,
 -1,
 822022800,
 69377,
 822227206,
 821525732,
 -1,
 822292741,
 822153060,
 -1,
 -52988,
 822238114,
 69393,
 -1,
 822290604,
 69397,
 -1,
 822231073,
 69401,
 822554891,
 822153060,
 -1,
 822620426,
 822497228,
 -1,
 -52983,
 822577196,
 69395,
 -1,
 822620561,
 69376,
 -1,
 822582840,
 69394,
 822882573,
 822492767,
 69381,
 -1,
 822839375,
 69385,
 -52978,
 822845406,
 69384,
 -52977,
 822976245,
 69386,
 -52976,
 823039969,
 69383,
 -52975,
 823101347,
 69402,
 -52974,
 823162632,
 69400,
 -52973,
 823225932,
 69396,
 -52972,
 823288767,
 69390,
 -52971,
 823352237,
 69389,
 -52970,
 823414959,
 69388,
 -52969,
 823479819,
 69387,
 -52968,
 823540586,
 69380,
 -1,
 823597652,
 69378,
 -1,
 821445708,
 69415,
 823865640,
 821388154,
 -1,
 823931171,
 823821923,
 -1,
 823996703,
 823891734,
 -1,
 -52962,
 823944171,
 69406,
 -1,
 823996753,
 69411,
 824193314,
 823934101,
 -1,
 -52959,
 824145470,
 69407,
 -1,
 824199818,
 69412,
 -1,
 824127568,
 69410,
 824455461,
 823879341,
 69405,
 -1,
 824377916,
 69413,
 824639487,
 824390839,
 -1,
 -52953,
 824535778,
 69408,
 -1,
 824593295,
 69409,
 -1,
 823802029,
 69414,
 824848730,
 821325524,
 -1,
 824914265,
 824794118,
 -1,
 824979763,
 824876267,
 -1,
 825045295,
 824914414,
 66415,
 -52946,
 825003551,
 66408,
 -1,
 825049738,
 66416,
 825241905,
 824971108,
 66420,
 -1,
 825198179,
 66417,
 -52942,
 825200159,
 66419,
 -1,
 825326809,
 66407,
 825504056,
 824933604,
 -1,
 825569591,
 825441429,
 -1,
 -52938,
 825518111,
 66405,
 -1,
 825565455,
 66406,
 -1,
 825509277,
 66401,
 825831739,
 825442954,
 66393,
 -52934,
 825765035,
 66418,
 -1,
 825823076,
 66421,
 826028352,
 825763426,
 -1,
 826093887,
 825990957,
 -1,
 -52930,
 826034992,
 66392,
 -1,
 826097824,
 66390,
 -1,
 826041665,
 66387,
 826356035,
 825990957,
 -1,
 -52926,
 826294432,
 66389,
 -1,
 826349439,
 66391,
 826552646,
 826315767,
 -1,
 -52923,
 826501151,
 66398,
 -1,
 826552814,
 66414,
 826749257,
 826508899,
 -1,
 -52920,
 826704325,
 66413,
 -1,
 826741204,
 66402,
 826945867,
 826696683,
 66409,
 -1,
 826893291,
 66410,
 827076941,
 826879147,
 66388,
 -1,
 827012279,
 66411,
 -52914,
 827035167,
 66403,
 -52913,
 827160231,
 66400,
 -52912,
 827223651,
 66399,
 -52911,
 827285613,
 66397,
 -52910,
 827349972,
 66396,
 -52909,
 827413608,
 66395,
 -52908,
 827477833,
 66394,
 -52907,
 827538595,
 66412,
 -52906,
 827603417,
 66386,
 -52905,
 827662523,
 66404,
 -52904,
 827727285,
 66385,
 -1,
 827790240,
 66384,
 -1,
 824869664,
 128435,
 828060039,
 824795743,
 -1,
 828125570,
 828003481,
 -1,
 828191074,
 828081763,
 -1,
 828256608,
 828128405,
 -1,
 -52897,
 828190513,
 68251,
 -1,
 828248693,
 68249,
 -52895,
 828190513,
 68233,
 -1,
 828379578,
 68247,
 828584294,
 828125879,
 -1,
 -52892,
 828508957,
 68239,
 -52891,
 828574277,
 68230,
 -1,
 828639657,
 68234,
 828846441,
 828546913,
 -1,
 -52888,
 828786218,
 68248,
 -1,
 828849301,
 68252,
 829043052,
 828788099,
 -1,
 -52885,
 828980414,
 68237,
 -1,
 829034819,
 68235,
 829239663,
 828980373,
 -1,
 -52882,
 829173553,
 68224,
 -1,
 829231546,
 68226,
 829436274,
 829176166,
 -1,
 -52879,
 829373661,
 68246,
 -1,
 829435524,
 68244,
 829632885,
 829368046,
 -1,
 -52876,
 829575116,
 68245,
 -1,
 829630050,
 68243,
 829829496,
 829558628,
 -1,
 -52873,
 829772438,
 68241,
 -1,
 829834794,
 68242,
 -52871,
 829791657,
 68250,
 -52870,
 829986785,
 68229,
 -52869,
 830045581,
 68238,
 -52868,
 830109347,
 68231,
 -52867,
 830173823,
 68228,
 -52866,
 830235187,
 68236,
 -52865,
 830298994,
 68227,
 -52864,
 830361761,
 68225,
 -52863,
 830420307,
 68240,
 -1,
 830478845,
 68232,
 830734335,
 828072826,
 -1,
 830747014,
 830637667,
 -1,
 -52859,
 830707811,
 68255,
 -1,
 830746704,
 68254,
 -1,
 830695085,
 68253,
 831009164,
 828001085,
 -1,
 -52855,
 830971298,
 66349,
 -52854,
 831030070,
 66351,
 -52853,
 831087214,
 66350,
 -1,
 831140591,
 66335,
 831336847,
 830939366,
 -1,
 -52850,
 831277917,
 94179,
 -1,
 831340738,
 94178,
 -1,
 831278777,
 128477,
 831651839,
 813511153,
 -1,
 -52846,
 831560597,
 128117,
 -52845,
 831609395,
 128116,
 -1,
 831656170,
 129491,
 831861233,
 813464804,
 -1,
 831926768,
 831787415,
 -1,
 831992259,
 831881774,
 -1,
 832057760,
 831925419,
 66783,
 832123295,
 831995029,
 -1,
 832188828,
 832079459,
 -1,
 -52837,
 832142718,
 66803,
 -1,
 832180068,
 66801,
 -52835,
 832138482,
 66797,
 -52834,
 832327130,
 66789,
 -1,
 832380979,
 66782,
 -1,
 832063018,
 66784,
 832647588,
 831983460,
 66776,
 832713123,
 832586378,
 66777,
 -1,
 832659071,
 66778,
 -1,
 832650389,
 66779,
 832909737,
 832603747,
 -1,
 832975272,
 832863460,
 -1,
 -52825,
 832912547,
 66804,
 -1,
 832966500,
 66802,
 -1,
 832900964,
 66800,
 833237421,
 832851331,
 -1,
 -52821,
 833199449,
 66790,
 -52820,
 833240227,
 66808,
 -1,
 833294180,
 66788,
 833499568,
 833199917,
 -1,
 -52817,
 833436835,
 66811,
 -1,
 833490788,
 66810,
 833696179,
 833453284,
 -1,
 -52814,
 833633443,
 66799,
 -1,
 833687396,
 66798,
 833892789,
 833643499,
 66794,
 -1,
 833832490,
 66795,
 834023864,
 833830037,
 -1,
 -52809,
 833985881,
 66786,
 -1,
 834015076,
 66785,
 -52807,
 833984302,
 66807,
 -52806,
 834178591,
 66806,
 -52805,
 834235634,
 66796,
 -52804,
 834297560,
 66793,
 -52803,
 834361709,
 66792,
 -52802,
 834424862,
 66791,
 -52801,
 834486922,
 66787,
 -52800,
 834550499,
 66809,
 -52799,
 834611362,
 66805,
 -52798,
 834674739,
 66781,
 -1,
 834739467,
 66780,
 834994175,
 831921861,
 -1,
 835006925,
 834874539,
 66743,
 835072460,
 834944149,
 -1,
 835137993,
 835028579,
 -1,
 -52792,
 835091838,
 66763,
 -1,
 835129188,
 66761,
 -52790,
 835087602,
 66757,
 -52789,
 835276250,
 66749,
 -1,
 835330099,
 66742,
 -1,
 835012138,
 66744,
 835596753,
 834932580,
 66736,
 835662288,
 835535498,
 66737,
 -1,
 835608191,
 66738,
 -1,
 835599509,
 66739,
 835858902,
 835552867,
 -1,
 835924437,
 835812580,
 -1,
 -52780,
 835861667,
 66764,
 -1,
 835915620,
 66762,
 -1,
 835850084,
 66760,
 836186586,
 835800451,
 -1,
 -52776,
 836148569,
 66750,
 -52775,
 836189347,
 66768,
 -1,
 836243300,
 66748,
 836448733,
 836149037,
 -1,
 -52772,
 836385955,
 66771,
 -1,
 836439908,
 66770,
 836645344,
 836402404,
 -1,
 -52769,
 836582563,
 66759,
 -1,
 836636516,
 66758,
 836841954,
 836592619,
 66754,
 -1,
 836781610,
 66755,
 836973029,
 836779157,
 -1,
 -52764,
 836935001,
 66746,
 -1,
 836964196,
 66745,
 -52762,
 836933422,
 66767,
 -52761,
 837127711,
 66766,
 -52760,
 837184754,
 66756,
 -52759,
 837246680,
 66753,
 -52758,
 837310829,
 66752,
 -52757,
 837373982,
 66751,
 -52756,
 837436042,
 66747,
 -52755,
 837499619,
 66769,
 -52754,
 837560482,
 66765,
 -52753,
 837623859,
 66741,
 -1,
 837688587,
 66740,
 -1,
 831856134,
 983191,
 837956167,
 831818942,
 -1,
 838021702,
 837903859,
 -1,
 838087217,
 837968762,
 -1,
 838152709,
 838043235,
 -1,
 838218236,
 838113046,
 -1,
 838283770,
 838165483,
 126210,
 838402047,
 838205440,
 -1,
 -52743,
 838306020,
 126237,
 -1,
 838353469,
 126228,
 838598655,
 838218065,
 126219,
 -1,
 838468886,
 126246,
 838676995,
 838155413,
 -1,
 838742529,
 838628926,
 126211,
 838860799,
 838664192,
 -1,
 -52736,
 838764772,
 126238,
 -1,
 838812221,
 126229,
 839057407,
 838683274,
 126220,
 -1,
 838927638,
 126247,
 839188479,
 838611024,
 126218,
 -1,
 839058710,
 126245,
 839266834,
 838106340,
 -1,
 839332364,
 839207981,
 126214,
 839397897,
 839290371,
 126223,
 -1,
 839320854,
 126250,
 839581695,
 839319552,
 -1,
 -52725,
 839485668,
 126241,
 -1,
 839533117,
 126232,
 839778303,
 839267271,
 126215,
 839791119,
 839683587,
 126224,
 -1,
 839714070,
 126251,
 839974911,
 839712768,
 -1,
 -52719,
 839878884,
 126242,
 -1,
 839926333,
 126233,
 840118817,
 839201975,
 -1,
 840184346,
 840066027,
 -1,
 840249880,
 840143484,
 126212,
 840368127,
 840171520,
 -1,
 -52713,
 840272100,
 126239,
 -1,
 840319549,
 126230,
 840564735,
 840203424,
 126221,
 -1,
 840434966,
 126248,
 840695807,
 840123018,
 -1,
 840708639,
 840602671,
 126213,
 840826879,
 840630272,
 -1,
 -52706,
 840730852,
 126240,
 -1,
 840778301,
 126231,
 841023487,
 840644945,
 126222,
 -1,
 840893718,
 126249,
 841101863,
 840065343,
 126217,
 841167396,
 841059843,
 126226,
 -1,
 841090326,
 126253,
 841351167,
 841089024,
 -1,
 -52698,
 841255140,
 126244,
 -1,
 841302589,
 126235,
 841495085,
 841035614,
 126216,
 841560618,
 841456875,
 126225,
 -1,
 841483542,
 126252,
 841744383,
 841482240,
 -1,
 -52692,
 841648356,
 126243,
 -1,
 841695805,
 126234,
 841940991,
 841442989,
 126209,
 842006527,
 841809920,
 -1,
 -52688,
 841910500,
 126236,
 -1,
 841957949,
 126227,
 842150466,
 838013714,
 -1,
 842215992,
 842106467,
 -1,
 842281525,
 842177282,
 126255,
 -1,
 842204438,
 126266,
 842412599,
 842215504,
 126263,
 -1,
 842335510,
 126267,
 -1,
 842350946,
 126256,
 842609212,
 842169572,
 -1,
 842674747,
 842550317,
 126259,
 -1,
 842596924,
 126265,
 -1,
 842609607,
 126260,
 842871360,
 842544311,
 -1,
 842936895,
 842820322,
 126257,
 -1,
 842859068,
 126264,
 -1,
 842877839,
 126258,
 -52671,
 842817855,
 126262,
 -1,
 843067230,
 126261,
 843264581,
 842086559,
 -1,
 -52668,
 843219450,
 126269,
 -1,
 843267371,
 126268,
 -1,
 843209329,
 126254,
 -1,
 837956078,
 129446,
 843592279,
 837905592,
 -1,
 843657812,
 843525291,
 -1,
 843723347,
 843603585,
 -1,
 843788877,
 843667917,
 -1,
 -52660,
 843740260,
 128236,
 -1,
 843798659,
 128237,
 843985488,
 843723959,
 -1,
 -52657,
 843933085,
 128449,
 -1,
 843990483,
 128194,
 -52655,
 843929402,
 128275,
 -52654,
 844119540,
 128080,
 -1,
 844176554,
 128214,
 -1,
 843674851,
 983190,
 844444246,
 843614644,
 128191,
 -1,
 844366405,
 128440,
 -1,
 844382326,
 9934,
 844640870,
 843543465,
 -1,
 844706401,
 844582015,
 -1,
 844771934,
 844654257,
 -1,
 -52645,
 844726757,
 2933,
 -52644,
 844788477,
 2930,
 -52643,
 844840235,
 2931,
 -1,
 844902291,
 2934,
 845152255,
 844728582,
 -1,
 -52640,
 845054447,
 2935,
 -1,
 845116219,
 2932,
 845348863,
 844633173,
 -1,
 845361765,
 845229229,
 -1,
 -52636,
 845299382,
 129505,
 -1,
 845356202,
 128217,
 -1,
 845321111,
 129447,
 845623922,
 844586623,
 -1,
 845689453,
 845554455,
 -1,
 -52631,
 845645735,
 128662,
 -52630,
 845705337,
 128660,
 -52629,
 845756023,
 128753,
 -52628,
 845815232,
 128653,
 -1,
 845879375,
 128664,
 846082672,
 845622443,
 -1,
 -52625,
 846006497,
 129649,
 -1,
 846070034,
 128431,
 -52623,
 846023036,
 129477,
 -1,
 846202516,
 128283,
 846410362,
 845583540,
 -1,
 846475897,
 846352621,
 128471,
 846594047,
 846425932,
 -1,
 846606968,
 846502087,
 -1,
 -52617,
 846562241,
 11194,
 -1,
 846599137,
 11195,
 -1,
 846535629,
 11196,
 -1,
 846413525,
 129397,
 846934653,
 846341526,
 -1,
 -52612,
 846883041,
 128025,
 -1,
 846926254,
 128721,
 -52610,
 846896932,
 129450,
 -52609,
 847092778,
 128002,
 -52608,
 847157931,
 129417,
 -52607,
 847221660,
 128228,
 -52606,
 847272260,
 128329,
 -52605,
 847334814,
 128076,
 -52604,
 847398311,
 128738,
 -52603,
 847459742,
 127970,
 -52602,
 847521795,
 127842,
 -1,
 847584627,
 9215,
 847787059,
 813377122,
 -1,
 847852339,
 847744543,
 -1,
 847917873,
 847802354,
 -1,
 847983363,
 847860889,
 -1,
 848048807,
 847936740,
 113692,
 848114330,
 847970304,
 -1,
 848179855,
 848075190,
 113701,
 -1,
 848101614,
 113702,
 848310929,
 848135779,
 113714,
 -1,
 848233537,
 113715,
 848442003,
 848260280,
 113716,
 -1,
 848364609,
 113717,
 848573077,
 848383363,
 113727,
 -1,
 848495681,
 113728,
 848704151,
 848514229,
 113696,
 -1,
 848626828,
 113710,
 -52584,
 848657636,
 113706,
 -52583,
 848780927,
 113723,
 -1,
 848845091,
 113724,
 849031846,
 848058155,
 -1,
 849097375,
 848964779,
 -1,
 -52579,
 849043071,
 113767,
 -52578,
 849099925,
 113740,
 -1,
 849161387,
 113742,
 849359522,
 849044459,
 -1,
 -52575,
 849319702,
 113730,
 -1,
 849370751,
 113769,
 -52573,
 849317407,
 113752,
 -52572,
 849497269,
 113685,
 -52571,
 849553567,
 113682,
 -1,
 849613728,
 113768,
 -1,
 848970027,
 113737,
 849883826,
 847994495,
 113690,
 849949357,
 849811169,
 -1,
 -52566,
 849907231,
 113761,
 -52565,
 849961963,
 113762,
 -52564,
 850018954,
 113763,
 -1,
 850071396,
 113764,
 850329599,
 849870848,
 -1,
 850342576,
 850221347,
 113694,
 -1,
 850265228,
 113708,
 -52559,
 850303414,
 113698,
 -1,
 850427108,
 113704,
 850604732,
 849824949,
 113691,
 850722815,
 850526208,
 -1,
 850735798,
 850631094,
 113699,
 -1,
 850689303,
 113700,
 850866872,
 850689252,
 113705,
 -1,
 850789993,
 113711,
 850997946,
 850812543,
 113712,
 -1,
 850920588,
 113713,
 851181567,
 850942243,
 113695,
 -1,
 851051660,
 113709,
 851260100,
 850564886,
 113720,
 851325631,
 851207147,
 113757,
 -1,
 851285782,
 113760,
 -52544,
 851264138,
 113758,
 -52543,
 851393685,
 113721,
 -52542,
 851455829,
 113759,
 -52541,
 851513188,
 113756,
 -1,
 851575873,
 113722,
 851784394,
 851211177,
 113675,
 851849928,
 851731967,
 -1,
 -52537,
 851807775,
 113750,
 -1,
 851853962,
 113741,
 -52535,
 851786901,
 113688,
 -1,
 851969164,
 113680,
 852177615,
 851731435,
 113732,
 -52532,
 852137750,
 113754,
 -52531,
 852200991,
 113755,
 -52530,
 852256050,
 113753,
 -1,
 852299620,
 113731,
 852505301,
 852121891,
 113689,
 852623359,
 852426752,
 -1,
 852636371,
 852516479,
 113693,
 -1,
 852558988,
 113707,
 -52524,
 852597174,
 113697,
 -1,
 852720868,
 113703,
 852898521,
 852463135,
 113745,
 -52521,
 852837002,
 113738,
 -52520,
 852901013,
 113751,
 -1,
 852951817,
 113748,
 853160670,
 852854371,
 113667,
 853226205,
 853082112,
 -1,
 -52516,
 853179620,
 113718,
 -1,
 853242813,
 113719,
 -1,
 853163157,
 113681,
 853488355,
 853109944,
 113666,
 853553890,
 853422724,
 -1,
 -52511,
 853499519,
 113765,
 -1,
 853563683,
 113766,
 -1,
 853476105,
 113676,
 853816040,
 853430220,
 113670,
 853881575,
 853763945,
 -1,
 -52506,
 853839391,
 113749,
 -1,
 853885578,
 113743,
 -1,
 853818517,
 113687,
 854143725,
 853757315,
 113669,
 854209260,
 854065152,
 -1,
 -52501,
 854160317,
 113725,
 -1,
 854219043,
 113679,
 -1,
 854150531,
 113684,
 854471408,
 854076587,
 113735,
 -52497,
 854429215,
 113746,
 -1,
 854469803,
 113739,
 854668019,
 854402658,
 113672,
 -52494,
 854604949,
 113683,
 -1,
 854656140,
 113677,
 854864629,
 854629418,
 113665,
 -1,
 854824726,
 113747,
 854995703,
 854823927,
 113673,
 -1,
 854942807,
 113770,
 855126777,
 854934154,
 113734,
 -1,
 855059627,
 113736,
 855257851,
 855063701,
 113664,
 -1,
 855199692,
 113686,
 855388925,
 855193958,
 113674,
 -1,
 855311428,
 113726,
 855519999,
 855323831,
 113668,
 -1,
 855442185,
 113678,
 855651073,
 855445348,
 113729,
 -1,
 855599702,
 113733,
 -52478,
 855612834,
 113744,
 -1,
 855709888,
 113671,
 855913261,
 847909230,
 -1,
 855978772,
 855855052,
 -1,
 856044307,
 855927878,
 -1,
 856109832,
 856003801,
 113816,
 -1,
 856032408,
 113779,
 856240907,
 856051660,
 -1,
 -52470,
 856188782,
 113811,
 -1,
 856246093,
 113814,
 856437518,
 856166244,
 -1,
 -52467,
 856390740,
 113817,
 -1,
 856434253,
 113808,
 -52465,
 856397771,
 113815,
 -52464,
 856590800,
 113809,
 -52463,
 856636440,
 113810,
 -52462,
 856697233,
 113812,
 -1,
 856760633,
 113813,
 -1,
 855977706,
 113776,
 857027360,
 855916510,
 -1,
 857092887,
 856986841,
 113800,
 -1,
 857015448,
 113781,
 857223962,
 857034700,
 -1,
 -52455,
 857171822,
 113795,
 -1,
 857229133,
 113798,
 -52453,
 857184203,
 113799,
 -52452,
 857377232,
 113793,
 -52451,
 857422872,
 113794,
 -52450,
 857483665,
 113796,
 -52449,
 857547065,
 113797,
 -1,
 857608379,
 113792,
 857813801,
 856954881,
 -1,
 857879333,
 857769714,
 -1,
 857944868,
 857825505,
 113784,
 -1,
 857866806,
 113788,
 -1,
 857884068,
 113785,
 -52442,
 857833078,
 113782,
 -52441,
 858084259,
 113783,
 -52440,
 858145442,
 113787,
 -1,
 858205397,
 113786,
 858403628,
 857758738,
 -1,
 -52437,
 858363189,
 113780,
 -1,
 858407169,
 113777,
 -1,
 858355757,
 113778,
 -52434,
 855869597,
 113821,
 -52433,
 858620241,
 113820,
 -52432,
 858681828,
 113823,
 -1,
 858729075,
 113822,
 -52430,
 847863299,
 129375,
 -1,
 858857958,
 129414,
 859059151,
 847799275,
 -1,
 859124613,
 858995046,
 128021,
 859190148,
 859075584,
 -1,
 859255664,
 859133081,
 -1,
 859321149,
 859211363,
 -1,
 859386683,
 859276899,
 -1,
 -52422,
 859323555,
 71701,
 -1,
 859377508,
 71700,
 -52420,
 859323555,
 71706,
 -1,
 859508580,
 71705,
 859714370,
 859266687,
 -1,
 -52417,
 859675993,
 71699,
 -52416,
 859725528,
 71704,
 -52415,
 859781535,
 71694,
 -1,
 859836260,
 71709,
 860042056,
 859645538,
 -1,
 860107590,
 859973218,
 -1,
 -52411,
 860044451,
 71703,
 -1,
 860098404,
 71702,
 -52409,
 860044451,
 71708,
 -1,
 860229476,
 71707,
 860435276,
 859967332,
 71680,
 -52406,
 860392991,
 71689,
 -52405,
 860439178,
 71687,
 -1,
 860491620,
 71681,
 860697424,
 860388580,
 -1,
 -52402,
 860650878,
 71720,
 -52401,
 860699811,
 71719,
 -1,
 860753764,
 71721,
 860959570,
 860655135,
 71684,
 -1,
 860917279,
 71685,
 861090645,
 860910505,
 -1,
 -52396,
 861041661,
 71723,
 -1,
 861081444,
 71716,
 861287256,
 861039800,
 -1,
 -52393,
 861224099,
 71711,
 -1,
 861278052,
 71710,
 861483867,
 861228419,
 -1,
 -52390,
 861420707,
 71691,
 -1,
 861474660,
 71690,
 861680478,
 861424821,
 -1,
 -52387,
 861617315,
 71698,
 -1,
 861671268,
 71697,
 861877088,
 861618826,
 71682,
 -1,
 861815434,
 71683,
 862008163,
 861813094,
 -1,
 -52382,
 861944995,
 71693,
 -1,
 861998948,
 71692,
 862204774,
 861937158,
 -1,
 -52379,
 862141603,
 71696,
 -1,
 862195556,
 71695,
 862401385,
 862132416,
 -1,
 -52376,
 862338211,
 71713,
 -1,
 862392164,
 71712,
 -52374,
 862362969,
 71715,
 -52373,
 862557193,
 71718,
 -52372,
 862610411,
 71688,
 -52371,
 862673261,
 71714,
 -52370,
 862736414,
 71717,
 -52369,
 862796963,
 71722,
 -1,
 862858411,
 71686,
 863056765,
 859215588,
 -1,
 863122293,
 862981988,
 -1,
 -52365,
 863079967,
 71734,
 -52364,
 863126154,
 71732,
 -1,
 863178596,
 71724,
 863384439,
 863082099,
 71729,
 -1,
 863335337,
 71730,
 863515513,
 863342111,
 71727,
 -1,
 863473183,
 71728,
 863646587,
 863453834,
 71725,
 -1,
 863584906,
 71726,
 -52356,
 863593451,
 71733,
 -1,
 863710379,
 71731,
 863908739,
 863011147,
 -1,
 863974273,
 863868387,
 -1,
 -52352,
 863927853,
 71736,
 -1,
 863990966,
 71737,
 -52350,
 863921012,
 71738,
 -1,
 864097545,
 71735,
 -1,
 863834121,
 71739,
 -1,
 859111900,
 128054,
 864433081,
 859085489,
 -1,
 864498614,
 864393084,
 -1,
 864564145,
 864451814,
 -1,
 864629662,
 864519779,
 -1,
 864695197,
 864581537,
 -1,
 864760732,
 864618631,
 -1,
 864826265,
 864687717,
 11107,
 864944127,
 864747520,
 -1,
 864957335,
 864852393,
 -1,
 865022865,
 864900977,
 -1,
 -52336,
 864975152,
 11169,
 -1,
 865031096,
 11168,
 -52334,
 864982391,
 129075,
 -52333,
 865165091,
 129059,
 -52332,
 865229629,
 129063,
 -52331,
 865287929,
 129071,
 -52330,
 865348186,
 11133,
 -1,
 865410182,
 129067,
 -52328,
 864914072,
 11123,
 -1,
 865555513,
 11139,
 -52326,
 864788483,
 11085,
 -52325,
 865692964,
 11143,
 -1,
 865740677,
 11117,
 -1,
 864682158,
 129171,
 -1,
 864656236,
 11247,
 866071462,
 864556670,
 -1,
 866136994,
 866026010,
 -1,
 -52319,
 866094044,
 129027,
 -1,
 866136536,
 129043,
 -52317,
 866083469,
 129179,
 -52316,
 866278232,
 129031,
 -52315,
 866341159,
 129035,
 -1,
 866398680,
 129047,
 866595753,
 866024676,
 -1,
 -52312,
 866546416,
 129083,
 -1,
 866587840,
 129107,
 866792364,
 866533089,
 -1,
 -52309,
 866722649,
 129091,
 -1,
 866784869,
 129095,
 -52307,
 866752731,
 129175,
 -52306,
 866941808,
 128623,
 -52305,
 866989648,
 129079,
 -52304,
 867050329,
 129087,
 -1,
 867113867,
 11147,
 867368959,
 864485865,
 -1,
 867382196,
 867263104,
 129289,
 -1,
 867305065,
 129291,
 867565567,
 867319991,
 129288,
 -1,
 867436137,
 129290,
 867696639,
 864422129,
 -1,
 -52296,
 867598981,
 128317,
 -1,
 867661361,
 128315,
 867840965,
 864390687,
 -1,
 867906500,
 867769318,
 -1,
 867972035,
 867827712,
 -1,
 868037567,
 867925220,
 -1,
 -52290,
 867996533,
 11844,
 -1,
 868058895,
 11849,
 -52288,
 867996898,
 9208,
 -52287,
 868177998,
 11842,
 -52286,
 868237955,
 11840,
 -1,
 868296212,
 10175,
 -1,
 867903159,
 11260,
 -1,
 867842819,
 127849,
 868627402,
 867771864,
 128462,
 868745215,
 868550097,
 -1,
 868758473,
 868649029,
 128441,
 -1,
 868679756,
 128442,
 -1,
 868708155,
 128443,
 -52277,
 868586561,
 128330,
 -52276,
 868912329,
 11850,
 -52275,
 868968704,
 128682,
 -52274,
 869030045,
 128044,
 -1,
 869073680,
 128687,
 869282816,
 858991787,
 -1,
 869348336,
 869241847,
 -1,
 869413865,
 869274580,
 -1,
 869479389,
 869356697,
 -1,
 869544918,
 869436959,
 -1,
 -52267,
 869502922,
 2423,
 -1,
 869543083,
 2422,
 869741529,
 869491691,
 -1,
 -52264,
 869688503,
 2420,
 -1,
 869739691,
 2419,
 869938140,
 869666660,
 -1,
 -52261,
 869899499,
 43262,
 -1,
 869963542,
 2421,
 -1,
 869882490,
 2424,
 870200295,
 869439204,
 -1,
 870265825,
 870157855,
 -1,
 -52256,
 870223818,
 2391,
 -1,
 870263979,
 2390,
 870462436,
 870212587,
 -1,
 -52253,
 870409399,
 2363,
 -1,
 870460587,
 2362,
 870711295,
 870387556,
 -1,
 -52250,
 870620395,
 43263,
 -1,
 870684438,
 2383,
 -52248,
 870154612,
 43260,
 -1,
 870796522,
 43261,
 871038975,
 869352323,
 -1,
 871052269,
 870942307,
 -1,
 -52244,
 871013122,
 983085,
 -1,
 871055714,
 983087,
 -52242,
 871007555,
 983160,
 -52241,
 871196333,
 983083,
 -1,
 871249916,
 983089,
 871445494,
 869301476,
 -1,
 871511028,
 871387004,
 -1,
 -52237,
 871471473,
 128468,
 -1,
 871506794,
 128421,
 871759871,
 871445164,
 127964,
 -1,
 871629419,
 127965,
 871838713,
 871387084,
 983119,
 -52232,
 871779341,
 128666,
 -1,
 871838480,
 983118,
 872035324,
 871767558,
 -1,
 -52229,
 871986604,
 128475,
 -1,
 872039397,
 127795,
 -52227,
 871986867,
 127962,
 -52226,
 872181272,
 127980,
 -52225,
 872231406,
 129420,
 -1,
 872288582,
 129487,
 872494097,
 869221002,
 -1,
 872559620,
 872456252,
 -1,
 -52221,
 872515124,
 128171,
 -1,
 872559838,
 128565,
 872756231,
 872513040,
 -1,
 -52218,
 872690910,
 128542,
 -1,
 872750557,
 128549,
 872952842,
 872702166,
 -1,
 -52215,
 872898612,
 127244,
 -1,
 872948087,
 127243,
 873149453,
 872878982,
 -1,
 -52212,
 873105283,
 128924,
 -1,
 873168913,
 128160,
 -52210,
 873110876,
 129684,
 -52209,
 873305653,
 129343,
 -52208,
 873362937,
 127919,
 -1,
 873411263,
 128754,
 873608223,
 872419172,
 -1,
 873673751,
 873544358,
 -1,
 873739286,
 873634217,
 -1,
 -52203,
 873691124,
 11831,
 -1,
 873747109,
 11830,
 -1,
 873680690,
 128481,
 874001434,
 873627526,
 -1,
 -52199,
 873961977,
 11843,
 -1,
 874022452,
 128168,
 874198045,
 873946751,
 -1,
 -52196,
 874134471,
 127841,
 -1,
 874192878,
 128131,
 -52194,
 874153717,
 983081,
 -1,
 874347279,
 128374,
 874525738,
 873558953,
 -1,
 874591270,
 874472427,
 -1,
 874656804,
 874540216,
 -1,
 -52189,
 874599566,
 128167,
 -1,
 874644285,
 129656,
 -52187,
 874603951,
 129316,
 -1,
 874797824,
 128042,
 874984488,
 874516905,
 128009,
 -1,
 874906076,
 128050,
 -52183,
 874942618,
 129345,
 -1,
 875049711,
 128087,
 875246640,
 874454534,
 -1,
 -52180,
 875199716,
 983161,
 -52179,
 875236310,
 983090,
 -52178,
 875301661,
 983088,
 -52177,
 875366981,
 983086,
 -1,
 875432361,
 983084,
 -52175,
 875205676,
 128192,
 -52174,
 875585243,
 129516,
 -1,
 875647491,
 983082,
 875836777,
 847746039,
 -1,
 875902261,
 875789540,
 -1,
 875967652,
 875825577,
 983240,
 876033089,
 875892441,
 983270,
 -52168,
 875957977,
 983450,
 -52167,
 876023386,
 983449,
 -52166,
 876088756,
 983448,
 -52165,
 876154140,
 983447,
 -52164,
 876219506,
 983446,
 -52163,
 876284886,
 983445,
 -52162,
 876350237,
 983444,
 -52161,
 876415557,
 983443,
 -52160,
 876480937,
 983442,
 -1,
 876546329,
 983441,
 876753996,
 875957850,
 983269,
 -52157,
 876678873,
 983440,
 -52156,
 876744282,
 983439,
 -52155,
 876809652,
 983438,
 -52154,
 876875036,
 983437,
 -52153,
 876940402,
 983436,
 -52152,
 877005782,
 983435,
 -52151,
 877071133,
 983434,
 -52150,
 877136453,
 983433,
 -52149,
 877201833,
 983432,
 -1,
 877267225,
 983431,
 877474903,
 876678580,
 983268,
 -52146,
 877399769,
 983430,
 -52145,
 877465178,
 983429,
 -52144,
 877530548,
 983428,
 -52143,
 877595932,
 983427,
 -52142,
 877661298,
 983426,
 -52141,
 877726678,
 983425,
 -52140,
 877792029,
 983424,
 -52139,
 877857349,
 983423,
 -52138,
 877922729,
 983422,
 -1,
 877988121,
 983421,
 878195810,
 877399324,
 983255,
 -52135,
 878120665,
 983420,
 -52134,
 878186074,
 983419,
 -52133,
 878251444,
 983418,
 -52132,
 878316828,
 983417,
 -52131,
 878382194,
 983416,
 -52130,
 878447574,
 983415,
 -52129,
 878512925,
 983414,
 -52128,
 878578245,
 983413,
 -52127,
 878643625,
 983412,
 -1,
 878709017,
 983411,
 878916717,
 878120050,
 983254,
 -52124,
 878841561,
 983410,
 -52123,
 878906970,
 983409,
 -52122,
 878972340,
 983408,
 -52121,
 879037724,
 983407,
 -52120,
 879103090,
 983406,
 -52119,
 879168470,
 983405,
 -52118,
 879233821,
 983404,
 -52117,
 879299141,
 983403,
 -52116,
 879364521,
 983402,
 -1,
 879429913,
 983401,
 879637624,
 878840790,
 983253,
 -52113,
 879562457,
 983400,
 -52112,
 879627866,
 983399,
 -52111,
 879693236,
 983398,
 -52110,
 879758620,
 983397,
 -52109,
 879823986,
 983396,
 -52108,
 879889366,
 983395,
 -52107,
 879954717,
 983394,
 -52106,
 880020037,
 983393,
 -52105,
 880085417,
 983392,
 -1,
 880150809,
 983391,
 880358531,
 879561501,
 983252,
 -52102,
 880283353,
 983390,
 -52101,
 880348762,
 983389,
 -52100,
 880414132,
 983388,
 -52099,
 880479516,
 983387,
 -52098,
 880544882,
 983386,
 -52097,
 880610262,
 983385,
 -52096,
 880675613,
 983384,
 -52095,
 880740933,
 983383,
 -52094,
 880806313,
 983382,
 -1,
 880871705,
 983381,
 881079438,
 880282181,
 983251,
 -52091,
 881004249,
 983380,
 -52090,
 881069658,
 983379,
 -52089,
 881135028,
 983378,
 -52088,
 881200412,
 983377,
 -52087,
 881265778,
 983376,
 -52086,
 881331158,
 983375,
 -52085,
 881396509,
 983374,
 -52084,
 881461829,
 983373,
 -52083,
 881527209,
 983372,
 -1,
 881592601,
 983371,
 881800345,
 881002921,
 983250,
 -52080,
 881725145,
 983370,
 -52079,
 881790554,
 983369,
 -52078,
 881855924,
 983368,
 -52077,
 881921308,
 983367,
 -52076,
 881986674,
 983366,
 -52075,
 882052054,
 983365,
 -52074,
 882117405,
 983364,
 -52073,
 882182725,
 983363,
 -52072,
 882248105,
 983362,
 -1,
 882313497,
 983361,
 882573311,
 881723673,
 983249,
 -52069,
 882446041,
 983360,
 -52068,
 882511450,
 983359,
 -52067,
 882576820,
 983358,
 -52066,
 882642204,
 983357,
 -52065,
 882707570,
 983356,
 -52064,
 882772950,
 983355,
 -52063,
 882838301,
 983354,
 -52062,
 882903621,
 983353,
 -52061,
 882969001,
 983352,
 -1,
 883034393,
 983351,
 883242216,
 875891269,
 983241,
 883307696,
 883166166,
 983275,
 -52057,
 883232473,
 983500,
 -52056,
 883297882,
 983499,
 -52055,
 883363252,
 983498,
 -52054,
 883428636,
 983497,
 -52053,
 883494002,
 983496,
 -52052,
 883559382,
 983495,
 -52051,
 883624733,
 983494,
 -52050,
 883690053,
 983493,
 -52049,
 883755433,
 983492,
 -1,
 883820825,
 983491,
 884028603,
 883231517,
 983274,
 -52046,
 883953369,
 983490,
 -52045,
 884018778,
 983489,
 -52044,
 884084148,
 983488,
 -52043,
 884149532,
 983487,
 -52042,
 884214898,
 983486,
 -52041,
 884280278,
 983485,
 -52040,
 884345629,
 983484,
 -52039,
 884410949,
 983483,
 -52038,
 884476329,
 983482,
 -1,
 884541721,
 983481,
 884749510,
 883952197,
 983273,
 -52035,
 884674265,
 983480,
 -52034,
 884739674,
 983479,
 -52033,
 884805044,
 983478,
 -52032,
 884870428,
 983477,
 -52031,
 884935794,
 983476,
 -52030,
 885001174,
 983475,
 -52029,
 885066525,
 983474,
 -52028,
 885131845,
 983473,
 -52027,
 885197225,
 983472,
 -1,
 885262617,
 983471,
 885470417,
 884672937,
 983272,
 -52024,
 885395161,
 983470,
 -52023,
 885460570,
 983469,
 -52022,
 885525940,
 983468,
 -52021,
 885591324,
 983467,
 -52020,
 885656690,
 983466,
 -52019,
 885722070,
 983465,
 -52018,
 885787421,
 983464,
 -52017,
 885852741,
 983463,
 -52016,
 885918121,
 983462,
 -1,
 885983513,
 983461,
 886191324,
 885393689,
 983271,
 -52013,
 886116057,
 983460,
 -52012,
 886181466,
 983459,
 -52011,
 886246836,
 983458,
 -52010,
 886312220,
 983457,
 -52009,
 886377586,
 983456,
 -52008,
 886442966,
 983455,
 -52007,
 886508317,
 983454,
 -52006,
 886573637,
 983453,
 -52005,
 886639017,
 983452,
 -1,
 886704409,
 983451,
 886912228,
 886115442,
 983276,
 -52002,
 886836508,
 983507,
 -52001,
 886901874,
 983506,
 -52000,
 886967254,
 983505,
 -51999,
 887032605,
 983504,
 -51998,
 887097925,
 983503,
 -51997,
 887163305,
 983502,
 -1,
 887228697,
 983501,
 -51995,
 886836953,
 983280,
 -51994,
 887361114,
 983279,
 -51993,
 887426484,
 983278,
 -1,
 887491868,
 983277,
 887698675,
 883166937,
 983248,
 -51990,
 887623385,
 983350,
 -51989,
 887688794,
 983349,
 -51988,
 887754164,
 983348,
 -51987,
 887819548,
 983347,
 -51986,
 887884914,
 983346,
 -51985,
 887950294,
 983345,
 -51984,
 888015645,
 983344,
 -51983,
 888080965,
 983343,
 -51982,
 888146345,
 983342,
 -1,
 888211737,
 983341,
 888419582,
 887623258,
 983247,
 -51979,
 888344281,
 983340,
 -51978,
 888409690,
 983339,
 -51977,
 888475060,
 983338,
 -51976,
 888540444,
 983337,
 -51975,
 888605810,
 983336,
 -51974,
 888671190,
 983335,
 -51973,
 888736541,
 983334,
 -51972,
 888801861,
 983333,
 -51971,
 888867241,
 983332,
 -1,
 888932633,
 983331,
 889140489,
 888343988,
 983246,
 -51968,
 889065177,
 983330,
 -51967,
 889130586,
 983329,
 -51966,
 889195956,
 983328,
 -51965,
 889261340,
 983327,
 -51964,
 889326706,
 983326,
 -51963,
 889392086,
 983325,
 -51962,
 889457437,
 983324,
 -51961,
 889522757,
 983323,
 -51960,
 889588137,
 983322,
 -1,
 889653529,
 983321,
 889861396,
 889064732,
 983245,
 -51957,
 889786073,
 983320,
 -51956,
 889851482,
 983319,
 -51955,
 889916852,
 983318,
 -51954,
 889982236,
 983317,
 -51953,
 890047602,
 983316,
 -51952,
 890112982,
 983315,
 -51951,
 890178333,
 983314,
 -51950,
 890243653,
 983313,
 -51949,
 890309033,
 983312,
 -1,
 890374425,
 983311,
 890582303,
 889785458,
 983244,
 -51946,
 890506969,
 983310,
 -51945,
 890572378,
 983309,
 -51944,
 890637748,
 983308,
 -51943,
 890703132,
 983307,
 -51942,
 890768498,
 983306,
 -51941,
 890833878,
 983305,
 -51940,
 890899229,
 983304,
 -51939,
 890964549,
 983303,
 -51938,
 891029929,
 983302,
 -1,
 891095321,
 983301,
 891303210,
 890506198,
 983243,
 -51935,
 891227865,
 983300,
 -51934,
 891293274,
 983299,
 -51933,
 891358644,
 983298,
 -51932,
 891424028,
 983297,
 -51931,
 891489394,
 983296,
 -51930,
 891554774,
 983295,
 -51929,
 891620125,
 983294,
 -51928,
 891685445,
 983293,
 -51927,
 891750825,
 983292,
 -1,
 891816217,
 983291,
 892076031,
 891226909,
 983242,
 -51924,
 891948761,
 983290,
 -51923,
 892014170,
 983289,
 -51922,
 892079540,
 983288,
 -51921,
 892144924,
 983287,
 -51920,
 892210290,
 983286,
 -51919,
 892275670,
 983285,
 -51918,
 892341021,
 983284,
 -51917,
 892406341,
 983283,
 -51916,
 892471721,
 983282,
 -1,
 892537113,
 983281,
 892745050,
 875834539,
 -1,
 892810575,
 892695465,
 -1,
 892876103,
 892771565,
 -1,
 892941638,
 892813025,
 -1,
 893007165,
 892894436,
 -1,
 -51909,
 892954019,
 128636,
 -51908,
 893013051,
 128953,
 -1,
 893063997,
 128941,
 893269312,
 892967111,
 -1,
 -51905,
 893223857,
 128914,
 -1,
 893264185,
 128904,
 893465923,
 893202276,
 -1,
 -51902,
 893420445,
 128959,
 -1,
 893480999,
 128976,
 -51900,
 893417277,
 128637,
 -51899,
 893598750,
 128934,
 -1,
 893662897,
 128947,
 -1,
 892869749,
 128933,
 893976575,
 892832173,
 -1,
 893990222,
 893879907,
 -1,
 894055757,
 893915104,
 -1,
 894121292,
 894013538,
 983069,
 -1,
 894043307,
 983143,
 -1,
 894042739,
 11135,
 -1,
 894006322,
 128678,
 -1,
 893944279,
 11837,
 894500863,
 892741872,
 -1,
 894514518,
 894402891,
 -1,
 -51886,
 894472652,
 7414,
 -51885,
 894532562,
 7411,
 -51884,
 894586157,
 7413,
 -51883,
 894642668,
 7418,
 -1,
 894703551,
 7415,
 894959615,
 894470862,
 -1,
 -51880,
 894859729,
 7416,
 -51879,
 894905007,
 7417,
 -1,
 894967440,
 7412,
 895169890,
 892682890,
 -1,
 895235424,
 895100957,
 -1,
 895300959,
 895156224,
 -1,
 -51874,
 895236579,
 127918,
 -1,
 895295086,
 128249,
 -1,
 895229732,
 128252,
 -51871,
 895182250,
 127931,
 -1,
 895491352,
 128243,
 895694180,
 895125091,
 983070,
 -1,
 895646948,
 983144,
 895825255,
 895640977,
 -1,
 -51866,
 895767894,
 127952,
 -1,
 895819451,
 127755,
 -51864,
 895783018,
 11238,
 -1,
 895947661,
 129499,
 896153316,
 875796246,
 -1,
 896218677,
 896077668,
 -1,
 896284120,
 896169152,
 -1,
 896349588,
 896238126,
 -1,
 896415090,
 896310507,
 -1,
 896480624,
 896372255,
 71875,
 -1,
 896421045,
 71886,
 -51855,
 896426987,
 71877,
 -1,
 896536420,
 71876,
 896742776,
 896351381,
 -1,
 896808310,
 896689131,
 -1,
 -51851,
 896760886,
 71899,
 -1,
 896816936,
 71898,
 -51849,
 896748696,
 71897,
 -1,
 896931184,
 71900,
 897135996,
 896667492,
 71873,
 -51846,
 897091171,
 71893,
 -51845,
 897147058,
 71882,
 -1,
 897210659,
 71894,
 897398144,
 897068203,
 71880,
 897515519,
 897343103,
 -1,
 -51841,
 897424619,
 71885,
 -1,
 897474175,
 71888,
 897660291,
 897355295,
 -1,
 -51838,
 897617439,
 71879,
 -1,
 897654278,
 71887,
 897856902,
 897613028,
 -1,
 -51835,
 897811949,
 71901,
 -1,
 897861021,
 71902,
 898053512,
 897803243,
 71881,
 -1,
 897984408,
 71889,
 898184587,
 897998463,
 -1,
 -51830,
 898142464,
 71891,
 -1,
 898185634,
 71872,
 -51828,
 898144595,
 71874,
 -51827,
 898340443,
 71903,
 -51826,
 898403525,
 71890,
 -51825,
 898462117,
 71896,
 -51824,
 898518846,
 71884,
 -51823,
 898581917,
 71878,
 -51822,
 898644383,
 71883,
 -51821,
 898705134,
 71892,
 -1,
 898768272,
 71895,
 898971068,
 896278213,
 -1,
 899036570,
 898931947,
 -1,
 899102104,
 898993695,
 71843,
 -1,
 899042485,
 71854,
 -51815,
 899048427,
 71845,
 -1,
 899157860,
 71844,
 899364256,
 898972821,
 -1,
 899429790,
 899310571,
 -1,
 -51811,
 899382326,
 71867,
 -1,
 899438376,
 71866,
 -51809,
 899370136,
 71865,
 -1,
 899552624,
 71868,
 899757476,
 899288932,
 71841,
 -51806,
 899712611,
 71861,
 -51805,
 899768498,
 71850,
 -1,
 899832099,
 71862,
 900019624,
 899689643,
 71848,
 900136959,
 899964543,
 -1,
 -51801,
 900046059,
 71853,
 -1,
 900095615,
 71856,
 900281771,
 899976735,
 -1,
 -51798,
 900238879,
 71847,
 -1,
 900275718,
 71855,
 900478382,
 900234468,
 -1,
 -51795,
 900433389,
 71869,
 -1,
 900482461,
 71870,
 900674992,
 900424683,
 71849,
 -1,
 900605848,
 71857,
 900806067,
 900619903,
 -1,
 -51790,
 900763904,
 71859,
 -1,
 900807074,
 71840,
 -51788,
 900766035,
 71842,
 -51787,
 900961883,
 71871,
 -51786,
 901024965,
 71858,
 -51785,
 901083557,
 71864,
 -51784,
 901140286,
 71852,
 -51783,
 901203357,
 71846,
 -51782,
 901265823,
 71851,
 -51781,
 901326574,
 71860,
 -1,
 901389712,
 71863,
 901592522,
 898902275,
 -1,
 901658048,
 901547619,
 -1,
 -51777,
 901618434,
 71906,
 -1,
 901661026,
 71907,
 901854659,
 901610724,
 -1,
 -51774,
 901794861,
 71910,
 -1,
 901854151,
 71911,
 902051270,
 901788855,
 -1,
 -51771,
 901999330,
 71908,
 -1,
 902056847,
 71909,
 -51769,
 902012910,
 71904,
 -51768,
 902194861,
 71905,
 -51767,
 902259007,
 71913,
 -1,
 902311774,
 71912,
 902510039,
 901538682,
 -1,
 902575567,
 902465123,
 -1,
 -51763,
 902535267,
 71915,
 -51762,
 902578279,
 71916,
 -1,
 902639696,
 71914,
 902837714,
 902528228,
 -1,
 -51759,
 902777971,
 71919,
 -1,
 902837248,
 71920,
 903034325,
 902771895,
 -1,
 -51756,
 902982047,
 71917,
 -1,
 903038002,
 71918,
 -51754,
 902979960,
 71922,
 -1,
 903163813,
 71921,
 -1,
 902456786,
 71935,
 903427621,
 896228991,
 -1,
 903493154,
 903356682,
 -1,
 903558670,
 903435417,
 -1,
 903624161,
 903483236,
 123585,
 903689695,
 903548772,
 123584,
 903806975,
 903634559,
 123624,
 -1,
 903690598,
 123619,
 -51744,
 903646751,
 123606,
 -1,
 903831730,
 123620,
 904017382,
 903579235,
 -1,
 -51741,
 903970174,
 123616,
 -51740,
 904033277,
 123617,
 -51739,
 904084643,
 123596,
 -1,
 904138596,
 123595,
 904345065,
 903963627,
 123605,
 904462335,
 904289919,
 123622,
 -1,
 904345958,
 123618,
 904541677,
 904289919,
 -1,
 -51733,
 904502617,
 123625,
 -51732,
 904542623,
 123613,
 -1,
 904597348,
 123593,
 904803824,
 904502507,
 -1,
 -51729,
 904742298,
 123627,
 -1,
 904793956,
 123590,
 905000434,
 904760863,
 123614,
 -1,
 904933456,
 123626,
 905131509,
 904953060,
 -1,
 -51724,
 905067683,
 123599,
 -1,
 905121636,
 123598,
 905328120,
 905079992,
 -1,
 -51721,
 905264291,
 123591,
 -1,
 905318244,
 123594,
 905524731,
 905269196,
 -1,
 -51718,
 905467274,
 123615,
 -1,
 905514852,
 123592,
 905721342,
 905465219,
 -1,
 -51715,
 905657507,
 123609,
 -1,
 905711460,
 123604,
 905917952,
 905659018,
 123612,
 -1,
 905863346,
 123621,
 906049026,
 905850027,
 123611,
 -1,
 905993855,
 123623,
 -51709,
 906010465,
 123601,
 -51708,
 906139438,
 123602,
 -51707,
 906204169,
 123603,
 -51706,
 906261501,
 123607,
 -51705,
 906320237,
 123608,
 -51704,
 906382554,
 123600,
 -51703,
 906443939,
 123610,
 -51702,
 906508703,
 123589,
 -51701,
 906573019,
 123597,
 -51700,
 906634990,
 123588,
 -51699,
 906698274,
 123587,
 -1,
 906762449,
 123586,
 906966556,
 903489795,
 -1,
 907032082,
 906921571,
 -1,
 -51695,
 906992386,
 123634,
 -1,
 907034978,
 123635,
 907228693,
 906984676,
 -1,
 -51692,
 907168813,
 123638,
 -1,
 907228103,
 123639,
 907425304,
 907162807,
 -1,
 -51689,
 907373282,
 123636,
 -1,
 907430799,
 123637,
 -51687,
 907386862,
 123632,
 -51686,
 907568813,
 123633,
 -51685,
 907632959,
 123641,
 -1,
 907685726,
 123640,
 907884065,
 906922702,
 -1,
 907949599,
 907840769,
 123628,
 -1,
 907895068,
 123629,
 908132351,
 907890501,
 123630,
 -1,
 908026140,
 123631,
 -1,
 907829522,
 123647,
 908328959,
 903432030,
 -1,
 -51676,
 908213057,
 127766,
 -1,
 908272881,
 127768,
 908473900,
 903383065,
 -1,
 908539435,
 908394496,
 -1,
 -51672,
 908498891,
 127754,
 -51671,
 908554372,
 129341,
 -51670,
 908599951,
 128702,
 -1,
 908664215,
 128003,
 -1,
 908483495,
 127817,
 908932656,
 908432943,
 -1,
 -51666,
 908892417,
 127987,
 -51665,
 908934573,
 128075,
 -1,
 908991397,
 127988,
 909194803,
 908893336,
 -1,
 -51662,
 909130561,
 127764,
 -1,
 909190385,
 127762,
 -51660,
 909149357,
 128465,
 -1,
 909325741,
 129479,
 909522571,
 896154773,
 -1,
 909588106,
 909462360,
 -1,
 909653602,
 909516294,
 -1,
 909719137,
 909590397,
 -1,
 909784651,
 909659523,
 -1,
 909850184,
 909730083,
 -1,
 909915716,
 909771882,
 -1,
 909981249,
 909870691,
 -1,
 910046784,
 909941537,
 -1,
 -51649,
 910003601,
 129584,
 -1,
 910065523,
 129591,
 -1,
 909984144,
 129605,
 -51646,
 909928139,
 129563,
 -51645,
 910254463,
 129549,
 -1,
 910309301,
 129542,
 910557183,
 909838432,
 -1,
 -51642,
 910457775,
 129615,
 -51641,
 910521156,
 129614,
 -1,
 910564159,
 129616,
 910819327,
 909789184,
 -1,
 -51638,
 910724572,
 129587,
 -1,
 910778751,
 129545,
 910964307,
 909741330,
 -1,
 911029839,
 910904707,
 -1,
 -51634,
 910975267,
 129570,
 -1,
 911034202,
 129566,
 -51632,
 910982063,
 129568,
 -51631,
 911176516,
 129567,
 -51630,
 911240754,
 129571,
 -1,
 911285055,
 129569,
 911488598,
 910916532,
 -1,
 -51627,
 911445468,
 129589,
 -1,
 911499647,
 129547,
 911685209,
 911438676,
 -1,
 -51624,
 911642076,
 129588,
 -1,
 911696255,
 129546,
 911881820,
 911633975,
 -1,
 -51621,
 911838684,
 129592,
 -1,
 911892863,
 129550,
 912078430,
 911815117,
 129608,
 -1,
 912000116,
 129611,
 912261119,
 912005958,
 -1,
 -51616,
 912166364,
 129590,
 -1,
 912220543,
 129548,
 -1,
 909658597,
 128906,
 912471661,
 909606116,
 -1,
 912537192,
 912429244,
 127779,
 912654335,
 912457728,
 -1,
 912668263,
 912529931,
 127781,
 -1,
 912590770,
 127782,
 -1,
 912628302,
 127780,
 912916479,
 912487145,
 -1,
 912930412,
 912794656,
 -1,
 -51605,
 912889255,
 128916,
 -1,
 912939850,
 128917,
 -1,
 912858607,
 128307,
 913192564,
 912402018,
 -1,
 913258097,
 913140853,
 -1,
 -51600,
 913199834,
 128407,
 -1,
 913250566,
 128071,
 913506303,
 913195852,
 -1,
 -51597,
 913413524,
 128922,
 -1,
 913464110,
 128923,
 913651320,
 913133516,
 -1,
 -51594,
 913599634,
 128928,
 -51593,
 913649408,
 128072,
 -1,
 913709006,
 128326,
 913913469,
 913587349,
 -1,
 913979004,
 913845556,
 -1,
 -51589,
 913938184,
 9989,
 -1,
 913996933,
 129293,
 -1,
 913905077,
 128427,
 914241152,
 913847479,
 -1,
 -51585,
 914189102,
 11214,
 -1,
 914249836,
 128174,
 914437763,
 914167403,
 -1,
 -51582,
 914394616,
 129197,
 -1,
 914450093,
 129196,
 -51580,
 914395476,
 128070,
 -51579,
 914590536,
 128382,
 -51578,
 914651205,
 128073,
 -51577,
 914715525,
 10068,
 -51576,
 914779809,
 127985,
 -51575,
 914840999,
 11229,
 -1,
 914895966,
 10069,
 -1,
 909513356,
 128011,
 915158728,
 909460106,
 -1,
 915224255,
 915089378,
 -1,
 915289754,
 915178287,
 -1,
 915355284,
 915249284,
 -1,
 -51568,
 915314017,
 129159,
 -51567,
 915364636,
 129143,
 -51566,
 915428839,
 129127,
 -51565,
 915488488,
 129151,
 -1,
 915544455,
 129135,
 915800063,
 915287413,
 -1,
 -51562,
 915707233,
 129158,
 -51561,
 915757852,
 129142,
 -51560,
 915822055,
 129126,
 -51559,
 915881704,
 129150,
 -1,
 915937671,
 129134,
 916141735,
 915235416,
 -1,
 916207265,
 916101252,
 -1,
 -51555,
 916165985,
 129156,
 -51554,
 916216604,
 129140,
 -51553,
 916280807,
 129124,
 -51552,
 916340456,
 129148,
 -1,
 916396423,
 129132,
 916652031,
 916139381,
 -1,
 -51549,
 916559201,
 129157,
 -51548,
 916609820,
 129141,
 -51547,
 916674023,
 129125,
 -51546,
 916733672,
 129149,
 -1,
 916789639,
 129133,
 916993709,
 916099625,
 -1,
 -51543,
 916952417,
 129153,
 -51542,
 917003036,
 129137,
 -51541,
 917067239,
 129121,
 -51540,
 917126888,
 129145,
 -1,
 917182855,
 129129,
 917386931,
 916945211,
 -1,
 -51537,
 917345633,
 129154,
 -51536,
 917396252,
 129138,
 -51535,
 917460455,
 129122,
 -51534,
 917520104,
 129146,
 -1,
 917576071,
 129130,
 917780153,
 917328834,
 -1,
 -51531,
 917738849,
 129152,
 -51530,
 917789468,
 129136,
 -51529,
 917853671,
 129120,
 -51528,
 917913320,
 129144,
 -1,
 917969287,
 129128,
 918224895,
 917711772,
 -1,
 -51525,
 918132065,
 129155,
 -51524,
 918182684,
 129139,
 -51523,
 918246887,
 129123,
 -51522,
 918306536,
 129147,
 -1,
 918362503,
 129131,
 918566597,
 915168895,
 -1,
 918632131,
 918496868,
 -1,
 -51518,
 918560992,
 127888,
 -1,
 918625339,
 127788,
 -51516,
 918572791,
 128521,
 -1,
 918760653,
 127863,
 -51514,
 918517284,
 128430,
 -51513,
 918902984,
 129344,
 -1,
 918960845,
 11838,
 919156438,
 915104747,
 -1,
 919221970,
 919099683,
 -1,
 919287505,
 919147424,
 128105,
 919353040,
 919239910,
 -1,
 -51507,
 919305689,
 128097,
 -51506,
 919354942,
 128082,
 -51505,
 919413398,
 128090,
 -1,
 919477423,
 128098,
 -1,
 919274986,
 128111,
 -1,
 919220481,
 128698,
 919811797,
 919172009,
 -1,
 -51500,
 919762881,
 128543,
 -1,
 919818694,
 128506,
 -1,
 919754096,
 128058,
 920073950,
 919088299,
 -1,
 920139482,
 920011402,
 -1,
 -51495,
 920075052,
 127947,
 -1,
 920138385,
 983234,
 920336093,
 920065753,
 -1,
 -51492,
 920270046,
 128553,
 -1,
 920330036,
 128576,
 -1,
 920266660,
 128146,
 920598243,
 920023977,
 -1,
 920663778,
 920530091,
 -1,
 -51487,
 920618215,
 129340,
 -1,
 920674121,
 128295,
 -1,
 920589657,
 127873,
 -1,
 920538293,
 983229,
 920991794,
 896088422,
 -1,
 921057128,
 920941481,
 -1,
 921122635,
 920981348,
 -1,
 921188169,
 921068376,
 -1,
 921253675,
 921130137,
 -1,
 921319155,
 921211895,
 -1,
 921384687,
 921265231,
 -1,
 921450221,
 921334697,
 70411,
 -1,
 921400233,
 70496,
 921632767,
 921391052,
 70412,
 -1,
 921522124,
 70497,
 921712370,
 921316943,
 -1,
 -51471,
 921643484,
 70495,
 -1,
 921703689,
 70494,
 -1,
 921636708,
 70453,
 921974521,
 921273955,
 -1,
 922040055,
 921929315,
 -1,
 -51466,
 921975971,
 70432,
 -1,
 922029924,
 70431,
 -51464,
 921975971,
 70437,
 -1,
 922160996,
 70436,
 922367742,
 921919103,
 -1,
 -51461,
 922328409,
 70430,
 -51460,
 922377944,
 70435,
 -51459,
 922433951,
 70425,
 -1,
 922488676,
 70440,
 922695428,
 922297954,
 -1,
 922760962,
 922625634,
 -1,
 -51455,
 922696867,
 70434,
 -1,
 922750820,
 70433,
 -51453,
 922696867,
 70439,
 -1,
 922881892,
 70438,
 923088648,
 922619748,
 70405,
 -51450,
 923045407,
 70420,
 -51449,
 923091594,
 70416,
 -1,
 923144036,
 70406,
 923350796,
 923040996,
 -1,
 -51446,
 923303294,
 70455,
 -51445,
 923352227,
 70454,
 -1,
 923406180,
 70456,
 923612942,
 923307551,
 70409,
 -1,
 923569695,
 70410,
 923744017,
 923561144,
 -1,
 -51440,
 923679907,
 70443,
 -1,
 923733860,
 70442,
 923940628,
 923684812,
 -1,
 -51437,
 923881502,
 70451,
 -1,
 923930468,
 70450,
 924137239,
 923880835,
 -1,
 -51434,
 924073123,
 70422,
 -1,
 924127076,
 70421,
 924333850,
 924077237,
 -1,
 -51431,
 924269731,
 70429,
 -1,
 924323684,
 70428,
 924530460,
 924271242,
 70407,
 -1,
 924467850,
 70408,
 924661535,
 924465510,
 -1,
 -51426,
 924597411,
 70424,
 -1,
 924651364,
 70423,
 924858146,
 924589574,
 -1,
 -51423,
 924794019,
 70427,
 -1,
 924847972,
 70426,
 925054757,
 924784832,
 -1,
 -51420,
 924990627,
 70445,
 -1,
 925044580,
 70444,
 -51418,
 925015385,
 70447,
 -51417,
 925201405,
 70448,
 -51416,
 925263900,
 70419,
 -51415,
 925325677,
 70446,
 -51414,
 925383843,
 70457,
 -1,
 925445743,
 70415,
 925644603,
 921212644,
 -1,
 925710129,
 925603434,
 -1,
 925775663,
 925660073,
 70467,
 -1,
 925725609,
 70468,
 925958143,
 925716428,
 70498,
 -1,
 925847500,
 70499,
 926037813,
 925634404,
 -1,
 -51405,
 925994527,
 70476,
 -51404,
 926040714,
 70472,
 -1,
 926093156,
 70462,
 926299959,
 925994527,
 70465,
 -1,
 926256671,
 70466,
 926431033,
 926237322,
 70463,
 -1,
 926368394,
 70464,
 -51398,
 926378012,
 70475,
 -1,
 926494319,
 70471,
 926693191,
 925598027,
 -1,
 926758719,
 926651875,
 -1,
 -51394,
 926711341,
 70403,
 -1,
 926774454,
 70477,
 926955330,
 926686726,
 -1,
 -51391,
 926901774,
 70400,
 -1,
 926946378,
 70401,
 927151941,
 926879588,
 -1,
 -51388,
 927110156,
 70461,
 -1,
 927163331,
 70402,
 -51386,
 927100943,
 70493,
 -1,
 927294324,
 70460,
 -51384,
 926639570,
 70480,
 -1,
 927406124,
 70487,
 -51382,
 921136903,
 127815,
 -1,
 927542353,
 127891,
 927741785,
 921054831,
 -1,
 927807316,
 927681925,
 -1,
 927872848,
 927759588,
 -1,
 -51377,
 927833808,
 65952,
 -1,
 927877390,
 65932,
 -51375,
 927819527,
 65931,
 -51374,
 928011514,
 43877,
 -51373,
 928073534,
 65933,
 -1,
 928128754,
 895,
 928382975,
 927751809,
 -1,
 -51370,
 928284071,
 129367,
 -51369,
 928333494,
 128154,
 -51368,
 928390314,
 128215,
 -1,
 928453991,
 127823,
 928659299,
 927679114,
 -1,
 928724834,
 928604644,
 -1,
 928790369,
 928658654,
 128512,
 928907263,
 928712145,
 -1,
 928921440,
 928808164,
 -1,
 -51361,
 928876410,
 129321,
 -1,
 928931005,
 128513,
 -1,
 928868075,
 129322,
 -1,
 928718694,
 128568,
 -1,
 928668036,
 128556,
 929366015,
 928605163,
 -1,
 929380199,
 929272105,
 -1,
 -51354,
 929332990,
 983109,
 -1,
 929389138,
 11218,
 -1,
 929339768,
 128151,
 929642447,
 921013791,
 -1,
 929707966,
 929587634,
 -1,
 929773471,
 929649817,
 -1,
 929838961,
 929728099,
 -1,
 929904495,
 929793635,
 -1,
 -51346,
 929840291,
 73086,
 -1,
 929894244,
 73085,
 -51344,
 929840291,
 73076,
 -1,
 930025316,
 73075,
 930232183,
 929769058,
 -1,
 930297717,
 930162274,
 -1,
 -51340,
 930233507,
 73091,
 -1,
 930287460,
 73090,
 -51338,
 930233507,
 73081,
 -1,
 930418532,
 73080,
 930625403,
 930156388,
 73056,
 -51335,
 930582047,
 73067,
 -51334,
 930628234,
 73064,
 -1,
 930680676,
 73057,
 930887549,
 930582047,
 73060,
 -1,
 930844191,
 73061,
 931018624,
 930835640,
 -1,
 -51329,
 930954403,
 73094,
 -1,
 931008356,
 73093,
 931215235,
 930963071,
 -1,
 -51326,
 931150239,
 73092,
 -1,
 931204964,
 73082,
 931411846,
 931155916,
 -1,
 -51323,
 931352606,
 73087,
 -1,
 931401572,
 73077,
 931608457,
 931351939,
 -1,
 -51320,
 931544227,
 73074,
 -1,
 931598180,
 73073,
 931805068,
 931548341,
 -1,
 -51317,
 931740835,
 73089,
 -1,
 931794788,
 73088,
 932001678,
 931742346,
 73058,
 -1,
 931938954,
 73059,
 932132753,
 931936614,
 -1,
 -51312,
 932068515,
 73079,
 -1,
 932122468,
 73078,
 932329364,
 932060678,
 -1,
 -51309,
 932265123,
 73084,
 -1,
 932319076,
 73083,
 932525975,
 932255936,
 -1,
 -51306,
 932461731,
 73071,
 -1,
 932515684,
 73070,
 -51304,
 932486489,
 73068,
 -51303,
 932680713,
 73069,
 -51302,
 932740478,
 73097,
 -51301,
 932803581,
 73096,
 -51300,
 932866076,
 73066,
 -51299,
 932927853,
 73072,
 -51298,
 932986019,
 73095,
 -1,
 933047919,
 73063,
 933246892,
 929731575,
 -1,
 933312427,
 933194854,
 -1,
 933377957,
 933236580,
 -1,
 -51293,
 933334559,
 73108,
 -51292,
 933380746,
 73105,
 -1,
 933433188,
 73098,
 933640103,
 933334559,
 73101,
 -1,
 933596703,
 73102,
 933771177,
 933577354,
 73099,
 -1,
 933708426,
 73100,
 -51286,
 933718044,
 73107,
 -1,
 933834351,
 73104,
 -1,
 933251545,
 73111,
 934098874,
 933177603,
 -1,
 934164400,
 934053475,
 -1,
 -51281,
 934124290,
 73122,
 -1,
 934166882,
 73123,
 934361011,
 934116580,
 -1,
 -51278,
 934300717,
 73126,
 -1,
 934360007,
 73127,
 934557622,
 934294711,
 -1,
 -51275,
 934505186,
 73124,
 -1,
 934562703,
 73125,
 -51273,
 934518766,
 73120,
 -51272,
 934700717,
 73121,
 -51271,
 934764863,
 73129,
 -1,
 934817630,
 73128,
 935016381,
 934052171,
 -1,
 -51268,
 934975046,
 73110,
 -1,
 935007497,
 73109,
 -1,
 934962642,
 73112,
 935278538,
 929647862,
 -1,
 935344072,
 935231819,
 -1,
 935409603,
 935298659,
 -1,
 -51262,
 935369558,
 2815,
 -1,
 935412188,
 2813,
 935606214,
 935361764,
 -1,
 -51259,
 935563344,
 2810,
 -1,
 935607480,
 2811,
 -51257,
 935549372,
 2812,
 -1,
 935731520,
 2814,
 -51255,
 935286046,
 2809,
 -1,
 935858185,
 2800,
 936064973,
 935215754,
 -1,
 -51252,
 936019830,
 127928,
 -1,
 936060854,
 129454,
 -51250,
 936016700,
 2678,
 -1,
 936187339,
 128130,
 936392732,
 929574059,
 -1,
 936458266,
 936339805,
 -1,
 936523791,
 936402472,
 -1,
 936589274,
 936459413,
 -1,
 936654807,
 936513380,
 -1,
 936720342,
 936604585,
 7348,
 -1,
 936650416,
 7358,
 -1,
 936651947,
 7344,
 -51240,
 936600759,
 7349,
 -51239,
 936854513,
 7346,
 -1,
 936914091,
 7345,
 937113568,
 936517126,
 -1,
 937179102,
 937049237,
 -1,
 -51235,
 937117226,
 7337,
 -1,
 937170288,
 7341,
 -51233,
 937117092,
 7340,
 -1,
 937300896,
 7338,
 937506789,
 937068131,
 -1,
 937572324,
 937430884,
 -1,
 -51229,
 937522089,
 7330,
 -1,
 937582207,
 7319,
 -1,
 937530066,
 7353,
 937834473,
 937430884,
 -1,
 -51225,
 937778815,
 7312,
 -51224,
 937838122,
 7354,
 -1,
 937898064,
 7357,
 938096620,
 937795373,
 -1,
 -51221,
 938032660,
 7327,
 -1,
 938094672,
 7318,
 938293231,
 938048740,
 -1,
 -51218,
 938229793,
 7336,
 -1,
 938283936,
 7329,
 938489842,
 938241208,
 -1,
 -51215,
 938425876,
 7332,
 -1,
 938481008,
 7326,
 938686453,
 938430494,
 -1,
 -51212,
 938638564,
 7322,
 -1,
 938678970,
 7359,
 938883064,
 938626435,
 -1,
 -51209,
 938819092,
 7333,
 -1,
 938873760,
 7321,
 939079675,
 938822837,
 -1,
 -51206,
 939017636,
 7339,
 -1,
 939081091,
 7343,
 939276286,
 939014502,
 -1,
 -51203,
 939212163,
 7334,
 -1,
 939266976,
 7314,
 939472897,
 939207851,
 -1,
 -51200,
 939417215,
 7316,
 -1,
 939480546,
 7352,
 -51198,
 939433703,
 7351,
 -51197,
 939629664,
 7342,
 -51196,
 939694124,
 7347,
 -51195,
 939759137,
 7317,
 -51194,
 939823292,
 7331,
 -51193,
 939881518,
 7328,
 -51192,
 939946646,
 7335,
 -51191,
 940009039,
 7325,
 -51190,
 940072726,
 7324,
 -51189,
 940137011,
 7323,
 -51188,
 940197418,
 7320,
 -51187,
 940258738,
 7350,
 -51186,
 940321165,
 7315,
 -1,
 940382566,
 7313,
 940587028,
 936465561,
 -1,
 -51183,
 940543605,
 983936,
 -51182,
 940593190,
 4351,
 -51181,
 940654125,
 4350,
 -1,
 940708110,
 4349,
 940914711,
 940540462,
 -1,
 -51178,
 940875495,
 11559,
 -1,
 940904718,
 11565,
 941162495,
 940842693,
 -1,
 -51175,
 941072103,
 4295,
 -1,
 941101326,
 4301,
 -51173,
 936403231,
 129502,
 -1,
 941250876,
 128142,
 941439011,
 936338411,
 -1,
 941504544,
 941363044,
 -1,
 -51169,
 941459043,
 128016,
 -1,
 941510616,
 129349,
 -51167,
 941455780,
 129421,
 -51166,
 941643128,
 127948,
 -1,
 941701815,
 129405,
 941897769,
 941379532,
 -1,
 941963304,
 941843435,
 -1,
 -51162,
 941922691,
 127775,
 -51161,
 941987257,
 129508,
 -1,
 942021071,
 127760,
 -1,
 941889345,
 129371,
 942290989,
 941836748,
 -1,
 942356524,
 942231500,
 128103,
 -1,
 942308694,
 128714,
 -1,
 942281060,
 129426,
 942553136,
 942215012,
 -1,
 -51153,
 942504748,
 129476,
 -1,
 942562036,
 127922,
 -51151,
 942505188,
 983110,
 -1,
 942686529,
 128123,
 942881126,
 920931715,
 -1,
 942946594,
 942816405,
 -1,
 943011983,
 942903216,
 -1,
 943077490,
 942953625,
 -1,
 943142973,
 943007330,
 -1,
 943208507,
 943072866,
 -1,
 -51143,
 943144099,
 70347,
 -51142,
 943204078,
 70345,
 -1,
 943263588,
 70344,
 -51140,
 943144099,
 70352,
 -1,
 943394660,
 70351,
 943601731,
 943097443,
 -1,
 943667265,
 943556195,
 -1,
 -51136,
 943602851,
 70343,
 -1,
 943656804,
 70342,
 -51134,
 943602851,
 70350,
 -1,
 943787876,
 70349,
 943994952,
 943545983,
 -1,
 -51131,
 943955289,
 70341,
 -51130,
 944004824,
 70348,
 -51129,
 944060831,
 70335,
 -1,
 944115556,
 70353,
 944322636,
 943918948,
 70320,
 -51126,
 944279071,
 70329,
 -51125,
 944325258,
 70327,
 -1,
 944377700,
 70321,
 944584784,
 944262325,
 -1,
 -51122,
 944524506,
 70339,
 -51121,
 944585891,
 70340,
 -1,
 944639844,
 70338,
 944846932,
 944519526,
 -1,
 -51118,
 944782499,
 70334,
 -51117,
 944847263,
 70333,
 -1,
 944901988,
 70332,
 945109080,
 944773312,
 -1,
 -51114,
 945044643,
 70358,
 -51113,
 945101009,
 70357,
 -1,
 945164132,
 70356,
 945371226,
 945065503,
 70324,
 -1,
 945327647,
 70325,
 945502301,
 945323236,
 -1,
 -51108,
 945437859,
 70364,
 -1,
 945491812,
 70365,
 945698912,
 945451945,
 -1,
 -51105,
 945648637,
 70346,
 -1,
 945688420,
 70361,
 945895523,
 945646776,
 -1,
 -51102,
 945831075,
 70355,
 -1,
 945885028,
 70354,
 946092134,
 945835395,
 -1,
 -51099,
 946027683,
 70331,
 -1,
 946081636,
 70330,
 946288744,
 946029194,
 70322,
 -1,
 946225802,
 70323,
 946419819,
 946216454,
 -1,
 -51094,
 946355363,
 70337,
 -1,
 946409316,
 70336,
 -51092,
 946380121,
 70360,
 -51091,
 946574345,
 70363,
 -51090,
 946627563,
 70328,
 -51089,
 946690413,
 70359,
 -51088,
 946753566,
 70362,
 -51087,
 946814115,
 70366,
 -1,
 946875563,
 70326,
 947075200,
 943008003,
 -1,
 947140726,
 947029603,
 -1,
 -51083,
 947100418,
 70386,
 -1,
 947143010,
 70387,
 947337337,
 947092708,
 -1,
 -51080,
 947276845,
 70390,
 -1,
 947336135,
 70391,
 947533948,
 947270839,
 -1,
 -51077,
 947481314,
 70388,
 -1,
 947538831,
 70389,
 -51075,
 947494894,
 70384,
 -51074,
 947676845,
 70385,
 -51073,
 947740991,
 70393,
 -1,
 947793758,
 70392,
 947992715,
 947033828,
 -1,
 948058245,
 947916644,
 -1,
 -51069,
 948014623,
 70376,
 -51068,
 948060810,
 70374,
 -1,
 948113252,
 70368,
 948320391,
 948014623,
 70371,
 -1,
 948276767,
 70372,
 948451465,
 948257418,
 70369,
 -1,
 948388490,
 70370,
 -51062,
 948397035,
 70375,
 -1,
 948513963,
 70373,
 948764671,
 947945803,
 -1,
 -51059,
 948672063,
 70378,
 -51058,
 948724596,
 70377,
 -1,
 948770057,
 70367,
 948975842,
 942957908,
 -1,
 949041352,
 948917401,
 -1,
 949106840,
 948971106,
 -1,
 949172374,
 949036642,
 -1,
 -51052,
 949107875,
 70167,
 -51051,
 949167854,
 70172,
 -1,
 949227364,
 70166,
 -51049,
 949107875,
 70173,
 -1,
 949358436,
 70171,
 949565598,
 949061219,
 -1,
 949631132,
 949519971,
 -1,
 -51045,
 949566627,
 70165,
 -1,
 949620580,
 70164,
 -51043,
 949566627,
 70170,
 -1,
 949751652,
 70169,
 949958819,
 949509759,
 -1,
 -51040,
 949919065,
 70163,
 -51039,
 949968600,
 70168,
 -51038,
 950024607,
 70157,
 -1,
 950079332,
 70174,
 950286503,
 949882724,
 70144,
 -51035,
 950242847,
 70151,
 -51034,
 950289034,
 70149,
 -1,
 950341476,
 70145,
 950548651,
 950221158,
 -1,
 -51031,
 950484131,
 70156,
 -51030,
 950548895,
 70155,
 -1,
 950603620,
 70154,
 950810799,
 950474944,
 -1,
 -51027,
 950746275,
 70179,
 -51026,
 950802641,
 70178,
 -1,
 950865764,
 70177,
 951072946,
 950758584,
 -1,
 -51023,
 951008419,
 70176,
 -1,
 951062372,
 70175,
 951269557,
 951013324,
 -1,
 -51020,
 951210014,
 70187,
 -1,
 951258980,
 70183,
 951466168,
 951209347,
 -1,
 -51017,
 951401635,
 70153,
 -1,
 951455588,
 70152,
 951662779,
 951405749,
 -1,
 -51014,
 951602394,
 70161,
 -1,
 951652196,
 70160,
 951859390,
 951590406,
 -1,
 -51011,
 951794851,
 70159,
 -1,
 951848804,
 70158,
 -51009,
 951819609,
 70181,
 -51008,
 952013833,
 70184,
 -51007,
 952077855,
 70147,
 -51006,
 952139134,
 70185,
 -51005,
 952202237,
 70182,
 -51004,
 952263659,
 70150,
 -51003,
 952326509,
 70180,
 -51002,
 952386186,
 70146,
 -51001,
 952450211,
 70186,
 -1,
 952511659,
 70148,
 952711378,
 948999908,
 -1,
 952776909,
 952635236,
 -1,
 -50997,
 952733215,
 70195,
 -50996,
 952779402,
 70193,
 -1,
 952831844,
 70188,
 953039055,
 952713866,
 70189,
 -1,
 952976010,
 70190,
 -50992,
 952995359,
 70191,
 -50991,
 953115627,
 70194,
 -1,
 953167019,
 70192,
 953366747,
 952663268,
 -1,
 953432282,
 953304387,
 -1,
 953497815,
 953384164,
 -1,
 -50986,
 953454672,
 70206,
 -1,
 953498808,
 70199,
 -50984,
 953456191,
 70197,
 -50983,
 953639796,
 70198,
 -1,
 953685257,
 70196,
 -1,
 953363920,
 70203,
 953956576,
 953296482,
 -1,
 954022111,
 953903705,
 -1,
 -50978,
 953974397,
 70204,
 -1,
 954017637,
 70201,
 -1,
 953947194,
 70200,
 -50975,
 953916360,
 70202,
 -1,
 954208265,
 70205,
 954415389,
 948919262,
 -1,
 954480915,
 954344402,
 -1,
 954546413,
 954435171,
 -1,
 954611944,
 954501199,
 -1,
 -50969,
 954557419,
 983950,
 -1,
 954601316,
 983948,
 954808555,
 954547349,
 -1,
 -50966,
 954754027,
 983955,
 -1,
 954797924,
 983953,
 -50964,
 954754027,
 983954,
 -1,
 954928996,
 983952,
 955136242,
 954490495,
 -1,
 -50961,
 955096818,
 983946,
 -50960,
 955147243,
 983956,
 -50959,
 955202503,
 983941,
 -1,
 955256676,
 983951,
 955463928,
 955075971,
 -1,
 955529462,
 955399317,
 -1,
 -50955,
 955474923,
 983940,
 -1,
 955518820,
 983938,
 -50953,
 955474923,
 983939,
 -1,
 955649892,
 983937,
 955857150,
 955391494,
 -1,
 955922684,
 955792533,
 -1,
 -50949,
 955868139,
 983945,
 -1,
 955912036,
 983943,
 -50947,
 955868139,
 983944,
 -1,
 956043108,
 983942,
 956250370,
 955808996,
 -1,
 -50944,
 956202366,
 983967,
 -50943,
 956251299,
 983966,
 -1,
 956305252,
 983968,
 956512519,
 956198072,
 -1,
 956578054,
 956447893,
 -1,
 -50939,
 956523499,
 983960,
 -1,
 956567396,
 983958,
 -1,
 956523499,
 983959,
 956840202,
 956452812,
 -1,
 -50935,
 956785643,
 983964,
 -1,
 956829540,
 983970,
 957036813,
 956769890,
 -1,
 -50932,
 956982251,
 983949,
 -1,
 957026148,
 983947,
 -50930,
 956997362,
 983962,
 -50929,
 957191776,
 983965,
 -50928,
 957250409,
 983963,
 -50927,
 957308219,
 983961,
 -50926,
 957365411,
 983969,
 -1,
 957421777,
 983957,
 957626649,
 954418837,
 -1,
 957692182,
 957578457,
 983973,
 -1,
 957652203,
 983974,
 957874175,
 957641333,
 -1,
 -50920,
 957779487,
 983972,
 -1,
 957820075,
 983975,
 958070783,
 957585124,
 -1,
 -50917,
 957965778,
 983976,
 -50916,
 958014150,
 983971,
 -1,
 958074815,
 983977,
 958332927,
 954340932,
 -1,
 958347553,
 958223513,
 -1,
 -50912,
 958305759,
 68149,
 -1,
 958368997,
 68148,
 -1,
 958281901,
 68168,
 958609731,
 942870372,
 -1,
 958675256,
 958564184,
 -1,
 958740778,
 958601934,
 -1,
 -50906,
 958696991,
 983985,
 -50905,
 958751723,
 983987,
 -50904,
 958808714,
 983984,
 -50903,
 958868651,
 983986,
 -1,
 958926692,
 983983,
 959134002,
 958664548,
 -1,
 959199537,
 959072521,
 -1,
 959265071,
 959153763,
 -1,
 -50898,
 959221279,
 983989,
 -1,
 959276011,
 983990,
 -50896,
 959212728,
 983991,
 -1,
 959389586,
 983988,
 -1,
 959149378,
 110592,
 959709183,
 959087130,
 -1,
 959723831,
 959616790,
 -1,
 -50891,
 959669227,
 110950,
 -50890,
 959726218,
 110948,
 -1,
 959786155,
 110949,
 -1,
 959667839,
 110951,
 960051521,
 958619263,
 -1,
 960117056,
 959995650,
 -1,
 960182591,
 960069963,
 -1,
 960248126,
 960134372,
 -1,
 -50883,
 960195848,
 3200,
 -1,
 960250838,
 3204,
 -1,
 960175773,
 3201,
 -1,
 960124090,
 983203,
 -1,
 960051721,
 129432,
 -50878,
 959990636,
 69837,
 -1,
 960565223,
 128331,
 960772439,
 958543013,
 128273,
 960837974,
 960700096,
 -1,
 960903507,
 960768259,
 -1,
 960969033,
 960857699,
 -1,
 -50872,
 960928514,
 983556,
 -1,
 960971106,
 983557,
 961165644,
 960920804,
 -1,
 -50869,
 961104941,
 983560,
 -1,
 961164231,
 983561,
 961362255,
 961098935,
 -1,
 -50866,
 961309410,
 983558,
 -1,
 961366927,
 983559,
 -50864,
 961322990,
 983554,
 -50863,
 961504941,
 983555,
 -50862,
 961569087,
 983563,
 -1,
 961621854,
 983562,
 -50860,
 960858122,
 128287,
 -50859,
 961766292,
 983552,
 -1,
 961812320,
 983553,
 -1,
 960765016,
 128422,
 962083171,
 960709258,
 -1,
 962148704,
 962036690,
 128143,
 962214239,
 962086750,
 -1,
 962279774,
 962147550,
 128535,
 962396159,
 962201041,
 -1,
 -50851,
 962298568,
 128537,
 -1,
 962339459,
 128538,
 -1,
 962207564,
 128573,
 -1,
 962134742,
 128139,
 -50847,
 962107753,
 129373,
 -50846,
 962627511,
 129665,
 -1,
 962682268,
 128088,
 -50844,
 962034568,
 11235,
 -50843,
 962815020,
 128040,
 -1,
 962879519,
 129486,
 963066463,
 942830505,
 -1,
 963131847,
 963003018,
 983153,
 963197362,
 963066633,
 -1,
 963262879,
 963155841,
 -1,
 963328386,
 963216995,
 -1,
 963393920,
 963278753,
 -1,
 963459455,
 963315847,
 -1,
 963524989,
 963384933,
 11106,
 963641343,
 963444736,
 -1,
 963656059,
 963549609,
 -1,
 963721587,
 963598193,
 -1,
 -50830,
 963678753,
 11173,
 -1,
 963718034,
 11175,
 963918198,
 963652052,
 -1,
 -50827,
 963876165,
 983238,
 -1,
 963920147,
 11132,
 -50825,
 963876215,
 129074,
 -50824,
 964058915,
 129058,
 -50823,
 964123453,
 129062,
 -50822,
 964181753,
 129070,
 -1,
 964238470,
 129066,
 -50820,
 963611288,
 11122,
 -1,
 964389825,
 11138,
 -50818,
 963472676,
 11142,
 -1,
 964503429,
 11116,
 -1,
 963379374,
 129170,
 -50815,
 963353452,
 11246,
 -1,
 964716659,
 129187,
 964901258,
 963253886,
 -1,
 964966790,
 964854298,
 -1,
 -50811,
 964922332,
 129026,
 -1,
 964964824,
 129042,
 -50809,
 964911757,
 129178,
 -50808,
 965106520,
 129030,
 -50807,
 965169447,
 129034,
 -1,
 965226968,
 129046,
 965425552,
 964827328,
 -1,
 965491086,
 965365810,
 -1,
 -50803,
 965419413,
 11146,
 -1,
 965482085,
 11157,
 -50801,
 965437983,
 129185,
 -1,
 965611623,
 129193,
 965818771,
 965377252,
 -1,
 -50798,
 965767920,
 129082,
 -1,
 965809344,
 129106,
 966015382,
 965768105,
 -1,
 -50795,
 965960830,
 128622,
 -1,
 966018296,
 129189,
 966211993,
 965951201,
 -1,
 -50792,
 966140761,
 129090,
 -1,
 966202981,
 129094,
 966408604,
 966145207,
 -1,
 -50789,
 966359950,
 129195,
 -1,
 966412368,
 129078,
 -50787,
 966367451,
 129174,
 -50786,
 966546315,
 129191,
 -1,
 966599513,
 129086,
 966801835,
 963182592,
 -1,
 966867366,
 966755164,
 -1,
 966932901,
 966791776,
 128360,
 967049215,
 966854097,
 -1,
 -50780,
 966953283,
 128362,
 -1,
 967010072,
 128361,
 -1,
 966864314,
 128489,
 967260585,
 966802595,
 -1,
 -50776,
 967204730,
 128381,
 -1,
 967267682,
 11241,
 -50774,
 967215317,
 128493,
 -1,
 967382111,
 128495,
 967639039,
 966723680,
 -1,
 967653807,
 967521518,
 -1,
 -50770,
 967587469,
 129308,
 -1,
 967644717,
 1421,
 -50768,
 967609000,
 8295,
 -50767,
 967798872,
 128270,
 -1,
 967851480,
 9957,
 968047040,
 963123638,
 127872,
 968163327,
 967966844,
 -1,
 968178103,
 968069417,
 -1,
 -50762,
 968128470,
 11187,
 -1,
 968184474,
 11186,
 968374714,
 968128476,
 -1,
 -50759,
 968331558,
 11189,
 -1,
 968370932,
 11191,
 968571325,
 968315551,
 -1,
 -50756,
 968528166,
 11188,
 -1,
 968567540,
 11190,
 968818687,
 968502009,
 -1,
 -50753,
 968718294,
 11185,
 -1,
 968774298,
 11184,
 968964547,
 967991474,
 128141,
 -50750,
 968902499,
 128365,
 -1,
 968961561,
 129680,
 969161158,
 968892309,
 -1,
 -50747,
 969090232,
 127832,
 -1,
 969152837,
 127833,
 -1,
 969094873,
 129350,
 969423363,
 963062955,
 -1,
 969488867,
 969358192,
 -1,
 -50742,
 969449261,
 127487,
 -50741,
 969514219,
 127486,
 -50740,
 969579562,
 127485,
 -50739,
 969643798,
 127484,
 -50738,
 969708535,
 127483,
 -50737,
 969772575,
 127482,
 -50736,
 969836131,
 127481,
 -50735,
 969899236,
 127480,
 -50734,
 969962409,
 127479,
 -50733,
 970027637,
 127478,
 -50732,
 970091704,
 127477,
 -50731,
 970154987,
 127476,
 -50730,
 970219135,
 127475,
 -50729,
 970283299,
 127474,
 -50728,
 970346444,
 127473,
 -50727,
 970411395,
 127472,
 -50726,
 970476725,
 127471,
 -50725,
 970539658,
 127470,
 -50724,
 970603669,
 127469,
 -50723,
 970668390,
 127468,
 -50722,
 970732727,
 127467,
 -50721,
 970796203,
 127466,
 -50720,
 970860130,
 127465,
 -50719,
 970923526,
 127464,
 -50718,
 970987712,
 127463,
 -1,
 971050852,
 127462,
 971258358,
 969446391,
 -1,
 971323893,
 971190924,
 -1,
 971389423,
 971253348,
 -1,
 971454953,
 971344267,
 -1,
 -50712,
 971411841,
 128402,
 -1,
 971451214,
 128403,
 971651564,
 971404201,
 -1,
 -50709,
 971588784,
 11262,
 -1,
 971641336,
 128401,
 -50707,
 971609574,
 128404,
 -50706,
 971783607,
 128405,
 -1,
 971842335,
 11841,
 972095487,
 971309056,
 -1,
 972110323,
 971986336,
 -1,
 -50702,
 972054517,
 983151,
 -1,
 972110605,
 128968,
 -50700,
 972048051,
 983152,
 -1,
 972234883,
 128639,
 -1,
 971269572,
 128158,
 972503546,
 971185670,
 -1,
 -50696,
 972453315,
 128665,
 -50695,
 972515650,
 983112,
 -1,
 972566448,
 129534,
 972765693,
 972459276,
 -1,
 -50692,
 972715990,
 11153,
 -1,
 972771994,
 11152,
 972962304,
 972695140,
 -1,
 -50689,
 972897116,
 129511,
 -1,
 972952935,
 127822,
 -50687,
 972916112,
 128699,
 -50686,
 973102313,
 127895,
 -1,
 973166038,
 128524,
 973355554,
 969346916,
 -1,
 973421078,
 973292170,
 -1,
 973486610,
 973373079,
 -1,
 973552138,
 973429027,
 -1,
 -50680,
 973501377,
 127340,
 -50679,
 973547184,
 127339,
 -1,
 973610514,
 127338,
 973814286,
 973487495,
 9995,
 973930495,
 973735377,
 -1,
 -50675,
 973827571,
 128406,
 -1,
 973878882,
 128400,
 -50673,
 973747853,
 9994,
 -50672,
 974006673,
 11827,
 -50671,
 974070559,
 11828,
 -1,
 974133497,
 129306,
 974338581,
 973429018,
 -1,
 -50668,
 974293872,
 128740,
 -1,
 974331669,
 128643,
 -1,
 974282554,
 127752,
 974600731,
 973348358,
 -1,
 974666266,
 974538590,
 -1,
 -50663,
 974609843,
 127949,
 -1,
 974659349,
 127950,
 -1,
 974595159,
 129437,
 974928413,
 974530850,
 128251,
 -1,
 974848266,
 128280,
 975059487,
 974854577,
 128007,
 -1,
 974979548,
 128048,
 -50656,
 975020056,
 129682,
 -50655,
 975144547,
 128000,
 -1,
 975198499,
 128015,
 975387199,
 973300715,
 -1,
 975452719,
 975343828,
 -1,
 975518252,
 975384117,
 -1,
 975583784,
 975470467,
 -1,
 -50649,
 975539949,
 127588,
 -1,
 975596118,
 127586,
 -50647,
 975543429,
 127587,
 -50646,
 975722744,
 127585,
 -50645,
 975780181,
 127584,
 -1,
 975838791,
 127589,
 976093183,
 975437824,
 -1,
 -50642,
 975996803,
 128907,
 -1,
 976056906,
 128205,
 976239157,
 975394494,
 -1,
 976304691,
 976170155,
 -1,
 -50638,
 976253867,
 127906,
 -1,
 976299743,
 128478,
 -50636,
 976242636,
 129315,
 -1,
 976421724,
 129531,
 976632376,
 976193436,
 -1,
 -50633,
 976591116,
 11215,
 -1,
 976639519,
 11213,
 976828986,
 976584294,
 127801,
 -1,
 976784581,
 127989,
 -50629,
 976787477,
 128675,
 -50628,
 976906682,
 128019,
 -50627,
 976953915,
 128640,
 -50626,
 977018037,
 129302,
 -1,
 977082189,
 127840,
 977287768,
 975343135,
 -1,
 977353295,
 977231487,
 -1,
 977418828,
 977290098,
 -1,
 977484361,
 977352902,
 -1,
 977549894,
 977407844,
 -1,
 -50619,
 977482427,
 5880,
 -1,
 977542662,
 5879,
 -50617,
 977496484,
 5876,
 -50616,
 977685151,
 5877,
 -1,
 977743665,
 5878,
 -50614,
 977436547,
 5874,
 -50613,
 977889308,
 5875,
 -1,
 977948035,
 5873,
 978190335,
 977362559,
 -1,
 -50610,
 978077709,
 127933,
 -1,
 978137582,
 127939,
 978336342,
 977306629,
 -1,
 -50607,
 978294287,
 11251,
 -50606,
 978357147,
 11256,
 -50605,
 978419386,
 11255,
 -50604,
 978482080,
 11253,
 -50603,
 978543283,
 11252,
 -1,
 978590499,
 11254,
 -50601,
 978270771,
 127945,
 -1,
 978721770,
 8381,
 978926173,
 977227724,
 -1,
 -50598,
 978871275,
 983226,
 -50597,
 978934051,
 983221,
 -50596,
 978993802,
 983231,
 -1,
 979053739,
 983223,
 -50594,
 978877668,
 983113,
 -1,
 979189817,
 129423,
 979385164,
 962997419,
 -1,
 979450553,
 979324876,
 -1,
 979516053,
 979376530,
 -1,
 979581543,
 979459711,
 -1,
 -50588,
 979520770,
 66837,
 -50587,
 979578027,
 66835,
 -50586,
 979642291,
 66821,
 -1,
 979701604,
 66836,
 979909229,
 979515750,
 -1,
 979974763,
 979844245,
 -1,
 -50582,
 979905707,
 66853,
 -1,
 979964787,
 66854,
 -50580,
 979913986,
 66827,
 -1,
 980102315,
 66826,
 980302448,
 979869485,
 -1,
 -50577,
 980237919,
 66852,
 -1,
 980298923,
 66851,
 980499059,
 980256355,
 -1,
 -50574,
 980434527,
 66846,
 -1,
 980495531,
 66845,
 980695670,
 980450532,
 -1,
 -50571,
 980631135,
 66844,
 -1,
 980692139,
 66843,
 980892281,
 980644777,
 -1,
 -50568,
 980841866,
 66842,
 -1,
 980888747,
 66841,
 981088892,
 980832204,
 -1,
 -50565,
 981029379,
 66833,
 -1,
 981085355,
 66832,
 981285503,
 981028227,
 -1,
 -50562,
 981220959,
 66855,
 -1,
 981281963,
 66831,
 981482113,
 981216427,
 66824,
 -1,
 981418634,
 66823,
 981613188,
 981411426,
 -1,
 -50557,
 981548639,
 66822,
 -1,
 981609643,
 66820,
 981809799,
 981540358,
 -1,
 -50554,
 981745247,
 66819,
 -1,
 981806251,
 66818,
 -50552,
 981769451,
 66850,
 -50551,
 981965938,
 66849,
 -50550,
 982029359,
 66848,
 -50549,
 982093343,
 66847,
 -50548,
 982151834,
 66840,
 -50547,
 982216268,
 66839,
 -50546,
 982279147,
 66838,
 -50545,
 982342376,
 66834,
 -50544,
 982404354,
 66830,
 -50543,
 982467210,
 66829,
 -50542,
 982531679,
 66828,
 -50541,
 982594886,
 66825,
 -50540,
 982653388,
 66817,
 -1,
 982716260,
 66816,
 982923954,
 979476117,
 -1,
 982989489,
 982856489,
 -1,
 983055004,
 982940900,
 -1,
 983120539,
 982978404,
 -1,
 -50534,
 983063458,
 69614,
 -1,
 983115948,
 69617,
 -1,
 983056417,
 69620,
 983382687,
 983008867,
 -1,
 -50530,
 983315232,
 69608,
 -1,
 983373955,
 69621,
 983579297,
 983318111,
 69604,
 -1,
 983533647,
 69607,
 983710372,
 983502692,
 -1,
 -50525,
 983670328,
 69615,
 -1,
 983717001,
 69600,
 -50523,
 983670750,
 69606,
 -50522,
 983867125,
 69609,
 -50521,
 983930849,
 69605,
 -50520,
 983987950,
 69619,
 -50519,
 984052394,
 69618,
 -50518,
 984116812,
 69616,
 -50517,
 984179647,
 69613,
 -50516,
 984243117,
 69612,
 -50515,
 984305839,
 69611,
 -50514,
 984370699,
 69610,
 -50513,
 984431466,
 69602,
 -50512,
 984491835,
 69603,
 -1,
 984554068,
 69601,
 -1,
 982926481,
 69622,
 984824504,
 982854827,
 -1,
 984890039,
 984753585,
 -1,
 -50507,
 984845076,
 128294,
 -50506,
 984903674,
 128268,
 -1,
 984962552,
 128161,
 -1,
 984837912,
 128024,
 -1,
 984757431,
 129501,
 985283303,
 979404387,
 -1,
 985348837,
 985219139,
 -1,
 985414370,
 985302534,
 -1,
 985479883,
 985343586,
 -1,
 985545412,
 985440045,
 -1,
 985610944,
 985476267,
 43797,
 -1,
 985541803,
 43796,
 -50495,
 985566751,
 43793,
 -50494,
 985687019,
 43798,
 -50493,
 985744010,
 43794,
 -1,
 985796530,
 43795,
 986054655,
 985475231,
 -1,
 986069703,
 985935019,
 43789,
 -1,
 986000555,
 43788,
 -50488,
 986025503,
 43785,
 -50487,
 986145771,
 43790,
 -50486,
 986202762,
 43786,
 -1,
 986255282,
 43787,
 986462931,
 985407367,
 -1,
 986528462,
 986393771,
 43813,
 -1,
 986459307,
 43812,
 986659536,
 986451812,
 43808,
 -1,
 986582884,
 43811,
 -50479,
 986615327,
 43809,
 -50478,
 986735595,
 43814,
 -1,
 986792586,
 43810,
 986987227,
 986388910,
 -1,
 987052758,
 986918059,
 43821,
 -1,
 986983595,
 43820,
 987183832,
 986976100,
 43816,
 -1,
 987107172,
 43819,
 -50471,
 987139615,
 43817,
 -50470,
 987259883,
 43822,
 -1,
 987316874,
 43818,
 987561983,
 986942689,
 -1,
 987577054,
 987442347,
 43781,
 -1,
 987507883,
 43780,
 -50465,
 987532831,
 43777,
 -50464,
 987653099,
 43782,
 -50463,
 987710090,
 43778,
 -1,
 987762610,
 43779,
 988020735,
 985342714,
 -1,
 -50460,
 987928257,
 4958,
 -1,
 987970149,
 4957,
 -50458,
 985308202,
 983047,
 -1,
 988092608,
 983096,
 988297980,
 985225507,
 -1,
 988363508,
 988243279,
 -1,
 988429039,
 988306764,
 -1,
 -50453,
 988351772,
 127999,
 -50452,
 988417138,
 127998,
 -50451,
 988482518,
 127997,
 -50450,
 988547869,
 127996,
 -1,
 988613173,
 127995,
 988872703,
 988357443,
 -1,
 -50447,
 988780836,
 129459,
 -50446,
 988837393,
 129456,
 -50445,
 988882441,
 129457,
 -1,
 988944704,
 129458,
 989200383,
 988311968,
 -1,
 989215481,
 989094554,
 128453,
 989331455,
 989135856,
 -1,
 -50440,
 989215306,
 128454,
 -1,
 989275746,
 128455,
 989477627,
 989162779,
 128460,
 -1,
 989428964,
 128461,
 -1,
 989407578,
 128459,
 989674254,
 988241535,
 -1,
 989739785,
 989603428,
 -1,
 989805320,
 989684922,
 -1,
 989870851,
 989759075,
 -1,
 989936386,
 989820107,
 983048,
 -1,
 989855995,
 983095,
 -1,
 989869210,
 983046,
 -50428,
 989822625,
 983134,
 -50427,
 990081399,
 983178,
 -50426,
 990141197,
 983099,
 -50425,
 990205547,
 983064,
 -1,
 990264383,
 983177,
 -1,
 989764106,
 128282,
 990526220,
 989697154,
 -1,
 -50421,
 990467668,
 128388,
 -1,
 990522351,
 128233,
 990773247,
 990474869,
 983051,
 -1,
 990679085,
 983050,
 990853917,
 989608294,
 -1,
 990919452,
 990813953,
 -1,
 990984983,
 990857393,
 -1,
 991050516,
 990939873,
 -1,
 -50413,
 991003803,
 78898,
 -1,
 991047839,
 78900,
 991297535,
 990977231,
 -1,
 -50410,
 991200411,
 78899,
 -1,
 991244447,
 78901,
 -50408,
 990942481,
 78896,
 -50407,
 991390772,
 78902,
 -50406,
 991445231,
 78897,
 -50405,
 991506632,
 78904,
 -1,
 991566319,
 78903,
 -1,
 990853478,
 129370,
 991836970,
 990813226,
 -1,
 991902505,
 991791977,
 -1,
 991968040,
 991834164,
 -1,
 992033571,
 991926471,
 -1,
 -50398,
 991986609,
 128915,
 -1,
 992026937,
 128905,
 992230182,
 991984868,
 -1,
 -50395,
 992169019,
 128954,
 -1,
 992219965,
 128942,
 -50393,
 992164894,
 128935,
 -1,
 992360113,
 128948,
 -1,
 991893408,
 128125,
 -1,
 991850820,
 128529,
 992688951,
 991760228,
 -1,
 992754486,
 992637865,
 128066,
 992820017,
 992708690,
 -1,
 992885552,
 992743268,
 -1,
 -50385,
 992837888,
 127759,
 -1,
 992893933,
 127758,
 -1,
 992818086,
 127757,
 993198079,
 992739328,
 -1,
 993213237,
 993092794,
 -1,
 -50380,
 993163184,
 127806,
 -1,
 993221083,
 127805,
 -1,
 993171925,
 129467,
 -1,
 992689059,
 129413,
 993540922,
 992648610,
 128065,
 -50375,
 993492196,
 128064,
 -1,
 993541019,
 128083,
 993737534,
 993492196,
 -1,
 993803069,
 993664518,
 983104,
 -1,
 993727789,
 983103,
 -1,
 993726308,
 983135,
 993999682,
 993682411,
 -1,
 -50368,
 993953379,
 983049,
 -50367,
 994007331,
 983100,
 -1,
 994070476,
 983067,
 994261829,
 993956611,
 -1,
 -50364,
 994209997,
 127972,
 -1,
 994254637,
 127984,
 994458440,
 994212473,
 -1,
 -50361,
 994413989,
 11249,
 -1,
 994469549,
 11248,
 -50359,
 994415811,
 127794,
 -50358,
 994603722,
 11257,
 -50357,
 994667762,
 983179,
 -1,
 994707610,
 128231,
 994917335,
 979321482,
 -1,
 994982855,
 994860671,
 -1,
 995048368,
 994911842,
 983129,
 995113903,
 994984586,
 -1,
 995179438,
 995040793,
 -1,
 995244965,
 995124090,
 -1,
 995310435,
 995198563,
 -1,
 995375962,
 995268374,
 -1,
 995441496,
 995320811,
 126066,
 995557375,
 995360768,
 -1,
 -50345,
 995461348,
 126093,
 -1,
 995508797,
 126084,
 995753983,
 995373393,
 126075,
 -1,
 995624214,
 126102,
 995834721,
 995310741,
 -1,
 995900255,
 995784254,
 126067,
 996016127,
 995819520,
 -1,
 -50338,
 995920100,
 126094,
 -1,
 995967549,
 126085,
 996212735,
 995838602,
 126076,
 -1,
 996082966,
 126103,
 996343807,
 995766352,
 126074,
 -1,
 996214038,
 126101,
 996424560,
 995261668,
 -1,
 996490090,
 996363309,
 126070,
 996555623,
 996445699,
 126079,
 -1,
 996476182,
 126106,
 996737023,
 996474880,
 -1,
 -50327,
 996640996,
 126097,
 -1,
 996688445,
 126088,
 996933631,
 996422599,
 126071,
 996948845,
 996838915,
 126080,
 -1,
 996869398,
 126107,
 997130239,
 996868096,
 -1,
 -50321,
 997034212,
 126098,
 -1,
 997081661,
 126089,
 997276543,
 996357303,
 -1,
 997342072,
 997221355,
 -1,
 997407606,
 997298812,
 126068,
 997523455,
 997326848,
 -1,
 -50315,
 997427428,
 126095,
 -1,
 997474877,
 126086,
 997720063,
 997358752,
 126077,
 -1,
 997590294,
 126104,
 997851135,
 997278346,
 -1,
 997866365,
 997757999,
 126069,
 997982207,
 997785600,
 -1,
 -50308,
 997886180,
 126096,
 -1,
 997933629,
 126087,
 998178815,
 997800273,
 126078,
 -1,
 998049046,
 126105,
 998259596,
 997224762,
 -1,
 998325123,
 998213219,
 -1,
 -50302,
 998284034,
 126116,
 -1,
 998326626,
 126117,
 998521734,
 998276324,
 -1,
 -50299,
 998460461,
 126120,
 -1,
 998519751,
 126121,
 998718345,
 998454455,
 -1,
 -50296,
 998664930,
 126118,
 -1,
 998722447,
 126119,
 -50294,
 998663853,
 126115,
 -50293,
 998859071,
 126123,
 -1,
 998911838,
 126122,
 999111570,
 998203711,
 126073,
 999177103,
 999067139,
 126082,
 -1,
 999097622,
 126109,
 999358463,
 999096320,
 -1,
 -50287,
 999262436,
 126100,
 -1,
 999309885,
 126091,
 999504792,
 999042910,
 126072,
 999570325,
 999464171,
 126081,
 -1,
 999490838,
 126108,
 999751679,
 999489536,
 -1,
 -50281,
 999655652,
 126099,
 -1,
 999703101,
 126090,
 999898012,
 999450285,
 126065,
 1000013823,
 999817216,
 -1,
 -50277,
 999917796,
 126092,
 -1,
 999965245,
 126083,
 1000160161,
 999822067,
 -1,
 1000225696,
 1000113763,
 -1,
 -50273,
 1000184578,
 126130,
 -1,
 1000222835,
 126131,
 -1,
 1000171181,
 126129,
 1000487843,
 1000099986,
 126110,
 -1,
 1000412064,
 126111,
 1000669183,
 1000427042,
 126113,
 -1,
 1000543136,
 126114,
 1000749994,
 995178645,
 -1,
 1000815529,
 1000695473,
 -1,
 -50264,
 1000764157,
 126125,
 -1,
 1000815915,
 126126,
 -1,
 1000769844,
 126127,
 -50261,
 1000701134,
 126128,
 -50260,
 1001025402,
 126124,
 -50259,
 1001083031,
 126112,
 -1,
 1001132798,
 126132,
 -1,
 995103655,
 8377,
 -1,
 995046474,
 983128,
 1001470903,
 994996830,
 -1,
 1001536437,
 1001410935,
 -1,
 -50253,
 1001488998,
 128289,
 -50252,
 1001542953,
 128292,
 -1,
 1001594629,
 128288,
 -50250,
 1001490011,
 128291,
 -1,
 1001743273,
 128290,
 1001929663,
 1001404303,
 -1,
 1001995198,
 1001881352,
 -1,
 1002060732,
 1001948771,
 -1,
 -50245,
 1002019586,
 983111,
 -1,
 1002062178,
 983108,
 -50243,
 1002006189,
 983114,
 -1,
 1002190844,
 983105,
 -1,
 1001924734,
 128129,
 1002453955,
 1001886929,
 -1,
 1002519490,
 1002395689,
 11845,
 -1,
 1002440518,
 11846,
 -1,
 1002467011,
 9959,
 1002716102,
 1002380806,
 -1,
 -50235,
 1002665388,
 128474,
 -1,
 1002726961,
 128232,
 -1,
 1002642687,
 128229,
 1002978255,
 994912300,
 -1,
 1003043787,
 1002931811,
 -1,
 -50230,
 1003002626,
 119667,
 -1,
 1003045218,
 119668,
 1003240398,
 1002976439,
 -1,
 -50227,
 1003186914,
 119669,
 -1,
 1003244431,
 119670,
 -1,
 1003185837,
 119666,
 1003502548,
 1002905493,
 -1,
 1003568083,
 1003429382,
 -1,
 -50222,
 1003523835,
 129482,
 -1,
 1003582871,
 127848,
 -1,
 1003503754,
 127954,
 -50219,
 1003462531,
 127982,
 -50218,
 1003773403,
 128127,
 -1,
 1003815584,
 129311,
 1004026977,
 994849975,
 -1,
 1004092427,
 1003949924,
 -1,
 1004157954,
 1004019206,
 -1,
 1004223489,
 1004088493,
 -1,
 1004289019,
 1004181924,
 -1,
 1004354554,
 1004208128,
 -1,
 1004420068,
 1004299243,
 -1,
 1004485602,
 1004367505,
 128558,
 1004601343,
 1004404736,
 -1,
 -50207,
 1004508832,
 129326,
 -1,
 1004540915,
 128560,
 -50205,
 1004429283,
 129320,
 -1,
 1004686740,
 128582,
 1004878824,
 1004373414,
 128539,
 1004994559,
 1004797983,
 -1,
 -50201,
 1004902802,
 128540,
 -1,
 1004964316,
 128541,
 1005140971,
 1004832355,
 -1,
 -50198,
 1005076313,
 129298,
 -1,
 1005137229,
 128514,
 1005337582,
 1005087928,
 -1,
 -50195,
 1005277773,
 129402,
 -1,
 1005328060,
 129395,
 1005534193,
 1005279523,
 -1,
 -50192,
 1005479873,
 129488,
 -1,
 1005530723,
 128567,
 1005730804,
 1005462204,
 -1,
 -50189,
 1005688859,
 129312,
 -1,
 1005736427,
 128531,
 -50187,
 1005687013,
 129396,
 -50186,
 1005878135,
 128580,
 -50185,
 1005937158,
 128581,
 -50184,
 1006000021,
 128548,
 -50183,
 1006059148,
 129301,
 -1,
 1006122548,
 129323,
 -1,
 1004301211,
 128566,
 1006386174,
 1004240100,
 -1,
 -50179,
 1006314695,
 128561,
 -1,
 1006377067,
 128523,
 -50177,
 1006340437,
 128536,
 -50176,
 1006529870,
 129318,
 -1,
 1006590608,
 128134,
 -1,
 1004178221,
 127981,
 1006844933,
 1004117036,
 -1,
 -50172,
 1006786940,
 128224,
 -1,
 1006846906,
 128439,
 1007041544,
 1006784460,
 -1,
 -50169,
 1006982252,
 127810,
 -1,
 1007030608,
 129478,
 -50167,
 1006995598,
 127877,
 -50166,
 1007181028,
 128106,
 -1,
 1007241883,
 129498,
 1007434793,
 1004028554,
 -1,
 1007500315,
 1007383465,
 -1,
 1007565845,
 1007430827,
 128293,
 1007631377,
 1007524823,
 -1,
 -50160,
 1007582436,
 127878,
 -1,
 1007617230,
 127879,
 1007827988,
 1007550930,
 -1,
 -50157,
 1007787193,
 129519,
 -1,
 1007837430,
 128658,
 -1,
 1007756472,
 129512,
 1008140287,
 1007518788,
 -1,
 1008155673,
 1008038682,
 -1,
 -50152,
 1008114111,
 127771,
 -1,
 1008174644,
 127763,
 -50150,
 1008108929,
 8296,
 -1,
 1008299886,
 129351,
 1008483363,
 1007439820,
 -1,
 1008548896,
 1008413869,
 -1,
 -50146,
 1008500478,
 983106,
 -50145,
 1008547686,
 128193,
 -1,
 1008606770,
 128452,
 1008861183,
 1008490789,
 -1,
 -50142,
 1008759149,
 128253,
 -1,
 1008810175,
 127902,
 1009007656,
 1008434404,
 -1,
 1009073191,
 1008942229,
 128031,
 -50138,
 1009010670,
 127907,
 -1,
 1009058080,
 127845,
 -1,
 1009027036,
 128074,
 -1,
 1008938949,
 127953,
 1009400889,
 1007379435,
 -1,
 1009466415,
 1009349545,
 -1,
 1009531949,
 1009405320,
 127860,
 -1,
 1009452966,
 127869,
 -50130,
 1009487093,
 129376,
 -1,
 1009604904,
 983071,
 1009794099,
 1009422975,
 -1,
 -50127,
 1009741863,
 128966,
 -50126,
 1009799795,
 127808,
 -1,
 1009853578,
 11156,
 1010056245,
 1009740224,
 129462,
 -1,
 1010004310,
 128099,
 1010187319,
 1009989990,
 127787,
 -1,
 1010121869,
 127745,
 -50120,
 1010146351,
 129418,
 -1,
 1010258430,
 128448,
 1010449478,
 1009349545,
 -1,
 1010515006,
 1010394091,
 -1,
 -50116,
 1010473669,
 128550,
 -50115,
 1010524963,
 128037,
 -1,
 1010579816,
 128056,
 1010777154,
 1010439007,
 -1,
 -50112,
 1010731510,
 128445,
 -50111,
 1010790203,
 128444,
 -1,
 1010832309,
 128446,
 1011039301,
 1010707627,
 -1,
 -50108,
 1010982733,
 127839,
 -1,
 1011037356,
 129398,
 -1,
 1010975732,
 127844,
 1011301459,
 1010388940,
 -1,
 1011366987,
 1011260988,
 -1,
 -50103,
 1011318327,
 128760,
 -50102,
 1011364201,
 128389,
 -1,
 1011427637,
 129359,
 1011629134,
 1011311595,
 -1,
 -50099,
 1011587186,
 127924,
 -1,
 1011642645,
 128190,
 1011825745,
 1011552100,
 -1,
 -50096,
 1011779282,
 129407,
 -1,
 1011834103,
 129449,
 -50094,
 1011782491,
 128563,
 -1,
 1011954823,
 128170,
 1012153431,
 1011259126,
 -1,
 -50091,
 1012075293,
 983215,
 -50090,
 1012140613,
 983214,
 -1,
 1012205993,
 983213,
 1012415579,
 1012083883,
 -1,
 -50087,
 1012366403,
 127905,
 -50086,
 1012424516,
 129338,
 -1,
 1012471259,
 128552,
 1012677726,
 1012371570,
 -1,
 -50083,
 1012636095,
 127773,
 -1,
 1012696628,
 127765,
 1012874336,
 1012628708,
 983107,
 -1,
 1012810378,
 983232,
 -1,
 1012806839,
 983072,
 1013071058,
 1003986733,
 -1,
 1013136583,
 1012995006,
 -1,
 1013202075,
 1013077145,
 -1,
 1013267565,
 1013155427,
 -1,
 1013333096,
 1013220963,
 -1,
 -50073,
 1013267619,
 72213,
 -1,
 1013321572,
 72212,
 1013529707,
 1013284068,
 -1,
 -50070,
 1013464227,
 72228,
 -1,
 1013518180,
 72227,
 -50068,
 1013464227,
 72218,
 -1,
 1013649252,
 72217,
 1013857398,
 1013196386,
 -1,
 1013922929,
 1013817133,
 -1,
 -50064,
 1013857443,
 72230,
 -1,
 1013911396,
 72229,
 1014119540,
 1013851746,
 -1,
 -50061,
 1014054051,
 72215,
 -1,
 1014108004,
 72214,
 -50059,
 1014054051,
 72220,
 -1,
 1014239076,
 72219,
 1014447227,
 1013800575,
 -1,
 -50056,
 1014406489,
 72211,
 -50055,
 1014456024,
 72216,
 -50054,
 1014512031,
 72207,
 -1,
 1014566756,
 72221,
 1014774911,
 1014398180,
 -1,
 -50051,
 1014726014,
 72239,
 -50050,
 1014774947,
 72238,
 -1,
 1014828900,
 72240,
 1015037059,
 1014713731,
 -1,
 -50047,
 1014989781,
 72242,
 -50046,
 1015037091,
 72204,
 -1,
 1015091044,
 72203,
 1015299206,
 1014996781,
 -1,
 -50043,
 1015233699,
 72231,
 -1,
 1015287652,
 72232,
 1015495817,
 1015246008,
 -1,
 -50040,
 1015430307,
 72223,
 -1,
 1015484260,
 72222,
 1015692428,
 1015429478,
 -1,
 -50037,
 1015626915,
 72206,
 -1,
 1015680868,
 72205,
 1015889039,
 1015619078,
 -1,
 -50034,
 1015823523,
 72209,
 -1,
 1015877476,
 72208,
 1016085650,
 1015814336,
 -1,
 -50031,
 1016020131,
 72225,
 -1,
 1016074084,
 72224,
 -50029,
 1016044889,
 72234,
 -50028,
 1016239113,
 72237,
 -50027,
 1016296445,
 72235,
 -50026,
 1016355181,
 72226,
 -50025,
 1016418334,
 72236,
 -50024,
 1016483034,
 72210,
 -50023,
 1016544419,
 72241,
 -50022,
 1016598372,
 72192,
 -1,
 1016662117,
 72233,
 1016872104,
 1013159602,
 -1,
 1016937639,
 1016824139,
 -1,
 1017003167,
 1016892959,
 72195,
 -1,
 1016933547,
 72194,
 1017134241,
 1016947691,
 72198,
 -1,
 1017064619,
 72197,
 1017265316,
 1017057124,
 -1,
 -50013,
 1017220639,
 72200,
 -1,
 1017266826,
 72199,
 -50011,
 1017214797,
 72201,
 -50010,
 1017397898,
 72193,
 -1,
 1017457835,
 72196,
 -1,
 1016878197,
 72202,
 1017724083,
 1016823012,
 -1,
 1017789618,
 1017660739,
 -1,
 1017855150,
 1017716361,
 -1,
 1017920685,
 1017780991,
 72245,
 -1,
 1017841529,
 72246,
 -1,
 1017841529,
 72247,
 1018117297,
 1017812451,
 -1,
 -50000,
 1018068525,
 72249,
 -1,
 1018131638,
 72244,
 -1,
 1018041609,
 72248,
 -1,
 1017745183,
 72263,
 1018444990,
 1017651802,
 -1,
 1018510523,
 1018401668,
 -1,
 1018576058,
 1018443283,
 -1,
 -49993,
 1018535257,
 72251,
 -49992,
 1018598409,
 72254,
 -49991,
 1018655741,
 72252,
 -1,
 1018712094,
 72253,
 -1,
 1018513528,
 72250,
 1019019263,
 1018456499,
 -1,
 -49987,
 1018904166,
 72256,
 -1,
 1018964701,
 72262,
 1019165891,
 1018387031,
 -1,
 -49984,
 1019120824,
 72257,
 -49983,
 1019183088,
 72258,
 -49982,
 1019238267,
 72260,
 -1,
 1019292353,
 72259,
 1019493574,
 1019103343,
 -1,
 -49979,
 1019428454,
 72255,
 -1,
 1019488989,
 72261,
 -1,
 1019426280,
 72243,
 1019755725,
 1013094166,
 -1,
 1019821259,
 1019698815,
 -1,
 -49974,
 1019759797,
 983218,
 -1,
 1019813254,
 983259,
 -49972,
 1019773771,
 983217,
 -1,
 1019956405,
 983219,
 1020148944,
 1019686059,
 -1,
 -49969,
 1020105520,
 11234,
 -1,
 1020140815,
 129427,
 -49967,
 1020093960,
 129503,
 -1,
 1020283295,
 129296,
 1020476694,
 1013026335,
 -1,
 1020542221,
 1020423352,
 -1,
 1020607743,
 1020499841,
 -1,
 1020673258,
 1020560995,
 -1,
 1020738793,
 1020622753,
 -1,
 1020804328,
 1020659847,
 -1,
 1020869862,
 1020728933,
 11105,
 1020985343,
 1020788736,
 -1,
 1021000932,
 1020893609,
 -1,
 1021066462,
 1020942193,
 -1,
 -49955,
 1021016368,
 11171,
 -1,
 1021072312,
 11170,
 -49953,
 1021023607,
 129073,
 -49952,
 1021206307,
 129057,
 -49951,
 1021270845,
 129061,
 -49950,
 1021329145,
 129069,
 -49949,
 1021389402,
 11131,
 -1,
 1021451398,
 129065,
 -49947,
 1020955288,
 11121,
 -1,
 1021596684,
 11137,
 -49945,
 1020816676,
 11141,
 -1,
 1021716357,
 11115,
 -1,
 1020723374,
 129169,
 -1,
 1020697452,
 11245,
 1022049522,
 1020597886,
 -1,
 1022115054,
 1022001690,
 -1,
 -49939,
 1022069724,
 129025,
 -1,
 1022112216,
 129041,
 -49937,
 1022059149,
 129177,
 -49936,
 1022253912,
 129029,
 -49935,
 1022316839,
 129033,
 -1,
 1022374360,
 129045,
 1022573813,
 1022007502,
 -1,
 -49932,
 1022532238,
 129173,
 -1,
 1022572765,
 11192,
 1022770424,
 1022524644,
 -1,
 -49929,
 1022718704,
 129081,
 -1,
 1022760128,
 129105,
 1022967035,
 1022705377,
 -1,
 -49926,
 1022894937,
 129089,
 -1,
 1022957157,
 129093,
 -49924,
 1022917488,
 128621,
 -49923,
 1023096400,
 129077,
 -49922,
 1023157081,
 129085,
 -1,
 1023220619,
 11145,
 1023425798,
 1020528881,
 -1,
 1023491331,
 1023377946,
 -1,
 -49918,
 1023440433,
 128316,
 -1,
 1023480303,
 128744,
 -49916,
 1023440433,
 128314,
 -49915,
 1023630537,
 128742,
 -1,
 1023676911,
 128743,
 1023884555,
 1023344640,
 -1,
 1023950090,
 1023814393,
 -1,
 -49911,
 1023904802,
 11109,
 -1,
 1023966708,
 129113,
 -1,
 1023874709,
 11193,
 -49908,
 1023836471,
 128579,
 -1,
 1024159448,
 128319,
 1024343317,
 1020485247,
 -1,
 1024408851,
 1024279178,
 -1,
 1024474386,
 1024362083,
 -1,
 -49903,
 1024405035,
 11258,
 -1,
 1024459936,
 983115,
 -1,
 1024402560,
 129412,
 -49900,
 1024335858,
 11217,
 -1,
 1024660372,
 128530,
 -1,
 1024294116,
 983116,
 1024933161,
 1020435592,
 -1,
 1024998688,
 1024882188,
 -1,
 1025064219,
 1024925190,
 -1,
 -49894,
 1024998967,
 129636,
 -1,
 1025053882,
 129637,
 -49892,
 1025016594,
 129638,
 -49891,
 1025202743,
 129633,
 -49890,
 1025261861,
 129635,
 -49889,
 1025325722,
 129632,
 -1,
 1025388524,
 129634,
 1025638399,
 1024924535,
 -1,
 1025654052,
 1025515014,
 -1,
 -49885,
 1025588791,
 129643,
 -1,
 1025643706,
 129644,
 -49883,
 1025606418,
 129645,
 -49882,
 1025792567,
 129640,
 -49881,
 1025851685,
 129642,
 -49880,
 1025915546,
 129639,
 -1,
 1025978348,
 129641,
 1026178359,
 1024871605,
 -1,
 1026243891,
 1026101092,
 -1,
 1026309426,
 1026190679,
 -1,
 -49875,
 1026262587,
 128304,
 -49874,
 1026322637,
 127971,
 -49873,
 1026385197,
 128121,
 -49872,
 1026440138,
 128122,
 -49871,
 1026500999,
 127886,
 -1,
 1026563885,
 127983,
 -1,
 1026236922,
 127875,
 -49868,
 1026199565,
 129337,
 -49867,
 1026780298,
 128377,
 -49866,
 1026835847,
 129513,
 -1,
 1026895176,
 128086,
 1027145727,
 1026137323,
 -1,
 -49863,
 1027040295,
 129664,
 -49862,
 1027097283,
 983239,
 -49861,
 1027158022,
 128155,
 -1,
 1027217548,
 129393]
_charnames_1318 = [
10199,
10187,
10197,
10183,
10193,
10176,
10195,
10178,
10198,
10184,
]

_charnames_1416 = [
6221,
-1,
-1,
-1,
-1,
14766,
11117,
6223,
]

_charnames_2112 = [
4261,
4255,
4253,
4254,
4252,
4259,
4244,
4257,
4241,
4243,
4242,
4250,
4249,
4248,
4237,
4258,
4247,
4238,
4246,
4245,
4239,
4240,
4262,
4260,
4251,
4266,
4263,
4265,
-1,
-1,
4264,
-1,
1838,
1845,
1837,
1842,
1836,
1835,
1846,
1844,
1841,
1840,
1843,
]

_charnames_2208 = [
6152,
6154,
6174,
6157,
6176,
6172,
6166,
6162,
6143,
6144,
6148,
6171,
6149,
6165,
6177,
6160,
6175,
6159,
6170,
6140,
6169,
-1,
6153,
6173,
6156,
6147,
6142,
6139,
6137,
6138,
]

_charnames_2259 = [
6118,
6104,
6112,
6116,
6113,
6114,
6119,
6102,
6103,
6105,
6107,
6108,
6106,
6115,
6111,
6203,
6192,
6196,
6198,
6194,
6197,
6199,
6195,
6188,
6185,
6191,
6187,
6184,
6190,
6211,
6212,
6210,
6109,
6214,
6215,
6218,
6180,
6206,
6179,
6208,
6201,
6202,
6207,
6204,
6069,
]

_charnames_2383 = [
13286,
-1,
-1,
-1,
-1,
-1,
-1,
13280,
13279,
]

_charnames_2809 = [
14280,
14276,
14277,
14278,
14274,
14279,
14273,
]

_charnames_3406 = [
4581,
4589,
-1,
-1,
-1,
-1,
4577,
4576,
4578,
-1,
4568,
4565,
4573,
4562,
4563,
4571,
4566,
4582,
]

_charnames_3558 = [
1167,
1168,
1159,
1160,
1165,
1166,
1162,
1163,
1170,
1169,
]

_charnames_3718 = [
10990,
-1,
-1,
10991,
-1,
-1,
10989,
-1,
10986,
10984,
10983,
10980,
10979,
10987,
-1,
-1,
-1,
-1,
10981,
]

_charnames_4295 = [
14360,
-1,
-1,
-1,
-1,
-1,
14361,
]

_charnames_5109 = [
9619,
-1,
-1,
9575,
9574,
9573,
9572,
9571,
9592,
]

_charnames_5873 = [
14923,
14921,
14922,
14918,
14919,
14920,
14917,
14916,
]

_charnames_6832 = [
9863,
9866,
9897,
9864,
9880,
9894,
9886,
9875,
9861,
9837,
9896,
9884,
9860,
9883,
9882,
]

_charnames_7098 = [
1713,
1706,
1707,
1708,
1705,
1704,
7489,
7458,
7484,
7456,
7472,
7488,
7481,
7474,
7453,
7466,
7471,
7477,
7450,
7475,
7485,
7457,
7482,
7486,
7479,
7452,
7468,
7454,
7459,
7463,
7460,
7451,
7470,
7476,
7449,
7464,
7480,
7455,
7462,
7487,
7465,
7473,
7483,
7478,
7508,
7496,
7498,
7497,
7500,
7495,
7499,
7494,
7491,
7492,
7513,
7514,
7511,
7510,
]

_charnames_7296 = [
10180,
10189,
10188,
10185,
10172,
10174,
10173,
10171,
10186,
]

_charnames_7312 = [
14310,
14350,
14333,
14349,
14335,
14340,
14315,
14307,
14347,
14327,
14323,
14346,
14345,
14344,
14321,
14314,
14342,
14318,
14306,
14341,
14320,
14326,
14332,
14343,
14317,
14300,
14303,
14329,
14302,
14301,
14338,
14330,
14294,
14297,
14296,
14339,
14292,
14295,
14348,
14337,
14336,
14308,
14311,
-1,
-1,
14312,
14293,
14324,
1696,
1695,
1694,
1700,
1697,
1698,
1699,
1701,
]

_charnames_7411 = [
13650,
13657,
13651,
13649,
13653,
13655,
13656,
13652,
]

_charnames_7655 = [
9825,
9822,
9823,
9828,
9831,
9830,
9820,
9829,
9832,
9817,
9827,
9826,
9821,
9818,
9895,
9892,
9893,
9865,
9887,
-1,
9867,
9862,
]

_charnames_8341 = [
10875,
10874,
10873,
10872,
10871,
10870,
10869,
10868,
]

_charnames_8377 = [
15278,
3518,
9095,
4280,
14935,
11031,
8154,
]

_charnames_9193 = [
8007,
8027,
8035,
8018,
8008,
8028,
8009,
6394,
1764,
3437,
11745,
7990,
7988,
7983,
7992,
13247,
7996,
7981,
12325,
12328,
12329,
12326,
12934,
]

_charnames_9984 = [
8003,
-1,
-1,
-1,
-1,
13946,
-1,
-1,
-1,
-1,
14862,
14858,
]

_charnames_10060 = [
10209,
-1,
8785,
-1,
-1,
-1,
-1,
8053,
13958,
13961,
]

_charnames_11098 = [
1895,
7597,
1894,
7596,
8114,
1573,
11046,
15576,
14701,
13195,
11107,
15624,
9083,
9091,
1417,
1409,
11063,
15591,
14718,
13211,
10140,
5870,
11060,
15588,
14715,
13207,
-1,
-1,
9084,
9092,
1418,
1410,
11054,
15586,
14709,
13205,
11733,
13644,
11061,
15589,
14716,
13208,
11062,
15590,
14717,
13210,
11077,
15614,
14732,
13232,
5869,
5872,
5871,
5868,
14844,
14843,
8729,
8728,
15410,
14733,
-1,
-1,
3455,
3456,
3454,
3457,
8030,
8036,
8011,
8019,
13200,
13199,
15581,
15580,
11050,
14705,
11051,
14706,
7980,
7979,
7971,
7970,
7976,
7973,
7977,
7974,
14783,
14782,
14774,
14773,
14779,
14776,
14780,
14777,
15604,
15626,
12918,
12919,
12920,
7577,
10239,
10242,
7997,
8023,
3516,
11735,
8054,
7984,
7993,
7991,
7989,
8835,
3552,
8095,
10668,
14903,
13950,
14902,
1686,
15635,
14182,
12245,
12246,
12248,
12249,
3478,
12373,
6604,
11793,
12410,
8833,
13960,
8022,
3497,
9508,
11723,
15566,
14691,
6608,
6511,
13671,
12345,
11104,
14760,
1741,
1740,
11065,
15593,
14720,
13213,
15175,
15174,
1904,
14928,
14932,
14931,
14933,
14930,
14929,
15177,
15632,
1902,
13251,
12125,
14826,
11592,
]

_charnames_11559 = [
14357,
-1,
-1,
-1,
-1,
-1,
14358,
]

_charnames_11826 = [
3515,
14863,
14864,
3505,
13333,
13332,
3510,
3551,
3570,
3458,
1753,
13646,
14023,
10088,
13249,
14830,
13248,
13336,
13245,
15296,
15297,
11141,
11142,
13246,
13259,
3486,
4119,
12109,
12402,
9977,
]

_charnames_42612 = [
9845,
9846,
9842,
9844,
9850,
9843,
9848,
9849,
]

_charnames_42648 = [
10194,
10177,
10201,
10190,
4958,
4957,
9851,
9847,
]

_charnames_42893 = [
10934,
10799,
10972,
10952,
10844,
10948,
10828,
10827,
10855,
10961,
10795,
10966,
10866,
10930,
10850,
10929,
10849,
10928,
10848,
10913,
10820,
10964,
10864,
10951,
10843,
10938,
10838,
10903,
10742,
10965,
10939,
10906,
10955,
10905,
10971,
10933,
10932,
10958,
10949,
10960,
10794,
10919,
10783,
10899,
10705,
10911,
10818,
10910,
10817,
10909,
10816,
-1,
-1,
10926,
10812,
10947,
10904,
10962,
]

_charnames_43488 = [
5188,
5189,
5187,
5186,
5190,
5212,
5213,
5171,
5183,
5178,
5177,
5175,
5174,
5167,
5166,
5172,
5204,
5205,
5196,
5197,
5202,
5203,
5199,
5200,
5207,
5206,
5182,
5169,
5168,
5181,
5180,
]

_charnames_43744 = [
4135,
4134,
4136,
4129,
4124,
4123,
4133,
4132,
4130,
4127,
4126,
4146,
4145,
4142,
4143,
4141,
4153,
4150,
4149,
4152,
4151,
4144,
4147,
]

_charnames_43777 = [
15070,
15072,
15073,
15069,
15068,
15071,
-1,
-1,
15047,
15049,
15050,
15046,
15045,
15048,
-1,
-1,
15040,
15042,
15043,
15039,
15038,
15041,
]

_charnames_43808 = [
15054,
15056,
15058,
15055,
15053,
15052,
15057,
-1,
15062,
15064,
15066,
15063,
15061,
15060,
15065,
-1,
10792,
10811,
10788,
10791,
10729,
10803,
10736,
10801,
10802,
10800,
10862,
10845,
10730,
10786,
10787,
10775,
10756,
10763,
10764,
10765,
10766,
10743,
10970,
10840,
10857,
10839,
10858,
10734,
10735,
10793,
10706,
10711,
10713,
10770,
10710,
10822,
10824,
10825,
10834,
10830,
10833,
10832,
10863,
4963,
4954,
4951,
4950,
4953,
10744,
10758,
10778,
10712,
10757,
14161,
10859,
10771,
]

_charnames_43888 = [
9618,
9617,
9616,
9614,
9613,
9612,
9611,
9615,
9610,
9609,
9608,
9607,
9606,
9561,
9560,
9559,
9557,
9556,
9555,
9604,
9603,
9602,
9601,
9600,
9599,
9597,
9596,
9595,
9594,
9593,
9547,
9558,
9548,
9553,
9552,
9551,
9550,
9549,
9590,
9589,
9588,
9587,
9586,
9585,
9545,
9539,
9544,
9543,
9542,
9541,
9540,
9569,
9538,
9568,
9537,
9567,
9536,
9565,
9564,
9563,
9566,
9535,
9534,
9533,
9532,
9531,
9530,
9528,
9527,
9526,
9525,
9524,
9523,
9583,
9582,
9581,
9580,
9579,
9578,
9576,
]

_charnames_64434 = [
6088,
6087,
6078,
6077,
6084,
6083,
6082,
6081,
6095,
6094,
6089,
6076,
6075,
6096,
6092,
6091,
]

_charnames_65063 = [
9836,
9835,
9879,
9878,
9890,
9889,
9855,
9854,
9853,
]

_charnames_66272 = [
9948,
9945,
9937,
9938,
9943,
9944,
9940,
9941,
9947,
9946,
9913,
9909,
9912,
9924,
9927,
9916,
9919,
9932,
9929,
9934,
9908,
9911,
9923,
9926,
9917,
9920,
9933,
9930,
]

_charnames_66384 = [
12632,
12631,
12629,
12607,
12619,
12609,
12606,
12610,
12605,
12600,
12627,
12626,
12625,
12624,
12612,
12623,
12622,
12599,
12616,
12621,
12630,
12597,
12598,
12594,
12589,
12617,
12618,
12620,
12628,
12615,
12613,
12588,
12590,
12592,
12601,
12593,
12591,
12602,
9874,
9873,
9870,
9872,
9871,
]

_charnames_66736 = [
12749,
12750,
12751,
12752,
12783,
12782,
12747,
12740,
12748,
12772,
12771,
12779,
12761,
12746,
12759,
12778,
12777,
12776,
12768,
12769,
12775,
12745,
12767,
12766,
12757,
12744,
12756,
12743,
12755,
12781,
12774,
12773,
12760,
12780,
12764,
12763,
-1,
-1,
-1,
-1,
12704,
12705,
12706,
12707,
12738,
12737,
12702,
12695,
12703,
12727,
12726,
12734,
12716,
12701,
12714,
12733,
12732,
12731,
12723,
12724,
12730,
12700,
12722,
12721,
12712,
12699,
12711,
12698,
12710,
12736,
12729,
12728,
12715,
12735,
12719,
12718,
-1,
-1,
-1,
-1,
14996,
14995,
14982,
14981,
14979,
14949,
14978,
14976,
14975,
14994,
14956,
14955,
14993,
14992,
14991,
14974,
14971,
14970,
14990,
14948,
14950,
14947,
14989,
14988,
14987,
14968,
14967,
14965,
14964,
14962,
14961,
14986,
14985,
14984,
14983,
14959,
14958,
14953,
14954,
14973,
]

_charnames_66864 = [
10046,
10055,
10039,
10006,
10043,
10011,
10042,
10009,
10015,
9985,
10021,
10010,
10018,
9997,
10031,
10019,
10047,
10005,
9994,
10036,
10034,
10030,
10053,
10024,
10045,
9987,
9988,
9990,
10052,
10025,
10051,
10003,
9998,
10037,
10050,
10013,
10054,
10004,
9986,
10028,
10040,
10049,
10000,
10048,
10014,
9999,
10017,
9991,
9993,
10022,
10027,
10033,
]

_charnames_67072 = [
10295,
10294,
10293,
10292,
10291,
10290,
10289,
10288,
10287,
10339,
10338,
10337,
10336,
10335,
10275,
10265,
10267,
10266,
10262,
10264,
10263,
10268,
10269,
10274,
10273,
10272,
10271,
10654,
10270,
10333,
10332,
10331,
10330,
10329,
10328,
10304,
10303,
10302,
10301,
10300,
10299,
10298,
10297,
10285,
10284,
10283,
10282,
10281,
10280,
10279,
10278,
10277,
10326,
10325,
10324,
10323,
10322,
10321,
10312,
10311,
10310,
10309,
10308,
10307,
10306,
10319,
10318,
10317,
10316,
10315,
10314,
10653,
10354,
10344,
10652,
10343,
10342,
10350,
10349,
10651,
10353,
10352,
10347,
10346,
10351,
10473,
10472,
10471,
10470,
10469,
10468,
10467,
10466,
10465,
10464,
10463,
10460,
10459,
10458,
10451,
10450,
10449,
10457,
10456,
10455,
10454,
10453,
10452,
10528,
10527,
10526,
10525,
10524,
10523,
10522,
10521,
10520,
10519,
10517,
10516,
10515,
10514,
10513,
10512,
10511,
10510,
10509,
10508,
10506,
10505,
10504,
10503,
10502,
10501,
10500,
10499,
10498,
10497,
10495,
10494,
10493,
10492,
10491,
10490,
10489,
10488,
10487,
10486,
10484,
10483,
10482,
10481,
10480,
10479,
10478,
10477,
10476,
10475,
10531,
10530,
10630,
10629,
10628,
10627,
10626,
10625,
10624,
10623,
10622,
10621,
10640,
10639,
10638,
10637,
10636,
10635,
10634,
10633,
10632,
10416,
10415,
10414,
10413,
10412,
10411,
10410,
10409,
10445,
10444,
10443,
10442,
10441,
10440,
10407,
10406,
10405,
10404,
10403,
10402,
10401,
10400,
10399,
10397,
10396,
10395,
10394,
10393,
10392,
10391,
10390,
10389,
10424,
10423,
10422,
10421,
10420,
10419,
10418,
10387,
10386,
10385,
10384,
10383,
10382,
10381,
10380,
10379,
10438,
10437,
10436,
10435,
10434,
10433,
10377,
10376,
10375,
10374,
10373,
10372,
10371,
10370,
10369,
10368,
10366,
10365,
10364,
10363,
10362,
10361,
10360,
10359,
10358,
10357,
10431,
10430,
10429,
10428,
10427,
10426,
10581,
10580,
10579,
10578,
10577,
10576,
10575,
10574,
10543,
10542,
10541,
10540,
10539,
10538,
10537,
10536,
10535,
10534,
10563,
10562,
10561,
10560,
10559,
10558,
10557,
10556,
10555,
10591,
10590,
10589,
10572,
10571,
10570,
10569,
10568,
10567,
10566,
10565,
10553,
10552,
10551,
10550,
10549,
10548,
10547,
10546,
10545,
10587,
10586,
10585,
10584,
10583,
]

_charnames_67392 = [
10608,
10607,
10606,
10605,
10604,
10603,
10602,
10601,
10600,
10599,
10598,
10597,
10596,
10616,
10615,
10614,
10613,
10612,
10611,
10610,
10618,
10617,
]

_charnames_67424 = [
10649,
10648,
10647,
10646,
10645,
10644,
10643,
10642,
]

_charnames_67680 = [
12070,
12084,
12081,
12083,
12066,
12073,
12071,
12067,
12064,
12072,
12080,
12079,
12078,
12082,
12077,
12060,
12069,
12076,
12061,
12075,
12074,
12062,
12065,
12085,
12097,
12096,
12089,
12091,
12094,
12095,
12092,
12090,
8937,
8950,
8936,
8963,
8961,
8962,
8935,
8946,
8953,
8951,
8947,
8944,
8929,
8952,
8934,
8960,
8933,
8959,
8932,
8958,
8931,
8957,
8940,
8949,
8956,
8941,
8955,
8954,
8930,
8942,
8945,
]

_charnames_67751 = [
8971,
8967,
8969,
8974,
8976,
8975,
8970,
8968,
8972,
]

_charnames_67808 = [
11694,
11706,
11704,
11705,
11690,
11697,
11695,
11691,
11688,
11696,
11703,
11702,
11701,
11700,
11684,
11693,
11699,
11685,
11698,
-1,
11686,
11689,
-1,
-1,
-1,
-1,
-1,
11711,
11713,
11710,
11709,
11712,
]

_charnames_67968 = [
3984,
3982,
3980,
3977,
3973,
3974,
3971,
3972,
3976,
3978,
3960,
3961,
3958,
3959,
3966,
3967,
3979,
3969,
3981,
3963,
3964,
3965,
3970,
3975,
3954,
3955,
3952,
3953,
3956,
3983,
3985,
3986,
3913,
3925,
3923,
3920,
3915,
3916,
3927,
3919,
3921,
3909,
3908,
3917,
3922,
3911,
3924,
3906,
3914,
3905,
3912,
3918,
3903,
3902,
3901,
3926,
-1,
-1,
-1,
-1,
3946,
3941,
3929,
3930,
3893,
3832,
3840,
3866,
3874,
3850,
3857,
3887,
3881,
3847,
3837,
3845,
3871,
3879,
3855,
3862,
-1,
-1,
3895,
3834,
3842,
3868,
3876,
3852,
3859,
3889,
3883,
3897,
3836,
3844,
3870,
3878,
3854,
3861,
3891,
3885,
3848,
3838,
3846,
3872,
3880,
3856,
3863,
3892,
3886,
3896,
3835,
3843,
3869,
3877,
3853,
3860,
3890,
3884,
3940,
3933,
3934,
3943,
3944,
3937,
3938,
3947,
3948,
3935,
]

_charnames_68224 = [
12653,
12671,
12654,
12670,
12668,
12665,
12644,
12667,
12673,
12640,
12645,
12651,
12669,
12650,
12666,
12643,
12672,
12662,
12663,
12660,
12657,
12659,
12656,
12641,
12647,
12639,
12664,
12638,
12648,
12678,
12677,
12676,
]

_charnames_68288 = [
4178,
4205,
4204,
4198,
4199,
4202,
4195,
4207,
4233,
4182,
4181,
4194,
4193,
4196,
4174,
4206,
4191,
4185,
4190,
4212,
4201,
4173,
4211,
4210,
4168,
4177,
4179,
4209,
4213,
4169,
4187,
4184,
4188,
4208,
4171,
4170,
4175,
4232,
4231,
-1,
-1,
-1,
-1,
4227,
4229,
4226,
4225,
4228,
4220,
4222,
4218,
4217,
4216,
4219,
4221,
]

_charnames_68480 = [
12272,
12271,
12269,
12270,
12258,
12262,
12260,
12259,
12261,
12268,
12267,
12266,
12265,
12255,
12264,
12256,
12257,
12263,
]

_charnames_68521 = [
12280,
12276,
12278,
12282,
12279,
12277,
12281,
]

_charnames_68736 = [
12501,
12505,
12500,
12503,
12476,
12475,
12477,
12499,
12502,
12470,
12522,
12498,
12497,
12489,
12490,
12496,
12519,
12520,
12495,
12494,
12504,
12509,
12487,
12488,
12485,
12471,
12474,
12510,
12511,
12518,
12515,
12512,
12493,
12486,
12492,
12521,
12483,
12484,
12481,
12472,
12482,
12478,
12506,
12507,
12517,
12514,
12491,
12479,
12480,
12473,
12508,
]

_charnames_68800 = [
12447,
12451,
12446,
12449,
12422,
12421,
12423,
12445,
12448,
12416,
12468,
12444,
12443,
12435,
12436,
12442,
12465,
12466,
12441,
12440,
12450,
12455,
12433,
12434,
12431,
12417,
12420,
12456,
12457,
12464,
12461,
12458,
12439,
12432,
12438,
12467,
12429,
12430,
12427,
12418,
12428,
12424,
12452,
12453,
12463,
12460,
12437,
12425,
12426,
12419,
12454,
]

_charnames_68858 = [
12524,
12529,
12531,
12530,
12527,
12526,
11636,
11635,
11627,
11613,
11612,
11630,
11634,
11631,
11605,
11633,
11622,
11621,
11619,
11618,
11623,
11616,
11615,
11606,
11632,
11629,
11628,
11610,
11625,
11604,
11624,
11603,
11609,
11608,
11626,
11656,
11654,
11652,
11655,
11653,
11664,
11665,
11662,
11661,
11660,
11659,
]

_charnames_68912 = [
11647,
11648,
11639,
11640,
11645,
11646,
11642,
11643,
11650,
11649,
]

_charnames_69376 = [
12553,
12544,
12568,
12543,
12567,
12555,
12542,
12559,
12557,
12556,
12558,
12566,
12565,
12564,
12563,
12540,
12541,
12547,
12554,
12552,
12562,
12548,
12538,
12539,
12561,
12549,
12560,
12536,
12537,
12579,
12573,
12576,
12582,
12583,
12578,
12574,
12577,
12580,
12584,
12569,
]

_charnames_69424 = [
1316,
1328,
1326,
1312,
1319,
1317,
1313,
1318,
1325,
1311,
1324,
1323,
1306,
1315,
1322,
1307,
1321,
1308,
1320,
1327,
1310,
1358,
1337,
1331,
1338,
1332,
1341,
1340,
1335,
1334,
1344,
1343,
1342,
1356,
1355,
1354,
1357,
1347,
1348,
1351,
1349,
1350,
]

_charnames_69600 = [
15011,
15024,
15022,
15023,
15007,
15014,
15012,
15008,
15005,
15013,
15021,
15020,
15019,
15018,
15001,
15010,
15017,
15002,
15016,
15015,
15003,
15006,
15025,
]

_charnames_69632 = [
7763,
7764,
7760,
7762,
7761,
7655,
7658,
7677,
7678,
7663,
7664,
7628,
7629,
7630,
7631,
7692,
7657,
7639,
7656,
7673,
7672,
7681,
7680,
7647,
7684,
7683,
7676,
7675,
7645,
7636,
7635,
7652,
7651,
7646,
7638,
7637,
7654,
7653,
7648,
7667,
7666,
7687,
7686,
7690,
7688,
7689,
7670,
7632,
7661,
7660,
7662,
7691,
7669,
7643,
7641,
7642,
7733,
7740,
7736,
7737,
7734,
7735,
7726,
7727,
7728,
7729,
7739,
7732,
7738,
7731,
7741,
7758,
7757,
7771,
7770,
7768,
7772,
7767,
-1,
-1,
-1,
-1,
7714,
7696,
7699,
7709,
7712,
7703,
7705,
7720,
7718,
7701,
7697,
7700,
7710,
7713,
7704,
7706,
7721,
7719,
7717,
7716,
7753,
7754,
7745,
7746,
7751,
7752,
7748,
7749,
7756,
7755,
]

_charnames_69837 = [
14657,
-1,
-1,
1375,
1374,
1387,
1386,
1385,
1384,
1366,
1363,
1379,
1364,
1372,
1377,
1371,
1376,
1383,
1380,
1381,
1362,
1388,
1370,
1382,
1373,
1378,
1369,
1367,
]

_charnames_69872 = [
1399,
1400,
1391,
1392,
1397,
1398,
1394,
1395,
1402,
1401,
-1,
-1,
-1,
-1,
-1,
-1,
9717,
9718,
9716,
9681,
9678,
9674,
9680,
9660,
9659,
9666,
9665,
9641,
9669,
9668,
9663,
9662,
9639,
9635,
9634,
9646,
9645,
9640,
9637,
9636,
9648,
9647,
9642,
9654,
9653,
9672,
9671,
9677,
9650,
9651,
9676,
9657,
9673,
9675,
9679,
9684,
9692,
9693,
9688,
9689,
9694,
9686,
9690,
9685,
9691,
9721,
9723,
9696,
9722,
-1,
9708,
9709,
9700,
9701,
9706,
9707,
9703,
9704,
9711,
9710,
9719,
9713,
9712,
9720,
9656,
9687,
9695,
]

_charnames_69968 = [
4523,
4520,
4515,
4522,
4517,
4501,
4500,
4507,
4506,
4510,
4509,
4504,
4503,
4490,
4480,
4479,
4486,
4485,
4491,
4482,
4481,
4488,
4487,
4492,
4498,
4497,
4513,
4512,
4518,
4495,
4519,
4514,
4516,
4521,
4494,
4526,
4528,
4527,
4524,
]

_charnames_70016 = [
1529,
1524,
1520,
1460,
1463,
1482,
1483,
1468,
1469,
1438,
1439,
1440,
1441,
1498,
1462,
1495,
1461,
1478,
1477,
1486,
1485,
1452,
1489,
1488,
1481,
1480,
1450,
1446,
1445,
1457,
1456,
1451,
1448,
1447,
1459,
1458,
1453,
1472,
1471,
1492,
1491,
1496,
1493,
1494,
1475,
1474,
1442,
1466,
1465,
1467,
1497,
1509,
1512,
1513,
1510,
1511,
1502,
1503,
1504,
1505,
1515,
1508,
1514,
1507,
1521,
1523,
1528,
1525,
1557,
1553,
1552,
1560,
1534,
1536,
1527,
1516,
1555,
1535,
-1,
-1,
1548,
1549,
1540,
1541,
1546,
1547,
1543,
1544,
1551,
1550,
1556,
1526,
1558,
1559,
1533,
1532,
-1,
1154,
1146,
1147,
1152,
1153,
1149,
1150,
1156,
1155,
1132,
1130,
1131,
1140,
1141,
1134,
1135,
1143,
1142,
1138,
1137,
]

_charnames_70144 = [
14499,
14502,
14533,
14528,
14535,
14501,
14531,
14500,
14519,
14518,
14506,
14505,
14504,
14497,
14525,
14524,
14522,
14521,
-1,
14495,
14491,
14490,
14485,
14483,
14496,
14493,
14492,
14487,
14484,
14486,
14498,
14513,
14512,
14510,
14509,
14508,
14532,
14526,
14530,
14516,
14527,
14529,
14534,
14515,
14540,
14541,
14542,
14543,
14545,
14539,
14544,
14538,
14553,
14551,
14552,
14550,
14559,
14558,
14560,
14554,
14557,
14561,
14549,
]

_charnames_70272 = [
5077,
5074,
5070,
5076,
5055,
5054,
5061,
-1,
5060,
-1,
5064,
5063,
5058,
5057,
-1,
5047,
5039,
5038,
5033,
5032,
5031,
5048,
5041,
5040,
5035,
5034,
5049,
5052,
5051,
5067,
-1,
5066,
5072,
5068,
5045,
5073,
5069,
5071,
5075,
5043,
5044,
5078,
-1,
-1,
-1,
-1,
-1,
-1,
14408,
14411,
14438,
14439,
14424,
14425,
14449,
14410,
14445,
14409,
14437,
14436,
14419,
14418,
14417,
14406,
14442,
14441,
14415,
14413,
14414,
14404,
14400,
14399,
14394,
14393,
14430,
14392,
14405,
14402,
14401,
14396,
14395,
14407,
14434,
14433,
14423,
14422,
14421,
14446,
14443,
14431,
14447,
14444,
14427,
14428,
14448,
14478,
14468,
14471,
14472,
14469,
14470,
14474,
14467,
14473,
14466,
14477,
14476,
-1,
-1,
-1,
-1,
-1,
14460,
14461,
14452,
14453,
14458,
14459,
14455,
14456,
14463,
14462,
-1,
-1,
-1,
-1,
-1,
-1,
14144,
14145,
14148,
14141,
-1,
14084,
14087,
14106,
14107,
14092,
14093,
14059,
14061,
-1,
-1,
14122,
14086,
-1,
-1,
14119,
14085,
14102,
14101,
14110,
14109,
14076,
14113,
14112,
14105,
14104,
14074,
14070,
14069,
14081,
14080,
14075,
14072,
14071,
14083,
14082,
14077,
-1,
14096,
14095,
14116,
14115,
14120,
14117,
14118,
-1,
14099,
14098,
-1,
14066,
14090,
14089,
14091,
14121,
-1,
9898,
14150,
14147,
14132,
14135,
14136,
14133,
14134,
14125,
14126,
-1,
-1,
14138,
14131,
-1,
-1,
14137,
14130,
14142,
-1,
-1,
14151,
-1,
-1,
-1,
-1,
-1,
-1,
14152,
-1,
-1,
-1,
-1,
-1,
14149,
14065,
14064,
14060,
14062,
14127,
14128,
-1,
-1,
9805,
9807,
9800,
9801,
9803,
9804,
9806,
-1,
-1,
-1,
9813,
9812,
9811,
9809,
9810,
]

_charnames_70656 = [
8625,
8628,
8653,
8654,
8633,
8634,
8608,
8609,
8610,
8611,
8668,
8627,
8666,
8626,
8649,
8648,
8657,
8656,
8602,
8601,
8660,
8659,
8652,
8651,
8599,
8598,
8616,
8615,
8622,
8621,
8603,
8618,
8617,
8624,
8623,
8605,
8604,
8640,
8639,
8663,
8662,
8643,
8642,
8664,
8637,
8636,
8646,
8645,
8665,
8631,
8630,
8632,
8667,
8678,
8681,
8682,
8679,
8680,
8671,
8672,
8673,
8674,
8684,
8677,
8683,
8676,
8707,
8713,
8710,
8706,
8711,
8709,
8712,
8717,
8714,
8701,
8700,
8720,
8719,
8721,
8696,
8697,
8688,
8689,
8694,
8695,
8691,
8692,
8699,
8698,
-1,
8716,
-1,
8718,
8715,
8612,
]

_charnames_70784 = [
3413,
3333,
3336,
3352,
3353,
3341,
3342,
3311,
3312,
3313,
3314,
3369,
3335,
3365,
3334,
3348,
3347,
3356,
3355,
3325,
3359,
3358,
3351,
3350,
3323,
3319,
3318,
3330,
3329,
3324,
3321,
3320,
3332,
3331,
3326,
3345,
3344,
3362,
3361,
3366,
3363,
3364,
3367,
3315,
3339,
3338,
3340,
3368,
3379,
3385,
3386,
3380,
3381,
3372,
3373,
3374,
3375,
3388,
3384,
3378,
3387,
3383,
3377,
3411,
3409,
3405,
3406,
3410,
3408,
3416,
3414,
3415,
]

_charnames_70864 = [
3399,
3400,
3391,
3392,
3397,
3398,
3394,
3395,
3402,
3401,
]

_charnames_71040 = [
1009,
1013,
1040,
1041,
1029,
1030,
1004,
1005,
1006,
1007,
1057,
1012,
1053,
1010,
1036,
1035,
1044,
1043,
1017,
1047,
1046,
1039,
1038,
1015,
997,
996,
1022,
1021,
1016,
1001,
1000,
1024,
1023,
1018,
1033,
1032,
1050,
1049,
1054,
1051,
1052,
1055,
1008,
1027,
1026,
1028,
1056,
1097,
1102,
1103,
1100,
1101,
1098,
1099,
-1,
-1,
1105,
1096,
1104,
1095,
1089,
1090,
1085,
1086,
1088,
1087,
1112,
1111,
1081,
1082,
1109,
1108,
1107,
1113,
1064,
1065,
1070,
1069,
1068,
1078,
1079,
1077,
1066,
1076,
1075,
1073,
1072,
1074,
999,
993,
994,
1011,
1093,
1094,
]

_charnames_71168 = [
4864,
4867,
4886,
4887,
4872,
4873,
4842,
4843,
4844,
4845,
4902,
4866,
4899,
4865,
4882,
4881,
4890,
4889,
4856,
4893,
4892,
4885,
4884,
4854,
4850,
4849,
4861,
4860,
4855,
4852,
4851,
4863,
4862,
4857,
4876,
4875,
4896,
4895,
4900,
4897,
4898,
4879,
4846,
4870,
4869,
4871,
4901,
4878,
4912,
4915,
4916,
4913,
4914,
4905,
4906,
4907,
4908,
4918,
4911,
4917,
4910,
4942,
4938,
4939,
4941,
4935,
4934,
4944,
4943,
]

_charnames_71248 = [
4930,
4931,
4922,
4923,
4928,
4929,
4925,
4926,
4933,
4932,
-1,
-1,
-1,
-1,
-1,
-1,
4981,
4971,
4984,
4977,
4982,
4973,
4974,
4978,
4979,
4967,
4969,
4970,
4976,
]

_charnames_71296 = [
3208,
3212,
3247,
3248,
3230,
3231,
3264,
3211,
3260,
3209,
3243,
3242,
3251,
3250,
3222,
3254,
3253,
3246,
3245,
3220,
3216,
3215,
3227,
3226,
3221,
3218,
3217,
3229,
3228,
3223,
3240,
3239,
3257,
3256,
3261,
3258,
3237,
3262,
3259,
3233,
3234,
3263,
3236,
3295,
3292,
3283,
3286,
3287,
3284,
3285,
3289,
3282,
3288,
3281,
3293,
3294,
3210,
]

_charnames_71360 = [
3275,
3276,
3267,
3268,
3273,
3274,
3270,
3271,
3278,
3277,
]

_charnames_71424 = [
6533,
6532,
6523,
6524,
6527,
6518,
6530,
6529,
6545,
6548,
6536,
6551,
6526,
6547,
6549,
6546,
6522,
6550,
6516,
6542,
6541,
6539,
6519,
6538,
6544,
6535,
6520,
-1,
-1,
6589,
6590,
6588,
6553,
6557,
6560,
6561,
6558,
6559,
6563,
6554,
6562,
6556,
6555,
6584,
-1,
-1,
-1,
-1,
6574,
6575,
6566,
6567,
6572,
6573,
6569,
6570,
6577,
6576,
6593,
6592,
6581,
6582,
6583,
6585,
]

_charnames_71680 = [
13128,
13131,
13150,
13151,
13136,
13137,
13167,
13130,
13163,
13129,
13146,
13145,
13154,
13153,
13120,
13157,
13156,
13149,
13148,
13118,
13114,
13113,
13125,
13124,
13119,
13116,
13115,
13127,
13126,
13121,
13143,
13142,
13160,
13159,
13164,
13161,
13140,
13165,
13162,
13134,
13133,
13135,
13166,
13139,
13172,
13177,
13178,
13175,
13176,
13173,
13174,
13180,
13171,
13179,
13170,
13186,
13183,
13184,
13185,
13187,
]

_charnames_71840 = [
13746,
13728,
13747,
13718,
13721,
13720,
13752,
13737,
13732,
13742,
13730,
13753,
13751,
13734,
13719,
13738,
13735,
13743,
13749,
13745,
13754,
13729,
13731,
13755,
13750,
13726,
13725,
13724,
13727,
13740,
13741,
13748,
13706,
13688,
13707,
13678,
13681,
13680,
13712,
13697,
13692,
13702,
13690,
13713,
13711,
13694,
13679,
13698,
13695,
13703,
13709,
13705,
13714,
13689,
13691,
13715,
13710,
13686,
13685,
13684,
13687,
13700,
13701,
13708,
13766,
13767,
13758,
13759,
13764,
13765,
13761,
13762,
13769,
13768,
13774,
13772,
13773,
13779,
13780,
13776,
13777,
13782,
13781,
]

_charnames_72096 = [
8858,
8861,
8887,
8888,
8870,
8871,
8863,
8864,
-1,
-1,
8902,
8860,
8899,
8859,
8883,
8882,
8891,
8890,
8850,
8894,
8893,
8886,
8885,
8848,
8844,
8843,
8855,
8854,
8849,
8846,
8845,
8857,
8856,
8851,
8877,
8876,
8897,
8896,
8900,
8898,
8874,
8880,
8865,
8868,
8867,
8869,
8901,
8879,
8873,
8907,
8912,
8913,
8910,
8911,
8908,
8909,
-1,
-1,
8916,
8906,
8915,
8905,
8923,
8919,
8920,
8922,
8924,
8925,
8914,
]

_charnames_72192 = [
15513,
15525,
15518,
15517,
15526,
15520,
15519,
15523,
15522,
15524,
15527,
15490,
15489,
15499,
15498,
15481,
15502,
15501,
15511,
15479,
15463,
15462,
15475,
15474,
15480,
15468,
15467,
15477,
15476,
15482,
15496,
15495,
15505,
15504,
15509,
15466,
15465,
15472,
15471,
15492,
15493,
15514,
15506,
15508,
15510,
15507,
15485,
15484,
15486,
15512,
15488,
15558,
15536,
15531,
15532,
15533,
15537,
15535,
15546,
15542,
15544,
15545,
15543,
15556,
15548,
15551,
15552,
15554,
15553,
15557,
15549,
15538,
]

_charnames_72272 = [
1246,
1273,
1267,
1266,
1274,
1268,
1269,
1272,
1271,
1264,
1265,
1275,
1221,
1220,
1233,
1232,
1212,
1236,
1235,
1230,
1229,
1210,
1196,
1195,
1205,
1204,
1211,
1201,
1200,
1208,
1207,
1213,
1227,
1226,
1239,
1238,
1243,
1199,
1198,
1206,
1223,
1224,
1247,
1240,
1242,
1244,
1241,
1216,
1215,
1217,
1245,
1219,
1280,
1279,
1292,
1293,
1290,
1291,
1257,
1256,
1252,
1258,
1251,
1259,
1254,
1253,
1255,
1250,
1249,
1260,
1281,
1278,
1301,
1282,
1284,
1285,
1287,
1286,
1296,
1297,
1294,
1300,
1299,
]

_charnames_72384 = [
12003,
12009,
12021,
12020,
12025,
12015,
12016,
12005,
12022,
12023,
12008,
12017,
12026,
12014,
12000,
11999,
12006,
12002,
12018,
11995,
12013,
12027,
12024,
12010,
12019,
11996,
11997,
12011,
11991,
11994,
11990,
11992,
11986,
11993,
11989,
11987,
11988,
12043,
12041,
12039,
12044,
12045,
12040,
12036,
12034,
12037,
12038,
12046,
12052,
12048,
12049,
12030,
12028,
12050,
12031,
12032,
12053,
]

_charnames_72704 = [
7816,
7819,
7835,
7836,
7824,
7825,
7795,
7796,
7797,
-1,
7852,
7818,
7848,
7817,
7831,
7830,
7839,
7838,
7808,
7842,
7841,
7834,
7833,
7806,
7802,
7801,
7813,
7812,
7807,
7804,
7803,
7815,
7814,
7809,
7828,
7827,
7845,
7844,
7849,
7846,
7847,
7850,
7798,
7822,
7821,
7823,
7851,
7887,
7890,
7891,
7888,
7889,
7881,
7882,
7883,
-1,
7893,
7886,
7892,
7885,
7918,
7917,
7913,
7914,
7916,
7910,
7909,
7922,
7921,
7920,
]

_charnames_72784 = [
7905,
7906,
7897,
7898,
7903,
7904,
7900,
7901,
7908,
7907,
7878,
7856,
7859,
7869,
7872,
7863,
7865,
7876,
7874,
7861,
7857,
7860,
7870,
7873,
7864,
7866,
7877,
7875,
7923,
-1,
-1,
-1,
4472,
4471,
4447,
4446,
4461,
4434,
4453,
4452,
4459,
4433,
4431,
4430,
4450,
4435,
4444,
4443,
4462,
4457,
4429,
4428,
4449,
4455,
4437,
4438,
4464,
4454,
4456,
4458,
4440,
4441,
4460,
4463,
-1,
-1,
4405,
4404,
4419,
4392,
4411,
4410,
4417,
4391,
4389,
4388,
4408,
4393,
4402,
4401,
4420,
4415,
4387,
4386,
4407,
4413,
4395,
4396,
-1,
4412,
4414,
4416,
4398,
4399,
4418,
4421,
4470,
4468,
4466,
4469,
4467,
4424,
4423,
]

_charnames_72960 = [
4301,
4304,
4325,
4326,
4317,
4318,
4342,
-1,
4303,
4339,
-1,
4302,
4312,
4311,
4329,
4328,
4293,
4332,
4331,
4316,
4315,
4291,
4286,
4285,
4298,
4297,
4292,
4289,
4288,
4300,
4299,
4294,
4321,
4320,
4335,
4334,
4340,
4336,
4338,
4324,
4337,
4307,
4306,
4308,
4341,
4323,
4310,
4314,
4287,
4348,
4351,
4352,
4349,
4350,
4353,
-1,
-1,
-1,
4355,
-1,
4347,
4354,
-1,
4346,
4376,
4372,
4373,
4375,
4374,
4356,
4378,
4379,
]

_charnames_73040 = [
4367,
4368,
4359,
4360,
4365,
4366,
4362,
4363,
4370,
4369,
-1,
-1,
-1,
-1,
-1,
-1,
14199,
14202,
14220,
14221,
14203,
14204,
-1,
14238,
14201,
-1,
14235,
14200,
14231,
14232,
14230,
14229,
14236,
14216,
14215,
14192,
14191,
14213,
14224,
14223,
14198,
14197,
14210,
14227,
14226,
14190,
14189,
14212,
14219,
14218,
14196,
14195,
14209,
14207,
14206,
14237,
14234,
14233,
14244,
14247,
14248,
14245,
14246,
-1,
14250,
14243,
-1,
14249,
14242,
14268,
14267,
14251,
14269,
]

_charnames_73120 = [
14262,
14263,
14254,
14255,
14260,
14261,
14257,
14258,
14265,
14264,
]

_charnames_73440 = [
4543,
4545,
4533,
4540,
4548,
4541,
4537,
4546,
4534,
4547,
4544,
4532,
4535,
4539,
4542,
4536,
4538,
4549,
4557,
4553,
4551,
4554,
4552,
4555,
4556,
]

_charnames_73664 = [
3166,
3185,
3182,
3174,
3179,
3167,
3192,
3188,
3168,
3173,
3172,
3169,
3183,
3190,
3189,
3180,
3184,
3177,
3176,
3191,
3193,
3129,
3130,
3131,
3128,
3120,
3126,
3110,
3122,
3127,
3111,
3113,
3116,
3112,
3125,
3118,
3199,
3203,
3201,
3134,
3197,
3196,
3161,
3204,
3133,
3198,
3202,
3132,
3121,
3117,
]

_charnames_74607 = [
9383,
9440,
9443,
9444,
9298,
9299,
9293,
9286,
9399,
9398,
9323,
9322,
9340,
9337,
9474,
9375,
9374,
9372,
9371,
9381,
9379,
9378,
9377,
9376,
9368,
9233,
9243,
9241,
9239,
9453,
9451,
9363,
9342,
9358,
9357,
9348,
9361,
9479,
9478,
9421,
9466,
9435,
9436,
]

_charnames_74851 = [
9493,
9494,
9487,
9486,
9484,
9485,
9496,
9497,
9490,
9491,
9488,
9498,
-1,
-1,
-1,
-1,
-1,
9499,
]

_charnames_74880 = [
9441,
9442,
9445,
9460,
9459,
9458,
9457,
9461,
9300,
9297,
9291,
9290,
9292,
9272,
9270,
9271,
9281,
9280,
9285,
9264,
9261,
9263,
9262,
9278,
9277,
9284,
9259,
9258,
9256,
9257,
9252,
9250,
9251,
9253,
9268,
9267,
9266,
9283,
9282,
9275,
9274,
9402,
9401,
9404,
9403,
9394,
9393,
9392,
9389,
9390,
9387,
9388,
9391,
9397,
9330,
9320,
9319,
9318,
9329,
9312,
9315,
9314,
9328,
9327,
9309,
9310,
9311,
9326,
9304,
9307,
9306,
9325,
9324,
9331,
9339,
9336,
9334,
9333,
9476,
9475,
9382,
9380,
9369,
9367,
9232,
9202,
9197,
9196,
9201,
9194,
9193,
9200,
9199,
9191,
9190,
9198,
9229,
9228,
9213,
9212,
9207,
9206,
9205,
9214,
9210,
9209,
9219,
9218,
9217,
9222,
9221,
9223,
9177,
9169,
9176,
9175,
9173,
9172,
9174,
9185,
9184,
9187,
9186,
9182,
9181,
9180,
9179,
9230,
9166,
9139,
9152,
9151,
9150,
9149,
9148,
9147,
9146,
9144,
9143,
9142,
9165,
9153,
9164,
9163,
9158,
9159,
9162,
9161,
9160,
9157,
9156,
9226,
9225,
9244,
9242,
9240,
9236,
9237,
9238,
9452,
9450,
9449,
9356,
9349,
9350,
9355,
9354,
9353,
9352,
9351,
9344,
9346,
9345,
9423,
9422,
9420,
9419,
9416,
9412,
9411,
9410,
9409,
9415,
9414,
9424,
9467,
9465,
9464,
9434,
9433,
9431,
9430,
9429,
9472,
9471,
9470,
]

_charnames_78896 = [
15127,
15129,
15122,
15125,
15123,
15126,
15128,
15131,
15130,
]

_charnames_82944 = [
5717,
5716,
5715,
5714,
5713,
5712,
5711,
5710,
5709,
5664,
5665,
5674,
5673,
5672,
5671,
5670,
5669,
5668,
5667,
5666,
5662,
5661,
5660,
5659,
5658,
5657,
5652,
5653,
5656,
5655,
5654,
5650,
5649,
5648,
5647,
5646,
5645,
5644,
5643,
5642,
5640,
5641,
5611,
5603,
5604,
5610,
5609,
5608,
5601,
5602,
5598,
5600,
5599,
5607,
5606,
5605,
5707,
5706,
5705,
5704,
5703,
5702,
5701,
5700,
5699,
5698,
5625,
5624,
5623,
5622,
5621,
5620,
5613,
5616,
5615,
5614,
5619,
5618,
5617,
5696,
5695,
5694,
5693,
5692,
5691,
5690,
5689,
5688,
5687,
5685,
5684,
5683,
5682,
5681,
5680,
5679,
5678,
5677,
5676,
5638,
5637,
5636,
5635,
5634,
5633,
5632,
5629,
5630,
5627,
5628,
5631,
5237,
5238,
5235,
5236,
5233,
5234,
5242,
5226,
5229,
5228,
5227,
5230,
5232,
5231,
5241,
5222,
5225,
5224,
5223,
5240,
5239,
5244,
5246,
5245,
5256,
5255,
5254,
5253,
5247,
5248,
5252,
5251,
5250,
5249,
5280,
5279,
5278,
5277,
5276,
5270,
5271,
5275,
5274,
5273,
5272,
5268,
5267,
5266,
5265,
5264,
5258,
5259,
5263,
5262,
5261,
5260,
5346,
5345,
5344,
5343,
5342,
5341,
5340,
5339,
5338,
5337,
5335,
5334,
5333,
5332,
5331,
5330,
5329,
5328,
5327,
5326,
5324,
5323,
5322,
5321,
5320,
5319,
5318,
5317,
5316,
5315,
5313,
5312,
5311,
5310,
5309,
5308,
5307,
5306,
5305,
5304,
5302,
5301,
5300,
5299,
5298,
5297,
5296,
5295,
5294,
5293,
5291,
5290,
5289,
5288,
5287,
5286,
5285,
5284,
5283,
5282,
5489,
5488,
5476,
5478,
5477,
5487,
5486,
5485,
5484,
5481,
5482,
5483,
5479,
5480,
5515,
5514,
5513,
5512,
5511,
5506,
5507,
5504,
5505,
5510,
5509,
5508,
5551,
5550,
5549,
5548,
5547,
5546,
5545,
5541,
5542,
5544,
5543,
5595,
5594,
5593,
5592,
5591,
5590,
5589,
5588,
5587,
5586,
5584,
5583,
5582,
5581,
5580,
5579,
5578,
5577,
5576,
5575,
5573,
5572,
5571,
5570,
5569,
5568,
5567,
5566,
5565,
5564,
5539,
5538,
5537,
5536,
5535,
5534,
5533,
5529,
5530,
5532,
5531,
5562,
5561,
5560,
5559,
5558,
5557,
5556,
5555,
5554,
5553,
5527,
5526,
5525,
5524,
5523,
5522,
5521,
5520,
5519,
5517,
5518,
5502,
5501,
5500,
5499,
5493,
5494,
5498,
5497,
5496,
5495,
5491,
5492,
5440,
5439,
5438,
5437,
5436,
5435,
5434,
5433,
5432,
5430,
5431,
5473,
5472,
5471,
5470,
5469,
5468,
5467,
5466,
5465,
5464,
5428,
5427,
5426,
5425,
5424,
5423,
5422,
5421,
5420,
5418,
5419,
5364,
5363,
5356,
5355,
5354,
5362,
5361,
5360,
5349,
5352,
5351,
5350,
5359,
5358,
5357,
5462,
5461,
5460,
5459,
5458,
5457,
5456,
5455,
5454,
5453,
5416,
5415,
5414,
5413,
5412,
5411,
5410,
5409,
5408,
5406,
5407,
5392,
5391,
5390,
5389,
5383,
5384,
5388,
5387,
5386,
5381,
5382,
5385,
5404,
5394,
5395,
5403,
5402,
5401,
5400,
5399,
5398,
5397,
5396,
5379,
5371,
5372,
5378,
5370,
5369,
5377,
5376,
5366,
5367,
5375,
5374,
5373,
5451,
5450,
5449,
5448,
5447,
5446,
5445,
5444,
5443,
5442,
5821,
5820,
5819,
5818,
5817,
5816,
5815,
5814,
5813,
5812,
5735,
5734,
5744,
5743,
5742,
5741,
5740,
5739,
5738,
5737,
5736,
5810,
5809,
5808,
5807,
5806,
5805,
5804,
5803,
5802,
5801,
5799,
5798,
5797,
5796,
5795,
5794,
5793,
5792,
5791,
5790,
5788,
5787,
5786,
5785,
5784,
5783,
5782,
5781,
5780,
5779,
5722,
5723,
5731,
5730,
5729,
5728,
5727,
5726,
5720,
5721,
5725,
5724,
5777,
5776,
5775,
5774,
5773,
5772,
5771,
5770,
5769,
5768,
5766,
5765,
5764,
5763,
5762,
5761,
5760,
5759,
5758,
5757,
5755,
5754,
5753,
5752,
5751,
5750,
5749,
5748,
5747,
5746,
5830,
5829,
5828,
5827,
5826,
5825,
5824,
5823,
5863,
5862,
5861,
5860,
5859,
5858,
5857,
5856,
5855,
5853,
5852,
5851,
5850,
5849,
5848,
5847,
5846,
5845,
5844,
5842,
5841,
5840,
5839,
5838,
5837,
5836,
5835,
5834,
5833,
5864,
]

_charnames_92160 = [
7175,
7283,
7252,
7253,
7196,
7227,
7272,
7184,
7230,
7249,
7250,
7206,
7268,
7177,
7204,
7211,
7220,
7238,
7171,
7258,
7189,
7236,
7174,
7278,
7277,
7170,
7209,
7244,
7281,
7245,
7216,
7183,
7286,
7282,
7169,
7237,
7221,
7222,
7214,
7262,
7246,
7193,
7255,
7205,
7198,
7254,
7267,
7275,
7235,
7270,
7208,
7259,
7192,
7263,
7215,
7226,
7276,
7289,
7288,
7264,
7234,
7210,
7229,
7167,
7231,
7180,
7242,
7190,
7285,
7176,
7207,
7197,
7219,
7181,
7271,
7233,
7243,
7186,
7203,
7179,
7261,
7187,
7287,
7274,
7199,
7195,
7218,
7323,
7358,
7332,
7333,
7353,
7295,
7342,
7361,
7294,
7343,
7347,
7362,
7351,
7325,
7326,
7364,
7346,
7357,
7330,
7329,
7304,
7297,
7320,
7338,
7365,
7337,
7352,
7348,
7370,
7318,
7315,
7369,
7334,
7359,
7308,
7313,
7314,
7305,
7331,
7298,
7309,
7321,
7345,
7307,
7367,
7296,
7368,
7339,
7302,
7301,
7354,
7316,
7324,
7299,
7341,
7317,
7028,
7065,
7119,
7157,
7026,
7043,
7029,
7152,
7077,
7154,
7069,
7061,
7075,
7147,
7047,
7084,
7103,
7153,
7106,
7120,
7064,
7087,
7038,
7079,
7121,
7114,
7115,
7136,
7048,
7130,
7056,
7126,
7138,
7025,
7159,
7068,
7095,
7062,
7022,
7141,
7080,
7098,
7059,
7128,
7023,
7162,
7042,
7039,
7037,
7163,
7160,
7076,
7161,
7055,
7142,
7125,
7034,
7052,
7110,
7021,
7091,
7088,
7143,
7112,
7054,
7030,
7156,
7024,
7036,
7060,
7113,
7035,
7046,
7094,
7122,
7045,
7133,
7137,
7078,
7092,
7085,
7104,
7074,
7105,
7083,
7118,
7051,
7097,
7096,
7134,
7108,
7109,
7031,
7067,
7144,
7148,
7149,
7129,
6923,
7010,
6870,
6906,
6871,
6984,
6873,
6883,
6864,
6889,
7009,
6858,
6936,
6860,
6955,
6966,
6935,
6876,
6942,
6956,
7001,
6959,
6946,
6908,
6892,
6925,
6917,
6948,
7000,
6874,
6953,
6855,
6970,
7013,
6857,
7015,
6893,
6912,
6979,
6894,
6929,
6914,
6987,
6913,
6905,
6982,
6880,
6921,
6962,
6888,
6968,
6947,
6999,
6954,
7007,
6969,
6856,
6909,
6879,
6952,
6992,
6990,
6886,
6980,
6863,
6910,
6866,
6998,
6993,
6997,
6895,
6898,
6943,
6960,
6868,
6859,
6971,
6918,
6958,
6884,
6967,
6926,
6865,
6978,
6867,
6882,
6875,
7012,
6957,
7004,
6974,
6972,
6887,
7006,
6981,
6919,
6903,
6941,
6928,
6939,
6934,
6961,
6901,
6937,
6899,
6991,
6902,
6938,
6988,
6927,
6983,
7005,
6973,
6900,
6922,
6945,
7016,
6660,
6744,
6724,
6789,
6846,
6784,
6696,
6778,
6833,
6673,
6664,
6692,
6736,
6637,
6803,
6839,
6776,
6646,
6697,
6743,
6796,
6786,
6675,
6652,
6715,
6635,
6651,
6674,
6835,
6669,
6709,
6779,
6641,
6722,
6822,
6636,
6670,
6717,
6783,
6647,
6662,
6737,
6775,
6693,
6658,
6643,
6766,
6823,
6741,
6757,
6710,
6740,
6801,
6777,
6748,
6844,
6841,
6790,
6689,
6734,
6827,
6653,
6773,
6721,
6725,
6678,
6687,
6830,
6739,
6797,
6767,
6680,
6765,
6729,
6663,
6704,
6754,
6792,
6812,
6829,
6632,
6802,
6714,
6638,
6825,
6814,
6683,
6708,
6760,
6645,
6681,
6677,
6711,
6719,
6813,
6686,
6727,
6824,
6810,
6726,
6691,
6633,
6795,
6703,
6684,
6758,
6642,
6700,
6811,
6816,
6667,
6849,
6745,
6847,
6848,
6788,
6699,
6733,
6735,
6659,
6772,
6759,
6648,
6755,
6762,
6763,
6752,
6753,
6800,
6707,
6668,
6694,
6840,
6817,
6845,
6791,
6718,
6836,
6834,
6649,
6654,
6770,
6771,
6809,
6685,
6701,
6785,
6804,
6730,
6713,
6716,
6747,
6805,
6728,
6749,
6815,
6826,
7403,
7441,
7400,
7443,
7408,
7422,
7381,
7433,
7410,
7411,
7418,
7423,
7385,
7377,
7413,
7391,
7390,
7392,
7393,
7399,
7397,
7374,
7373,
7376,
7435,
7388,
7436,
7383,
7427,
7382,
7438,
7428,
7412,
7384,
7406,
7398,
7379,
7380,
7389,
7429,
7442,
7439,
7432,
7431,
7402,
7415,
7407,
7419,
7417,
7416,
7424,
7401,
7394,
7440,
]

_charnames_92736 = [
5109,
5125,
5138,
5127,
5142,
5136,
5143,
5121,
5115,
5132,
5137,
5141,
5116,
5112,
5128,
5124,
5122,
5111,
5110,
5118,
5140,
5107,
5135,
5139,
5134,
5114,
5130,
5129,
5133,
5119,
5108,
-1,
5155,
5156,
5147,
5148,
5153,
5154,
5150,
5151,
5158,
5157,
-1,
-1,
-1,
-1,
5160,
5159,
]

_charnames_92880 = [
7522,
7535,
7545,
7551,
7547,
7525,
7538,
7541,
7534,
7548,
7550,
7527,
7542,
7537,
7540,
7552,
7530,
7544,
7553,
7543,
7526,
7546,
7528,
7554,
7531,
7532,
7529,
7523,
7521,
7549,
-1,
-1,
7561,
7558,
7562,
7557,
7560,
7563,
]

_charnames_92928 = [
11938,
11937,
11934,
11933,
11908,
11907,
11922,
11921,
11940,
11939,
11911,
11910,
11926,
11925,
11905,
11904,
11920,
11919,
11928,
11927,
11932,
11931,
11916,
11915,
11943,
11942,
11914,
11913,
11816,
11801,
11821,
11810,
11803,
11817,
11804,
11818,
11814,
11809,
11820,
11812,
11805,
11808,
11819,
11802,
11806,
11822,
11815,
11813,
11972,
11976,
11979,
11978,
11975,
11980,
11973,
11875,
11877,
11858,
11876,
11881,
11867,
11866,
11865,
11868,
11878,
11889,
11879,
11899,
11871,
11855,
]

_charnames_93008 = [
11954,
11955,
11946,
11947,
11952,
11953,
11949,
11950,
11957,
11956,
-1,
11964,
11967,
11962,
11969,
11968,
11963,
11965,
-1,
11880,
11869,
11896,
11884,
11897,
11895,
11893,
11870,
11892,
11900,
11883,
11888,
11885,
11898,
11890,
11861,
11857,
11853,
11854,
11859,
11860,
-1,
-1,
-1,
-1,
-1,
11827,
11835,
11841,
11842,
11846,
11832,
11844,
11848,
11829,
11828,
11847,
11833,
11845,
11839,
11849,
11836,
11826,
11831,
11838,
]

_charnames_93760 = [
4053,
4049,
4046,
4045,
4033,
4043,
4040,
4052,
4048,
4057,
4058,
4056,
4039,
4032,
4055,
4059,
4062,
4061,
4047,
4036,
4054,
4051,
4042,
4030,
4044,
4060,
4038,
4029,
4050,
4037,
4034,
4035,
4016,
4012,
4009,
4008,
3996,
4006,
4003,
4015,
4011,
4020,
4021,
4019,
4002,
3995,
4018,
4022,
4025,
4024,
4010,
3999,
4017,
4014,
4005,
3993,
4007,
4023,
4001,
3992,
4013,
4000,
3997,
3998,
4078,
4073,
4066,
4068,
4076,
4077,
4071,
4072,
4080,
4079,
4085,
4093,
4083,
4084,
4090,
4091,
4087,
4088,
4094,
4095,
4074,
4067,
4069,
4063,
4096,
4026,
4097,
]

_charnames_93952 = [
4741,
4750,
4683,
4740,
4744,
4743,
4715,
4754,
4735,
4734,
4650,
4708,
4681,
4682,
4648,
4707,
4661,
4663,
4684,
4713,
4657,
4656,
4727,
4726,
4725,
4724,
4647,
4706,
4646,
4705,
4753,
4732,
4685,
4738,
4737,
4660,
4659,
4712,
4747,
4751,
4731,
4730,
4641,
4700,
4654,
4653,
4642,
4702,
4679,
4686,
4696,
4720,
4719,
4674,
4672,
4644,
4703,
4680,
4721,
4675,
4673,
4670,
4668,
4714,
4669,
4667,
4752,
4716,
4746,
4749,
4718,
4701,
4649,
4643,
4697,
-1,
-1,
-1,
-1,
4818,
4662,
4819,
4816,
4817,
4776,
4784,
4783,
4777,
4778,
4792,
4797,
4803,
4802,
4785,
4788,
4789,
4794,
4756,
4757,
4758,
4759,
4760,
4766,
4764,
4762,
4763,
4767,
4768,
4769,
4770,
4771,
4775,
4773,
4799,
4801,
4779,
4780,
4787,
4805,
4786,
4804,
4782,
4790,
4781,
4796,
4806,
4807,
4772,
4800,
4798,
4795,
4808,
4765,
4791,
4761,
4774,
]

_charnames_94095 = [
4811,
4810,
4813,
4812,
4639,
4638,
4637,
4636,
4635,
4634,
4633,
4695,
4694,
4693,
4692,
4691,
4690,
]

_charnames_100352 = [
2724,
2723,
2722,
2721,
2720,
2719,
2718,
2717,
2716,
2714,
2713,
2712,
2711,
2710,
2709,
2708,
2707,
2706,
2705,
2703,
2702,
2701,
2700,
2699,
2698,
2697,
2696,
2695,
2694,
2692,
2691,
2690,
2689,
2688,
2687,
2686,
2685,
2684,
2683,
2681,
2680,
2679,
2678,
2677,
2676,
2675,
2674,
2673,
2672,
2670,
2669,
2668,
2667,
2666,
2665,
2664,
2663,
2662,
2661,
2659,
2658,
2657,
2656,
2655,
2654,
2653,
2652,
2651,
2650,
2648,
2647,
2646,
2645,
2644,
2643,
2642,
2641,
2640,
2639,
2637,
2636,
2635,
2634,
2633,
2632,
2631,
2630,
2629,
2628,
2626,
2625,
2624,
2623,
2622,
2621,
2620,
2619,
2618,
2617,
2614,
2613,
2612,
2611,
2610,
2609,
2608,
2607,
2606,
2605,
2603,
2602,
2601,
2600,
2599,
2598,
2597,
2596,
2595,
2594,
2592,
2591,
2590,
2589,
2588,
2587,
2586,
2585,
2584,
2583,
2581,
2580,
2579,
2578,
2577,
2576,
2575,
2574,
2573,
2572,
2570,
2569,
2568,
2567,
2566,
2565,
2564,
2563,
2562,
2561,
2559,
2558,
2557,
2556,
2555,
2554,
2553,
2552,
2551,
2550,
2548,
2547,
2546,
2545,
2544,
2543,
2542,
2541,
2540,
2539,
2537,
2536,
2535,
2534,
2533,
2532,
2531,
2530,
2529,
2528,
2526,
2525,
2524,
2523,
2522,
2521,
2520,
2519,
2518,
2517,
2515,
2514,
2513,
2512,
2511,
2510,
2509,
2508,
2507,
2506,
2503,
2502,
2501,
2500,
2499,
2498,
2497,
2496,
2495,
2494,
2492,
2491,
2490,
2489,
2488,
2487,
2486,
2485,
2484,
2483,
2481,
2480,
2479,
2478,
2477,
2476,
2475,
2474,
2473,
2472,
2470,
2469,
2468,
2467,
2466,
2465,
2464,
2463,
2462,
2461,
2459,
2458,
2457,
2456,
2455,
2454,
2453,
2452,
2451,
2450,
2448,
2447,
2446,
2445,
2444,
2443,
2442,
2441,
2440,
2439,
2437,
2436,
2435,
2434,
2433,
2432,
2431,
2430,
2429,
2428,
2426,
2425,
2424,
2423,
2422,
2421,
2420,
2419,
2418,
2417,
2415,
2414,
2413,
2412,
2411,
2410,
2409,
2408,
2407,
2406,
2404,
2403,
2402,
2401,
2400,
2399,
2398,
2397,
2396,
2395,
2392,
2391,
2390,
2389,
2388,
2387,
2386,
2385,
2384,
2383,
2381,
2380,
2379,
2378,
2377,
2376,
2375,
2374,
2373,
2372,
2370,
2369,
2368,
2367,
2366,
2365,
2364,
2363,
2362,
2361,
2359,
2358,
2357,
2356,
2355,
2354,
2353,
2352,
2351,
2350,
2348,
2347,
2346,
2345,
2344,
2343,
2342,
2341,
2340,
2339,
2337,
2336,
2335,
2334,
2333,
2332,
2331,
2330,
2329,
2328,
2326,
2325,
2324,
2323,
2322,
2321,
2320,
2319,
2318,
2317,
2315,
2314,
2313,
2312,
2311,
2310,
2309,
2308,
2307,
2306,
2304,
2303,
2302,
2301,
2300,
2299,
2298,
2297,
2296,
2295,
2293,
2292,
2291,
2290,
2289,
2288,
2287,
2286,
2285,
2284,
2281,
2280,
2279,
2278,
2277,
2276,
2275,
2274,
2273,
2272,
2270,
2269,
2268,
2267,
2266,
2265,
2264,
2263,
2262,
2261,
2259,
2258,
2257,
2256,
2255,
2254,
2253,
2252,
2251,
2250,
2248,
2247,
2246,
2245,
2244,
2243,
2242,
2241,
2240,
2239,
2237,
2236,
2235,
2234,
2233,
2232,
2231,
2230,
2229,
2228,
2226,
2225,
2224,
2223,
2222,
2221,
2220,
2219,
2218,
2217,
2215,
2214,
2213,
2212,
2211,
2210,
2209,
2208,
2207,
2206,
2204,
2203,
2202,
2201,
2200,
2199,
2198,
2197,
2196,
2195,
2193,
2192,
2191,
2190,
2189,
2188,
2187,
2186,
2185,
2184,
2182,
2181,
2180,
2179,
2178,
2177,
2176,
2175,
2174,
2173,
2170,
2169,
2168,
2167,
2166,
2165,
2164,
2163,
2162,
2161,
2159,
2158,
2157,
2156,
2155,
2154,
2153,
2152,
2151,
2150,
2148,
2147,
2146,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2137,
2136,
2135,
2134,
2133,
2132,
2131,
2130,
2129,
2128,
2126,
2125,
2124,
2123,
2122,
2121,
2120,
2119,
2118,
2117,
2115,
2114,
2113,
2112,
2111,
2110,
2109,
2108,
2107,
2106,
2104,
2103,
2102,
2101,
2100,
2099,
2098,
2097,
2096,
2095,
2093,
2092,
2091,
2090,
2089,
2088,
2087,
2086,
2085,
2084,
2082,
2081,
2080,
2079,
2078,
2077,
2076,
2075,
2074,
2073,
2071,
2070,
2069,
2068,
2067,
2066,
2065,
2064,
2063,
2062,
2059,
2058,
2057,
2056,
2055,
2054,
2053,
2052,
2051,
2050,
2048,
2047,
2046,
2045,
2044,
2043,
2042,
2041,
2040,
2039,
2037,
2036,
2035,
2034,
2033,
2032,
2031,
2030,
2029,
2028,
2026,
2025,
2024,
2023,
2022,
2021,
2020,
2019,
2018,
2017,
2015,
2014,
2013,
2012,
2011,
2010,
2009,
2008,
2007,
2006,
2004,
2003,
2002,
2001,
2000,
1999,
1998,
1997,
1996,
1995,
1993,
1992,
1991,
1990,
1989,
1988,
1987,
1986,
1985,
1984,
1982,
1981,
1980,
1979,
1978,
1977,
1976,
1975,
1974,
1973,
1971,
1970,
1969,
1968,
1967,
1966,
1965,
1964,
1963,
1962,
1960,
1959,
1958,
1957,
1956,
1955,
1954,
1953,
1952,
1951,
2780,
2779,
2778,
2777,
2776,
2775,
2774,
2773,
2772,
2771,
2769,
2768,
2767,
2766,
2765,
2764,
2763,
2762,
2761,
2760,
2758,
2757,
2756,
2755,
2754,
2753,
2752,
2751,
2750,
2749,
2747,
2746,
2745,
2744,
2743,
2742,
2741,
2740,
2739,
2738,
2736,
2735,
2734,
2733,
2732,
2731,
2730,
2729,
2728,
2727,
2787,
2786,
2785,
2784,
2783,
2782,
]

_charnames_110592 = [
14641,
11773,
11506,
11505,
11504,
11503,
11501,
11500,
11499,
11498,
11496,
11495,
11494,
11493,
11492,
11489,
11488,
11487,
11486,
11485,
11510,
11509,
11508,
11170,
11181,
11180,
11179,
11178,
11177,
11176,
11175,
11174,
11172,
11171,
11173,
11190,
11189,
11188,
11187,
11186,
11185,
11184,
11183,
11198,
11197,
11196,
11195,
11194,
11193,
11192,
11205,
11204,
11203,
11202,
11201,
11200,
11210,
11209,
11208,
11207,
11271,
11270,
11269,
11268,
11267,
11266,
11265,
11264,
11286,
11285,
11284,
11283,
11282,
11281,
11262,
11261,
11260,
11259,
11258,
11257,
11256,
11255,
11292,
11291,
11290,
11289,
11288,
11279,
11278,
11277,
11276,
11275,
11274,
11273,
11371,
11370,
11369,
11368,
11360,
11359,
11358,
11357,
11356,
11355,
11354,
11366,
11365,
11364,
11363,
11362,
11344,
11343,
11342,
11341,
11340,
11339,
11338,
11337,
11336,
11352,
11351,
11350,
11349,
11348,
11347,
11346,
11303,
11302,
11301,
11300,
11299,
11298,
11297,
11296,
11295,
11312,
11311,
11310,
11309,
11308,
11307,
11306,
11305,
11330,
11329,
11328,
11320,
11319,
11318,
11317,
11316,
11315,
11314,
11326,
11325,
11324,
11323,
11322,
11213,
11223,
11222,
11221,
11220,
11219,
11218,
11217,
11216,
11215,
11214,
11240,
11239,
11238,
11237,
11236,
11235,
11234,
11252,
11251,
11250,
11248,
11247,
11246,
11245,
11244,
11243,
11242,
11232,
11231,
11230,
11229,
11228,
11227,
11226,
11225,
11421,
11420,
11419,
11418,
11417,
11416,
11415,
11413,
11412,
11411,
11410,
11409,
11408,
11407,
11433,
11432,
11431,
11430,
11437,
11436,
11435,
11428,
11427,
11426,
11425,
11424,
11423,
11478,
11477,
11476,
11475,
11474,
11473,
11483,
11482,
11481,
11480,
11471,
11470,
11469,
11468,
11467,
11466,
11404,
11403,
11402,
11401,
11380,
11379,
11378,
11377,
11376,
11375,
11374,
11387,
11386,
11385,
11384,
11383,
11382,
11399,
11398,
11397,
11396,
11394,
11393,
11392,
11391,
11390,
11389,
11458,
11457,
11456,
11455,
11454,
11452,
11451,
11450,
11449,
11448,
11463,
11462,
11461,
11460,
11446,
11445,
11444,
11443,
11442,
11441,
11440,
11333,
11332,
]

_charnames_110960 = [
8587,
8586,
8585,
8584,
8583,
8582,
8581,
8580,
8579,
8578,
8577,
8576,
8575,
8574,
8573,
8572,
8570,
8569,
8568,
8567,
8566,
8565,
8564,
8563,
8562,
8561,
8560,
8559,
8558,
8557,
8556,
8555,
8553,
8552,
8551,
8550,
8549,
8548,
8547,
8546,
8545,
8544,
8543,
8542,
8541,
8540,
8539,
8538,
8536,
8535,
8534,
8533,
8532,
8531,
8530,
8529,
8528,
8527,
8526,
8525,
8524,
8523,
8522,
8521,
8519,
8518,
8517,
8516,
8515,
8514,
8513,
8512,
8511,
8510,
8509,
8508,
8507,
8506,
8505,
8504,
8502,
8501,
8500,
8499,
8498,
8497,
8496,
8495,
8494,
8493,
8492,
8491,
8490,
8489,
8488,
8487,
8485,
8484,
8483,
8482,
8481,
8480,
8479,
8478,
8477,
8476,
8475,
8474,
8473,
8472,
8471,
8470,
8468,
8467,
8466,
8465,
8464,
8463,
8462,
8461,
8460,
8459,
8458,
8457,
8456,
8455,
8454,
8453,
8451,
8450,
8449,
8448,
8447,
8446,
8445,
8444,
8443,
8442,
8441,
8440,
8439,
8438,
8437,
8436,
8420,
8419,
8418,
8417,
8416,
8415,
8414,
8413,
8412,
8411,
8410,
8409,
8408,
8407,
8406,
8405,
8403,
8402,
8401,
8400,
8399,
8398,
8397,
8396,
8395,
8394,
8393,
8392,
8391,
8390,
8389,
8388,
8386,
8385,
8384,
8383,
8382,
8381,
8380,
8379,
8378,
8377,
8376,
8375,
8374,
8373,
8372,
8371,
8369,
8368,
8367,
8366,
8365,
8364,
8363,
8362,
8361,
8360,
8359,
8358,
8357,
8356,
8355,
8354,
8352,
8351,
8350,
8349,
8348,
8347,
8346,
8345,
8344,
8343,
8342,
8341,
8340,
8339,
8338,
8337,
8335,
8334,
8333,
8332,
8331,
8330,
8329,
8328,
8327,
8326,
8325,
8324,
8323,
8322,
8321,
8320,
8318,
8317,
8316,
8315,
8314,
8313,
8312,
8311,
8310,
8309,
8308,
8307,
8306,
8305,
8304,
8303,
8301,
8300,
8299,
8298,
8297,
8296,
8295,
8294,
8293,
8292,
8291,
8290,
8289,
8288,
8287,
8286,
8284,
8283,
8282,
8281,
8280,
8279,
8278,
8277,
8276,
8275,
8274,
8273,
8272,
8271,
8270,
8269,
8267,
8266,
8265,
8264,
8263,
8262,
8261,
8260,
8259,
8258,
8257,
8256,
8255,
8254,
8253,
8252,
8250,
8249,
8248,
8247,
8246,
8245,
8244,
8243,
8242,
8241,
8240,
8239,
8238,
8237,
8236,
8235,
8233,
8232,
8231,
8230,
8229,
8228,
8227,
8226,
8225,
8224,
8223,
8222,
8221,
8220,
8219,
8218,
8216,
8215,
8214,
8213,
8212,
8211,
8210,
8209,
8208,
8207,
8206,
8205,
8204,
8203,
8202,
8201,
8199,
8198,
8197,
8196,
8195,
8194,
8193,
8192,
8191,
8190,
8189,
8188,
8187,
8186,
8185,
8184,
8182,
8181,
8180,
8179,
8178,
8177,
8176,
8175,
8174,
8173,
8172,
8171,
8170,
8169,
8168,
8167,
8433,
8432,
8431,
8430,
8429,
8428,
8427,
8426,
8425,
8424,
8423,
8422,
]

_charnames_113664 = [
13049,
13043,
13022,
13017,
13053,
13032,
13027,
13058,
13040,
13045,
13051,
12996,
13026,
13042,
13054,
13035,
13001,
13021,
12964,
13041,
13036,
12963,
13050,
13031,
13000,
13007,
12967,
12978,
12939,
13009,
12974,
12986,
12949,
13011,
12976,
12980,
12981,
12941,
12942,
13012,
12977,
12982,
12951,
13010,
12975,
12987,
12950,
12983,
12984,
12985,
12943,
12944,
12945,
12946,
13019,
13020,
12988,
12992,
12995,
12952,
12953,
13034,
13052,
12947,
12948,
13055,
12960,
13006,
13002,
13056,
13047,
13037,
13048,
12966,
13014,
13039,
12957,
12999,
12958,
13030,
13057,
13013,
13038,
13044,
13016,
13029,
12998,
13015,
12962,
13005,
13003,
13004,
12994,
12989,
12991,
12993,
12990,
12969,
12970,
12971,
12972,
13024,
13025,
12956,
12965,
12961,
13046,
-1,
-1,
-1,
-1,
-1,
13075,
13099,
13100,
13063,
13098,
13078,
13093,
13094,
13090,
13092,
13096,
13095,
13091,
-1,
-1,
-1,
13087,
13083,
13084,
13080,
13085,
13086,
13081,
13082,
13077,
]

_charnames_113808 = [
13069,
13071,
13072,
13065,
13073,
13074,
13066,
13070,
13062,
13068,
-1,
-1,
13102,
13101,
13104,
13103,
1568,
1570,
1569,
1567,
]

_charnames_119262 = [
5098,
5088,
5094,
5096,
5095,
5097,
5091,
5090,
5087,
5086,
5093,
]

_charnames_119520 = [
4616,
4617,
4593,
4596,
4605,
4608,
4600,
4602,
4611,
4614,
4598,
4613,
4594,
4597,
4606,
4609,
4601,
4603,
4612,
4615,
]

_charnames_119666 = [
15310,
15305,
15306,
15308,
15309,
3298,
3299,
]

_charnames_120832 = [
10,
242,
223,
362,
276,
331,
101,
254,
111,
100,
103,
89,
93,
253,
12,
244,
53,
50,
51,
94,
91,
15,
28,
27,
25,
23,
30,
247,
148,
102,
33,
249,
56,
54,
44,
52,
96,
97,
92,
55,
36,
38,
40,
41,
115,
18,
20,
21,
140,
81,
24,
31,
22,
26,
133,
76,
131,
132,
87,
88,
78,
37,
43,
42,
136,
137,
138,
82,
189,
194,
193,
191,
192,
272,
176,
311,
180,
203,
187,
205,
188,
206,
186,
231,
232,
312,
363,
182,
184,
185,
177,
212,
201,
209,
207,
211,
210,
200,
196,
197,
198,
199,
263,
266,
270,
267,
328,
315,
217,
215,
220,
229,
222,
233,
221,
230,
237,
235,
240,
354,
357,
360,
358,
291,
295,
274,
313,
294,
303,
296,
314,
304,
305,
329,
46,
250,
286,
340,
297,
49,
48,
287,
150,
153,
154,
155,
161,
110,
260,
361,
346,
162,
163,
157,
158,
301,
160,
300,
345,
344,
159,
261,
299,
343,
57,
251,
288,
306,
341,
32,
248,
174,
307,
353,
169,
171,
172,
262,
359,
352,
165,
168,
167,
173,
170,
327,
99,
252,
239,
325,
326,
324,
227,
289,
338,
337,
147,
308,
141,
258,
145,
142,
322,
139,
146,
144,
256,
238,
234,
309,
349,
350,
347,
257,
268,
269,
320,
321,
318,
290,
59,
282,
62,
63,
64,
67,
68,
66,
84,
85,
79,
75,
74,
271,
73,
77,
225,
226,
283,
284,
278,
281,
335,
336,
333,
104,
125,
119,
120,
121,
126,
114,
117,
116,
108,
123,
109,
112,
124,
8,
175,
733,
734,
735,
982,
983,
984,
918,
919,
920,
968,
969,
970,
803,
804,
805,
927,
928,
914,
910,
915,
911,
912,
886,
882,
887,
883,
884,
916,
650,
649,
651,
653,
648,
647,
652,
499,
619,
442,
443,
440,
441,
444,
479,
478,
476,
477,
415,
474,
473,
471,
472,
460,
461,
462,
407,
409,
410,
408,
412,
413,
414,
456,
457,
458,
488,
489,
490,
492,
493,
494,
697,
698,
699,
701,
702,
703,
708,
706,
707,
705,
641,
642,
639,
640,
636,
637,
634,
635,
631,
632,
629,
630,
626,
627,
624,
625,
576,
577,
574,
575,
578,
600,
599,
597,
598,
520,
595,
594,
593,
592,
606,
517,
518,
519,
521,
603,
604,
605,
608,
609,
610,
612,
613,
614,
716,
717,
718,
712,
713,
714,
719,
396,
397,
394,
395,
388,
389,
386,
387,
400,
401,
467,
468,
469,
447,
452,
453,
448,
424,
425,
426,
420,
421,
422,
402,
404,
405,
759,
763,
771,
445,
391,
465,
450,
432,
761,
765,
769,
392,
466,
451,
433,
762,
766,
770,
428,
429,
430,
509,
510,
566,
569,
565,
568,
549,
552,
550,
553,
529,
530,
776,
780,
784,
506,
507,
561,
562,
559,
560,
542,
545,
543,
546,
526,
527,
775,
779,
783,
513,
514,
511,
512,
515,
570,
554,
532,
533,
534,
773,
777,
781,
579,
482,
485,
483,
486,
582,
585,
588,
583,
586,
589,
435,
436,
536,
537,
497,
498,
617,
618,
937,
938,
942,
935,
939,
940,
933,
934,
943,
941,
365,
377,
371,
370,
374,
372,
375,
376,
904,
902,
903,
838,
839,
840,
947,
949,
948,
946,
899,
900,
898,
831,
830,
832,
843,
844,
828,
826,
829,
825,
845,
834,
836,
835,
810,
812,
813,
818,
820,
821,
815,
822,
816,
961,
962,
960,
754,
752,
753,
847,
955,
956,
953,
954,
979,
976,
980,
977,
972,
973,
669,
670,
671,
677,
679,
680,
685,
687,
688,
666,
665,
664,
660,
663,
662,
656,
659,
658,
681,
684,
683,
673,
676,
675,
864,
863,
862,
672,
690,
691,
728,
730,
724,
723,
731,
729,
726,
727,
742,
749,
745,
746,
747,
748,
750,
500,
620,
957,
364,
846,
923,
924,
985,
888,
925,
738,
739,
740,
986,
859,
858,
857,
856,
855,
854,
853,
852,
896,
875,
876,
868,
870,
873,
869,
871,
872,
964,
905,
929,
965,
987,
]

_charnames_121499 = [
895,
894,
893,
892,
891,
-1,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
789,
788,
787,
]

_charnames_122880 = [
9796,
9782,
9784,
9794,
9779,
9753,
9770,
-1,
9771,
9761,
9762,
9757,
9780,
9792,
9791,
9790,
9789,
9788,
9787,
9786,
9768,
9773,
9785,
9776,
9793,
-1,
-1,
9765,
9774,
9795,
9766,
9751,
9752,
9756,
-1,
9754,
9767,
-1,
9755,
9759,
9783,
9760,
9777,
]

_charnames_123136 = [
9017,
9002,
8990,
9003,
9018,
8999,
9006,
8997,
9039,
9034,
9032,
9027,
8998,
8989,
9035,
9024,
8994,
8995,
9030,
8988,
9001,
9038,
9009,
9033,
9028,
8996,
9012,
9005,
8993,
9023,
8992,
9019,
9016,
9011,
9037,
9008,
9025,
9026,
9036,
9031,
9013,
9014,
9020,
9021,
9029,
-1,
-1,
-1,
9062,
9058,
9059,
9056,
9057,
9060,
9061,
9067,
9066,
9068,
9070,
9069,
9071,
9072,
-1,
-1,
9051,
9052,
9043,
9044,
9049,
9050,
9046,
9047,
9054,
9053,
-1,
-1,
-1,
-1,
9040,
9073,
]

_charnames_123584 = [
13788,
13787,
13837,
13836,
13835,
13833,
13807,
13814,
13818,
13804,
13815,
13797,
13796,
13834,
13812,
13811,
13831,
13826,
13827,
13828,
13821,
13798,
13791,
13829,
13830,
13820,
13832,
13824,
13822,
13803,
13808,
13817,
13794,
13795,
13800,
13790,
13792,
13823,
13799,
13825,
13789,
13802,
13809,
13806,
13853,
13854,
13855,
13856,
13848,
13849,
13840,
13841,
13846,
13847,
13843,
13844,
13851,
13850,
-1,
-1,
-1,
-1,
-1,
13857,
]

_charnames_124928 = [
3689,
3688,
3687,
3619,
3586,
3607,
3638,
3703,
3686,
3685,
3684,
3761,
3770,
3774,
3641,
3794,
3742,
3623,
3637,
3747,
3683,
3682,
3681,
3626,
3587,
3730,
3692,
3679,
3678,
3677,
3734,
3584,
3786,
3748,
3676,
3675,
3674,
3720,
3789,
3718,
3738,
3749,
3755,
3751,
3793,
3704,
3670,
3668,
3667,
3721,
3772,
3750,
3604,
3792,
3663,
3662,
3661,
3598,
3610,
3631,
3731,
3778,
3673,
3672,
3671,
3593,
3701,
3700,
3666,
3665,
3664,
3590,
3630,
3785,
3615,
3660,
3659,
3657,
3727,
3775,
3723,
3621,
3707,
3656,
3655,
3654,
3780,
3602,
3744,
3766,
3653,
3652,
3651,
3605,
3608,
3753,
3594,
3791,
3788,
3650,
3649,
3648,
3771,
3714,
3706,
3645,
3695,
3646,
3585,
3644,
3745,
3599,
3759,
3632,
3756,
3595,
3633,
3795,
3640,
3591,
3643,
3600,
3773,
3739,
3728,
3767,
3725,
3760,
3596,
3783,
3698,
3729,
3777,
3715,
3798,
3717,
3716,
3697,
3628,
3705,
3616,
3582,
3635,
3601,
3634,
3787,
3618,
3740,
3622,
3765,
3639,
3693,
3611,
3710,
3708,
3694,
3722,
3784,
3743,
3754,
3589,
3609,
3642,
3781,
3776,
3726,
3763,
3629,
3737,
3588,
3782,
3612,
3613,
3711,
3764,
3758,
3762,
3797,
3769,
3617,
3620,
3732,
3796,
3736,
3752,
3699,
3696,
3733,
3709,
3597,
3741,
3606,
3719,
3627,
3712,
3583,
3624,
-1,
-1,
3809,
3801,
3802,
3807,
3808,
3804,
3805,
3811,
3810,
3818,
3816,
3821,
3819,
3817,
3822,
3823,
]

_charnames_125184 = [
6439,
6418,
6432,
6431,
6421,
6411,
6429,
6420,
6427,
6437,
6436,
6434,
6430,
6417,
6408,
6423,
6401,
6406,
6409,
6425,
6433,
6438,
6435,
6428,
6415,
6400,
6426,
6402,
6424,
6405,
6414,
6422,
6404,
6412,
6482,
6461,
6475,
6474,
6464,
6454,
6472,
6463,
6470,
6480,
6479,
6477,
6473,
6460,
6451,
6466,
6444,
6449,
6452,
6468,
6476,
6481,
6478,
6471,
6458,
6443,
6469,
6445,
6467,
6448,
6457,
6465,
6447,
6455,
6508,
6506,
6504,
6507,
6440,
6505,
6498,
6499,
-1,
-1,
-1,
-1,
6493,
6494,
6485,
6486,
6491,
6492,
6488,
6489,
6496,
6495,
-1,
-1,
-1,
-1,
6502,
6501,
]

_charnames_126065 = [
15256,
15188,
15195,
15218,
15225,
15204,
15210,
15250,
15244,
15201,
15192,
15199,
15222,
15229,
15205,
15211,
15251,
15245,
15259,
15191,
15198,
15221,
15228,
15209,
15215,
15255,
15249,
15258,
15190,
15197,
15220,
15227,
15208,
15214,
15254,
15248,
15202,
15193,
15200,
15223,
15230,
15206,
15212,
15252,
15246,
15265,
15266,
15276,
15267,
15268,
15241,
15233,
15234,
15239,
15240,
15236,
15237,
15243,
15242,
15275,
15271,
15272,
15273,
15274,
15264,
15262,
15263,
15277,
]

_charnames_126209 = [
12845,
12790,
12797,
12820,
12827,
12806,
12812,
12839,
12833,
12803,
12794,
12801,
12824,
12831,
12807,
12813,
12840,
12834,
12848,
12793,
12800,
12823,
12830,
12811,
12817,
12844,
12838,
12847,
12792,
12799,
12822,
12829,
12810,
12816,
12843,
12837,
12804,
12795,
12802,
12825,
12832,
12808,
12814,
12841,
12835,
12869,
12851,
12855,
12861,
12863,
12857,
12859,
12865,
12864,
12853,
12862,
12858,
12852,
12854,
12868,
12867,
]

_charnames_126464 = [
6056,
6068,
6064,
5922,
-1,
6059,
6047,
6065,
6041,
6058,
6054,
5960,
6063,
6062,
5993,
6057,
6067,
5994,
6061,
6060,
5992,
6045,
6043,
6053,
6044,
5923,
6048,
6066,
5920,
5918,
5919,
5917,
-1,
6018,
6014,
-1,
6007,
-1,
-1,
6008,
-1,
6009,
6005,
6013,
6012,
6011,
5998,
6019,
6016,
5999,
6010,
-1,
5997,
6002,
6001,
6004,
-1,
6017,
-1,
6015,
-1,
-1,
-1,
-1,
-1,
-1,
6037,
-1,
-1,
-1,
-1,
6038,
-1,
6032,
-1,
6035,
-1,
6034,
6025,
6040,
-1,
6026,
6033,
-1,
6024,
-1,
-1,
6036,
-1,
6031,
-1,
6039,
-1,
6030,
-1,
6029,
-1,
5990,
5987,
-1,
5980,
-1,
-1,
5981,
5966,
5983,
5978,
-1,
5986,
5985,
5969,
5991,
5989,
5970,
5984,
-1,
5968,
5965,
5964,
5977,
-1,
5975,
5982,
5988,
5974,
-1,
5973,
-1,
5946,
5959,
5956,
5943,
5940,
5949,
5937,
5941,
5931,
5948,
-1,
5954,
5953,
5952,
5934,
5947,
5958,
5935,
5951,
5950,
5933,
5930,
5928,
5955,
5929,
5944,
5938,
5957,
-1,
-1,
-1,
-1,
-1,
5914,
5910,
5900,
-1,
5903,
5897,
5911,
5891,
5902,
-1,
5908,
5907,
5906,
5894,
5915,
5913,
5895,
5905,
5904,
5893,
5890,
5888,
5909,
5889,
5901,
5898,
5912,
]

_charnames_127136 = [
12238,
12232,
12162,
12167,
12179,
12185,
12191,
12196,
12227,
12217,
12172,
12222,
12202,
12212,
12207,
-1,
-1,
12233,
12163,
12168,
12180,
12186,
12192,
12197,
12228,
12218,
12173,
12223,
12203,
12213,
12208,
12240,
-1,
12234,
12164,
12169,
12181,
12187,
12193,
12198,
12229,
12219,
12174,
12224,
12204,
12214,
12209,
12237,
-1,
12235,
12165,
12170,
12182,
12188,
12194,
12199,
12230,
12220,
12175,
12225,
12205,
12215,
12210,
12239,
12183,
12140,
12151,
12160,
12159,
12158,
12157,
12156,
12155,
12154,
12150,
12149,
12148,
12147,
12146,
12145,
12144,
12143,
12142,
12141,
12153,
12152,
]

_charnames_127279 = [
9951,
1621,
-1,
1620,
1619,
1618,
1617,
1616,
1615,
1614,
1613,
1612,
1611,
1610,
-1,
1609,
-1,
1608,
1607,
-1,
1606,
1605,
1604,
-1,
1603,
1602,
1601,
-1,
-1,
-1,
-1,
-1,
1681,
8757,
8756,
8755,
8754,
8753,
8752,
8751,
-1,
8750,
8749,
8748,
8747,
8746,
8745,
8744,
-1,
8743,
8742,
8741,
8740,
8739,
8738,
8737,
8736,
8735,
8734,
14857,
14856,
14855,
-1,
-1,
-1,
8783,
8782,
8781,
8780,
8779,
8778,
8777,
8776,
8775,
-1,
8774,
-1,
-1,
8773,
8772,
-1,
8771,
8770,
8769,
8768,
8767,
8766,
8765,
8764,
8763,
8762,
-1,
-1,
-1,
-1,
8786,
8784,
-1,
1645,
1644,
1663,
1682,
1677,
1676,
1674,
1650,
1670,
1667,
1657,
1649,
1655,
1664,
1683,
1665,
1648,
1656,
1651,
1673,
1622,
1661,
1660,
1659,
1627,
1652,
1671,
1668,
]

_charnames_127462 = [
14818,
14817,
14816,
14815,
14814,
14813,
14812,
14811,
14810,
14809,
14808,
14807,
14806,
14805,
14804,
14803,
14802,
14801,
14800,
14799,
14798,
14797,
14796,
14795,
14794,
14793,
-1,
1680,
1679,
]

_charnames_127538 = [
1632,
1631,
1641,
1638,
1636,
1637,
1633,
1642,
1640,
1643,
]

_charnames_127744 = [
10202,
15414,
10146,
9130,
1715,
1714,
10245,
1716,
14869,
7779,
13863,
13670,
4833,
15152,
15151,
15150,
14375,
8725,
13874,
15384,
13873,
15453,
13859,
11034,
13860,
10222,
8724,
15383,
11033,
15452,
1718,
14373,
1582,
3470,
8024,
13923,
13927,
13925,
13926,
10152,
10151,
10153,
10150,
15413,
14018,
11749,
3304,
8141,
9626,
1898,
15176,
13307,
12099,
10089,
11748,
3522,
9621,
14904,
11785,
1717,
8061,
15156,
15155,
11594,
15409,
4627,
15366,
11123,
5103,
3559,
6600,
14153,
4160,
13867,
2789,
11126,
7591,
12384,
14847,
14168,
12318,
12317,
9622,
1760,
11719,
1889,
4161,
12334,
14788,
14789,
9968,
9502,
1750,
1799,
7790,
15427,
14910,
13339,
12933,
1721,
15429,
15398,
1423,
1562,
15314,
13252,
9967,
9741,
10062,
11154,
9513,
11757,
1577,
8113,
12340,
9966,
15403,
3543,
1874,
14020,
9976,
3492,
8129,
10164,
7608,
15404,
8096,
12351,
14770,
14050,
8146,
15666,
9742,
15368,
15375,
15376,
7580,
12107,
9956,
2790,
10210,
12385,
15664,
10074,
14017,
5013,
1916,
14154,
11585,
8093,
4834,
14849,
5101,
1757,
11124,
9959,
8121,
8120,
15394,
6510,
10075,
15448,
14897,
15397,
4823,
5024,
10246,
11590,
6225,
3553,
10243,
3438,
10158,
12308,
13661,
13327,
1892,
8149,
14383,
8084,
15436,
5102,
5079,
1871,
14283,
5100,
3496,
13664,
5099,
14925,
3545,
1931,
7565,
9627,
1921,
14926,
1727,
1786,
3493,
11738,
6612,
14934,
1937,
14040,
14369,
14872,
14873,
10220,
13669,
15400,
15315,
3301,
1922,
10084,
8123,
8142,
11743,
10244,
13308,
10159,
13300,
13301,
8979,
1747,
11742,
11744,
12932,
15661,
15171,
11758,
7584,
6598,
11750,
11151,
9963,
1915,
13309,
15361,
15316,
15665,
15172,
13959,
8049,
13869,
13871,
14905,
8013,
11036,
7620,
8085,
6611,
15086,
15085,
15084,
15083,
15082,
14880,
5000,
12926,
13866,
9969,
3435,
11125,
14877,
10076,
13350,
10213,
13962,
1925,
1924,
11736,
14881,
14366,
1594,
4990,
14907,
9738,
13108,
12387,
8101,
15031,
12923,
1790,
8143,
5865,
11756,
11038,
15396,
3491,
8060,
3520,
11714,
7607,
15420,
8147,
12312,
14692,
12354,
13349,
7602,
13261,
5001,
9970,
3436,
14878,
10077,
13351,
1785,
11739,
4991,
13188,
12390,
15421,
11718,
14037,
8118,
12128,
12389,
12132,
9737,
15160,
15159,
15147,
9117,
5002,
3558,
13955,
13936,
13942,
13957,
15399,
13870,
12930,
3467,
3468,
10157,
12881,
10211,
14029,
15161,
8837,
3573,
15670,
13353,
14690,
8155,
14030,
12398,
11676,
12335,
4278,
6621,
11778,
14028,
14031,
15412,
8135,
8134,
8090,
14378,
4163,
14026,
15369,
4275,
3567,
3565,
12349,
14032,
7780,
12297,
4270,
4269,
12690,
12689,
7604,
9961,
12371,
15662,
15663,
14385,
7609,
15144,
6392,
15317,
1930,
15294,
14286,
13340,
10687,
8982,
15360,
11722,
7614,
1848,
12392,
14687,
11150,
14784,
14363,
14680,
8092,
9972,
14045,
8122,
7785,
3568,
1797,
14183,
11587,
8057,
14166,
15674,
12399,
11586,
14837,
11588,
13324,
15030,
5878,
8098,
1879,
9978,
1800,
13346,
13337,
12393,
15442,
13314,
1780,
3469,
13951,
11788,
4988,
9503,
11557,
10223,
7586,
7589,
7588,
7587,
4987,
9727,
1906,
12306,
7777,
4830,
15437,
12884,
13360,
15390,
12879,
12116,
12118,
10087,
3542,
10068,
9726,
9728,
7613,
10165,
12401,
14894,
12133,
1761,
3483,
8088,
11128,
9109,
9110,
10148,
12882,
14167,
8058,
12900,
8089,
8980,
1909,
4159,
3536,
12120,
15363,
1867,
12403,
9625,
12928,
15302,
12134,
15179,
15301,
15115,
10145,
10144,
12875,
12876,
12343,
12344,
8730,
5016,
5018,
13665,
5019,
9105,
5874,
10082,
10083,
13662,
3539,
14875,
13663,
15393,
12353,
12380,
3571,
10137,
10138,
10141,
5873,
11143,
11781,
1775,
1771,
1774,
1773,
7517,
15029,
11119,
14768,
11148,
10147,
14659,
11144,
12880,
8125,
8127,
8087,
10661,
14876,
7600,
15112,
12913,
1428,
3554,
9104,
14675,
15284,
15282,
15286,
15285,
15283,
15373,
15028,
14049,
11716,
8591,
11760,
12394,
4822,
3540,
10218,
1187,
15660,
3487,
7998,
13932,
11024,
11011,
11017,
11010,
1825,
1826,
15619,
13240,
15617,
13239,
11139,
15628,
10233,
10208,
10207,
9116,
9115,
1852,
13943,
11536,
10252,
12929,
13258,
14658,
5022,
1851,
3825,
8083,
10131,
10098,
10104,
10118,
10121,
10111,
10114,
10128,
10134,
10107,
10125,
10101,
10130,
10097,
10103,
10117,
10120,
10110,
10113,
10127,
10133,
10106,
10124,
10100,
14753,
14756,
14755,
8139,
8140,
14785,
8086,
10063,
4277,
8002,
9098,
11754,
4273,
1883,
13342,
1793,
1794,
15668,
4274,
11105,
3537,
14759,
13956,
8043,
3538,
10160,
7601,
1746,
15114,
15433,
12313,
10660,
8048,
11134,
11138,
11136,
11135,
11137,
11109,
3514,
14861,
14827,
14823,
14824,
14828,
14829,
14860,
13935,
1118,
1117,
1123,
1122,
8031,
8012,
1116,
1119,
1121,
1124,
8037,
8020,
8051,
13299,
14678,
3449,
12368,
12355,
8052,
13948,
1422,
3303,
14021,
12911,
3569,
3450,
3477,
12633,
11720,
1911,
12369,
15364,
12885,
13255,
13256,
13257,
15424,
15423,
15425,
8055,
15416,
12878,
10069,
10070,
15391,
15093,
15095,
15096,
9108,
9112,
9113,
15099,
15097,
15098,
13253,
12113,
12119,
13875,
1791,
1792,
13298,
4829,
4626,
12915,
10139,
10059,
15300,
13306,
9900,
12687,
14898,
12117,
1765,
13334,
10686,
1776,
3446,
3445,
3444,
3443,
11111,
14757,
3566,
3447,
11110,
14761,
11113,
14762,
5015,
10684,
10683,
7575,
7579,
7576,
7578,
7573,
10682,
7574,
14036,
4999,
3560,
1743,
1189,
5023,
14171,
14175,
15338,
1811,
1814,
1815,
1813,
1819,
1817,
14019,
1806,
15357,
14850,
1818,
1810,
1823,
8831,
15145,
15636,
15347,
12311,
9954,
9955,
14682,
15358,
14684,
14685,
15332,
15334,
15335,
13317,
14035,
5877,
12332,
10216,
12307,
15351,
13318,
15419,
5876,
15450,
14043,
1882,
3417,
14178,
11152,
15326,
11787,
15329,
15356,
6605,
15441,
1880,
13315,
15354,
15344,
14177,
10080,
1821,
1822,
10079,
14686,
12333,
10217,
14044,
1888,
1887,
15627,
15349,
15350,
15331,
12305,
1899,
11589,
1777,
11721,
12301,
12302,
12294,
12296,
9081,
1407,
9089,
1415,
3512,
3503,
3513,
3504,
9080,
1406,
9088,
1414,
11547,
11516,
11550,
11519,
9082,
1408,
9090,
1416,
11548,
11517,
11551,
11520,
11752,
11753,
1425,
1426,
11083,
15611,
14740,
13229,
1910,
11527,
10685,
11535,
11544,
1935,
1858,
1859,
1860,
11581,
1861,
11525,
13626,
13635,
9628,
14836,
14908,
11593,
1751,
14868,
11776,
11777,
3479,
4157,
10679,
1744,
3473,
3474,
8132,
12907,
3494,
8136,
4831,
6613,
15379,
12347,
12905,
3302,
12904,
6597,
12908,
14839,
13303,
6226,
3476,
4992,
4996,
1720,
4997,
6622,
1588,
14906,
1779,
11734,
13645,
9962,
12348,
3484,
13260,
9106,
1828,
9103,
12400,
13262,
12339,
9118,
8153,
9102,
8152,
4998,
12321,
9099,
9736,
3824,
14033,
14848,
7606,
3561,
13865,
1581,
7515,
7516,
12126,
9512,
7617,
11112,
3485,
12374,
10238,
8091,
14379,
9973,
1881,
1580,
8126,
8130,
12241,
12924,
1579,
1755,
12121,
11783,
]

_charnames_128736 = [
11717,
1589,
12931,
5008,
14867,
5007,
15620,
15621,
15618,
1827,
9094,
6615,
6616,
-1,
-1,
-1,
1866,
12906,
13328,
12124,
1914,
5006,
10064,
1884,
15432,
1932,
6599,
-1,
-1,
-1,
-1,
-1,
6376,
6272,
6389,
6390,
6374,
6261,
6259,
6260,
6257,
6258,
6322,
6325,
6324,
6239,
6339,
6318,
6349,
6352,
6351,
6292,
6241,
6379,
6327,
6328,
6307,
6308,
6386,
6252,
6369,
6370,
6284,
6303,
6290,
6371,
6236,
6282,
6283,
6291,
6243,
6234,
6329,
6343,
6383,
6270,
6237,
6244,
6235,
6326,
6301,
6302,
6295,
6299,
6298,
6297,
6263,
6264,
6354,
6245,
6269,
6304,
6305,
6267,
6319,
6344,
6345,
6377,
6310,
6313,
6312,
6265,
6388,
6250,
6342,
6385,
6373,
6332,
6287,
6346,
6286,
6253,
6288,
6347,
6249,
6382,
6251,
6387,
6358,
6268,
6334,
6317,
6333,
6271,
6247,
6248,
6238,
6338,
6366,
6364,
6365,
6337,
6336,
6275,
6280,
6279,
6278,
6277,
6266,
6316,
6315,
6306,
6357,
6380,
6367,
6353,
6361,
6360,
]

_charnames_128896 = [
8029,
8034,
8010,
8017,
8001,
4118,
8066,
11566,
13631,
15138,
13921,
14893,
8040,
8000,
10678,
4116,
8065,
11565,
13630,
15137,
13930,
13931,
1685,
8042,
8046,
7987,
13938,
13939,
13323,
8041,
8045,
7986,
13941,
3463,
10680,
4117,
8070,
13638,
13636,
15142,
3462,
10677,
4104,
8069,
11526,
13628,
15141,
10670,
4109,
8071,
11577,
13637,
15143,
10676,
4102,
8068,
11522,
13627,
15140,
10681,
4114,
8072,
11563,
13633,
10674,
4112,
3448,
4111,
10667,
4108,
15408,
4107,
14834,
10671,
11578,
4103,
11523,
1188,
4115,
11562,
13634,
11561,
10673,
11572,
11571,
10240,
8758,
10241,
8759,
]

_charnames_128992 = [
11018,
11021,
11030,
11027,
11014,
11023,
11009,
11016,
11020,
11029,
11026,
11013,
]

_charnames_129024 = [
11069,
15596,
14724,
13216,
11072,
15599,
14727,
13219,
11073,
15600,
14728,
13220,
-1,
-1,
-1,
-1,
11070,
15597,
14725,
13217,
11074,
15601,
14729,
13221,
11534,
11569,
11575,
11556,
11533,
11568,
11574,
11555,
11056,
15583,
14711,
13202,
11057,
15584,
14712,
13203,
11059,
15587,
14714,
13206,
11058,
15585,
14713,
13204,
11055,
15582,
14710,
13201,
11090,
15612,
14747,
13230,
11080,
15606,
14737,
13223,
11093,
15613,
14750,
13231,
11086,
15609,
14743,
13226,
11087,
15610,
14744,
13227,
]

_charnames_129104 = [
11081,
15607,
14738,
13224,
9085,
9093,
1419,
1411,
11108,
15625,
-1,
-1,
-1,
-1,
-1,
-1,
14006,
13994,
14000,
14012,
13982,
13988,
13975,
13969,
14008,
13996,
14002,
14014,
13984,
13990,
13977,
13971,
14005,
13993,
13999,
14011,
13981,
13987,
13974,
13968,
14007,
13995,
14001,
14013,
13983,
13989,
13976,
13970,
14004,
13992,
13998,
14010,
13980,
13986,
13973,
13967,
]

_charnames_129168 = [
11064,
15592,
14719,
13212,
11091,
15603,
14748,
13228,
11071,
15598,
14726,
13218,
11539,
11543,
11542,
11541,
11076,
14734,
11066,
14721,
11092,
14741,
11084,
14749,
11078,
14735,
11089,
14746,
13954,
13953,
]

_charnames_129280 = [
10232,
10231,
10229,
11102,
11101,
11100,
11103,
11097,
13236,
13234,
13237,
13235,
-1,
13947,
7783,
12386,
15569,
4989,
15337,
8834,
3464,
15352,
14909,
11789,
988,
10086,
14865,
11116,
14765,
11677,
11678,
15318,
15346,
10154,
8978,
14899,
13348,
11161,
15359,
1926,
15330,
14174,
14176,
15353,
1901,
1809,
15328,
1583,
12379,
7788,
12098,
1903,
12370,
4272,
5010,
1591,
12303,
15667,
15449,
4964,
14048,
13864,
11675,
13326,
14022,
13352,
10163,
3521,
1783,
14367,
14790,
15386,
1905,
3465,
8099,
4473,
9506,
11039,
1424,
15434,
10212,
6620,
9515,
7603,
12338,
10072,
7616,
14165,
1563,
1756,
15132,
14376,
12319,
14688,
12129,
13105,
15405,
3296,
9740,
8082,
9510,
9975,
7786,
12395,
12377,
9514,
1862,
10065,
11122,
4279,
5014,
7618,
1808,
15675,
-1,
15341,
15348,
12921,
15428,
-1,
-1,
-1,
15340,
1872,
11037,
14370,
11784,
15439,
10224,
10692,
1913,
3519,
15634,
15158,
13106,
7444,
1561,
12927,
15415,
8138,
13310,
14368,
10691,
14942,
1592,
1688,
14380,
15567,
11595,
1864,
3574,
10219,
14656,
11163,
12316,
11782,
12111,
14874,
11155,
5021,
4824,
7621,
1936,
-1,
-1,
1891,
12870,
12901,
1929,
15440,
12925,
-1,
-1,
-1,
14284,
12375,
15089,
15090,
15091,
15088,
8100,
11127,
15411,
3556,
1724,
1723,
1869,
15157,
5009,
4276,
4156,
4155,
9624,
9509,
1873,
8128,
14382,
12912,
15367,
13876,
8137,
4622,
15313,
-1,
-1,
1745,
14693,
13311,
15343,
6512,
9735,
12691,
8117,
12295,
12299,
12304,
12300,
4625,
15370,
13672,
3987,
15032,
14362,
15568,
7773,
12899,
8150,
1918,
14374,
9979,
1430,
14846,
15380,
15669,
3544,
12320,
13361,
9901,
6623,
15378,
3557,
7781,
4624,
11162,
11153,
1784,
7582,
1870,
3546,
7784,
7564,
14900,
7612,
1787,
14841,
8977,
8801,
8817,
8813,
8825,
8791,
8821,
13891,
7938,
8800,
13898,
13912,
13909,
13920,
13890,
13915,
7945,
7959,
7956,
7967,
7937,
7962,
8804,
8820,
8816,
8828,
8799,
8824,
13889,
7936,
8798,
13902,
13904,
13903,
13906,
13901,
13905,
7949,
7951,
7950,
7953,
7948,
7952,
8808,
8810,
8809,
8812,
8807,
8811,
13886,
7933,
8795,
13897,
13911,
13908,
13919,
13887,
13914,
7944,
7958,
7955,
7966,
7934,
7961,
8803,
8819,
8815,
8827,
8796,
8823,
13888,
7935,
8797,
13916,
7963,
8829,
13917,
7964,
8830,
13894,
13893,
13895,
7941,
7940,
7942,
]

_charnames_129632 = [
15646,
15644,
15647,
15645,
15641,
15642,
15643,
15655,
15653,
15656,
15654,
15650,
15651,
15652,
-1,
-1,
7581,
12910,
7776,
1576,
-1,
-1,
-1,
-1,
13347,
6513,
1752,
-1,
-1,
-1,
-1,
-1,
15672,
14689,
12110,
]

_charnames_983040 = [
8590,
8589,
1737,
1429,
1735,
1766,
15106,
15077,
15104,
15167,
15117,
15116,
6618,
6617,
6393,
8124,
7598,
8159,
9729,
11729,
11790,
3300,
10658,
8726,
15110,
11164,
9129,
15169,
10656,
13642,
13666,
15406,
15456,
10073,
10203,
1586,
11147,
1190,
1587,
11146,
1,
13341,
13362,
13294,
13359,
13291,
13358,
13292,
13357,
13295,
13356,
8787,
8981,
1850,
1849,
15105,
15078,
10058,
10057,
15109,
15168,
1726,
1725,
15164,
15163,
15293,
15389,
15454,
15291,
14181,
14384,
15290,
14840,
14941,
15292,
15633,
15637,
1768,
13304,
13302,
12131,
12130,
11780,
11759,
7789,
8160,
9101,
9127,
15279,
15182,
8832,
8836,
1734,
1939,
15107,
15165,
9732,
11732,
11791,
9731,
11731,
11792,
10657,
13643,
13667,
12104,
12105,
12250,
12106,
12103,
12242,
14833,
14835,
14695,
1179,
1185,
1941,
1180,
1184,
1940,
13293,
13355,
12365,
12362,
12405,
12364,
12361,
12404,
1900,
1767,
10060,
10253,
4158,
5214,
1738,
1736,
1795,
15111,
15108,
15178,
1733,
1427,
1181,
1942,
1182,
1917,
9958,
10250,
1762,
1728,
12883,
12784,
12366,
12409,
6607,
6609,
9126,
1593,
10912,
10819,
10251,
6391,
1847,
14655,
11000,
11001,
11002,
11003,
3428,
11669,
11671,
11672,
11670,
15446,
15445,
15444,
5215,
15563,
15561,
15564,
11158,
14938,
11160,
14940,
12408,
11157,
14937,
9128,
5216,
14051,
11159,
14939,
15455,
12407,
14041,
4826,
4827,
11053,
14708,
15673,
13365,
13476,
13610,
13599,
13588,
13577,
13566,
13555,
13544,
13465,
13454,
13443,
13432,
13421,
13410,
13399,
12378,
8158,
8097,
15562,
9360,
9362,
4041,
4031,
4004,
3994,
11490,
8157,
13388,
13377,
13366,
13521,
13510,
13499,
13488,
13477,
13532,
13543,
13542,
13541,
13540,
13620,
13619,
13618,
13617,
13616,
13615,
13614,
13613,
13612,
13611,
13609,
13608,
13607,
13606,
13605,
13604,
13603,
13602,
13601,
13600,
13598,
13597,
13596,
13595,
13594,
13593,
13592,
13591,
13590,
13589,
13587,
13586,
13585,
13584,
13583,
13582,
13581,
13580,
13579,
13578,
13576,
13575,
13574,
13573,
13572,
13571,
13570,
13569,
13568,
13567,
13565,
13564,
13563,
13562,
13561,
13560,
13559,
13558,
13557,
13556,
13554,
13553,
13552,
13551,
13550,
13549,
13548,
13547,
13546,
13545,
13475,
13474,
13473,
13472,
13471,
13470,
13469,
13468,
13467,
13466,
13464,
13463,
13462,
13461,
13460,
13459,
13458,
13457,
13456,
13455,
13453,
13452,
13451,
13450,
13449,
13448,
13447,
13446,
13445,
13444,
13442,
13441,
13440,
13439,
13438,
13437,
13436,
13435,
13434,
13433,
13431,
13430,
13429,
13428,
13427,
13426,
13425,
13424,
13423,
13422,
13420,
13419,
13418,
13417,
13416,
13415,
13414,
13413,
13412,
13411,
13409,
13408,
13407,
13406,
13405,
13404,
13403,
13402,
13401,
13400,
13398,
13397,
13396,
13395,
13394,
13393,
13392,
13391,
13390,
13389,
13387,
13386,
13385,
13384,
13383,
13382,
13381,
13380,
13379,
13378,
13376,
13375,
13374,
13373,
13372,
13371,
13370,
13369,
13368,
13367,
13531,
13530,
13529,
13528,
13527,
13526,
13525,
13524,
13523,
13522,
13520,
13519,
13518,
13517,
13516,
13515,
13514,
13513,
13512,
13511,
13509,
13508,
13507,
13506,
13505,
13504,
13503,
13502,
13501,
13500,
13498,
13497,
13496,
13495,
13494,
13493,
13492,
13491,
13490,
13489,
13487,
13486,
13485,
13484,
13483,
13482,
13481,
13480,
13479,
13478,
13539,
13538,
13537,
13536,
13535,
13534,
13533,
]

_charnames_983552 = [
14676,
14677,
14671,
14672,
14663,
14664,
14669,
14670,
14666,
14667,
14674,
14673,
10925,
10810,
10878,
10716,
10880,
10718,
10881,
10719,
10889,
10727,
10890,
10728,
10944,
10754,
10750,
10846,
10915,
10779,
10917,
10781,
10918,
10782,
10902,
10741,
10894,
10702,
10924,
10809,
10923,
10808,
10884,
10722,
10883,
10721,
10887,
10725,
10886,
10724,
10749,
10748,
10943,
10753,
10942,
10752,
10957,
10865,
10954,
10798,
10963,
10861,
10937,
10837,
10898,
10709,
10897,
10708,
10895,
10703,
10893,
10701,
10813,
10776,
10777,
10768,
10769,
10738,
10739,
10853,
10854,
6123,
6127,
6124,
6129,
6128,
6126,
6130,
6125,
6131,
8107,
3152,
3141,
3160,
3140,
3149,
3138,
3148,
3137,
3156,
3157,
3154,
3150,
3145,
3155,
3147,
3146,
3151,
3139,
3158,
3144,
3143,
3142,
3159,
3153,
2955,
2960,
2961,
2956,
2957,
2962,
2963,
2954,
2958,
2959,
2953,
2838,
2843,
2844,
2839,
2840,
2845,
2846,
2837,
2841,
2842,
2836,
3098,
3103,
3104,
3099,
3100,
3105,
3106,
3097,
3101,
3102,
3096,
2825,
2830,
2831,
2826,
2827,
2832,
2833,
2824,
2828,
2829,
2823,
2969,
2974,
2975,
2970,
2971,
2976,
2977,
2968,
2972,
2973,
2967,
2812,
2817,
2818,
2813,
2814,
2819,
2820,
2811,
2815,
2816,
2810,
2981,
2986,
2987,
2982,
2983,
2988,
2989,
2980,
2984,
2985,
2979,
2850,
2855,
2856,
2851,
2852,
2857,
2858,
2849,
2853,
2854,
2848,
3046,
3051,
3052,
3047,
3048,
3053,
3054,
3045,
3049,
3050,
3044,
3059,
3064,
3065,
3060,
3061,
3066,
3067,
3058,
3062,
3063,
3057,
3020,
3025,
3026,
3021,
3022,
3027,
3028,
3019,
3023,
3024,
3018,
3007,
3012,
3013,
3008,
3009,
3014,
3015,
3006,
3010,
3011,
3005,
2929,
2934,
2935,
2930,
2931,
2936,
2937,
2928,
2932,
2933,
2927,
3033,
3038,
3039,
3034,
3035,
3040,
3041,
3032,
3036,
3037,
3031,
2905,
2910,
2911,
2906,
2907,
2912,
2913,
2904,
2908,
2909,
2903,
2917,
2922,
2923,
2918,
2919,
2924,
2925,
2916,
2920,
2921,
2915,
2995,
3000,
3001,
2996,
2997,
3002,
3003,
2994,
2998,
2999,
2993,
2800,
2805,
2806,
2801,
2802,
2807,
2808,
2799,
2803,
2804,
2798,
3072,
3077,
3078,
3073,
3074,
3079,
3080,
3071,
3075,
3076,
3070,
2864,
2869,
2870,
2865,
2866,
2871,
2872,
2863,
2867,
2868,
2862,
2878,
2883,
2884,
2879,
2880,
2885,
2886,
2877,
2881,
2882,
2876,
2890,
2895,
2896,
2891,
2892,
2897,
2898,
2889,
2893,
2894,
2888,
3085,
3090,
3091,
3086,
3087,
3092,
3093,
3084,
3088,
3089,
3083,
2940,
2943,
2948,
2949,
2944,
2945,
2950,
2951,
2942,
2946,
2947,
2941,
2873,
1175,
1174,
1173,
14352,
14583,
14581,
14582,
14580,
14576,
14589,
14587,
14588,
14586,
14574,
14604,
14567,
14603,
14566,
14577,
14572,
14570,
14571,
14569,
14575,
14610,
14597,
14598,
14596,
14608,
14605,
14607,
14600,
14606,
14592,
14591,
14593,
14609,
14601,
14619,
14615,
14612,
14613,
14616,
14618,
14620,
11768,
11766,
11764,
11767,
11765,
14633,
14631,
14629,
14632,
14630,
14640,
14637,
14638,
14639,
4962,
4961,
]

def lookup_charcode(code):
    res = -1
    if code == 895: res = 14163
    elif 1318 <= code <= 1327: res = _charnames_1318[code-1318]
    elif code == 1376: res = 6222
    elif 1416 <= code <= 1423: res = _charnames_1416[code-1416]
    elif code == 1519: res = 11596
    elif code == 1540: res = 6132
    elif code == 1541: res = 6217
    elif code == 1564: res = 6163
    elif code == 1568: res = 6168
    elif code == 1631: res = 6216
    elif code == 2045: res = 9123
    elif code == 2046: res = 9122
    elif code == 2047: res = 9124
    elif 2112 <= code <= 2154: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2259 <= code <= 2303: res = _charnames_2259[code-2259]
    elif code == 2362: res = 13283
    elif code == 2363: res = 13282
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 13272
    elif code == 2420: res = 13271
    elif code == 2421: res = 13275
    elif code == 2422: res = 13269
    elif code == 2423: res = 13268
    elif code == 2424: res = 13276
    elif code == 2432: res = 8109
    elif code == 2556: res = 8106
    elif code == 2557: res = 8110
    elif code == 2558: res = 8111
    elif code == 2678: res = 14285
    elif code == 2800: res = 14281
    elif 2809 <= code <= 2815: res = _charnames_2809[code-2809]
    elif code == 2930: res = 12891
    elif code == 2931: res = 12892
    elif code == 2932: res = 12896
    elif code == 2933: res = 12890
    elif code == 2934: res = 12893
    elif code == 2935: res = 12895
    elif code == 3072: res = 3528
    elif code == 3076: res = 3529
    elif code == 3124: res = 3533
    elif code == 3162: res = 3532
    elif code == 3191: res = 3530
    elif code == 3200: res = 14652
    elif code == 3201: res = 14654
    elif code == 3204: res = 14653
    elif code == 3328: res = 4585
    elif code == 3329: res = 4587
    elif code == 3369: res = 4580
    elif code == 3386: res = 4579
    elif code == 3387: res = 4588
    elif code == 3388: res = 4586
    elif 3406 <= code <= 3423: res = _charnames_3406[code-3406]
    elif code == 3446: res = 4567
    elif code == 3447: res = 4569
    elif code == 3448: res = 4572
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif 3718 <= code <= 3736: res = _charnames_3718[code-3718]
    elif code == 3744: res = 10992
    elif code == 3752: res = 10995
    elif code == 3753: res = 10994
    elif code == 3756: res = 10988
    elif code == 3770: res = 11004
    elif code == 3806: res = 10998
    elif code == 3807: res = 10997
    elif code == 3980: res = 3424
    elif code == 3981: res = 3422
    elif code == 3982: res = 3421
    elif code == 3983: res = 3423
    elif code == 4057: res = 3427
    elif code == 4058: res = 3426
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 14355
    elif code == 4350: res = 14354
    elif code == 4351: res = 14353
    elif code == 4957: res = 15076
    elif code == 4958: res = 15075
    elif 5109 <= code <= 5117: res = _charnames_5109[code-5109]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6264: res = 4983
    elif code == 6429: res = 10690
    elif code == 6430: res = 10689
    elif 6832 <= code <= 6846: res = _charnames_6832[code-6832]
    elif code == 7083: res = 1712
    elif code == 7084: res = 1711
    elif code == 7085: res = 1710
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 7506
    elif code == 7165: res = 7504
    elif code == 7166: res = 7507
    elif code == 7167: res = 7505
    elif 7296 <= code <= 7304: res = _charnames_7296[code-7296]
    elif 7312 <= code <= 7367: res = _charnames_7312[code-7312]
    elif 7411 <= code <= 7418: res = _charnames_7411[code-7411]
    elif 7655 <= code <= 7676: res = _charnames_7655[code-7655]
    elif code == 8294: res = 11118
    elif code == 8295: res = 14767
    elif code == 8296: res = 15385
    elif code == 8297: res = 12352
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif 8377 <= code <= 8383: res = _charnames_8377[code-8377]
    elif code == 8586: res = 3508
    elif code == 8587: res = 3509
    elif 9193 <= code <= 9215: res = _charnames_9193[code-9193]
    elif code == 9934: res = 12886
    elif code == 9954: res = 6603
    elif code == 9956: res = 12310
    elif code == 9957: res = 14769
    elif code == 9958: res = 11120
    elif code == 9959: res = 15298
    elif 9984 <= code <= 9995: res = _charnames_9984[code-9984]
    elif code == 10024: res = 1798
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 11530
    elif code == 10080: res = 11531
    elif code == 10133: res = 11579
    elif code == 10134: res = 11580
    elif code == 10135: res = 11558
    elif code == 10160: res = 9505
    elif code == 10175: res = 13250
    elif code == 10187: res = 4620
    elif code == 10189: res = 4621
    elif code == 10190: res = 1626
    elif code == 10191: res = 1625
    elif code == 11085: res = 13209
    elif code == 11086: res = 1575
    elif code == 11087: res = 1574
    elif 11098 <= code <= 11263: res = _charnames_11098[code-11098]
    elif code == 11506: res = 9950
    elif code == 11507: res = 9949
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 3432
    elif code == 11623: res = 3431
    elif code == 11632: res = 3433
    elif code == 11647: res = 3434
    elif 11826 <= code <= 11855: res = _charnames_11826[code-11826]
    elif code == 12590: res = 8075
    elif code == 12591: res = 8076
    elif code == 12728: res = 8078
    elif code == 12729: res = 8077
    elif code == 12730: res = 8074
    elif code == 13055: res = 1687
    elif code == 42592: res = 10200
    elif code == 42593: res = 10181
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif 42648 <= code <= 42655: res = _charnames_42648[code-42648]
    elif 42893 <= code <= 42950: res = _charnames_42893[code-42893]
    elif code == 42999: res = 10973
    elif code == 43000: res = 4959
    elif code == 43001: res = 4952
    elif code == 43002: res = 10969
    elif code == 43205: res = 1865
    elif code == 43260: res = 13287
    elif code == 43261: res = 13288
    elif code == 43262: res = 13274
    elif code == 43263: res = 13285
    elif 43488 <= code <= 43518: res = _charnames_43488[code-43488]
    elif code == 43644: res = 5211
    elif code == 43645: res = 5210
    elif code == 43646: res = 5193
    elif code == 43647: res = 5192
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43879: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 43967: res = _charnames_43888[code-43888]
    elif code == 64046: res = 10249
    elif code == 64047: res = 10248
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 65063 <= code <= 65071: res = _charnames_65063[code-65063]
    elif code == 65931: res = 14160
    elif code == 65932: res = 14159
    elif code == 65933: res = 14162
    elif code == 65934: res = 9119
    elif code == 65952: res = 14158
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 12683
    elif code == 66349: res = 12680
    elif code == 66350: res = 12682
    elif code == 66351: res = 12681
    elif 66384 <= code <= 66426: res = _charnames_66384[code-66384]
    elif 66736 <= code <= 66855: res = _charnames_66736[code-66736]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 10056
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67680 <= code <= 67742: res = _charnames_67680[code-67680]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67839: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68095: res = _charnames_67968[code-67968]
    elif code == 68148: res = 14624
    elif code == 68149: res = 14623
    elif code == 68168: res = 14625
    elif 68224 <= code <= 68255: res = _charnames_68224[code-68224]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68480 <= code <= 68497: res = _charnames_68480[code-68480]
    elif code == 68505: res = 12287
    elif code == 68506: res = 12286
    elif code == 68507: res = 12285
    elif code == 68508: res = 12284
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif 68858 <= code <= 68903: res = _charnames_68858[code-68858]
    elif 68912 <= code <= 68921: res = _charnames_68912[code-68912]
    elif 69376 <= code <= 69415: res = _charnames_69376[code-69376]
    elif 69424 <= code <= 69465: res = _charnames_69424[code-69424]
    elif 69600 <= code <= 69622: res = _charnames_69600[code-69600]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif code == 69759: res = 7722
    elif 69837 <= code <= 69864: res = _charnames_69837[code-69837]
    elif 69872 <= code <= 69958: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70751: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71352: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71680 <= code <= 71739: res = _charnames_71680[code-71680]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 13783
    elif 72096 <= code <= 72164: res = _charnames_72096[code-72096]
    elif 72192 <= code <= 72263: res = _charnames_72192[code-72192]
    elif 72272 <= code <= 72354: res = _charnames_72272[code-72272]
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 72960 <= code <= 73031: res = _charnames_72960[code-72960]
    elif 73040 <= code <= 73112: res = _charnames_73040[code-73040]
    elif 73120 <= code <= 73129: res = _charnames_73120[code-73120]
    elif 73440 <= code <= 73464: res = _charnames_73440[code-73440]
    elif 73664 <= code <= 73713: res = _charnames_73664[code-73664]
    elif code == 73727: res = 3200
    elif 74607 <= code <= 74649: res = _charnames_74607[code-74607]
    elif 74851 <= code <= 74868: res = _charnames_74851[code-74851]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 78896 <= code <= 78904: res = _charnames_78896[code-78896]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93760 <= code <= 93850: res = _charnames_93760[code-93760]
    elif 93952 <= code <= 94087: res = _charnames_93952[code-93952]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 2788
    elif code == 94177: res = 8588
    elif code == 94178: res = 12686
    elif code == 94179: res = 12685
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif 110592 <= code <= 110878: res = _charnames_110592[code-110592]
    elif code == 110928: res = 11771
    elif code == 110929: res = 11772
    elif code == 110930: res = 11770
    elif code == 110948: res = 14645
    elif code == 110949: res = 14646
    elif code == 110950: res = 14644
    elif code == 110951: res = 14647
    elif 110960 <= code <= 111355: res = _charnames_110960[code-110960]
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119520 <= code <= 119539: res = _charnames_119520[code-119520]
    elif 119666 <= code <= 119672: res = _charnames_119666[code-119666]
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 123136 <= code <= 123215: res = _charnames_123136[code-123136]
    elif 123584 <= code <= 123647: res = _charnames_123584[code-123584]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126065 <= code <= 126132: res = _charnames_126065[code-126065]
    elif 126209 <= code <= 126269: res = _charnames_126209[code-126209]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 6050
    elif code == 126705: res = 6051
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif code == 127243: res = 13321
    elif code == 127244: res = 13320
    elif 127279 <= code <= 127404: res = _charnames_127279[code-127279]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127547: res = _charnames_127538[code-127538]
    elif code == 127568: res = 10236
    elif code == 127569: res = 10237
    elif code == 127584: res = 14890
    elif code == 127585: res = 14889
    elif code == 127586: res = 14887
    elif code == 127587: res = 14888
    elif code == 127588: res = 14886
    elif code == 127589: res = 14891
    elif 127744 <= code <= 128725: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128883: res = _charnames_128736[code-128736]
    elif 128896 <= code <= 128984: res = _charnames_128896[code-128896]
    elif 128992 <= code <= 129003: res = _charnames_128992[code-128992]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129280 <= code <= 129619: res = _charnames_129280[code-129280]
    elif 129632 <= code <= 129666: res = _charnames_129632[code-129632]
    elif code == 129680: res = 14786
    elif code == 129681: res = 9733
    elif code == 129682: res = 14879
    elif code == 129683: res = 6619
    elif code == 129684: res = 13325
    elif code == 129685: res = 7590
    elif 983040 <= code <= 983507: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983993: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2CEA1 or 0x2CEB0 <= code <= 0x2EBE0):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2CEA1 or 0x2CEB0 <= code <= 0x2EBE0):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'N', 15360),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AL', 'N', 4160),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sc', 'R', 'N', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'N', 4608),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklmnopqrstuvwxyz{|}\x15\x15\x15~\x7f\x80yyyyyyyyyy\x15\x15\x15\x15\x81yyyyyyyyyyy'
'yyyy\x15\x15\x82yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy\x15\x15\x83\x84yy\x85\x865555555555555555'
'5555555\x8755\x88yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy5\x89\x8ayyyyyyyyy\x8byyy'
'yyyyyyyyyyyyyyyy\x8c\x8d\x8e\x8f\x90\x91\x92\x93((\x94yyyyy\x95\x96\x97yyyyy\x98\x99yy\x9a\x9b\x9cy\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7yyyyy'
'\xa8\xa95555555\xaa\xab\xac55555555555555555555555\xad55555\xae55555555555555555\xaf5555'
'5555555555555555555555555555555555\xb055555555555555555555555555555'
'55555555555555555555555555555555555555\xb15555555555555555\xb2\xb35555555'
'55555555555555\xb45555555555555555555555555555\xb5\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xad5\xb7\xb6\xb6\xb6\xb6\xb8'
'\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6'
'\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6'
'\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6'
'\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb6\xb8'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'\xb9\xbayyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xbb'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xbb'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd9\x92\x92\x87\xa4\x87\x92\x93\x9cq\x92\xb2\x80g\x81\x80FFFFFFFFFF\x81\x92\xc0\xbf\xc0\x92'
'\x9288888888888888888888888888\x9c\x92q\xacd\xac\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9c\xbfq\xbf\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd6\x8a\xa4\xa4\xa0\xa4\xd1\x8a\xa9\xcf-z\xbf\x07\xcc\xac\xc4\xb4TT\xa9\x1b\x8a\x8c\xa9T-v[[[\x8a'
'77777757777777775777777\xb75777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb7\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xab\xab\xa9\xab)')''')'))\x1f$\xab\xab\xab\xab\xab\xab\xa9\xa9\xa9\xa9\xab\xa9\xab\xa9%%%%%\xab\xab\xab\xab\xab\xab\xab)\xab$\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xab7\x1b\x15\x15#\x1b\x1b\x1b\x907'
'\x15\x15\x15\x15\xab\xab7\x91777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xbc7\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xca@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x89\x89\x89\x89\x89\x89\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89j\x15\x15\xcf\xcf\xa3\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@l@'
'\x96@@\x96@@\x96@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x153333\x96\x97\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xbc\xbc\xae\x86\x86\x9f\x7f{\xcf\xcf@@@@@@@@@@@{\x05\x15{{,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@CCCCCCCCCC\x86||{,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,{,@@@@@@@\x06\xcf@@@@@@\x1e\x1e@@\xcf@@@@,,EEEEEEEEEE,,,\xc3\xc3,'
'{{{{{{{{{{{{{{\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'HHHHHHHHHH333333333333333333333333333333333@@@@@@@@@**\xcf\x90\x90\x90*\x15\x15@\xa6\xa6'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x15'
'3333333333333333333333333@@@\x15\x15\x96\x15,,,,,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15,,,,,,,,\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@\x06@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x89\x89GGGGGGGGGG\x89$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG00\xa3\xa3XXXXXX\xca\xa30\x89@\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG@@000@\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x89\xa3\x15\x15\x15\x15\x15\x15\x150@@@@@@'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG\xca0XXXXXX\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGXXX\xcf\xcf\xcf\xcf\xcf\xcf\xa3\xcf\x15\x15\x15\x15\x15'
'@:::@00000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x89]]]]]]]\xca'
'0@::\x8900000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15GGGGGGGGGG\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15000\x1500000000000000000000000000000000000000000@@0::'
':@@@@\x15:::\x15:::@0\xca\x15\x15\x15\x15000:XXXXXXX000@@\x15\x15GGGGGGGGGGXXXXXXXXX\xca000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15::\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa3'
'000000$@@@@@@@@\x89GGGGGGGGGG\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x1500000\x15000000000000000000000000\x150\x150000000000@0/@@@@@@@@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15GGGGGGGGGG\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xca\xca\xca\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\xca\x89\xca\xca\xca@@\xca\xca\xca\xca\xca\xcaGGGGGGGGGGXXXXXXXXXX\xca@\xca@\xca@\x9bp\x9bp::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x89@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xca\xca'
'\xca\xca\xca\xca\xca\xca@\xca\xca\xca\xca\xca\xca\x15\xca\xca\x89\x89\x89\x89\x89\xca\xca\xca\xca\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'GGGGGGGGGG\x89\x89\x89\x89\x89\x89000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:GGGGGGGGGG:::@\xca\xca77777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89$\x1b\x1b\x1b'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x89\x89\x89\x89\x89\x89\x89\x89\x89YYYYYYYYYXXXXXXXXXXX\x15\x15\x15'
'0000000000000000\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'j000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\xca\x8900000000000000000'
'\xd800000000000000000000000000\x9bp\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x89\x89\x89KKK00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x89\x89\x89$\x89\x89\x89\xa30@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15]]]]]]]]]]\x15\x15\x15\x15\x15\x15'
'\x90\x90\x90\x90\x90\x90j\x90\x90\x90\x90@@@\x08\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$00000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'00000AA0000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcf\x15\x15\x15\x90\x90GGGGGGGGGG000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15GGGGGGGGGGY\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'00000000000000000000000@@::@\x15\x15\x89\x8900000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89\x89\x89\x89$\x89\x89\x89\x89\x89\x89\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15GGGGGGGGGG\x89\x89\x89\x89\x89\x89\x89\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@@@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00GGGGGGGGGG000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x89\x89\x89\x89\x89'
'GGGGGGGGGG\x15\x15\x15000GGGGGGGGGG000000000000000000000000000000$$$$$$\x89\x89'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x157777777777777777777777777777777777777777777\x15\x15777'
'\x89\x89\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15@@@\x89@@@@@@@@@@@@@:@@@@@@@0000@000000@00:@@0\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15@@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xab\x1b\xab'
'\xab\xab\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\xab\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xab\xab\xab\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xab\xab\xab\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\x15'
'\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\x08\x08\x08\n\x11ijjiii\x8a\x90xu\x9aywt\x9ay\x8a\x8a\x8a\x90\x8b\x8a\x8a\x8b\xd4\xd5\x0b\x12\x0f\r\x14\xd6\x84\x86\x84\x84\x86\x8a\x90\x90\x90zv\x8a\x90\x90\x8ac'
'c\x90\x90\x90\xaf\x9bp\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xbc\x90c\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xd8\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08V%\x15\x15TVVVVV\xb1\xb1\xbc\x9bp '
'VTTTTVVVVV\xb1\xb1\xbc\x9bp\x15%%%%%%%%%%%%%\x15\x15\x15\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa2\xa3\xa3\xa0\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf7\xcc\xcf\xcc\xcf7\xcf\xcc\x1b777\x1b\x1b777\x19\xcf7\xcc\xcf\xbe77777\xcf\xcf\xcf\xcc\xcc\xcf7\xcf5\xcf7\xcf7577\xc6\x1b7777\x1b0000\x1b\xcf\xcf\x1b\x1b77'
'\xbd\xbc\xbc\xbc\xbc7\x1b\x1b\x1b\x1b\xcf\xbc\xcf\xcf\x1b\xca]]][[]]]]]][[[[]IIIIIIIIIIIILLLLJJJJJJJJJJMMMMMM'
'KKK7\x1bKKKK[\xcf\xcf\x15\x15\x15\x15\xb7\xb7\xb7\xb7\xb7\xcc\xcc\xcc\xcc\xcc\xbc\xbc\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xcf\xcf\xb7\xcf\xb7\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xb7\xbd\xb8\xb8\xbd\xbc\xbc\xb7\xb8\xbd\xbd\xb8\xbd\xbd\xbc\xb7\xbc\xb8\xb1\xb5\xbc\xb8\xbd\xbc\xbc\xbc\xb8\xbd\xbd\xb8\xb7\xb8\xb8\xbd\xbd\xb7\xbd\xb7\xbd\xb7\xb7\xb7\xb7\xb8\xb8\xbd\xb8\xbd\xbd\xbd\xbd\xbd\xb7\xb7\xb7\xb7\xbc\xbd\xbc\xbd\xb8\xb8\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xb8\xbd\xbd\xbd\xb8\xbc\xbc\xbc\xbc\xbc\xb8\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xb8\xb7\xbd\xbc\xb8\xb8\xb8\xb8\xbd\xbd\xb8\xb8\xbc\xbc\xb8\xb8\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xb8\xb8\xbd\xbd\xb8\xb8\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xb7\xbc\xbc\xbd\xb7\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xb7\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xb8'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9bp\x9bp\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xbd\xbd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9es\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcf\xbc\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xca\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xd2\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\[[[[[[[[[[[\\\\\\\\\\\\\\\\\\[[['
'[[[[[[[[TTTTTTTTTSSSSSSSSSSS\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9^[[[[[[[[[[\\\\\\\\\\\\\\\\\\[\\'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcc\xb7\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf'
'\xcc\xb7\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcf\xcf\xcc\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xc1\xc1\xbc'
'\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcc\xcc\xcc\xcf\xcc\xcc\xcc\xcc\xcf\xcc\xcc\xcf\xb7\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xca\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcc'
'\xcf\xcf\xcf\xcf\xd2\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xd2\xd2\xcc\xd2\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xd2\xcc\xcc'
'\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\\\\\\\\\\\\\\\\\\['
'^^^^^^^^^]^^^^^^^^^]\xcf\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2'
'\xbd\xbc\xbc\xbd\xbd\x9bp\xbc\xbd\xbd\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\x9cq\x9cq\x9cq\x9cq\x9bp\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\x9bp\x9cq\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbc\xbc\x9bp\x9bp\xbd\xbc\xbc\xbc\xbc\xbd\xbc\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\x9bp\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbc\xbd\xbc\xbc\xbd\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbc\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbc\xbc'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd0\xcf'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcf\xcf\xcf\xcf\xcf\xcf7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x90\x90\x90\x90]\x90\x90'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x90\x90zvzv\x90\x90\x90zv\x90zv\x90\x90\x90\x90\x90\x90\x90\x90\x90j\x90\x90j\x90zv\x90\x90zv\x9bp\x9bp\x9bp\x9bp\x90\x90\x90\x90\x90(\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90jj\x90\x90\x90\x90'
'j\x90\x9a\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15'
'\xd7\x94\x94\x94\xd2&1N\x9es\x9es\x9es\x9es\x9es\xd2\xd2\x9es\x9es\x9es\x9esk\x9drr\xd2NNNNNNNNNBBBB;;k&&&&&\xd2\xd2NNN&1\x94\xd2\xcf'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15BB\xad\xad&&1k1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x94&&&1'
'\x15\x15\x15\x15\x151111111111111111111111111111111111111111111\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xcb\xcbZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb111111111111111111111111111\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\x15ZZZZZZZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcbWWWWWWWW\xd2_______________\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xcb'
'ZZZZZZZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb_______________'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xd2\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xd2\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x89\x89'
'000000000000$\x90\x90\x900000000000000000GGGGGGGGGG00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x90@@@@@@@@@@\x90)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000KKKKKKKKKK@@\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15'
'\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab)))))))))\xab\xab7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa8\xa87\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77777\x1b77777\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x15\x157\x1b777\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcf\xcf\xcf\xcf\x15\x15\x15\x15XXXXXX\xca\xca\xa3\xc5\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@@\x15\x15\x15\x15\x15\x15\x15\x15\x89\x89GGGGGGGGGG\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x89\x89\x890\x8900@'
'GGGGGGGGGG0000000000000000000000000000@@@@@@@@\x89\x890000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8911111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@@::'
':\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x15$GGGGGGGGGG\x15\x15\x15\x15\x89\x8900000@$000000000GGGGGGGGGG00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15GGGGGGGGGG\x15\x15\x89\x89\x89\x890000000000000000$000000\xca\xca\xca0:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x89\x8900000000000:@@::\x89\x890$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa8%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x89:@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xb13333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7'
'\xa7\xa7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,o\x9a'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9f\xcf\x15\x15'
'>>>>>>>>>>>>>>>>\x94\x94\x94\x95\x94\x94\x94\x9dr\x94\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x94kkee\x9dr\x9dr\x9dr\x9dr\x9dr\x9d'
'r\x9dr\x9dr\x94\x94\x9dr\x94\x94\x94\x94eee\x82\x94\x83\x15\x94\x83\x94\x94k\x9es\x9es\x9es\x88\x94\x94\xb3h\xc2\xc2\xc1\x15\x94\xa5\x88\x94\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8d\x8d\x85\xa1\x85\x8d\x8e\x98m\x8d\xb0}f~}DDDDDDDDDD~\x8d\xba\xb9\xba\x8d\x8d66666666666666666666666666\x98\x8dm\xaab'
'\xaa\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x98\xb9m\xb9\x98m\x8f\x99n\x8f\x8f.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\xa1\xa1\xb9\xaa\xcd\xa1\xa1\x15\xce\xbb\xbb\xbb\xbb\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcf\xcc\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x89\x90\x89\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO]]]]\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf]]\xcf\xca\xca\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@UUUUUUUUUUUUUUUUUUUUUUUUUUU\x15\x15\x15\x15'
'00000000000000000000000000000000XXXX\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000'
'0K00000000K\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8900000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x89KKKKK\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x157777777777777777'
'77777777777777777777\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x96````````33333333333333333333333\xd3\xd3```````'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15`````````\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15`````'
'3333333333333333333333``````\x15\x15\x15\x9033333333333333333333333333\x15\x15\x15\x15\x15\x96'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15``33'
'````````````````\x15\x15``````````````````````````````````````````````'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x1533333333333333333333333333333\x15\x15@@@\x15\x15\x15\x15@'
'aaaa`````\x15\x15\x15\x15\x15\x15\x15\x96\x96\x96\x96\x96\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333``\x96'
'33333333333333333333333333333```\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xd33333333333333333333333333333@@\x15\x15\x15\x15`````\x96\x96\x96\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x90\x90\x90\x90\x90\x90\x90'
'3333333333333333333333\x15\x15````````3333333333333333333\x15\x15\x15\x15\x15````````'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15```````\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15``````'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@\x15\x15\x15\x15\x15\x15\x15\x15CCCCCCCCCC\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15RRRRRRRRRQQQQQQQQQQQQQQQQQQQQQQ\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333``````````3\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,'
',,,,,,@@@@@@@@@@@PPPP{{{{{\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1533333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x89\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15^^^^^^^^^]]]]]]]]]]]GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x89\x89\n\x89\x89'
'\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\n\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15GGGGGGGGGG'
'\x89\x89\x89\x890::\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x89\x890\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x89\x89\x89\x89@@@@\x89\x15\x15GGGGGGGGGG0\x890\x89\x89\x89\x15XXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x89\x89\x89\x89\x89\x89@\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x89\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15@@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000000000:::@@@@@@@@'
'::@@@:@0000\x89\x89\x89\x89\x89GGGGGGGGGG\x15\x89\x15\x89@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x890\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x890000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x89\x89\x890\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@0\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15GGGGGGGGGGXX\x89\x89\x89\xca'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000:::@@@@@@@@@:@@\x89\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bGGGGGGGGGGXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x150000000000000000000000'
'00000000000000000:::@@@@\x15\x15@@::::@0\x890:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0@@@@@@==@@0000000000000000000000000000000000000000@@@@@@:0@@@@\x89'
'\x89\x89\x89\x89\x89\x89\x89@\x15\x15\x15\x15\x15\x15\x15\x150@@@@@@::@@@000000000000000000000000000000000000'
'0000000000@@@@@@@@@@@@@:@@\x89\x89\x890\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000\x150000000000000000000000000000000000000:@@@@@@@\x15@@@@@@:='
'0\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x89\x8900000000000000'
'0000000000000000\x15\x15@@@@@@@@@@@@@@@@@@@@@@\x15:@@@@@@@:@@:@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x1500\x1500000000000000000000000000000000000000@@@@@@\x15\x15\x15@\x15@@\x15@'
'@@@@@@0@\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15000000\x1500\x150000000000000000000000'
'0000000000:::::\x15@@\x15::@:@0\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000@@::\x89\x89\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'XXXXXXXXXXXXXXXXXXXXX\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xa3\xa3\xa3\xa3\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x89'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x15\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\n\n\n\n\n\n\n\n\n\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15GGGGGGGGGG\x15\x15\x15\x15\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x89\x89\x89\x89\x89\xca\xca\xca\xca'
'$$$$\x89\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15XXXXXXX\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'XXXXXXXXXXXXXXXXXXXXXXX\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000\x15\x15\x15\x15@0:::::::::::::::::::::::::::::::::::::::::::::::'
'::::::::\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15&&\x94&\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111111111\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xca@@\x89\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca::@@@\xca\xca\xca::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xca\xca@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf@@@\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xca\xca\xca\xca@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca@\xca\xca\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@@@@\x15@@@@@@@@@@@@@@@@@\x15\x15@@@@@@@\x15@@\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000\x15\x15\x15@@@@@@@$$$$$$$\x15\x15'
'GGGGGGGGGG\x15\x15\x15\x150\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000@@@@GGGGGGGGGG\x15\x15\x15\x15\x15\xa3'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15`````````@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'9999999999999999999999999999999999\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'\x1d\x1d\x1d\x1d@@@@@@@*\x15\x15\x15\x15HHHHHHHHHH\x15\x15\x15\x15\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15PPPPPPPPPPPPPPP'
'PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP\xc3PPP\x9fPPPP\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP\xc3PPPPPPPPPPPPPPP\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xbc\xbc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'TTTTTTTTTTT]]\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xca\xcf\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc7\xc7\xc7\xc7\xc7\xc7\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xcf\xcf\xcf\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc7\xc7\xc7\xc7\xcb\xc7\xc7\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xcb\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\x15\x15\x15\x15'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xd2\xd2\xd2\xad\xad\xad\xad\xad'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf'
'\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xd2\xd2\xd2\xcf\xcf\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\x15\x15\x15\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\xd2\xd2\xd2\xd2\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xd2\xd2\xd2\xd2\x15\x15\x15\x15\xd2\xd2\xd2\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x15\x15'
'\x15\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x15'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
68912: 0,
68913: 1,
68914: 2,
68915: 3,
68916: 4,
68917: 5,
68918: 6,
68919: 7,
68920: 8,
68921: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
73040: 0,
73041: 1,
73042: 2,
73043: 3,
73044: 4,
73045: 5,
73046: 6,
73047: 7,
73048: 8,
73049: 9,
73120: 0,
73121: 1,
73122: 2,
73123: 3,
73124: 4,
73125: 5,
73126: 6,
73127: 7,
73128: 8,
73129: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
123200: 0,
123201: 1,
123202: 2,
123203: 3,
123204: 4,
123205: 5,
123206: 6,
123207: 7,
123208: 8,
123209: 9,
123632: 0,
123633: 1,
123634: 2,
123635: 3,
123636: 4,
123637: 5,
123638: 6,
123639: 7,
123640: 8,
123641: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
68912: 0,
68913: 1,
68914: 2,
68915: 3,
68916: 4,
68917: 5,
68918: 6,
68919: 7,
68920: 8,
68921: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
73040: 0,
73041: 1,
73042: 2,
73043: 3,
73044: 4,
73045: 5,
73046: 6,
73047: 7,
73048: 8,
73049: 9,
73120: 0,
73121: 1,
73122: 2,
73123: 3,
73124: 4,
73125: 5,
73126: 6,
73127: 7,
73128: 8,
73129: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
123200: 0,
123201: 1,
123202: 2,
123203: 3,
123204: 4,
123205: 5,
123206: 6,
123207: 7,
123208: 8,
123209: 9,
123632: 0,
123633: 1,
123634: 2,
123635: 3,
123636: 4,
123637: 5,
123638: 6,
123639: 7,
123640: 8,
123641: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3416: 1.0 / 160.0,
3417: 1.0 / 40.0,
3418: 3.0 / 80.0,
3419: 1.0 / 20.0,
3420: 1.0 / 10.0,
3421: 3.0 / 20.0,
3422: 1.0 / 5.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3446: 1.0 / 16.0,
3447: 1.0 / 8.0,
3448: 3.0 / 16.0,
3558: 0.0,
3559: 1.0,
3560: 2.0,
3561: 3.0,
3562: 4.0,
3563: 5.0,
3564: 6.0,
3565: 7.0,
3566: 8.0,
3567: 9.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43504: 0.0,
43505: 1.0,
43506: 2.0,
43507: 3.0,
43508: 4.0,
43509: 5.0,
43510: 6.0,
43511: 7.0,
43512: 8.0,
43513: 9.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65931: 1.0 / 4.0,
66273: 1.0,
66274: 2.0,
66275: 3.0,
66276: 4.0,
66277: 5.0,
66278: 6.0,
66279: 7.0,
66280: 8.0,
66281: 9.0,
66282: 10.0,
66283: 20.0,
66284: 30.0,
66285: 40.0,
66286: 50.0,
66287: 60.0,
66288: 70.0,
66289: 80.0,
66290: 90.0,
66291: 100.0,
66292: 200.0,
66293: 300.0,
66294: 400.0,
66295: 500.0,
66296: 600.0,
66297: 700.0,
66298: 800.0,
66299: 900.0,
67705: 1.0,
67706: 2.0,
67707: 3.0,
67708: 4.0,
67709: 5.0,
67710: 10.0,
67711: 20.0,
67751: 1.0,
67752: 2.0,
67753: 3.0,
67754: 4.0,
67755: 4.0,
67756: 5.0,
67757: 10.0,
67758: 20.0,
67759: 100.0,
67835: 1.0,
67836: 5.0,
67837: 10.0,
67838: 20.0,
67839: 100.0,
68028: 11.0 / 12.0,
68029: 1.0 / 2.0,
68032: 1.0,
68033: 2.0,
68034: 3.0,
68035: 4.0,
68036: 5.0,
68037: 6.0,
68038: 7.0,
68039: 8.0,
68040: 9.0,
68041: 10.0,
68042: 20.0,
68043: 30.0,
68044: 40.0,
68045: 50.0,
68046: 60.0,
68047: 70.0,
68050: 100.0,
68051: 200.0,
68052: 300.0,
68053: 400.0,
68054: 500.0,
68055: 600.0,
68056: 700.0,
68057: 800.0,
68058: 900.0,
68059: 1000.0,
68060: 2000.0,
68061: 3000.0,
68062: 4000.0,
68063: 5000.0,
68064: 6000.0,
68065: 7000.0,
68066: 8000.0,
68067: 9000.0,
68068: 10000.0,
68069: 20000.0,
68070: 30000.0,
68071: 40000.0,
68072: 50000.0,
68073: 60000.0,
68074: 70000.0,
68075: 80000.0,
68076: 90000.0,
68077: 100000.0,
68078: 200000.0,
68079: 300000.0,
68080: 400000.0,
68081: 500000.0,
68082: 600000.0,
68083: 700000.0,
68084: 800000.0,
68085: 900000.0,
68086: 1.0 / 12.0,
68087: 2.0 / 12.0,
68088: 3.0 / 12.0,
68089: 4.0 / 12.0,
68090: 5.0 / 12.0,
68091: 6.0 / 12.0,
68092: 7.0 / 12.0,
68093: 8.0 / 12.0,
68094: 9.0 / 12.0,
68095: 10.0 / 12.0,
68168: 1.0 / 2.0,
68253: 1.0,
68254: 10.0,
68255: 20.0,
68331: 1.0,
68332: 5.0,
68333: 10.0,
68334: 20.0,
68335: 100.0,
68521: 1.0,
68522: 2.0,
68523: 3.0,
68524: 4.0,
68525: 10.0,
68526: 20.0,
68527: 100.0,
68858: 1.0,
68859: 5.0,
68860: 10.0,
68861: 50.0,
68862: 100.0,
68863: 1000.0,
68912: 0.0,
68913: 1.0,
68914: 2.0,
68915: 3.0,
68916: 4.0,
68917: 5.0,
68918: 6.0,
68919: 7.0,
68920: 8.0,
68921: 9.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69405: 1.0,
69406: 2.0,
69407: 3.0,
69408: 4.0,
69409: 5.0,
69410: 10.0,
69411: 20.0,
69412: 30.0,
69413: 100.0,
69414: 1.0 / 2.0,
69457: 1.0,
69458: 10.0,
69459: 20.0,
69460: 100.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
70113: 1.0,
70114: 2.0,
70115: 3.0,
70116: 4.0,
70117: 5.0,
70118: 6.0,
70119: 7.0,
70120: 8.0,
70121: 9.0,
70122: 10.0,
70123: 20.0,
70124: 30.0,
70125: 40.0,
70126: 50.0,
70127: 60.0,
70128: 70.0,
70129: 80.0,
70130: 90.0,
70131: 100.0,
70132: 1000.0,
70384: 0.0,
70385: 1.0,
70386: 2.0,
70387: 3.0,
70388: 4.0,
70389: 5.0,
70390: 6.0,
70391: 7.0,
70392: 8.0,
70393: 9.0,
70736: 0.0,
70737: 1.0,
70738: 2.0,
70739: 3.0,
70740: 4.0,
70741: 5.0,
70742: 6.0,
70743: 7.0,
70744: 8.0,
70745: 9.0,
70864: 0.0,
70865: 1.0,
70866: 2.0,
70867: 3.0,
70868: 4.0,
70869: 5.0,
70870: 6.0,
70871: 7.0,
70872: 8.0,
70873: 9.0,
71248: 0.0,
71249: 1.0,
71250: 2.0,
71251: 3.0,
71252: 4.0,
71253: 5.0,
71254: 6.0,
71255: 7.0,
71256: 8.0,
71257: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
71472: 0.0,
71473: 1.0,
71474: 2.0,
71475: 3.0,
71476: 4.0,
71477: 5.0,
71478: 6.0,
71479: 7.0,
71480: 8.0,
71481: 9.0,
71482: 10.0,
71483: 20.0,
71904: 0.0,
71905: 1.0,
71906: 2.0,
71907: 3.0,
71908: 4.0,
71909: 5.0,
71910: 6.0,
71911: 7.0,
71912: 8.0,
71913: 9.0,
71914: 10.0,
71915: 20.0,
71916: 30.0,
71917: 40.0,
71918: 50.0,
71919: 60.0,
71920: 70.0,
71921: 80.0,
71922: 90.0,
72784: 0.0,
72785: 1.0,
72786: 2.0,
72787: 3.0,
72788: 4.0,
72789: 5.0,
72790: 6.0,
72791: 7.0,
72792: 8.0,
72793: 9.0,
72794: 1.0,
72795: 2.0,
72796: 3.0,
72797: 4.0,
72798: 5.0,
72799: 6.0,
72800: 7.0,
72801: 8.0,
72802: 9.0,
72803: 10.0,
72804: 20.0,
72805: 30.0,
72806: 40.0,
72807: 50.0,
72808: 60.0,
72809: 70.0,
72810: 80.0,
72811: 90.0,
72812: 100.0,
73040: 0.0,
73041: 1.0,
73042: 2.0,
73043: 3.0,
73044: 4.0,
73045: 5.0,
73046: 6.0,
73047: 7.0,
73048: 8.0,
73049: 9.0,
73120: 0.0,
73121: 1.0,
73122: 2.0,
73123: 3.0,
73124: 4.0,
73125: 5.0,
73126: 6.0,
73127: 7.0,
73128: 8.0,
73129: 9.0,
73664: 1.0 / 320.0,
73665: 1.0 / 160.0,
73666: 1.0 / 80.0,
73667: 1.0 / 64.0,
73668: 1.0 / 40.0,
73669: 1.0 / 32.0,
73670: 3.0 / 80.0,
73671: 3.0 / 64.0,
73672: 1.0 / 20.0,
73673: 1.0 / 16.0,
73674: 1.0 / 16.0,
73675: 1.0 / 10.0,
73676: 1.0 / 8.0,
73677: 3.0 / 20.0,
73678: 3.0 / 16.0,
73679: 1.0 / 5.0,
73680: 1.0 / 4.0,
73681: 1.0 / 2.0,
73682: 1.0 / 2.0,
73683: 3.0 / 4.0,
73684: 1.0 / 320.0,
74802: 216000.0,
74803: 432000.0,
74838: 2.0,
74839: 3.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
74851: 1.0 / 4.0,
74852: 1.0 / 2.0,
74853: 1.0 / 3.0,
74854: 2.0 / 3.0,
74855: 40.0,
74856: 50.0,
74857: 4.0,
74858: 5.0,
74859: 6.0,
74860: 7.0,
74861: 8.0,
74862: 9.0,
92768: 0.0,
92769: 1.0,
92770: 2.0,
92771: 3.0,
92772: 4.0,
92773: 5.0,
92774: 6.0,
92775: 7.0,
92776: 8.0,
92777: 9.0,
93008: 0.0,
93009: 1.0,
93010: 2.0,
93011: 3.0,
93012: 4.0,
93013: 5.0,
93014: 6.0,
93015: 7.0,
93016: 8.0,
93017: 9.0,
93019: 10.0,
93020: 100.0,
93021: 10000.0,
93022: 1000000.0,
93023: 100000000.0,
93024: 10000000000.0,
93025: 1000000000000.0,
93824: 0.0,
93825: 1.0,
93826: 2.0,
93827: 3.0,
93828: 4.0,
93829: 5.0,
93830: 6.0,
93831: 7.0,
93832: 8.0,
93833: 9.0,
93834: 10.0,
93835: 11.0,
93836: 12.0,
93837: 13.0,
93838: 14.0,
93839: 15.0,
93840: 16.0,
93841: 17.0,
93842: 18.0,
93843: 19.0,
93844: 1.0,
93845: 2.0,
93846: 3.0,
119520: 0.0,
119521: 1.0,
119522: 2.0,
119523: 3.0,
119524: 4.0,
119525: 5.0,
119526: 6.0,
119527: 7.0,
119528: 8.0,
119529: 9.0,
119530: 10.0,
119531: 11.0,
119532: 12.0,
119533: 13.0,
119534: 14.0,
119535: 15.0,
119536: 16.0,
119537: 17.0,
119538: 18.0,
119539: 19.0,
119666: 1.0,
119667: 2.0,
119668: 3.0,
119669: 4.0,
119670: 5.0,
119671: 1.0,
119672: 5.0,
123200: 0.0,
123201: 1.0,
123202: 2.0,
123203: 3.0,
123204: 4.0,
123205: 5.0,
123206: 6.0,
123207: 7.0,
123208: 8.0,
123209: 9.0,
123632: 0.0,
123633: 1.0,
123634: 2.0,
123635: 3.0,
123636: 4.0,
123637: 5.0,
123638: 6.0,
123639: 7.0,
123640: 8.0,
123641: 9.0,
125127: 1.0,
125128: 2.0,
125129: 3.0,
125130: 4.0,
125131: 5.0,
125132: 6.0,
125133: 7.0,
125134: 8.0,
125135: 9.0,
125264: 0.0,
125265: 1.0,
125266: 2.0,
125267: 3.0,
125268: 4.0,
125269: 5.0,
125270: 6.0,
125271: 7.0,
125272: 8.0,
125273: 9.0,
126065: 1.0,
126066: 2.0,
126067: 3.0,
126068: 4.0,
126069: 5.0,
126070: 6.0,
126071: 7.0,
126072: 8.0,
126073: 9.0,
126074: 10.0,
126075: 20.0,
126076: 30.0,
126077: 40.0,
126078: 50.0,
126079: 60.0,
126080: 70.0,
126081: 80.0,
126082: 90.0,
126083: 100.0,
126084: 200.0,
126085: 300.0,
126086: 400.0,
126087: 500.0,
126088: 600.0,
126089: 700.0,
126090: 800.0,
126091: 900.0,
126092: 1000.0,
126093: 2000.0,
126094: 3000.0,
126095: 4000.0,
126096: 5000.0,
126097: 6000.0,
126098: 7000.0,
126099: 8000.0,
126100: 9000.0,
126101: 10000.0,
126102: 20000.0,
126103: 30000.0,
126104: 40000.0,
126105: 50000.0,
126106: 60000.0,
126107: 70000.0,
126108: 80000.0,
126109: 90000.0,
126110: 100000.0,
126111: 200000.0,
126112: 100000.0,
126113: 10000000.0,
126114: 20000000.0,
126115: 1.0,
126116: 2.0,
126117: 3.0,
126118: 4.0,
126119: 5.0,
126120: 6.0,
126121: 7.0,
126122: 8.0,
126123: 9.0,
126125: 1.0 / 4.0,
126126: 1.0 / 2.0,
126127: 3.0 / 4.0,
126129: 1.0,
126130: 2.0,
126131: 10000.0,
126132: 100000.0,
126209: 1.0,
126210: 2.0,
126211: 3.0,
126212: 4.0,
126213: 5.0,
126214: 6.0,
126215: 7.0,
126216: 8.0,
126217: 9.0,
126218: 10.0,
126219: 20.0,
126220: 30.0,
126221: 40.0,
126222: 50.0,
126223: 60.0,
126224: 70.0,
126225: 80.0,
126226: 90.0,
126227: 100.0,
126228: 200.0,
126229: 300.0,
126230: 400.0,
126231: 500.0,
126232: 600.0,
126233: 700.0,
126234: 800.0,
126235: 900.0,
126236: 1000.0,
126237: 2000.0,
126238: 3000.0,
126239: 4000.0,
126240: 5000.0,
126241: 6000.0,
126242: 7000.0,
126243: 8000.0,
126244: 9000.0,
126245: 10000.0,
126246: 20000.0,
126247: 30000.0,
126248: 40000.0,
126249: 50000.0,
126250: 60000.0,
126251: 70000.0,
126252: 80000.0,
126253: 90000.0,
126255: 2.0,
126256: 3.0,
126257: 4.0,
126258: 5.0,
126259: 6.0,
126260: 7.0,
126261: 8.0,
126262: 9.0,
126263: 10.0,
126264: 400.0,
126265: 600.0,
126266: 2000.0,
126267: 10000.0,
126268: 1.0 / 2.0,
126269: 1.0 / 6.0,
127243: 0.0,
127244: 0.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
642: 42949,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
4304: 7312,
4305: 7313,
4306: 7314,
4307: 7315,
4308: 7316,
4309: 7317,
4310: 7318,
4311: 7319,
4312: 7320,
4313: 7321,
4314: 7322,
4315: 7323,
4316: 7324,
4317: 7325,
4318: 7326,
4319: 7327,
4320: 7328,
4321: 7329,
4322: 7330,
4323: 7331,
4324: 7332,
4325: 7333,
4326: 7334,
4327: 7335,
4328: 7336,
4329: 7337,
4330: 7338,
4331: 7339,
4332: 7340,
4333: 7341,
4334: 7342,
4335: 7343,
4336: 7344,
4337: 7345,
4338: 7346,
4339: 7347,
4340: 7348,
4341: 7349,
4342: 7350,
4343: 7351,
4344: 7352,
4345: 7353,
4346: 7354,
4349: 7357,
4350: 7358,
4351: 7359,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
7566: 42950,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42900: 42948,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
42937: 42936,
42939: 42938,
42941: 42940,
42943: 42942,
42947: 42946,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
93792: 93760,
93793: 93761,
93794: 93762,
93795: 93763,
93796: 93764,
93797: 93765,
93798: 93766,
93799: 93767,
93800: 93768,
93801: 93769,
93802: 93770,
93803: 93771,
93804: 93772,
93805: 93773,
93806: 93774,
93807: 93775,
93808: 93776,
93809: 93777,
93810: 93778,
93811: 93779,
93812: 93780,
93813: 93781,
93814: 93782,
93815: 93783,
93816: 93784,
93817: 93785,
93818: 93786,
93819: 93787,
93820: 93788,
93821: 93789,
93822: 93790,
93823: 93791,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_toupper_corrected = {
}
_tolower = {
895: 1011,
1318: 1319,
1320: 1321,
1322: 1323,
1324: 1325,
1326: 1327,
4295: 11559,
4301: 11565,
5024: 43888,
5025: 43889,
5026: 43890,
5027: 43891,
5028: 43892,
5029: 43893,
5030: 43894,
5031: 43895,
5032: 43896,
5033: 43897,
5034: 43898,
5035: 43899,
5036: 43900,
5037: 43901,
5038: 43902,
5039: 43903,
5040: 43904,
5041: 43905,
5042: 43906,
5043: 43907,
5044: 43908,
5045: 43909,
5046: 43910,
5047: 43911,
5048: 43912,
5049: 43913,
5050: 43914,
5051: 43915,
5052: 43916,
5053: 43917,
5054: 43918,
5055: 43919,
5056: 43920,
5057: 43921,
5058: 43922,
5059: 43923,
5060: 43924,
5061: 43925,
5062: 43926,
5063: 43927,
5064: 43928,
5065: 43929,
5066: 43930,
5067: 43931,
5068: 43932,
5069: 43933,
5070: 43934,
5071: 43935,
5072: 43936,
5073: 43937,
5074: 43938,
5075: 43939,
5076: 43940,
5077: 43941,
5078: 43942,
5079: 43943,
5080: 43944,
5081: 43945,
5082: 43946,
5083: 43947,
5084: 43948,
5085: 43949,
5086: 43950,
5087: 43951,
5088: 43952,
5089: 43953,
5090: 43954,
5091: 43955,
5092: 43956,
5093: 43957,
5094: 43958,
5095: 43959,
5096: 43960,
5097: 43961,
5098: 43962,
5099: 43963,
5100: 43964,
5101: 43965,
5102: 43966,
5103: 43967,
5104: 5112,
5105: 5113,
5106: 5114,
5107: 5115,
5108: 5116,
5109: 5117,
7312: 4304,
7313: 4305,
7314: 4306,
7315: 4307,
7316: 4308,
7317: 4309,
7318: 4310,
7319: 4311,
7320: 4312,
7321: 4313,
7322: 4314,
7323: 4315,
7324: 4316,
7325: 4317,
7326: 4318,
7327: 4319,
7328: 4320,
7329: 4321,
7330: 4322,
7331: 4323,
7332: 4324,
7333: 4325,
7334: 4326,
7335: 4327,
7336: 4328,
7337: 4329,
7338: 4330,
7339: 4331,
7340: 4332,
7341: 4333,
7342: 4334,
7343: 4335,
7344: 4336,
7345: 4337,
7346: 4338,
7347: 4339,
7348: 4340,
7349: 4341,
7350: 4342,
7351: 4343,
7352: 4344,
7353: 4345,
7354: 4346,
7357: 4349,
7358: 4350,
7359: 4351,
11506: 11507,
42592: 42593,
42648: 42649,
42650: 42651,
42893: 613,
42896: 42897,
42898: 42899,
42902: 42903,
42904: 42905,
42906: 42907,
42908: 42909,
42910: 42911,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
42923: 604,
42924: 609,
42925: 620,
42926: 618,
42928: 670,
42929: 647,
42930: 669,
42931: 43859,
42932: 42933,
42934: 42935,
42936: 42937,
42938: 42939,
42940: 42941,
42942: 42943,
42946: 42947,
42948: 42900,
42949: 642,
42950: 7566,
66736: 66776,
66737: 66777,
66738: 66778,
66739: 66779,
66740: 66780,
66741: 66781,
66742: 66782,
66743: 66783,
66744: 66784,
66745: 66785,
66746: 66786,
66747: 66787,
66748: 66788,
66749: 66789,
66750: 66790,
66751: 66791,
66752: 66792,
66753: 66793,
66754: 66794,
66755: 66795,
66756: 66796,
66757: 66797,
66758: 66798,
66759: 66799,
66760: 66800,
66761: 66801,
66762: 66802,
66763: 66803,
66764: 66804,
66765: 66805,
66766: 66806,
66767: 66807,
66768: 66808,
66769: 66809,
66770: 66810,
66771: 66811,
68736: 68800,
68737: 68801,
68738: 68802,
68739: 68803,
68740: 68804,
68741: 68805,
68742: 68806,
68743: 68807,
68744: 68808,
68745: 68809,
68746: 68810,
68747: 68811,
68748: 68812,
68749: 68813,
68750: 68814,
68751: 68815,
68752: 68816,
68753: 68817,
68754: 68818,
68755: 68819,
68756: 68820,
68757: 68821,
68758: 68822,
68759: 68823,
68760: 68824,
68761: 68825,
68762: 68826,
68763: 68827,
68764: 68828,
68765: 68829,
68766: 68830,
68767: 68831,
68768: 68832,
68769: 68833,
68770: 68834,
68771: 68835,
68772: 68836,
68773: 68837,
68774: 68838,
68775: 68839,
68776: 68840,
68777: 68841,
68778: 68842,
68779: 68843,
68780: 68844,
68781: 68845,
68782: 68846,
68783: 68847,
68784: 68848,
68785: 68849,
68786: 68850,
71840: 71872,
71841: 71873,
71842: 71874,
71843: 71875,
71844: 71876,
71845: 71877,
71846: 71878,
71847: 71879,
71848: 71880,
71849: 71881,
71850: 71882,
71851: 71883,
71852: 71884,
71853: 71885,
71854: 71886,
71855: 71887,
71856: 71888,
71857: 71889,
71858: 71890,
71859: 71891,
71860: 71892,
71861: 71893,
71862: 71894,
71863: 71895,
71864: 71896,
71865: 71897,
71866: 71898,
71867: 71899,
71868: 71900,
71869: 71901,
71870: 71902,
71871: 71903,
93760: 93792,
93761: 93793,
93762: 93794,
93763: 93795,
93764: 93796,
93765: 93797,
93766: 93798,
93767: 93799,
93768: 93800,
93769: 93801,
93770: 93802,
93771: 93803,
93772: 93804,
93773: 93805,
93774: 93806,
93775: 93807,
93776: 93808,
93777: 93809,
93778: 93810,
93779: 93811,
93780: 93812,
93781: 93813,
93782: 93814,
93783: 93815,
93784: 93816,
93785: 93817,
93786: 93818,
93787: 93819,
93788: 93820,
93789: 93821,
93790: 93822,
93791: 93823,
125184: 125218,
125185: 125219,
125186: 125220,
125187: 125221,
125188: 125222,
125189: 125223,
125190: 125224,
125191: 125225,
125192: 125226,
125193: 125227,
125194: 125228,
125195: 125229,
125196: 125230,
125197: 125231,
125198: 125232,
125199: 125233,
125200: 125234,
125201: 125235,
125202: 125236,
125203: 125237,
125204: 125238,
125205: 125239,
125206: 125240,
125207: 125241,
125208: 125242,
125209: 125243,
125210: 125244,
125211: 125245,
125212: 125246,
125213: 125247,
125214: 125248,
125215: 125249,
125216: 125250,
125217: 125251,
}

_tolower_corrected = {
}
_totitle = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
642: 42949,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
4304: 4304,
4305: 4305,
4306: 4306,
4307: 4307,
4308: 4308,
4309: 4309,
4310: 4310,
4311: 4311,
4312: 4312,
4313: 4313,
4314: 4314,
4315: 4315,
4316: 4316,
4317: 4317,
4318: 4318,
4319: 4319,
4320: 4320,
4321: 4321,
4322: 4322,
4323: 4323,
4324: 4324,
4325: 4325,
4326: 4326,
4327: 4327,
4328: 4328,
4329: 4329,
4330: 4330,
4331: 4331,
4332: 4332,
4333: 4333,
4334: 4334,
4335: 4335,
4336: 4336,
4337: 4337,
4338: 4338,
4339: 4339,
4340: 4340,
4341: 4341,
4342: 4342,
4343: 4343,
4344: 4344,
4345: 4345,
4346: 4346,
4349: 4349,
4350: 4350,
4351: 4351,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
7566: 42950,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42900: 42948,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
42937: 42936,
42939: 42938,
42941: 42940,
42943: 42942,
42947: 42946,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
93792: 93760,
93793: 93761,
93794: 93762,
93795: 93763,
93796: 93764,
93797: 93765,
93798: 93766,
93799: 93767,
93800: 93768,
93801: 93769,
93802: 93770,
93803: 93771,
93804: 93772,
93805: 93773,
93806: 93774,
93807: 93775,
93808: 93776,
93809: 93777,
93810: 93778,
93811: 93779,
93812: 93780,
93813: 93781,
93814: 93782,
93815: 93783,
93816: 93784,
93817: 93785,
93818: 93786,
93819: 93787,
93820: 93788,
93821: 93789,
93822: 93790,
93823: 93791,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
13055: '<square> 4EE4 548C',
42652: '<super> 044A',
42653: '<super> 044C',
43000: '<super> 0126',
43001: '<super> 0153',
43868: '<super> A727',
43869: '<super> AB37',
43870: '<super> 026B',
43871: '<super> AB52',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
70475: '11347 1133E',
70476: '11347 11357',
70843: '114B9 114BA',
70844: '114B9 114B0',
70846: '114B9 114BD',
71098: '115B8 115AF',
71099: '115B9 115AF',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127340: '<super> 004D 0052',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127547: '<square> 914D',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
r_longlong(70471 << 32 | 70462): 70475,
r_longlong(70471 << 32 | 70487): 70476,
r_longlong(70841 << 32 | 70842): 70843,
r_longlong(70841 << 32 | 70832): 70844,
r_longlong(70841 << 32 | 70845): 70846,
r_longlong(71096 << 32 | 71087): 71098,
r_longlong(71097 << 32 | 71087): 71099,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
13055: [20196, 21644],
42652: [1098],
42653: [1100],
43000: [294],
43001: [339],
43868: [42791],
43869: [43831],
43870: [619],
43871: [43858],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127340: [77, 82],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127547: [37197],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'#\ufe0f\u20e3',
u'*\ufe0f\u20e3',
u'0\ufe0f\u20e3',
u'1\ufe0f\u20e3',
u'2\ufe0f\u20e3',
u'3\ufe0f\u20e3',
u'4\ufe0f\u20e3',
u'5\ufe0f\u20e3',
u'6\ufe0f\u20e3',
u'7\ufe0f\u20e3',
u'8\ufe0f\u20e3',
u'9\ufe0f\u20e3',
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0626\u0627',
u'\u0626\u0648',
u'\u0626\u0649',
u'\u0626\u06c6',
u'\u0626\u06c7',
u'\u0626\u06c8',
u'\u0626\u06d0',
u'\u0626\u06d5',
u'\u0646\u06a9',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1564,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
4588,
4589,
4590,
4591,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8294,
8295,
8296,
8297,
8472,
9288,
9289,
11130,
11132,
40981,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65048,
65279,
65279,
65279,
74452,
74453,
93782,
93783,
93814,
93815,
110593,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
5024: [5024],
5025: [5025],
5026: [5026],
5027: [5027],
5028: [5028],
5029: [5029],
5030: [5030],
5031: [5031],
5032: [5032],
5033: [5033],
5034: [5034],
5035: [5035],
5036: [5036],
5037: [5037],
5038: [5038],
5039: [5039],
5040: [5040],
5041: [5041],
5042: [5042],
5043: [5043],
5044: [5044],
5045: [5045],
5046: [5046],
5047: [5047],
5048: [5048],
5049: [5049],
5050: [5050],
5051: [5051],
5052: [5052],
5053: [5053],
5054: [5054],
5055: [5055],
5056: [5056],
5057: [5057],
5058: [5058],
5059: [5059],
5060: [5060],
5061: [5061],
5062: [5062],
5063: [5063],
5064: [5064],
5065: [5065],
5066: [5066],
5067: [5067],
5068: [5068],
5069: [5069],
5070: [5070],
5071: [5071],
5072: [5072],
5073: [5073],
5074: [5074],
5075: [5075],
5076: [5076],
5077: [5077],
5078: [5078],
5079: [5079],
5080: [5080],
5081: [5081],
5082: [5082],
5083: [5083],
5084: [5084],
5085: [5085],
5086: [5086],
5087: [5087],
5088: [5088],
5089: [5089],
5090: [5090],
5091: [5091],
5092: [5092],
5093: [5093],
5094: [5094],
5095: [5095],
5096: [5096],
5097: [5097],
5098: [5098],
5099: [5099],
5100: [5100],
5101: [5101],
5102: [5102],
5103: [5103],
5104: [5104],
5105: [5105],
5106: [5106],
5107: [5107],
5108: [5108],
5109: [5109],
5112: [5104],
5113: [5105],
5114: [5106],
5115: [5107],
5116: [5108],
5117: [5109],
7296: [1074],
7297: [1076],
7298: [1086],
7299: [1089],
7300: [1090],
7301: [1090],
7302: [1098],
7303: [1123],
7304: [42571],
43888: [5024],
43889: [5025],
43890: [5026],
43891: [5027],
43892: [5028],
43893: [5029],
43894: [5030],
43895: [5031],
43896: [5032],
43897: [5033],
43898: [5034],
43899: [5035],
43900: [5036],
43901: [5037],
43902: [5038],
43903: [5039],
43904: [5040],
43905: [5041],
43906: [5042],
43907: [5043],
43908: [5044],
43909: [5045],
43910: [5046],
43911: [5047],
43912: [5048],
43913: [5049],
43914: [5050],
43915: [5051],
43916: [5052],
43917: [5053],
43918: [5054],
43919: [5055],
43920: [5056],
43921: [5057],
43922: [5058],
43923: [5059],
43924: [5060],
43925: [5061],
43926: [5062],
43927: [5063],
43928: [5064],
43929: [5065],
43930: [5066],
43931: [5067],
43932: [5068],
43933: [5069],
43934: [5070],
43935: [5071],
43936: [5072],
43937: [5073],
43938: [5074],
43939: [5075],
43940: [5076],
43941: [5077],
43942: [5078],
43943: [5079],
43944: [5080],
43945: [5081],
43946: [5082],
43947: [5083],
43948: [5084],
43949: [5085],
43950: [5086],
43951: [5087],
43952: [5088],
43953: [5089],
43954: [5090],
43955: [5091],
43956: [5092],
43957: [5093],
43958: [5094],
43959: [5095],
43960: [5096],
43961: [5097],
43962: [5098],
43963: [5099],
43964: [5100],
43965: [5101],
43966: [5102],
43967: [5103],
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2045: 220,
2137: 220,
2138: 220,
2139: 220,
2259: 220,
2260: 230,
2261: 230,
2262: 230,
2263: 230,
2264: 230,
2265: 230,
2266: 230,
2267: 230,
2268: 230,
2269: 230,
2270: 230,
2271: 230,
2272: 230,
2273: 230,
2275: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
2303: 230,
2558: 230,
3387: 9,
3388: 9,
3770: 9,
4957: 230,
4958: 230,
6832: 230,
6833: 230,
6834: 230,
6835: 230,
6836: 230,
6837: 220,
6838: 220,
6839: 220,
6840: 220,
6841: 220,
6842: 220,
6843: 230,
6844: 230,
6845: 220,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7416: 230,
7417: 230,
7655: 230,
7656: 230,
7657: 230,
7658: 230,
7659: 230,
7660: 230,
7661: 230,
7662: 230,
7663: 230,
7664: 230,
7665: 230,
7666: 230,
7667: 230,
7668: 230,
7669: 230,
7670: 232,
7671: 228,
7672: 228,
7673: 220,
7675: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42654: 230,
42655: 230,
43766: 9,
65063: 220,
65064: 220,
65065: 220,
65066: 220,
65067: 220,
65068: 220,
65069: 220,
65070: 230,
65071: 230,
66272: 220,
66422: 230,
66423: 230,
66424: 230,
66425: 230,
66426: 230,
68325: 230,
68326: 220,
68900: 230,
68901: 230,
68902: 230,
68903: 230,
69446: 220,
69447: 220,
69448: 230,
69449: 230,
69450: 230,
69451: 220,
69452: 230,
69453: 220,
69454: 220,
69455: 220,
69456: 220,
69702: 9,
69759: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70003: 7,
70080: 9,
70090: 7,
70197: 9,
70198: 7,
70377: 7,
70378: 9,
70459: 7,
70460: 7,
70477: 9,
70502: 230,
70503: 230,
70504: 230,
70505: 230,
70506: 230,
70507: 230,
70508: 230,
70512: 230,
70513: 230,
70514: 230,
70515: 230,
70516: 230,
70722: 9,
70726: 7,
70750: 230,
70850: 9,
70851: 7,
71103: 9,
71104: 7,
71231: 9,
71350: 9,
71351: 7,
71467: 9,
71737: 9,
71738: 7,
72160: 9,
72244: 9,
72263: 9,
72345: 9,
72767: 9,
73026: 7,
73028: 9,
73029: 9,
73111: 9,
92912: 1,
92913: 1,
92914: 1,
92915: 1,
92916: 1,
92976: 230,
92977: 230,
92978: 230,
92979: 230,
92980: 230,
92981: 230,
92982: 230,
113822: 1,
122880: 230,
122881: 230,
122882: 230,
122883: 230,
122884: 230,
122885: 230,
122886: 230,
122888: 230,
122889: 230,
122890: 230,
122891: 230,
122892: 230,
122893: 230,
122894: 230,
122895: 230,
122896: 230,
122897: 230,
122898: 230,
122899: 230,
122900: 230,
122901: 230,
122902: 230,
122903: 230,
122904: 230,
122907: 230,
122908: 230,
122909: 230,
122910: 230,
122911: 230,
122912: 230,
122913: 230,
122915: 230,
122916: 230,
122918: 230,
122919: 230,
122920: 230,
122921: 230,
122922: 230,
123184: 230,
123185: 230,
123186: 230,
123187: 230,
123188: 230,
123189: 230,
123190: 230,
123628: 230,
123629: 230,
123630: 230,
123631: 230,
125136: 220,
125137: 220,
125138: 220,
125139: 220,
125140: 220,
125141: 220,
125142: 220,
125252: 230,
125253: 230,
125254: 230,
125255: 230,
125256: 230,
125257: 230,
125258: 7,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

