import sys
import py
if sys.version_info[0] < 3:
    print('ERROR: autogen.py should be run on top of Python 3.x')
    sys.exit(1)
if len(sys.argv) != 2:
    print('USAGE: autogen.py /path/to/hpy_repo')
    sys.exit(1)

HPY_PATH = sys.argv[1]
sys.path.insert(0, HPY_PATH)

from hpy.tools.autogen.parse import HPyAPI, PUBLIC_API_H, toC
from hpy.tools.autogen.autogenfile import AutoGenFile

# NOTE: autogen_interp_slots.py is no longer used. We keep the code around
# because it's useful as an example for when we will need to autogen other
# files
class autogen_example_py(AutoGenFile):
    PATH = 'autogen_example.py'
    LANGUAGE = 'Python'
    DISCLAIMER = '## DO NOT EDIT THIS FILE, IT IS AUTOGENERATED'

    def generate(self):
        lines = []
        w = lines.append
        #
        w(f'# example file')
        return '\n'.join(lines)


def main():
    OUTDIR = py.path.local(__file__).dirpath('..')
    api = HPyAPI.parse(PUBLIC_API_H)
    for cls in (autogen_example_py,):
        cls(api).write(OUTDIR)



if __name__ == '__main__':
    main()
