#
# Print module for pyne.
#

import tempfile
import os
from gtk import *
from time import strftime
import pynei18n

class print_box(GtkWindow):
	"""
	A 'print' dialog box.
	"""
	def do_print(self, _a=None):
		command = self.command_entry.get_text()
		self.parent_user.printer = command
		self.destroy()

		# for the moment print the whole damn thing...
		filename = tempfile.mktemp()
		f = open(filename, "w")
		self.parent_user.tempfiles.append(filename)

		try:
			f.write("To: "+self.message.headers["to"]+"\n")
		except KeyError:
			try:
				f.write("Newsgroups: "+self.message.headers["newsgroups"]+"\n")
			except KeyError:
				pass

		f.write("From: "+self.message.headers["from"]+"\n")
		f.write("Subject: "+self.message.headers["subject"]+"\n")
		f.write("Date: "+strftime("%d %b %Y %H:%M:%S", self.message.date)+"\n")
		f.write("\n")
		f.write(self.message.parts_text[0])
		f.close()

		os.system(command+" "+filename)


	def __init__(self, parent_user, message):
		self.parent_user = parent_user
		self.message = message

		GtkWindow.__init__(self)
		self.set_name(_("Pyne - Print Message"))
		self.set_title(_("Pyne - Print Message"))

		box = GtkVBox()
		self.add(box)
		box.show()

		box1 = GtkHBox()
		box.pack_start(box1, expand=FALSE)
		box1.set_border_width(5)
		box1.show()

		label = GtkLabel(_("Printer Command:"))
		box1.pack_start(label, expand=FALSE)
		label.show()

		self.command_entry = GtkEntry()
		box1.pack_start(self.command_entry)
		self.command_entry.set_text(self.parent_user.printer)
		self.command_entry.show()

		sep = GtkHSeparator()
		box.pack_start(sep, expand=FALSE)
		sep.show()

		# page range still to do

		box2 = GtkHBox(spacing=5)
		box.pack_start(box2, expand=FALSE)
		box2.set_border_width(5)
		box2.show()

		button = GtkButton(" "+_("Cancel")+" ")
		button.connect("clicked", self.destroy)
		box2.pack_end(button, expand=FALSE)
		button.show()

		button = GtkButton(" "+_("Print")+" ")
		button.connect("clicked", self.do_print)
		box2.pack_end(button, expand=FALSE)
		button.show()


