#
# Pyne main window module.
#
# The main window is 0wned by a 'user' object,
# which contains all the smelly data.
#

import utils

from time import *
from copy import copy
import threading
import tempfile

from _gtk import *
from gtk import *
import GtkExtra

from pyne import *
import pynei18n
from addressbook import *
from pyneheaders import *
import pynemsg
from boxtypes import *
from boxtypes.superbox import *
import ptk.message_tree
import ptk.folder_tree
import ptk.msg_view_box
import ptk.menu_maker

# specific update flavours
UPDATE_CHANGED    = 0 #default
UPDATE_FOLDERVIEW = 1

# Method keys for the method_widgets dict.
METH_NEW_MESSAGE     = 1
METH_REPLY_SINGLE    = 2
METH_REPLY_GROUP     = 3
METH_REPLY_FORWARD   = 4
METH_EDIT_MESSAGE    = 5
METH_DEL_MESSAGE     = 6
METH_PRINT_MESSAGE   = 7
METH_FOLDER_UPDATE   = 8
METH_MARK_MESSAGE    = 9
METH_UNMARK_MESSAGE  = 10
METH_VIEW_BROWSER    = 11
METH_VIEW_NEWWIN     = 12
METH_TOGGLE_EXPAND_ALL = 13
METH_DELETE_BOX      = 14
METH_SEARCH_MESSAGES = 15
METH_SENDER2ADDRBOOK = 16
METH_DOWNLOAD_BODY   = 17
METH_DELETE_THREAD   = 18

class pyne_window:
	"""
	Create Pyne window
	"""

	def about_box(self, _a, _b):
		win = GtkWindow()
		#win.set_usize(220, 200)
		win.set_title("About "+ver_string)

		box1 = GtkVBox(spacing=5)
		box1.set_border_width(5)
		win.add(box1)
		box1.show()

		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/logo.xpm")
		pixmap = GtkPixmap(pix, mask)
		close_button = GtkButton()
		close_button.connect("clicked", win.destroy)
		close_button.add(pixmap)
		box1.pack_start(close_button, expand=FALSE)
		pixmap.show()
		close_button.show()		

		table = GtkTable(2, 2, FALSE)
		table.set_row_spacings(10)
		table.set_col_spacings(5)
		box1.pack_start(table)
		table.show()

		text = GtkText()
		text.set_editable(FALSE)
		text.set_word_wrap(TRUE)
		table.attach(text, 0,1, 0,2)
		text.show()

		vscrollbar = GtkVScrollbar(text.get_vadjustment())
		table.attach(vscrollbar, 1,2, 0,2, xoptions=FILL)
		vscrollbar.show()

		text.insert_defaults("\n")
		text.insert_defaults(ver_string+"\n")
		text.insert_defaults("\n")
		text.insert_defaults("Copyright (c) 2000, 2001\n")
		text.insert_defaults("Tom Morton <tom@moretom.net>\n")
		text.insert_defaults("\n")
		text.insert_defaults("Visit the Pyne Homepage: www.moretom.net/pyne\n")
		text.insert_defaults("\n")
		text.insert_defaults("This program is distributed under the terms of the GNU Public License.\n")
		text.insert_defaults("\n")

		win.show()

	def new_window(self, _a, _b):
		"""
		Spawn a new pyne_window object.
		"""
		self.parent_user.new_window()

	def close(self, _a, _b):
		"""
		Close this window.
		"""
		self.parent_user.kill_window(self.number)

	def new_mailbox(self, type, _b):
		"""
		Create a new 'box'.
		"""
		user = self.parent_user
		
		if type == 0:
			newbox = mailbox.mailbox(user, _("Mailbox"), user.get_uid())
			user.contents.append(newbox)
		elif type == 1:
			newbox = nntpbox.nntpbox(user, _("News"), user.get_uid())
			user.contents.append(newbox)
		elif type == 2:
			newbox = storebox.storebox(user, _("Folder"), user.get_uid())
			user.contents.append(newbox)
		# Open settings box
		newbox.setup(self.parent_user)
		# Update windows
		newbox.changed = 1
		user.update(UPDATE_FOLDERVIEW)

	def get_folder_list_selected(self):
		"""
		Return first selected item in folder_list.
		** This may not be the folder currently showing messages  **
		** use self.opened_folder for that **
		"""
		if self.folder_list.selected[0] == None:
			return None
		user = self.parent_user
		# GET FOLDER_LIST SELECTED ITEM
		selected = self.folder_list.selected[0]
		object = user.get_folder_by_uid(selected)
		return object

	def get_message_list_selected(self):
		"""
		Return ids of selected messages in message_list as a list.
		"""
		#if self.display_msg != None:
	#		return [ self.display_msg[1] ]
		#else:
		return self.message_list.get_selected_msg_ids()

	def update_ui(self, folder, msg):
		"""
		Decide what widgets should be enabled/disabled according
		to what folder and message is open.
		"""
		set_enabled = self.method_widgets.set_enabled

		# Start with them all disabled
		set_enabled(METH_PRINT_MESSAGE, FALSE)
		set_enabled(METH_FOLDER_UPDATE, FALSE)

		set_enabled(METH_VIEW_BROWSER, FALSE)
		set_enabled(METH_VIEW_NEWWIN, FALSE)
		set_enabled(METH_NEW_MESSAGE, FALSE)
		set_enabled(METH_REPLY_SINGLE, FALSE)
		set_enabled(METH_REPLY_GROUP, FALSE)
		set_enabled(METH_REPLY_FORWARD, FALSE)
		set_enabled(METH_EDIT_MESSAGE, FALSE)
		set_enabled(METH_DEL_MESSAGE, FALSE)
		set_enabled(METH_MARK_MESSAGE, FALSE)
		set_enabled(METH_UNMARK_MESSAGE, FALSE)
		set_enabled(METH_TOGGLE_EXPAND_ALL, FALSE)
		set_enabled(METH_DELETE_BOX, FALSE)
		set_enabled(METH_SEARCH_MESSAGES, FALSE)
		set_enabled(METH_SENDER2ADDRBOOK, FALSE)
		set_enabled(METH_DOWNLOAD_BODY, FALSE)
		set_enabled(METH_DELETE_THREAD, FALSE)

		# No folder selected. run away
		if folder == None:
			return
	
		flags = folder.get_flags()
		
		set_enabled(METH_DOWNLOAD_BODY, isinstance(folder, nntpbox.newsgroup))
		set_enabled(METH_SEARCH_MESSAGES, folder.__dict__.has_key("messages"))
		set_enabled(METH_DELETE_BOX, flags & BOX_ISDELETEABLE)
		set_enabled(METH_TOGGLE_EXPAND_ALL, folder.opts & OPT_THREAD)
		set_enabled(METH_NEW_MESSAGE, flags & BOX_MAKE_NEW_MSG)
		set_enabled(METH_FOLDER_UPDATE, flags & BOX_UPDATE_METHOD)

		# No message. run away
		if msg == None:
			return
		if msg.opts & MSG_NO_BODY:
			return

		set_enabled(METH_DELETE_THREAD, isinstance(folder, nntpbox.newsgroup))

		set_enabled(METH_PRINT_MESSAGE, TRUE)
		set_enabled(METH_VIEW_BROWSER, TRUE)
		set_enabled(METH_VIEW_NEWWIN, TRUE)
		set_enabled(METH_MARK_MESSAGE, TRUE)
		set_enabled(METH_UNMARK_MESSAGE, TRUE)
		set_enabled(METH_REPLY_SINGLE, flags & BOX_REPLY_SINGLE)
		set_enabled(METH_REPLY_GROUP, flags & BOX_REPLY_GROUP)
		set_enabled(METH_REPLY_FORWARD, flags & BOX_REPLY_FORWARD)
		set_enabled(METH_DEL_MESSAGE, flags & BOX_DEL_MESSAGE)
		# Message from some other guy. may collect address
		set_enabled(METH_SENDER2ADDRBOOK, msg.senduid == None)
		# Outgoing message. may edit it
		set_enabled(METH_EDIT_MESSAGE, msg.senduid != None)

	def message_list_popup_box(self, event):
		"""
		Popup menu for right click in message_list.
		"""
		# get selected message id
		msg_id = self.get_message_list_selected()
		if msg_id == []:
			# the cow jumped over the m00n
			return
		# build menu
		ag = GtkAccelGroup()
		itemf = ptk.menu_maker.MyGtkItemFactory(GtkMenu, "<main>", ag, methodset=self.method_widgets, temporary=1)
		itemf.create_items(self.messagemenu_items)
		menu = itemf.get_widget("<main>")

		menu.popup(None, None, None, event.button, event.time)

	def folder_list_popup_box(self, event):
		"""
		Popup menu for right click in folder_list.
		"""
		selected = self.get_folder_list_selected()
		if selected == None:
			return
		# build menu
		ag = GtkAccelGroup()
		itemf = ptk.menu_maker.MyGtkItemFactory(GtkMenu, "<main>", ag, methodset=self.method_widgets, temporary=1)
		itemf.create_items(self.foldermenu_items)
		menu = itemf.get_widget("<main>")

		menu.popup(None, None, None, event.button, event.time)
	
	def folder_settings(self, _a=None, _b=None):
		"""
		Change a folder's settings.
		"""
		user = self.parent_user

		selected = self.get_folder_list_selected()
		if selected == None:
			return
		selected.setup(user)

	def move_folder(self, offset, _a=None):
		"""
		Move the selected folder up or down by 'offset' in the folder
		list.
		"""
		user = self.parent_user

		# Check a folder is selected
		folder = self.get_folder_list_selected()
		if folder == None:
			return
		# Find parent object
		parent_object = user.parent_of(folder)
		# Get item number in parent's contents
		for x in xrange(0, len(parent_object.contents)):
			if parent_object.contents[x].uid == folder.uid:
				item = x
				break
		# delete it
		del parent_object.contents[item]
		# dump in new location
		parent_object.contents.insert(item+offset, folder)
		# update folder list
		user.update(UPDATE_FOLDERVIEW)

	def delete_folder(self, _a=None, _b=None):
		"""
		You clicked on delete folder.
		"""
		user = self.parent_user
		
		# Check a folder is selected
		folder = self.get_folder_list_selected()
		if folder == None:
			return

		# Can't delete 'special' folders.
		if not (folder.get_flags() & BOX_ISDELETEABLE):
			GtkExtra.message_box(_("Error"), _("You cannot delete folder \"%s\"") % folder.name, (_("Ok"),))
			return

		a = GtkExtra.message_box(_("Delete %s") % folder.name, _("Do you really want to delete\nfolder \"%s\"?") % folder.name, (_("Ok"), _("Cancel")))

		if a == _("Ok"):
			# Find parent object to delete from
			parent_object = user.parent_of(folder)
			# Get item number in parent's contents
			for x in xrange(0, len(parent_object.contents)):
				if parent_object.contents[x].uid == folder.uid:
					item = x
					break
			if isinstance(parent_object.contents[item], nntpbox.newsgroup):
				# delete articles in it
				def recurse_remove(folder, user=user):
					if folder.__dict__.has_key("messages"):
						for x in folder.messages:
							folder.io.delete_article(x)
				utils.recurse_apply( [parent_object.contents[item]], recurse_remove)
			else:
				# delete whole damn lot
				parent_object.contents[item].io.nuke()
			# delete folder
			del parent_object.contents[item]
			# update folder list
			user.update(UPDATE_FOLDERVIEW)

	def sender2addrbook(self, _a=None, _b=None):
		"""
		Add sender of message to address book.
		"""
		# get selected message id
		msg_ids = self.get_message_list_selected()
		folder = self.opened_folder
	
		if msg_ids == []:
			return
		msg = folder.io.load_article(msg_ids[0])
		self.parent_user.addressbook.add_senders_address(msg, self.addr_book())

	def mark_message(self, _a=None, _b=None):
		user = self.parent_user
		# get selected message id
		msg_ids = self.get_message_list_selected()
		folder = self.opened_folder
		# apply to all selected messages
		for msg_id in msg_ids:
			# mark it
			msg = folder.io.load_article(msg_id)
			if msg.opts & MSG_ISMARKED:
				continue
			msg.opts = msg.opts | MSG_ISMARKED
			folder.io.save_article(msg)
			# update message list
			self.message_list.update_node(user, msg.opts, msg_id=msg_id)

	def unmark_message(self, _a=None, _b=None):
		user = self.parent_user
		# get selected message id
		msg_ids = self.get_message_list_selected()
		folder = self.opened_folder
		# apply to all selected messages
		for msg_id in msg_ids:
			# unmark it
			msg = folder.io.load_article(msg_id)
			if not (msg.opts & MSG_ISMARKED):
				return
			msg.opts = msg.opts & (~MSG_ISMARKED)
			folder.io.save_article(msg)
			# update message list
			self.message_list.update_node(user, msg.opts, msg_id=msg_id)

	def reply_to_message(self, type=REPLY_AUTO, _b=None):
		"""
		Reply to sender of selected message by email.
		"""
		user = self.parent_user
		# get selected message id
		msg_id =  self.get_message_list_selected()
		if msg_id == []:
			return
		# find outbox
		the_outbox = user.get_folder_by_uid("outbox")
		from_folder = self.opened_folder

		msg_id = msg_id[0]
		msg = from_folder.io.load_article(msg_id)
	
		# we can't reply to messages we don't have the body text of
		if msg.opts & MSG_NO_BODY:
			return
	
		the_outbox.do_reply(user, msg, from_folder, type)

	def delete_thread(self, _a=None, _b=None):
		"""
		Delete an entire thread from a newsgroup.
		"""
		folder = self.opened_folder
		if not isinstance(folder, nntpbox.newsgroup):
			return
		for msg_id in self.get_message_list_selected():
			if msg_id in folder.messages:
				folder.kill_thread(msg_id)
		folder.changed = 1
		self.parent_user.update()
		

	def download_body(self, _a=None, _b=None):
		"""
		Download the body of a partially downloaded (headers only)
		message.
		"""
		user = self.parent_user
		folder = self.opened_folder
		if not isinstance(folder, nntpbox.newsgroup):
			return
		parent_nntpbox = user.parent_of(folder)
		msg_ids = self.get_message_list_selected()
		threading.Thread(target=folder.get_rest_of_msg, args=(user,parent_nntpbox,msg_ids)).start()

	def delete_message(self, _a=None, _b=None):
		"""
		Delete selected message(s), archiving into deleted folder unless
		already there.
		"""
		user = self.parent_user
		# get selected message id
		msg_ids = self.get_message_list_selected()
		if msg_ids == []:
			return
		# find deleted box
		deleted = user.get_folder_by_uid("deleted")
		oldfolder = self.opened_folder
		if isinstance(oldfolder, nntpbox.newsgroup):
			return

		for x in msg_ids:
			# if we are deleting from the deleted folder then
			# permanently delete the message
			oldfolder.messages.remove(x)
			if oldfolder.uid != "deleted":
				msg = oldfolder.io.load_article(x)
				deleted.messages.append(x)
				deleted.io.save_article(msg)
				oldfolder.io.delete_article(x)
			else:
				oldfolder.io.delete_article(x)
		deleted.changed = 1
		oldfolder.changed = 1	
		user.update()

	def shred_message(self, _a=None, _b=None):
		"""
		Permenently delete a message or group of messages.
		"""
		user = self.parent_user
		#### Allow multiple selections [not yet]
		msg_ids = self.get_message_list_selected()
		folder = self.opened_folder
		if folder == None:
			return
		if isinstance(folder, nntpbox.newsgroup):
			return

		for x in msg_ids:
			folder.messages.remove(x)
			# permanently delete
			folder.io.delete_article(x)
		folder.changed = 1
		user.update()

	def edit_message(self, _a=None, _b=None):
		"""
		Edit the currently selected message.
		"""
		user = self.parent_user
		# get selected message id
		msg_id = self.get_message_list_selected()
		if msg_id == []:
			return
		folder = self.opened_folder
		msg_id = msg_id[0]
		msg = folder.io.load_article(msg_id)
		# You can only edit outgoing messages. stands to reason.
		if msg.senduid == None:
			return
		msg.edit(folder, user)

	def print_message(self, _a=None, _b=None):
		"""
		Print the message.
		"""
		from printmodule import print_box

		user = self.parent_user
		# get selected message id
		msg_id = self.get_message_list_selected()
		if msg_id == []:
			return
		# You can only edit outgoing messages. stands to reason.
		folder = self.opened_folder
		if folder == None:
			return
		msg_id = msg_id[0]
		message = folder.io.load_article(msg_id)

		print_dialog = print_box(user, message)
		print_dialog.show()
		

	def new_message(self, _a=None, _b=None):
		"""
		Compose a new message.
		"""
		user = self.parent_user
		# find folder to send from
		folder = self.opened_folder
		if folder == None:
			return
		# find outbox
		the_outbox = user.get_folder_by_uid("outbox")
		# use REPLY types...
		if isinstance(folder, nntpbox.newsgroup):
			# need to find the nntpbox parent box
			parent_folder = user.parent_of(folder)
			# preset to field to NG name
			the_outbox.new_message(user, parent_folder, REPLY_GROUP, to=folder.name)
		elif isinstance(folder, mailbox.mailbox):
			the_outbox.new_message(user, folder, REPLY_EMAIL, to="")

	def unixbox_export(self, _a=None, _b=None):
		"""
		Export messages to a unix mailbox format file.
		"""
		folder = self.opened_folder
		if folder == None or isinstance(folder, nntpbox.newsgroup):
			return
		# open file selection box
		filename = GtkExtra.file_sel_box(_("Save/Append messages to Unix mailbox"))

		if filename == None:
			return

		try:
			f = open(filename, "a")
		except IOError:
			utils.info_box(_("Error"), _("Could not open %s") % filename)
			return

		for i in folder.messages:
			msg = folder.io.load_article(i)
			lines = string.split(msg.body, "\n")
			
			from_addr = utils.split_address(msg.headers["from"])[1]
			if from_addr == "":
				from_addr = "nobody@localdomain"
			f.write("From "+from_addr+time.strftime(" %a %b %d %H:%M:%S %Y\n", msg.date))
			# dump lines up to start of body
			while lines[0] != "":
				f.write(lines[0]+"\n")
				del lines[0]
			# dump body. escape 'From' lines this time
			for x in lines:
				if x[:5] == "From ":
					f.write(">"+x+"\n")
				else:
					f.write(x+"\n")
			# extra \n at end
			f.write("\n")
		f.close()

	def unixbox_import(self, _a=None, _b=None):
		"""
		Load all the messages in a unix (~/Mail) mailbox into the
		current folder.
		"""
		folder = self.opened_folder
		if folder==None or isinstance(folder, nntpbox.newsgroup):
			return
		# Open file selection box
		filename = GtkExtra.file_sel_box(_("Load messages from a Unix mailbox"))

		if filename == None:
			return

		try:
			import mailbox
			f = open(filename, "r")
		except IOError:
			utils.info_box(_("Error"), _("Could not open %s") % filename)
			return
		except ImportError:
			utils.info_box(_("Error"), _("Missing Python \"mailbox\" module."))
			return
		
		msgs = mailbox.UnixMailbox(f)
		
		while 1:
			rfc822msg = msgs.next()
			if rfc822msg == None:
				break
			body = str(rfc822msg) + "\n" + rfc822msg.fp.read()
			# Make a pyne message from this body
			msg = pynemsg.pynemsg()
			msg.body = body
			msg.parseheaders(self.parent_user)
			msg.date_received = time.gmtime(time.time())
			if not msg.headers.has_key("message-id"):
				msg_id = folder.io.get_unique_message_id()
				msg.headers["message-id"] = msg_id
				msg.body = "Message-Id: "+msg_id+"\n"+msg.body
			if msg.headers["message-id"] in folder.messages:
				# don't let duplicates be added
				continue
			folder.io.save_article(msg)
			folder.messages.append(msg.headers["message-id"])
		f.close()
		folder.changed = 1
		self.parent_user.update()	
			
	def load_from_ascii(self, _a=None, _b=None):
		"""
		Load an ascii format message with headers and all that junk and
		put in the current folder.
		"""
		folder = self.opened_folder
		if folder==None or isinstance(folder, nntpbox.newsgroup):
			return
		# Open file selection box
		filename = GtkExtra.file_sel_box(_("Load ascii message"))

		if filename == None:
			return

		try:
			file = open(filename, "r")
			body = file.read()
			file.close()
		except IOError:
			utils.info_box(_("Error"), _("Could not open %s") % filename)
			return
		msg = pynemsg.pynemsg()
		msg.body = body
		msg.parseheaders(self.parent_user)
		msg.date_received = time.gmtime(time.time())
		if not msg.headers.has_key("message-id"):
			msg_id = folder.io.get_unique_message_id()
			msg.headers["message-id"] = msg_id
			msg.body = "Message-Id: "+msg_id+"\n"+msg.body
		if msg.headers["message-id"] in folder.messages:
			# don't let duplicates be added
			return
		folder.io.save_article(msg)
		folder.messages.append(msg.headers["message-id"])
		folder.changed = 1
		self.parent_user.update()
	
	def save_to_ascii(self, _a=None, _b=None):
		"""
		Save currently selected message's body to a file.
		"""
		msg_id = self.get_message_list_selected()
		folder = self.opened_folder
		if folder==None:
			pass
		if msg_id == []:
			return
		msg_id = msg_id[0]
		msg = folder.io.load_article(msg_id)

		# Open file selection box
		filename = GtkExtra.file_sel_box(_("Save message as"))

		if filename == None:
			return

		try:
			file = open(filename, "w")
		except IOError:
			GtkExtra.message_box(_("Error"), _("Could not create %s") % filename, (_("Ok"),))
		else:
			file.write(msg.body)
			file.close()

	def view_new_window(self, _a=None, _b=None):
		"""
		Open selected message in a new window.
		"""
		self.parent_user.new_window(display_msg=(self.opened_folder, self.get_message_list_selected()[0]))

	def view_browser(self, _a=None, _b=None):
		"""
		Open selected message in browser (for crappy html emails)
		"""
		try:
			import webbrowser
		except ImportError:
			GtkExtra.message_box(_("Missing module"), _("Python 'webbrowser' module missing"), (_("Cancel"),))
			return
		user = self.parent_user

		msg_id = self.get_message_list_selected()
		folder = self.opened_folder
		if folder==None:
			pass
		if msg_id == []:
			return
		msg_id = msg_id[0]
		msg = folder.io.load_article(msg_id)
	
		# we can't reply to messages we don't have the body text of
		if msg.opts & MSG_NO_BODY:
			return

		filename = tempfile.mktemp(".html")

		file = open(filename, "w")
		file.write(msg.parts_text[0])
		file.close()

		webbrowser.open("file://"+filename, 1)

		# remember temporary files for cleanup time :-)
		# /me kisses pyne.py
		user.tempfiles.append(filename)

	def updateall_mail(self, _a=None, _b=None):
		"""
		You clicked 'update' all mailboxes.
		"""
		user = self.parent_user
		pager = utils.ProgressWindow(_("Collecting messages..."), hidetext=_("Show Logs"))
		# Update every mailbox
		def _recurse_update(folder, user=user, pager=pager):
			# nntpboxes recurse into the newsgroups for us..
			if isinstance(folder, nntpbox.newsgroup):
				return
			if (not folder.__dict__.has_key("locked")) and (folder.get_flags() & BOX_UPDATE_METHOD):
				threading.Thread(target=folder.update, args=(user,pager)).start()
		utils.recurse_apply(user.contents, _recurse_update)

	def update_mail(self, _a=None, _b=None):
		"""
		You clicked 'update' mailbox.
		"""
		user = self.parent_user
		folder = self.get_folder_list_selected()
		if folder == None:
			return
		if isinstance(folder, nntpbox.newsgroup) and not \
		   folder.__dict__.has_key("locked"):
			# Update a single newsgroup rather all subscribed
			# find parent nntpbox
			parent = user.parent_of(folder)
			pager = utils.ProgressWindow(_("Collecting messages..."), hidetext=_("Show Logs"))
			func = parent.update
			threading.Thread(target=func, args=(user,pager,folder)).start()
		elif not folder.__dict__.has_key("locked"):
			pager = utils.ProgressWindow(_("Collecting messages..."), hidetext=_("Show Logs"))
			func = folder.update
			threading.Thread(target=func, args=(user,pager)).start()

	def addr_book(self, _a=None, _b=None):
		"""
		Open the address book.
		"""
		user=self.parent_user
		addr_box = AddressEditBox(user.addressbook)
		def test_thing(_button, addr_box=addr_box):
			addr_box.destroy()
		addr_box.ok_button.connect("clicked", test_thing)
		return addr_box

	def rot13_message(self, _a=None, _b=None):
		"""
		Rot13 the body of the currently displayed message.
		"""
		self.msg_view.rot13_redisplay(self.parent_user)

	def search_message(self, _a=None, _b=None):
		"""
		Find instance of a phrase in the currently displayed
		message.
		"""
		# create pretty find boxy thing
		win = GtkWindow()
		win.set_title(_("Pyne - Find in message"))
		box = GtkVBox()
		win.add(box)
		box.show()

		# Find: [ something ]   text entry
		box1 = GtkHBox()
		box.pack_start(box1, expand=FALSE)
		box1.set_border_width(5)
		box1.show()
		label = GtkLabel(_("Find: "))
		box1.pack_start(label, expand=FALSE)
		label.show()
		find_entry = GtkEntry()
		box1.pack_start(find_entry)
		find_entry.show()

		# position of find in body text.
		position = [0]

		# Buttons
		box2 = GtkHBox()
		box2.set_border_width(5)
		box.pack_start(box2, expand=FALSE)
		box2.show()
		case_sensitive_cb = GtkCheckButton(_("Case Sensitive"))
		box2.pack_start(case_sensitive_cb, expand=FALSE)
		case_sensitive_cb.show()

		def do_find(_button, self=self, \
			             find_entry=find_entry, \
			             position=position, \
			             case_sensitive_cb=case_sensitive_cb):
			user = self.parent_user
		
			body_obj = self.msg_view.body_text
			msg_body = body_obj.get_chars(0, body_obj.get_length())
		
			find_me = find_entry.get_text()

			if case_sensitive_cb.get_active():
				start = string.find(msg_body[position[0]:], find_me)
			else:
				# all munched to lower case
				start = string.find( string.lower(msg_body)[position[0]:], string.lower(find_me))

			if start != -1:
				position[0] = position[0] + start + 1
				body_obj.select_region(position[0] - 1, position[0]+len(find_me)-1)
			else:
				# hit end of file with no find
				position[0] = 0


		# Buttons [cont]
		button = GtkButton(" "+_("Find")+" ")
		button.connect("clicked", do_find)
		button.show()
		box2.pack_end(button, expand=FALSE)
		box2.show()

		win.show()

	def search_messages(self, _a=None, _b=None):
		"""
		Find a message in the current mailbox containing some
		phrase.
		"""
		# create pretty find boxy thing
		win = GtkWindow()
		win.set_title(_("Pyne - Find message"))
		box = GtkVBox()
		win.add(box)
		box.show()

		# Find: [ something ]   text entry
		box1 = GtkHBox()
		box.pack_start(box1, expand=FALSE)
		box1.set_border_width(5)
		box1.show()
		label = GtkLabel(_("Find: "))
		box1.pack_start(label, expand=FALSE)
		label.show()
		find_entry = GtkEntry()
		box1.pack_start(find_entry)
		find_entry.show()

		# position in message list
		position = [0]

		# Buttons
		box2 = GtkHBox()
		box2.set_border_width(5)
		box.pack_start(box2, expand=FALSE)
		box2.show()
		case_sensitive_cb = GtkCheckButton(_("Case Sensitive"))
		box2.pack_start(case_sensitive_cb, expand=FALSE)
		case_sensitive_cb.show()

		def do_find(_button, self=self, \
			             find_entry=find_entry, \
			             position=position, \
			             case_sensitive_cb=case_sensitive_cb):
			user = self.parent_user
	
			while 1:
				node = self.message_list.node_nth(position[0])
				if node == None:
					# search finished with no find :-\
					position[0] = 0
					GtkExtra.message_box(_("Pyne Search"), _("Reached end of search"), (_("Ok"),))
					break
				msg_id = self.message_list.node_get_row_data(node)
				folder = self.opened_folder
				if folder == None:
					pass
				if msg_id == None:
					position[0] = position[0] + 1
					continue
				msg = folder.io.load_article(msg_id)
	
				find_me = find_entry.get_text()
				position[0] = position[0] + 1

				if case_sensitive_cb.get_active():
					index = string.find(msg.parts_text[0], find_me)
				else:
					# all munched to lower case
					index = string.find(string.lower(msg.parts_text[0]), string.lower(find_me))
				if index != -1:
					# find ancestor and expand it
					for i in xrange(position[0]-2, -1, -1):
						tempnode = self.message_list.node_nth(i)
						if not self.message_list.is_ancestor(tempnode, node):
							self.message_list.expand_recursive( \
								self.message_list.node_nth(i+1))
							break
					self.message_list.select(node)
					self.message_list.node_moveto(node, 0, 0.5, 0.5)
					break

		# Buttons [cont]
		button = GtkButton(" "+_("Find")+" ")
		button.connect("clicked", do_find)
		button.show()
		box2.pack_end(button, expand=FALSE)
		box2.show()

		win.show()
			
	def expand_all(self, _a=None, _b=None):
		self.message_list.freeze()
		i = 0
		node = self.message_list.node_nth(i)
		while node != None:
			self.message_list.expand_recursive(node)
			i = i + 1
			node = self.message_list.node_nth(i)
		self.message_list.thaw()

	def collapse_all(self, _a=None, _b=None):
		self.message_list.freeze()
		i = 0
		node = self.message_list.node_nth(i)
		while node != None:
			self.message_list.collapse_recursive(node)
			i = i + 1
			node = self.message_list.node_nth(i)
		self.message_list.thaw()


	def make_menubar(self):
		"""
		Construct the menu bar.
		"""

		def do_prefs(_a, _button, user=self.parent_user):
			"""
			Run the user preferences dialog.
			"""
			user.set_preferences()

		#
		# Pulldown menus
		#
		ag = GtkAccelGroup()
		itemf = ptk.menu_maker.MyGtkItemFactory(GtkMenuBar, "<main>", ag, methodset=self.method_widgets)

		# cache some names of menus
		n_file = _("_File")
		n_folder = _("Fol_der")
		n_message = _("_Message")
		n_options = _("_Options")
		n_help = _("_Help")

		# Export these, so we can also use them on right-click popups
		self.filemenu_items = [
			("/"+_("_New Window"), "<control>N", self.new_window, 2, ""),
			("/sep1", None, None, 0, "<Separator>"),
			("/"+_("_Load Message"), "<control>O", self.load_from_ascii, 3, ""),
			("/"+_("Save Message _As..."), "<control>S", self.save_to_ascii, 4, ""),
			("/"+_("_Print Message"), "<control>P", self.print_message, 0, "", METH_PRINT_MESSAGE),
			("/sep2", None, None, 0, "<Separator>"),
			("/"+_("_Import Unix mailbox"), None, self.unixbox_import, 0, ""),
			("/"+_("_Export to Unix mailbox"), None, self.unixbox_export, 0, ""),
			("/sep3", None, None, 0, "<Separator>"),
			("/"+_("_Quit"), "<control>Q", self.close, 5, "")
		]
		self.foldermenu_items = [
			("/"+_("_New"), None, None, 1, "<Branch>"),
			("/"+_("_New")+"/"+_("_Folder"), None, self.new_mailbox, 2, ""),
			("/"+_("_New")+"/"+_("_Mail folder"), None, self.new_mailbox, 0, ""),
			("/"+_("_New")+"/"+_("_News folder"), None, self.new_mailbox, 1, ""),
			("/sep1", None, None, 0, "<Separator>"),
			("/"+_("Move Up"), None, self.move_folder, -1, ""),
			("/"+_("Move Down"), None, self.move_folder, +1, ""),
			("/sep2", None, None, 0, "<Separator>"),
			("/"+_("_Settings"), None, self.folder_settings, 2, ""),
			("/"+_("_Delete"), None, self.delete_folder, 3, "", METH_DELETE_BOX),
			("/sep3", None, None, 0, "<Separator>"),
			("/"+_("_Update"), None, self.update_mail, 0, "", METH_FOLDER_UPDATE),
			("/"+_("Update _All"), None, self.updateall_mail, 0, ""),
			("/sep4", None, None, 0, "<Separator>"),
			("/"+_("_Expand All"), "<control>E", self.expand_all, 0, "", METH_TOGGLE_EXPAND_ALL),
			("/"+_("_Collapse All"), "<control>W", self.collapse_all, 0, "", METH_TOGGLE_EXPAND_ALL),
			("/sep5", None, None, 0, "<Separator>"),
			("/"+_("Search _Messages"), None, self.search_messages, 1, "", METH_SEARCH_MESSAGES)
		]
		self.messagemenu_items = [
			("/"+_("_Open in Browser"), "<control>B", self.view_browser, 1, "", METH_VIEW_BROWSER),
			("/"+_("Open in New _Window"), None, self.view_new_window, 0, "", METH_VIEW_NEWWIN),
			("/sep1", None, None, 0, "<Separator>"),
			("/"+_("_Mark Message"), "<control>M", self.mark_message, 0, "", METH_MARK_MESSAGE),
			("/"+_("_Unmark Message"), "<control>U", self.unmark_message, 0, "", METH_UNMARK_MESSAGE),
			("/sep2", None, None, 0, "<Separator>"),
			("/"+_("_New Message"), None, self.new_message, 1, "", METH_NEW_MESSAGE),
			("/"+_("_Edit Message"), None, self.edit_message, 1, "", METH_EDIT_MESSAGE),
			("/"+_("Reply to _Sender"), None, self.reply_to_message, REPLY_EMAIL, "", METH_REPLY_SINGLE),
			("/"+_("Reply to _Group"), None, self.reply_to_message, REPLY_GROUP, "", METH_REPLY_GROUP),
			("/"+_("_Forward Message"), None, self.reply_to_message, REPLY_FORWARD, "", METH_REPLY_FORWARD),
			("/"+_("_Delete Message"), None, self.delete_message, 1, "", METH_DEL_MESSAGE),
			("/"+_("_Delete Thread"), None, self.delete_thread, 1, "", METH_DELETE_THREAD),
			("/sep2", None, None, 0, "<Separator>"),
			("/"+_("Download _Body"), None, self.download_body, 0, "", METH_DOWNLOAD_BODY),
			("/sep3", None, None, 0, "<Separator>"),
			("/"+_("_ROT13 Body"), None, self.rot13_message, 1, ""),
			("/"+_("Fin_d in Message"), None, self.search_message, 1, ""),
			("/"+_("Add sender to address book"), None, self.sender2addrbook, 0, "", METH_SENDER2ADDRBOOK)
		]

		# Make menubar
		itemf.create_items([
			("/"+n_file, None, None, 0, ""),
			("/"+n_folder, None, None, 0, ""),
			("/"+n_message, None, None, 0, ""),
			("/"+n_options, None, None, 0, "<Branch>"),
			("/"+n_options+"/"+_("_Edit Addressbook"), None, self.addr_book, 1, ""),
			("/"+n_options+"/"+_("_Preferences"), None, do_prefs, 1, ""),

			("/"+n_help, None, None, 0, "<LastBranch>"),
			("/"+n_help+"/"+_("_About"), None, self.about_box, 1, "")
		])
		self.menubar = itemf.get_widget("<main>")

		# Add file menu
		itemf2 = ptk.menu_maker.MyGtkItemFactory(GtkMenu, "<main>", ag, methodset=self.method_widgets)
		itemf2.create_items(self.filemenu_items)
		itemf.get_widget("<main>/"+string.replace(n_file, "_", "")).set_submenu(itemf2.get_widget("<main>"))
		
		# and folder menu
		itemf2 = ptk.menu_maker.MyGtkItemFactory(GtkMenu, "<main>", ag, methodset=self.method_widgets)
		itemf2.create_items(self.foldermenu_items)
		itemf.get_widget("<main>/"+string.replace(n_folder, "_", "")).set_submenu(itemf2.get_widget("<main>"))
		
		# message menu
		itemf2 = ptk.menu_maker.MyGtkItemFactory(GtkMenu, "<main>", ag, methodset=self.method_widgets)
		itemf2.create_items(self.messagemenu_items)
		itemf.get_widget("<main>/"+string.replace(n_message, "_", "")).set_submenu(itemf2.get_widget("<main>"))
		
		self.box1.pack_start(self.menubar, expand=FALSE)
		self.win.add_accel_group(ag)

		self.menubar.show()

	def make_toolbar(self):
		"""
		Make toolbar
		"""
		# Toolbar
		self.toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_BOTH)

		def _reply_email(_button, self=self):
			self.reply_to_message(REPLY_EMAIL)
		def _reply_group(_button, self=self):
			self.reply_to_message(REPLY_GROUP)
		def _reply_forward(_button, self=self):
			self.reply_to_message(REPLY_FORWARD)

		# First section. Send and recieve mail

		# Send and recieve from all folders
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_updateall_mail.xpm")
		self.toolbar.append_item(_("Update All"), _("Send and recieve mail for all folders"), _("Send and recieve mail for all folders"),
				GtkPixmap(pix, mask), self.updateall_mail)

		# Send/recieve from one folder
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_update_mail.xpm")
		w = self.toolbar.append_item(_("Update"), _("Send or recieve mail for current folder only"), _("Send or recieve mail for current folder only"),
				GtkPixmap(pix, mask), self.update_mail)
		self.method_widgets.add_widget(METH_FOLDER_UPDATE, w)

		self.toolbar.append_space()

#		def select_prev_msg(_button, self=self):
#			print "woo"
#		def select_next_msg(_button, self=self):
#			print "poo"
#			
#		# 2nd section. Message up.down buttons
#		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_msg_up.xpm")
#		self.toolbar.append_item(_("Prev"), _("Previous Message"), _("Previous Message"),
#				GtkPixmap(pix, mask), select_prev_msg)
#
#		# Send/recieve from one folder
#		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_msg_down.xpm")
#		self.toolbar.append_item(_("Next"), _("Next Message"), _("Next Message"),
#				GtkPixmap(pix, mask), select_next_msg)
#
#		self.toolbar.append_space()

		# 3rd section. regarding messages

		# Print message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_print_message.xpm")
		w = self.toolbar.append_item(_("Print"), _("Print Message"), _("Print Message"),
				GtkPixmap(pix, mask), self.print_message)
		self.method_widgets.add_widget(METH_PRINT_MESSAGE, w)
		self.toolbar.append_space()
		# New Message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_new_message.xpm")
		w = self.toolbar.append_item(_("New Message"), _("Compose new message"), _("Compose new message"),
				GtkPixmap(pix, mask), self.new_message)
		self.method_widgets.add_widget(METH_NEW_MESSAGE, w)
		# Edit message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_edit_message.xpm")
		w = self.toolbar.append_item(_("Edit"), _("Edit message"), _("Edit message"),
				GtkPixmap(pix, mask), self.edit_message)
		self.method_widgets.add_widget(METH_EDIT_MESSAGE, w)
		# Reply to message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_reply_message.xpm")
		w = self.toolbar.append_item(_("Reply"), _("Reply to sender"), _("Reply to sender"),
				GtkPixmap(pix, mask), _reply_email)
		self.method_widgets.add_widget(METH_REPLY_SINGLE, w)
		# Reply to all recipients
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_replyall_message.xpm")
		w = self.toolbar.append_item(_("Reply All"), _("Reply to group"), _("Reply to group"),
				GtkPixmap(pix, mask), _reply_group)
		self.method_widgets.add_widget(METH_REPLY_GROUP, w)
		# Forward message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_forward_message.xpm")
		w = self.toolbar.append_item(_("Forward"), _("Forward message"), _("Forward message"),
				GtkPixmap(pix, mask), _reply_forward)
		self.method_widgets.add_widget(METH_REPLY_FORWARD, w)
		# Delete message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_delete_message.xpm")
		w = self.toolbar.append_item(_("Delete"), _("Delete message"), _("Delete message"),
				GtkPixmap(pix, mask), self.delete_message)
		self.method_widgets.add_widget(METH_DEL_MESSAGE, w)

		self.toolbar.append_space()

		# 4th section. Misc crap

		# Address book
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_address_book.xpm")
		self.toolbar.append_item(_("Address Book"), _("Address Book"), _("Address Book"),
				GtkPixmap(pix, mask), self.addr_book)
		for x in range(0,15):
			self.toolbar.append_space()
		# Shred (permanently delete) message
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/tb_shred_message.xpm")
		self.toolbar.append_item(_("Shred Message"), _("Shred (permanently delete!) message"), _("Shred (permanently delete!) message"),
				GtkPixmap(pix, mask), self.shred_message)
		

		self.toolbar.set_style(TOOLBAR_ICONS) # could be TOOLBAR_TEXT or TOOLBAR_BOTH
		self.box1.pack_start(self.toolbar, expand=FALSE)
		self.toolbar.show()

	def make_panes(self):
		"""
		Make panes like so:
		#################################
		#                               #
		#         Message List          #
		#                               #
		#################################
		#               #               #
		#   Mailboxes   # Preview Pane  #
		#               #               #
		#################################
		"""	
		def click_folder_list(w, event, ctree, self=self):
			user = self.parent_user
			# Update message list
			mousebutton = event.button
			# Right mouse button brings popup menu
			if mousebutton == 3:
				self.folder_list_popup_box(event)
				return
			if w.get_selection_info(event.x, event.y):
				# if the object contains messages show them in
				# message list pane
				object = self.get_folder_list_selected()
				if object == None:
					# probably clicked on the root node
					return
				if object.__dict__.has_key("messages"):
					# mark this as the open folder. whoohoo! :-)
					# note that subfolders need the uid of
					# their parents.
					self.opened_folder = object
					self.message_list.update(object)
			
				self.update_ui(object, None)

		# Dump clicked on message to the preview window
		def click_message_list(msg_tree, event, msg_id, self=self):
			user = self.parent_user
			mousebutton = event.button
			# Right mouse button brings popup menu
			if mousebutton == 3:
				self.message_list_popup_box(event)
				return
			folder = msg_tree.cur_object
			# mark as read if needed
			if msg_id != None:
				# Mark as read
				msg = folder.io.load_article(msg_id)
				if not ((user.opts & OPT_2CLICK_MARK) and (event.type == GDK.BUTTON_PRESS)):
					if (not msg.opts & MSG_ISREAD) and (not msg.opts & MSG_NO_BODY):
						msg.opts = msg.opts | MSG_ISREAD
						folder.io.save_article(msg)
				# Update UI state
				self.update_ui(folder, msg)
				# change icon as appropriate
				node = msg_tree.node_nth(msg_tree.get_selection_info(event.x, event.y)[0])
				msg_tree.update_node(user, msg.opts, node=node)
				# if the object contains messages show message
				if event.type == GDK.BUTTON_PRESS:
					# dump message to view pane
					self.msg_view.dump_msg(user, folder, msg_id)
				elif event.type == GDK._2BUTTON_PRESS:
					if msg.senduid != None:
						# outgoing message: open edit box
						msg.edit(folder, user)
					else:
						# else: open new window displaying message
						self.parent_user.new_window(display_msg=(folder,msg_id))
			# 'None' article
			else:
				self.msg_view.clear()
				self.update_ui(folder, None)

		self.message_list.connect_button_press_event(click_message_list)
		self.folder_list.connect_button_press_event(click_folder_list)
		self.msg_view = ptk.msg_view_box.msg_view_box(self.parent_user)

		if self.display_msg != None:
			# Simply mainwin showing only quick view pane
			self.box1.pack_start(self.msg_view)
			self.msg_view.show()
			# Dump requested message to msg_view
			self.msg_view.dump_msg(self.parent_user, self.display_msg[0], self.display_msg[1])
		else:
			# default multi-pane setup
			mpwin = GtkScrolledWindow()
			mpwin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
			mpwin.add(self.message_list)
			mpwin.show()
			self.message_list.show()
	
			fpwin = GtkScrolledWindow()
			fpwin.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
			fpwin.add(self.folder_list)
			fpwin.show()
			self.folder_list.show()
	
			self.msg_view.show()
	
			# Vertical pane
			self.vpaned = GtkVPaned()
			self.box1.pack_start(self.vpaned)
			self.vpaned.set_border_width(2)
			self.vpaned.show()
			# Horizontal pane
			self.hpaned = GtkHPaned()
			# pane layouts
			if self.parent_user.opts & OPT_PANES_CLASSIC:
				self.vpaned.add1(self.hpaned)
				self.vpaned.add2(self.msg_view)
				self.hpaned.add1(fpwin)
				self.hpaned.add2(mpwin)
			else:
				self.vpaned.add1(mpwin)
				self.vpaned.add2(self.hpaned)
				self.hpaned.add1(fpwin)
				self.hpaned.add2(self.msg_view)
			self.hpaned.show()
			# size panes
			pos = self.parent_user.window_setup[self.number][1] / 3
			self.vpaned.set_position(pos)
			#self.vpaned.set_position(self.parent_user.window_setup[self.number][VPANE_POS])
			#self.hpaned.set_position(self.parent_user.window_setup[self.number][HPANE_POS])
			#def _moo(widget, event, self=self):
			#	print widget
			#	print str(event)
			#self.vpaned.connect("add", _moo)

	def __init__(self, user, title, size, number, display_msg=None):
		"""
		Main window initialisation.
		size: (width, height, hpane pos)
		"""
		# Parent user and window number
		self.parent_user = user
		self.number = number
		self.display_msg = display_msg

		def resize(win, event, self=self, user=user):
			# Store mainwindow size
			size = (event.width, event.height, -1, -1)
			user.window_setup[self.number] = size

		#create main window
		self.win = GtkWindow(WINDOW_TOPLEVEL)
		self.win.set_default_size(size[0], size[1])
		self.win.connect("delete_event", self.close)
		self.win.connect("configure_event", resize)
		self.win.set_title(title)

		# set icon
		pix, mask = create_pixmap_from_xpm(self.win, None, pyne_path+"/icons/pyne.xpm")
		self.win.set_icon(GtkPixmap(pix, mask))

		# Box to contain the shit in the main window
		self.box1 = GtkVBox()
		self.win.add(self.box1)
		self.box1.show()

		# Dictionary of method widgets
		self.method_widgets = ptk.menu_maker.method_set()

		# Defined early 'cause menubar/toolbar needs them
		self.folder_list = ptk.folder_tree.folder_tree()
		# Setup DND
		targets = [ ("pyne_msgid", 0, -1), ("pyne_boxid", 0, -1) ]
		def dnd_drag_data_received(w, context, x, y, data, info, time, self=self):
			# get target ('pyne_msgid' or 'pyne_boxid')
			content_type = str(context.targets[0])
			user = self.parent_user
			to_folder = self.get_folder_list_selected()
			if content_type == "pyne_msgid":
				if to_folder == None:
					return
				#if data and data.format == 8 and to_folder != None:
				from_folder = user.get_folder_by_uid(string.split(data.data, "/")[0])
				if from_folder.uid == to_folder.uid:
					return
				# evaluate to list of message ids
				msg_ids = eval( string.join( string.split(data.data, "/")[1:], "/" ) )

				for msg_id in msg_ids:
					# don't bother if it's there already
					if msg_id in to_folder.messages:
						continue
					msg = from_folder.io.load_article(msg_id)
					# check we are moving OUTGOING messages to the outbox
					if isinstance(to_folder, outbox.outbox):
						if msg.senduid == None:
							# moving non-outgoing message to outbox.
							# make it a reply.
							to_folder.do_reply(user, msg, from_folder, type=REPLY_AUTO)
							continue
					to_folder.messages.append(msg_id)
					to_folder.io.save_article(msg)
					# copy not move if from newsgroup
					if not isinstance(from_folder, nntpbox.newsgroup):
						from_folder.messages.remove(msg_id)
						from_folder.io.delete_article(msg_id)
						from_folder.changed = 1
					to_folder.changed = 1
				user.update()
			elif content_type == "pyne_boxid":
				from_folder = user.get_folder_by_uid(data.data)
				# illegal from folders. we only want to move
				# mailboxes at the moment.
				if not isinstance(from_folder, mailbox.mailbox) and \
				   not isinstance(from_folder, storebox.storebox):
					GtkExtra.message_box(_("Error"), _("You can only move mailboxes into\nother mailboxes."), (_("Cancel"),))
					return
				# make sure we are not moving into ourself or a child box
				def _is_child(folder, to_folder=to_folder):
					if folder is to_folder:
						return 1
				if len(utils.recurse_apply([from_folder], _is_child)) > 0:
					GtkExtra.message_box(_("Error"), _("You cannot move folders into\nthemselves or their sub-folders."), (_("Cancel"),))
					return
				if from_folder == to_folder:
					return
				if to_folder == None:
					# copying to root node (user.contents)
					to_folder = user
				# find parent of from_folder and remove it from
				# there
				parent_object = user.parent_of(from_folder)
				parent_object.contents.remove(from_folder)
				# append to to_folder contents
				to_folder.contents.append(from_folder)
				# big update of folderview, since its structure has changed
				user.update(UPDATE_FOLDERVIEW)
				
		def dnd_drag_motion(w, context, x, y, time, self=self):
			# get target ('pyne_msgid' or 'pyne_boxid')
			content_type = str(context.targets[0])
			# For some reason the last entry in the CTree
			# cannot be selected when dragged over :-\ XXX XXX XXX
			folder_list = self.folder_list
			y = y-20  # hack to make CTree DND selection not look
				  # too sloppy... see XXX thingy
			selected = folder_list.get_selection_info(x, y)
			if selected:
				row = selected[0]# - 1 # hack to fix CTree DND thingy
				node = folder_list.node_nth(row)
				if node == None:
					return
				box = folder_list.node_get_row_data(node)
				folder_list.selected = [ box ]
				folder = self.get_folder_list_selected()
				if content_type == "pyne_msgid":
					# only allow sensible folders :-]
					if isinstance(folder, mailbox.mailbox) or \
					   isinstance(folder, deletedbox.deletedbox) or \
					   isinstance(folder, storebox.storebox) or \
					   isinstance(folder, outbox.outbox):
						# gtk selectalise it :-.
						folder_list.select(node)
					else:
						folder_list.selected = [ None ]
				elif content_type == "pyne_boxid":
					# only allow moving to the root node
					# and into mailboxes.
					if folder==None or \
					   isinstance(folder, mailbox.mailbox) or \
					   isinstance(folder, storebox.storebox):
						# folder==None indicates root node
						folder_list.select(node)
					else:
						folder_list.selected = [ None ]

		self.folder_list.connect("drag_data_received", dnd_drag_data_received)
		self.folder_list.connect("drag_motion", dnd_drag_motion)
		self.folder_list.drag_dest_set(DEST_DEFAULT_ALL, targets, GDK.ACTION_MOVE)

		self.message_list = ptk.message_tree.message_tree(user, size[0])
		# the uid of the current open folder (not necessarily the
		# selected one. just the one showing messages)
		if self.display_msg == None:
			self.opened_folder = None
		else:
			self.opened_folder = self.display_msg[0]

		self.make_menubar()
		self.make_toolbar()
		self.make_panes()

		# Set default method states
		if self.display_msg != None:
			folder, msg_id = self.display_msg
			self.update_ui(folder, folder.io.load_article(msg_id))
		else:
			self.update_ui(None, None)

		self.win.show()

	def update(self, contents, update_type):
		"""
		Fill folder_list with items from user's contents.
		"""
		if self.display_msg != None:
			# no visible folder or message lists
			return
		# update folder and message list
		if update_type == UPDATE_FOLDERVIEW:
			self.folder_list.update(contents, update_all=1)
			self.message_list.update(self.opened_folder, clear=1)
		else:
			self.folder_list.update(contents)
			self.message_list.update(self.opened_folder)

