/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded2DDoubleSet
extends Gridded2DSet
implements GriddedDoubleSet {
    double[] Low = new double[2];
    double[] Hi = new double[2];
    double LowX;
    double HiX;
    double LowY;
    double HiY;
    double[][] Samples;

    public Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, true);
    }

    Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, copy);
    }

    public Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true);
    }

    public Gridded2DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, copy, true);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        super(type, null, lengthX, lengthY, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1) {
            for (int i = 0; i < this.Length; ++i) {
                if (this.Samples[0][i] == this.Samples[0][i]) continue;
                throw new SetException("Gridded2DDoubleSet: samples values may not be missing");
            }
            double xpos = (this.Samples[0][1] - this.Samples[0][0]) * (this.Samples[1][this.LengthX + 1] - this.Samples[1][1]) - (this.Samples[1][1] - this.Samples[1][0]) * (this.Samples[0][this.LengthX + 1] - this.Samples[0][1]);
            boolean bl = this.Pos = xpos > 0.0;
            if (test) {
                if (xpos == 0.0) {
                    throw new SetException("Gridded2DSet: samples do not form a valid grid");
                }
                double[] v00 = new double[2];
                double[] v10 = new double[2];
                double[] v01 = new double[2];
                double[] v11 = new double[2];
                for (int j = 0; j < this.LengthY - 1; ++j) {
                    for (int i = 0; i < this.LengthX - 1; ++i) {
                        for (int v = 0; v < 2; ++v) {
                            v00[v] = this.Samples[v][j * this.LengthX + i];
                            v10[v] = this.Samples[v][j * this.LengthX + i + 1];
                            v01[v] = this.Samples[v][(j + 1) * this.LengthX + i];
                            v11[v] = this.Samples[v][(j + 1) * this.LengthX + i + 1];
                        }
                        double w1 = (v10[0] - v00[0]) * (v11[1] - v10[1]) - (v10[1] - v00[1]) * (v11[0] - v10[0]);
                        double w2 = (v11[0] - v10[0]) * (v01[1] - v11[1]) - (v11[1] - v10[1]) * (v01[0] - v11[0]);
                        double w3 = (v01[0] - v11[0]) * (v00[1] - v01[1]) - (v01[1] - v11[1]) * (v00[0] - v01[0]);
                        double w4 = (v00[0] - v01[0]) * (v10[1] - v00[1]) - (v00[1] - v01[1]) * (v10[0] - v00[0]);
                        if (w1 > 0.0 == this.Pos && w1 != 0.0 && w2 > 0.0 == this.Pos && w2 != 0.0 && w3 > 0.0 == this.Pos && w3 != 0.0 && w4 > 0.0 == this.Pos && w4 != 0.0) continue;
                        throw new SetException("Gridded2DDoubleSet: samples do not form a valid grid (" + i + "," + j + ")");
                    }
                }
            }
        }
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded2DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, (float[][])null, lengthX, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(grid)));
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(value)));
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int len = weights.length;
        double[][] w = new double[len][];
        this.doubleToInterp(Set.floatToDouble(value), indices, w);
        for (int i = 0; i < len; ++i) {
            if (w[i] == null) continue;
            weights[i] = new float[w[i].length];
            for (int j = 0; j < w[i].length; ++j) {
                weights[i][j] = (float)w[i][j];
            }
        }
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        return copy ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            double[][] grid = new double[this.ManifoldDimension][length];
            for (int i = 0; i < length; ++i) {
                int indexY;
                int indexX;
                if (0 <= index[i] && index[i] < this.Length) {
                    indexX = index[i] % this.LengthX;
                    indexY = index[i] / this.LengthX;
                } else {
                    indexX = -1;
                    indexY = -1;
                }
                grid[0][i] = indexX;
                grid[1][i] = indexY;
            }
            return this.gridToDouble(grid);
        }
        double[][] values = new double[2][length];
        for (int i = 0; i < length; ++i) {
            if (0 <= index[i] && index[i] < this.Length) {
                values[0][i] = this.Samples[0][index[i]];
                values[1][i] = this.Samples[1][index[i]];
                continue;
            }
            values[0][i] = Double.NaN;
            values[1][i] = Double.NaN;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double[][] grid = this.doubleToGrid(value);
        double[] grid0 = grid[0];
        double[] grid1 = grid[1];
        for (int i = 0; i < length; ++i) {
            double g0 = grid0[i];
            double g1 = grid1[i];
            index[i] = g0 != g0 || g1 != g1 ? -1 : (int)(g0 + 0.5) + this.LengthX * (int)(g1 + 0.5);
        }
        return index;
    }

    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: bad dimension");
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: ManifoldDimension must be 2");
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        double[][] value = new double[2][length];
        for (int i = 0; i < length; ++i) {
            int j;
            double gx = grid[0][i];
            double gy = grid[1][i];
            if (gx < -0.5 || gy < -0.5 || gx > (double)this.LengthX - 0.5 || gy > (double)this.LengthY - 0.5) {
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                value[1][i] = this.Samples[1][0];
                continue;
            }
            int igx = (int)gx;
            int igy = (int)gy;
            if (igx < 0) {
                igx = 0;
            }
            if (igx > this.LengthX - 2) {
                igx = this.LengthX - 2;
            }
            if (igy < 0) {
                igy = 0;
            }
            if (igy > this.LengthY - 2) {
                igy = this.LengthY - 2;
            }
            int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
            if (gx + gy - (double)igx - (double)igy - 1.0 <= 0.0) {
                for (j = 0; j < 2; ++j) {
                    value[j][i] = this.Samples[j][s[0][0]] + (gx - (double)igx) * (this.Samples[j][s[1][0]] - this.Samples[j][s[0][0]]) + (gy - (double)igy) * (this.Samples[j][s[0][1]] - this.Samples[j][s[0][0]]);
                }
                continue;
            }
            for (j = 0; j < 2; ++j) {
                value[j][i] = this.Samples[j][s[1][1]] + ((double)(1 + igx) - gx) * (this.Samples[j][s[0][1]] - this.Samples[j][s[1][1]]) + ((double)(1 + igy) - gy) * (this.Samples[j][s[1][0]] - this.Samples[j][s[1][1]]);
            }
        }
        return value;
    }

    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: bad dimension");
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: ManifoldDimension must be 2");
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int length = Math.min(value[0].length, value[1].length);
        double[][] grid = new double[this.ManifoldDimension][length];
        int gx = (this.LengthX - 1) / 2;
        int gy = (this.LengthY - 1) / 2;
        boolean lowertri = true;
        for (int i = 0; i < length; ++i) {
            if (this.Length == 1) {
                if (Double.isNaN(value[0][i]) || Double.isNaN(value[1][i])) {
                    grid[1][i] = Double.NaN;
                    grid[0][i] = Double.NaN;
                    continue;
                }
                grid[0][i] = 0.0;
                grid[1][i] = 0.0;
                continue;
            }
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1]) {
                gx = (this.LengthX - 1) / 2;
                gy = (this.LengthY - 1) / 2;
            }
            grid[1][i] = Double.NaN;
            grid[0][i] = Double.NaN;
            for (int itnum = 0; itnum < 2 * (this.LengthX + this.LengthY); ++itnum) {
                int ogy;
                int ogx;
                boolean test3;
                boolean test2;
                boolean test1;
                double tval3;
                double tval2;
                double tval1;
                double[] v0 = new double[]{this.Samples[0][gy * this.LengthX + gx], this.Samples[1][gy * this.LengthX + gx]};
                double[] v1 = new double[]{this.Samples[0][gy * this.LengthX + gx + 1], this.Samples[1][gy * this.LengthX + gx + 1]};
                double[] v2 = new double[]{this.Samples[0][(gy + 1) * this.LengthX + gx], this.Samples[1][(gy + 1) * this.LengthX + gx]};
                double[] v3 = new double[]{this.Samples[0][(gy + 1) * this.LengthX + gx + 1], this.Samples[1][(gy + 1) * this.LengthX + gx + 1]};
                double[] bd = new double[]{v2[0] - v1[0], v2[1] - v1[1]};
                double[] bp = new double[]{value[0][i] - v1[0], value[1][i] - v1[1]};
                double[] dp = new double[]{value[0][i] - v2[0], value[1][i] - v2[1]};
                if (lowertri) {
                    double[] ab = new double[]{v1[0] - v0[0], v1[1] - v0[1]};
                    double[] da = new double[]{v0[0] - v2[0], v0[1] - v2[1]};
                    double[] ap = new double[]{value[0][i] - v0[0], value[1][i] - v0[1]};
                    tval1 = ab[0] * ap[1] - ab[1] * ap[0];
                    tval2 = bd[0] * bp[1] - bd[1] * bp[0];
                    tval3 = da[0] * dp[1] - da[1] * dp[0];
                    boolean bl = tval1 == 0.0 || tval1 > 0.0 == this.Pos ? true : (test1 = false);
                    boolean bl2 = tval2 == 0.0 || tval2 > 0.0 == this.Pos ? true : (test2 = false);
                    test3 = tval3 == 0.0 || tval3 > 0.0 == this.Pos;
                    ogx = gx++;
                    ogy = gy--;
                    if (test1 || test2) {
                        if (!test2 && !test3) {
                            --gx;
                            ++gy;
                        } else if (!test1 && !test3) {
                            --gx;
                            --gy;
                        } else if (!test1) {
                            --gy;
                        } else if (!test3) {
                            --gx;
                        }
                    }
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gx == ogx && gy == ogy && test2) {
                        grid[0][i] = ((value[0][i] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - value[1][i]) * (v2[0] - v0[0])) / ((v1[0] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - v1[1]) * (v2[0] - v0[0])) + (double)gx;
                        grid[1][i] = ((value[0][i] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - value[1][i]) * (v1[0] - v0[0])) / ((v2[0] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - v2[1]) * (v1[0] - v0[0])) + (double)gy;
                        break;
                    }
                    lowertri = false;
                    continue;
                }
                double[] bc = new double[]{v3[0] - v1[0], v3[1] - v1[1]};
                double[] cd = new double[]{v2[0] - v3[0], v2[1] - v3[1]};
                double[] cp = new double[]{value[0][i] - v3[0], value[1][i] - v3[1]};
                tval1 = bc[0] * bp[1] - bc[1] * bp[0];
                tval2 = cd[0] * cp[1] - cd[1] * cp[0];
                tval3 = bd[0] * dp[1] - bd[1] * dp[0];
                boolean bl = tval1 == 0.0 || tval1 > 0.0 == this.Pos ? true : (test1 = false);
                boolean bl3 = tval2 == 0.0 || tval2 > 0.0 == this.Pos ? true : (test2 = false);
                test3 = tval3 == 0.0 || tval3 < 0.0 == this.Pos;
                ogx = gx++;
                ogy = gy--;
                if (test1 || test3) {
                    if (!test2 && !test3) {
                        --gx;
                        ++gy;
                    } else if (!test1 && !test2) {
                        ++gx;
                        ++gy;
                    } else if (!test1) {
                        ++gx;
                    } else if (!test2) {
                        ++gy;
                    }
                }
                if (gx < 0) {
                    gx = 0;
                }
                if (gx > this.LengthX - 2) {
                    gx = this.LengthX - 2;
                }
                if (gy < 0) {
                    gy = 0;
                }
                if (gy > this.LengthY - 2) {
                    gy = this.LengthY - 2;
                }
                if (gx == ogx && gy == ogy && test3) {
                    grid[0][i] = ((v3[0] - value[0][i]) * (v1[1] - v3[1]) + (value[1][i] - v3[1]) * (v1[0] - v3[0])) / ((v2[0] - v3[0]) * (v1[1] - v3[1]) - (v2[1] - v3[1]) * (v1[0] - v3[0])) + (double)gx + 1.0;
                    grid[1][i] = ((v2[1] - v3[1]) * (v3[0] - value[0][i]) + (v2[0] - v3[0]) * (value[1][i] - v3[1])) / ((v1[0] - v3[0]) * (v2[1] - v3[1]) - (v2[0] - v3[0]) * (v1[1] - v3[1])) + (double)gy + 1.0;
                    break;
                }
                lowertri = true;
            }
            if (!(grid[0][i] >= (double)this.LengthX - 0.5 || grid[1][i] >= (double)this.LengthY - 0.5 || grid[0][i] <= -0.5) && !(grid[1][i] <= -0.5)) continue;
            grid[1][i] = Double.NaN;
            grid[0][i] = Double.NaN;
        }
        return grid;
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        for (j = 1; j < this.ManifoldDimension; ++j) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
        }
        for (int i = 0; i < length; ++i) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            for (j = this.ManifoldDimension - 2; j >= 0 && base >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                    continue;
                }
                l[j] = (int)(grid[j][i] + 0.5);
                if (l[j] == this.Lengths[j]) {
                    int n = j;
                    l[n] = l[n] - 1;
                }
                c[j] = grid[j][i] - (double)l[j];
                if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[j] + this.Lengths[j] * base;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    double b;
                    double a;
                    int isoff;
                    if (l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0) continue;
                    if (c[j] >= 0.0) {
                        isoff = off[j];
                        a = 1.0 - c[j];
                        b = c[j];
                    } else {
                        isoff = -off[j];
                        a = 1.0 + c[j];
                        b = -c[j];
                    }
                    int k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
        }
    }

    void init_doubles(double[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples  dimension " + samples.length + " not equal to domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples[0] length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new double[this.DomainDimension][this.Length] : samples;
        for (int j = 0; j < this.DomainDimension; ++j) {
            if (samples[j].length != this.Length) {
                throw new SetException("Gridded2DDoubleSet.init_doubles: samples[" + j + "] length " + samples[0].length + " doesn't match expected length " + this.Length);
            }
            double[] samplesJ = samples[j];
            double[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Double.POSITIVE_INFINITY;
            this.Hi[j] = Double.NEGATIVE_INFINITY;
            double sum = 0.0;
            for (int i = 0; i < this.Length; ++i) {
                if (SamplesJ[i] == SamplesJ[i] && !Double.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Double.NaN;
                }
                sum += SamplesJ[i];
            }
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (double)this.Length, this.Length, this.SetErrors[j].getUnit());
            }
            ((Gridded2DSet)this).Low[j] = (float)this.Low[j];
            ((Gridded2DSet)this).Hi[j] = (float)this.Hi[j];
        }
    }

    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        for (int i = 0; i < n; ++i) {
            if (range_select[i]) continue;
            this.Samples[0][i] = Double.NaN;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Gridded2DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            int j;
            if (this.DomainDimension != ((Gridded2DDoubleSet)set).getDimension() || this.ManifoldDimension != ((Gridded2DDoubleSet)set).getManifoldDimension() || this.Length != ((Gridded2DDoubleSet)set).getLength()) {
                return false;
            }
            for (j = 0; j < this.ManifoldDimension; ++j) {
                if (this.Lengths[j] == ((Gridded2DDoubleSet)set).getLength(j)) continue;
                return false;
            }
            double[][] samples = ((Gridded2DDoubleSet)set).getDoubles(false);
            if (this.Samples != null && samples != null) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        if (this.Samples[j][i] == samples[j][i]) continue;
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                }
            } else {
                double[][] this_samples = this.getDoubles(false);
                if (this_samples == null) {
                    if (samples != null) {
                        return false;
                    }
                } else {
                    if (samples == null) {
                        return false;
                    }
                    for (j = 0; j < this.DomainDimension; ++j) {
                        for (int i = 0; i < this.Length; ++i) {
                            if (this_samples[j][i] == samples[j][i]) continue;
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public Object clone() {
        Gridded2DDoubleSet clone = (Gridded2DDoubleSet)super.clone();
        if (this.Samples != null) {
            clone.Samples = (double[][])this.Samples.clone();
            for (int i = 0; i < this.Samples.length; ++i) {
                clone.Samples[i] = (double[])this.Samples[i].clone();
            }
        }
        return clone;
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 2) {
            return new Gridded2DDoubleSet(type, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded2DDoubleSet(type, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }
}

