/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class IndexedColorModel
extends ColorModel {
    private byte[] redByte;
    private byte[] greenByte;
    private byte[] blueByte;
    private byte[] alphaByte;
    private short[] redShort;
    private short[] greenShort;
    private short[] blueShort;
    private short[] alphaShort;
    private int[] redInt;
    private int[] greenInt;
    private int[] blueInt;
    private int[] alphaInt;
    private int tableSize;
    private int pixelBits;

    public IndexedColorModel(int bits, int size, byte[][] table) throws IOException {
        super(bits);
        if (table == null) {
            throw new IOException("LUT cannot be null");
        }
        for (int i = 0; i < table.length; ++i) {
            if (table[i].length >= size) continue;
            throw new IOException("LUT " + i + " too small");
        }
        if (table.length > 0) {
            this.redByte = table[0];
        }
        if (table.length > 1) {
            this.greenByte = table[1];
        }
        if (table.length > 2) {
            this.blueByte = table[2];
        }
        if (table.length > 3) {
            this.alphaByte = table[3];
        }
        this.tableSize = size;
        this.pixelBits = bits;
    }

    public IndexedColorModel(int bits, int size, short[][] table) throws IOException {
        super(bits);
        if (table == null) {
            throw new IOException("LUT cannot be null");
        }
        for (int i = 0; i < table.length; ++i) {
            if (table[i].length >= size) continue;
            throw new IOException("LUT " + i + " too small");
        }
        if (table.length > 0) {
            this.redShort = table[0];
        }
        if (table.length > 1) {
            this.greenShort = table[1];
        }
        if (table.length > 2) {
            this.blueShort = table[2];
        }
        if (table.length > 3) {
            this.alphaShort = table[3];
        }
        this.tableSize = size;
        this.pixelBits = bits;
    }

    public IndexedColorModel(int bits, int size, int[][] table) throws IOException {
        super(bits);
        if (table == null) {
            throw new IOException("LUT cannot be null");
        }
        for (int i = 0; i < table.length; ++i) {
            if (table[i].length >= size) continue;
            throw new IOException("LUT " + i + " too small");
        }
        if (table.length > 0) {
            this.redInt = table[0];
        }
        if (table.length > 1) {
            this.greenInt = table[1];
        }
        if (table.length > 2) {
            this.blueInt = table[2];
        }
        if (table.length > 3) {
            this.alphaInt = table[3];
        }
        this.tableSize = size;
        this.pixelBits = bits;
    }

    public synchronized Object getDataElements(int rgb, Object pixel) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int alpha = rgb >>> 24;
        if (this.redByte != null) {
            byte[] p = pixel == null ? new byte[3] : (byte[])pixel;
            p[0] = (byte)red;
            p[1] = (byte)green;
            p[2] = (byte)blue;
            return p;
        }
        if (this.redShort != null) {
            short[] p = pixel == null ? new short[3] : (short[])pixel;
            p[0] = (short)red;
            p[1] = (short)green;
            p[2] = (short)blue;
            return p;
        }
        if (this.redInt != null) {
            int[] p = pixel == null ? new int[3] : (int[])pixel;
            p[0] = red;
            p[1] = green;
            p[2] = blue;
            return p;
        }
        throw new UnsupportedOperationException("Invalid transfer type");
    }

    public boolean isCompatibleRaster(Raster raster) {
        return raster.getNumBands() == 1;
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        WritableRaster raster;
        if (this.pixelBits == 1 || this.pixelBits == 2 || this.pixelBits == 4) {
            raster = Raster.createPackedRaster(0, w, h, 1, this.pixelBits, null);
        } else if (this.pixelBits <= 8) {
            raster = Raster.createInterleavedRaster(0, w, h, 1, null);
        } else if (this.pixelBits <= 16) {
            raster = Raster.createInterleavedRaster(1, w, h, 1, null);
        } else {
            throw new UnsupportedOperationException("Pixel bits > 16 not supported");
        }
        return raster;
    }

    public int getAlpha(int pixel) {
        if (this.alphaByte != null) {
            return this.alphaByte[pixel] & 0xFF;
        }
        if (this.alphaShort != null) {
            return this.alphaShort[pixel] & 0xFFFF;
        }
        if (this.alphaInt != null) {
            return this.alphaInt[pixel];
        }
        return 255;
    }

    public int getBlue(int pixel) {
        if (this.blueByte != null) {
            return this.blueByte[pixel] & 0xFF;
        }
        if (this.blueShort != null) {
            return this.blueShort[pixel] & 0xFFFF;
        }
        if (this.blueInt != null) {
            return this.blueInt[pixel];
        }
        return 0;
    }

    public int getGreen(int pixel) {
        if (this.greenByte != null) {
            return this.greenByte[pixel] & 0xFF;
        }
        if (this.greenShort != null) {
            return this.greenShort[pixel] & 0xFFFF;
        }
        if (this.greenInt != null) {
            return this.greenInt[pixel];
        }
        return 0;
    }

    public int getRed(int pixel) {
        if (this.redByte != null) {
            return this.redByte[pixel] & 0xFF;
        }
        if (this.redShort != null) {
            return this.redShort[pixel] & 0xFFFF;
        }
        if (this.redInt != null) {
            return this.redInt[pixel];
        }
        return 0;
    }
}

