/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import weka.core.Utils;
import weka.gui.Messages;

public class LookAndFeel {
    public static String PROPERTY_FILE = "weka/gui/LookAndFeel.props";
    protected static Properties LOOKANDFEEL_PROPERTIES;

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static boolean setLookAndFeel() {
        Messages.getInstance();
        String classname = LOOKANDFEEL_PROPERTIES.getProperty(Messages.getString("LookAndFeel_SetLookAndFeel_ClassName_Text"), "");
        if (classname.equals("")) {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                return true;
            }
            classname = LookAndFeel.getSystemLookAndFeel();
        }
        return LookAndFeel.setLookAndFeel(classname);
    }

    public static String getSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
        String[] result = new String[laf.length];
        for (int i = 0; i < laf.length; ++i) {
            result[i] = laf[i].getClassName();
        }
        return result;
    }

    public static void main(String[] args) {
        Messages.getInstance();
        System.out.println(Messages.getString("LookAndFeel_Main_Text_First"));
        String[] list = LookAndFeel.getInstalledLookAndFeels();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(i + 1 + ". " + list[i]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("LookAndFeel_Main_Text_Second")).append(PROPERTY_FILE);
        Messages.getInstance();
        System.out.println(stringBuilder2.append(Messages.getString("LookAndFeel_Main_Text_Third")).toString());
    }

    static {
        try {
            LOOKANDFEEL_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("LookAndFeel_Exception_JOptionPaneShowMessageDialog_Text_First")).append(PROPERTY_FILE);
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("LookAndFeel_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(System.getProperties().getProperty("user.home"));
            Messages.getInstance();
            String string = stringBuilder3.append(Messages.getString("LookAndFeel_Exception_JOptionPaneShowMessageDialog_Text_Third")).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(null, string, Messages.getString("LookAndFeel_Exception_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
        }
    }
}

