/***************************************************************************
                          tagger_oggvorbis.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#undef QT_NO_ASCII_CAST   // utf8 support not fully implemented. Use taglib instead 

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_OGG

#include "tagger_oggvorbis.h"
#include "tagger_vorbiscomment.h"
#include "vcedit.h"

#include <stdio.h>
#include <stdlib.h>
#include <qfileinfo.h>

#include <ogg/ogg.h>
#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>

#include <iostream>
using namespace std;


Tagger_OggVorbis::Tagger_OggVorbis() {}
Tagger_OggVorbis::~Tagger_OggVorbis() {}


bool Tagger_OggVorbis::getInfo(TRACK *track, bool lazyRead) {

  //  qWarning("oggvorbis::getinfo starts %s", track->filename.latin1());
  OggVorbis_File vf;
  vorbis_comment *vc;
  FILE *fp;

  track->artist = "";
  track->title = "";
  track->album = "";
  track->comment = "";
  track->year = "";
  track->genre = 255;
  track->tracknumber = 0; 

  fp = fopen(track->path + "/" + track->filename,"rb");
  if (!fp) return false;
 
  if(ov_open(fp, &vf, NULL, 0) < 0) {
    return false;
  }

  vc = ov_comment(&vf,-1);
  QString s;

  Tagger_VorbisComment vbc(vc);

  track->title   = (s = vbc.getvorbiscomment("title")) == QString::null  ? QString("")  : s;
  track->artist  = (s = vbc.getvorbiscomment("artist")) == QString::null? QString("")  : s;
  track->album   = (s = vbc.getvorbiscomment("album")) == QString::null ? QString("")  : s;
  track->year    = (s = vbc.getvorbiscomment("year")) == QString::null ? QString("")  : s;
  track->comment = (s = vbc.getvorbiscomment("comment")) == QString::null ? QString("")  : s;
  track->genre   = ((s = vbc.getvorbiscomment("genre")) == QString::null ? QString("255") : s).toInt();
  track->tracknumber = ((s = vbc.getvorbiscomment( "tracknumber")) == QString::null ? QString("0")  : s).toInt();

  Tagger::stripWhiteSpace( track, "Ogg" );

  track->mimetype = MIMETYPE_OGG;
  track->layer = 0;

  vorbis_info *vvi=ov_info(&vf,-1);
  track->version = vvi->version;
  track->mode = vvi->channels;
  track->samplerate = vvi->rate;

  track->bitrate = (long) ov_bitrate(&vf,-1)/1000;
  track->length = (long) ov_time_total(&vf, -1);
  ov_clear(&vf);
  return true;
}

bool Tagger_OggVorbis::getTagOnly(TRACK *track) {

  vcedit_state *state;
  vorbis_comment *vc;
  FILE *fp;

  //  qWarning("oggvorbis::gettagonly starts %s", track->filename.latin1());

  fp = fopen(track->path + "/" + track->filename,"rb");
  if (!fp)
    {
      fprintf(stderr, QString(_("Failed to open file")) + ": %s\n", QString( track->path + "/" + track->filename ).latin1() );
      fclose(fp);
      return false;
    }

  state = vcedit_new_state();

  if(vcedit_open(state, fp) < 0)
    {
      fprintf(stderr, QString(_("Failed to open file as vorbis")) + ": %s\n", vcedit_error(state));
      fclose(fp);
      vcedit_clear(state);
      return false;
    }

  /* grab and clear the existing comments */

  vc = vcedit_comments(state);
  QString s;
  Tagger_VorbisComment vbc(vc);
  track->title = (s = vbc.getvorbiscomment( "title")) == QString::null ? QString("")  : s;
  track->artist =  (s = vbc.getvorbiscomment( "artist")) == QString::null ? QString("")  : s;
  track->album =   (s = vbc.getvorbiscomment( "album")) == QString::null ? QString("")  : s;
  track->year =    (s = vbc.getvorbiscomment( "year")) == QString::null ? QString("")  : s;
  track->comment = (s = vbc.getvorbiscomment( "comment")) == QString::null ? QString("")  : s;
  track->genre =   ((s = vbc.getvorbiscomment( "genre")) == QString::null ? QString("")  : s).toInt();
  track->tracknumber = ((s = vbc.getvorbiscomment( "tracknumber")) == QString::null ? QString("0")  : s).toInt();


  Tagger::stripWhiteSpace( track, "Ogg" );

  /* done */
  vcedit_clear(state);
  fclose(fp);
  return true;
}

bool Tagger_OggVorbis::writeInfo(TRACK *track) { 

  vcedit_state *state;
  vorbis_comment *vc;
  char  *filename, *tmpfilename;
  FILE *fp, *ft;

  if ( verbose==6 )  
    qWarning("oggvorbis::writeinfo  starts %s", track->filename.latin1());

  filename = strdup( QString( track->path + "/" + track->filename ).latin1() );
  fp = fopen( filename, "r+b");
  if (!fp)
    {
      fprintf(stderr, QString(_("Failed to open file")) + ": %s\n", filename );
      fclose(fp);
      return false;
    }


  QString ss = QString(track->path + "/") + QFileInfo(QString( filename ) ).baseName( true ) + ".tmpogg"; 
  tmpfilename = strdup( ss.latin1() );
  ft = fopen(tmpfilename,"w+b");
  if (!ft)
    {
      fprintf(stderr, QString(_("Failed to open file")) + ": %s\n", tmpfilename );
      fclose(ft);
      return false;
    }


  state = vcedit_new_state();

  if(vcedit_open(state, fp) < 0)
    {
      fprintf(stderr, QString(_("Failed to open file as vorbis")) + ": %s\n", vcedit_error(state));
      fclose(ft);fclose(fp);
      vcedit_clear(state);
      return false;
    }

  /* grab and clear the existing comments */

  vc = vcedit_comments(state);
  /* comment out those 2 lines to append rather than replace*/
  vorbis_comment_clear(vc);
  vorbis_comment_init(vc);
  /* xmms needs unicode string */
  char * utfvalue =  strdup( track->title.utf8() );
  vorbis_comment_add_tag(vc, "title", utfvalue );
  free( utfvalue );
  
  utfvalue =  strdup( track->artist.utf8() );
  vorbis_comment_add_tag(vc, "artist", utfvalue );
  free( utfvalue );

  utfvalue =  strdup( track->album.utf8() );
  vorbis_comment_add_tag(vc, "album", utfvalue );
  free( utfvalue );

  utfvalue =  strdup( track->year.utf8() );
  vorbis_comment_add_tag(vc, "year", utfvalue );
  free( utfvalue );

  utfvalue =  strdup( track->comment.utf8() );
  vorbis_comment_add_tag(vc, "comment", utfvalue );
  free( utfvalue );
  
  utfvalue =  strdup( QString::number( track->genre ).utf8() );
  vorbis_comment_add_tag(vc, "genre", utfvalue );
  free( utfvalue );

  utfvalue =  strdup( QString::number( track->tracknumber ).utf8() );
  vorbis_comment_add_tag(vc, "tracknumber", utfvalue );
  free( utfvalue );

  /* write out the modified stream */
  if(vcedit_write(state, ft) < 0)
    {
      fprintf(stderr, QString(_("Failed to write comments to output file")) + ": %s\n", 
	      vcedit_error(state));
      fclose(fp);fclose(ft);
      vcedit_clear(state);
      return 1;
    }


  /* done */
  vcedit_clear(state);
  fclose(fp);fclose(ft);

  /* Some platforms fail to rename a file if the new name already exists,
   * so we need to remove, then rename. How stupid.
   */

  if(rename( tmpfilename, filename)) {
    if(remove( filename ))
      fprintf(stderr, QString(_("Error removing old file")) + ": %s\n", filename);
    else if(rename( tmpfilename, filename))
      // TRANSLATORS: Error renaming TEMPFILENAME to FILENAME"
      fprintf(stderr, QString(_("Error renaming %s to %s")) + "\n", tmpfilename, filename );

    free( tmpfilename );
    free( filename );
  };
  return true;
}
#endif /* HAVE_OGG */
