/***************************************************************************
                          submountwatcher.cpp  -  description
                             -------------------
    begin                : Tue May 10 2005
    copyright            : (C) 2005 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "submountwatcher.h"
#include "datadispatcher.h"
#include "gui.h"

#include <qdir.h>
#include <qfileinfo.h>

#define MOUNTS "/proc/mounts"

SubmountWatcher::SubmountWatcher() {
    stopCalled = false;
    paused = false;
}

void SubmountWatcher::addDevice(QString device, QString dir) {
    deviceStates[device] = "subfs"; // unmounted
    deviceMountpoints[device] = dir;
}

void SubmountWatcher::stop() {
    stopCalled = true;
}

void SubmountWatcher::pause() {
    paused = true;
}

void SubmountWatcher::proceed() {
    paused = false;
}

void SubmountWatcher::keepMounted(QString device) {
    if(deviceStates.contains(device) && !devicesKeptMounted.contains(device)) {
        QString path = scanDirectoryForFile(deviceMountpoints[device]);
        if(!path.isNull()) {
            devicesKeptMounted[device] = new QFile(path);
            devicesKeptMounted[device]->open(IO_ReadOnly);
        }
    }
}

QString SubmountWatcher::scanDirectoryForFile(QString dir) {
    QDir d(dir);
    const QFileInfoList *list = d.entryInfoList(QDir::Dirs | QDir::Files | QDir::NoSymLinks, QDir::DirsFirst | QDir::Reversed);
    QFileInfoListIterator it( *list );
    QFileInfo *fi;
    while((fi = it.current()) != 0) {
        if(!(fi->fileName() == ".") && !(fi->fileName() == "..")) {
            if(fi->isFile()) {
                return fi->absFilePath();
            } else if(fi->isDir()) {
                QString path = scanDirectoryForFile(fi->absFilePath());
                if(!path.isNull()) {
                    return path;
                }
            }
        }
        ++it;
    }
    return NULL;
}

void SubmountWatcher::release(QString device) {
    if(devicesKeptMounted.contains(device)) {
        devicesKeptMounted[device]->close();
        delete devicesKeptMounted[device];
        devicesKeptMounted.remove(device);
        msleep(5000);
    }
}

void SubmountWatcher::run()
{
    QFile f(MOUNTS);
    
    for(;;) {
        msleep(1000);
        if(stopCalled) { exit(); }
        if(paused || deviceMountpoints.empty()) { continue; }
        mutex.lock();
        
        if(!(f.exists() && f.open(IO_ReadOnly))) {
            // TRANSLATORS: %1 = filename
            MessageEvent* e = new MessageEvent(QString(_("Error: Could not read '%1'.\nPlease contact the prokyon3 developers\nbecause it seems that your submount implementation\nisn't supported by prokyon3 correctly")).arg(QString(MOUNTS)));
            QApplication::postEvent( gui, e );
            mutex.unlock();
            exit();
        }
        
        QTextStream t(&f);
        QString s;
        while(!t.eof()) {
            s = t.readLine();
            s = s.simplifyWhiteSpace();
            if(!s.isEmpty()) {
                QString devicename = s.left(s.find(' '));
                s = s.remove(0, s.find(' ') + 1);
                QString mountpoint = s.left(s.find(' '));
                s = s.remove(0, s.find(' ') + 1);
                QString filesystem = s.left(s.find(' '));
          
                if(deviceStates.contains(devicename) && deviceStates[devicename] != filesystem) {
                    deviceStates[devicename] = filesystem;
                    app->lock();
                    datadispatcher->eventDirHasChanged(deviceMountpoints[devicename]);
                    app->unlock();
                }
            }
        }
	
        f.close();
        mutex.unlock();
    }
}
