/***************************************************************************
                          mtabwatcher.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mtabwatcher.h"

#include "datadispatcher.h"

#include <qdir.h>

MtabWatcher::MtabWatcher() { stopCalled = false; }

void MtabWatcher::addDir(QString dir) {
  QFileInfo fi(dir);
  if(fi.exists()) lastChanged[dir] = fi.lastModified();
}

void MtabWatcher::stop() {
  stopCalled = true;
}

void MtabWatcher::pause() {
    paused = true;
}

void MtabWatcher::proceed() {
    paused = false;
}

void MtabWatcher::run()
{
  QFileInfo fi(MTAB);
  QDateTime mtabDate = fi.lastModified();

  for(;;) {
    msleep(1000);
    if(stopCalled) { exit(); }
    if(lastChanged.empty()) { continue; }
    mutex.lock();
    QFileInfo fi(MTAB);
    if(fi.lastModified() != mtabDate) {
      mtabDate = fi.lastModified();
      for(QMap<QString, QDateTime>::Iterator it = lastChanged.begin(); it != lastChanged.end(); ++it) {
	QString dir = it.key();
	QFileInfo fi(dir);
	if(fi.exists()) {
	  if(fi.lastModified() != lastChanged[dir]) {
	    lastChanged[dir] = fi.lastModified();
	    app->lock();
	    datadispatcher->eventDirHasChanged(dir);
	    app->unlock();
	  }
	}
      }
    }
    mutex.unlock();
  }
}
