/***************************************************************************
                           job_renamemedium->cpp  - ask the user for a new name 
                                                   and rename it in the database
                             -------------------
    begin                : 2004-10-08
    copyright            : (C) 2004 by Christian Mueller
    email                : cmbofh@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the license, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_renamemedium.h"

/* #include "job_disconnectfromdatabase.h" */

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#include "gui.h"

#include <qinputdialog.h>
#include <qmessagebox.h>

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_RenameMedium::Job_RenameMedium(MEDIUM *_medium)
  : medium(_medium)
{}

void Job_RenameMedium::run()
{
  int error = 0;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif

  if (verbose==8) qWarning("Renaming medium \" %s \" (%d)", medium->label.local8Bit().data(), medium->id);
  
  // ask for new media name
  bool ok = false, done = false;
  QString label = QString(_("Renaming Medium \"%1\". Please Enter the New CD Name:")).arg(medium->label);
  app->lock();
  do {
    medium->label = QInputDialog::getText(_("CD Identification"), label, QLineEdit::Normal, medium->label, &ok);
    if(ok) {
      done = (!medium->label.stripWhiteSpace().isEmpty() && !gui->getSourcer()->existsLabel(medium->label));
      if(!done) QMessageBox::information(gui, _("Message"), _("ID is empty / ID already exists!"), QMessageBox::Ok);
    } else {
      done = true;
    }
  } while(!done);
  app->unlock();
  
  if ( !medium->label ) {
    if (verbose==8) qWarning("Not changing medium name, got no new ID.");
  } else {
    medium->label = medium->label.stripWhiteSpace();
    if (verbose==8) qWarning("New medium name: \"%s\".", medium->label.local8Bit().data() );

    app->lock();
    datadispatcher->eventAddEditLock();
    app->unlock();

    database->lock();
    database->renameMedium(medium);
    error = database->getError();
    database->unlock();
  
    
    if(!error) {
      app->lock();

      datadispatcher->eventMediumRenamed(medium);
          
      datadispatcher->eventRemoveEditLock();
      
      app->unlock();
    }
  }
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_RenameMedium::~Job_RenameMedium() {}
