/***************************************************************************
                          gui_listing.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_LISTING_H
#define GUI_LISTING_H

#include "prokyon.h"

#include "extendedlistview.h"

#include "gui_searcher.h"
#include "gui_sql.h"
#ifdef HAVE_MIXXX
#include "gui_mixxxqueue.h"
#endif /* HAVE_MIXXX */
#include "gui_taglisting.h"

#include "lvi_track.h"

#include <qwidget.h>
#include <qframe.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qdragobject.h>

#include <qmap.h>
#include <qvaluevector.h>

class GUI_Listing : public QFrame  {
  Q_OBJECT
    public: 
  GUI_Listing(QWidget *parent=0, const char *name=0);
  
#ifdef HAVE_MIXXX
  void setMixxxConnectionState(bool state);
  void mixxxEnqueueAtChannel(bool selected, int channel);
#endif /* HAVE_MIXXX */
  
  void notifyMediumAvailabilityChanged(int id, QString path, bool state);
  void notifyNewMediumBasis(QList<MEDIUM> *list);
  void notifyNewTrackListing(QList<TRACK> *list);
  void notifyNewMedium(MEDIUM *medium);
  void notifyMediumRemoved(int id);
  void notifyMediumRenamed(MEDIUM *medium);

  void notifyFilenameHasChanged(int id, QString filename);

  void notifyMediumBusy(int id, bool status);

  void setEditMode(bool state);
  void clear();

  QListView*      list()          { return listing; }
  GUI_Searcher*   getSearcher()   { return searcher; }
  GUI_SQL*        getSQL()        { return sql; }
#ifdef HAVE_MIXXX
  GUI_MixxxQueue* getMixxxQueue() { return mixxxQueue; }
#endif /* HAVE_MIXXX */
  
  bool readInfo_lengthCheck()   { return info_lengthcheck->isChecked(); } 
  bool readInfo_bitrateCheck()  { return info_bitratecheck->isChecked(); } 
  bool readInfo_yearCheck()     { return info_yearcheck->isChecked(); } 
  bool readInfo_genreCheck()    { return info_genrecheck->isChecked(); } 
  bool readInfo_albumCheck()    { return info_albumcheck->isChecked(); } 
  bool readInfo_commentCheck()  { return info_commentcheck->isChecked(); } 
  bool readInfo_pathCheck()     { return info_pathcheck->isChecked(); } 
  bool readInfo_filenameCheck() { return info_filenamecheck->isChecked(); } 
  bool readInfo_mediaCheck()    { return info_mediacheck->isChecked(); } 
  bool readInfo_notesCheck()    { return info_notescheck->isChecked(); } 
  bool readInfo_ratingCheck()   { return info_ratingcheck->isChecked(); } 
  QStringList readColumnWidth();
  QStringList readColumnMap();

  int readInfo_radiostate() { return radioState; } 

  int getColumnMedium()   { return columnMedium; }
  int getColumnArtist()   { return columnArtist; }
  int getColumnTitle()    { return columnTitle; }
  int getColumnRating()   { return columnRating; }
  int getColumnLength()   { return columnLength; }
  int getColumnBitrate()  { return columnBitrate; }
  int getColumnAlbum()    { return columnAlbum; }
  int getColumnComment()  { return columnComment; }
  int getColumnYear()     { return columnYear; }
  int getColumnGenre()    { return columnGenre; }
  int getColumnPath()     { return columnPath; }
  int getColumnFilename() { return columnFilename; }
  int getColumnNotes()    { return columnNotes; }

  int getHeaderIndex( QString s);

  ~GUI_Listing();
  
 public slots:
  void slot_playWithXMMS(bool selected = true);
  void slot_enqueueInXMMS(bool selected = true);
  void slot_setConnectionState(bool state);
  
 private:
  void toggleColumn(int column, int state);
  void callRegularPlayer(bool selected, bool enqueue);
#ifdef HAVE_MIXXX
  void mixxxLoadAtChannel(int channel);
  void mixxxLoadAndPlayAtChannel(int channel);
#endif /* HAVE_MIXXX */
  
  int columnMedium;
  int columnArtist;
  int columnTitle;
  int columnRating;
  int columnLength;
  int columnBitrate;
  int columnAlbum;
  int columnComment;
  int columnYear;
  int columnGenre;
  int columnPath;
  int columnFilename;
  int columnNotes;
  
  ExtendedListView *listing;
  QList<LVI_Track>	listAll;

  QMap<int, QString> mapLabel;
  QMap<int, int>     mapType;
  QMap<int, bool>    mapAvail;
  QMap<int, QString> mapPath;

  QMap<int, bool>    busyMap;

  int radioState;
  QValueVector<int> widthes;
  
  GUI_Searcher *searcher;
  GUI_SQL *sql;

#ifdef HAVE_MIXXX
  GUI_MixxxQueue *mixxxQueue;
  bool isMixxxConnected;
  bool mixxxMode;
#endif /* HAVE_MIXXX */
  
  bool isConnected;
  bool editmode;
  
  QPushButton *button_All, *button_None, *button_Invert;
  QButtonGroup *selbox;
  QFrame *trackframe, *selectionframe;
  QTabWidget *tabbar;
  
  void sort();
  QString oldtip;

  QCheckBox *info_lengthcheck;
  QCheckBox *info_bitratecheck;
  QCheckBox *info_yearcheck;
  QCheckBox *info_genrecheck;
  QCheckBox *info_albumcheck;
  QCheckBox *info_commentcheck;
  QCheckBox *info_pathcheck;
  QCheckBox *info_filenamecheck;
  QCheckBox *info_mediacheck;
  QCheckBox *info_notescheck;
  QCheckBox *info_ratingcheck;

  int tabbarMinSize;
  int tabbarMaxSize;
  
  private slots:
  void slot_contextMenu(QListViewItem*, const QPoint&, int);
  void slot_deleteTrack();
  void slot_addToCurrent();
  void slot_addToPlaylist();

  void slot_selectionChanged();
  void slot_currentChanged(QListViewItem*);
  void slot_doubleClicked(QListViewItem*);
  void slot_selectionChanged2(int);
  
  void slot_selectionAll();
  void slot_selectionNone();
  void slot_selectionInvert();

  void slot_changeRadio(int);
  
  void slot_Length(int);
  void slot_Bitrate(int);
  void slot_Year(int);
  void slot_Genre(int);
  void slot_Album(int);
  void slot_Comment(int);
  void slot_Path(int);
  void slot_Filename(int);
  void slot_Media(int);
  void slot_Notes(int);
  void slot_Rating(int);

  void slot_mixxxLoadAtChannel1();
  void slot_mixxxLoadAtChannel2();
  void slot_mixxxLoadAndPlayAtChannel1();
  void slot_mixxxLoadAndPlayAtChannel2();
  void slot_mixxxEnqueueAtChannel1();
  void slot_mixxxEnqueueAtChannel2();
  
  void slot_tabChanged(QWidget *widget);
  void polish();
};

#endif
