/****************************************************************************
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
****************************************************************************/

#include "finddialog.h"

#include <qvariant.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qstatusbar.h>
#include <qtextbrowser.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qapplication.h>


void FindDialog::init()
{
    browser = 0;
    fromBegin = TRUE;
    firstRun = TRUE;
    onceFound = FALSE;
    findExpr = "";
    sb = new QStatusBar( this );
    FindDialogLayout->addWidget( sb );
    sb->message( _( "Enter the text you are looking for." ) );
}

void FindDialog::destroy()
{
}

void FindDialog::doFind()
{
    if ( !browser )
	return;
    sb->clear();
    if ( comboFind->currentText() != findExpr ) 
	onceFound = FALSE;
    findExpr = comboFind->currentText();
        
    int dummy = radioForward->isChecked() ? 0 : INT_MAX;
    if ( !fromBegin )
	fromBegin = !browser->find( findExpr, checkCase->isChecked(),
			checkWords->isChecked(), radioForward->isChecked() );
    else
	fromBegin = !browser->find( findExpr, checkCase->isChecked(),
			checkWords->isChecked(), radioForward->isChecked(), &dummy, &dummy );
    if ( fromBegin ) {
	QApplication::beep();
	if ( onceFound ) {
	    if ( radioForward->isChecked() )
		sb->message( _( "Search reached end of the document" ) );
	    else
		sb->message( _( "Search reached start of the document" ) );
	} else
	    sb->message( _( "Text not found" ) );  
    } else
	onceFound = TRUE;
}

void FindDialog::setBrowser( QTextBrowser * b )
{
    browser = b;
    fromBegin = TRUE;
}


/* 
 *  Constructs a FindDialog as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
FindDialog::FindDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )

{
    if ( !name )
	setName( "FindDialog" );
    FindDialogLayout = new QVBoxLayout( this, 0, 6, "FindDialogLayout"); 

    Layout5 = new QGridLayout( 0, 1, 1, 11, 6, "Layout5"); 

    ButtonGroup2 = new QButtonGroup( this, "ButtonGroup2" );
    ButtonGroup2->setColumnLayout(0, Qt::Vertical );
    ButtonGroup2->layout()->setSpacing( 6 );
    ButtonGroup2->layout()->setMargin( 11 );
    ButtonGroup2Layout = new QVBoxLayout( ButtonGroup2->layout() );
    ButtonGroup2Layout->setAlignment( Qt::AlignTop );

    radioForward = new QRadioButton( ButtonGroup2, "radioForward" );
    radioForward->setChecked( TRUE );
    ButtonGroup2Layout->addWidget( radioForward );

    radioBackward = new QRadioButton( ButtonGroup2, "radioBackward" );
    ButtonGroup2Layout->addWidget( radioBackward );

    Layout5->addMultiCellWidget( ButtonGroup2, 1, 2, 1, 1 );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1"); 

    TextLabel1 = new QLabel( this, "TextLabel1" );
    Layout1->addWidget( TextLabel1 );

    comboFind = new QComboBox( FALSE, this, "comboFind" );
    comboFind->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, comboFind->sizePolicy().hasHeightForWidth() ) );
    comboFind->setEditable( TRUE );
    comboFind->setDuplicatesEnabled( FALSE );
    Layout1->addWidget( comboFind );

    Layout5->addMultiCellLayout( Layout1, 0, 0, 0, 1 );
    QSpacerItem* spacer = new QSpacerItem( 31, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout5->addItem( spacer, 2, 2 );

    PushButton2 = new QPushButton( this, "PushButton2" );

    Layout5->addWidget( PushButton2, 1, 2 );

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 6 );
    ButtonGroup1->layout()->setMargin( 11 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );

    checkWords = new QCheckBox( ButtonGroup1, "checkWords" );
    ButtonGroup1Layout->addWidget( checkWords );

    checkCase = new QCheckBox( ButtonGroup1, "checkCase" );
    ButtonGroup1Layout->addWidget( checkCase );

    Layout5->addMultiCellWidget( ButtonGroup1, 1, 2, 0, 0 );

    PushButton1 = new QPushButton( this, "PushButton1" );
    PushButton1->setDefault( TRUE );

    Layout5->addWidget( PushButton1, 0, 2 );
    FindDialogLayout->addLayout( Layout5 );
    languageChange();
    resize( QSize(362, 153).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( PushButton1, SIGNAL( clicked() ), this, SLOT( doFind() ) );
    connect( PushButton2, SIGNAL( clicked() ), this, SLOT( reject() ) );

    // tab order
    setTabOrder( comboFind, checkWords );
    setTabOrder( checkWords, checkCase );
    setTabOrder( checkCase, radioForward );
    setTabOrder( radioForward, radioBackward );
    setTabOrder( radioBackward, PushButton1 );
    setTabOrder( PushButton1, PushButton2 );

    // buddies
    TextLabel1->setBuddy( comboFind );
    init();
}

/*
 *  Destroys the object and frees any allocated resources
 */
FindDialog::~FindDialog()
{
    destroy();
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void FindDialog::languageChange()
{
    setCaption( _( "Qt Assistant - Find Text" ) );
    ButtonGroup2->setTitle( _( "&Direction" ) );
    radioForward->setText( _( "Forwar&d" ) );
    radioBackward->setText( _( "&Backward" ) );
    TextLabel1->setText( _( "&Find:" ) );
    PushButton2->setText( _( "Close" ) );
    ButtonGroup1->setTitle( _( "&Options" ) );
    checkWords->setText( _( "&Whole words only" ) );
    checkCase->setText( _( "&Case sensitive" ) );
    PushButton1->setText( _( "&Find" ) );
}

