/***************************************************************************
                          extendedlistview.cpp  -  description
                             -------------------
    begin                : Sam Jan 11 2003
    copyright            : (C) 2003 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extendedlistview.h"

#include "lvi_track.h"
#include "gui_listing.h"

// ##############################################
// # initialize listing gui
// ##############################################
ExtendedListView::ExtendedListView(QWidget *parent, const char *name)
  : QListView(parent, name)
{}

QDragObject *ExtendedListView::dragObject()
{
    QStrList urls;
    for (QListViewItem *item = firstChild(); item != 0; item = item->nextSibling()) {
        if (item->isSelected() && dynamic_cast<LVI_Track*>(item)->getIsAvailable()) {
            QString filename = dynamic_cast<LVI_Track*>(item)->getPath() + "/" + dynamic_cast<LVI_Track*>(item)->getFilename();
            urls.append(QUriDrag::localFileToUri(filename.stripWhiteSpace()));
        }
    }
    return new QUriDrag(urls, this);
}

