/***************************************************************************
                    configuration_dialog.h  -  description
                             -------------------
    begin                : Sat Feb 9 2001
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGURATION_DIALOG_H
#define CONFIGURATION_DIALOG_H

#include "prokyon.h"

#include <qtabdialog.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qcombobox.h>

class Configuration_Dialog : public QTabDialog {
    Q_OBJECT
friend class Configuration;
public: 
	Configuration_Dialog(QWidget *parent, const char *name=0);
	~Configuration_Dialog();
private:
    QLineEdit *db_host_line, *db_database_line, *db_user_line, *db_pass_line;
#ifdef EMBEDDED
    QLineEdit *embedded_basedir_line, *embedded_language_line;
#endif /* EMBEDDED */
    QLineEdit *burnCD_line, *k3b_line; 
    QLabel *l1, *l2;
#ifdef HAVE_MIXXX
    QLabel *lmixxxhost, *lmixxxport;
    QLineEdit *mixxxhost_line, *mixxxport_line;
    QCheckBox *enableRegularPlayer, *enableMixxxPlayer;
#endif /* HAVE_MIXXX */
#ifdef HAVE_LIBMUSICBRAINZ
    QLineEdit *musicBrainzServer_line, *musicBrainzPort_line;
#endif /* HAVE_LIBMUSICBRAINZ */
    QLineEdit *smbKeywords_line, *nfsKeywords_line;
    QComboBox *play_line, *enqueue_line, *comboSortingMode;
    QCheckBox *readv2check, *writev2check, *autocheck, *hidecheck, *hddcheck;
    QCheckBox *smbcheck, *nfscheck;
    QCheckBox *showtooltip, *maxwidthmode, *guirestore;
    QLineEdit *customrename_line;
#ifdef HAVE_MEXTRAS
    QCheckBox *mextras_bgnd;
#endif /* HAVE_MEXTRAS */
    QCheckBox *checkartist, *checkcover, *checklyrics, *checkalbum;
    QCheckBox *checktracks, *checkbiography, *checkyears;
    QListView *hddlist;
    QSpinBox *mexspinbox;
    QPushButton *hddedit, *hddremove;
    QCheckBox *comboSortingAuto;
private slots:
    void slot_clickenableRegularPlayer();
    void slot_clickenableMixxxPlayer();
    void slot_selectionChanged();
    void slot_hddadd();
    void slot_hddremove();
    void slot_hddedit();
};

#endif
