------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--             P O L Y O R B . C O R B A _ P . O R B _ I N I T              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2004-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines procedures to register call backs functions
--  to be called when initializing an ORB object.

package PolyORB.CORBA_P.ORB_Init is

   type ORB_Init_Suffix_Type is
     access function (Value : String) return Boolean;

   procedure Register
     (Suffix : String;
      ORB_Init_Suffix : ORB_Init_Suffix_Type);
   --  Attach ORB_Init_Suffix initialization routine to Suffix

   function Initialize (Suffix : String; Value : String) return Boolean;
   --  Initialize Suffix with Value. Return True if the initialisation
   --  was succesful, else return False.

   function Initialize (Value : String) return Boolean;
   --  If the N first characters of Value matches one registered
   --  suffix, run the corresponding initialization routine, else
   --  return false.

end PolyORB.CORBA_P.ORB_Init;
