/* $Id: cpu_arch_def.h 1369 2005-01-26 17:19:10Z mipsator $ */

/*
 * Copyright (c) 2004 Damien Couderc
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *    - Neither the name of the copyright holder(s) nor the names of its
 *      contributors may be used to endorse or promote products derived
 *      from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef _CPU_ARCH_DEF_
#define _CPU_ARCH_DEF_

/* check x86 32 bits architecture */
#if defined(i386) || defined(__i386) || defined(__i386__)
#define ARCH_X86_32	1
#endif

/* check x86 64 bits architecture */
#if defined(__AMD64__) || defined(AMD64) || \
	defined(__amd64__) || defined(__x86_64__)
#define ARCH_X86_64	1
#endif

/* check alpha architecture */
#if defined(__alpha__) || defined(__alpha) || \
	defined(__ALPHA)
#define ARCH_ALPHA	1
#endif

/* check ia64 architecture */
#if defined(__ia64__) || defined(__IA64__) || \
	defined(_IA64) || defined(_M_IA64)
#define ARCH_IA64	1
#endif

#endif /* _CPU_ARCH_DEF_ */

