/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  misc-nexus.c: deals with unmapped and miscellaneous IO ports.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"


  Bit32u
miscIORead(vm_t *vm, Bit32u port, unsigned len)
{
  switch (port) {
    case 0x80:
      return( vm->misc.s.port80 );
    default:
      monpanic(vm, "miscIORead: port=0x%x\n", port);
    }
}

  void
miscIOWrite(vm_t *vm, Bit32u port, Bit32u dvalue, unsigned len)
{
  switch (port) {
    case 0x80:
      vm->misc.s.port80 = dvalue;
      break;
    default:
      monpanic(vm, "miscIOWrite: port=0x%x, val=0x%x\n", port, dvalue);
    }
}
