/*  Copyright (C) 2000-2001  MandrakeSoft S.A.
 *
 *    MandrakeSoft S.A.
 *    43, rue d'Aboukir
 *    75002 Paris - France
 *    http://www.linux-mandrake.com/
 *    http://www.mandrakesoft.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */



#ifndef __PIT_H__
#define __PIT_H__


#define BX_PIT_LATCH_MODE_LSB   10
#define BX_PIT_LATCH_MODE_MSB   11
#define BX_PIT_LATCH_MODE_16BIT 12

#define PitPeriodicDelta 100

#ifdef OUT
#  undef OUT
#endif


typedef struct {
  Bit8u      mode;
  Bit8u      latch_mode;
  Bit16u     input_latch_value;
  Boolean    input_latch_toggle;
  Bit16u     output_latch_value;
  Boolean    output_latch_toggle;
  Boolean    output_latch_full;
  Bit16u     counter_max;
  Bit16u     counter;
  Boolean    bcd_mode;
  Boolean    active;
  Boolean    GATE;     // GATE input  pin
  Boolean    OUT;      // OUT  output pin
  } onePit_t;




typedef struct {
  struct {
    onePit_t timer[3];
    Bit8u   speaker_data_on;
    Boolean refresh_clock_div2;
    } s;
  } pit_t;

#endif  /* #ifndef __PIT_H__ */
