/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */



#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <signal.h>

#include "codegen.h"


Bit8u *
dtGenRet(Bit8u * tcodePtr)
{
  Bit32u *r3hBranchPtr;

  /* Emit code */
#if DT_UseR3hStack
  tcodePtr = dtEmitUseR3hESP(tcodePtr);
#endif
  tcodePtr = dtEmitJmp(tcodePtr, &r3hBranchPtr);

  /* Emit relocation record */
  reloc[relocN].tcodePtr = r3hBranchPtr;
  reloc[relocN].tcodeOff = (Bit32u) __r3h_ret;
  relocN++;

  return tcodePtr;
}


Bit8u *
dtGenJmpEcx4(Bit8u * tcodePtr, Bit32u targetOffset32)
{
  Bit32u *r3hBranchPtr;

  /* +++ specific hack for following instruction: */
  /* jmp *table(,%eax,4) */

  /* Emit code */
#if DT_UseR3hStack
  tcodePtr = dtEmitUseR3hESP(tcodePtr);
#endif

  *tcodePtr++ = 0xff;   /* pushl table(,%ecx,4) */
  *tcodePtr++ = 0x34;
  *tcodePtr++ = 0x8d;
  *(Bit32u *) tcodePtr = targetOffset32;
  tcodePtr += 4;

  tcodePtr = dtEmitCall(tcodePtr, &r3hBranchPtr);

  /* Emit relocation record */
  reloc[relocN].tcodePtr = r3hBranchPtr;
  reloc[relocN].tcodeOff = (Bit32u) __r3h_branch_dynamic;
  relocN++;

  return tcodePtr;
}
