#include "dt.h"


/* memory representing two arbitrary guest pages */
asm (
  ".comm   guest_page0,4096,4096 \n\t"
  ".comm   guest_page1,4096,4096 \n\t"
  );

Bit8u guest_stack[GUEST_STACK_SIZE];

Bit32u loop_count;

/* Put some instructions in the guest pages, so we have something
   to work with.
 */

  void
hack_guest_code(void)
{
  unsigned i;
  unsigned char *gp0, *gp1;
  Bit32s displacement;

  loop_count = DT_LOOP_COUNT;

  gp0 = &guest_page0[0];
  gp1 = &guest_page1[0];

  /* Weave some code back and forth between pages to test the
   * branch handler.
   */
  for (i=0; i<20; i++) {
    *gp0++ = 0x90; /* NOP */
    *gp0++ = 0xe9; /* JMP_Jd */
    displacement = ((Bit32u) gp1) - (((Bit32u)gp0)+4);
    *(Bit32u*)gp0 = displacement;
    gp0 += 4;

    *gp1++ = 0x90; /* NOP */
    *gp1++ = 0xe9; /* JMP_Jd */
    displacement = ((Bit32u) gp0) - (((Bit32u)gp1)+4);
    *(Bit32u*)gp1 = displacement;
    gp1 += 4;
    }

  /* Now, loop back to beginning of code until terminal condition
     is met.
   */
  *gp0++ = 0xff; /* DEC loop_count */
  *gp0++ = 0x0d;
  *(Bit32u*)gp0 = (Bit32u) &loop_count;
  gp0 += 4;

  *gp0++ = 0x0f; /* JNZ &guest_page0[0] */
  *gp0++ = 0x85;
  displacement = ((Bit32u) &guest_page0[0]) - (((Bit32u)gp0)+4);
  *(Bit32u*)gp0 = displacement;
  gp0 += 4;

  *gp0++ = 0xc3; /* RET */
}

asm (
  ".globl __execute_guest_code_native \n\t"
  "__execute_guest_code_native:\n\t"
  "  pushal \n\t"
  "  pushfl \n\t"
  "  call guest_page0 \n\t"
  "  popfl  \n\t"
  "  popal  \n\t"
  "  ret \n\t"
  );
