/* this handles all file IO, it is written to be as portable as I could make it
 */

#include	"includes.h"

/* error family, members and descriptions for those errors
 * generated here
 */

#define	LF		10
#define	CR		13



FILE *OpenReadFile(char *fname,int bufferSize)
/* passed a pointer to a file name, open a file for reading (in untranslated mode)
 * return a FILE, or NULL if there was an error
 * If NULL is returned, GetError can be called to determine what went wrong
 */
{
FILE
	*theFile;

	if( (theFile=(FILE *)fopen(fname,"r")) )				/* open the file */
		{
		if(bufferSize)
			{
			if(setvbuf(theFile,NULL,_IOFBF,bufferSize)!=0)
				{
				SetStdCLibError();						/* set high level error information */
				fclose(theFile);						/* could not set buf for the file, so close it and complain */
				theFile=(FILE *)NULL;
				}
			}
		else
			{
			if(setvbuf(theFile,NULL,_IONBF,0)!=0)
				{
				SetStdCLibError();						/* set high level error information */
				fclose(theFile);						/* could not set buf for the file, so close it and complain */
				theFile=(FILE *)NULL;
				}
			}
		}
	else
		{
		SetStdCLibError();								/* set high level error information */
		}
	return(theFile);
}

FILE *OpenWriteFile(char *fname,int bufferSize)
/* passed a pointer to a file name, open a file for writing (untranslated mode)
 * return a FILE, or null if there was an error
 * If NULL is returned, GetError can be called to determine what went wrong
 */
{
FILE
	*theFile;

	if( (theFile=(FILE *)fopen(fname,"w")) )				/* open the file */
		{
		if(bufferSize)
			{
			if(setvbuf(theFile,NULL,_IOFBF,bufferSize)!=0)
				{
				SetStdCLibError();						/* set high level error information */
				fclose(theFile);						/* could not set buf for the file, so close it and complain */
				theFile=(FILE *)NULL;
				}
			}
		else
			{
			if(setvbuf(theFile,NULL,_IONBF,0)!=0)
				{
				SetStdCLibError();						/* set high level error information */
				fclose(theFile);						/* could not set buf for the file, so close it and complain */
				theFile=(FILE *)NULL;
				}
			}
		}
	else
		{
		SetStdCLibError();								/* set high level error information */
		}
	return(theFile);
}


bool CloseFile(FILE *fp)
/* passed a pointer to a file, close it
 * return false if there is a problem
 * If false is returned, GetError can be called to determine what went wrong
 */
{
	fclose(fp);												/* get rid of the file */
	return(true);
}


bool ReadFile(FILE *fp,UBYTE *dest,ULONG count,ULONG *numRead)
/* passed a pointer to an open file, extract a string of bytes from the file
 * and return it at dest
 * fill numRead with the actual number of bytes read
 * pass back a bool that tells if all was well during read
 * it will be false for a read error
 * If false is returned, GetError can be called to determine what went wrong
 * it is allowed to attempt to read past the end of file, numRead will just
 * return less than count.
 */
{
int
	numToRead,numJustRead;
bool
	fail,done;

	(*numRead)=0;							/* no bytes read so far */
	fail=done=false;
	while(!done&&count)
		{
		numToRead=Min(count,INT_MAX);		/* dont pass an int that is too big */
		if((numJustRead=fread(&(dest[(*numRead)]),1,numToRead,fp))!=numToRead)
			{
			done=true;						/* no matter what, we are done now */
			if(ferror(fp))					/* if there was an error, report it */
				{
				SetStdCLibError();			/* set high level error information */
				fail=true;
				}
			}
		(*numRead)+=(ULONG)numJustRead;		/* add in amount just read */
		count-=(ULONG)numJustRead;			/* this many less bytes to go */
		}
	return(!fail);
}

bool WriteFile(FILE *fp,UBYTE *src,ULONG count,ULONG *numWritten)
/* passed a pointer to an open file, send the string of bytes given
 * out to it. If there is an error, return false
 * If false is returned, GetError can be called to determine what went wrong
 */
{
int
	numToWrite,numJustWritten;
bool
	fail;

	(*numWritten)=0;							/* no bytes written so far */
	fail=false;
	while(!fail&&count)
		{
		numToWrite=Min(count,INT_MAX);			/* dont pass an int that is too big */
		if((numJustWritten=fwrite(&(src[(*numWritten)]),1,numToWrite,fp))!=numToWrite)
			{
			SetStdCLibError();					/* set high level error information */
			fail=true;							/* no matter what, we have failed now */
			}
		(*numWritten)+=(ULONG)numJustWritten;	/* add in amount just written */
		count-=(ULONG)numJustWritten;			/* this many less bytes to go */
		}
	return(!fail);
}

bool GetLine(FILE *theFile,char *line,int lineLength,bool *atEOF,bool *overFlow)
/* read a line from the given file into the array line
 * if there is a read error, return false
 * lineLength is considered to be the maximum number of characters
 * to read into the line (including the 0 terminator)
 * if the line fills before a CR is hit, overFlow will be set true, and the rest of the
 * line will be read, but not stored
 * if the EOF is hit, atEOF is set true
 */ 
{
int
	i;
UBYTE
	c;
bool
	hadError;
ULONG
	numRead;
bool
	stopReading;

	i=0;												/* index into output line */
	stopReading=hadError=(*atEOF)=(*overFlow)=false;	
	while(!stopReading)
		{
		if(ReadFile(theFile,&c,(ULONG)1,&numRead))	/* get character from input */
			{
			if(numRead)								/* if something was read, check it, and add to output line */
				{
				if(c=='\n'||c=='\0')				/* found termination? */
					{
					stopReading=true;				/* yes, output line is complete */
					}
				else
					{
					if(c!=LF&&c!=CR)				/* see if the character should be added to the line */
						{
						if(i<lineLength-1)			/* make sure there is room to store it */
							{
							line[i++]=c;			/* store it if there is room */
							}
						else
							{
							(*overFlow)=true;		/* complain of overflow, but continue to the end */
							}
						}
					}
				}
			else
				{
				stopReading=true;
				(*atEOF)=true;						/* tell caller that EOF was encountered */
				}
			}
		else
			{
			stopReading=true;
			hadError=true;
			}
		}
	if(lineLength)
		{
		line[i]='\0';									/* terminate the line if possible */
		}
	return(!hadError);									/* return error status */
}

