/* Error handling routines, and global structures
 * 12/16/1990 TMS
 */

#include	"includes.h"

extern int
	errno;

static char
	xErrorFamily[MAXERRORFAMILY+1];				/* name of the family in which the error occured */
static char
	xFamilyMember[MAXERRORFAMILY+1];			/* the member of the error family */
static char
	xMemberDescription[MAXERRORDESCRIPTION+1];	/* the description of the member */

void SetError(char *errorFamily,char *familyMember,char *memberDescription)
/* Set the current global error to the given error information.
 * It is allowed for anyone to call this routine at any level to send back
 * error information.
 * errorFamily, and familyMember must be MAXERRORFAMILY characters long at most,
 * and description is limited to MAXERRORDESCRIPTION characters in length.
 * If the input strings exceed this length, they will be truncated.
 */
{
	strncpy(&xErrorFamily[0],errorFamily,MAXERRORFAMILY);	/* leave room for null terminator */
	xErrorFamily[MAXERRORFAMILY]='\0';						/* terminate if strncpy could not */
	strncpy(&xFamilyMember[0],familyMember,MAXERRORFAMILY);	/* leave room for null terminator */
	xFamilyMember[MAXERRORFAMILY]='\0';						/* terminate if strncpy could not */
	strncpy(&xMemberDescription[0],memberDescription,MAXERRORDESCRIPTION);	/* leave room for null terminator */
	xMemberDescription[MAXERRORDESCRIPTION]='\0';			/* terminate if strncpy could not */
}

void SetStdCLibError()
/* When an error occurs within a standard C library function, call this
 * and it will turn the standard C library information into an extended library
 * error
 */
{
char
	tempString[256];									/* need a place to sprintf info */

	sprintf(&tempString[0],"#%d",errno);				/* place the error number into the temp space */
	SetError("StdCLib",&tempString[0],(char *)sys_errlist[errno]);
}

void GetError(char **errorFamily,char **familyMember,char **memberDescription)
/* Return pointers to the last globally kept error information.
 * If no information is present, pointers to empty strings will be returned.
 */
{
	*errorFamily=&xErrorFamily[0];
	*familyMember=&xFamilyMember[0];
	*memberDescription=&xMemberDescription[0];
}

bool InitErrors()
/* Initialize the error handling code.
 * If there is a problem return false.
 * If false is returned, it is NOT legal to call GetError to find out what failed,
 * You just have to report that the initialization failed.
 */
{
	xErrorFamily[0]='\0';
	xFamilyMember[0]='\0';
	xMemberDescription[0]='\0';
	return(true);
}

void UnInitErrors()
/* Undo whatever InitErrors did.
 */
{
}
