(** Wrapper around Perl [Net::Google::Spelling] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_Net_Google_Spelling.ml,v 1.3 2003/10/16 13:41:07 rich Exp $
  *)

open Perl

let _ = eval "use Net::Google::Spelling"

class net_google_spelling sv =

object (self)

  method key =
    string_of_sv (call_method sv "key" [])
  method set_key v =
    call_method_void sv "key" [sv_of_string v]
  method phrase phrases =
    string_of_sv (call_method sv "phrase" (List.map sv_of_string phrases))
  method suggest =
    string_of_sv (call_method sv "suggest" [])

end

(* let new_ = ... *)
