(** Wrapper around Perl [HTTP::Response] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTTP_Response.ml,v 1.4 2005/01/13 16:06:04 rich Exp $
  *)

open Perl

open Pl_HTTP_Message
open Pl_HTTP_Request

let _ = eval "use HTTP::Response"

class http_response sv =

object (self)
  inherit http_message sv

  method code =
    string_of_sv (call_method sv "code" [])
  method set_code code =
    call_method_void sv "code" [sv_of_string code]
  method message =
    string_of_sv (call_method sv "message" [])
  method set_message message =
    call_method_void sv "message" [sv_of_string message]
  method request =
    new http_request (call_method sv "request" [])
  method set_request (req : http_request) =
    call_method_void sv "request" [req#sv]
  method status_line =
    string_of_sv (call_method sv "status_line" [])
  method base =
    string_of_sv (call_method sv "base" [])
  method as_string =
    string_of_sv (call_method sv "as_string" [])
  method is_info =
    bool_of_sv (call_method sv "is_info" [])
  method is_success =
    bool_of_sv (call_method sv "is_success" [])
  method is_redirect =
    bool_of_sv (call_method sv "is_redirect" [])
  method is_error =
    bool_of_sv (call_method sv "is_error" [])
  method error_as_HTML =
    string_of_sv (call_method sv "error_as_HTML" [])

end

(* let new_ ... *)
