/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2, Imlib >= 1.9.2 !!!!                                  *
 * Modul:     paulload.c                                                     *
 *            strongly modified load.c from gdk_imlib (version 1.9.2)        *
 *            new: at_imlib_set_image_from_data() (modified                  *
 *            imlib_create_image_from_data())                                *
 *            Requires Imlib-Version >= 1.9.2 !!!!!                          *
 * Autor:     Andreas Tille                                                  *
 * Datum:     19.03.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <sys/param.h>

#include "paul.h"

#define HAVE_LIBJPEG
#define HAVE_LIBGIF
#define id _gdk_imlib_data
#include <gdk_imlib_private.h>

PICTURE *LoadPicture(PICTURE *bild, char *file, long flag)
{
  int            w, h, trans, read_anything;
  unsigned char *data = NULL;
  char          *sp, *filename;
  FILE          *p = NULL;

  if ( !CheckFile(file) ) return NULL;
  g_return_val_if_fail ( (p = fopen(file, "rb")), NULL ) ;

  filename = g_strdup(file);
  if ( (sp = strrchr(file, '.')) ) {
    *(sp++) = 0;
    bild->ext = g_strdup(sp);
  } else 
    bild->ext = NULL;
   
  if ( (sp = strrchr(file, '/')) ) {
    *(sp++) = 0;
    bild->file = g_strdup(sp);
    bild->dir  = g_strdup(file);
  } else {
    bild->file = g_strdup(file);
    if ( (sp = g_get_current_dir()) ) {
      bild->dir = g_strdup(sp);
      FREE(sp);
    } else
      bild->dir = NULL;
  }
   
  trans = 0;
  if ( _gdk_imlib_ispng(p) ) {
    w = PaulLoadPNG(bild, p, flag, &read_anything);

    if ( !OnlyInfo(flag) && read_anything != bild->H ) 
      g_warning(_("Only %i rows of %i could be read from file %s."), read_anything, bild->H, bild->file);
      
    if ( w == RET_OK || read_anything > 0 ) {
      fclose(p);
      return bild;
    }
    g_warning(_("File %s seems not to be a PNG file.  Trying convert.  Special info would be lost."), 
              bild->file);
    fseek(p, 0L, SEEK_SET);
  }
  else if ( _gdk_imlib_istiff(p) && !PaulLoadTIFF(bild, p, bild->file, flag) )  {
    fclose(p);
    return bild;
  }
  else if ( _gdk_imlib_isgif(p) ) data = (*_gdk_imlib_LoadGIF)(p, &w, &h, &trans);
  else if ( _gdk_imlib_isxpm(p) ) {
    if ( !id ) {
     /*  g_LoadXPM() requires a valid internal imlib structure!!        *
      *  This will be simulated by the folowing code                    *
      *  It is enourmous dangerous to do such undocumented stuff!!!!!!  */
       XWindowAttributes   xwa;

       id = g_new(ImlibData, 1);

       if ( gdk_display ) id->x.disp = gdk_display;
       else               id->x.disp = XOpenDisplay(NULL);;
       id->x.root_cmap = 0;
       if ( XGetWindowAttributes(id->x.disp, DefaultRootWindow(id->x.disp), &xwa) && xwa.colormap )
         id->x.root_cmap = xwa.colormap;

       data = (*_gdk_imlib_LoadXPM)(p, &w, &h, &trans);
       if ( !gdk_display ) XCloseDisplay(id->x.disp);
       FREE(id);
    } else
       data = (*_gdk_imlib_LoadXPM)(p, &w, &h, &trans);
  }
  else if ( _gdk_imlib_isbmp(p) ) data = (*_gdk_imlib_LoadBMP)(p, &w, &h, &trans);
  else if ( _gdk_imlib_isjpeg(p)) data = (*_gdk_imlib_LoadJPEG)(p, &w, &h, &trans);
  else if ( _gdk_imlib_ispnm(p) ) data = (*_gdk_imlib_LoadPPM)(p, &w, &h, &trans);

  fclose(p);
  if (!data && (p = _gdk_imlib_open_helper("%C/convert %s pnm:-", filename, "rb")) ) {
     data = (*_gdk_imlib_LoadPPM)(p, &w, &h, &trans);
     _gdk_imlib_close_helper(p);
  }

  if ( !data ) {
    g_warning(_("Cannot load image: %s\nAll fallbacks failed."), file);
    FREE(filename);
    FREE(bild->file);
    return NULL;
  }
  bild->DATA = data;
  bild->size = (bild->W = w) * (bild->H = h);
   
  GetPictureSpecs(bild, filename);
  FREE(filename);

  return bild;
}


GdkImlibImage *at_imlib_set_image_from_data(unsigned char **data, gint w, gint h)
{
  GdkImlibImage *im;
    
  g_return_val_if_fail ( (im = gdk_imlib_create_image_from_data(*data, NULL, w, h)), NULL );
  FREE(*data);
  *data = im->rgb_data;
  
  return im;
}
