/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <Line.h>
#include <DataNode.h>

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Init utility for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void Line::Init()
{
    point1[0] = 0;
    point1[1] = 0;
    point1[2] = 0;
    point2[0] = 1;
    point2[1] = 1;
    point2[2] = 1;
    lineStyle = 0;
    lineWidth = 0;
    interactive = false;
    reflineLabels = false;
    varName = "default";
    samplingOn = false;
    numSamples = 50;

    Line::SelectAll();
}

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Copy utility for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void Line::Copy(const Line &obj)
{
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    designator = obj.designator;
    color = obj.color;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    interactive = obj.interactive;
    reflineLabels = obj.reflineLabels;
    varName = obj.varName;
    samplingOn = obj.samplingOn;
    numSamples = obj.numSamples;

    Line::SelectAll();
}

// Type map format string
const char *Line::TypeMapFormatString = LINE_TMFS;
const AttributeGroup::private_tmfs_t Line::TmfsStruct = {LINE_TMFS};


// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Default constructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line::Line() : 
    AttributeSubject(Line::TypeMapFormatString),
    color(0, 0, 0)
{
    Line::Init();
}

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Constructor for the derived classes of Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line::Line(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    color(0, 0, 0)
{
    Line::Init();
}

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Copy constructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line::Line(const Line &obj) : 
    AttributeSubject(Line::TypeMapFormatString)
{
    Line::Copy(obj);
}

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Copy constructor for derived classes of the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line::Line(const Line &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    Line::Copy(obj);
}

// ****************************************************************************
// Method: Line::~Line
//
// Purpose: 
//   Destructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line::~Line()
{
    // nothing here
}

// ****************************************************************************
// Method: Line::operator = 
//
// Purpose: 
//   Assignment operator for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Line& 
Line::operator = (const Line &obj)
{
    if (this == &obj) return *this;

    Line::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: Line::operator == 
//
// Purpose: 
//   Comparison operator == for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Line::operator == (const Line &obj) const
{
    // Compare the point1 arrays.
    bool point1_equal = true;
    for(int i = 0; i < 3 && point1_equal; ++i)
        point1_equal = (point1[i] == obj.point1[i]);

    // Compare the point2 arrays.
    bool point2_equal = true;
    for(int i = 0; i < 3 && point2_equal; ++i)
        point2_equal = (point2[i] == obj.point2[i]);

    // Create the return value
    return (point1_equal &&
            point2_equal &&
            (designator == obj.designator) &&
            (color == obj.color) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (interactive == obj.interactive) &&
            (reflineLabels == obj.reflineLabels) &&
            (varName == obj.varName) &&
            (samplingOn == obj.samplingOn) &&
            (numSamples == obj.numSamples));
}

// ****************************************************************************
// Method: Line::operator != 
//
// Purpose: 
//   Comparison operator != for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Line::operator != (const Line &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Line::TypeName
//
// Purpose: 
//   Type name method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
Line::TypeName() const
{
    return "Line";
}

// ****************************************************************************
// Method: Line::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Line::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Line *tmp = (const Line *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Line::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Line::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Line(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Line::NewInstance
//
// Purpose: 
//   NewInstance method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Line::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Line(*this);
    else
        retval = new Line;

    return retval;
}

// ****************************************************************************
// Method: Line::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Line::SelectAll()
{
    Select(ID_point1,        (void *)point1, 3);
    Select(ID_point2,        (void *)point2, 3);
    Select(ID_designator,    (void *)&designator);
    Select(ID_color,         (void *)&color);
    Select(ID_lineStyle,     (void *)&lineStyle);
    Select(ID_lineWidth,     (void *)&lineWidth);
    Select(ID_interactive,   (void *)&interactive);
    Select(ID_reflineLabels, (void *)&reflineLabels);
    Select(ID_varName,       (void *)&varName);
    Select(ID_samplingOn,    (void *)&samplingOn);
    Select(ID_numSamples,    (void *)&numSamples);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Line::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Line::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    Line defaultObject;
    bool addToParent = false;
    // Create a node for Line.
    DataNode *node = new DataNode("Line");

    if(completeSave || !FieldsEqual(ID_point1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point1", point1, 3));
    }

    if(completeSave || !FieldsEqual(ID_point2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point2", point2, 3));
    }

    if(completeSave || !FieldsEqual(ID_designator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(ID_lineStyle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(ID_interactive, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }

    if(completeSave || !FieldsEqual(ID_reflineLabels, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("reflineLabels", reflineLabels));
    }

    if(completeSave || !FieldsEqual(ID_varName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("varName", varName));
    }

    if(completeSave || !FieldsEqual(ID_samplingOn, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplingOn", samplingOn));
    }

    if(completeSave || !FieldsEqual(ID_numSamples, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numSamples", numSamples));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: Line::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Line::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("Line");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("point1")) != 0)
        SetPoint1(node->AsDoubleArray());
    if((node = searchNode->GetNode("point2")) != 0)
        SetPoint2(node->AsDoubleArray());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
    if((node = searchNode->GetNode("reflineLabels")) != 0)
        SetReflineLabels(node->AsBool());
    if((node = searchNode->GetNode("varName")) != 0)
        SetVarName(node->AsString());
    if((node = searchNode->GetNode("samplingOn")) != 0)
        SetSamplingOn(node->AsBool());
    if((node = searchNode->GetNode("numSamples")) != 0)
        SetNumSamples(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Line::SetPoint1(const double *point1_)
{
    point1[0] = point1_[0];
    point1[1] = point1_[1];
    point1[2] = point1_[2];
    Select(ID_point1, (void *)point1, 3);
}

void
Line::SetPoint2(const double *point2_)
{
    point2[0] = point2_[0];
    point2[1] = point2_[1];
    point2[2] = point2_[2];
    Select(ID_point2, (void *)point2, 3);
}

void
Line::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(ID_designator, (void *)&designator);
}

void
Line::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(ID_color, (void *)&color);
}

void
Line::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(ID_lineStyle, (void *)&lineStyle);
}

void
Line::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
Line::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(ID_interactive, (void *)&interactive);
}

void
Line::SetReflineLabels(bool reflineLabels_)
{
    reflineLabels = reflineLabels_;
    Select(ID_reflineLabels, (void *)&reflineLabels);
}

void
Line::SetVarName(const std::string &varName_)
{
    varName = varName_;
    Select(ID_varName, (void *)&varName);
}

void
Line::SetSamplingOn(bool samplingOn_)
{
    samplingOn = samplingOn_;
    Select(ID_samplingOn, (void *)&samplingOn);
}

void
Line::SetNumSamples(int numSamples_)
{
    numSamples = numSamples_;
    Select(ID_numSamples, (void *)&numSamples);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
Line::GetPoint1() const
{
    return point1;
}

double *
Line::GetPoint1()
{
    return point1;
}

const double *
Line::GetPoint2() const
{
    return point2;
}

double *
Line::GetPoint2()
{
    return point2;
}

const std::string &
Line::GetDesignator() const
{
    return designator;
}

std::string &
Line::GetDesignator()
{
    return designator;
}

const ColorAttribute &
Line::GetColor() const
{
    return color;
}

ColorAttribute &
Line::GetColor()
{
    return color;
}

int
Line::GetLineStyle() const
{
    return lineStyle;
}

int
Line::GetLineWidth() const
{
    return lineWidth;
}

bool
Line::GetInteractive() const
{
    return interactive;
}

bool
Line::GetReflineLabels() const
{
    return reflineLabels;
}

const std::string &
Line::GetVarName() const
{
    return varName;
}

std::string &
Line::GetVarName()
{
    return varName;
}

bool
Line::GetSamplingOn() const
{
    return samplingOn;
}

int
Line::GetNumSamples() const
{
    return numSamples;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Line::SelectPoint1()
{
    Select(ID_point1, (void *)point1, 3);
}

void
Line::SelectPoint2()
{
    Select(ID_point2, (void *)point2, 3);
}

void
Line::SelectDesignator()
{
    Select(ID_designator, (void *)&designator);
}

void
Line::SelectColor()
{
    Select(ID_color, (void *)&color);
}

void
Line::SelectVarName()
{
    Select(ID_varName, (void *)&varName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Line::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Line::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_point1:        return "point1";
    case ID_point2:        return "point2";
    case ID_designator:    return "designator";
    case ID_color:         return "color";
    case ID_lineStyle:     return "lineStyle";
    case ID_lineWidth:     return "lineWidth";
    case ID_interactive:   return "interactive";
    case ID_reflineLabels: return "reflineLabels";
    case ID_varName:       return "varName";
    case ID_samplingOn:    return "samplingOn";
    case ID_numSamples:    return "numSamples";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Line::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Line::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_point1:        return FieldType_doubleArray;
    case ID_point2:        return FieldType_doubleArray;
    case ID_designator:    return FieldType_string;
    case ID_color:         return FieldType_color;
    case ID_lineStyle:     return FieldType_linestyle;
    case ID_lineWidth:     return FieldType_linewidth;
    case ID_interactive:   return FieldType_bool;
    case ID_reflineLabels: return FieldType_bool;
    case ID_varName:       return FieldType_string;
    case ID_samplingOn:    return FieldType_bool;
    case ID_numSamples:    return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Line::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Line::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_point1:        return "doubleArray";
    case ID_point2:        return "doubleArray";
    case ID_designator:    return "string";
    case ID_color:         return "color";
    case ID_lineStyle:     return "linestyle";
    case ID_lineWidth:     return "linewidth";
    case ID_interactive:   return "bool";
    case ID_reflineLabels: return "bool";
    case ID_varName:       return "string";
    case ID_samplingOn:    return "bool";
    case ID_numSamples:    return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Line::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Line::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Line &obj = *((const Line*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_point1:
        {  // new scope
        // Compare the point1 arrays.
        bool point1_equal = true;
        for(int i = 0; i < 3 && point1_equal; ++i)
            point1_equal = (point1[i] == obj.point1[i]);

        retval = point1_equal;
        }
        break;
    case ID_point2:
        {  // new scope
        // Compare the point2 arrays.
        bool point2_equal = true;
        for(int i = 0; i < 3 && point2_equal; ++i)
            point2_equal = (point2[i] == obj.point2[i]);

        retval = point2_equal;
        }
        break;
    case ID_designator:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    case ID_color:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case ID_lineStyle:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_interactive:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    case ID_reflineLabels:
        {  // new scope
        retval = (reflineLabels == obj.reflineLabels);
        }
        break;
    case ID_varName:
        {  // new scope
        retval = (varName == obj.varName);
        }
        break;
    case ID_samplingOn:
        {  // new scope
        retval = (samplingOn == obj.samplingOn);
        }
        break;
    case ID_numSamples:
        {  // new scope
        retval = (numSamples == obj.numSamples);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method:  Line::SetPoint1
//
//  Purpose:
//    A method to set the xyz values of point1. 
//
//  Arguments:
//    x,y,z   the coordinate
//
//  Programmer:  Kathleen Bonnell 
//  Creation:    February 28, 2003 
//
// ****************************************************************************

void
Line::SetPoint1(double x, double y, double z) 
{
    point1[0] = x;
    point1[1] = y;
    point1[2] = z;
    Select(0, (void*)point1, 3);
}

// ****************************************************************************
//  Method:  Line::SetPoint2
//
//  Purpose:
//    A method to set the xyz values of point2. 
//
//  Arguments:
//    x,y,z   the coordinate
//
//  Programmer:  Kathleen Bonnell 
//  Creation:    February 28, 2003 
//
// ****************************************************************************

void
Line::SetPoint2(double x, double y, double z) 
{
    point2[0] = x;
    point2[1] = y;
    point2[2] = z;
    Select(1, (void*)point2, 3);
}

