#
#    Copyright 2015 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = aux
CONFIG  -= debug_and_release

CMAKE_TOOLCHAIN_FILE = $$clean_path($$OUT_PWD/../../toolchain.cmake)
if (exists($$CMAKE_TOOLCHAIN_FILE)) {
    CMAKE_ARGS      += "-DCMAKE_TOOLCHAIN_FILE=\"$$CMAKE_TOOLCHAIN_FILE\""
    doxygen.depends += $$CMAKE_TOOLCHAIN_FILE
}

doxygen.dir      = $$OUT_PWD/doxygen
doxygen.target   = $$doxygen.dir/doxygen-project-prefix/bin/doxygen
win32: doxygen.target = $$doxygen.dir/doxygen-project-prefix/bin/doxygen.exe
doxygen.commands = \
  mkdir -p "$$doxygen.dir" && \
  cd "$$doxygen.dir" && \
  if [ -d CMakeFiles -o -f CMakeCache.txt ] ; then rm -R CMake*; fi && \
  if [ -d doxygen-project-prefix ] ; then rm -R doxygen-project-prefix; fi && \
  cmake "$$PWD" $$CMAKE_ARGS && \
  $(MAKE) all VERBOSE=$(VERBOSE) && \
  $(MAKE) clean VERBOSE=$(VERBOSE)

QMAKE_EXTRA_TARGETS += doxygen
PRE_TARGETDEPS      += $$doxygen.target
QMAKE_CLEAN         += $$doxygen.target

DOXYGEN_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_"

write_file($$OUT_PWD/doxygen.pri, DOXYGEN_PRI)

OTHER_FILES += \
  CMakeLists.txt \
  LICENSE
