#ifndef _USR_H
#define _USR_H

/* usr.h -- public interface to libusr, the Userspace Routing Library.

   Copyright (C) 2007, 2008 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Interfaces */

struct if_entry {
    char        intf_name[INTF_NAME_LEN];   /* interface name */
    uint16_t    intf_type;                  /* interface type (r/o) */
    uint16_t    intf_flags;                 /* interface flags */
    uint32_t    intf_mtu;                   /* interface MTU */
    struct addr intf_addr;                  /* interface address */
    struct addr intf_dst_addr;              /* point-to-point dst */
    struct addr intf_link_addr;             /* link-layer address */
};

struct iftable {
    int nentries;

    struct if_entry *entries;
};

/* Neighbors (ARP) */

struct neightable {
    int nentries;

    struct neigh_entry *entries;
};

/* Routes */

enum rtabletype {
    RTABLE_IPV4,
    RTABLE_IPV6
};

struct rtable {
    enum rtabletype type;   /* Type of routing table */
    int nentries;

    struct route_entry *entries;
};

/* Interface tables */
extern struct iftable *iftable_new(int);
extern void iftable_destroy(struct iftable *);
extern void iftable_print(struct iftable *);

/* Neighbor (ARP) tables */
extern struct neightable *neightable_new(int);
extern void neightable_destroy(struct neightable *);
extern void neightable_print(struct neightable *);

/* Routing tables */
extern struct rtable *rtable_new(enum rtabletype, int);
extern void rtable_destroy(struct rtable *);
extern void rtable_print(struct rtable *);

extern int usr_init(void);
extern int usr_send(void);
extern int usr_outif(struct intf_entry *, struct addr *);

#endif /* _USR_H */
