/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <netdude/nd_debug.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_packet_iterator.h>
#include <netdude/nd_dialog.h>

#include <nd_udp.h>
#include <nd_udp_callbacks.h>


void    
nd_udp_sport_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct udphdr *udphdr;

  udphdr = (struct udphdr *) header;
  nd_proto_cb_data_init(&cb_data, nd_udp_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter UDP source port:"),
		   ND_BASE_DEC,
		   ntohs(udphdr->uh_sport), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void    
nd_udp_dport_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct udphdr *udphdr;

  udphdr = (struct udphdr *) header;
  nd_proto_cb_data_init(&cb_data, nd_udp_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter UDP destination port:"),
		   ND_BASE_DEC,
		   ntohs(udphdr->uh_dport), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void    
nd_udp_length_cb(ND_Packet   *packet,
		 guchar      *header,
		 guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct udphdr *udphdr;

  udphdr = (struct udphdr *) header;
  nd_proto_cb_data_init(&cb_data, nd_udp_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter UDP packet length:"),
		   ND_BASE_DEC,
		   ntohs(udphdr->uh_ulen), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void    
nd_udp_csum_cb(ND_Packet   *packet,
	       guchar      *header,
	       guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct udphdr *udphdr;

  udphdr = (struct udphdr *) header;
  nd_proto_cb_data_init(&cb_data, nd_udp_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter UDP checksum:"),
		   ND_BASE_HEX,
		   ntohs(udphdr->uh_sum), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void   
nd_udp_cksum_fix_cb(ND_Packet   *packet,
		    guchar      *header,
		    int          value)
{
  guint16               correct_sum;
  struct udphdr        *udphdr;
  ND_PacketIterator     pit;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      udphdr = (struct udphdr *) nd_packet_get_data(nd_pit_get(&pit), nd_udp_get(), 0);
      if (!udphdr)
	continue;
      
      if (!nd_udp_csum_correct(nd_pit_get(&pit), &correct_sum))
	{
	  udphdr->uh_sum = correct_sum;
	  nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
	}
    }

  return;
  TOUCH(header);
  TOUCH(value);
}

